/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.commands.change.ChangeStructCommand;
import org.eclipse.fordiac.ide.model.commands.change.UpdateFBTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.UpdateUntypedSubAppInterfaceCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.search.AbstractLiveSearchContext;
import org.eclipse.fordiac.ide.model.search.types.BlockTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public final class FBUpdater {
    private static Set<INamedElement> updatedElements;

    private FBUpdater() {
    }

    public static Set<INamedElement> getUpdatedElements() {
        return updatedElements;
    }

    public static Command createUpdateUntypedSubappInterfaceCommand(SubApp subApp, DataTypeEntry dataTypeEntry) {
        return new UpdateUntypedSubAppInterfaceCommand((FBNetworkElement)subApp, dataTypeEntry);
    }

    public static Command createUpdateUntypedSubappInterfaceCommand(Collection<SubApp> subApps, DataTypeEntry dataTypeEntry) {
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.addAll(subApps.stream().map(s -> FBUpdater.createUpdateUntypedSubappInterfaceCommand(s, dataTypeEntry)).toList());
        CompoundCommand cmd = new CompoundCommand();
        for (Command subCmd : commands) {
            cmd = cmd.chain(subCmd);
        }
        return cmd;
    }

    public static Command createStructManipulatorsUpdateCommand(List<StructManipulator> muxes, List<DataTypeEntry> dataTypeEntries) {
        ArrayList commands = new ArrayList();
        muxes.stream().forEach(mux -> {
            StructuredType structuredType = (StructuredType)((DataTypeEntry)dataTypeEntries.get(muxes.indexOf(mux))).getTypeEditable();
            EObject rootContainer = EcoreUtil.getRootContainer((EObject)EcoreUtil.getRootContainer((EObject)mux));
            if (rootContainer instanceof AutomationSystem) {
                AutomationSystem autoSys = (AutomationSystem)rootContainer;
                autoSys.getCommandStack().execute((Command)new ChangeStructCommand(mux, (DataType)structuredType));
            } else if (rootContainer instanceof SubAppType) {
                SubAppType subApp = (SubAppType)rootContainer;
                IFile file = subApp.getTypeEntry().getFile();
                IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor((IEditorInput)new FileEditorInput(file));
                if (editor != null) {
                    HandlerHelper.getCommandStack((IEditorPart)editor).execute((Command)new ChangeStructCommand(mux, (DataType)structuredType));
                } else {
                    commands.add(new ChangeStructCommand(mux, (DataType)structuredType));
                }
            }
        });
        CompoundCommand cmd = new CompoundCommand();
        for (Command subCmd : commands) {
            cmd = cmd.chain(subCmd);
        }
        return cmd;
    }

    public static List<FBNetworkElement> updateAllInstances(Set<TypeEntry> typeEntries) {
        BlockTypeInstanceSearch search = new BlockTypeInstanceSearch(typeEntries);
        List<FBNetworkElement> elements = search.performSearch().stream().filter(FBNetworkElement.class::isInstance).map(FBNetworkElement.class::cast).toList();
        elements.forEach(el -> {
            UpdateFBTypeCommand cmd = new UpdateFBTypeCommand(el, el.getTypeEntry());
            AbstractLiveSearchContext.executeAndSave((Command)cmd, (EObject)el, null);
        });
        return elements;
    }
}

