/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.move;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.model.IdentifierVerifier;
import org.eclipse.fordiac.ide.model.commands.change.ChangePackageNameCommand;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.typemanagement.refactoring.AbstractCommandChange;
import org.eclipse.fordiac.ide.typemanagement.wizards.Messages;
import org.eclipse.gef.commands.Command;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class MoveTypeChange
extends AbstractCommandChange<LibraryElement> {
    private final String newPackageName;
    private String oldPackageName;

    protected MoveTypeChange(String newPackageName, String name, URI uri) {
        super(name, uri, LibraryElement.class);
        this.newPackageName = newPackageName;
    }

    @Override
    public void initializeValidationData(LibraryElement element, IProgressMonitor pm) {
        this.oldPackageName = PackageNameHelper.getPackageName((LibraryElement)element);
    }

    @Override
    public RefactoringStatus isValid(LibraryElement element, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        Optional errorMessage;
        RefactoringStatus status = new RefactoringStatus();
        if (!Objects.equals(PackageNameHelper.getPackageName((LibraryElement)element), this.oldPackageName)) {
            status.addFatalError(Messages.MoveTypeToPackage_NameChanged);
        }
        if (this.oldPackageName.equals(this.newPackageName)) {
            status.addWarning(Messages.MoveTypeToPackage_PackageNameIsTheSame);
        }
        if ((errorMessage = IdentifierVerifier.verifyPackageName((String)this.newPackageName)).isPresent()) {
            status.addFatalError((String)errorMessage.get());
        }
        return status;
    }

    @Override
    protected Command createCommand(LibraryElement element) {
        return new ChangePackageNameCommand(element, this.newPackageName);
    }
}

