/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.connection.commands;

import java.util.Objects;
import org.eclipse.fordiac.ide.model.commands.change.ChangeStructCommand;
import org.eclipse.fordiac.ide.model.commands.create.FBCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.StructDataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.gef.commands.Command;

public class InsertStructManipulatorCommand
extends Command {
    private final StructuredType structType;
    private final boolean isMUX;
    private final IInterfaceElement port;
    private FBCreateCommand muxcreate;
    private ChangeStructCommand changeStruct;
    private StructDataConnectionCreateCommand createCon;

    public InsertStructManipulatorCommand(IInterfaceElement port) {
        this.port = Objects.requireNonNull(port);
        this.structType = (StructuredType)port.getType();
        this.isMUX = port.isIsInput();
    }

    public boolean canExecute() {
        return this.port.getType() instanceof StructuredType && this.port.getFBNetworkElement().getTypeLibrary().getFBTypeEntry(this.isMUX ? "STRUCT_MUX" : "STRUCT_DEMUX") != null;
    }

    public void execute() {
        FBNetworkElement element = this.port.getFBNetworkElement();
        Position pos = LibraryElementFactory.eINSTANCE.createPosition();
        pos.setX((double)((int)element.getPosition().getX()) + (this.isMUX ? -1000.0 : 1000.0));
        pos.setY((double)((int)element.getPosition().getY()));
        this.muxcreate = new FBCreateCommand(element.getTypeLibrary().getFBTypeEntry(this.isMUX ? "STRUCT_MUX" : "STRUCT_DEMUX"), element.getFbNetwork(), pos);
        this.muxcreate.execute();
        this.changeStruct = new ChangeStructCommand((StructManipulator)this.muxcreate.getElement(), (DataType)this.structType);
        this.changeStruct.execute();
        this.createCon = new StructDataConnectionCreateCommand(element.getFbNetwork());
        IInterfaceElement src = this.port;
        IInterfaceElement dest = this.isMUX ? (IInterfaceElement)this.changeStruct.getNewElement().getInterface().getOutputVars().getFirst() : (IInterfaceElement)this.changeStruct.getNewElement().getInterface().getInputVars().getFirst();
        this.createCon.setSource(src);
        this.createCon.setDestination(dest);
        this.createCon.execute();
    }

    public FBNetworkElement getNewElement() {
        return this.changeStruct.getNewElement();
    }

    public boolean canUndo() {
        return this.createCon.canUndo() && this.changeStruct.canUndo() && this.muxcreate.canUndo();
    }

    public void undo() {
        this.createCon.undo();
        this.changeStruct.undo();
        this.muxcreate.undo();
    }

    public boolean canRedo() {
        return this.muxcreate.canRedo() && this.changeStruct.canRedo() && this.createCon.canRedo();
    }

    public void redo() {
        this.muxcreate.redo();
        this.changeStruct.redo();
        this.createCon.redo();
    }
}

