/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.connection;

import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.change.UpdateFBTypeCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.AbstractCommandChange;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class SystemUpdateFBChange
extends AbstractCommandChange<AutomationSystem> {
    private final List<URI> updateURIs;

    protected SystemUpdateFBChange(URI elementURI, List<URI> list) {
        super(Objects.requireNonNull(elementURI).trimFileExtension().lastSegment() + Messages.SystemUpdateFBChange_Name, elementURI, AutomationSystem.class);
        this.updateURIs = Objects.requireNonNull(list);
    }

    @Override
    public void initializeValidationData(AutomationSystem element, IProgressMonitor pm) {
    }

    @Override
    public RefactoringStatus isValid(AutomationSystem element, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        this.updateURIs.forEach(uri -> {
            if (!uri.toPlatformString(true).equals(this.getElementURI().toPlatformString(true))) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)(String.valueOf(uri) + Messages.ConnectionsToStructRefactoring_FBNotInSystem + String.valueOf(this.getElementURI()))));
            }
        });
        return status;
    }

    @Override
    protected Command createCommand(AutomationSystem element) {
        CompoundCommand cmds = new CompoundCommand();
        this.updateURIs.forEach(uri -> {
            EObject eObject = element.eResource().getEObject(uri.fragment());
            if (eObject instanceof FBNetworkElement) {
                FBNetworkElement fbnelem = (FBNetworkElement)eObject;
                cmds.add((Command)new UpdateFBTypeCommand(fbnelem));
            }
        });
        return cmds.isEmpty() ? null : cmds;
    }
}

