/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDataTypeCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class FBInstanceMemberChange
extends Change {
    private final StructuredType affectedStruct;
    private final TypeEntry typeEntry;
    private final String oldName;
    private final CompoundCommand cmd = new CompoundCommand();

    public FBInstanceMemberChange(StructuredType affectedStruct, TypeEntry oldTypeEntry, String oldName) {
        this.affectedStruct = affectedStruct;
        this.typeEntry = oldTypeEntry;
        this.oldName = oldName;
    }

    public String getName() {
        return "Update Struct Members - " + this.affectedStruct.getName() + "." + this.affectedStruct.getTypeEntry().getFile().getFileExtension() + " - " + this.affectedStruct.getTypeEntry().getFile().getProject().getName();
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        StructuredType structuredTypeEditable = (StructuredType)this.affectedStruct.getTypeEntry().getTypeEditable();
        for (VarDeclaration varDeclaration : structuredTypeEditable.getMemberVariables()) {
            String typeName = varDeclaration.getTypeName();
            if (!typeName.equals(this.oldName)) continue;
            this.cmd.add((Command)ChangeDataTypeCommand.forDataType((IInterfaceElement)varDeclaration, (DataType)((DataType)this.typeEntry.getTypeEditable())));
        }
        this.cmd.execute();
        structuredTypeEditable.getTypeEntry().save((LibraryElement)structuredTypeEditable, pm);
        return null;
    }

    public Object getModifiedElement() {
        return null;
    }
}

