/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.datatypeeditor.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.datatypeeditor.Messages;
import org.eclipse.fordiac.ide.datatypeeditor.widgets.StructEditingComposite;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.typeeditor.ITypeEditorPage;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;

public class DataTypeEditorPage
extends EditorPart
implements ITypeEditorPage,
CommandStackEventListener {
    private CommandStack commandStack;
    private GraphicalAnnotationModel annotationModel;
    private StructEditingComposite structComposite;
    private ActionRegistry actionRegistry;
    private final List<String> selectionActions = new ArrayList<String>();
    private final List<String> stackActions = new ArrayList<String>();
    private final List<String> propertyActions = new ArrayList<String>();

    public void stackChanged(CommandStackEvent event) {
        this.updateActions(this.stackActions);
    }

    public void dispose() {
        this.getCommandStack().removeCommandStackEventListener((CommandStackEventListener)this);
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.getActionRegistry().dispose();
        if (this.structComposite != null) {
            this.structComposite.dispose();
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        site.getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.getCommandStack().addCommandStackEventListener((CommandStackEventListener)this);
        this.initializeActionRegistry();
        this.setActionHandlers(site);
        this.setPartName(Messages.DataTypeEditorPage_DataType);
        this.setTitleImage(FordiacImage.ICON_DATA_TYPE.getImage());
    }

    private void setActionHandlers(IEditorSite site) {
        ActionRegistry registry = this.getActionRegistry();
        IActionBars bars = site.getActionBars();
        String id = ActionFactory.UNDO.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.REDO.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.DELETE.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        bars.updateActionBars();
    }

    public boolean isDirty() {
        return this.getCommandStack().isDirty();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void createPartControl(Composite parent) {
        AnyDerivedType anyDerivedType = this.getType();
        if (anyDerivedType instanceof StructuredType) {
            StructuredType structType = (StructuredType)anyDerivedType;
            this.structComposite = new StructEditingComposite(parent, this.commandStack, structType, this.annotationModel, (IWorkbenchSite)this.getSite());
            this.getSite().setSelectionProvider(this.structComposite.getSelectionProvider());
        }
    }

    public void setFocus() {
        this.structComposite.setFocus();
    }

    private CommandStack getCommandStack() {
        return this.commandStack;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (((Object)((Object)this)).equals(this.getSite().getPage().getActiveEditor())) {
            this.updateActions(this.selectionActions);
        }
    }

    private void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        UndoAction action = new UndoAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getStackActions().add(action.getId());
        action = new RedoAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getStackActions().add(action.getId());
    }

    public <T> T getAdapter(Class<T> key) {
        if (key == ActionRegistry.class) {
            return key.cast(this.getActionRegistry());
        }
        if (key == CommandStack.class) {
            return key.cast(this.getCommandStack());
        }
        return (T)super.getAdapter(key);
    }

    private List<String> getStackActions() {
        return this.stackActions;
    }

    public AnyDerivedType getType() {
        return (AnyDerivedType)super.getType();
    }

    private void initializeActionRegistry() {
        this.createActions();
        this.updateActions(this.propertyActions);
        this.updateActions(this.stackActions);
    }

    private void updateActions(List<String> actionIds) {
        ActionRegistry registry = this.getActionRegistry();
        actionIds.forEach(id -> {
            IAction action = registry.getAction(id);
            if (action instanceof UpdateAction) {
                UpdateAction updateAction = (UpdateAction)action;
                updateAction.update();
            }
        });
    }

    private ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public void setInput(IEditorInput input) {
        this.checkEditorInput(input);
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        if (iWorkbenchPartSite instanceof MultiPageEditorSite) {
            MultiPageEditorSite mpes = (MultiPageEditorSite)iWorkbenchPartSite;
            this.annotationModel = (GraphicalAnnotationModel)mpes.getMultiPageEditor().getAdapter(GraphicalAnnotationModel.class);
        }
        if (this.structComposite != null) {
            this.structComposite.setAnnotationModel(this.annotationModel);
        }
        super.setInputWithNotify(input);
    }

    public void reloadType() {
        AnyDerivedType anyDerivedType = this.getType();
        if (anyDerivedType instanceof StructuredType) {
            StructuredType structType = (StructuredType)anyDerivedType;
            this.structComposite.setStructType(structType);
        }
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean outlineSelectionChanged(Object selectedElement) {
        return false;
    }

    public boolean isMarkerTarget(IMarker marker) {
        return false;
    }

    public void setCommonCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    public Object getSelectableObject() {
        return null;
    }
}

