/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.properties;

import org.eclipse.fordiac.ide.fbtypeeditor.ecc.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.contentprovider.AlgorithmsLabelProvider;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class AlgorithmList {
    private static final String A_NAME = "Name";
    private static final String A_LANGUAGE = "Language";
    private static final String A_COMMENT = "Comment";
    private TableViewer algorithmViewer;
    private final Composite composite;
    private BasicFBType type;

    public AlgorithmList(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory) {
        this.composite = widgetFactory.createComposite(parent);
        this.composite.setLayout((Layout)new GridLayout(2, false));
        GridData gridDataVersionViewer = new GridData(4, 4, true, true);
        this.composite.setLayoutData((Object)gridDataVersionViewer);
        this.createAlgorithmViewer(this.composite);
    }

    Composite getComposite() {
        return this.composite;
    }

    public void initialize(BasicFBType type) {
        this.type = type;
    }

    private void createAlgorithmViewer(Composite parent) {
        this.algorithmViewer = TableWidgetFactory.createTableViewer((Composite)parent);
        AlgorithmList.configureTableLayout(this.algorithmViewer);
        this.algorithmViewer.setColumnProperties(new String[]{A_NAME, A_LANGUAGE, A_COMMENT});
        this.algorithmViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.algorithmViewer.setLabelProvider((IBaseLabelProvider)new AlgorithmsLabelProvider());
    }

    private static void configureTableLayout(TableViewer tableViewer) {
        Table table = tableViewer.getTable();
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setText(Messages.AlgorithmList_ConfigureTableLayout_Name);
        TableColumn column2 = new TableColumn(table, 0x1000000);
        column2.setText(Messages.AlgorithmList_ConfigureTableLayout_Language);
        TableColumn column3 = new TableColumn(table, 16384);
        column3.setText(Messages.AlgorithmList_ConfigureTableLayout_Comment);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 50));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 20));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 50));
        table.setLayout((Layout)layout);
    }

    public void refresh() {
        if (this.type != null) {
            this.algorithmViewer.setInput((Object)this.type.getAlgorithm());
        }
    }

    public TableViewer getViewer() {
        return this.algorithmViewer;
    }

    public BasicFBType getType() {
        return this.type;
    }
}

