/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.policies;

import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.CreateECStateCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionAlgorithmEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionOutputEventEditPart;
import org.eclipse.fordiac.ide.gef.policies.ModifiedNonResizeableEditPolicy;
import org.eclipse.fordiac.ide.gef.utilities.RequestUtil;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.commands.change.SetPositionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class ECCXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new ModifiedNonResizeableEditPolicy(0, new Insets(4));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        Point moveDelta;
        Object object = child.getModel();
        if (!(object instanceof ECState)) return null;
        ECState state = (ECState)object;
        if (!RequestUtil.isMoveRequest((Request)request)) return null;
        if (constraint instanceof Rectangle) {
            Rectangle rect = (Rectangle)constraint;
            if (RequestUtil.isAlignmentRequest((Request)request)) {
                moveDelta = ECCXYLayoutEditPolicy.getMoveDelta(rect, state);
                return new SetPositionCommand((PositionableElement)state, moveDelta.x, moveDelta.y);
            }
        }
        moveDelta = request.getMoveDelta().getScaled(1.0 / this.getZoomManager().getZoom());
        return new SetPositionCommand((PositionableElement)state, moveDelta.x, moveDelta.y);
    }

    private static Point getMoveDelta(Rectangle rect, ECState state) {
        Position newPos = CoordinateConverter.INSTANCE.createPosFromScreenCoordinates(rect.x, rect.y);
        Position oldPos = state.getPosition();
        newPos.setX(Math.floor((newPos.getX() - oldPos.getX()) / 2.0));
        newPos.setY(Math.floor((newPos.getY() - oldPos.getY()) / 2.0));
        return newPos.toScreenPoint();
    }

    protected Command getAddCommand(Request generic) {
        if (generic instanceof ChangeBoundsRequest) {
            ChangeBoundsRequest request = (ChangeBoundsRequest)generic;
            for (Object editPart : request.getEditParts()) {
                if (!(editPart instanceof ECActionAlgorithmEditPart) && !(editPart instanceof ECActionOutputEventEditPart)) continue;
                return null;
            }
        }
        return super.getAddCommand(generic);
    }

    protected Command getCreateCommand(CreateRequest request) {
        Object object;
        if (request.getNewObjectType().equals(ECState.class) && (object = this.getHost().getModel()) instanceof ECC) {
            ECC ecc = (ECC)object;
            Point point = request.getLocation().getCopy();
            this.getHostFigure().translateToRelative((Translatable)point);
            return new CreateECStateCommand((ECState)request.getNewObject(), point, ecc);
        }
        return null;
    }

    protected ZoomManager getZoomManager() {
        return ((ScalableFreeformRootEditPart)this.getHost().getRoot()).getZoomManager();
    }
}

