; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX2-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX512
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq | FileCheck %s --check-prefixes=AVX512DQ
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX512BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512BW-FCP
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw | FileCheck %s --check-prefixes=AVX512DQ-BW
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512vl,+avx512dq,+avx512bw,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX512DQ-BW-FCP

; These patterns are produced by LoopVectorizer for interleaved stores.

define void @store_i64_stride6_vf2(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride6_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps (%rdi), %xmm0
; SSE-NEXT:    movaps (%rsi), %xmm1
; SSE-NEXT:    movaps (%rdx), %xmm2
; SSE-NEXT:    movaps (%rcx), %xmm3
; SSE-NEXT:    movaps (%r8), %xmm4
; SSE-NEXT:    movaps (%r9), %xmm5
; SSE-NEXT:    movaps %xmm0, %xmm6
; SSE-NEXT:    movlhps {{.*#+}} xmm6 = xmm6[0],xmm1[0]
; SSE-NEXT:    movaps %xmm2, %xmm7
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm3[1]
; SSE-NEXT:    movaps %xmm4, %xmm8
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm5[1]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm5[0]
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSE-NEXT:    movaps %xmm2, 16(%rax)
; SSE-NEXT:    movaps %xmm4, 32(%rax)
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps %xmm8, 80(%rax)
; SSE-NEXT:    movaps %xmm7, 64(%rax)
; SSE-NEXT:    movaps %xmm6, (%rax)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i64_stride6_vf2:
; AVX:       # %bb.0:
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    vmovaps (%rdi), %xmm0
; AVX-NEXT:    vmovaps (%rsi), %xmm1
; AVX-NEXT:    vmovaps (%rdx), %xmm2
; AVX-NEXT:    vmovaps (%rcx), %xmm3
; AVX-NEXT:    vmovaps (%r8), %xmm4
; AVX-NEXT:    vmovaps (%r9), %xmm5
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm6
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm7
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm6 = ymm7[0],ymm6[0],ymm7[2],ymm6[2]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm5, %ymm1
; AVX-NEXT:    vinsertf128 $1, %xmm0, %ymm4, %ymm0
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[3],ymm1[3]
; AVX-NEXT:    vinsertf128 $1, %xmm5, %ymm3, %ymm1
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm2, %ymm2
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm2[1],ymm1[1],ymm2[3],ymm1[3]
; AVX-NEXT:    vmovaps %ymm1, 64(%rax)
; AVX-NEXT:    vmovapd %ymm0, 32(%rax)
; AVX-NEXT:    vmovaps %ymm6, (%rax)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i64_stride6_vf2:
; AVX2:       # %bb.0:
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-NEXT:    vmovaps (%rdx), %xmm1
; AVX2-NEXT:    vmovaps (%r8), %xmm2
; AVX2-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX2-NEXT:    vinsertf128 $1, (%rcx), %ymm1, %ymm1
; AVX2-NEXT:    vinsertf128 $1, (%r9), %ymm2, %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,2,1,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5],ymm0[6,7]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-NEXT:    vmovaps %ymm1, 64(%rax)
; AVX2-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-NEXT:    vmovaps %ymm3, (%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i64_stride6_vf2:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-FP-NEXT:    vmovaps (%rdx), %xmm1
; AVX2-FP-NEXT:    vmovaps (%r8), %xmm2
; AVX2-FP-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX2-FP-NEXT:    vinsertf128 $1, (%rcx), %ymm1, %ymm1
; AVX2-FP-NEXT:    vinsertf128 $1, (%r9), %ymm2, %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,2,1,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-FP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-FP-NEXT:    vmovaps %ymm1, 64(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm3, (%rax)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i64_stride6_vf2:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovaps (%rdx), %xmm1
; AVX2-FCP-NEXT:    vmovaps (%r8), %xmm2
; AVX2-FCP-NEXT:    vinsertf128 $1, (%rsi), %ymm0, %ymm0
; AVX2-FCP-NEXT:    vinsertf128 $1, (%rcx), %ymm1, %ymm1
; AVX2-FCP-NEXT:    vinsertf128 $1, (%r9), %ymm2, %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm3 = ymm3[0,2,1,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-FCP-NEXT:    vpermpd {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-FCP-NEXT:    vmovaps %ymm1, 64(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm3, (%rax)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i64_stride6_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512-NEXT:    vmovdqa (%r8), %xmm2
; AVX512-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512-NEXT:    vinserti32x4 $1, (%r9), %zmm2, %zmm2
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,2,4,6,8,10,1,3]
; AVX512-NEXT:    vpermi2q %zmm2, %zmm0, %zmm3
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm0 = [1,3,5,7]
; AVX512-NEXT:    vpermi2q %ymm2, %ymm1, %ymm0
; AVX512-NEXT:    vmovdqa %ymm0, 64(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm3, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i64_stride6_vf2:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512-FCP-NEXT:    vmovdqa (%r8), %xmm2
; AVX512-FCP-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512-FCP-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512-FCP-NEXT:    vinserti32x4 $1, (%r9), %zmm2, %zmm2
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,2,4,6,8,10,1,3]
; AVX512-FCP-NEXT:    vpermi2q %zmm2, %zmm0, %zmm3
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm0 = [1,3,5,7]
; AVX512-FCP-NEXT:    vpermi2q %ymm2, %ymm1, %ymm0
; AVX512-FCP-NEXT:    vmovdqa %ymm0, 64(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, (%rax)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i64_stride6_vf2:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-NEXT:    vmovdqa (%r8), %xmm2
; AVX512DQ-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512DQ-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-NEXT:    vinserti32x4 $1, (%r9), %zmm2, %zmm2
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,2,4,6,8,10,1,3]
; AVX512DQ-NEXT:    vpermi2q %zmm2, %zmm0, %zmm3
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm0 = [1,3,5,7]
; AVX512DQ-NEXT:    vpermi2q %ymm2, %ymm1, %ymm0
; AVX512DQ-NEXT:    vmovdqa %ymm0, 64(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, (%rax)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i64_stride6_vf2:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-FCP-NEXT:    vmovdqa (%r8), %xmm2
; AVX512DQ-FCP-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512DQ-FCP-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-FCP-NEXT:    vinserti32x4 $1, (%r9), %zmm2, %zmm2
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,2,4,6,8,10,1,3]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm2, %zmm0, %zmm3
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm0 = [1,3,5,7]
; AVX512DQ-FCP-NEXT:    vpermi2q %ymm2, %ymm1, %ymm0
; AVX512DQ-FCP-NEXT:    vmovdqa %ymm0, 64(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, (%rax)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i64_stride6_vf2:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512BW-NEXT:    vmovdqa (%r8), %xmm2
; AVX512BW-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512BW-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512BW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vinserti32x4 $1, (%r9), %zmm2, %zmm2
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,2,4,6,8,10,1,3]
; AVX512BW-NEXT:    vpermi2q %zmm2, %zmm0, %zmm3
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm0 = [1,3,5,7]
; AVX512BW-NEXT:    vpermi2q %ymm2, %ymm1, %ymm0
; AVX512BW-NEXT:    vmovdqa %ymm0, 64(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm3, (%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i64_stride6_vf2:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512BW-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512BW-FCP-NEXT:    vmovdqa (%r8), %xmm2
; AVX512BW-FCP-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512BW-FCP-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512BW-FCP-NEXT:    vinserti32x4 $1, (%r9), %zmm2, %zmm2
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,2,4,6,8,10,1,3]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm2, %zmm0, %zmm3
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm0 = [1,3,5,7]
; AVX512BW-FCP-NEXT:    vpermi2q %ymm2, %ymm1, %ymm0
; AVX512BW-FCP-NEXT:    vmovdqa %ymm0, 64(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, (%rax)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i64_stride6_vf2:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-BW-NEXT:    vmovdqa (%r8), %xmm2
; AVX512DQ-BW-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512DQ-BW-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-BW-NEXT:    vinserti32x4 $1, (%r9), %zmm2, %zmm2
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,2,4,6,8,10,1,3]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm2, %zmm0, %zmm3
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm0 = [1,3,5,7]
; AVX512DQ-BW-NEXT:    vpermi2q %ymm2, %ymm1, %ymm0
; AVX512DQ-BW-NEXT:    vmovdqa %ymm0, 64(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, (%rax)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i64_stride6_vf2:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdx), %xmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%r8), %xmm2
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, (%rcx), %ymm1, %ymm1
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, (%rsi), %ymm0, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vinserti32x4 $1, (%r9), %zmm2, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,2,4,6,8,10,1,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm2, %zmm0, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm0 = [1,3,5,7]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %ymm2, %ymm1, %ymm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa %ymm0, 64(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, (%rax)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <2 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <2 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <2 x i64>, ptr %in.vecptr2, align 64
  %in.vec3 = load <2 x i64>, ptr %in.vecptr3, align 64
  %in.vec4 = load <2 x i64>, ptr %in.vecptr4, align 64
  %in.vec5 = load <2 x i64>, ptr %in.vecptr5, align 64
  %1 = shufflevector <2 x i64> %in.vec0, <2 x i64> %in.vec1, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %2 = shufflevector <2 x i64> %in.vec2, <2 x i64> %in.vec3, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = shufflevector <2 x i64> %in.vec4, <2 x i64> %in.vec5, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %4 = shufflevector <4 x i64> %1, <4 x i64> %2, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %5 = shufflevector <4 x i64> %3, <4 x i64> poison, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <8 x i64> %4, <8 x i64> %5, <12 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11>
  %interleaved.vec = shufflevector <12 x i64> %6, <12 x i64> poison, <12 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11>
  store <12 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride6_vf4(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride6_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps (%rdi), %xmm2
; SSE-NEXT:    movaps 16(%rdi), %xmm1
; SSE-NEXT:    movaps (%rsi), %xmm5
; SSE-NEXT:    movaps 16(%rsi), %xmm6
; SSE-NEXT:    movaps (%rdx), %xmm0
; SSE-NEXT:    movaps 16(%rdx), %xmm4
; SSE-NEXT:    movaps (%rcx), %xmm7
; SSE-NEXT:    movaps 16(%rcx), %xmm8
; SSE-NEXT:    movaps (%r8), %xmm9
; SSE-NEXT:    movaps 16(%r8), %xmm10
; SSE-NEXT:    movaps (%r9), %xmm11
; SSE-NEXT:    movaps 16(%r9), %xmm12
; SSE-NEXT:    movaps %xmm1, %xmm3
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm6[1]
; SSE-NEXT:    movaps %xmm10, %xmm13
; SSE-NEXT:    movlhps {{.*#+}} xmm13 = xmm13[0],xmm12[0]
; SSE-NEXT:    movaps %xmm9, %xmm14
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm11[1]
; SSE-NEXT:    movaps %xmm0, %xmm15
; SSE-NEXT:    unpckhpd {{.*#+}} xmm15 = xmm15[1],xmm7[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm7[0]
; SSE-NEXT:    movaps %xmm2, %xmm7
; SSE-NEXT:    movlhps {{.*#+}} xmm7 = xmm7[0],xmm5[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm10 = xmm10[1],xmm12[1]
; SSE-NEXT:    movaps %xmm4, %xmm12
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm8[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm8[0]
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm6[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm5[1]
; SSE-NEXT:    movlhps {{.*#+}} xmm9 = xmm9[0],xmm11[0]
; SSE-NEXT:    movaps %xmm9, 32(%rax)
; SSE-NEXT:    movaps %xmm2, 48(%rax)
; SSE-NEXT:    movaps %xmm1, 96(%rax)
; SSE-NEXT:    movaps %xmm4, 112(%rax)
; SSE-NEXT:    movaps %xmm12, 160(%rax)
; SSE-NEXT:    movaps %xmm10, 176(%rax)
; SSE-NEXT:    movaps %xmm7, (%rax)
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps %xmm15, 64(%rax)
; SSE-NEXT:    movaps %xmm14, 80(%rax)
; SSE-NEXT:    movaps %xmm13, 128(%rax)
; SSE-NEXT:    movaps %xmm3, 144(%rax)
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i64_stride6_vf4:
; AVX:       # %bb.0:
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    vmovapd (%rdi), %ymm0
; AVX-NEXT:    vmovapd (%rsi), %ymm1
; AVX-NEXT:    vmovaps (%rdx), %ymm2
; AVX-NEXT:    vmovapd (%r8), %ymm3
; AVX-NEXT:    vmovapd (%r9), %ymm4
; AVX-NEXT:    vmovddup {{.*#+}} xmm5 = mem[0,0]
; AVX-NEXT:    vmovaps (%rsi), %xmm6
; AVX-NEXT:    vmovaps (%rdi), %xmm7
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm8 = xmm7[1],xmm6[1]
; AVX-NEXT:    vinsertf128 $1, %xmm8, %ymm0, %ymm8
; AVX-NEXT:    vblendpd {{.*#+}} ymm8 = ymm3[0,1],ymm8[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm5 = ymm8[0],ymm5[1],ymm8[2,3]
; AVX-NEXT:    vmovaps (%rcx), %xmm8
; AVX-NEXT:    vmovaps (%rdx), %xmm9
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm10 = xmm9[1],xmm8[1]
; AVX-NEXT:    vinsertf128 $1, (%r9), %ymm10, %ymm11
; AVX-NEXT:    vbroadcastsd 8(%r8), %ymm12
; AVX-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3],ymm12[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1],ymm11[2,3],ymm10[4,5],ymm11[6,7]
; AVX-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm2[0],mem[0],ymm2[2],mem[2]
; AVX-NEXT:    vmovaps 16(%rdi), %xmm11
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm11 = xmm11[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm11[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm4[2,3],ymm1[2,3]
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm3[2,3],ymm0[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm11[0],ymm0[2],ymm11[3]
; AVX-NEXT:    vmovapd 16(%rdx), %xmm1
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],mem[1]
; AVX-NEXT:    vbroadcastsd 24(%r8), %ymm3
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0,1,2],ymm4[3]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm7[0],xmm6[0]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm4 = xmm9[0],xmm8[0]
; AVX-NEXT:    vmovaps %xmm4, 16(%rax)
; AVX-NEXT:    vmovaps %xmm3, (%rax)
; AVX-NEXT:    vmovapd %ymm0, 128(%rax)
; AVX-NEXT:    vmovaps %ymm2, 96(%rax)
; AVX-NEXT:    vmovaps %ymm10, 64(%rax)
; AVX-NEXT:    vmovapd %ymm5, 32(%rax)
; AVX-NEXT:    vmovapd %ymm1, 160(%rax)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i64_stride6_vf4:
; AVX2:       # %bb.0:
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-NEXT:    vmovaps (%rcx), %ymm3
; AVX2-NEXT:    vmovaps (%r8), %ymm4
; AVX2-NEXT:    vmovaps (%r9), %xmm5
; AVX2-NEXT:    vmovddup {{.*#+}} xmm6 = xmm5[0,0]
; AVX2-NEXT:    vmovaps (%rsi), %xmm7
; AVX2-NEXT:    vmovaps (%rdi), %xmm8
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm9 = xmm8[1],xmm7[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm4[0,1],ymm9[0,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm9[0,1],ymm6[2,3],ymm9[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX2-NEXT:    vmovaps (%rcx), %xmm9
; AVX2-NEXT:    vmovaps (%rdx), %xmm10
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm11 = xmm10[1],xmm9[1]
; AVX2-NEXT:    vbroadcastsd 8(%r8), %ymm12
; AVX2-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm12[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm11[0,1,2,3,4,5],ymm5[6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm9, %ymm7, %ymm7
; AVX2-NEXT:    vinsertf128 $1, %xmm10, %ymm8, %ymm8
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm8[0],ymm7[0],ymm8[2],ymm7[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm8 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm9 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm9[2,3],ymm8[2,3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-NEXT:    vbroadcastsd 24(%r8), %ymm3
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],ymm3[2,3]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm4[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 16(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovaps %ymm8, 96(%rax)
; AVX2-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-NEXT:    vmovaps %ymm7, (%rax)
; AVX2-NEXT:    vmovaps %ymm2, 160(%rax)
; AVX2-NEXT:    vmovaps %ymm5, 64(%rax)
; AVX2-NEXT:    vmovaps %ymm6, 32(%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i64_stride6_vf4:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FP-NEXT:    vmovaps (%rcx), %ymm3
; AVX2-FP-NEXT:    vmovaps (%r8), %ymm4
; AVX2-FP-NEXT:    vmovaps (%r9), %xmm5
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm6 = xmm5[0,0]
; AVX2-FP-NEXT:    vmovaps (%rsi), %xmm7
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm8
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm9 = xmm8[1],xmm7[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm4[0,1],ymm9[0,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm9[0,1],ymm6[2,3],ymm9[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX2-FP-NEXT:    vmovaps (%rcx), %xmm9
; AVX2-FP-NEXT:    vmovaps (%rdx), %xmm10
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm11 = xmm10[1],xmm9[1]
; AVX2-FP-NEXT:    vbroadcastsd 8(%r8), %ymm12
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm12[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm11[0,1,2,3,4,5],ymm5[6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm9, %ymm7, %ymm7
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm10, %ymm8, %ymm8
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm8[0],ymm7[0],ymm8[2],ymm7[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm8 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm9 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm9[2,3],ymm8[2,3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FP-NEXT:    vbroadcastsd 24(%r8), %ymm3
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],ymm3[2,3]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm4[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 16(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps %ymm8, 96(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm7, (%rax)
; AVX2-FP-NEXT:    vmovaps %ymm2, 160(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm5, 64(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm6, 32(%rax)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i64_stride6_vf4:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FCP-NEXT:    vmovaps (%rcx), %ymm3
; AVX2-FCP-NEXT:    vmovaps (%r8), %ymm4
; AVX2-FCP-NEXT:    vmovaps (%r9), %xmm5
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm6 = xmm5[0,0]
; AVX2-FCP-NEXT:    vmovaps (%rsi), %xmm7
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm8
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm9 = xmm8[1],xmm7[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm4[0,1],ymm9[0,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm9[0,1],ymm6[2,3],ymm9[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm5
; AVX2-FCP-NEXT:    vmovaps (%rcx), %xmm9
; AVX2-FCP-NEXT:    vmovaps (%rdx), %xmm10
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm11 = xmm10[1],xmm9[1]
; AVX2-FCP-NEXT:    vbroadcastsd 8(%r8), %ymm12
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3],ymm12[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm11[0,1,2,3,4,5],ymm5[6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm9, %ymm7, %ymm7
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm10, %ymm8, %ymm8
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm8[0],ymm7[0],ymm8[2],ymm7[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm8 = ymm2[0],ymm3[0],ymm2[2],ymm3[2]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm9 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm9[2,3],ymm8[2,3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX2-FCP-NEXT:    vbroadcastsd 24(%r8), %ymm3
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],ymm3[2,3]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm4[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 16(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps %ymm8, 96(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm7, (%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm2, 160(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm5, 64(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm6, 32(%rax)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i64_stride6_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512-NEXT:    vmovdqa (%r8), %ymm2
; AVX512-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512-NEXT:    vinserti64x4 $1, (%r9), %zmm2, %zmm2
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,4,8,12,0,0,1,5]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,1,2,3,8,12,6,7]
; AVX512-NEXT:    vpermi2q %zmm2, %zmm3, %zmm4
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [1,5,0,0,10,14,2,6]
; AVX512-NEXT:    vpermi2q %zmm0, %zmm1, %zmm3
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,9,13,4,5,6,7]
; AVX512-NEXT:    vpermi2q %zmm2, %zmm3, %zmm5
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [11,15,3,7,11,15,3,7]
; AVX512-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [10,14,2,3,4,5,11,15]
; AVX512-NEXT:    vpermi2q %zmm2, %zmm3, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm0, 128(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm5, 64(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm4, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i64_stride6_vf4:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512-FCP-NEXT:    vmovdqa (%r8), %ymm2
; AVX512-FCP-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512-FCP-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512-FCP-NEXT:    vinserti64x4 $1, (%r9), %zmm2, %zmm2
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,4,8,12,0,0,1,5]
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,1,2,3,8,12,6,7]
; AVX512-FCP-NEXT:    vpermi2q %zmm2, %zmm3, %zmm4
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [1,5,0,0,10,14,2,6]
; AVX512-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm3
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,9,13,4,5,6,7]
; AVX512-FCP-NEXT:    vpermi2q %zmm2, %zmm3, %zmm5
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [11,15,3,7,11,15,3,7]
; AVX512-FCP-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [10,14,2,3,4,5,11,15]
; AVX512-FCP-NEXT:    vpermi2q %zmm2, %zmm3, %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, 128(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, 64(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, (%rax)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i64_stride6_vf4:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512DQ-NEXT:    vmovdqa (%r8), %ymm2
; AVX512DQ-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512DQ-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512DQ-NEXT:    vinserti64x4 $1, (%r9), %zmm2, %zmm2
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,4,8,12,0,0,1,5]
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,1,2,3,8,12,6,7]
; AVX512DQ-NEXT:    vpermi2q %zmm2, %zmm3, %zmm4
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [1,5,0,0,10,14,2,6]
; AVX512DQ-NEXT:    vpermi2q %zmm0, %zmm1, %zmm3
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,9,13,4,5,6,7]
; AVX512DQ-NEXT:    vpermi2q %zmm2, %zmm3, %zmm5
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [11,15,3,7,11,15,3,7]
; AVX512DQ-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [10,14,2,3,4,5,11,15]
; AVX512DQ-NEXT:    vpermi2q %zmm2, %zmm3, %zmm0
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, 128(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, 64(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, (%rax)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i64_stride6_vf4:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512DQ-FCP-NEXT:    vmovdqa (%r8), %ymm2
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512DQ-FCP-NEXT:    vinserti64x4 $1, (%r9), %zmm2, %zmm2
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,4,8,12,0,0,1,5]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,1,2,3,8,12,6,7]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm2, %zmm3, %zmm4
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [1,5,0,0,10,14,2,6]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm3
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,9,13,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm2, %zmm3, %zmm5
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [11,15,3,7,11,15,3,7]
; AVX512DQ-FCP-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [10,14,2,3,4,5,11,15]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm2, %zmm3, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, 128(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, 64(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, (%rax)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i64_stride6_vf4:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512BW-NEXT:    vmovdqa (%r8), %ymm2
; AVX512BW-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512BW-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512BW-NEXT:    vinserti64x4 $1, (%r9), %zmm2, %zmm2
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,4,8,12,0,0,1,5]
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,1,2,3,8,12,6,7]
; AVX512BW-NEXT:    vpermi2q %zmm2, %zmm3, %zmm4
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [1,5,0,0,10,14,2,6]
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm1, %zmm3
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,9,13,4,5,6,7]
; AVX512BW-NEXT:    vpermi2q %zmm2, %zmm3, %zmm5
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [11,15,3,7,11,15,3,7]
; AVX512BW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [10,14,2,3,4,5,11,15]
; AVX512BW-NEXT:    vpermi2q %zmm2, %zmm3, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 128(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, 64(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, (%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i64_stride6_vf4:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-FCP-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512BW-FCP-NEXT:    vmovdqa (%r8), %ymm2
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512BW-FCP-NEXT:    vinserti64x4 $1, (%r9), %zmm2, %zmm2
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,4,8,12,0,0,1,5]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,1,2,3,8,12,6,7]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm2, %zmm3, %zmm4
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [1,5,0,0,10,14,2,6]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm3
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,9,13,4,5,6,7]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm2, %zmm3, %zmm5
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [11,15,3,7,11,15,3,7]
; AVX512BW-FCP-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [10,14,2,3,4,5,11,15]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm2, %zmm3, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, 128(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, 64(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, (%rax)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i64_stride6_vf4:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-BW-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512DQ-BW-NEXT:    vmovdqa (%r8), %ymm2
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512DQ-BW-NEXT:    vinserti64x4 $1, (%r9), %zmm2, %zmm2
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,4,8,12,0,0,1,5]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,1,2,3,8,12,6,7]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm2, %zmm3, %zmm4
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [1,5,0,0,10,14,2,6]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm0, %zmm1, %zmm3
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,9,13,4,5,6,7]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm2, %zmm3, %zmm5
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [11,15,3,7,11,15,3,7]
; AVX512DQ-BW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [10,14,2,3,4,5,11,15]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm2, %zmm3, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, 128(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, 64(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, (%rax)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i64_stride6_vf4:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdx), %ymm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%r8), %ymm2
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, (%rsi), %zmm0, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, (%rcx), %zmm1, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $1, (%r9), %zmm2, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,4,8,12,0,0,1,5]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm4 = [0,1,2,3,8,12,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm2, %zmm3, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [1,5,0,0,10,14,2,6]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,9,13,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm2, %zmm3, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [11,15,3,7,11,15,3,7]
; AVX512DQ-BW-FCP-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm0, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [10,14,2,3,4,5,11,15]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm2, %zmm3, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, 128(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, 64(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, (%rax)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <4 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <4 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <4 x i64>, ptr %in.vecptr2, align 64
  %in.vec3 = load <4 x i64>, ptr %in.vecptr3, align 64
  %in.vec4 = load <4 x i64>, ptr %in.vecptr4, align 64
  %in.vec5 = load <4 x i64>, ptr %in.vecptr5, align 64
  %1 = shufflevector <4 x i64> %in.vec0, <4 x i64> %in.vec1, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %2 = shufflevector <4 x i64> %in.vec2, <4 x i64> %in.vec3, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %3 = shufflevector <4 x i64> %in.vec4, <4 x i64> %in.vec5, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %4 = shufflevector <8 x i64> %1, <8 x i64> %2, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %5 = shufflevector <8 x i64> %3, <8 x i64> poison, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <16 x i64> %4, <16 x i64> %5, <24 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23>
  %interleaved.vec = shufflevector <24 x i64> %6, <24 x i64> poison, <24 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 3, i32 7, i32 11, i32 15, i32 19, i32 23>
  store <24 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride6_vf8(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride6_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $24, %rsp
; SSE-NEXT:    movaps (%rdi), %xmm2
; SSE-NEXT:    movaps 16(%rdi), %xmm3
; SSE-NEXT:    movaps 32(%rdi), %xmm5
; SSE-NEXT:    movaps (%rsi), %xmm1
; SSE-NEXT:    movaps 16(%rsi), %xmm12
; SSE-NEXT:    movaps 32(%rsi), %xmm14
; SSE-NEXT:    movaps (%rdx), %xmm4
; SSE-NEXT:    movaps 16(%rdx), %xmm6
; SSE-NEXT:    movaps 32(%rdx), %xmm0
; SSE-NEXT:    movaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps (%rcx), %xmm10
; SSE-NEXT:    movaps 16(%rcx), %xmm13
; SSE-NEXT:    movaps (%r8), %xmm7
; SSE-NEXT:    movaps 16(%r8), %xmm9
; SSE-NEXT:    movaps (%r9), %xmm11
; SSE-NEXT:    movaps 16(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm1[0]
; SSE-NEXT:    movaps %xmm8, (%rsp) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm4, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm10[0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm10[1]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm7, %xmm10
; SSE-NEXT:    movlhps {{.*#+}} xmm10 = xmm10[0],xmm11[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm11[1]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm3, %xmm11
; SSE-NEXT:    movlhps {{.*#+}} xmm11 = xmm11[0],xmm12[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm12[1]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm6, %xmm12
; SSE-NEXT:    movlhps {{.*#+}} xmm12 = xmm12[0],xmm13[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm13[1]
; SSE-NEXT:    movaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm13
; SSE-NEXT:    movlhps {{.*#+}} xmm13 = xmm13[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm0[1]
; SSE-NEXT:    movaps %xmm5, %xmm15
; SSE-NEXT:    movlhps {{.*#+}} xmm15 = xmm15[0],xmm14[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm14[1]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%rcx), %xmm0
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm1 # 16-byte Reload
; SSE-NEXT:    movaps %xmm1, %xmm14
; SSE-NEXT:    movlhps {{.*#+}} xmm14 = xmm14[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%r8), %xmm5
; SSE-NEXT:    movaps 32(%r9), %xmm0
; SSE-NEXT:    movaps %xmm5, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm0[1]
; SSE-NEXT:    movaps 48(%rdi), %xmm6
; SSE-NEXT:    movaps 48(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm6, %xmm7
; SSE-NEXT:    movlhps {{.*#+}} xmm7 = xmm7[0],xmm1[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm1[1]
; SSE-NEXT:    movaps 48(%rdx), %xmm1
; SSE-NEXT:    movaps 48(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 48(%r8), %xmm0
; SSE-NEXT:    movaps 48(%r9), %xmm3
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm3[1]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps %xmm0, 368(%rax)
; SSE-NEXT:    movaps %xmm1, 352(%rax)
; SSE-NEXT:    movaps %xmm6, 336(%rax)
; SSE-NEXT:    movaps %xmm2, 320(%rax)
; SSE-NEXT:    movaps %xmm4, 304(%rax)
; SSE-NEXT:    movaps %xmm7, 288(%rax)
; SSE-NEXT:    movaps %xmm5, 272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rax)
; SSE-NEXT:    movaps %xmm8, 224(%rax)
; SSE-NEXT:    movaps %xmm14, 208(%rax)
; SSE-NEXT:    movaps %xmm15, 192(%rax)
; SSE-NEXT:    movaps %xmm9, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps %xmm13, 128(%rax)
; SSE-NEXT:    movaps %xmm12, 112(%rax)
; SSE-NEXT:    movaps %xmm11, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps %xmm10, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    addq $24, %rsp
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i64_stride6_vf8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovapd 32(%rdi), %ymm13
; AVX-NEXT:    vmovapd (%r8), %ymm11
; AVX-NEXT:    vmovapd 32(%r8), %ymm14
; AVX-NEXT:    vmovddup {{.*#+}} xmm0 = mem[0,0]
; AVX-NEXT:    vmovaps (%rsi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 32(%rsi), %xmm4
; AVX-NEXT:    vmovaps (%rdi), %xmm3
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm3[1],xmm1[1]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX-NEXT:    vblendpd {{.*#+}} ymm2 = ymm11[0,1],ymm2[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm2[0],ymm0[1],ymm2[2,3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps (%rcx), %xmm5
; AVX-NEXT:    vmovaps 32(%rcx), %xmm6
; AVX-NEXT:    vmovaps 32(%rdx), %xmm8
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm8[1],xmm6[1]
; AVX-NEXT:    vinsertf128 $1, 32(%r9), %ymm2, %ymm7
; AVX-NEXT:    vbroadcastsd 40(%r8), %ymm9
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm9[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm7[2,3],ymm2[4,5],ymm7[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps (%rdx), %xmm9
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm7 = xmm9[1],xmm5[1]
; AVX-NEXT:    vinsertf128 $1, (%r9), %ymm7, %ymm10
; AVX-NEXT:    vbroadcastsd 8(%r8), %ymm12
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],ymm12[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm10[2,3],ymm7[4,5],ymm10[6,7]
; AVX-NEXT:    vmovddup {{.*#+}} xmm10 = mem[0,0]
; AVX-NEXT:    vmovaps 32(%rdi), %xmm12
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm15 = xmm12[1],xmm4[1]
; AVX-NEXT:    vinsertf128 $1, %xmm15, %ymm0, %ymm15
; AVX-NEXT:    vblendpd {{.*#+}} ymm15 = ymm14[0,1],ymm15[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm10 = ymm15[0],ymm10[1],ymm15[2,3]
; AVX-NEXT:    vmovapd 32(%rsi), %ymm15
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm13 = ymm13[1],ymm15[1],ymm13[3],ymm15[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm13 = ymm14[2,3],ymm13[2,3]
; AVX-NEXT:    vmovapd 32(%r9), %ymm0
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm0[2,3],ymm15[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm13 = ymm13[0],ymm14[0],ymm13[2],ymm14[3]
; AVX-NEXT:    vmovapd (%rdi), %ymm14
; AVX-NEXT:    vmovapd (%rsi), %ymm15
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm14 = ymm14[1],ymm15[1],ymm14[3],ymm15[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm11[2,3],ymm14[2,3]
; AVX-NEXT:    vmovapd (%r9), %ymm1
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm1[2,3],ymm15[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm14 = ymm11[0],ymm14[0],ymm11[2],ymm14[3]
; AVX-NEXT:    vmovapd 48(%rdx), %xmm11
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm11 = xmm11[1],mem[1]
; AVX-NEXT:    vbroadcastsd 56(%r8), %ymm15
; AVX-NEXT:    vblendpd {{.*#+}} ymm11 = ymm11[0,1],ymm15[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm11 = ymm11[0,1,2],ymm0[3]
; AVX-NEXT:    vmovaps 48(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 48(%rcx), %ymm15
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm15[6,7]
; AVX-NEXT:    vmovapd 16(%rdx), %xmm15
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm15 = xmm15[1],mem[1]
; AVX-NEXT:    vbroadcastsd 24(%r8), %ymm2
; AVX-NEXT:    vblendpd {{.*#+}} ymm2 = ymm15[0,1],ymm2[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm2[0,1,2],ymm1[3]
; AVX-NEXT:    vmovaps 16(%rdi), %xmm2
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 16(%rcx), %ymm15
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm15[6,7]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm4 = xmm12[0],xmm4[0]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm6 = xmm8[0],xmm6[0]
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm3, %xmm3 # 16-byte Folded Reload
; AVX-NEXT:    # xmm3 = xmm3[0],mem[0]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm5 = xmm9[0],xmm5[0]
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    vmovaps %xmm5, 16(%rax)
; AVX-NEXT:    vmovaps %xmm3, (%rax)
; AVX-NEXT:    vmovaps %xmm6, 208(%rax)
; AVX-NEXT:    vmovaps %xmm4, 192(%rax)
; AVX-NEXT:    vmovapd %ymm14, 128(%rax)
; AVX-NEXT:    vmovapd %ymm13, 320(%rax)
; AVX-NEXT:    vmovaps %ymm2, 96(%rax)
; AVX-NEXT:    vmovapd %ymm1, 160(%rax)
; AVX-NEXT:    vmovapd %ymm10, 224(%rax)
; AVX-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX-NEXT:    vmovaps %ymm7, 64(%rax)
; AVX-NEXT:    vmovapd %ymm11, 352(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i64_stride6_vf8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovaps (%r8), %ymm1
; AVX2-NEXT:    vmovaps 32(%r8), %ymm4
; AVX2-NEXT:    vmovaps (%r9), %xmm3
; AVX2-NEXT:    vmovaps 32(%r9), %xmm5
; AVX2-NEXT:    vmovddup {{.*#+}} xmm0 = xmm3[0,0]
; AVX2-NEXT:    vmovaps (%rsi), %xmm9
; AVX2-NEXT:    vmovaps 32(%rsi), %xmm7
; AVX2-NEXT:    vmovaps (%rdi), %xmm6
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm6[1],xmm9[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[0,1],ymm2[0,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm2
; AVX2-NEXT:    vmovaps (%rcx), %xmm11
; AVX2-NEXT:    vmovaps 32(%rcx), %xmm12
; AVX2-NEXT:    vmovaps (%rdx), %xmm13
; AVX2-NEXT:    vmovaps 32(%rdx), %xmm10
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm8 = xmm10[1],xmm12[1]
; AVX2-NEXT:    vbroadcastsd 40(%r8), %ymm14
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm14[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm8[0,1,2,3,4,5],ymm2[6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm8 = xmm13[1],xmm11[1]
; AVX2-NEXT:    vbroadcastsd 8(%r8), %ymm14
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm14[4,5,6,7]
; AVX2-NEXT:    vmovaps 32(%rdi), %xmm14
; AVX2-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm8[0,1,2,3,4,5],ymm3[6,7]
; AVX2-NEXT:    vmovddup {{.*#+}} xmm5 = xmm5[0,0]
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm8 = xmm14[1],xmm7[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm4[0,1],ymm8[0,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm8[0,1],ymm5[2,3],ymm8[4,5,6,7]
; AVX2-NEXT:    vmovaps (%rdi), %ymm8
; AVX2-NEXT:    vinsertf128 $1, %xmm11, %ymm9, %ymm9
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm11
; AVX2-NEXT:    vinsertf128 $1, %xmm13, %ymm6, %ymm6
; AVX2-NEXT:    vmovaps (%rsi), %ymm13
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm6 = ymm6[0],ymm9[0],ymm6[2],ymm9[2]
; AVX2-NEXT:    vmovaps 32(%rsi), %ymm9
; AVX2-NEXT:    vinsertf128 $1, %xmm12, %ymm7, %ymm7
; AVX2-NEXT:    vmovaps 32(%rdx), %ymm12
; AVX2-NEXT:    vinsertf128 $1, %xmm10, %ymm14, %ymm10
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm10[0],ymm7[0],ymm10[2],ymm7[2]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm10 = ymm12[1],mem[1],ymm12[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 56(%r8), %ymm14
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm10[2,3],ymm14[2,3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm14 = ymm11[1],ymm9[1],ymm11[3],ymm9[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],ymm14[2,3]
; AVX2-NEXT:    vbroadcastsd 48(%r9), %ymm14
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm14[2,3],ymm4[4,5,6,7]
; AVX2-NEXT:    vmovaps (%rdx), %ymm14
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm9 = ymm11[0],ymm9[0],ymm11[2],ymm9[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm9[2,3],ymm12[2,3]
; AVX2-NEXT:    vbroadcastsd 48(%rcx), %ymm11
; AVX2-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],ymm11[6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm11 = ymm14[1],mem[1],ymm14[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 24(%r8), %ymm12
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm11[2,3],ymm12[2,3]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm12 = ymm8[1],ymm13[1],ymm8[3],ymm13[3]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3],ymm12[2,3]
; AVX2-NEXT:    vbroadcastsd 16(%r9), %ymm12
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm12[2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm8 = ymm8[0],ymm13[0],ymm8[2],ymm13[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm8[2,3],ymm14[2,3]
; AVX2-NEXT:    vbroadcastsd 16(%rcx), %ymm12
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],ymm12[6,7]
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vmovaps %ymm8, 96(%rax)
; AVX2-NEXT:    vmovaps %ymm1, 128(%rax)
; AVX2-NEXT:    vmovaps %ymm7, 192(%rax)
; AVX2-NEXT:    vmovaps %ymm11, 160(%rax)
; AVX2-NEXT:    vmovaps %ymm9, 288(%rax)
; AVX2-NEXT:    vmovaps %ymm4, 320(%rax)
; AVX2-NEXT:    vmovaps %ymm10, 352(%rax)
; AVX2-NEXT:    vmovaps %ymm6, (%rax)
; AVX2-NEXT:    vmovaps %ymm5, 224(%rax)
; AVX2-NEXT:    vmovaps %ymm3, 64(%rax)
; AVX2-NEXT:    vmovaps %ymm2, 256(%rax)
; AVX2-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i64_stride6_vf8:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    vmovaps (%r8), %ymm1
; AVX2-FP-NEXT:    vmovaps 32(%r8), %ymm4
; AVX2-FP-NEXT:    vmovaps (%r9), %xmm3
; AVX2-FP-NEXT:    vmovaps 32(%r9), %xmm5
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm0 = xmm3[0,0]
; AVX2-FP-NEXT:    vmovaps (%rsi), %xmm9
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %xmm7
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm6
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm6[1],xmm9[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[0,1],ymm2[0,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm2
; AVX2-FP-NEXT:    vmovaps (%rcx), %xmm11
; AVX2-FP-NEXT:    vmovaps 32(%rcx), %xmm12
; AVX2-FP-NEXT:    vmovaps (%rdx), %xmm13
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %xmm10
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm8 = xmm10[1],xmm12[1]
; AVX2-FP-NEXT:    vbroadcastsd 40(%r8), %ymm14
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm14[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm8[0,1,2,3,4,5],ymm2[6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm8 = xmm13[1],xmm11[1]
; AVX2-FP-NEXT:    vbroadcastsd 8(%r8), %ymm14
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm14[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %xmm14
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm8[0,1,2,3,4,5],ymm3[6,7]
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm5 = xmm5[0,0]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm8 = xmm14[1],xmm7[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm4[0,1],ymm8[0,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm8[0,1],ymm5[2,3],ymm8[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm8
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm11, %ymm9, %ymm9
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm11
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm13, %ymm6, %ymm6
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm13
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm6 = ymm6[0],ymm9[0],ymm6[2],ymm9[2]
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %ymm9
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm12, %ymm7, %ymm7
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %ymm12
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm10, %ymm14, %ymm10
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm10[0],ymm7[0],ymm10[2],ymm7[2]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm10 = ymm12[1],mem[1],ymm12[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 56(%r8), %ymm14
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm10[2,3],ymm14[2,3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm14 = ymm11[1],ymm9[1],ymm11[3],ymm9[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],ymm14[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 48(%r9), %ymm14
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm14[2,3],ymm4[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps (%rdx), %ymm14
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm9 = ymm11[0],ymm9[0],ymm11[2],ymm9[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm9[2,3],ymm12[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 48(%rcx), %ymm11
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],ymm11[6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm11 = ymm14[1],mem[1],ymm14[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 24(%r8), %ymm12
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm11[2,3],ymm12[2,3]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm12 = ymm8[1],ymm13[1],ymm8[3],ymm13[3]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3],ymm12[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 16(%r9), %ymm12
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm12[2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm8 = ymm8[0],ymm13[0],ymm8[2],ymm13[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm8[2,3],ymm14[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 16(%rcx), %ymm12
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],ymm12[6,7]
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps %ymm8, 96(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm1, 128(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm7, 192(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm11, 160(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm9, 288(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm4, 320(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm10, 352(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm6, (%rax)
; AVX2-FP-NEXT:    vmovaps %ymm5, 224(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm3, 64(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm2, 256(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i64_stride6_vf8:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    vmovaps (%r8), %ymm1
; AVX2-FCP-NEXT:    vmovaps 32(%r8), %ymm4
; AVX2-FCP-NEXT:    vmovaps (%r9), %xmm3
; AVX2-FCP-NEXT:    vmovaps 32(%r9), %xmm5
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm0 = xmm3[0,0]
; AVX2-FCP-NEXT:    vmovaps (%rsi), %xmm9
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %xmm7
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm6
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm6[1],xmm9[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm1[0,1],ymm2[0,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm2[0,1],ymm0[2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm5, %ymm0, %ymm2
; AVX2-FCP-NEXT:    vmovaps (%rcx), %xmm11
; AVX2-FCP-NEXT:    vmovaps 32(%rcx), %xmm12
; AVX2-FCP-NEXT:    vmovaps (%rdx), %xmm13
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %xmm10
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm8 = xmm10[1],xmm12[1]
; AVX2-FCP-NEXT:    vbroadcastsd 40(%r8), %ymm14
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm14[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm8[0,1,2,3,4,5],ymm2[6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm8 = xmm13[1],xmm11[1]
; AVX2-FCP-NEXT:    vbroadcastsd 8(%r8), %ymm14
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3],ymm14[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %xmm14
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm8[0,1,2,3,4,5],ymm3[6,7]
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm5 = xmm5[0,0]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm8 = xmm14[1],xmm7[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm4[0,1],ymm8[0,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm8[0,1],ymm5[2,3],ymm8[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm8
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm11, %ymm9, %ymm9
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm11
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm13, %ymm6, %ymm6
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm13
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm6 = ymm6[0],ymm9[0],ymm6[2],ymm9[2]
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %ymm9
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm12, %ymm7, %ymm7
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %ymm12
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm10, %ymm14, %ymm10
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm10[0],ymm7[0],ymm10[2],ymm7[2]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm10 = ymm12[1],mem[1],ymm12[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 56(%r8), %ymm14
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm10[2,3],ymm14[2,3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm14 = ymm11[1],ymm9[1],ymm11[3],ymm9[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],ymm14[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 48(%r9), %ymm14
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1],ymm14[2,3],ymm4[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps (%rdx), %ymm14
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm9 = ymm11[0],ymm9[0],ymm11[2],ymm9[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm9[2,3],ymm12[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 48(%rcx), %ymm11
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],ymm11[6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm11 = ymm14[1],mem[1],ymm14[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 24(%r8), %ymm12
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm11[2,3],ymm12[2,3]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm12 = ymm8[1],ymm13[1],ymm8[3],ymm13[3]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3],ymm12[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 16(%r9), %ymm12
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm12[2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm8 = ymm8[0],ymm13[0],ymm8[2],ymm13[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm8[2,3],ymm14[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 16(%rcx), %ymm12
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],ymm12[6,7]
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps %ymm8, 96(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm1, 128(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm7, 192(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm11, 160(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm9, 288(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm4, 320(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm10, 352(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm6, (%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm5, 224(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm3, 64(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm2, 256(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i64_stride6_vf8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm5
; AVX512-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [4,12,5,13,4,12,5,13]
; AVX512-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2q %zmm3, %zmm2, %zmm0
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [0,0,4,12]
; AVX512-NEXT:    vpermi2q %zmm6, %zmm5, %zmm4
; AVX512-NEXT:    movb $12, %r10b
; AVX512-NEXT:    kmovw %r10d, %k1
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512-NEXT:    movb $16, %r10b
; AVX512-NEXT:    kmovw %r10d, %k2
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k2}
; AVX512-NEXT:    vmovdqa64 (%r9), %zmm4
; AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} zmm7 = [2,10,2,10,2,10,2,10]
; AVX512-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2q %zmm3, %zmm2, %zmm7
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [1,9,2,10,1,9,2,10]
; AVX512-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2q %zmm6, %zmm5, %zmm8
; AVX512-NEXT:    movb $48, %r9b
; AVX512-NEXT:    kmovw %r9d, %k2
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k2}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,9,0,4,5,6,7]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm8, %zmm9
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,9,4,5,6,7]
; AVX512-NEXT:    vpermi2q %zmm4, %zmm9, %zmm7
; AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [6,14,6,14,6,14,6,14]
; AVX512-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [5,13,6,14,5,13,6,14]
; AVX512-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2q %zmm6, %zmm5, %zmm9
; AVX512-NEXT:    vmovdqa64 %zmm8, %zmm9 {%k2}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,1,13,0,4,5,6,7]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm9, %zmm8
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,2,13,4,5,6,7]
; AVX512-NEXT:    vpermi2q %zmm4, %zmm8, %zmm9
; AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [7,15,7,15,7,15,7,15]
; AVX512-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [3,11,3,11,3,11,3,11]
; AVX512-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2q %zmm6, %zmm5, %zmm10
; AVX512-NEXT:    vpermt2q %zmm6, %zmm8, %zmm5
; AVX512-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512-NEXT:    vshufi64x2 {{.*#+}} zmm5 = zmm8[0,1,2,3],zmm5[4,5,6,7]
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [14,0,2,3,4,5,15,0]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm5, %zmm6
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,14,2,3,4,5,6,15]
; AVX512-NEXT:    vpermi2q %zmm4, %zmm6, %zmm5
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,8,1,9,0,8,1,9]
; AVX512-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermi2q %zmm3, %zmm2, %zmm6
; AVX512-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm6 {%k1}
; AVX512-NEXT:    vinserti32x4 $2, (%r8), %zmm6, %zmm2
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,1,2,3,4,8,6,7]
; AVX512-NEXT:    vpermi2q %zmm4, %zmm2, %zmm3
; AVX512-NEXT:    vmovdqa (%rdi), %ymm2
; AVX512-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512-NEXT:    vinserti64x4 $0, %ymm2, %zmm10, %zmm2
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [10,0,2,3,4,5,11,0]
; AVX512-NEXT:    vpermi2q %zmm1, %zmm2, %zmm6
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,10,2,3,4,5,6,11]
; AVX512-NEXT:    vpermi2q %zmm4, %zmm6, %zmm1
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,12,6,7]
; AVX512-NEXT:    vpermi2q %zmm4, %zmm0, %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm2, 192(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm1, 128(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm5, 320(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm9, 256(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm7, 64(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm3, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i64_stride6_vf8:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 (%rdx), %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [4,12,5,13,4,12,5,13]
; AVX512-FCP-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm0
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [0,0,4,12]
; AVX512-FCP-NEXT:    vpermi2q %zmm6, %zmm5, %zmm4
; AVX512-FCP-NEXT:    movb $12, %r10b
; AVX512-FCP-NEXT:    kmovw %r10d, %k1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512-FCP-NEXT:    movb $16, %r10b
; AVX512-FCP-NEXT:    kmovw %r10d, %k2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k2}
; AVX512-FCP-NEXT:    vmovdqa64 (%r9), %zmm4
; AVX512-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm7 = [2,10,2,10,2,10,2,10]
; AVX512-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm7
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [1,9,2,10,1,9,2,10]
; AVX512-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermi2q %zmm6, %zmm5, %zmm8
; AVX512-FCP-NEXT:    movb $48, %r9b
; AVX512-FCP-NEXT:    kmovw %r9d, %k2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,9,0,4,5,6,7]
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm8, %zmm9
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,9,4,5,6,7]
; AVX512-FCP-NEXT:    vpermi2q %zmm4, %zmm9, %zmm7
; AVX512-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [6,14,6,14,6,14,6,14]
; AVX512-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [5,13,6,14,5,13,6,14]
; AVX512-FCP-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermi2q %zmm6, %zmm5, %zmm9
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, %zmm9 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,1,13,0,4,5,6,7]
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm9, %zmm8
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,2,13,4,5,6,7]
; AVX512-FCP-NEXT:    vpermi2q %zmm4, %zmm8, %zmm9
; AVX512-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [7,15,7,15,7,15,7,15]
; AVX512-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [3,11,3,11,3,11,3,11]
; AVX512-FCP-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermi2q %zmm6, %zmm5, %zmm10
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm8, %zmm5
; AVX512-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm5 = zmm8[0,1,2,3],zmm5[4,5,6,7]
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [14,0,2,3,4,5,15,0]
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm5, %zmm6
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,14,2,3,4,5,6,15]
; AVX512-FCP-NEXT:    vpermi2q %zmm4, %zmm6, %zmm5
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,8,1,9,0,8,1,9]
; AVX512-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm6
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm6 {%k1}
; AVX512-FCP-NEXT:    vinserti32x4 $2, (%r8), %zmm6, %zmm2
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,1,2,3,4,8,6,7]
; AVX512-FCP-NEXT:    vpermi2q %zmm4, %zmm2, %zmm3
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %ymm2
; AVX512-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm10, %zmm2
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [10,0,2,3,4,5,11,0]
; AVX512-FCP-NEXT:    vpermi2q %zmm1, %zmm2, %zmm6
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,10,2,3,4,5,6,11]
; AVX512-FCP-NEXT:    vpermi2q %zmm4, %zmm6, %zmm1
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,12,6,7]
; AVX512-FCP-NEXT:    vpermi2q %zmm4, %zmm0, %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, 192(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, 128(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, 320(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, 256(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, 64(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, (%rax)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i64_stride6_vf8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512DQ-NEXT:    vmovdqa64 (%rdx), %zmm5
; AVX512DQ-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512DQ-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [4,12,5,13,4,12,5,13]
; AVX512DQ-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermi2q %zmm3, %zmm2, %zmm0
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [0,0,4,12]
; AVX512DQ-NEXT:    vpermi2q %zmm6, %zmm5, %zmm4
; AVX512DQ-NEXT:    movb $12, %r10b
; AVX512DQ-NEXT:    kmovw %r10d, %k1
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512DQ-NEXT:    movb $16, %r10b
; AVX512DQ-NEXT:    kmovw %r10d, %k2
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k2}
; AVX512DQ-NEXT:    vmovdqa64 (%r9), %zmm4
; AVX512DQ-NEXT:    vbroadcasti32x4 {{.*#+}} zmm7 = [2,10,2,10,2,10,2,10]
; AVX512DQ-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermi2q %zmm3, %zmm2, %zmm7
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [1,9,2,10,1,9,2,10]
; AVX512DQ-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermi2q %zmm6, %zmm5, %zmm8
; AVX512DQ-NEXT:    movb $48, %r9b
; AVX512DQ-NEXT:    kmovw %r9d, %k2
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k2}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,9,0,4,5,6,7]
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm8, %zmm9
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,9,4,5,6,7]
; AVX512DQ-NEXT:    vpermi2q %zmm4, %zmm9, %zmm7
; AVX512DQ-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [6,14,6,14,6,14,6,14]
; AVX512DQ-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [5,13,6,14,5,13,6,14]
; AVX512DQ-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermi2q %zmm6, %zmm5, %zmm9
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, %zmm9 {%k2}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,1,13,0,4,5,6,7]
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm9, %zmm8
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,2,13,4,5,6,7]
; AVX512DQ-NEXT:    vpermi2q %zmm4, %zmm8, %zmm9
; AVX512DQ-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [7,15,7,15,7,15,7,15]
; AVX512DQ-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [3,11,3,11,3,11,3,11]
; AVX512DQ-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermi2q %zmm6, %zmm5, %zmm10
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm8, %zmm5
; AVX512DQ-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512DQ-NEXT:    vshufi64x2 {{.*#+}} zmm5 = zmm8[0,1,2,3],zmm5[4,5,6,7]
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [14,0,2,3,4,5,15,0]
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm5, %zmm6
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,14,2,3,4,5,6,15]
; AVX512DQ-NEXT:    vpermi2q %zmm4, %zmm6, %zmm5
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,8,1,9,0,8,1,9]
; AVX512DQ-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermi2q %zmm3, %zmm2, %zmm6
; AVX512DQ-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm6 {%k1}
; AVX512DQ-NEXT:    vinserti32x4 $2, (%r8), %zmm6, %zmm2
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,1,2,3,4,8,6,7]
; AVX512DQ-NEXT:    vpermi2q %zmm4, %zmm2, %zmm3
; AVX512DQ-NEXT:    vmovdqa (%rdi), %ymm2
; AVX512DQ-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm2, %zmm10, %zmm2
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [10,0,2,3,4,5,11,0]
; AVX512DQ-NEXT:    vpermi2q %zmm1, %zmm2, %zmm6
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,10,2,3,4,5,6,11]
; AVX512DQ-NEXT:    vpermi2q %zmm4, %zmm6, %zmm1
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,12,6,7]
; AVX512DQ-NEXT:    vpermi2q %zmm4, %zmm0, %zmm2
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, 192(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, 128(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, 320(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, 256(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, 64(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, (%rax)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i64_stride6_vf8:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdx), %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [4,12,5,13,4,12,5,13]
; AVX512DQ-FCP-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm0
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [0,0,4,12]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm6, %zmm5, %zmm4
; AVX512DQ-FCP-NEXT:    movb $12, %r10b
; AVX512DQ-FCP-NEXT:    kmovw %r10d, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512DQ-FCP-NEXT:    movb $16, %r10b
; AVX512DQ-FCP-NEXT:    kmovw %r10d, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%r9), %zmm4
; AVX512DQ-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm7 = [2,10,2,10,2,10,2,10]
; AVX512DQ-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm7
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [1,9,2,10,1,9,2,10]
; AVX512DQ-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm6, %zmm5, %zmm8
; AVX512DQ-FCP-NEXT:    movb $48, %r9b
; AVX512DQ-FCP-NEXT:    kmovw %r9d, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,9,0,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm8, %zmm9
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,9,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm4, %zmm9, %zmm7
; AVX512DQ-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [6,14,6,14,6,14,6,14]
; AVX512DQ-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [5,13,6,14,5,13,6,14]
; AVX512DQ-FCP-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm6, %zmm5, %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, %zmm9 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,1,13,0,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm9, %zmm8
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,2,13,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm4, %zmm8, %zmm9
; AVX512DQ-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [7,15,7,15,7,15,7,15]
; AVX512DQ-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [3,11,3,11,3,11,3,11]
; AVX512DQ-FCP-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm6, %zmm5, %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm8, %zmm5
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512DQ-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm5 = zmm8[0,1,2,3],zmm5[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [14,0,2,3,4,5,15,0]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm5, %zmm6
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,14,2,3,4,5,6,15]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm4, %zmm6, %zmm5
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,8,1,9,0,8,1,9]
; AVX512DQ-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512DQ-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm6 {%k1}
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, (%r8), %zmm6, %zmm2
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,1,2,3,4,8,6,7]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm4, %zmm2, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %ymm2
; AVX512DQ-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm10, %zmm2
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [10,0,2,3,4,5,11,0]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm1, %zmm2, %zmm6
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,10,2,3,4,5,6,11]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm4, %zmm6, %zmm1
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,12,6,7]
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm4, %zmm0, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, 192(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, 128(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, 320(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, 256(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, 64(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, (%rax)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i64_stride6_vf8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm5
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512BW-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [4,12,5,13,4,12,5,13]
; AVX512BW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm0
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [0,0,4,12]
; AVX512BW-NEXT:    vpermi2q %zmm6, %zmm5, %zmm4
; AVX512BW-NEXT:    movb $12, %r10b
; AVX512BW-NEXT:    kmovd %r10d, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512BW-NEXT:    movb $16, %r10b
; AVX512BW-NEXT:    kmovd %r10d, %k2
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k2}
; AVX512BW-NEXT:    vmovdqa64 (%r9), %zmm4
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm7 = [2,10,2,10,2,10,2,10]
; AVX512BW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm7
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [1,9,2,10,1,9,2,10]
; AVX512BW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm6, %zmm5, %zmm8
; AVX512BW-NEXT:    movb $48, %r9b
; AVX512BW-NEXT:    kmovd %r9d, %k2
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k2}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,9,0,4,5,6,7]
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm8, %zmm9
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,9,4,5,6,7]
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm9, %zmm7
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [6,14,6,14,6,14,6,14]
; AVX512BW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [5,13,6,14,5,13,6,14]
; AVX512BW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm6, %zmm5, %zmm9
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm9 {%k2}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,1,13,0,4,5,6,7]
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm9, %zmm8
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,2,13,4,5,6,7]
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm8, %zmm9
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [7,15,7,15,7,15,7,15]
; AVX512BW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [3,11,3,11,3,11,3,11]
; AVX512BW-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm6, %zmm5, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm8, %zmm5
; AVX512BW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm5 = zmm8[0,1,2,3],zmm5[4,5,6,7]
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [14,0,2,3,4,5,15,0]
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm5, %zmm6
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,14,2,3,4,5,6,15]
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm6, %zmm5
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,8,1,9,0,8,1,9]
; AVX512BW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm6
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm6 {%k1}
; AVX512BW-NEXT:    vinserti32x4 $2, (%r8), %zmm6, %zmm2
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,1,2,3,4,8,6,7]
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm2, %zmm3
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm2
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm10, %zmm2
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [10,0,2,3,4,5,11,0]
; AVX512BW-NEXT:    vpermi2q %zmm1, %zmm2, %zmm6
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,10,2,3,4,5,6,11]
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm6, %zmm1
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,12,6,7]
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm0, %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 192(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 128(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, 320(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm9, 256(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm7, 64(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm3, (%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i64_stride6_vf8:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [4,12,5,13,4,12,5,13]
; AVX512BW-FCP-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm0
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [0,0,4,12]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm6, %zmm5, %zmm4
; AVX512BW-FCP-NEXT:    movb $12, %r10b
; AVX512BW-FCP-NEXT:    kmovd %r10d, %k1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512BW-FCP-NEXT:    movb $16, %r10b
; AVX512BW-FCP-NEXT:    kmovd %r10d, %k2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k2}
; AVX512BW-FCP-NEXT:    vmovdqa64 (%r9), %zmm4
; AVX512BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm7 = [2,10,2,10,2,10,2,10]
; AVX512BW-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm7
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [1,9,2,10,1,9,2,10]
; AVX512BW-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm6, %zmm5, %zmm8
; AVX512BW-FCP-NEXT:    movb $48, %r9b
; AVX512BW-FCP-NEXT:    kmovd %r9d, %k2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,9,0,4,5,6,7]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm8, %zmm9
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,9,4,5,6,7]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm4, %zmm9, %zmm7
; AVX512BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [6,14,6,14,6,14,6,14]
; AVX512BW-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [5,13,6,14,5,13,6,14]
; AVX512BW-FCP-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm6, %zmm5, %zmm9
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm9 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,1,13,0,4,5,6,7]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm9, %zmm8
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,2,13,4,5,6,7]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm4, %zmm8, %zmm9
; AVX512BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [7,15,7,15,7,15,7,15]
; AVX512BW-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [3,11,3,11,3,11,3,11]
; AVX512BW-FCP-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm6, %zmm5, %zmm10
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm8, %zmm5
; AVX512BW-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm5 = zmm8[0,1,2,3],zmm5[4,5,6,7]
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [14,0,2,3,4,5,15,0]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm5, %zmm6
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,14,2,3,4,5,6,15]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm4, %zmm6, %zmm5
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,8,1,9,0,8,1,9]
; AVX512BW-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512BW-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm6 {%k1}
; AVX512BW-FCP-NEXT:    vinserti32x4 $2, (%r8), %zmm6, %zmm2
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,1,2,3,4,8,6,7]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm4, %zmm2, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %ymm2
; AVX512BW-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512BW-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm10, %zmm2
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [10,0,2,3,4,5,11,0]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm1, %zmm2, %zmm6
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,10,2,3,4,5,6,11]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm4, %zmm6, %zmm1
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,12,6,7]
; AVX512BW-FCP-NEXT:    vpermi2q %zmm4, %zmm0, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, 192(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, 128(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, 320(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, 256(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, 64(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, (%rax)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i64_stride6_vf8:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdx), %zmm5
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [4,12,5,13,4,12,5,13]
; AVX512DQ-BW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm0
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [0,0,4,12]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm6, %zmm5, %zmm4
; AVX512DQ-BW-NEXT:    movb $12, %r10b
; AVX512DQ-BW-NEXT:    kmovd %r10d, %k1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512DQ-BW-NEXT:    movb $16, %r10b
; AVX512DQ-BW-NEXT:    kmovd %r10d, %k2
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k2}
; AVX512DQ-BW-NEXT:    vmovdqa64 (%r9), %zmm4
; AVX512DQ-BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm7 = [2,10,2,10,2,10,2,10]
; AVX512DQ-BW-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm7
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [1,9,2,10,1,9,2,10]
; AVX512DQ-BW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm6, %zmm5, %zmm8
; AVX512DQ-BW-NEXT:    movb $48, %r9b
; AVX512DQ-BW-NEXT:    kmovd %r9d, %k2
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,9,0,4,5,6,7]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm8, %zmm9
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,9,4,5,6,7]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm4, %zmm9, %zmm7
; AVX512DQ-BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [6,14,6,14,6,14,6,14]
; AVX512DQ-BW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [5,13,6,14,5,13,6,14]
; AVX512DQ-BW-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm6, %zmm5, %zmm9
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, %zmm9 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,1,13,0,4,5,6,7]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm9, %zmm8
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,2,13,4,5,6,7]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm4, %zmm8, %zmm9
; AVX512DQ-BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [7,15,7,15,7,15,7,15]
; AVX512DQ-BW-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [3,11,3,11,3,11,3,11]
; AVX512DQ-BW-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm6, %zmm5, %zmm10
; AVX512DQ-BW-NEXT:    vpermt2q %zmm6, %zmm8, %zmm5
; AVX512DQ-BW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512DQ-BW-NEXT:    vshufi64x2 {{.*#+}} zmm5 = zmm8[0,1,2,3],zmm5[4,5,6,7]
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [14,0,2,3,4,5,15,0]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm5, %zmm6
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,14,2,3,4,5,6,15]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm4, %zmm6, %zmm5
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,8,1,9,0,8,1,9]
; AVX512DQ-BW-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm3, %zmm2, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512DQ-BW-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQ-BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm6 {%k1}
; AVX512DQ-BW-NEXT:    vinserti32x4 $2, (%r8), %zmm6, %zmm2
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,1,2,3,4,8,6,7]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm4, %zmm2, %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %ymm2
; AVX512DQ-BW-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512DQ-BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm10, %zmm2
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [10,0,2,3,4,5,11,0]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm1, %zmm2, %zmm6
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,10,2,3,4,5,6,11]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm4, %zmm6, %zmm1
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,12,6,7]
; AVX512DQ-BW-NEXT:    vpermi2q %zmm4, %zmm0, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, 192(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, 128(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, 320(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, 256(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, 64(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, (%rax)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i64_stride6_vf8:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%r8), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [4,12,5,13,4,12,5,13]
; AVX512DQ-BW-FCP-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm4 = [0,0,4,12]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm6, %zmm5, %zmm4
; AVX512DQ-BW-FCP-NEXT:    movb $12, %r10b
; AVX512DQ-BW-FCP-NEXT:    kmovd %r10d, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm0 {%k1}
; AVX512DQ-BW-FCP-NEXT:    movb $16, %r10b
; AVX512DQ-BW-FCP-NEXT:    kmovd %r10d, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%r9), %zmm4
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm7 = [2,10,2,10,2,10,2,10]
; AVX512DQ-BW-FCP-NEXT:    # zmm7 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm8 = [1,9,2,10,1,9,2,10]
; AVX512DQ-BW-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm6, %zmm5, %zmm8
; AVX512DQ-BW-FCP-NEXT:    movb $48, %r9b
; AVX512DQ-BW-FCP-NEXT:    kmovd %r9d, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm8 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,9,0,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm8, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm7 = [0,1,2,9,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm4, %zmm9, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [6,14,6,14,6,14,6,14]
; AVX512DQ-BW-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm9 = [5,13,6,14,5,13,6,14]
; AVX512DQ-BW-FCP-NEXT:    # zmm9 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm6, %zmm5, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm9 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm8 = [0,1,13,0,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm9, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm9 = [0,1,2,13,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm4, %zmm8, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm8 = [7,15,7,15,7,15,7,15]
; AVX512DQ-BW-FCP-NEXT:    # zmm8 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm10 = [3,11,3,11,3,11,3,11]
; AVX512DQ-BW-FCP-NEXT:    # zmm10 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm6, %zmm5, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm6, %zmm8, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm5 = zmm8[0,1,2,3],zmm5[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [14,0,2,3,4,5,15,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm5, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,14,2,3,4,5,6,15]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm4, %zmm6, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm6 = [0,8,1,9,0,8,1,9]
; AVX512DQ-BW-FCP-NEXT:    # zmm6 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm3, %zmm2, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdx), %xmm2
; AVX512DQ-BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm2
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm6 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vinserti32x4 $2, (%r8), %zmm6, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm3 = [0,1,2,3,4,8,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm4, %zmm2, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %ymm2
; AVX512DQ-BW-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm10, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [10,0,2,3,4,5,11,0]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm1, %zmm2, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,10,2,3,4,5,6,11]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm4, %zmm6, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm2 = [0,1,2,3,4,12,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm4, %zmm0, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, 192(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, 128(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, 320(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, 256(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, 64(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, (%rax)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <8 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <8 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <8 x i64>, ptr %in.vecptr2, align 64
  %in.vec3 = load <8 x i64>, ptr %in.vecptr3, align 64
  %in.vec4 = load <8 x i64>, ptr %in.vecptr4, align 64
  %in.vec5 = load <8 x i64>, ptr %in.vecptr5, align 64
  %1 = shufflevector <8 x i64> %in.vec0, <8 x i64> %in.vec1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %2 = shufflevector <8 x i64> %in.vec2, <8 x i64> %in.vec3, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %3 = shufflevector <8 x i64> %in.vec4, <8 x i64> %in.vec5, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %4 = shufflevector <16 x i64> %1, <16 x i64> %2, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %5 = shufflevector <16 x i64> %3, <16 x i64> poison, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <32 x i64> %4, <32 x i64> %5, <48 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47>
  %interleaved.vec = shufflevector <48 x i64> %6, <48 x i64> poison, <48 x i32> <i32 0, i32 8, i32 16, i32 24, i32 32, i32 40, i32 1, i32 9, i32 17, i32 25, i32 33, i32 41, i32 2, i32 10, i32 18, i32 26, i32 34, i32 42, i32 3, i32 11, i32 19, i32 27, i32 35, i32 43, i32 4, i32 12, i32 20, i32 28, i32 36, i32 44, i32 5, i32 13, i32 21, i32 29, i32 37, i32 45, i32 6, i32 14, i32 22, i32 30, i32 38, i32 46, i32 7, i32 15, i32 23, i32 31, i32 39, i32 47>
  store <48 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride6_vf16(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride6_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $408, %rsp # imm = 0x198
; SSE-NEXT:    movaps (%rdi), %xmm7
; SSE-NEXT:    movaps 16(%rdi), %xmm8
; SSE-NEXT:    movaps 32(%rdi), %xmm9
; SSE-NEXT:    movaps (%rsi), %xmm3
; SSE-NEXT:    movaps 16(%rsi), %xmm1
; SSE-NEXT:    movaps 32(%rsi), %xmm0
; SSE-NEXT:    movaps (%rdx), %xmm10
; SSE-NEXT:    movaps 16(%rdx), %xmm11
; SSE-NEXT:    movaps 32(%rdx), %xmm12
; SSE-NEXT:    movaps (%rcx), %xmm5
; SSE-NEXT:    movaps 16(%rcx), %xmm2
; SSE-NEXT:    movaps (%r8), %xmm13
; SSE-NEXT:    movaps 16(%r8), %xmm15
; SSE-NEXT:    movaps (%r9), %xmm6
; SSE-NEXT:    movaps 16(%r9), %xmm4
; SSE-NEXT:    movaps %xmm7, %xmm14
; SSE-NEXT:    movlhps {{.*#+}} xmm14 = xmm14[0],xmm3[0]
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm3[1]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm10, %xmm3
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm5[0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm10 = xmm10[1],xmm5[1]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm13, %xmm5
; SSE-NEXT:    movlhps {{.*#+}} xmm5 = xmm5[0],xmm6[0]
; SSE-NEXT:    movaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm6[1]
; SSE-NEXT:    movaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm8, %xmm3
; SSE-NEXT:    movlhps {{.*#+}} xmm3 = xmm3[0],xmm1[0]
; SSE-NEXT:    movaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm1[1]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm11, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm2[1]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm15, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm4[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm15 = xmm15[1],xmm4[1]
; SSE-NEXT:    movaps %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm0[1]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm12, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm0[1]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%r8), %xmm2
; SSE-NEXT:    movaps 32(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%rdi), %xmm2
; SSE-NEXT:    movaps 48(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%rdx), %xmm2
; SSE-NEXT:    movaps 48(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%r8), %xmm2
; SSE-NEXT:    movaps 48(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdi), %xmm2
; SSE-NEXT:    movaps 64(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdx), %xmm2
; SSE-NEXT:    movaps 64(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%r8), %xmm2
; SSE-NEXT:    movaps 64(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rdi), %xmm15
; SSE-NEXT:    movaps 80(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm15, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm15 = xmm15[1],xmm0[1]
; SSE-NEXT:    movaps 80(%rdx), %xmm12
; SSE-NEXT:    movaps 80(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm12, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm0[1]
; SSE-NEXT:    movaps 80(%r8), %xmm14
; SSE-NEXT:    movaps 80(%r9), %xmm0
; SSE-NEXT:    movaps %xmm14, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm0[1]
; SSE-NEXT:    movaps 96(%rdi), %xmm9
; SSE-NEXT:    movaps 96(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm9, %xmm13
; SSE-NEXT:    movlhps {{.*#+}} xmm13 = xmm13[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm0[1]
; SSE-NEXT:    movaps 96(%rdx), %xmm10
; SSE-NEXT:    movaps 96(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm10, %xmm11
; SSE-NEXT:    movlhps {{.*#+}} xmm11 = xmm11[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm10 = xmm10[1],xmm0[1]
; SSE-NEXT:    movaps 96(%r8), %xmm5
; SSE-NEXT:    movaps 96(%r9), %xmm0
; SSE-NEXT:    movaps %xmm5, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm0[1]
; SSE-NEXT:    movaps 112(%rdi), %xmm6
; SSE-NEXT:    movaps 112(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm6, %xmm7
; SSE-NEXT:    movlhps {{.*#+}} xmm7 = xmm7[0],xmm1[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm1[1]
; SSE-NEXT:    movaps 112(%rdx), %xmm1
; SSE-NEXT:    movaps 112(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 112(%r8), %xmm0
; SSE-NEXT:    movaps 112(%r9), %xmm3
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm3[1]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps %xmm0, 752(%rax)
; SSE-NEXT:    movaps %xmm1, 736(%rax)
; SSE-NEXT:    movaps %xmm6, 720(%rax)
; SSE-NEXT:    movaps %xmm2, 704(%rax)
; SSE-NEXT:    movaps %xmm4, 688(%rax)
; SSE-NEXT:    movaps %xmm7, 672(%rax)
; SSE-NEXT:    movaps %xmm5, 656(%rax)
; SSE-NEXT:    movaps %xmm10, 640(%rax)
; SSE-NEXT:    movaps %xmm9, 624(%rax)
; SSE-NEXT:    movaps %xmm8, 608(%rax)
; SSE-NEXT:    movaps %xmm11, 592(%rax)
; SSE-NEXT:    movaps %xmm13, 576(%rax)
; SSE-NEXT:    movaps %xmm14, 560(%rax)
; SSE-NEXT:    movaps %xmm12, 544(%rax)
; SSE-NEXT:    movaps %xmm15, 528(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 512(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    addq $408, %rsp # imm = 0x198
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i64_stride6_vf16:
; AVX:       # %bb.0:
; AVX-NEXT:    subq $440, %rsp # imm = 0x1B8
; AVX-NEXT:    vmovapd (%r8), %ymm11
; AVX-NEXT:    vmovapd 32(%r8), %ymm0
; AVX-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX-NEXT:    vmovaps (%rsi), %xmm3
; AVX-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 32(%rsi), %xmm4
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 64(%rsi), %xmm5
; AVX-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps (%rdi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, (%rsp) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm2[1],xmm3[1]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX-NEXT:    vblendpd {{.*#+}} ymm2 = ymm11[0,1],ymm2[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3]
; AVX-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps (%rcx), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 32(%rcx), %xmm6
; AVX-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps (%rdx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vinsertf128 $1, (%r9), %ymm1, %ymm2
; AVX-NEXT:    vbroadcastsd 8(%r8), %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5],ymm2[6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX-NEXT:    vmovaps 32(%rdi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm2[1],xmm4[1]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX-NEXT:    vblendpd {{.*#+}} ymm2 = ymm0[0,1],ymm2[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm2[0],ymm1[1],ymm2[2,3]
; AVX-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 32(%rdx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm6[1]
; AVX-NEXT:    vbroadcastsd 40(%r8), %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 32(%r9), %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 64(%rdi), %xmm15
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm15[1],xmm5[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovapd 64(%r8), %ymm5
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm5[0,1],ymm1[2,3]
; AVX-NEXT:    vmovddup {{.*#+}} xmm2 = mem[0,0]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0],ymm2[1],ymm1[2,3]
; AVX-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 64(%rcx), %xmm10
; AVX-NEXT:    vmovaps 64(%rdx), %xmm9
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm9[1],xmm10[1]
; AVX-NEXT:    vbroadcastsd 72(%r8), %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 64(%r9), %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rsi), %xmm8
; AVX-NEXT:    vmovaps 96(%rdi), %xmm7
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm7[1],xmm8[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm2
; AVX-NEXT:    vmovapd 96(%r8), %ymm1
; AVX-NEXT:    vblendpd {{.*#+}} ymm2 = ymm1[0,1],ymm2[2,3]
; AVX-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2,3]
; AVX-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rcx), %xmm6
; AVX-NEXT:    vmovaps 96(%rdx), %xmm3
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm3[1],xmm6[1]
; AVX-NEXT:    vbroadcastsd 104(%r8), %ymm4
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm2[0,1,2,3],ymm4[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 96(%r9), %ymm2, %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3],ymm4[4,5],ymm2[6,7]
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd (%rdi), %ymm2
; AVX-NEXT:    vmovapd (%rsi), %ymm12
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm12[1],ymm2[3],ymm12[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm11[2,3],ymm2[2,3]
; AVX-NEXT:    vmovapd (%r9), %ymm4
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm4[2,3],ymm12[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm11[0],ymm2[2],ymm11[3]
; AVX-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 32(%rdi), %ymm2
; AVX-NEXT:    vmovapd 32(%rsi), %ymm11
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm11[1],ymm2[3],ymm11[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm2[2,3]
; AVX-NEXT:    vmovapd 32(%r9), %ymm2
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm2[2,3],ymm11[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm11[0],ymm0[2],ymm11[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 64(%rdi), %ymm0
; AVX-NEXT:    vmovapd 64(%rsi), %ymm11
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm11[1],ymm0[3],ymm11[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm5[2,3],ymm0[2,3]
; AVX-NEXT:    vmovapd 64(%r9), %ymm0
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm0[2,3],ymm11[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm5 = ymm5[0],ymm11[0],ymm5[2],ymm11[3]
; AVX-NEXT:    vmovupd %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 96(%rdi), %ymm5
; AVX-NEXT:    vmovapd 96(%rsi), %ymm11
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm5 = ymm5[1],ymm11[1],ymm5[3],ymm11[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm1[2,3],ymm5[2,3]
; AVX-NEXT:    vmovapd 96(%r9), %ymm1
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm1[2,3],ymm11[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm11 = ymm5[0],ymm11[0],ymm5[2],ymm11[3]
; AVX-NEXT:    vmovaps 16(%rdi), %xmm5
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 16(%rcx), %ymm12
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],ymm12[6,7]
; AVX-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 16(%rdx), %xmm5
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm5 = xmm5[1],mem[1]
; AVX-NEXT:    vbroadcastsd 24(%r8), %ymm12
; AVX-NEXT:    vblendpd {{.*#+}} ymm5 = ymm5[0,1],ymm12[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm4 = ymm5[0,1,2],ymm4[3]
; AVX-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 48(%rdi), %xmm4
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm4 = xmm4[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 48(%rcx), %ymm5
; AVX-NEXT:    vblendps {{.*#+}} ymm5 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX-NEXT:    vmovapd 48(%rdx), %xmm4
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm4 = xmm4[1],mem[1]
; AVX-NEXT:    vbroadcastsd 56(%r8), %ymm14
; AVX-NEXT:    vblendpd {{.*#+}} ymm4 = ymm4[0,1],ymm14[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm4 = ymm4[0,1,2],ymm2[3]
; AVX-NEXT:    vmovaps 80(%rdi), %xmm2
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 80(%rcx), %ymm14
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm14[6,7]
; AVX-NEXT:    vmovapd 80(%rdx), %xmm14
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm14 = xmm14[1],mem[1]
; AVX-NEXT:    vbroadcastsd 88(%r8), %ymm13
; AVX-NEXT:    vblendpd {{.*#+}} ymm13 = ymm14[0,1],ymm13[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm13[0,1,2],ymm0[3]
; AVX-NEXT:    vmovaps 112(%rdi), %xmm13
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm13 = xmm13[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 112(%rcx), %ymm14
; AVX-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1,2,3,4,5],ymm14[6,7]
; AVX-NEXT:    vmovapd 112(%rdx), %xmm14
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm14 = xmm14[1],mem[1]
; AVX-NEXT:    vbroadcastsd 120(%r8), %ymm12
; AVX-NEXT:    vblendpd {{.*#+}} ymm12 = ymm14[0,1],ymm12[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm12[0,1,2],ymm1[3]
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm15, %xmm12 # 16-byte Folded Reload
; AVX-NEXT:    # xmm12 = xmm15[0],mem[0]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm9 = xmm9[0],xmm10[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm10 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm10, %xmm10 # 16-byte Folded Reload
; AVX-NEXT:    # xmm10 = xmm10[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm14, %xmm14 # 16-byte Folded Reload
; AVX-NEXT:    # xmm14 = xmm14[0],mem[0]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm7 = xmm7[0],xmm8[0]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm3 = xmm3[0],xmm6[0]
; AVX-NEXT:    vmovaps (%rsp), %xmm6 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm6, %xmm6 # 16-byte Folded Reload
; AVX-NEXT:    # xmm6 = xmm6[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm8 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm8, %xmm8 # 16-byte Folded Reload
; AVX-NEXT:    # xmm8 = xmm8[0],mem[0]
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    vmovaps %xmm8, 16(%rax)
; AVX-NEXT:    vmovaps %xmm6, (%rax)
; AVX-NEXT:    vmovaps %xmm3, 592(%rax)
; AVX-NEXT:    vmovaps %xmm7, 576(%rax)
; AVX-NEXT:    vmovaps %xmm14, 208(%rax)
; AVX-NEXT:    vmovaps %xmm10, 192(%rax)
; AVX-NEXT:    vmovaps %xmm9, 400(%rax)
; AVX-NEXT:    vmovaps %xmm12, 384(%rax)
; AVX-NEXT:    vmovapd %ymm11, 704(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm3, 512(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm3, 320(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm3 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm3, 128(%rax)
; AVX-NEXT:    vmovapd %ymm1, 736(%rax)
; AVX-NEXT:    vmovaps %ymm13, 672(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 640(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm1, 608(%rax)
; AVX-NEXT:    vmovapd %ymm0, 544(%rax)
; AVX-NEXT:    vmovaps %ymm2, 480(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX-NEXT:    vmovapd %ymm4, 352(%rax)
; AVX-NEXT:    vmovaps %ymm5, 288(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX-NEXT:    addq $440, %rsp # imm = 0x1B8
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i64_stride6_vf16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    subq $360, %rsp # imm = 0x168
; AVX2-NEXT:    vmovaps (%r8), %ymm5
; AVX2-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%r8), %ymm4
; AVX2-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%r9), %xmm1
; AVX2-NEXT:    vmovaps 32(%r9), %xmm0
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-NEXT:    vmovaps (%rsi), %xmm3
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rsi), %xmm6
; AVX2-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rdi), %xmm15
; AVX2-NEXT:    vmovaps 32(%rdi), %xmm7
; AVX2-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm15[1],xmm3[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm5[0,1],ymm3[0,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vmovaps (%rcx), %xmm9
; AVX2-NEXT:    vmovaps 32(%rcx), %xmm13
; AVX2-NEXT:    vmovaps (%rdx), %xmm8
; AVX2-NEXT:    vmovaps 32(%rdx), %xmm11
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm8[1],xmm9[1]
; AVX2-NEXT:    vbroadcastsd 8(%r8), %ymm3
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovddup {{.*#+}} xmm1 = xmm0[0,0]
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm7[1],xmm6[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm4[0,1],ymm2[0,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm11[1],xmm13[1]
; AVX2-NEXT:    vbroadcastsd 40(%r8), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vmovaps 64(%r8), %ymm2
; AVX2-NEXT:    vmovups %ymm2, (%rsp) # 32-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rsi), %xmm6
; AVX2-NEXT:    vmovaps 64(%rdi), %xmm7
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm7[1],xmm6[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm2[0,1],ymm0[0,1]
; AVX2-NEXT:    vmovaps 64(%r9), %xmm1
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rcx), %xmm4
; AVX2-NEXT:    vmovaps 64(%rdx), %xmm5
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm5[1],xmm4[1]
; AVX2-NEXT:    vbroadcastsd 72(%r8), %ymm12
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm12[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%r8), %ymm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%rsi), %xmm2
; AVX2-NEXT:    vmovaps 96(%rdi), %xmm3
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm10 = xmm3[1],xmm2[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm0[0,1],ymm10[0,1]
; AVX2-NEXT:    vmovaps 96(%r9), %xmm0
; AVX2-NEXT:    vmovddup {{.*#+}} xmm12 = xmm0[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm10[0,1],ymm12[2,3],ymm10[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%rcx), %xmm10
; AVX2-NEXT:    vmovaps 96(%rdx), %xmm12
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm12[1],xmm10[1]
; AVX2-NEXT:    vbroadcastsd 104(%r8), %ymm14
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm14[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, %xmm9, %ymm0, %ymm0
; AVX2-NEXT:    vinsertf128 $1, %xmm8, %ymm15, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, %xmm13, %ymm0, %ymm0
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, %xmm11, %ymm1, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm4, %ymm6, %ymm0
; AVX2-NEXT:    vinsertf128 $1, %xmm5, %ymm7, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm14 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vinsertf128 $1, %xmm10, %ymm2, %ymm0
; AVX2-NEXT:    vinsertf128 $1, %xmm12, %ymm3, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovaps (%rdi), %ymm1
; AVX2-NEXT:    vmovaps (%rsi), %ymm2
; AVX2-NEXT:    vmovaps (%rdx), %ymm3
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],ymm3[2,3]
; AVX2-NEXT:    vbroadcastsd 16(%rcx), %ymm5
; AVX2-NEXT:    vblendps {{.*#+}} ymm15 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm1 = mem[2,3],ymm1[2,3]
; AVX2-NEXT:    vbroadcastsd 16(%r9), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm3[1],mem[1],ymm3[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 24(%r8), %ymm3
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm2[2,3],ymm3[2,3]
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm3
; AVX2-NEXT:    vmovaps 32(%rsi), %ymm5
; AVX2-NEXT:    vmovaps 32(%rdx), %ymm6
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm3[0],ymm5[0],ymm3[2],ymm5[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],ymm6[2,3]
; AVX2-NEXT:    vbroadcastsd 48(%rcx), %ymm7
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm7[6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm3 = ymm3[1],ymm5[1],ymm3[3],ymm5[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm3 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm3 = mem[2,3],ymm3[2,3]
; AVX2-NEXT:    vbroadcastsd 48(%r9), %ymm5
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm5[2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm5 = ymm6[1],mem[1],ymm6[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 56(%r8), %ymm6
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm5[2,3],ymm6[2,3]
; AVX2-NEXT:    vmovaps 64(%rdi), %ymm7
; AVX2-NEXT:    vmovaps 64(%rsi), %ymm9
; AVX2-NEXT:    vmovaps 64(%rdx), %ymm10
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm7[0],ymm9[0],ymm7[2],ymm9[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm5[2,3],ymm10[2,3]
; AVX2-NEXT:    vbroadcastsd 80(%rcx), %ymm11
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],ymm11[6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm7 = ymm7[1],ymm9[1],ymm7[3],ymm9[3]
; AVX2-NEXT:    vperm2f128 $19, (%rsp), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm7 = mem[2,3],ymm7[2,3]
; AVX2-NEXT:    vbroadcastsd 80(%r9), %ymm9
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm9[2,3],ymm7[4,5,6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm9 = ymm10[1],mem[1],ymm10[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 88(%r8), %ymm10
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm9[2,3],ymm10[2,3]
; AVX2-NEXT:    vmovaps 96(%rdi), %ymm10
; AVX2-NEXT:    vmovaps 96(%rsi), %ymm11
; AVX2-NEXT:    vmovaps 96(%rdx), %ymm12
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm8 = ymm10[0],ymm11[0],ymm10[2],ymm11[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm8[2,3],ymm12[2,3]
; AVX2-NEXT:    vbroadcastsd 112(%rcx), %ymm13
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],ymm13[6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm10 = ymm10[1],ymm11[1],ymm10[3],ymm11[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm10 = mem[2,3],ymm10[2,3]
; AVX2-NEXT:    vbroadcastsd 112(%r9), %ymm11
; AVX2-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1],ymm11[2,3],ymm10[4,5,6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm11 = ymm12[1],mem[1],ymm12[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 120(%r8), %ymm12
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm11[2,3],ymm12[2,3]
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vmovaps %ymm11, 736(%rax)
; AVX2-NEXT:    vmovaps %ymm10, 704(%rax)
; AVX2-NEXT:    vmovaps %ymm8, 672(%rax)
; AVX2-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-NEXT:    vmovaps %ymm9, 544(%rax)
; AVX2-NEXT:    vmovaps %ymm7, 512(%rax)
; AVX2-NEXT:    vmovaps %ymm5, 480(%rax)
; AVX2-NEXT:    vmovaps %ymm14, 384(%rax)
; AVX2-NEXT:    vmovaps %ymm6, 352(%rax)
; AVX2-NEXT:    vmovaps %ymm3, 320(%rax)
; AVX2-NEXT:    vmovaps %ymm2, 288(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-NEXT:    vmovaps %ymm4, 160(%rax)
; AVX2-NEXT:    vmovaps %ymm1, 128(%rax)
; AVX2-NEXT:    vmovaps %ymm15, 96(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-NEXT:    addq $360, %rsp # imm = 0x168
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i64_stride6_vf16:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    subq $360, %rsp # imm = 0x168
; AVX2-FP-NEXT:    vmovaps (%r8), %ymm5
; AVX2-FP-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%r8), %ymm4
; AVX2-FP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%r9), %xmm1
; AVX2-FP-NEXT:    vmovaps 32(%r9), %xmm0
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FP-NEXT:    vmovaps (%rsi), %xmm3
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %xmm6
; AVX2-FP-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm15
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %xmm7
; AVX2-FP-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm15[1],xmm3[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm5[0,1],ymm3[0,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vmovaps (%rcx), %xmm9
; AVX2-FP-NEXT:    vmovaps 32(%rcx), %xmm13
; AVX2-FP-NEXT:    vmovaps (%rdx), %xmm8
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %xmm11
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm8[1],xmm9[1]
; AVX2-FP-NEXT:    vbroadcastsd 8(%r8), %ymm3
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm1 = xmm0[0,0]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm7[1],xmm6[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm4[0,1],ymm2[0,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm11[1],xmm13[1]
; AVX2-FP-NEXT:    vbroadcastsd 40(%r8), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps 64(%r8), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, (%rsp) # 32-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %xmm6
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %xmm7
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm7[1],xmm6[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm2[0,1],ymm0[0,1]
; AVX2-FP-NEXT:    vmovaps 64(%r9), %xmm1
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rcx), %xmm4
; AVX2-FP-NEXT:    vmovaps 64(%rdx), %xmm5
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm5[1],xmm4[1]
; AVX2-FP-NEXT:    vbroadcastsd 72(%r8), %ymm12
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm12[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%r8), %ymm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %xmm2
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %xmm3
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm10 = xmm3[1],xmm2[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm0[0,1],ymm10[0,1]
; AVX2-FP-NEXT:    vmovaps 96(%r9), %xmm0
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm12 = xmm0[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm10[0,1],ymm12[2,3],ymm10[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rcx), %xmm10
; AVX2-FP-NEXT:    vmovaps 96(%rdx), %xmm12
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm12[1],xmm10[1]
; AVX2-FP-NEXT:    vbroadcastsd 104(%r8), %ymm14
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm14[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm9, %ymm0, %ymm0
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm8, %ymm15, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm13, %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm11, %ymm1, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm4, %ymm6, %ymm0
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm5, %ymm7, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm14 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm10, %ymm2, %ymm0
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm12, %ymm3, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm1
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm2
; AVX2-FP-NEXT:    vmovaps (%rdx), %ymm3
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],ymm3[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 16(%rcx), %ymm5
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm15 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm1 = mem[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 16(%r9), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm3[1],mem[1],ymm3[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 24(%r8), %ymm3
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm2[2,3],ymm3[2,3]
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm3
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %ymm5
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %ymm6
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm3[0],ymm5[0],ymm3[2],ymm5[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],ymm6[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 48(%rcx), %ymm7
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm7[6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm3 = ymm3[1],ymm5[1],ymm3[3],ymm5[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm3 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm3 = mem[2,3],ymm3[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 48(%r9), %ymm5
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm5[2,3],ymm3[4,5,6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm5 = ymm6[1],mem[1],ymm6[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 56(%r8), %ymm6
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm5[2,3],ymm6[2,3]
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %ymm7
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %ymm9
; AVX2-FP-NEXT:    vmovaps 64(%rdx), %ymm10
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm7[0],ymm9[0],ymm7[2],ymm9[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm5[2,3],ymm10[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 80(%rcx), %ymm11
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],ymm11[6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm7 = ymm7[1],ymm9[1],ymm7[3],ymm9[3]
; AVX2-FP-NEXT:    vperm2f128 $19, (%rsp), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm7 = mem[2,3],ymm7[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 80(%r9), %ymm9
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm9[2,3],ymm7[4,5,6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm9 = ymm10[1],mem[1],ymm10[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 88(%r8), %ymm10
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm9[2,3],ymm10[2,3]
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %ymm10
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %ymm11
; AVX2-FP-NEXT:    vmovaps 96(%rdx), %ymm12
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm8 = ymm10[0],ymm11[0],ymm10[2],ymm11[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm8[2,3],ymm12[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 112(%rcx), %ymm13
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],ymm13[6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm10 = ymm10[1],ymm11[1],ymm10[3],ymm11[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm10 = mem[2,3],ymm10[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 112(%r9), %ymm11
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1],ymm11[2,3],ymm10[4,5,6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm11 = ymm12[1],mem[1],ymm12[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 120(%r8), %ymm12
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm11[2,3],ymm12[2,3]
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps %ymm11, 736(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm10, 704(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm8, 672(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm9, 544(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm7, 512(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm5, 480(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm14, 384(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm6, 352(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm3, 320(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm2, 288(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm4, 160(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm1, 128(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm15, 96(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FP-NEXT:    addq $360, %rsp # imm = 0x168
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i64_stride6_vf16:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    subq $360, %rsp # imm = 0x168
; AVX2-FCP-NEXT:    vmovaps (%r8), %ymm5
; AVX2-FCP-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%r8), %ymm4
; AVX2-FCP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%r9), %xmm1
; AVX2-FCP-NEXT:    vmovaps 32(%r9), %xmm0
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FCP-NEXT:    vmovaps (%rsi), %xmm3
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %xmm6
; AVX2-FCP-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm15
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %xmm7
; AVX2-FCP-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm15[1],xmm3[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm5[0,1],ymm3[0,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vmovaps (%rcx), %xmm9
; AVX2-FCP-NEXT:    vmovaps 32(%rcx), %xmm13
; AVX2-FCP-NEXT:    vmovaps (%rdx), %xmm8
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %xmm11
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm8[1],xmm9[1]
; AVX2-FCP-NEXT:    vbroadcastsd 8(%r8), %ymm3
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm1 = xmm0[0,0]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm7[1],xmm6[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm4[0,1],ymm2[0,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm11[1],xmm13[1]
; AVX2-FCP-NEXT:    vbroadcastsd 40(%r8), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps 64(%r8), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, (%rsp) # 32-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %xmm6
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %xmm7
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm7[1],xmm6[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm2[0,1],ymm0[0,1]
; AVX2-FCP-NEXT:    vmovaps 64(%r9), %xmm1
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rcx), %xmm4
; AVX2-FCP-NEXT:    vmovaps 64(%rdx), %xmm5
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm5[1],xmm4[1]
; AVX2-FCP-NEXT:    vbroadcastsd 72(%r8), %ymm12
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm12[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%r8), %ymm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %xmm2
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %xmm3
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm10 = xmm3[1],xmm2[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm0[0,1],ymm10[0,1]
; AVX2-FCP-NEXT:    vmovaps 96(%r9), %xmm0
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm12 = xmm0[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm10[0,1],ymm12[2,3],ymm10[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rcx), %xmm10
; AVX2-FCP-NEXT:    vmovaps 96(%rdx), %xmm12
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm12[1],xmm10[1]
; AVX2-FCP-NEXT:    vbroadcastsd 104(%r8), %ymm14
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm14[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm9, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm8, %ymm15, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm13, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm11, %ymm1, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm4, %ymm6, %ymm0
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm5, %ymm7, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm14 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm10, %ymm2, %ymm0
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm12, %ymm3, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm2
; AVX2-FCP-NEXT:    vmovaps (%rdx), %ymm3
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],ymm3[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 16(%rcx), %ymm5
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm15 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm1 = mem[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 16(%r9), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm3[1],mem[1],ymm3[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 24(%r8), %ymm3
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm2[2,3],ymm3[2,3]
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm3
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %ymm5
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %ymm6
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm2 = ymm3[0],ymm5[0],ymm3[2],ymm5[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],ymm6[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 48(%rcx), %ymm7
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3,4,5],ymm7[6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm3 = ymm3[1],ymm5[1],ymm3[3],ymm5[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm3, %ymm3 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm3 = mem[2,3],ymm3[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 48(%r9), %ymm5
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1],ymm5[2,3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm5 = ymm6[1],mem[1],ymm6[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 56(%r8), %ymm6
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm5[2,3],ymm6[2,3]
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %ymm7
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %ymm9
; AVX2-FCP-NEXT:    vmovaps 64(%rdx), %ymm10
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm5 = ymm7[0],ymm9[0],ymm7[2],ymm9[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm5[2,3],ymm10[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 80(%rcx), %ymm11
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],ymm11[6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm7 = ymm7[1],ymm9[1],ymm7[3],ymm9[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, (%rsp), %ymm7, %ymm7 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm7 = mem[2,3],ymm7[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 80(%r9), %ymm9
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1],ymm9[2,3],ymm7[4,5,6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm9 = ymm10[1],mem[1],ymm10[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 88(%r8), %ymm10
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm9[2,3],ymm10[2,3]
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %ymm10
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %ymm11
; AVX2-FCP-NEXT:    vmovaps 96(%rdx), %ymm12
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm8 = ymm10[0],ymm11[0],ymm10[2],ymm11[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm8[2,3],ymm12[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 112(%rcx), %ymm13
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm8[0,1,2,3,4,5],ymm13[6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm10 = ymm10[1],ymm11[1],ymm10[3],ymm11[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm10, %ymm10 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm10 = mem[2,3],ymm10[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 112(%r9), %ymm11
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1],ymm11[2,3],ymm10[4,5,6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm11 = ymm12[1],mem[1],ymm12[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 120(%r8), %ymm12
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm11 = ymm11[2,3],ymm12[2,3]
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm11[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps %ymm11, 736(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm10, 704(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm8, 672(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm9, 544(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm7, 512(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm5, 480(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm14, 384(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm6, 352(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm3, 320(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm2, 288(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm4, 160(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm1, 128(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm15, 96(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FCP-NEXT:    addq $360, %rsp # imm = 0x168
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i64_stride6_vf16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm8
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm12
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm15
; AVX512-NEXT:    vmovdqa64 64(%rsi), %zmm11
; AVX512-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512-NEXT:    vmovdqa64 (%rcx), %zmm4
; AVX512-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512-NEXT:    vmovdqa64 (%r8), %zmm3
; AVX512-NEXT:    vmovdqa64 64(%r8), %zmm6
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [4,12,5,13,4,12,5,13]
; AVX512-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm12, %zmm1
; AVX512-NEXT:    vpermt2q %zmm15, %zmm0, %zmm1
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm9 = [0,0,4,12]
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512-NEXT:    vpermt2q %zmm4, %zmm9, %zmm10
; AVX512-NEXT:    movb $12, %r10b
; AVX512-NEXT:    kmovw %r10d, %k1
; AVX512-NEXT:    vmovdqa64 %zmm10, %zmm1 {%k1}
; AVX512-NEXT:    movb $16, %r10b
; AVX512-NEXT:    kmovw %r10d, %k2
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm1 {%k2}
; AVX512-NEXT:    vpermi2q %zmm11, %zmm8, %zmm0
; AVX512-NEXT:    vpermi2q %zmm7, %zmm5, %zmm9
; AVX512-NEXT:    vmovdqa64 %zmm9, %zmm0 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm6, %zmm0 {%k2}
; AVX512-NEXT:    vmovdqa64 (%r9), %zmm10
; AVX512-NEXT:    vmovdqa64 64(%r9), %zmm14
; AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} zmm19 = [7,15,7,15,7,15,7,15]
; AVX512-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm9
; AVX512-NEXT:    vpermt2q %zmm7, %zmm19, %zmm9
; AVX512-NEXT:    vmovdqa64 %zmm8, %zmm13
; AVX512-NEXT:    vpermt2q %zmm11, %zmm19, %zmm13
; AVX512-NEXT:    vshufi64x2 {{.*#+}} zmm9 = zmm13[0,1,2,3],zmm9[4,5,6,7]
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [14,0,2,3,4,5,15,0]
; AVX512-NEXT:    vpermt2q %zmm6, %zmm20, %zmm9
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [0,14,2,3,4,5,6,15]
; AVX512-NEXT:    vpermt2q %zmm14, %zmm21, %zmm9
; AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} zmm22 = [6,14,6,14,6,14,6,14]
; AVX512-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm8, %zmm17
; AVX512-NEXT:    vpermt2q %zmm11, %zmm22, %zmm17
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [5,13,6,14,5,13,6,14]
; AVX512-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm13
; AVX512-NEXT:    vpermt2q %zmm7, %zmm16, %zmm13
; AVX512-NEXT:    movb $48, %r9b
; AVX512-NEXT:    kmovw %r9d, %k2
; AVX512-NEXT:    vmovdqa64 %zmm17, %zmm13 {%k2}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm23 = [0,1,13,0,4,5,6,7]
; AVX512-NEXT:    vpermt2q %zmm6, %zmm23, %zmm13
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm24 = [0,1,2,13,4,5,6,7]
; AVX512-NEXT:    vpermt2q %zmm14, %zmm24, %zmm13
; AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} zmm25 = [2,10,2,10,2,10,2,10]
; AVX512-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm8, %zmm26
; AVX512-NEXT:    vpermt2q %zmm11, %zmm25, %zmm26
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [1,9,2,10,1,9,2,10]
; AVX512-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm17
; AVX512-NEXT:    vpermt2q %zmm7, %zmm18, %zmm17
; AVX512-NEXT:    vmovdqa64 %zmm26, %zmm17 {%k2}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm26 = [0,1,9,0,4,5,6,7]
; AVX512-NEXT:    vpermt2q %zmm6, %zmm26, %zmm17
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm27 = [0,1,2,9,4,5,6,7]
; AVX512-NEXT:    vpermt2q %zmm14, %zmm27, %zmm17
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm28
; AVX512-NEXT:    vpermt2q %zmm4, %zmm19, %zmm28
; AVX512-NEXT:    vpermi2q %zmm15, %zmm12, %zmm19
; AVX512-NEXT:    vshufi64x2 {{.*#+}} zmm19 = zmm19[0,1,2,3],zmm28[4,5,6,7]
; AVX512-NEXT:    vpermt2q %zmm3, %zmm20, %zmm19
; AVX512-NEXT:    vpermt2q %zmm10, %zmm21, %zmm19
; AVX512-NEXT:    vpermi2q %zmm15, %zmm12, %zmm22
; AVX512-NEXT:    vpermi2q %zmm4, %zmm2, %zmm16
; AVX512-NEXT:    vmovdqa64 %zmm22, %zmm16 {%k2}
; AVX512-NEXT:    vpermt2q %zmm3, %zmm23, %zmm16
; AVX512-NEXT:    vpermt2q %zmm10, %zmm24, %zmm16
; AVX512-NEXT:    vpermi2q %zmm15, %zmm12, %zmm25
; AVX512-NEXT:    vpermi2q %zmm4, %zmm2, %zmm18
; AVX512-NEXT:    vmovdqa64 %zmm25, %zmm18 {%k2}
; AVX512-NEXT:    vpermt2q %zmm3, %zmm26, %zmm18
; AVX512-NEXT:    vpermt2q %zmm10, %zmm27, %zmm18
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm20 = [0,8,1,9,0,8,1,9]
; AVX512-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermt2q %zmm15, %zmm20, %zmm12
; AVX512-NEXT:    vmovdqa (%rdx), %xmm15
; AVX512-NEXT:    vmovdqa64 64(%rdx), %xmm21
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm15 = xmm15[0],mem[0]
; AVX512-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm15
; AVX512-NEXT:    vinserti64x4 $0, %ymm15, %zmm0, %zmm12 {%k1}
; AVX512-NEXT:    vinserti32x4 $2, (%r8), %zmm12, %zmm12
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,1,2,3,4,8,6,7]
; AVX512-NEXT:    vpermt2q %zmm10, %zmm15, %zmm12
; AVX512-NEXT:    vpermt2q %zmm11, %zmm20, %zmm8
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm11 = xmm21[0],mem[0]
; AVX512-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512-NEXT:    vinserti64x4 $0, %ymm11, %zmm0, %zmm8 {%k1}
; AVX512-NEXT:    vinserti32x4 $2, 64(%r8), %zmm8, %zmm8
; AVX512-NEXT:    vpermt2q %zmm14, %zmm15, %zmm8
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm11 = [0,1,2,3,4,12,6,7]
; AVX512-NEXT:    vpermt2q %zmm14, %zmm11, %zmm0
; AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} zmm15 = [3,11,3,11,3,11,3,11]
; AVX512-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermt2q %zmm7, %zmm15, %zmm5
; AVX512-NEXT:    vmovdqa (%rdi), %ymm7
; AVX512-NEXT:    vmovdqa64 64(%rdi), %ymm20
; AVX512-NEXT:    vpunpckhqdq {{.*#+}} ymm20 = ymm20[1],mem[1],ymm20[3],mem[3]
; AVX512-NEXT:    vinserti64x4 $0, %ymm20, %zmm5, %zmm5
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [10,0,2,3,4,5,11,0]
; AVX512-NEXT:    vpermt2q %zmm6, %zmm20, %zmm5
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,10,2,3,4,5,6,11]
; AVX512-NEXT:    vpermt2q %zmm14, %zmm6, %zmm5
; AVX512-NEXT:    vpermt2q %zmm10, %zmm11, %zmm1
; AVX512-NEXT:    vpermt2q %zmm4, %zmm15, %zmm2
; AVX512-NEXT:    vpunpckhqdq {{.*#+}} ymm4 = ymm7[1],mem[1],ymm7[3],mem[3]
; AVX512-NEXT:    vinserti64x4 $0, %ymm4, %zmm2, %zmm2
; AVX512-NEXT:    vpermt2q %zmm3, %zmm20, %zmm2
; AVX512-NEXT:    vpermt2q %zmm10, %zmm6, %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm18, 64(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm2, 128(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm1, 192(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm16, 256(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm19, 320(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm17, 448(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm5, 512(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm0, 576(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm13, 640(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm9, 704(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm8, 384(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm12, (%rax)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i64_stride6_vf16:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm8
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm12
; AVX512-FCP-NEXT:    vmovdqa64 (%rsi), %zmm15
; AVX512-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm11
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 (%rcx), %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512-FCP-NEXT:    vmovdqa64 (%r8), %zmm3
; AVX512-FCP-NEXT:    vmovdqa64 64(%r8), %zmm6
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [4,12,5,13,4,12,5,13]
; AVX512-FCP-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm12, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm15, %zmm0, %zmm1
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm9 = [0,0,4,12]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm9, %zmm10
; AVX512-FCP-NEXT:    movb $12, %r10b
; AVX512-FCP-NEXT:    kmovw %r10d, %k1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, %zmm1 {%k1}
; AVX512-FCP-NEXT:    movb $16, %r10b
; AVX512-FCP-NEXT:    kmovw %r10d, %k2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, %zmm1 {%k2}
; AVX512-FCP-NEXT:    vpermi2q %zmm11, %zmm8, %zmm0
; AVX512-FCP-NEXT:    vpermi2q %zmm7, %zmm5, %zmm9
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, %zmm0 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, %zmm0 {%k2}
; AVX512-FCP-NEXT:    vmovdqa64 (%r9), %zmm10
; AVX512-FCP-NEXT:    vmovdqa64 64(%r9), %zmm14
; AVX512-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm19 = [7,15,7,15,7,15,7,15]
; AVX512-FCP-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm9
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm19, %zmm9
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, %zmm13
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm19, %zmm13
; AVX512-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm9 = zmm13[0,1,2,3],zmm9[4,5,6,7]
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [14,0,2,3,4,5,15,0]
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm20, %zmm9
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [0,14,2,3,4,5,6,15]
; AVX512-FCP-NEXT:    vpermt2q %zmm14, %zmm21, %zmm9
; AVX512-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm22 = [6,14,6,14,6,14,6,14]
; AVX512-FCP-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, %zmm17
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm22, %zmm17
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [5,13,6,14,5,13,6,14]
; AVX512-FCP-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm13
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm16, %zmm13
; AVX512-FCP-NEXT:    movb $48, %r9b
; AVX512-FCP-NEXT:    kmovw %r9d, %k2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm17, %zmm13 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm23 = [0,1,13,0,4,5,6,7]
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm23, %zmm13
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm24 = [0,1,2,13,4,5,6,7]
; AVX512-FCP-NEXT:    vpermt2q %zmm14, %zmm24, %zmm13
; AVX512-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm25 = [2,10,2,10,2,10,2,10]
; AVX512-FCP-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, %zmm26
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm25, %zmm26
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [1,9,2,10,1,9,2,10]
; AVX512-FCP-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm17
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm18, %zmm17
; AVX512-FCP-NEXT:    vmovdqa64 %zmm26, %zmm17 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm26 = [0,1,9,0,4,5,6,7]
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm26, %zmm17
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm27 = [0,1,2,9,4,5,6,7]
; AVX512-FCP-NEXT:    vpermt2q %zmm14, %zmm27, %zmm17
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm28
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm19, %zmm28
; AVX512-FCP-NEXT:    vpermi2q %zmm15, %zmm12, %zmm19
; AVX512-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm19 = zmm19[0,1,2,3],zmm28[4,5,6,7]
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm20, %zmm19
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm21, %zmm19
; AVX512-FCP-NEXT:    vpermi2q %zmm15, %zmm12, %zmm22
; AVX512-FCP-NEXT:    vpermi2q %zmm4, %zmm2, %zmm16
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, %zmm16 {%k2}
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm23, %zmm16
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm24, %zmm16
; AVX512-FCP-NEXT:    vpermi2q %zmm15, %zmm12, %zmm25
; AVX512-FCP-NEXT:    vpermi2q %zmm4, %zmm2, %zmm18
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, %zmm18 {%k2}
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm26, %zmm18
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm27, %zmm18
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm20 = [0,8,1,9,0,8,1,9]
; AVX512-FCP-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermt2q %zmm15, %zmm20, %zmm12
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %xmm15
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdx), %xmm21
; AVX512-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm15 = xmm15[0],mem[0]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm15
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm15, %zmm0, %zmm12 {%k1}
; AVX512-FCP-NEXT:    vinserti32x4 $2, (%r8), %zmm12, %zmm12
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,1,2,3,4,8,6,7]
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm15, %zmm12
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm20, %zmm8
; AVX512-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm11 = xmm21[0],mem[0]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm11, %zmm0, %zmm8 {%k1}
; AVX512-FCP-NEXT:    vinserti32x4 $2, 64(%r8), %zmm8, %zmm8
; AVX512-FCP-NEXT:    vpermt2q %zmm14, %zmm15, %zmm8
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm11 = [0,1,2,3,4,12,6,7]
; AVX512-FCP-NEXT:    vpermt2q %zmm14, %zmm11, %zmm0
; AVX512-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm15 = [3,11,3,11,3,11,3,11]
; AVX512-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm15, %zmm5
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %ymm7
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %ymm20
; AVX512-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm20 = ymm20[1],mem[1],ymm20[3],mem[3]
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm20, %zmm5, %zmm5
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [10,0,2,3,4,5,11,0]
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm20, %zmm5
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,10,2,3,4,5,6,11]
; AVX512-FCP-NEXT:    vpermt2q %zmm14, %zmm6, %zmm5
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm11, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm15, %zmm2
; AVX512-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm4 = ymm7[1],mem[1],ymm7[3],mem[3]
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm4, %zmm2, %zmm2
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm20, %zmm2
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm6, %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, 64(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, 128(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, 192(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm16, 256(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm19, 320(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm17, 448(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, 512(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, 576(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, 640(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, 704(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, 384(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm12, (%rax)
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i64_stride6_vf16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm8
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm12
; AVX512DQ-NEXT:    vmovdqa64 (%rsi), %zmm15
; AVX512DQ-NEXT:    vmovdqa64 64(%rsi), %zmm11
; AVX512DQ-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512DQ-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 (%rcx), %zmm4
; AVX512DQ-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512DQ-NEXT:    vmovdqa64 (%r8), %zmm3
; AVX512DQ-NEXT:    vmovdqa64 64(%r8), %zmm6
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [4,12,5,13,4,12,5,13]
; AVX512DQ-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm12, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm15, %zmm0, %zmm1
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm9 = [0,0,4,12]
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm9, %zmm10
; AVX512DQ-NEXT:    movb $12, %r10b
; AVX512DQ-NEXT:    kmovw %r10d, %k1
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, %zmm1 {%k1}
; AVX512DQ-NEXT:    movb $16, %r10b
; AVX512DQ-NEXT:    kmovw %r10d, %k2
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, %zmm1 {%k2}
; AVX512DQ-NEXT:    vpermi2q %zmm11, %zmm8, %zmm0
; AVX512DQ-NEXT:    vpermi2q %zmm7, %zmm5, %zmm9
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, %zmm0 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, %zmm0 {%k2}
; AVX512DQ-NEXT:    vmovdqa64 (%r9), %zmm10
; AVX512DQ-NEXT:    vmovdqa64 64(%r9), %zmm14
; AVX512DQ-NEXT:    vbroadcasti32x4 {{.*#+}} zmm19 = [7,15,7,15,7,15,7,15]
; AVX512DQ-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm9
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm19, %zmm9
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, %zmm13
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm19, %zmm13
; AVX512DQ-NEXT:    vshufi64x2 {{.*#+}} zmm9 = zmm13[0,1,2,3],zmm9[4,5,6,7]
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [14,0,2,3,4,5,15,0]
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm20, %zmm9
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [0,14,2,3,4,5,6,15]
; AVX512DQ-NEXT:    vpermt2q %zmm14, %zmm21, %zmm9
; AVX512DQ-NEXT:    vbroadcasti32x4 {{.*#+}} zmm22 = [6,14,6,14,6,14,6,14]
; AVX512DQ-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, %zmm17
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm22, %zmm17
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [5,13,6,14,5,13,6,14]
; AVX512DQ-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm13
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm16, %zmm13
; AVX512DQ-NEXT:    movb $48, %r9b
; AVX512DQ-NEXT:    kmovw %r9d, %k2
; AVX512DQ-NEXT:    vmovdqa64 %zmm17, %zmm13 {%k2}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm23 = [0,1,13,0,4,5,6,7]
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm23, %zmm13
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm24 = [0,1,2,13,4,5,6,7]
; AVX512DQ-NEXT:    vpermt2q %zmm14, %zmm24, %zmm13
; AVX512DQ-NEXT:    vbroadcasti32x4 {{.*#+}} zmm25 = [2,10,2,10,2,10,2,10]
; AVX512DQ-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, %zmm26
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm25, %zmm26
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [1,9,2,10,1,9,2,10]
; AVX512DQ-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm17
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm18, %zmm17
; AVX512DQ-NEXT:    vmovdqa64 %zmm26, %zmm17 {%k2}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm26 = [0,1,9,0,4,5,6,7]
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm26, %zmm17
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm27 = [0,1,2,9,4,5,6,7]
; AVX512DQ-NEXT:    vpermt2q %zmm14, %zmm27, %zmm17
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm28
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm19, %zmm28
; AVX512DQ-NEXT:    vpermi2q %zmm15, %zmm12, %zmm19
; AVX512DQ-NEXT:    vshufi64x2 {{.*#+}} zmm19 = zmm19[0,1,2,3],zmm28[4,5,6,7]
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm20, %zmm19
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm21, %zmm19
; AVX512DQ-NEXT:    vpermi2q %zmm15, %zmm12, %zmm22
; AVX512DQ-NEXT:    vpermi2q %zmm4, %zmm2, %zmm16
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, %zmm16 {%k2}
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm23, %zmm16
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm24, %zmm16
; AVX512DQ-NEXT:    vpermi2q %zmm15, %zmm12, %zmm25
; AVX512DQ-NEXT:    vpermi2q %zmm4, %zmm2, %zmm18
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, %zmm18 {%k2}
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm26, %zmm18
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm27, %zmm18
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm20 = [0,8,1,9,0,8,1,9]
; AVX512DQ-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermt2q %zmm15, %zmm20, %zmm12
; AVX512DQ-NEXT:    vmovdqa (%rdx), %xmm15
; AVX512DQ-NEXT:    vmovdqa64 64(%rdx), %xmm21
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm15 = xmm15[0],mem[0]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm15
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm15, %zmm0, %zmm12 {%k1}
; AVX512DQ-NEXT:    vinserti32x4 $2, (%r8), %zmm12, %zmm12
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,1,2,3,4,8,6,7]
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm15, %zmm12
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm20, %zmm8
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm11 = xmm21[0],mem[0]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm11, %zmm0, %zmm8 {%k1}
; AVX512DQ-NEXT:    vinserti32x4 $2, 64(%r8), %zmm8, %zmm8
; AVX512DQ-NEXT:    vpermt2q %zmm14, %zmm15, %zmm8
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm11 = [0,1,2,3,4,12,6,7]
; AVX512DQ-NEXT:    vpermt2q %zmm14, %zmm11, %zmm0
; AVX512DQ-NEXT:    vbroadcasti32x4 {{.*#+}} zmm15 = [3,11,3,11,3,11,3,11]
; AVX512DQ-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm15, %zmm5
; AVX512DQ-NEXT:    vmovdqa (%rdi), %ymm7
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %ymm20
; AVX512DQ-NEXT:    vpunpckhqdq {{.*#+}} ymm20 = ymm20[1],mem[1],ymm20[3],mem[3]
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm20, %zmm5, %zmm5
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [10,0,2,3,4,5,11,0]
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm20, %zmm5
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,10,2,3,4,5,6,11]
; AVX512DQ-NEXT:    vpermt2q %zmm14, %zmm6, %zmm5
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm11, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm15, %zmm2
; AVX512DQ-NEXT:    vpunpckhqdq {{.*#+}} ymm4 = ymm7[1],mem[1],ymm7[3],mem[3]
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm4, %zmm2, %zmm2
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm20, %zmm2
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm6, %zmm2
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, 64(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, 128(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, 192(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm16, 256(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm19, 320(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm17, 448(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, 512(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, 576(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm13, 640(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, 704(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, 384(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm12, (%rax)
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i64_stride6_vf16:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rsi), %zmm15
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rcx), %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%r8), %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%r8), %zmm6
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [4,12,5,13,4,12,5,13]
; AVX512DQ-FCP-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm12, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm15, %zmm0, %zmm1
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm9 = [0,0,4,12]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm9, %zmm10
; AVX512DQ-FCP-NEXT:    movb $12, %r10b
; AVX512DQ-FCP-NEXT:    kmovw %r10d, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, %zmm1 {%k1}
; AVX512DQ-FCP-NEXT:    movb $16, %r10b
; AVX512DQ-FCP-NEXT:    kmovw %r10d, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, %zmm1 {%k2}
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm11, %zmm8, %zmm0
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm7, %zmm5, %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, %zmm0 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, %zmm0 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%r9), %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%r9), %zmm14
; AVX512DQ-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm19 = [7,15,7,15,7,15,7,15]
; AVX512DQ-FCP-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm9
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm19, %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, %zmm13
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm19, %zmm13
; AVX512DQ-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm9 = zmm13[0,1,2,3],zmm9[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [14,0,2,3,4,5,15,0]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm20, %zmm9
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [0,14,2,3,4,5,6,15]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm14, %zmm21, %zmm9
; AVX512DQ-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm22 = [6,14,6,14,6,14,6,14]
; AVX512DQ-FCP-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, %zmm17
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm22, %zmm17
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [5,13,6,14,5,13,6,14]
; AVX512DQ-FCP-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm13
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm16, %zmm13
; AVX512DQ-FCP-NEXT:    movb $48, %r9b
; AVX512DQ-FCP-NEXT:    kmovw %r9d, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm17, %zmm13 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm23 = [0,1,13,0,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm23, %zmm13
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm24 = [0,1,2,13,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm14, %zmm24, %zmm13
; AVX512DQ-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm25 = [2,10,2,10,2,10,2,10]
; AVX512DQ-FCP-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, %zmm26
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm25, %zmm26
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [1,9,2,10,1,9,2,10]
; AVX512DQ-FCP-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm17
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm18, %zmm17
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm26, %zmm17 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm26 = [0,1,9,0,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm26, %zmm17
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm27 = [0,1,2,9,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm14, %zmm27, %zmm17
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm28
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm19, %zmm28
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm15, %zmm12, %zmm19
; AVX512DQ-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm19 = zmm19[0,1,2,3],zmm28[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm20, %zmm19
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm21, %zmm19
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm15, %zmm12, %zmm22
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm4, %zmm2, %zmm16
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, %zmm16 {%k2}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm23, %zmm16
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm24, %zmm16
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm15, %zmm12, %zmm25
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm4, %zmm2, %zmm18
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, %zmm18 {%k2}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm26, %zmm18
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm27, %zmm18
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm20 = [0,8,1,9,0,8,1,9]
; AVX512DQ-FCP-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm15, %zmm20, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %xmm15
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdx), %xmm21
; AVX512DQ-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm15 = xmm15[0],mem[0]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm15
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm15, %zmm0, %zmm12 {%k1}
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, (%r8), %zmm12, %zmm12
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,1,2,3,4,8,6,7]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm15, %zmm12
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm20, %zmm8
; AVX512DQ-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm11 = xmm21[0],mem[0]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm11, %zmm0, %zmm8 {%k1}
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, 64(%r8), %zmm8, %zmm8
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm14, %zmm15, %zmm8
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm11 = [0,1,2,3,4,12,6,7]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm14, %zmm11, %zmm0
; AVX512DQ-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm15 = [3,11,3,11,3,11,3,11]
; AVX512DQ-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm15, %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %ymm7
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %ymm20
; AVX512DQ-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm20 = ymm20[1],mem[1],ymm20[3],mem[3]
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm20, %zmm5, %zmm5
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [10,0,2,3,4,5,11,0]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm20, %zmm5
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,10,2,3,4,5,6,11]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm14, %zmm6, %zmm5
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm11, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm15, %zmm2
; AVX512DQ-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm4 = ymm7[1],mem[1],ymm7[3],mem[3]
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm4, %zmm2, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm20, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm6, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, 64(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, 128(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, 192(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm16, 256(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm19, 320(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm17, 448(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, 512(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, 576(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, 640(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, 704(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, 384(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm12, (%rax)
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i64_stride6_vf16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm8
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm12
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm15
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm11
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm4
; AVX512BW-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512BW-NEXT:    vmovdqa64 (%r8), %zmm3
; AVX512BW-NEXT:    vmovdqa64 64(%r8), %zmm6
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [4,12,5,13,4,12,5,13]
; AVX512BW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm15, %zmm0, %zmm1
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm9 = [0,0,4,12]
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm9, %zmm10
; AVX512BW-NEXT:    movb $12, %r10b
; AVX512BW-NEXT:    kmovd %r10d, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm1 {%k1}
; AVX512BW-NEXT:    movb $16, %r10b
; AVX512BW-NEXT:    kmovd %r10d, %k2
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm1 {%k2}
; AVX512BW-NEXT:    vpermi2q %zmm11, %zmm8, %zmm0
; AVX512BW-NEXT:    vpermi2q %zmm7, %zmm5, %zmm9
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm0 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm0 {%k2}
; AVX512BW-NEXT:    vmovdqa64 (%r9), %zmm10
; AVX512BW-NEXT:    vmovdqa64 64(%r9), %zmm14
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm19 = [7,15,7,15,7,15,7,15]
; AVX512BW-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm9
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm19, %zmm9
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm13
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm19, %zmm13
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm9 = zmm13[0,1,2,3],zmm9[4,5,6,7]
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [14,0,2,3,4,5,15,0]
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm20, %zmm9
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [0,14,2,3,4,5,6,15]
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm21, %zmm9
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm22 = [6,14,6,14,6,14,6,14]
; AVX512BW-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm17
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm22, %zmm17
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [5,13,6,14,5,13,6,14]
; AVX512BW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm13
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm16, %zmm13
; AVX512BW-NEXT:    movb $48, %r9b
; AVX512BW-NEXT:    kmovd %r9d, %k2
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm13 {%k2}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm23 = [0,1,13,0,4,5,6,7]
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm23, %zmm13
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm24 = [0,1,2,13,4,5,6,7]
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm24, %zmm13
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm25 = [2,10,2,10,2,10,2,10]
; AVX512BW-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm26
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm25, %zmm26
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [1,9,2,10,1,9,2,10]
; AVX512BW-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm17
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm18, %zmm17
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm17 {%k2}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm26 = [0,1,9,0,4,5,6,7]
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm26, %zmm17
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm27 = [0,1,2,9,4,5,6,7]
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm27, %zmm17
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm28
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm19, %zmm28
; AVX512BW-NEXT:    vpermi2q %zmm15, %zmm12, %zmm19
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm19 = zmm19[0,1,2,3],zmm28[4,5,6,7]
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm20, %zmm19
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm21, %zmm19
; AVX512BW-NEXT:    vpermi2q %zmm15, %zmm12, %zmm22
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm2, %zmm16
; AVX512BW-NEXT:    vmovdqa64 %zmm22, %zmm16 {%k2}
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm23, %zmm16
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm24, %zmm16
; AVX512BW-NEXT:    vpermi2q %zmm15, %zmm12, %zmm25
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm2, %zmm18
; AVX512BW-NEXT:    vmovdqa64 %zmm25, %zmm18 {%k2}
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm26, %zmm18
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm27, %zmm18
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm20 = [0,8,1,9,0,8,1,9]
; AVX512BW-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm15, %zmm20, %zmm12
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm15
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %xmm21
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm15 = xmm15[0],mem[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm15
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm15, %zmm0, %zmm12 {%k1}
; AVX512BW-NEXT:    vinserti32x4 $2, (%r8), %zmm12, %zmm12
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,1,2,3,4,8,6,7]
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm15, %zmm12
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm20, %zmm8
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm11 = xmm21[0],mem[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm11, %zmm0, %zmm8 {%k1}
; AVX512BW-NEXT:    vinserti32x4 $2, 64(%r8), %zmm8, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm15, %zmm8
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm11 = [0,1,2,3,4,12,6,7]
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm11, %zmm0
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm15 = [3,11,3,11,3,11,3,11]
; AVX512BW-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm15, %zmm5
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm7
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %ymm20
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm20 = ymm20[1],mem[1],ymm20[3],mem[3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm20, %zmm5, %zmm5
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [10,0,2,3,4,5,11,0]
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm20, %zmm5
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,10,2,3,4,5,6,11]
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm6, %zmm5
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm11, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm15, %zmm2
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm4 = ymm7[1],mem[1],ymm7[3],mem[3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm4, %zmm2, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm20, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm6, %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm18, 64(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 128(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 192(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm16, 256(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm19, 320(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm17, 448(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, 512(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 576(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm13, 640(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm9, 704(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm8, 384(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm12, (%rax)
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i64_stride6_vf16:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm8
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm12
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm15
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm11
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512BW-FCP-NEXT:    vmovdqa64 (%r8), %zmm3
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%r8), %zmm6
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [4,12,5,13,4,12,5,13]
; AVX512BW-FCP-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm12, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm15, %zmm0, %zmm1
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm9 = [0,0,4,12]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512BW-FCP-NEXT:    vpermt2q %zmm4, %zmm9, %zmm10
; AVX512BW-FCP-NEXT:    movb $12, %r10b
; AVX512BW-FCP-NEXT:    kmovd %r10d, %k1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, %zmm1 {%k1}
; AVX512BW-FCP-NEXT:    movb $16, %r10b
; AVX512BW-FCP-NEXT:    kmovd %r10d, %k2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm1 {%k2}
; AVX512BW-FCP-NEXT:    vpermi2q %zmm11, %zmm8, %zmm0
; AVX512BW-FCP-NEXT:    vpermi2q %zmm7, %zmm5, %zmm9
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm0 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm0 {%k2}
; AVX512BW-FCP-NEXT:    vmovdqa64 (%r9), %zmm10
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%r9), %zmm14
; AVX512BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm19 = [7,15,7,15,7,15,7,15]
; AVX512BW-FCP-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm9
; AVX512BW-FCP-NEXT:    vpermt2q %zmm7, %zmm19, %zmm9
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm13
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm19, %zmm13
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm9 = zmm13[0,1,2,3],zmm9[4,5,6,7]
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [14,0,2,3,4,5,15,0]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm20, %zmm9
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [0,14,2,3,4,5,6,15]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm14, %zmm21, %zmm9
; AVX512BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm22 = [6,14,6,14,6,14,6,14]
; AVX512BW-FCP-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm17
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm22, %zmm17
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [5,13,6,14,5,13,6,14]
; AVX512BW-FCP-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm13
; AVX512BW-FCP-NEXT:    vpermt2q %zmm7, %zmm16, %zmm13
; AVX512BW-FCP-NEXT:    movb $48, %r9b
; AVX512BW-FCP-NEXT:    kmovd %r9d, %k2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm17, %zmm13 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm23 = [0,1,13,0,4,5,6,7]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm23, %zmm13
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm24 = [0,1,2,13,4,5,6,7]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm14, %zmm24, %zmm13
; AVX512BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm25 = [2,10,2,10,2,10,2,10]
; AVX512BW-FCP-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm26
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm25, %zmm26
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [1,9,2,10,1,9,2,10]
; AVX512BW-FCP-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm17
; AVX512BW-FCP-NEXT:    vpermt2q %zmm7, %zmm18, %zmm17
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm26, %zmm17 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm26 = [0,1,9,0,4,5,6,7]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm26, %zmm17
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm27 = [0,1,2,9,4,5,6,7]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm14, %zmm27, %zmm17
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm28
; AVX512BW-FCP-NEXT:    vpermt2q %zmm4, %zmm19, %zmm28
; AVX512BW-FCP-NEXT:    vpermi2q %zmm15, %zmm12, %zmm19
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm19 = zmm19[0,1,2,3],zmm28[4,5,6,7]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm20, %zmm19
; AVX512BW-FCP-NEXT:    vpermt2q %zmm10, %zmm21, %zmm19
; AVX512BW-FCP-NEXT:    vpermi2q %zmm15, %zmm12, %zmm22
; AVX512BW-FCP-NEXT:    vpermi2q %zmm4, %zmm2, %zmm16
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm22, %zmm16 {%k2}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm23, %zmm16
; AVX512BW-FCP-NEXT:    vpermt2q %zmm10, %zmm24, %zmm16
; AVX512BW-FCP-NEXT:    vpermi2q %zmm15, %zmm12, %zmm25
; AVX512BW-FCP-NEXT:    vpermi2q %zmm4, %zmm2, %zmm18
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm25, %zmm18 {%k2}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm26, %zmm18
; AVX512BW-FCP-NEXT:    vpermt2q %zmm10, %zmm27, %zmm18
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm20 = [0,8,1,9,0,8,1,9]
; AVX512BW-FCP-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm15, %zmm20, %zmm12
; AVX512BW-FCP-NEXT:    vmovdqa (%rdx), %xmm15
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdx), %xmm21
; AVX512BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm15 = xmm15[0],mem[0]
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm15
; AVX512BW-FCP-NEXT:    vinserti64x4 $0, %ymm15, %zmm0, %zmm12 {%k1}
; AVX512BW-FCP-NEXT:    vinserti32x4 $2, (%r8), %zmm12, %zmm12
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,1,2,3,4,8,6,7]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm10, %zmm15, %zmm12
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm20, %zmm8
; AVX512BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm11 = xmm21[0],mem[0]
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512BW-FCP-NEXT:    vinserti64x4 $0, %ymm11, %zmm0, %zmm8 {%k1}
; AVX512BW-FCP-NEXT:    vinserti32x4 $2, 64(%r8), %zmm8, %zmm8
; AVX512BW-FCP-NEXT:    vpermt2q %zmm14, %zmm15, %zmm8
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm11 = [0,1,2,3,4,12,6,7]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm14, %zmm11, %zmm0
; AVX512BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm15 = [3,11,3,11,3,11,3,11]
; AVX512BW-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm7, %zmm15, %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %ymm7
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %ymm20
; AVX512BW-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm20 = ymm20[1],mem[1],ymm20[3],mem[3]
; AVX512BW-FCP-NEXT:    vinserti64x4 $0, %ymm20, %zmm5, %zmm5
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [10,0,2,3,4,5,11,0]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm20, %zmm5
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,10,2,3,4,5,6,11]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm14, %zmm6, %zmm5
; AVX512BW-FCP-NEXT:    vpermt2q %zmm10, %zmm11, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm4, %zmm15, %zmm2
; AVX512BW-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm4 = ymm7[1],mem[1],ymm7[3],mem[3]
; AVX512BW-FCP-NEXT:    vinserti64x4 $0, %ymm4, %zmm2, %zmm2
; AVX512BW-FCP-NEXT:    vpermt2q %zmm3, %zmm20, %zmm2
; AVX512BW-FCP-NEXT:    vpermt2q %zmm10, %zmm6, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, 64(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, 128(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, 192(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm16, 256(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm19, 320(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm17, 448(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, 512(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, 576(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm13, 640(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, 704(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, 384(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm12, (%rax)
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i64_stride6_vf16:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm8
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm12
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rsi), %zmm15
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rsi), %zmm11
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rcx), %zmm4
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512DQ-BW-NEXT:    vmovdqa64 (%r8), %zmm3
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%r8), %zmm6
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [4,12,5,13,4,12,5,13]
; AVX512DQ-BW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm12, %zmm1
; AVX512DQ-BW-NEXT:    vpermt2q %zmm15, %zmm0, %zmm1
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm9 = [0,0,4,12]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512DQ-BW-NEXT:    vpermt2q %zmm4, %zmm9, %zmm10
; AVX512DQ-BW-NEXT:    movb $12, %r10b
; AVX512DQ-BW-NEXT:    kmovd %r10d, %k1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm10, %zmm1 {%k1}
; AVX512DQ-BW-NEXT:    movb $16, %r10b
; AVX512DQ-BW-NEXT:    kmovd %r10d, %k2
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, %zmm1 {%k2}
; AVX512DQ-BW-NEXT:    vpermi2q %zmm11, %zmm8, %zmm0
; AVX512DQ-BW-NEXT:    vpermi2q %zmm7, %zmm5, %zmm9
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, %zmm0 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, %zmm0 {%k2}
; AVX512DQ-BW-NEXT:    vmovdqa64 (%r9), %zmm10
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%r9), %zmm14
; AVX512DQ-BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm19 = [7,15,7,15,7,15,7,15]
; AVX512DQ-BW-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, %zmm9
; AVX512DQ-BW-NEXT:    vpermt2q %zmm7, %zmm19, %zmm9
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, %zmm13
; AVX512DQ-BW-NEXT:    vpermt2q %zmm11, %zmm19, %zmm13
; AVX512DQ-BW-NEXT:    vshufi64x2 {{.*#+}} zmm9 = zmm13[0,1,2,3],zmm9[4,5,6,7]
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [14,0,2,3,4,5,15,0]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm6, %zmm20, %zmm9
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [0,14,2,3,4,5,6,15]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm14, %zmm21, %zmm9
; AVX512DQ-BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm22 = [6,14,6,14,6,14,6,14]
; AVX512DQ-BW-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, %zmm17
; AVX512DQ-BW-NEXT:    vpermt2q %zmm11, %zmm22, %zmm17
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [5,13,6,14,5,13,6,14]
; AVX512DQ-BW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, %zmm13
; AVX512DQ-BW-NEXT:    vpermt2q %zmm7, %zmm16, %zmm13
; AVX512DQ-BW-NEXT:    movb $48, %r9b
; AVX512DQ-BW-NEXT:    kmovd %r9d, %k2
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm17, %zmm13 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm23 = [0,1,13,0,4,5,6,7]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm6, %zmm23, %zmm13
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm24 = [0,1,2,13,4,5,6,7]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm14, %zmm24, %zmm13
; AVX512DQ-BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm25 = [2,10,2,10,2,10,2,10]
; AVX512DQ-BW-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, %zmm26
; AVX512DQ-BW-NEXT:    vpermt2q %zmm11, %zmm25, %zmm26
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [1,9,2,10,1,9,2,10]
; AVX512DQ-BW-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, %zmm17
; AVX512DQ-BW-NEXT:    vpermt2q %zmm7, %zmm18, %zmm17
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm26, %zmm17 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm26 = [0,1,9,0,4,5,6,7]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm6, %zmm26, %zmm17
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm27 = [0,1,2,9,4,5,6,7]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm14, %zmm27, %zmm17
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm28
; AVX512DQ-BW-NEXT:    vpermt2q %zmm4, %zmm19, %zmm28
; AVX512DQ-BW-NEXT:    vpermi2q %zmm15, %zmm12, %zmm19
; AVX512DQ-BW-NEXT:    vshufi64x2 {{.*#+}} zmm19 = zmm19[0,1,2,3],zmm28[4,5,6,7]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm20, %zmm19
; AVX512DQ-BW-NEXT:    vpermt2q %zmm10, %zmm21, %zmm19
; AVX512DQ-BW-NEXT:    vpermi2q %zmm15, %zmm12, %zmm22
; AVX512DQ-BW-NEXT:    vpermi2q %zmm4, %zmm2, %zmm16
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm22, %zmm16 {%k2}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm23, %zmm16
; AVX512DQ-BW-NEXT:    vpermt2q %zmm10, %zmm24, %zmm16
; AVX512DQ-BW-NEXT:    vpermi2q %zmm15, %zmm12, %zmm25
; AVX512DQ-BW-NEXT:    vpermi2q %zmm4, %zmm2, %zmm18
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm25, %zmm18 {%k2}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm26, %zmm18
; AVX512DQ-BW-NEXT:    vpermt2q %zmm10, %zmm27, %zmm18
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm20 = [0,8,1,9,0,8,1,9]
; AVX512DQ-BW-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm15, %zmm20, %zmm12
; AVX512DQ-BW-NEXT:    vmovdqa (%rdx), %xmm15
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdx), %xmm21
; AVX512DQ-BW-NEXT:    vpunpcklqdq {{.*#+}} xmm15 = xmm15[0],mem[0]
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm15
; AVX512DQ-BW-NEXT:    vinserti64x4 $0, %ymm15, %zmm0, %zmm12 {%k1}
; AVX512DQ-BW-NEXT:    vinserti32x4 $2, (%r8), %zmm12, %zmm12
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,1,2,3,4,8,6,7]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm10, %zmm15, %zmm12
; AVX512DQ-BW-NEXT:    vpermt2q %zmm11, %zmm20, %zmm8
; AVX512DQ-BW-NEXT:    vpunpcklqdq {{.*#+}} xmm11 = xmm21[0],mem[0]
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512DQ-BW-NEXT:    vinserti64x4 $0, %ymm11, %zmm0, %zmm8 {%k1}
; AVX512DQ-BW-NEXT:    vinserti32x4 $2, 64(%r8), %zmm8, %zmm8
; AVX512DQ-BW-NEXT:    vpermt2q %zmm14, %zmm15, %zmm8
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm11 = [0,1,2,3,4,12,6,7]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm14, %zmm11, %zmm0
; AVX512DQ-BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm15 = [3,11,3,11,3,11,3,11]
; AVX512DQ-BW-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm7, %zmm15, %zmm5
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %ymm7
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %ymm20
; AVX512DQ-BW-NEXT:    vpunpckhqdq {{.*#+}} ymm20 = ymm20[1],mem[1],ymm20[3],mem[3]
; AVX512DQ-BW-NEXT:    vinserti64x4 $0, %ymm20, %zmm5, %zmm5
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [10,0,2,3,4,5,11,0]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm6, %zmm20, %zmm5
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,10,2,3,4,5,6,11]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm14, %zmm6, %zmm5
; AVX512DQ-BW-NEXT:    vpermt2q %zmm10, %zmm11, %zmm1
; AVX512DQ-BW-NEXT:    vpermt2q %zmm4, %zmm15, %zmm2
; AVX512DQ-BW-NEXT:    vpunpckhqdq {{.*#+}} ymm4 = ymm7[1],mem[1],ymm7[3],mem[3]
; AVX512DQ-BW-NEXT:    vinserti64x4 $0, %ymm4, %zmm2, %zmm2
; AVX512DQ-BW-NEXT:    vpermt2q %zmm3, %zmm20, %zmm2
; AVX512DQ-BW-NEXT:    vpermt2q %zmm10, %zmm6, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm18, 64(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, 128(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, 192(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm16, 256(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm19, 320(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm17, 448(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, 512(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, 576(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm13, 640(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, 704(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, 384(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm12, (%rax)
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i64_stride6_vf16:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm8
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm12
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm15
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm11
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm7
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%r8), %zmm3
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%r8), %zmm6
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm0 = [4,12,5,13,4,12,5,13]
; AVX512DQ-BW-FCP-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm12, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm15, %zmm0, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm9 = [0,0,4,12]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm4, %zmm9, %zmm10
; AVX512DQ-BW-FCP-NEXT:    movb $12, %r10b
; AVX512DQ-BW-FCP-NEXT:    kmovd %r10d, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm10, %zmm1 {%k1}
; AVX512DQ-BW-FCP-NEXT:    movb $16, %r10b
; AVX512DQ-BW-FCP-NEXT:    kmovd %r10d, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm1 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm11, %zmm8, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm7, %zmm5, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm0 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm0 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%r9), %zmm10
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%r9), %zmm14
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm19 = [7,15,7,15,7,15,7,15]
; AVX512DQ-BW-FCP-NEXT:    # zmm19 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm7, %zmm19, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm11, %zmm19, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm9 = zmm13[0,1,2,3],zmm9[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [14,0,2,3,4,5,15,0]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm6, %zmm20, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [0,14,2,3,4,5,6,15]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm14, %zmm21, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm22 = [6,14,6,14,6,14,6,14]
; AVX512DQ-BW-FCP-NEXT:    # zmm22 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm11, %zmm22, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm16 = [5,13,6,14,5,13,6,14]
; AVX512DQ-BW-FCP-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm7, %zmm16, %zmm13
; AVX512DQ-BW-FCP-NEXT:    movb $48, %r9b
; AVX512DQ-BW-FCP-NEXT:    kmovd %r9d, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm17, %zmm13 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm23 = [0,1,13,0,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm6, %zmm23, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm24 = [0,1,2,13,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm14, %zmm24, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm25 = [2,10,2,10,2,10,2,10]
; AVX512DQ-BW-FCP-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm26
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm11, %zmm25, %zmm26
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm18 = [1,9,2,10,1,9,2,10]
; AVX512DQ-BW-FCP-NEXT:    # zmm18 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm7, %zmm18, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm26, %zmm17 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm26 = [0,1,9,0,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm6, %zmm26, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm27 = [0,1,2,9,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm14, %zmm27, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm28
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm4, %zmm19, %zmm28
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm15, %zmm12, %zmm19
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm19 = zmm19[0,1,2,3],zmm28[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm20, %zmm19
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm10, %zmm21, %zmm19
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm15, %zmm12, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm4, %zmm2, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm22, %zmm16 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm23, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm10, %zmm24, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm15, %zmm12, %zmm25
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm4, %zmm2, %zmm18
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm25, %zmm18 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm26, %zmm18
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm10, %zmm27, %zmm18
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm20 = [0,8,1,9,0,8,1,9]
; AVX512DQ-BW-FCP-NEXT:    # zmm20 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm15, %zmm20, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdx), %xmm15
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdx), %xmm21
; AVX512DQ-BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm15 = xmm15[0],mem[0]
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm15, %ymm0, %ymm15
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $0, %ymm15, %zmm0, %zmm12 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vinserti32x4 $2, (%r8), %zmm12, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm15 = [0,1,2,3,4,8,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm10, %zmm15, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm11, %zmm20, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm11 = xmm21[0],mem[0]
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm11, %ymm0, %ymm11
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $0, %ymm11, %zmm0, %zmm8 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vinserti32x4 $2, 64(%r8), %zmm8, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm14, %zmm15, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm11 = [0,1,2,3,4,12,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm14, %zmm11, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm15 = [3,11,3,11,3,11,3,11]
; AVX512DQ-BW-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm7, %zmm15, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %ymm7
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %ymm20
; AVX512DQ-BW-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm20 = ymm20[1],mem[1],ymm20[3],mem[3]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $0, %ymm20, %zmm5, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm20 = [10,0,2,3,4,5,11,0]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm6, %zmm20, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,10,2,3,4,5,6,11]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm14, %zmm6, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm10, %zmm11, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm4, %zmm15, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm4 = ymm7[1],mem[1],ymm7[3],mem[3]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $0, %ymm4, %zmm2, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm3, %zmm20, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm10, %zmm6, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm18, 64(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, 128(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, 192(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm16, 256(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm19, 320(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm17, 448(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, 512(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, 576(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm13, 640(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, 704(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, 384(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm12, (%rax)
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <16 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <16 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <16 x i64>, ptr %in.vecptr2, align 64
  %in.vec3 = load <16 x i64>, ptr %in.vecptr3, align 64
  %in.vec4 = load <16 x i64>, ptr %in.vecptr4, align 64
  %in.vec5 = load <16 x i64>, ptr %in.vecptr5, align 64
  %1 = shufflevector <16 x i64> %in.vec0, <16 x i64> %in.vec1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %2 = shufflevector <16 x i64> %in.vec2, <16 x i64> %in.vec3, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %3 = shufflevector <16 x i64> %in.vec4, <16 x i64> %in.vec5, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  %4 = shufflevector <32 x i64> %1, <32 x i64> %2, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %5 = shufflevector <32 x i64> %3, <32 x i64> poison, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <64 x i64> %4, <64 x i64> %5, <96 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95>
  %interleaved.vec = shufflevector <96 x i64> %6, <96 x i64> poison, <96 x i32> <i32 0, i32 16, i32 32, i32 48, i32 64, i32 80, i32 1, i32 17, i32 33, i32 49, i32 65, i32 81, i32 2, i32 18, i32 34, i32 50, i32 66, i32 82, i32 3, i32 19, i32 35, i32 51, i32 67, i32 83, i32 4, i32 20, i32 36, i32 52, i32 68, i32 84, i32 5, i32 21, i32 37, i32 53, i32 69, i32 85, i32 6, i32 22, i32 38, i32 54, i32 70, i32 86, i32 7, i32 23, i32 39, i32 55, i32 71, i32 87, i32 8, i32 24, i32 40, i32 56, i32 72, i32 88, i32 9, i32 25, i32 41, i32 57, i32 73, i32 89, i32 10, i32 26, i32 42, i32 58, i32 74, i32 90, i32 11, i32 27, i32 43, i32 59, i32 75, i32 91, i32 12, i32 28, i32 44, i32 60, i32 76, i32 92, i32 13, i32 29, i32 45, i32 61, i32 77, i32 93, i32 14, i32 30, i32 46, i32 62, i32 78, i32 94, i32 15, i32 31, i32 47, i32 63, i32 79, i32 95>
  store <96 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride6_vf32(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride6_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $1176, %rsp # imm = 0x498
; SSE-NEXT:    movaps (%rdi), %xmm7
; SSE-NEXT:    movaps 16(%rdi), %xmm8
; SSE-NEXT:    movaps 32(%rdi), %xmm9
; SSE-NEXT:    movaps (%rsi), %xmm2
; SSE-NEXT:    movaps 16(%rsi), %xmm1
; SSE-NEXT:    movaps 32(%rsi), %xmm0
; SSE-NEXT:    movaps (%rdx), %xmm10
; SSE-NEXT:    movaps 16(%rdx), %xmm11
; SSE-NEXT:    movaps 32(%rdx), %xmm12
; SSE-NEXT:    movaps (%rcx), %xmm4
; SSE-NEXT:    movaps 16(%rcx), %xmm3
; SSE-NEXT:    movaps (%r8), %xmm13
; SSE-NEXT:    movaps 16(%r8), %xmm14
; SSE-NEXT:    movaps (%r9), %xmm6
; SSE-NEXT:    movaps 16(%r9), %xmm5
; SSE-NEXT:    movaps %xmm7, %xmm15
; SSE-NEXT:    movlhps {{.*#+}} xmm15 = xmm15[0],xmm2[0]
; SSE-NEXT:    movaps %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm2[1]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm10, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm4[0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm10 = xmm10[1],xmm4[1]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm13, %xmm4
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm6[0]
; SSE-NEXT:    movaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm6[1]
; SSE-NEXT:    movaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm8, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm1[0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm1[1]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm11, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm3[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm3[1]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm14, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm5[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm5[1]
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm0[1]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm12, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm0[1]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%r8), %xmm2
; SSE-NEXT:    movaps 32(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%rdi), %xmm2
; SSE-NEXT:    movaps 48(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%rdx), %xmm2
; SSE-NEXT:    movaps 48(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%r8), %xmm2
; SSE-NEXT:    movaps 48(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdi), %xmm2
; SSE-NEXT:    movaps 64(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdx), %xmm2
; SSE-NEXT:    movaps 64(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%r8), %xmm2
; SSE-NEXT:    movaps 64(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rdi), %xmm2
; SSE-NEXT:    movaps 80(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rdx), %xmm2
; SSE-NEXT:    movaps 80(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%r8), %xmm2
; SSE-NEXT:    movaps 80(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%rdi), %xmm2
; SSE-NEXT:    movaps 96(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%rdx), %xmm2
; SSE-NEXT:    movaps 96(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%r8), %xmm2
; SSE-NEXT:    movaps 96(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%rdi), %xmm2
; SSE-NEXT:    movaps 112(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%rdx), %xmm2
; SSE-NEXT:    movaps 112(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%r8), %xmm2
; SSE-NEXT:    movaps 112(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%rdi), %xmm2
; SSE-NEXT:    movaps 128(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%rdx), %xmm2
; SSE-NEXT:    movaps 128(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%r8), %xmm2
; SSE-NEXT:    movaps 128(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%rdi), %xmm2
; SSE-NEXT:    movaps 144(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%rdx), %xmm2
; SSE-NEXT:    movaps 144(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%r8), %xmm2
; SSE-NEXT:    movaps 144(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%rdi), %xmm2
; SSE-NEXT:    movaps 160(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%rdx), %xmm2
; SSE-NEXT:    movaps 160(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%r8), %xmm2
; SSE-NEXT:    movaps 160(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%rdi), %xmm2
; SSE-NEXT:    movaps 176(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%rdx), %xmm2
; SSE-NEXT:    movaps 176(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%r8), %xmm2
; SSE-NEXT:    movaps 176(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%rdi), %xmm2
; SSE-NEXT:    movaps 192(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%rdx), %xmm2
; SSE-NEXT:    movaps 192(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%r8), %xmm2
; SSE-NEXT:    movaps 192(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 208(%rdi), %xmm15
; SSE-NEXT:    movaps 208(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm15, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm15 = xmm15[1],xmm0[1]
; SSE-NEXT:    movaps 208(%rdx), %xmm12
; SSE-NEXT:    movaps 208(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm12, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm0[1]
; SSE-NEXT:    movaps 208(%r8), %xmm11
; SSE-NEXT:    movaps 208(%r9), %xmm0
; SSE-NEXT:    movaps %xmm11, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm0[1]
; SSE-NEXT:    movaps 224(%rdi), %xmm13
; SSE-NEXT:    movaps 224(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm13, %xmm14
; SSE-NEXT:    movlhps {{.*#+}} xmm14 = xmm14[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm0[1]
; SSE-NEXT:    movaps 224(%rdx), %xmm9
; SSE-NEXT:    movaps 224(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm9, %xmm10
; SSE-NEXT:    movlhps {{.*#+}} xmm10 = xmm10[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm0[1]
; SSE-NEXT:    movaps 224(%r8), %xmm5
; SSE-NEXT:    movaps 224(%r9), %xmm0
; SSE-NEXT:    movaps %xmm5, %xmm8
; SSE-NEXT:    movlhps {{.*#+}} xmm8 = xmm8[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm0[1]
; SSE-NEXT:    movaps 240(%rdi), %xmm6
; SSE-NEXT:    movaps 240(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm6, %xmm7
; SSE-NEXT:    movlhps {{.*#+}} xmm7 = xmm7[0],xmm1[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm1[1]
; SSE-NEXT:    movaps 240(%rdx), %xmm1
; SSE-NEXT:    movaps 240(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 240(%r8), %xmm0
; SSE-NEXT:    movaps 240(%r9), %xmm3
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm3[1]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps %xmm0, 1520(%rax)
; SSE-NEXT:    movaps %xmm1, 1504(%rax)
; SSE-NEXT:    movaps %xmm6, 1488(%rax)
; SSE-NEXT:    movaps %xmm2, 1472(%rax)
; SSE-NEXT:    movaps %xmm4, 1456(%rax)
; SSE-NEXT:    movaps %xmm7, 1440(%rax)
; SSE-NEXT:    movaps %xmm5, 1424(%rax)
; SSE-NEXT:    movaps %xmm9, 1408(%rax)
; SSE-NEXT:    movaps %xmm13, 1392(%rax)
; SSE-NEXT:    movaps %xmm8, 1376(%rax)
; SSE-NEXT:    movaps %xmm10, 1360(%rax)
; SSE-NEXT:    movaps %xmm14, 1344(%rax)
; SSE-NEXT:    movaps %xmm11, 1328(%rax)
; SSE-NEXT:    movaps %xmm12, 1312(%rax)
; SSE-NEXT:    movaps %xmm15, 1296(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1280(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1264(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1248(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1232(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1216(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1200(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1184(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1168(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1152(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1136(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1120(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1104(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1088(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1072(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1056(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1040(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1024(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1008(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 992(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 976(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 960(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 944(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 928(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 912(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 896(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 880(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 864(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 848(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 832(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 816(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 800(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 784(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 768(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 752(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 736(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 720(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 704(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 688(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 672(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 656(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 640(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 624(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 608(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 592(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 576(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 560(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 544(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 528(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 512(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    addq $1176, %rsp # imm = 0x498
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i64_stride6_vf32:
; AVX:       # %bb.0:
; AVX-NEXT:    subq $1608, %rsp # imm = 0x648
; AVX-NEXT:    vmovapd (%r8), %ymm0
; AVX-NEXT:    vmovapd 32(%r8), %ymm1
; AVX-NEXT:    vmovddup {{.*#+}} xmm2 = mem[0,0]
; AVX-NEXT:    vmovaps (%rsi), %xmm4
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 32(%rsi), %xmm10
; AVX-NEXT:    vmovaps 64(%rsi), %xmm11
; AVX-NEXT:    vmovaps (%rdi), %xmm3
; AVX-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm3[1],xmm4[1]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX-NEXT:    vblendpd {{.*#+}} ymm3 = ymm0[0,1],ymm3[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm2 = ymm3[0],ymm2[1],ymm3[2,3]
; AVX-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps (%rcx), %xmm3
; AVX-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 32(%rcx), %xmm5
; AVX-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps (%rdx), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm2[1],xmm3[1]
; AVX-NEXT:    vinsertf128 $1, (%r9), %ymm2, %ymm3
; AVX-NEXT:    vbroadcastsd 8(%r8), %ymm4
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm4[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm3[2,3],ymm2[4,5],ymm3[6,7]
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovddup {{.*#+}} xmm2 = mem[0,0]
; AVX-NEXT:    vmovaps 32(%rdi), %xmm3
; AVX-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm3[1],xmm10[1]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX-NEXT:    vblendpd {{.*#+}} ymm3 = ymm1[0,1],ymm3[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm2 = ymm3[0],ymm2[1],ymm3[2,3]
; AVX-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 32(%rdx), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm2[1],xmm5[1]
; AVX-NEXT:    vbroadcastsd 40(%r8), %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm2[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 32(%r9), %ymm2, %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5],ymm2[6,7]
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 64(%rdi), %xmm13
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm13[1],xmm11[1]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX-NEXT:    vmovapd 64(%r8), %ymm3
; AVX-NEXT:    vblendpd {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3]
; AVX-NEXT:    vmovddup {{.*#+}} xmm4 = mem[0,0]
; AVX-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2,3]
; AVX-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 64(%rcx), %xmm4
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 64(%rdx), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm2[1],xmm4[1]
; AVX-NEXT:    vbroadcastsd 72(%r8), %ymm4
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm2[0,1,2,3],ymm4[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 64(%r9), %ymm2, %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3],ymm4[4,5],ymm2[6,7]
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rsi), %xmm4
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 96(%rdi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm2[1],xmm4[1]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX-NEXT:    vmovapd 96(%r8), %ymm5
; AVX-NEXT:    vblendpd {{.*#+}} ymm2 = ymm5[0,1],ymm2[2,3]
; AVX-NEXT:    vmovddup {{.*#+}} xmm4 = mem[0,0]
; AVX-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2,3]
; AVX-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rcx), %xmm4
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 96(%rdx), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm2[1],xmm4[1]
; AVX-NEXT:    vbroadcastsd 104(%r8), %ymm4
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm2[0,1,2,3],ymm4[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 96(%r9), %ymm2, %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3],ymm4[4,5],ymm2[6,7]
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 128(%rsi), %xmm14
; AVX-NEXT:    vmovaps 128(%rdi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm2[1],xmm14[1]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm2
; AVX-NEXT:    vmovapd 128(%r8), %ymm8
; AVX-NEXT:    vblendpd {{.*#+}} ymm2 = ymm8[0,1],ymm2[2,3]
; AVX-NEXT:    vmovddup {{.*#+}} xmm4 = mem[0,0]
; AVX-NEXT:    vblendpd {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2,3]
; AVX-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 128(%rcx), %xmm4
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 128(%rdx), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm2[1],xmm4[1]
; AVX-NEXT:    vbroadcastsd 136(%r8), %ymm4
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm2[0,1,2,3],ymm4[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 128(%r9), %ymm2, %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm2 = ymm4[0,1],ymm2[2,3],ymm4[4,5],ymm2[6,7]
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 160(%rsi), %xmm4
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 160(%rdi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm2[1],xmm4[1]
; AVX-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm4
; AVX-NEXT:    vmovapd 160(%r8), %ymm2
; AVX-NEXT:    vblendpd {{.*#+}} ymm4 = ymm2[0,1],ymm4[2,3]
; AVX-NEXT:    vmovddup {{.*#+}} xmm6 = mem[0,0]
; AVX-NEXT:    vblendpd {{.*#+}} ymm4 = ymm4[0],ymm6[1],ymm4[2,3]
; AVX-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 160(%rcx), %xmm6
; AVX-NEXT:    vmovaps %xmm6, (%rsp) # 16-byte Spill
; AVX-NEXT:    vmovaps 160(%rdx), %xmm4
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm4 = xmm4[1],xmm6[1]
; AVX-NEXT:    vbroadcastsd 168(%r8), %ymm6
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm4[0,1,2,3],ymm6[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 160(%r9), %ymm4, %ymm4
; AVX-NEXT:    vblendps {{.*#+}} ymm4 = ymm6[0,1],ymm4[2,3],ymm6[4,5],ymm4[6,7]
; AVX-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 192(%rsi), %xmm6
; AVX-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 192(%rdi), %xmm4
; AVX-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm4 = xmm4[1],xmm6[1]
; AVX-NEXT:    vinsertf128 $1, %xmm4, %ymm0, %ymm6
; AVX-NEXT:    vmovapd 192(%r8), %ymm4
; AVX-NEXT:    vblendpd {{.*#+}} ymm6 = ymm4[0,1],ymm6[2,3]
; AVX-NEXT:    vmovddup {{.*#+}} xmm7 = mem[0,0]
; AVX-NEXT:    vblendpd {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2,3]
; AVX-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 192(%rcx), %xmm7
; AVX-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 192(%rdx), %xmm6
; AVX-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm6 = xmm6[1],xmm7[1]
; AVX-NEXT:    vbroadcastsd 200(%r8), %ymm7
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 192(%r9), %ymm6, %ymm6
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3],ymm7[4,5],ymm6[6,7]
; AVX-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 224(%rsi), %xmm7
; AVX-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 224(%rdi), %xmm6
; AVX-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm6 = xmm6[1],xmm7[1]
; AVX-NEXT:    vinsertf128 $1, %xmm6, %ymm0, %ymm6
; AVX-NEXT:    vmovapd 224(%r8), %ymm9
; AVX-NEXT:    vblendpd {{.*#+}} ymm6 = ymm9[0,1],ymm6[2,3]
; AVX-NEXT:    vmovddup {{.*#+}} xmm7 = mem[0,0]
; AVX-NEXT:    vblendpd {{.*#+}} ymm6 = ymm6[0],ymm7[1],ymm6[2,3]
; AVX-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 224(%rcx), %xmm7
; AVX-NEXT:    vmovaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 224(%rdx), %xmm6
; AVX-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm6 = xmm6[1],xmm7[1]
; AVX-NEXT:    vbroadcastsd 232(%r8), %ymm7
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm6[0,1,2,3],ymm7[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 224(%r9), %ymm6, %ymm6
; AVX-NEXT:    vblendps {{.*#+}} ymm6 = ymm7[0,1],ymm6[2,3],ymm7[4,5],ymm6[6,7]
; AVX-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd (%rdi), %ymm6
; AVX-NEXT:    vmovapd (%rsi), %ymm7
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm6 = ymm6[1],ymm7[1],ymm6[3],ymm7[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm0[2,3],ymm6[2,3]
; AVX-NEXT:    vmovapd (%r9), %ymm0
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm0[2,3],ymm7[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm6 = ymm6[0],ymm7[0],ymm6[2],ymm7[3]
; AVX-NEXT:    vmovupd %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 32(%rdi), %ymm6
; AVX-NEXT:    vmovapd 32(%rsi), %ymm7
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm6 = ymm6[1],ymm7[1],ymm6[3],ymm7[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3],ymm6[2,3]
; AVX-NEXT:    vmovapd 32(%r9), %ymm12
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm12[2,3],ymm7[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm6[0],ymm1[2],ymm6[3]
; AVX-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 64(%rdi), %ymm1
; AVX-NEXT:    vmovapd 64(%rsi), %ymm7
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm7[1],ymm1[3],ymm7[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm3[2,3],ymm1[2,3]
; AVX-NEXT:    vmovapd 64(%r9), %ymm6
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm6[2,3],ymm7[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm3[0],ymm1[2],ymm3[3]
; AVX-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 96(%rdi), %ymm1
; AVX-NEXT:    vmovapd 96(%rsi), %ymm3
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm3[1],ymm1[3],ymm3[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm5[2,3],ymm1[2,3]
; AVX-NEXT:    vmovapd 96(%r9), %ymm5
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm5[2,3],ymm3[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm3[0],ymm1[2],ymm3[3]
; AVX-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 128(%rdi), %ymm1
; AVX-NEXT:    vmovapd 128(%rsi), %ymm7
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm7[1],ymm1[3],ymm7[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm8[2,3],ymm1[2,3]
; AVX-NEXT:    vmovapd 128(%r9), %ymm3
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm3[2,3],ymm7[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm1 = ymm1[0],ymm7[0],ymm1[2],ymm7[3]
; AVX-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 160(%rdi), %ymm1
; AVX-NEXT:    vmovapd 160(%rsi), %ymm7
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm7[1],ymm1[3],ymm7[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm2[2,3],ymm1[2,3]
; AVX-NEXT:    vmovapd 160(%r9), %ymm1
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm1[2,3],ymm7[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm2 = ymm2[0],ymm7[0],ymm2[2],ymm7[3]
; AVX-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 192(%rdi), %ymm2
; AVX-NEXT:    vmovapd 192(%rsi), %ymm7
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm7[1],ymm2[3],ymm7[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],ymm2[2,3]
; AVX-NEXT:    vmovapd 192(%r9), %ymm2
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm2[2,3],ymm7[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm4 = ymm4[0],ymm7[0],ymm4[2],ymm7[3]
; AVX-NEXT:    vmovupd %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 224(%rdi), %ymm4
; AVX-NEXT:    vmovapd 224(%rsi), %ymm7
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm4 = ymm4[1],ymm7[1],ymm4[3],ymm7[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm8 = ymm9[2,3],ymm4[2,3]
; AVX-NEXT:    vmovapd 224(%r9), %ymm4
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm4[2,3],ymm7[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm7 = ymm8[0],ymm7[0],ymm8[2],ymm7[3]
; AVX-NEXT:    vmovupd %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 16(%rdi), %xmm7
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm7 = xmm7[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 16(%rcx), %ymm8
; AVX-NEXT:    vblendps {{.*#+}} ymm7 = ymm7[0,1,2,3,4,5],ymm8[6,7]
; AVX-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 16(%rdx), %xmm7
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm7 = xmm7[1],mem[1]
; AVX-NEXT:    vbroadcastsd 24(%r8), %ymm8
; AVX-NEXT:    vblendpd {{.*#+}} ymm7 = ymm7[0,1],ymm8[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm7[0,1,2],ymm0[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 48(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 48(%rcx), %ymm7
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm7[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 48(%rdx), %xmm0
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX-NEXT:    vbroadcastsd 56(%r8), %ymm7
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm7[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm12[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 80(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 80(%rcx), %ymm7
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm7[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 80(%rdx), %xmm0
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX-NEXT:    vbroadcastsd 88(%r8), %ymm7
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm7[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm6[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 112(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 112(%rcx), %ymm6
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm6[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 112(%rdx), %xmm0
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX-NEXT:    vbroadcastsd 120(%r8), %ymm6
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm6[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm5[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 144(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 144(%rcx), %ymm5
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm5[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 144(%rdx), %xmm0
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX-NEXT:    vbroadcastsd 152(%r8), %ymm5
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm5[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm3[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 176(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 176(%rcx), %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm3[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 176(%rdx), %xmm0
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX-NEXT:    vbroadcastsd 184(%r8), %ymm3
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm3[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm1[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 208(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 208(%rcx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 208(%rdx), %xmm0
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX-NEXT:    vbroadcastsd 216(%r8), %ymm15
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm15[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm2[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 240(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 240(%rcx), %ymm15
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm15[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 240(%rdx), %xmm15
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm15 = xmm15[1],mem[1]
; AVX-NEXT:    vbroadcastsd 248(%r8), %ymm12
; AVX-NEXT:    vblendpd {{.*#+}} ymm12 = ymm15[0,1],ymm12[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm12[0,1,2],ymm4[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovlhps {{.*#+}} xmm14 = xmm0[0],xmm14[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm15 # 16-byte Folded Reload
; AVX-NEXT:    # xmm15 = xmm0[0],mem[0]
; AVX-NEXT:    vmovlhps {{.*#+}} xmm13 = xmm13[0],xmm11[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm12 # 16-byte Folded Reload
; AVX-NEXT:    # xmm12 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovlhps {{.*#+}} xmm11 = xmm0[0],xmm10[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm10 # 16-byte Folded Reload
; AVX-NEXT:    # xmm10 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm9 # 16-byte Folded Reload
; AVX-NEXT:    # xmm9 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm8 # 16-byte Folded Reload
; AVX-NEXT:    # xmm8 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm7 # 16-byte Folded Reload
; AVX-NEXT:    # xmm7 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd (%rsp), %xmm0, %xmm6 # 16-byte Folded Reload
; AVX-NEXT:    # xmm6 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm5 # 16-byte Folded Reload
; AVX-NEXT:    # xmm5 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm4 # 16-byte Folded Reload
; AVX-NEXT:    # xmm4 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm3 # 16-byte Folded Reload
; AVX-NEXT:    # xmm3 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm2 # 16-byte Folded Reload
; AVX-NEXT:    # xmm2 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    vmovaps %xmm0, 16(%rax)
; AVX-NEXT:    vmovaps %xmm1, (%rax)
; AVX-NEXT:    vmovaps %xmm2, 1168(%rax)
; AVX-NEXT:    vmovaps %xmm3, 1152(%rax)
; AVX-NEXT:    vmovaps %xmm4, 1360(%rax)
; AVX-NEXT:    vmovaps %xmm5, 1344(%rax)
; AVX-NEXT:    vmovaps %xmm6, 976(%rax)
; AVX-NEXT:    vmovaps %xmm7, 960(%rax)
; AVX-NEXT:    vmovaps %xmm8, 592(%rax)
; AVX-NEXT:    vmovaps %xmm9, 576(%rax)
; AVX-NEXT:    vmovaps %xmm10, 208(%rax)
; AVX-NEXT:    vmovaps %xmm11, 192(%rax)
; AVX-NEXT:    vmovaps %xmm12, 400(%rax)
; AVX-NEXT:    vmovaps %xmm13, 384(%rax)
; AVX-NEXT:    vmovaps %xmm15, 784(%rax)
; AVX-NEXT:    vmovaps %xmm14, 768(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1472(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1280(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1088(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 896(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1504(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1440(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1408(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1376(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1312(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1248(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1216(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1184(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1120(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1056(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1024(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 992(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 928(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 864(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 736(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 544(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX-NEXT:    addq $1608, %rsp # imm = 0x648
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i64_stride6_vf32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    subq $1208, %rsp # imm = 0x4B8
; AVX2-NEXT:    vmovaps (%r8), %ymm5
; AVX2-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%r8), %ymm4
; AVX2-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%r9), %xmm1
; AVX2-NEXT:    vmovaps 32(%r9), %xmm0
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-NEXT:    vmovaps (%rsi), %xmm8
; AVX2-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rsi), %xmm6
; AVX2-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rdi), %xmm3
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rdi), %xmm7
; AVX2-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm3[1],xmm8[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm5[0,1],ymm3[0,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vmovaps (%rcx), %xmm3
; AVX2-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 32(%rcx), %xmm5
; AVX2-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps (%rdx), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 32(%rdx), %xmm8
; AVX2-NEXT:    vmovaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm2[1],xmm3[1]
; AVX2-NEXT:    vbroadcastsd 8(%r8), %ymm3
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovddup {{.*#+}} xmm1 = xmm0[0,0]
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm7[1],xmm6[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm4[0,1],ymm2[0,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm8[1],xmm5[1]
; AVX2-NEXT:    vbroadcastsd 40(%r8), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vmovaps 64(%r8), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rsi), %xmm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rdi), %xmm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm2[0,1],ymm0[0,1]
; AVX2-NEXT:    vmovaps 64(%r9), %xmm1
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rcx), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 64(%rdx), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vbroadcastsd 72(%r8), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%rsi), %xmm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%rdi), %xmm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-NEXT:    vmovaps 96(%r9), %xmm1
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%rcx), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 96(%rdx), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vbroadcastsd 104(%r8), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 128(%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 128(%rsi), %xmm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 128(%rdi), %xmm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-NEXT:    vmovaps 128(%r9), %xmm1
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 128(%rcx), %xmm14
; AVX2-NEXT:    vmovaps 128(%rdx), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm14[1]
; AVX2-NEXT:    vbroadcastsd 136(%r8), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 160(%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 160(%rsi), %xmm12
; AVX2-NEXT:    vmovaps 160(%rdi), %xmm13
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm13[1],xmm12[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-NEXT:    vmovaps 160(%r9), %xmm1
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 160(%rcx), %xmm10
; AVX2-NEXT:    vmovaps 160(%rdx), %xmm11
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm11[1],xmm10[1]
; AVX2-NEXT:    vbroadcastsd 168(%r8), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 192(%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 192(%rsi), %xmm8
; AVX2-NEXT:    vmovaps 192(%rdi), %xmm9
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm9[1],xmm8[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-NEXT:    vmovaps 192(%r9), %xmm1
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 192(%rcx), %xmm6
; AVX2-NEXT:    vmovaps 192(%rdx), %xmm7
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm7[1],xmm6[1]
; AVX2-NEXT:    vbroadcastsd 200(%r8), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 224(%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 224(%rsi), %xmm4
; AVX2-NEXT:    vmovaps 224(%rdi), %xmm5
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm5[1],xmm4[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[0,1],ymm0[0,1]
; AVX2-NEXT:    vmovaps 224(%r9), %xmm0
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm0[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 224(%rcx), %xmm2
; AVX2-NEXT:    vmovaps 224(%rdx), %xmm3
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm3[1],xmm2[1]
; AVX2-NEXT:    vbroadcastsd 232(%r8), %ymm15
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm15[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, %xmm14, %ymm0, %ymm0
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm10, %ymm12, %ymm0
; AVX2-NEXT:    vinsertf128 $1, %xmm11, %ymm13, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm6, %ymm8, %ymm0
; AVX2-NEXT:    vinsertf128 $1, %xmm7, %ymm9, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm2, %ymm4, %ymm0
; AVX2-NEXT:    vinsertf128 $1, %xmm3, %ymm5, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 16(%rcx), %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 16(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 24(%r8), %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 32(%rdx), %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 48(%rcx), %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 48(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 56(%r8), %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 64(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 64(%rdx), %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 80(%rcx), %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 80(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 88(%r8), %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm13 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovaps 96(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 96(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 96(%rdx), %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 112(%rcx), %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 112(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 120(%r8), %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovaps 128(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 128(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 128(%rdx), %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 144(%rcx), %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm11 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 144(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm10 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 152(%r8), %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 160(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 160(%rdx), %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 176(%rcx), %ymm5
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 176(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 184(%r8), %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovaps 192(%rdi), %ymm1
; AVX2-NEXT:    vmovaps 192(%rsi), %ymm0
; AVX2-NEXT:    vmovaps 192(%rdx), %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 208(%rcx), %ymm12
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm12[6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 208(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 216(%r8), %ymm2
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3],ymm2[2,3]
; AVX2-NEXT:    vmovaps 224(%rdi), %ymm2
; AVX2-NEXT:    vmovaps 224(%rsi), %ymm12
; AVX2-NEXT:    vmovaps 224(%rdx), %ymm0
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm14 = ymm2[0],ymm12[0],ymm2[2],ymm12[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm14[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 240(%rcx), %ymm15
; AVX2-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm12[1],ymm2[3],ymm12[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm2 = mem[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 240(%r9), %ymm12
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm12[2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 248(%r8), %ymm12
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm12[2,3]
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX2-NEXT:    vblendps {{.*#+}} ymm15 = ymm15[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vmovaps %ymm0, 1504(%rax)
; AVX2-NEXT:    vmovaps %ymm2, 1472(%rax)
; AVX2-NEXT:    vmovaps %ymm14, 1440(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1344(%rax)
; AVX2-NEXT:    vmovaps %ymm1, 1312(%rax)
; AVX2-NEXT:    vmovaps %ymm3, 1280(%rax)
; AVX2-NEXT:    vmovaps %ymm4, 1248(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1152(%rax)
; AVX2-NEXT:    vmovaps %ymm5, 1120(%rax)
; AVX2-NEXT:    vmovaps %ymm7, 1088(%rax)
; AVX2-NEXT:    vmovaps %ymm8, 1056(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 960(%rax)
; AVX2-NEXT:    vmovaps %ymm6, 928(%rax)
; AVX2-NEXT:    vmovaps %ymm10, 896(%rax)
; AVX2-NEXT:    vmovaps %ymm11, 864(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 768(%rax)
; AVX2-NEXT:    vmovaps %ymm9, 736(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-NEXT:    vmovaps %ymm13, 544(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-NEXT:    vmovaps %ymm15, 352(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-NEXT:    vmovaps %ymm12, 160(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1408(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1376(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1216(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1184(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1024(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 992(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-NEXT:    addq $1208, %rsp # imm = 0x4B8
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i64_stride6_vf32:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    subq $1208, %rsp # imm = 0x4B8
; AVX2-FP-NEXT:    vmovaps (%r8), %ymm5
; AVX2-FP-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%r8), %ymm4
; AVX2-FP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%r9), %xmm1
; AVX2-FP-NEXT:    vmovaps 32(%r9), %xmm0
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FP-NEXT:    vmovaps (%rsi), %xmm8
; AVX2-FP-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %xmm6
; AVX2-FP-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm3
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %xmm7
; AVX2-FP-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm3[1],xmm8[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm5[0,1],ymm3[0,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vmovaps (%rcx), %xmm3
; AVX2-FP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rcx), %xmm5
; AVX2-FP-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rdx), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %xmm8
; AVX2-FP-NEXT:    vmovaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm2[1],xmm3[1]
; AVX2-FP-NEXT:    vbroadcastsd 8(%r8), %ymm3
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm1 = xmm0[0,0]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm7[1],xmm6[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm4[0,1],ymm2[0,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm8[1],xmm5[1]
; AVX2-FP-NEXT:    vbroadcastsd 40(%r8), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps 64(%r8), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %xmm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %xmm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm2[0,1],ymm0[0,1]
; AVX2-FP-NEXT:    vmovaps 64(%r9), %xmm1
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rcx), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rdx), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vbroadcastsd 72(%r8), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %xmm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %xmm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FP-NEXT:    vmovaps 96(%r9), %xmm1
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rcx), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rdx), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vbroadcastsd 104(%r8), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%rsi), %xmm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%rdi), %xmm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FP-NEXT:    vmovaps 128(%r9), %xmm1
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%rcx), %xmm14
; AVX2-FP-NEXT:    vmovaps 128(%rdx), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm14[1]
; AVX2-FP-NEXT:    vbroadcastsd 136(%r8), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%rsi), %xmm12
; AVX2-FP-NEXT:    vmovaps 160(%rdi), %xmm13
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm13[1],xmm12[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FP-NEXT:    vmovaps 160(%r9), %xmm1
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%rcx), %xmm10
; AVX2-FP-NEXT:    vmovaps 160(%rdx), %xmm11
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm11[1],xmm10[1]
; AVX2-FP-NEXT:    vbroadcastsd 168(%r8), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%rsi), %xmm8
; AVX2-FP-NEXT:    vmovaps 192(%rdi), %xmm9
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm9[1],xmm8[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FP-NEXT:    vmovaps 192(%r9), %xmm1
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%rcx), %xmm6
; AVX2-FP-NEXT:    vmovaps 192(%rdx), %xmm7
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm7[1],xmm6[1]
; AVX2-FP-NEXT:    vbroadcastsd 200(%r8), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 224(%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 224(%rsi), %xmm4
; AVX2-FP-NEXT:    vmovaps 224(%rdi), %xmm5
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm5[1],xmm4[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[0,1],ymm0[0,1]
; AVX2-FP-NEXT:    vmovaps 224(%r9), %xmm0
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm0[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 224(%rcx), %xmm2
; AVX2-FP-NEXT:    vmovaps 224(%rdx), %xmm3
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm3[1],xmm2[1]
; AVX2-FP-NEXT:    vbroadcastsd 232(%r8), %ymm15
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm15[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm14, %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm10, %ymm12, %ymm0
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm11, %ymm13, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm6, %ymm8, %ymm0
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm7, %ymm9, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm2, %ymm4, %ymm0
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm3, %ymm5, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 16(%rcx), %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 16(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 24(%r8), %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 48(%rcx), %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 48(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 56(%r8), %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 64(%rdx), %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 80(%rcx), %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 80(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 88(%r8), %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm13 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 96(%rdx), %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 112(%rcx), %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 112(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 120(%r8), %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovaps 128(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 128(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 128(%rdx), %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 144(%rcx), %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm11 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 144(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm10 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 152(%r8), %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 160(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 160(%rdx), %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 176(%rcx), %ymm5
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 176(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 184(%r8), %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovaps 192(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovaps 192(%rsi), %ymm0
; AVX2-FP-NEXT:    vmovaps 192(%rdx), %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 208(%rcx), %ymm12
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm12[6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 208(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 216(%r8), %ymm2
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vmovaps 224(%rdi), %ymm2
; AVX2-FP-NEXT:    vmovaps 224(%rsi), %ymm12
; AVX2-FP-NEXT:    vmovaps 224(%rdx), %ymm0
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm14 = ymm2[0],ymm12[0],ymm2[2],ymm12[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm14[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 240(%rcx), %ymm15
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm12[1],ymm2[3],ymm12[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm2 = mem[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 240(%r9), %ymm12
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm12[2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 248(%r8), %ymm12
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm12[2,3]
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm15 = ymm15[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps %ymm0, 1504(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm2, 1472(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm14, 1440(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1344(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm1, 1312(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm3, 1280(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm4, 1248(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1152(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm5, 1120(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm7, 1088(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm8, 1056(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 960(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm6, 928(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm10, 896(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm11, 864(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 768(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm9, 736(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm13, 544(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm15, 352(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm12, 160(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1408(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1376(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1216(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1184(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1024(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 992(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FP-NEXT:    addq $1208, %rsp # imm = 0x4B8
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i64_stride6_vf32:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    subq $1208, %rsp # imm = 0x4B8
; AVX2-FCP-NEXT:    vmovaps (%r8), %ymm5
; AVX2-FCP-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%r8), %ymm4
; AVX2-FCP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%r9), %xmm1
; AVX2-FCP-NEXT:    vmovaps 32(%r9), %xmm0
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FCP-NEXT:    vmovaps (%rsi), %xmm8
; AVX2-FCP-NEXT:    vmovups %ymm8, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %xmm6
; AVX2-FCP-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm3
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %xmm7
; AVX2-FCP-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm3[1],xmm8[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm5[0,1],ymm3[0,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm3[0,1],ymm2[2,3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vmovaps (%rcx), %xmm3
; AVX2-FCP-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rcx), %xmm5
; AVX2-FCP-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rdx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %xmm8
; AVX2-FCP-NEXT:    vmovaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm2[1],xmm3[1]
; AVX2-FCP-NEXT:    vbroadcastsd 8(%r8), %ymm3
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1,2,3],ymm3[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm1 = xmm0[0,0]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm7[1],xmm6[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm4[0,1],ymm2[0,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm8[1],xmm5[1]
; AVX2-FCP-NEXT:    vbroadcastsd 40(%r8), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps 64(%r8), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm2[0,1],ymm0[0,1]
; AVX2-FCP-NEXT:    vmovaps 64(%r9), %xmm1
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rcx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rdx), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vbroadcastsd 72(%r8), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%r8), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %xmm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FCP-NEXT:    vmovaps 96(%r9), %xmm1
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rcx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rdx), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vbroadcastsd 104(%r8), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%r8), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%rsi), %xmm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FCP-NEXT:    vmovaps 128(%r9), %xmm1
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%rcx), %xmm14
; AVX2-FCP-NEXT:    vmovaps 128(%rdx), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm14[1]
; AVX2-FCP-NEXT:    vbroadcastsd 136(%r8), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%r8), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%rsi), %xmm12
; AVX2-FCP-NEXT:    vmovaps 160(%rdi), %xmm13
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm13[1],xmm12[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FCP-NEXT:    vmovaps 160(%r9), %xmm1
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%rcx), %xmm10
; AVX2-FCP-NEXT:    vmovaps 160(%rdx), %xmm11
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm11[1],xmm10[1]
; AVX2-FCP-NEXT:    vbroadcastsd 168(%r8), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 192(%r8), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 192(%rsi), %xmm8
; AVX2-FCP-NEXT:    vmovaps 192(%rdi), %xmm9
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm9[1],xmm8[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FCP-NEXT:    vmovaps 192(%r9), %xmm1
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 192(%rcx), %xmm6
; AVX2-FCP-NEXT:    vmovaps 192(%rdx), %xmm7
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm7[1],xmm6[1]
; AVX2-FCP-NEXT:    vbroadcastsd 200(%r8), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 224(%r8), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 224(%rsi), %xmm4
; AVX2-FCP-NEXT:    vmovaps 224(%rdi), %xmm5
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm5[1],xmm4[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[0,1],ymm0[0,1]
; AVX2-FCP-NEXT:    vmovaps 224(%r9), %xmm0
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm0[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 224(%rcx), %xmm2
; AVX2-FCP-NEXT:    vmovaps 224(%rdx), %xmm3
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm3[1],xmm2[1]
; AVX2-FCP-NEXT:    vbroadcastsd 232(%r8), %ymm15
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm15[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm14, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm10, %ymm12, %ymm0
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm11, %ymm13, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm6, %ymm8, %ymm0
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm7, %ymm9, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm2, %ymm4, %ymm0
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm3, %ymm5, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 16(%rcx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 16(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 24(%r8), %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 48(%rcx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 48(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 56(%r8), %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 64(%rdx), %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 80(%rcx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 80(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 88(%r8), %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm13 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 96(%rdx), %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 112(%rcx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 112(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 120(%r8), %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovaps 128(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 128(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 128(%rdx), %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 144(%rcx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 144(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm10 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 152(%r8), %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 160(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 160(%rdx), %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 176(%rcx), %ymm5
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 176(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 184(%r8), %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm5 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovaps 192(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 192(%rsi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 192(%rdx), %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 208(%rcx), %ymm12
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm4[0,1,2,3,4,5],ymm12[6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 208(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 216(%r8), %ymm2
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vmovaps 224(%rdi), %ymm2
; AVX2-FCP-NEXT:    vmovaps 224(%rsi), %ymm12
; AVX2-FCP-NEXT:    vmovaps 224(%rdx), %ymm0
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm14 = ymm2[0],ymm12[0],ymm2[2],ymm12[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm14[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 240(%rcx), %ymm15
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm14 = ymm14[0,1,2,3,4,5],ymm15[6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm12[1],ymm2[3],ymm12[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm2 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm2 = mem[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 240(%r9), %ymm12
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm2[0,1],ymm12[2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 248(%r8), %ymm12
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm12[2,3]
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm12 # 32-byte Reload
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm12 = ymm12[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm15 # 32-byte Reload
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm15 = ymm15[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm13 = ymm13[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm9 = ymm9[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm5[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1504(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm2, 1472(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm14, 1440(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1344(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm1, 1312(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm3, 1280(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm4, 1248(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1152(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm5, 1120(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm7, 1088(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm8, 1056(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 960(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm6, 928(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm10, 896(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm11, 864(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 768(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm9, 736(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm13, 544(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm15, 352(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm12, 160(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1408(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1376(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1216(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1184(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1024(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 992(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FCP-NEXT:    addq $1208, %rsp # imm = 0x4B8
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i64_stride6_vf32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    subq $648, %rsp # imm = 0x288
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm11
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm5
; AVX512-NEXT:    vmovdqa64 128(%rdi), %zmm1
; AVX512-NEXT:    vmovdqa64 192(%rdi), %zmm19
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm29
; AVX512-NEXT:    vmovdqa64 64(%rsi), %zmm25
; AVX512-NEXT:    vmovdqa64 128(%rsi), %zmm23
; AVX512-NEXT:    vmovdqa64 192(%rsi), %zmm20
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm24
; AVX512-NEXT:    vmovdqa64 64(%rdx), %zmm4
; AVX512-NEXT:    vmovdqa64 128(%rdx), %zmm7
; AVX512-NEXT:    vmovdqa64 192(%rdx), %zmm21
; AVX512-NEXT:    vmovdqa64 (%rcx), %zmm18
; AVX512-NEXT:    vmovdqa64 64(%rcx), %zmm13
; AVX512-NEXT:    vmovdqa64 128(%rcx), %zmm12
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm27 = [4,12,5,13,4,12,5,13]
; AVX512-NEXT:    # zmm27 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm19, %zmm0
; AVX512-NEXT:    vpermt2q %zmm20, %zmm27, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512-NEXT:    vpermt2q %zmm23, %zmm27, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512-NEXT:    vpermt2q %zmm25, %zmm27, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermi2q %zmm29, %zmm11, %zmm27
; AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} zmm14 = [2,10,2,10,2,10,2,10]
; AVX512-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512-NEXT:    vpermt2q %zmm29, %zmm14, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} zmm15 = [6,14,6,14,6,14,6,14]
; AVX512-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512-NEXT:    vpermt2q %zmm29, %zmm15, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} zmm16 = [7,15,7,15,7,15,7,15]
; AVX512-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm24, %zmm0
; AVX512-NEXT:    vpermt2q %zmm18, %zmm16, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512-NEXT:    vpermt2q %zmm29, %zmm16, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512-NEXT:    vpermt2q %zmm25, %zmm14, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512-NEXT:    vpermt2q %zmm25, %zmm15, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm26
; AVX512-NEXT:    vpermt2q %zmm13, %zmm16, %zmm26
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm22
; AVX512-NEXT:    vpermt2q %zmm25, %zmm16, %zmm22
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm30
; AVX512-NEXT:    vpermt2q %zmm23, %zmm14, %zmm30
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,8,1,9,0,8,1,9]
; AVX512-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermt2q %zmm29, %zmm1, %zmm11
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm8
; AVX512-NEXT:    vpermt2q %zmm23, %zmm15, %zmm8
; AVX512-NEXT:    vpermt2q %zmm25, %zmm1, %zmm5
; AVX512-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm28
; AVX512-NEXT:    vpermt2q %zmm23, %zmm16, %zmm28
; AVX512-NEXT:    vpermt2q %zmm23, %zmm1, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm17
; AVX512-NEXT:    vpermt2q %zmm12, %zmm16, %zmm17
; AVX512-NEXT:    vpermi2q %zmm20, %zmm19, %zmm14
; AVX512-NEXT:    vpermi2q %zmm20, %zmm19, %zmm15
; AVX512-NEXT:    vmovdqa64 192(%rcx), %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm21, %zmm10
; AVX512-NEXT:    vpermt2q %zmm2, %zmm16, %zmm10
; AVX512-NEXT:    vpermi2q %zmm20, %zmm19, %zmm16
; AVX512-NEXT:    vpermt2q %zmm20, %zmm1, %zmm19
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,0,4,12]
; AVX512-NEXT:    vmovdqa64 %zmm21, %zmm6
; AVX512-NEXT:    vpermt2q %zmm2, %zmm1, %zmm6
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm5
; AVX512-NEXT:    vpermt2q %zmm12, %zmm1, %zmm5
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm3
; AVX512-NEXT:    vpermt2q %zmm13, %zmm1, %zmm3
; AVX512-NEXT:    vpermi2q %zmm18, %zmm24, %zmm1
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm25 = [1,9,2,10,1,9,2,10]
; AVX512-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm24, %zmm20
; AVX512-NEXT:    vpermt2q %zmm18, %zmm25, %zmm20
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [5,13,6,14,5,13,6,14]
; AVX512-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm24, %zmm23
; AVX512-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512-NEXT:    vpermt2q %zmm18, %zmm29, %zmm23
; AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [3,11,3,11,3,11,3,11]
; AVX512-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermt2q %zmm18, %zmm0, %zmm9
; AVX512-NEXT:    vmovdqu64 %zmm9, (%rsp) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm18
; AVX512-NEXT:    vpermt2q %zmm13, %zmm25, %zmm18
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm31
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm24
; AVX512-NEXT:    vpermt2q %zmm13, %zmm29, %zmm31
; AVX512-NEXT:    vpermt2q %zmm13, %zmm0, %zmm24
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm13
; AVX512-NEXT:    vpermt2q %zmm12, %zmm25, %zmm13
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm4
; AVX512-NEXT:    vpermt2q %zmm12, %zmm29, %zmm4
; AVX512-NEXT:    vpermt2q %zmm12, %zmm0, %zmm7
; AVX512-NEXT:    vpermi2q %zmm2, %zmm21, %zmm25
; AVX512-NEXT:    vpermi2q %zmm2, %zmm21, %zmm29
; AVX512-NEXT:    vpermt2q %zmm2, %zmm0, %zmm21
; AVX512-NEXT:    movb $12, %al
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm6, %zmm0 {%k1}
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm0 {%k1}
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm9 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k1}
; AVX512-NEXT:    movb $48, %al
; AVX512-NEXT:    kmovw %eax, %k2
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm12 # 64-byte Folded Reload
; AVX512-NEXT:    # zmm12 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k2}
; AVX512-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512-NEXT:    vshufi64x2 {{.*#+}} zmm22 = zmm22[0,1,2,3],zmm26[4,5,6,7]
; AVX512-NEXT:    vmovdqa64 64(%r8), %zmm1
; AVX512-NEXT:    vmovdqa64 %zmm30, %zmm13 {%k2}
; AVX512-NEXT:    vmovdqa64 128(%r8), %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k2}
; AVX512-NEXT:    vmovdqa64 192(%r8), %zmm26
; AVX512-NEXT:    vshufi64x2 {{.*#+}} zmm3 = zmm28[0,1,2,3],zmm17[4,5,6,7]
; AVX512-NEXT:    vmovdqa64 (%r9), %zmm8
; AVX512-NEXT:    vmovdqa64 %zmm14, %zmm25 {%k2}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,9,0,4,5,6,7]
; AVX512-NEXT:    vpermt2q %zmm0, %zmm5, %zmm20
; AVX512-NEXT:    vpermt2q %zmm1, %zmm5, %zmm18
; AVX512-NEXT:    vpermt2q %zmm2, %zmm5, %zmm13
; AVX512-NEXT:    vpermt2q %zmm26, %zmm5, %zmm25
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,9,4,5,6,7]
; AVX512-NEXT:    vpermt2q %zmm8, %zmm5, %zmm20
; AVX512-NEXT:    vmovdqa64 64(%r9), %zmm17
; AVX512-NEXT:    vpermt2q %zmm17, %zmm5, %zmm18
; AVX512-NEXT:    vmovdqa64 128(%r9), %zmm30
; AVX512-NEXT:    vpermt2q %zmm30, %zmm5, %zmm13
; AVX512-NEXT:    vmovdqa64 192(%r9), %zmm14
; AVX512-NEXT:    vpermt2q %zmm14, %zmm5, %zmm25
; AVX512-NEXT:    vmovdqa64 %zmm15, %zmm29 {%k2}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,13,0,4,5,6,7]
; AVX512-NEXT:    vpermt2q %zmm0, %zmm5, %zmm23
; AVX512-NEXT:    vpermt2q %zmm1, %zmm5, %zmm31
; AVX512-NEXT:    vpermt2q %zmm2, %zmm5, %zmm4
; AVX512-NEXT:    vpermt2q %zmm26, %zmm5, %zmm29
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,13,4,5,6,7]
; AVX512-NEXT:    vpermt2q %zmm8, %zmm5, %zmm23
; AVX512-NEXT:    vpermt2q %zmm17, %zmm5, %zmm31
; AVX512-NEXT:    vpermt2q %zmm30, %zmm5, %zmm4
; AVX512-NEXT:    vpermt2q %zmm14, %zmm5, %zmm29
; AVX512-NEXT:    vshufi64x2 {{.*#+}} zmm15 = zmm16[0,1,2,3],zmm10[4,5,6,7]
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [14,0,2,3,4,5,15,0]
; AVX512-NEXT:    vpermt2q %zmm0, %zmm5, %zmm12
; AVX512-NEXT:    vpermt2q %zmm1, %zmm5, %zmm22
; AVX512-NEXT:    vpermt2q %zmm2, %zmm5, %zmm3
; AVX512-NEXT:    vpermt2q %zmm26, %zmm5, %zmm15
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,14,2,3,4,5,6,15]
; AVX512-NEXT:    vpermt2q %zmm8, %zmm5, %zmm12
; AVX512-NEXT:    vpermt2q %zmm17, %zmm5, %zmm22
; AVX512-NEXT:    vpermt2q %zmm30, %zmm5, %zmm3
; AVX512-NEXT:    vpermt2q %zmm14, %zmm5, %zmm15
; AVX512-NEXT:    vmovdqa (%rdx), %xmm5
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm11 {%k1}
; AVX512-NEXT:    vmovdqa 64(%rdx), %xmm5
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm10 {%k1}
; AVX512-NEXT:    vmovdqa 128(%rdx), %xmm5
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm16 {%k1}
; AVX512-NEXT:    vmovdqa 192(%rdx), %xmm5
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm19 {%k1}
; AVX512-NEXT:    vinserti32x4 $2, (%r8), %zmm11, %zmm5
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,1,2,3,4,8,6,7]
; AVX512-NEXT:    vpermt2q %zmm8, %zmm6, %zmm5
; AVX512-NEXT:    vinserti32x4 $2, 64(%r8), %zmm10, %zmm10
; AVX512-NEXT:    vpermt2q %zmm17, %zmm6, %zmm10
; AVX512-NEXT:    vinserti32x4 $2, 128(%r8), %zmm16, %zmm11
; AVX512-NEXT:    vpermt2q %zmm30, %zmm6, %zmm11
; AVX512-NEXT:    vinserti32x4 $2, 192(%r8), %zmm19, %zmm16
; AVX512-NEXT:    vpermt2q %zmm14, %zmm6, %zmm16
; AVX512-NEXT:    vmovdqa (%rdi), %ymm6
; AVX512-NEXT:    vpunpckhqdq {{.*#+}} ymm6 = ymm6[1],mem[1],ymm6[3],mem[3]
; AVX512-NEXT:    vmovdqu64 (%rsp), %zmm19 # 64-byte Reload
; AVX512-NEXT:    vinserti64x4 $0, %ymm6, %zmm19, %zmm6
; AVX512-NEXT:    movb $16, %al
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k1}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm19 = [10,0,2,3,4,5,11,0]
; AVX512-NEXT:    vpermt2q %zmm0, %zmm19, %zmm6
; AVX512-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX512-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512-NEXT:    vinserti64x4 $0, %ymm0, %zmm24, %zmm0
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm9 {%k1}
; AVX512-NEXT:    vpermt2q %zmm1, %zmm19, %zmm0
; AVX512-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX512-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3]
; AVX512-NEXT:    vinserti64x4 $0, %ymm1, %zmm7, %zmm1
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm28 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm28 {%k1}
; AVX512-NEXT:    vpermt2q %zmm2, %zmm19, %zmm1
; AVX512-NEXT:    vmovdqa 192(%rdi), %ymm2
; AVX512-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512-NEXT:    vinserti64x4 $0, %ymm2, %zmm21, %zmm2
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm24 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm26, %zmm24 {%k1}
; AVX512-NEXT:    vpermt2q %zmm26, %zmm19, %zmm2
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm19 = [0,10,2,3,4,5,6,11]
; AVX512-NEXT:    vpermt2q %zmm8, %zmm19, %zmm6
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [0,1,2,3,4,12,6,7]
; AVX512-NEXT:    vpermt2q %zmm8, %zmm21, %zmm27
; AVX512-NEXT:    vpermt2q %zmm17, %zmm19, %zmm0
; AVX512-NEXT:    vpermt2q %zmm17, %zmm21, %zmm9
; AVX512-NEXT:    vpermt2q %zmm30, %zmm19, %zmm1
; AVX512-NEXT:    vpermt2q %zmm30, %zmm21, %zmm28
; AVX512-NEXT:    vpermt2q %zmm14, %zmm19, %zmm2
; AVX512-NEXT:    vpermt2q %zmm14, %zmm21, %zmm24
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovdqa64 %zmm15, 1472(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm29, 1408(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm24, 1344(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm2, 1280(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm25, 1216(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm3, 1088(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm4, 1024(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm28, 960(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm1, 896(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm13, 832(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm22, 704(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm31, 640(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm9, 576(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm0, 512(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm18, 448(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm12, 320(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm23, 256(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm27, 192(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm6, 128(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm20, 64(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm16, 1152(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm11, 768(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm10, 384(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm5, (%rax)
; AVX512-NEXT:    addq $648, %rsp # imm = 0x288
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i64_stride6_vf32:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    subq $648, %rsp # imm = 0x288
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm11
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm19
; AVX512-FCP-NEXT:    vmovdqa64 (%rsi), %zmm29
; AVX512-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm25
; AVX512-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm23
; AVX512-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm20
; AVX512-FCP-NEXT:    vmovdqa64 (%rdx), %zmm24
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm7
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm21
; AVX512-FCP-NEXT:    vmovdqa64 (%rcx), %zmm18
; AVX512-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm13
; AVX512-FCP-NEXT:    vmovdqa64 128(%rcx), %zmm12
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm27 = [4,12,5,13,4,12,5,13]
; AVX512-FCP-NEXT:    # zmm27 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm19, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm20, %zmm27, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm23, %zmm27, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm25, %zmm27, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermi2q %zmm29, %zmm11, %zmm27
; AVX512-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm14 = [2,10,2,10,2,10,2,10]
; AVX512-FCP-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm29, %zmm14, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm15 = [6,14,6,14,6,14,6,14]
; AVX512-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm29, %zmm15, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm16 = [7,15,7,15,7,15,7,15]
; AVX512-FCP-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm24, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm18, %zmm16, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm29, %zmm16, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm25, %zmm14, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm25, %zmm15, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm26
; AVX512-FCP-NEXT:    vpermt2q %zmm13, %zmm16, %zmm26
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm22
; AVX512-FCP-NEXT:    vpermt2q %zmm25, %zmm16, %zmm22
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm30
; AVX512-FCP-NEXT:    vpermt2q %zmm23, %zmm14, %zmm30
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,8,1,9,0,8,1,9]
; AVX512-FCP-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermt2q %zmm29, %zmm1, %zmm11
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm8
; AVX512-FCP-NEXT:    vpermt2q %zmm23, %zmm15, %zmm8
; AVX512-FCP-NEXT:    vpermt2q %zmm25, %zmm1, %zmm5
; AVX512-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm28
; AVX512-FCP-NEXT:    vpermt2q %zmm23, %zmm16, %zmm28
; AVX512-FCP-NEXT:    vpermt2q %zmm23, %zmm1, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm17
; AVX512-FCP-NEXT:    vpermt2q %zmm12, %zmm16, %zmm17
; AVX512-FCP-NEXT:    vpermi2q %zmm20, %zmm19, %zmm14
; AVX512-FCP-NEXT:    vpermi2q %zmm20, %zmm19, %zmm15
; AVX512-FCP-NEXT:    vmovdqa64 192(%rcx), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm21, %zmm10
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm10
; AVX512-FCP-NEXT:    vpermi2q %zmm20, %zmm19, %zmm16
; AVX512-FCP-NEXT:    vpermt2q %zmm20, %zmm1, %zmm19
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,0,4,12]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm21, %zmm6
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm1, %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm5
; AVX512-FCP-NEXT:    vpermt2q %zmm12, %zmm1, %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm3
; AVX512-FCP-NEXT:    vpermt2q %zmm13, %zmm1, %zmm3
; AVX512-FCP-NEXT:    vpermi2q %zmm18, %zmm24, %zmm1
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm25 = [1,9,2,10,1,9,2,10]
; AVX512-FCP-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm24, %zmm20
; AVX512-FCP-NEXT:    vpermt2q %zmm18, %zmm25, %zmm20
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [5,13,6,14,5,13,6,14]
; AVX512-FCP-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm24, %zmm23
; AVX512-FCP-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512-FCP-NEXT:    vpermt2q %zmm18, %zmm29, %zmm23
; AVX512-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [3,11,3,11,3,11,3,11]
; AVX512-FCP-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermt2q %zmm18, %zmm0, %zmm9
; AVX512-FCP-NEXT:    vmovdqu64 %zmm9, (%rsp) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm18
; AVX512-FCP-NEXT:    vpermt2q %zmm13, %zmm25, %zmm18
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm31
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm24
; AVX512-FCP-NEXT:    vpermt2q %zmm13, %zmm29, %zmm31
; AVX512-FCP-NEXT:    vpermt2q %zmm13, %zmm0, %zmm24
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm13
; AVX512-FCP-NEXT:    vpermt2q %zmm12, %zmm25, %zmm13
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm4
; AVX512-FCP-NEXT:    vpermt2q %zmm12, %zmm29, %zmm4
; AVX512-FCP-NEXT:    vpermt2q %zmm12, %zmm0, %zmm7
; AVX512-FCP-NEXT:    vpermi2q %zmm2, %zmm21, %zmm25
; AVX512-FCP-NEXT:    vpermi2q %zmm2, %zmm21, %zmm29
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm0, %zmm21
; AVX512-FCP-NEXT:    movb $12, %al
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, %zmm0 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm0 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, %zmm9 {%k1}
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k1}
; AVX512-FCP-NEXT:    movb $48, %al
; AVX512-FCP-NEXT:    kmovw %eax, %k2
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm12 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    # zmm12 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k2}
; AVX512-FCP-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm22 = zmm22[0,1,2,3],zmm26[4,5,6,7]
; AVX512-FCP-NEXT:    vmovdqa64 64(%r8), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm30, %zmm13 {%k2}
; AVX512-FCP-NEXT:    vmovdqa64 128(%r8), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k2}
; AVX512-FCP-NEXT:    vmovdqa64 192(%r8), %zmm26
; AVX512-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm3 = zmm28[0,1,2,3],zmm17[4,5,6,7]
; AVX512-FCP-NEXT:    vmovdqa64 (%r9), %zmm8
; AVX512-FCP-NEXT:    vmovdqa64 %zmm14, %zmm25 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,9,0,4,5,6,7]
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm5, %zmm20
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm5, %zmm18
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm5, %zmm13
; AVX512-FCP-NEXT:    vpermt2q %zmm26, %zmm5, %zmm25
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,9,4,5,6,7]
; AVX512-FCP-NEXT:    vpermt2q %zmm8, %zmm5, %zmm20
; AVX512-FCP-NEXT:    vmovdqa64 64(%r9), %zmm17
; AVX512-FCP-NEXT:    vpermt2q %zmm17, %zmm5, %zmm18
; AVX512-FCP-NEXT:    vmovdqa64 128(%r9), %zmm30
; AVX512-FCP-NEXT:    vpermt2q %zmm30, %zmm5, %zmm13
; AVX512-FCP-NEXT:    vmovdqa64 192(%r9), %zmm14
; AVX512-FCP-NEXT:    vpermt2q %zmm14, %zmm5, %zmm25
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, %zmm29 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,13,0,4,5,6,7]
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm5, %zmm23
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm5, %zmm31
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm5, %zmm4
; AVX512-FCP-NEXT:    vpermt2q %zmm26, %zmm5, %zmm29
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,13,4,5,6,7]
; AVX512-FCP-NEXT:    vpermt2q %zmm8, %zmm5, %zmm23
; AVX512-FCP-NEXT:    vpermt2q %zmm17, %zmm5, %zmm31
; AVX512-FCP-NEXT:    vpermt2q %zmm30, %zmm5, %zmm4
; AVX512-FCP-NEXT:    vpermt2q %zmm14, %zmm5, %zmm29
; AVX512-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm15 = zmm16[0,1,2,3],zmm10[4,5,6,7]
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [14,0,2,3,4,5,15,0]
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm5, %zmm12
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm5, %zmm22
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm5, %zmm3
; AVX512-FCP-NEXT:    vpermt2q %zmm26, %zmm5, %zmm15
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,14,2,3,4,5,6,15]
; AVX512-FCP-NEXT:    vpermt2q %zmm8, %zmm5, %zmm12
; AVX512-FCP-NEXT:    vpermt2q %zmm17, %zmm5, %zmm22
; AVX512-FCP-NEXT:    vpermt2q %zmm30, %zmm5, %zmm3
; AVX512-FCP-NEXT:    vpermt2q %zmm14, %zmm5, %zmm15
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %xmm5
; AVX512-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm11 {%k1}
; AVX512-FCP-NEXT:    vmovdqa 64(%rdx), %xmm5
; AVX512-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm10 {%k1}
; AVX512-FCP-NEXT:    vmovdqa 128(%rdx), %xmm5
; AVX512-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm16 {%k1}
; AVX512-FCP-NEXT:    vmovdqa 192(%rdx), %xmm5
; AVX512-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm19 {%k1}
; AVX512-FCP-NEXT:    vinserti32x4 $2, (%r8), %zmm11, %zmm5
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,1,2,3,4,8,6,7]
; AVX512-FCP-NEXT:    vpermt2q %zmm8, %zmm6, %zmm5
; AVX512-FCP-NEXT:    vinserti32x4 $2, 64(%r8), %zmm10, %zmm10
; AVX512-FCP-NEXT:    vpermt2q %zmm17, %zmm6, %zmm10
; AVX512-FCP-NEXT:    vinserti32x4 $2, 128(%r8), %zmm16, %zmm11
; AVX512-FCP-NEXT:    vpermt2q %zmm30, %zmm6, %zmm11
; AVX512-FCP-NEXT:    vinserti32x4 $2, 192(%r8), %zmm19, %zmm16
; AVX512-FCP-NEXT:    vpermt2q %zmm14, %zmm6, %zmm16
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %ymm6
; AVX512-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm6 = ymm6[1],mem[1],ymm6[3],mem[3]
; AVX512-FCP-NEXT:    vmovdqu64 (%rsp), %zmm19 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm6, %zmm19, %zmm6
; AVX512-FCP-NEXT:    movb $16, %al
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k1}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm19 = [10,0,2,3,4,5,11,0]
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm19, %zmm6
; AVX512-FCP-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX512-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm0, %zmm24, %zmm0
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm9 {%k1}
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm19, %zmm0
; AVX512-FCP-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX512-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3]
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm1, %zmm7, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm28 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm28 {%k1}
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm19, %zmm1
; AVX512-FCP-NEXT:    vmovdqa 192(%rdi), %ymm2
; AVX512-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm21, %zmm2
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm24 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm26, %zmm24 {%k1}
; AVX512-FCP-NEXT:    vpermt2q %zmm26, %zmm19, %zmm2
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm19 = [0,10,2,3,4,5,6,11]
; AVX512-FCP-NEXT:    vpermt2q %zmm8, %zmm19, %zmm6
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [0,1,2,3,4,12,6,7]
; AVX512-FCP-NEXT:    vpermt2q %zmm8, %zmm21, %zmm27
; AVX512-FCP-NEXT:    vpermt2q %zmm17, %zmm19, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm17, %zmm21, %zmm9
; AVX512-FCP-NEXT:    vpermt2q %zmm30, %zmm19, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm30, %zmm21, %zmm28
; AVX512-FCP-NEXT:    vpermt2q %zmm14, %zmm19, %zmm2
; AVX512-FCP-NEXT:    vpermt2q %zmm14, %zmm21, %zmm24
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, 1472(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm29, 1408(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm24, 1344(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, 1280(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, 1216(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, 1088(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, 1024(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm28, 960(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, 896(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, 832(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm22, 704(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm31, 640(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, 576(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, 512(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, 448(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm12, 320(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, 256(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm27, 192(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, 128(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm20, 64(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm16, 1152(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, 768(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, 384(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, (%rax)
; AVX512-FCP-NEXT:    addq $648, %rsp # imm = 0x288
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i64_stride6_vf32:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    subq $648, %rsp # imm = 0x288
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm11
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm5
; AVX512DQ-NEXT:    vmovdqa64 128(%rdi), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 192(%rdi), %zmm19
; AVX512DQ-NEXT:    vmovdqa64 (%rsi), %zmm29
; AVX512DQ-NEXT:    vmovdqa64 64(%rsi), %zmm25
; AVX512DQ-NEXT:    vmovdqa64 128(%rsi), %zmm23
; AVX512DQ-NEXT:    vmovdqa64 192(%rsi), %zmm20
; AVX512DQ-NEXT:    vmovdqa64 (%rdx), %zmm24
; AVX512DQ-NEXT:    vmovdqa64 64(%rdx), %zmm4
; AVX512DQ-NEXT:    vmovdqa64 128(%rdx), %zmm7
; AVX512DQ-NEXT:    vmovdqa64 192(%rdx), %zmm21
; AVX512DQ-NEXT:    vmovdqa64 (%rcx), %zmm18
; AVX512DQ-NEXT:    vmovdqa64 64(%rcx), %zmm13
; AVX512DQ-NEXT:    vmovdqa64 128(%rcx), %zmm12
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm27 = [4,12,5,13,4,12,5,13]
; AVX512DQ-NEXT:    # zmm27 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm19, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm20, %zmm27, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm23, %zmm27, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm25, %zmm27, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermi2q %zmm29, %zmm11, %zmm27
; AVX512DQ-NEXT:    vbroadcasti32x4 {{.*#+}} zmm14 = [2,10,2,10,2,10,2,10]
; AVX512DQ-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm29, %zmm14, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vbroadcasti32x4 {{.*#+}} zmm15 = [6,14,6,14,6,14,6,14]
; AVX512DQ-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm29, %zmm15, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vbroadcasti32x4 {{.*#+}} zmm16 = [7,15,7,15,7,15,7,15]
; AVX512DQ-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm24, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm18, %zmm16, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm29, %zmm16, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm25, %zmm14, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm25, %zmm15, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm26
; AVX512DQ-NEXT:    vpermt2q %zmm13, %zmm16, %zmm26
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm22
; AVX512DQ-NEXT:    vpermt2q %zmm25, %zmm16, %zmm22
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm30
; AVX512DQ-NEXT:    vpermt2q %zmm23, %zmm14, %zmm30
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,8,1,9,0,8,1,9]
; AVX512DQ-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermt2q %zmm29, %zmm1, %zmm11
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm8
; AVX512DQ-NEXT:    vpermt2q %zmm23, %zmm15, %zmm8
; AVX512DQ-NEXT:    vpermt2q %zmm25, %zmm1, %zmm5
; AVX512DQ-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm28
; AVX512DQ-NEXT:    vpermt2q %zmm23, %zmm16, %zmm28
; AVX512DQ-NEXT:    vpermt2q %zmm23, %zmm1, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm17
; AVX512DQ-NEXT:    vpermt2q %zmm12, %zmm16, %zmm17
; AVX512DQ-NEXT:    vpermi2q %zmm20, %zmm19, %zmm14
; AVX512DQ-NEXT:    vpermi2q %zmm20, %zmm19, %zmm15
; AVX512DQ-NEXT:    vmovdqa64 192(%rcx), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 %zmm21, %zmm10
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm16, %zmm10
; AVX512DQ-NEXT:    vpermi2q %zmm20, %zmm19, %zmm16
; AVX512DQ-NEXT:    vpermt2q %zmm20, %zmm1, %zmm19
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,0,4,12]
; AVX512DQ-NEXT:    vmovdqa64 %zmm21, %zmm6
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm1, %zmm6
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm5
; AVX512DQ-NEXT:    vpermt2q %zmm12, %zmm1, %zmm5
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm3
; AVX512DQ-NEXT:    vpermt2q %zmm13, %zmm1, %zmm3
; AVX512DQ-NEXT:    vpermi2q %zmm18, %zmm24, %zmm1
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm25 = [1,9,2,10,1,9,2,10]
; AVX512DQ-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm24, %zmm20
; AVX512DQ-NEXT:    vpermt2q %zmm18, %zmm25, %zmm20
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [5,13,6,14,5,13,6,14]
; AVX512DQ-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm24, %zmm23
; AVX512DQ-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512DQ-NEXT:    vpermt2q %zmm18, %zmm29, %zmm23
; AVX512DQ-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [3,11,3,11,3,11,3,11]
; AVX512DQ-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermt2q %zmm18, %zmm0, %zmm9
; AVX512DQ-NEXT:    vmovdqu64 %zmm9, (%rsp) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm18
; AVX512DQ-NEXT:    vpermt2q %zmm13, %zmm25, %zmm18
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm31
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm24
; AVX512DQ-NEXT:    vpermt2q %zmm13, %zmm29, %zmm31
; AVX512DQ-NEXT:    vpermt2q %zmm13, %zmm0, %zmm24
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm13
; AVX512DQ-NEXT:    vpermt2q %zmm12, %zmm25, %zmm13
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm4
; AVX512DQ-NEXT:    vpermt2q %zmm12, %zmm29, %zmm4
; AVX512DQ-NEXT:    vpermt2q %zmm12, %zmm0, %zmm7
; AVX512DQ-NEXT:    vpermi2q %zmm2, %zmm21, %zmm25
; AVX512DQ-NEXT:    vpermi2q %zmm2, %zmm21, %zmm29
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm0, %zmm21
; AVX512DQ-NEXT:    movb $12, %al
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, %zmm0 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm0 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, %zmm9 {%k1}
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k1}
; AVX512DQ-NEXT:    movb $48, %al
; AVX512DQ-NEXT:    kmovw %eax, %k2
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm12 # 64-byte Folded Reload
; AVX512DQ-NEXT:    # zmm12 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k2}
; AVX512DQ-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512DQ-NEXT:    vshufi64x2 {{.*#+}} zmm22 = zmm22[0,1,2,3],zmm26[4,5,6,7]
; AVX512DQ-NEXT:    vmovdqa64 64(%r8), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 %zmm30, %zmm13 {%k2}
; AVX512DQ-NEXT:    vmovdqa64 128(%r8), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k2}
; AVX512DQ-NEXT:    vmovdqa64 192(%r8), %zmm26
; AVX512DQ-NEXT:    vshufi64x2 {{.*#+}} zmm3 = zmm28[0,1,2,3],zmm17[4,5,6,7]
; AVX512DQ-NEXT:    vmovdqa64 (%r9), %zmm8
; AVX512DQ-NEXT:    vmovdqa64 %zmm14, %zmm25 {%k2}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,9,0,4,5,6,7]
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm5, %zmm20
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm5, %zmm18
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm5, %zmm13
; AVX512DQ-NEXT:    vpermt2q %zmm26, %zmm5, %zmm25
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,9,4,5,6,7]
; AVX512DQ-NEXT:    vpermt2q %zmm8, %zmm5, %zmm20
; AVX512DQ-NEXT:    vmovdqa64 64(%r9), %zmm17
; AVX512DQ-NEXT:    vpermt2q %zmm17, %zmm5, %zmm18
; AVX512DQ-NEXT:    vmovdqa64 128(%r9), %zmm30
; AVX512DQ-NEXT:    vpermt2q %zmm30, %zmm5, %zmm13
; AVX512DQ-NEXT:    vmovdqa64 192(%r9), %zmm14
; AVX512DQ-NEXT:    vpermt2q %zmm14, %zmm5, %zmm25
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, %zmm29 {%k2}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,13,0,4,5,6,7]
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm5, %zmm23
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm5, %zmm31
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm5, %zmm4
; AVX512DQ-NEXT:    vpermt2q %zmm26, %zmm5, %zmm29
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,13,4,5,6,7]
; AVX512DQ-NEXT:    vpermt2q %zmm8, %zmm5, %zmm23
; AVX512DQ-NEXT:    vpermt2q %zmm17, %zmm5, %zmm31
; AVX512DQ-NEXT:    vpermt2q %zmm30, %zmm5, %zmm4
; AVX512DQ-NEXT:    vpermt2q %zmm14, %zmm5, %zmm29
; AVX512DQ-NEXT:    vshufi64x2 {{.*#+}} zmm15 = zmm16[0,1,2,3],zmm10[4,5,6,7]
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [14,0,2,3,4,5,15,0]
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm5, %zmm12
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm5, %zmm22
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm5, %zmm3
; AVX512DQ-NEXT:    vpermt2q %zmm26, %zmm5, %zmm15
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,14,2,3,4,5,6,15]
; AVX512DQ-NEXT:    vpermt2q %zmm8, %zmm5, %zmm12
; AVX512DQ-NEXT:    vpermt2q %zmm17, %zmm5, %zmm22
; AVX512DQ-NEXT:    vpermt2q %zmm30, %zmm5, %zmm3
; AVX512DQ-NEXT:    vpermt2q %zmm14, %zmm5, %zmm15
; AVX512DQ-NEXT:    vmovdqa (%rdx), %xmm5
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm11 {%k1}
; AVX512DQ-NEXT:    vmovdqa 64(%rdx), %xmm5
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm10 {%k1}
; AVX512DQ-NEXT:    vmovdqa 128(%rdx), %xmm5
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm16 {%k1}
; AVX512DQ-NEXT:    vmovdqa 192(%rdx), %xmm5
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm19 {%k1}
; AVX512DQ-NEXT:    vinserti32x4 $2, (%r8), %zmm11, %zmm5
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,1,2,3,4,8,6,7]
; AVX512DQ-NEXT:    vpermt2q %zmm8, %zmm6, %zmm5
; AVX512DQ-NEXT:    vinserti32x4 $2, 64(%r8), %zmm10, %zmm10
; AVX512DQ-NEXT:    vpermt2q %zmm17, %zmm6, %zmm10
; AVX512DQ-NEXT:    vinserti32x4 $2, 128(%r8), %zmm16, %zmm11
; AVX512DQ-NEXT:    vpermt2q %zmm30, %zmm6, %zmm11
; AVX512DQ-NEXT:    vinserti32x4 $2, 192(%r8), %zmm19, %zmm16
; AVX512DQ-NEXT:    vpermt2q %zmm14, %zmm6, %zmm16
; AVX512DQ-NEXT:    vmovdqa (%rdi), %ymm6
; AVX512DQ-NEXT:    vpunpckhqdq {{.*#+}} ymm6 = ymm6[1],mem[1],ymm6[3],mem[3]
; AVX512DQ-NEXT:    vmovdqu64 (%rsp), %zmm19 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm6, %zmm19, %zmm6
; AVX512DQ-NEXT:    movb $16, %al
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k1}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm19 = [10,0,2,3,4,5,11,0]
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm19, %zmm6
; AVX512DQ-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX512DQ-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm0, %zmm24, %zmm0
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm9 {%k1}
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm19, %zmm0
; AVX512DQ-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX512DQ-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3]
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm1, %zmm7, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm28 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm28 {%k1}
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm19, %zmm1
; AVX512DQ-NEXT:    vmovdqa 192(%rdi), %ymm2
; AVX512DQ-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm2, %zmm21, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm24 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm26, %zmm24 {%k1}
; AVX512DQ-NEXT:    vpermt2q %zmm26, %zmm19, %zmm2
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm19 = [0,10,2,3,4,5,6,11]
; AVX512DQ-NEXT:    vpermt2q %zmm8, %zmm19, %zmm6
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [0,1,2,3,4,12,6,7]
; AVX512DQ-NEXT:    vpermt2q %zmm8, %zmm21, %zmm27
; AVX512DQ-NEXT:    vpermt2q %zmm17, %zmm19, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm17, %zmm21, %zmm9
; AVX512DQ-NEXT:    vpermt2q %zmm30, %zmm19, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm30, %zmm21, %zmm28
; AVX512DQ-NEXT:    vpermt2q %zmm14, %zmm19, %zmm2
; AVX512DQ-NEXT:    vpermt2q %zmm14, %zmm21, %zmm24
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, 1472(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm29, 1408(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm24, 1344(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, 1280(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, 1216(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, 1088(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, 1024(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm28, 960(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, 896(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm13, 832(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm22, 704(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm31, 640(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, 576(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, 512(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, 448(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm12, 320(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, 256(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm27, 192(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, 128(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm20, 64(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm16, 1152(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, 768(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, 384(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, (%rax)
; AVX512DQ-NEXT:    addq $648, %rsp # imm = 0x288
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i64_stride6_vf32:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    subq $648, %rsp # imm = 0x288
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm19
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rsi), %zmm29
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm25
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm23
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm20
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdx), %zmm24
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm21
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rcx), %zmm18
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rcx), %zmm12
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm27 = [4,12,5,13,4,12,5,13]
; AVX512DQ-FCP-NEXT:    # zmm27 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm19, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm20, %zmm27, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm23, %zmm27, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm25, %zmm27, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm29, %zmm11, %zmm27
; AVX512DQ-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm14 = [2,10,2,10,2,10,2,10]
; AVX512DQ-FCP-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm29, %zmm14, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm15 = [6,14,6,14,6,14,6,14]
; AVX512DQ-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm29, %zmm15, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm16 = [7,15,7,15,7,15,7,15]
; AVX512DQ-FCP-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm24, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm18, %zmm16, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm29, %zmm16, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm25, %zmm14, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm25, %zmm15, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm26
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm13, %zmm16, %zmm26
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm22
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm25, %zmm16, %zmm22
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm30
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm23, %zmm14, %zmm30
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,8,1,9,0,8,1,9]
; AVX512DQ-FCP-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm29, %zmm1, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm8
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm23, %zmm15, %zmm8
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm25, %zmm1, %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm28
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm23, %zmm16, %zmm28
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm23, %zmm1, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm17
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm12, %zmm16, %zmm17
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm20, %zmm19, %zmm14
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm20, %zmm19, %zmm15
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rcx), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm21, %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm10
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm20, %zmm19, %zmm16
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm20, %zmm1, %zmm19
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,0,4,12]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm21, %zmm6
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm1, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm5
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm12, %zmm1, %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm13, %zmm1, %zmm3
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm18, %zmm24, %zmm1
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm25 = [1,9,2,10,1,9,2,10]
; AVX512DQ-FCP-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm24, %zmm20
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm18, %zmm25, %zmm20
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [5,13,6,14,5,13,6,14]
; AVX512DQ-FCP-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm24, %zmm23
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm18, %zmm29, %zmm23
; AVX512DQ-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [3,11,3,11,3,11,3,11]
; AVX512DQ-FCP-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm18, %zmm0, %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm9, (%rsp) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm18
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm13, %zmm25, %zmm18
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm31
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm24
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm13, %zmm29, %zmm31
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm13, %zmm0, %zmm24
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm13
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm12, %zmm25, %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm12, %zmm29, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm12, %zmm0, %zmm7
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm2, %zmm21, %zmm25
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm2, %zmm21, %zmm29
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm0, %zmm21
; AVX512DQ-FCP-NEXT:    movb $12, %al
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, %zmm0 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm0 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, %zmm9 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k1}
; AVX512DQ-FCP-NEXT:    movb $48, %al
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k2
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm12 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    # zmm12 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512DQ-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm22 = zmm22[0,1,2,3],zmm26[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%r8), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm30, %zmm13 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%r8), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%r8), %zmm26
; AVX512DQ-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm3 = zmm28[0,1,2,3],zmm17[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%r9), %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm14, %zmm25 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,9,0,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm5, %zmm20
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm5, %zmm18
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm5, %zmm13
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm26, %zmm5, %zmm25
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,9,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm8, %zmm5, %zmm20
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%r9), %zmm17
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm17, %zmm5, %zmm18
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%r9), %zmm30
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm30, %zmm5, %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%r9), %zmm14
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm14, %zmm5, %zmm25
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, %zmm29 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,13,0,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm5, %zmm23
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm5, %zmm31
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm5, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm26, %zmm5, %zmm29
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,13,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm8, %zmm5, %zmm23
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm17, %zmm5, %zmm31
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm30, %zmm5, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm14, %zmm5, %zmm29
; AVX512DQ-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm15 = zmm16[0,1,2,3],zmm10[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [14,0,2,3,4,5,15,0]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm5, %zmm12
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm5, %zmm22
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm5, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm26, %zmm5, %zmm15
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,14,2,3,4,5,6,15]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm8, %zmm5, %zmm12
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm17, %zmm5, %zmm22
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm30, %zmm5, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm14, %zmm5, %zmm15
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %xmm5
; AVX512DQ-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm11 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa 64(%rdx), %xmm5
; AVX512DQ-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm10 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa 128(%rdx), %xmm5
; AVX512DQ-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm16 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa 192(%rdx), %xmm5
; AVX512DQ-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm19 {%k1}
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, (%r8), %zmm11, %zmm5
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,1,2,3,4,8,6,7]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm8, %zmm6, %zmm5
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, 64(%r8), %zmm10, %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm17, %zmm6, %zmm10
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, 128(%r8), %zmm16, %zmm11
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm30, %zmm6, %zmm11
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, 192(%r8), %zmm19, %zmm16
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm14, %zmm6, %zmm16
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %ymm6
; AVX512DQ-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm6 = ymm6[1],mem[1],ymm6[3],mem[3]
; AVX512DQ-FCP-NEXT:    vmovdqu64 (%rsp), %zmm19 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm6, %zmm19, %zmm6
; AVX512DQ-FCP-NEXT:    movb $16, %al
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k1}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm19 = [10,0,2,3,4,5,11,0]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm19, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX512DQ-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm0, %zmm24, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm9 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm19, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX512DQ-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3]
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm1, %zmm7, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm28 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm28 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm19, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa 192(%rdi), %ymm2
; AVX512DQ-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm21, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm24 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm26, %zmm24 {%k1}
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm26, %zmm19, %zmm2
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm19 = [0,10,2,3,4,5,6,11]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm8, %zmm19, %zmm6
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [0,1,2,3,4,12,6,7]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm8, %zmm21, %zmm27
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm17, %zmm19, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm17, %zmm21, %zmm9
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm30, %zmm19, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm30, %zmm21, %zmm28
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm14, %zmm19, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm14, %zmm21, %zmm24
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, 1472(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm29, 1408(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm24, 1344(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, 1280(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, 1216(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, 1088(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, 1024(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm28, 960(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, 896(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, 832(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm22, 704(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm31, 640(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, 576(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, 512(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, 448(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm12, 320(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, 256(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm27, 192(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, 128(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm20, 64(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm16, 1152(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, 768(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, 384(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, (%rax)
; AVX512DQ-FCP-NEXT:    addq $648, %rsp # imm = 0x288
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i64_stride6_vf32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    subq $648, %rsp # imm = 0x288
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm11
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm5
; AVX512BW-NEXT:    vmovdqa64 128(%rdi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %zmm19
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm29
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm25
; AVX512BW-NEXT:    vmovdqa64 128(%rsi), %zmm23
; AVX512BW-NEXT:    vmovdqa64 192(%rsi), %zmm20
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm24
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %zmm4
; AVX512BW-NEXT:    vmovdqa64 128(%rdx), %zmm7
; AVX512BW-NEXT:    vmovdqa64 192(%rdx), %zmm21
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm18
; AVX512BW-NEXT:    vmovdqa64 64(%rcx), %zmm13
; AVX512BW-NEXT:    vmovdqa64 128(%rcx), %zmm12
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm27 = [4,12,5,13,4,12,5,13]
; AVX512BW-NEXT:    # zmm27 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm20, %zmm27, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm23, %zmm27, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm27, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2q %zmm29, %zmm11, %zmm27
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm14 = [2,10,2,10,2,10,2,10]
; AVX512BW-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm14, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm15 = [6,14,6,14,6,14,6,14]
; AVX512BW-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm15, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm16 = [7,15,7,15,7,15,7,15]
; AVX512BW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm16, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm16, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm14, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm15, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm26
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm16, %zmm26
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm22
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm16, %zmm22
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm30
; AVX512BW-NEXT:    vpermt2q %zmm23, %zmm14, %zmm30
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,8,1,9,0,8,1,9]
; AVX512BW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm1, %zmm11
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm23, %zmm15, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm25, %zmm1, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm28
; AVX512BW-NEXT:    vpermt2q %zmm23, %zmm16, %zmm28
; AVX512BW-NEXT:    vpermt2q %zmm23, %zmm1, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm17
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm16, %zmm17
; AVX512BW-NEXT:    vpermi2q %zmm20, %zmm19, %zmm14
; AVX512BW-NEXT:    vpermi2q %zmm20, %zmm19, %zmm15
; AVX512BW-NEXT:    vmovdqa64 192(%rcx), %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm21, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm10
; AVX512BW-NEXT:    vpermi2q %zmm20, %zmm19, %zmm16
; AVX512BW-NEXT:    vpermt2q %zmm20, %zmm1, %zmm19
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,0,4,12]
; AVX512BW-NEXT:    vmovdqa64 %zmm21, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm1, %zmm6
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm5
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm1, %zmm5
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm1, %zmm3
; AVX512BW-NEXT:    vpermi2q %zmm18, %zmm24, %zmm1
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm25 = [1,9,2,10,1,9,2,10]
; AVX512BW-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm20
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm25, %zmm20
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [5,13,6,14,5,13,6,14]
; AVX512BW-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm23
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm29, %zmm23
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [3,11,3,11,3,11,3,11]
; AVX512BW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm18, %zmm0, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm18
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm25, %zmm18
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm31
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm24
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm29, %zmm31
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm0, %zmm24
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm13
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm25, %zmm13
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm29, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm12, %zmm0, %zmm7
; AVX512BW-NEXT:    vpermi2q %zmm2, %zmm21, %zmm25
; AVX512BW-NEXT:    vpermi2q %zmm2, %zmm21, %zmm29
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm0, %zmm21
; AVX512BW-NEXT:    movb $12, %al
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm0 {%k1}
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm0 {%k1}
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm9 {%k1}
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k1}
; AVX512BW-NEXT:    movb $48, %al
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm12 # 64-byte Folded Reload
; AVX512BW-NEXT:    # zmm12 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k2}
; AVX512BW-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm22 = zmm22[0,1,2,3],zmm26[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 64(%r8), %zmm1
; AVX512BW-NEXT:    vmovdqa64 %zmm30, %zmm13 {%k2}
; AVX512BW-NEXT:    vmovdqa64 128(%r8), %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k2}
; AVX512BW-NEXT:    vmovdqa64 192(%r8), %zmm26
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm3 = zmm28[0,1,2,3],zmm17[4,5,6,7]
; AVX512BW-NEXT:    vmovdqa64 (%r9), %zmm8
; AVX512BW-NEXT:    vmovdqa64 %zmm14, %zmm25 {%k2}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,9,0,4,5,6,7]
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm5, %zmm20
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm5, %zmm18
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm5, %zmm13
; AVX512BW-NEXT:    vpermt2q %zmm26, %zmm5, %zmm25
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,9,4,5,6,7]
; AVX512BW-NEXT:    vpermt2q %zmm8, %zmm5, %zmm20
; AVX512BW-NEXT:    vmovdqa64 64(%r9), %zmm17
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm5, %zmm18
; AVX512BW-NEXT:    vmovdqa64 128(%r9), %zmm30
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm5, %zmm13
; AVX512BW-NEXT:    vmovdqa64 192(%r9), %zmm14
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm5, %zmm25
; AVX512BW-NEXT:    vmovdqa64 %zmm15, %zmm29 {%k2}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,13,0,4,5,6,7]
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm5, %zmm23
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm5, %zmm31
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm5, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm26, %zmm5, %zmm29
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,13,4,5,6,7]
; AVX512BW-NEXT:    vpermt2q %zmm8, %zmm5, %zmm23
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm5, %zmm31
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm5, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm5, %zmm29
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm15 = zmm16[0,1,2,3],zmm10[4,5,6,7]
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [14,0,2,3,4,5,15,0]
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm5, %zmm12
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm5, %zmm22
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm5, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm26, %zmm5, %zmm15
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,14,2,3,4,5,6,15]
; AVX512BW-NEXT:    vpermt2q %zmm8, %zmm5, %zmm12
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm5, %zmm22
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm5, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm5, %zmm15
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm5
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm11 {%k1}
; AVX512BW-NEXT:    vmovdqa 64(%rdx), %xmm5
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm10 {%k1}
; AVX512BW-NEXT:    vmovdqa 128(%rdx), %xmm5
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm16 {%k1}
; AVX512BW-NEXT:    vmovdqa 192(%rdx), %xmm5
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm19 {%k1}
; AVX512BW-NEXT:    vinserti32x4 $2, (%r8), %zmm11, %zmm5
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,1,2,3,4,8,6,7]
; AVX512BW-NEXT:    vpermt2q %zmm8, %zmm6, %zmm5
; AVX512BW-NEXT:    vinserti32x4 $2, 64(%r8), %zmm10, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm6, %zmm10
; AVX512BW-NEXT:    vinserti32x4 $2, 128(%r8), %zmm16, %zmm11
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm6, %zmm11
; AVX512BW-NEXT:    vinserti32x4 $2, 192(%r8), %zmm19, %zmm16
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm6, %zmm16
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm6
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm6 = ymm6[1],mem[1],ymm6[3],mem[3]
; AVX512BW-NEXT:    vmovdqu64 (%rsp), %zmm19 # 64-byte Reload
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm6, %zmm19, %zmm6
; AVX512BW-NEXT:    movb $16, %al
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k1}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm19 = [10,0,2,3,4,5,11,0]
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm19, %zmm6
; AVX512BW-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm24, %zmm0
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm9 {%k1}
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm19, %zmm0
; AVX512BW-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm7, %zmm1
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm28 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm28 {%k1}
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm19, %zmm1
; AVX512BW-NEXT:    vmovdqa 192(%rdi), %ymm2
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm21, %zmm2
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm24 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm26, %zmm24 {%k1}
; AVX512BW-NEXT:    vpermt2q %zmm26, %zmm19, %zmm2
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm19 = [0,10,2,3,4,5,6,11]
; AVX512BW-NEXT:    vpermt2q %zmm8, %zmm19, %zmm6
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [0,1,2,3,4,12,6,7]
; AVX512BW-NEXT:    vpermt2q %zmm8, %zmm21, %zmm27
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm19, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm17, %zmm21, %zmm9
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm19, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm21, %zmm28
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm19, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm21, %zmm24
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    vmovdqa64 %zmm15, 1472(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm29, 1408(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm24, 1344(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 1280(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm25, 1216(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm3, 1088(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 1024(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm28, 960(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm1, 896(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm13, 832(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm22, 704(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm31, 640(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm9, 576(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 512(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm18, 448(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm12, 320(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm23, 256(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm27, 192(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm6, 128(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm20, 64(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm16, 1152(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm11, 768(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 384(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm5, (%rax)
; AVX512BW-NEXT:    addq $648, %rsp # imm = 0x288
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i64_stride6_vf32:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    subq $648, %rsp # imm = 0x288
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm11
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm19
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm29
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm25
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm23
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm20
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm24
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm7
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm21
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm18
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm13
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rcx), %zmm12
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm27 = [4,12,5,13,4,12,5,13]
; AVX512BW-FCP-NEXT:    # zmm27 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm19, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm20, %zmm27, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm23, %zmm27, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm25, %zmm27, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermi2q %zmm29, %zmm11, %zmm27
; AVX512BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm14 = [2,10,2,10,2,10,2,10]
; AVX512BW-FCP-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm29, %zmm14, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm15 = [6,14,6,14,6,14,6,14]
; AVX512BW-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm29, %zmm15, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm16 = [7,15,7,15,7,15,7,15]
; AVX512BW-FCP-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm24, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm18, %zmm16, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm29, %zmm16, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm25, %zmm14, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm25, %zmm15, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm26
; AVX512BW-FCP-NEXT:    vpermt2q %zmm13, %zmm16, %zmm26
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm22
; AVX512BW-FCP-NEXT:    vpermt2q %zmm25, %zmm16, %zmm22
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm30
; AVX512BW-FCP-NEXT:    vpermt2q %zmm23, %zmm14, %zmm30
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,8,1,9,0,8,1,9]
; AVX512BW-FCP-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm29, %zmm1, %zmm11
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm8
; AVX512BW-FCP-NEXT:    vpermt2q %zmm23, %zmm15, %zmm8
; AVX512BW-FCP-NEXT:    vpermt2q %zmm25, %zmm1, %zmm5
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm28
; AVX512BW-FCP-NEXT:    vpermt2q %zmm23, %zmm16, %zmm28
; AVX512BW-FCP-NEXT:    vpermt2q %zmm23, %zmm1, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm17
; AVX512BW-FCP-NEXT:    vpermt2q %zmm12, %zmm16, %zmm17
; AVX512BW-FCP-NEXT:    vpermi2q %zmm20, %zmm19, %zmm14
; AVX512BW-FCP-NEXT:    vpermi2q %zmm20, %zmm19, %zmm15
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rcx), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm21, %zmm10
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm10
; AVX512BW-FCP-NEXT:    vpermi2q %zmm20, %zmm19, %zmm16
; AVX512BW-FCP-NEXT:    vpermt2q %zmm20, %zmm1, %zmm19
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,0,4,12]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm21, %zmm6
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm1, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm5
; AVX512BW-FCP-NEXT:    vpermt2q %zmm12, %zmm1, %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm3
; AVX512BW-FCP-NEXT:    vpermt2q %zmm13, %zmm1, %zmm3
; AVX512BW-FCP-NEXT:    vpermi2q %zmm18, %zmm24, %zmm1
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm25 = [1,9,2,10,1,9,2,10]
; AVX512BW-FCP-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm24, %zmm20
; AVX512BW-FCP-NEXT:    vpermt2q %zmm18, %zmm25, %zmm20
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [5,13,6,14,5,13,6,14]
; AVX512BW-FCP-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm24, %zmm23
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512BW-FCP-NEXT:    vpermt2q %zmm18, %zmm29, %zmm23
; AVX512BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [3,11,3,11,3,11,3,11]
; AVX512BW-FCP-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm18, %zmm0, %zmm9
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm9, (%rsp) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm18
; AVX512BW-FCP-NEXT:    vpermt2q %zmm13, %zmm25, %zmm18
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm31
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm24
; AVX512BW-FCP-NEXT:    vpermt2q %zmm13, %zmm29, %zmm31
; AVX512BW-FCP-NEXT:    vpermt2q %zmm13, %zmm0, %zmm24
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm13
; AVX512BW-FCP-NEXT:    vpermt2q %zmm12, %zmm25, %zmm13
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2q %zmm12, %zmm29, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2q %zmm12, %zmm0, %zmm7
; AVX512BW-FCP-NEXT:    vpermi2q %zmm2, %zmm21, %zmm25
; AVX512BW-FCP-NEXT:    vpermi2q %zmm2, %zmm21, %zmm29
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm0, %zmm21
; AVX512BW-FCP-NEXT:    movb $12, %al
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm0 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm0 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm9 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k1}
; AVX512BW-FCP-NEXT:    movb $48, %al
; AVX512BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k2}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k2}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm12 # 64-byte Folded Reload
; AVX512BW-FCP-NEXT:    # zmm12 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k2}
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k2}
; AVX512BW-FCP-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm22 = zmm22[0,1,2,3],zmm26[4,5,6,7]
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%r8), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm30, %zmm13 {%k2}
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%r8), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k2}
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%r8), %zmm26
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm3 = zmm28[0,1,2,3],zmm17[4,5,6,7]
; AVX512BW-FCP-NEXT:    vmovdqa64 (%r9), %zmm8
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm14, %zmm25 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,9,0,4,5,6,7]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm5, %zmm20
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm5, %zmm18
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm5, %zmm13
; AVX512BW-FCP-NEXT:    vpermt2q %zmm26, %zmm5, %zmm25
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,9,4,5,6,7]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm8, %zmm5, %zmm20
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%r9), %zmm17
; AVX512BW-FCP-NEXT:    vpermt2q %zmm17, %zmm5, %zmm18
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%r9), %zmm30
; AVX512BW-FCP-NEXT:    vpermt2q %zmm30, %zmm5, %zmm13
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%r9), %zmm14
; AVX512BW-FCP-NEXT:    vpermt2q %zmm14, %zmm5, %zmm25
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm29 {%k2}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,13,0,4,5,6,7]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm5, %zmm23
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm5, %zmm31
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm5, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2q %zmm26, %zmm5, %zmm29
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,13,4,5,6,7]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm8, %zmm5, %zmm23
; AVX512BW-FCP-NEXT:    vpermt2q %zmm17, %zmm5, %zmm31
; AVX512BW-FCP-NEXT:    vpermt2q %zmm30, %zmm5, %zmm4
; AVX512BW-FCP-NEXT:    vpermt2q %zmm14, %zmm5, %zmm29
; AVX512BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm15 = zmm16[0,1,2,3],zmm10[4,5,6,7]
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [14,0,2,3,4,5,15,0]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm5, %zmm12
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm5, %zmm22
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm5, %zmm3
; AVX512BW-FCP-NEXT:    vpermt2q %zmm26, %zmm5, %zmm15
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,14,2,3,4,5,6,15]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm8, %zmm5, %zmm12
; AVX512BW-FCP-NEXT:    vpermt2q %zmm17, %zmm5, %zmm22
; AVX512BW-FCP-NEXT:    vpermt2q %zmm30, %zmm5, %zmm3
; AVX512BW-FCP-NEXT:    vpermt2q %zmm14, %zmm5, %zmm15
; AVX512BW-FCP-NEXT:    vmovdqa (%rdx), %xmm5
; AVX512BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512BW-FCP-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm11 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa 64(%rdx), %xmm5
; AVX512BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm10 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa 128(%rdx), %xmm5
; AVX512BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm16 {%k1}
; AVX512BW-FCP-NEXT:    vmovdqa 192(%rdx), %xmm5
; AVX512BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512BW-FCP-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512BW-FCP-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm19 {%k1}
; AVX512BW-FCP-NEXT:    vinserti32x4 $2, (%r8), %zmm11, %zmm5
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,1,2,3,4,8,6,7]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm8, %zmm6, %zmm5
; AVX512BW-FCP-NEXT:    vinserti32x4 $2, 64(%r8), %zmm10, %zmm10
; AVX512BW-FCP-NEXT:    vpermt2q %zmm17, %zmm6, %zmm10
; AVX512BW-FCP-NEXT:    vinserti32x4 $2, 128(%r8), %zmm16, %zmm11
; AVX512BW-FCP-NEXT:    vpermt2q %zmm30, %zmm6, %zmm11
; AVX512BW-FCP-NEXT:    vinserti32x4 $2, 192(%r8), %zmm19, %zmm16
; AVX512BW-FCP-NEXT:    vpermt2q %zmm14, %zmm6, %zmm16
; AVX512BW-FCP-NEXT:    vmovdqa (%rdi), %ymm6
; AVX512BW-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm6 = ymm6[1],mem[1],ymm6[3],mem[3]
; AVX512BW-FCP-NEXT:    vmovdqu64 (%rsp), %zmm19 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vinserti64x4 $0, %ymm6, %zmm19, %zmm6
; AVX512BW-FCP-NEXT:    movb $16, %al
; AVX512BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k1}
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm19 = [10,0,2,3,4,5,11,0]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm19, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX512BW-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512BW-FCP-NEXT:    vinserti64x4 $0, %ymm0, %zmm24, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm9 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm19, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX512BW-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3]
; AVX512BW-FCP-NEXT:    vinserti64x4 $0, %ymm1, %zmm7, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm28 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm28 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm19, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa 192(%rdi), %ymm2
; AVX512BW-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512BW-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm21, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm24 # 64-byte Reload
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm26, %zmm24 {%k1}
; AVX512BW-FCP-NEXT:    vpermt2q %zmm26, %zmm19, %zmm2
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm19 = [0,10,2,3,4,5,6,11]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm8, %zmm19, %zmm6
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [0,1,2,3,4,12,6,7]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm8, %zmm21, %zmm27
; AVX512BW-FCP-NEXT:    vpermt2q %zmm17, %zmm19, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm17, %zmm21, %zmm9
; AVX512BW-FCP-NEXT:    vpermt2q %zmm30, %zmm19, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm30, %zmm21, %zmm28
; AVX512BW-FCP-NEXT:    vpermt2q %zmm14, %zmm19, %zmm2
; AVX512BW-FCP-NEXT:    vpermt2q %zmm14, %zmm21, %zmm24
; AVX512BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, 1472(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm29, 1408(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm24, 1344(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, 1280(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm25, 1216(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm3, 1088(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, 1024(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm28, 960(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, 896(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm13, 832(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm22, 704(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm31, 640(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, 576(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm0, 512(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, 448(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm12, 320(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm23, 256(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm27, 192(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, 128(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm20, 64(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm16, 1152(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm11, 768(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, 384(%rax)
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, (%rax)
; AVX512BW-FCP-NEXT:    addq $648, %rsp # imm = 0x288
; AVX512BW-FCP-NEXT:    vzeroupper
; AVX512BW-FCP-NEXT:    retq
;
; AVX512DQ-BW-LABEL: store_i64_stride6_vf32:
; AVX512DQ-BW:       # %bb.0:
; AVX512DQ-BW-NEXT:    subq $648, %rsp # imm = 0x288
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdi), %zmm11
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdi), %zmm5
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rdi), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rdi), %zmm19
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rsi), %zmm29
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rsi), %zmm25
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rsi), %zmm23
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rsi), %zmm20
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rdx), %zmm24
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rdx), %zmm4
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rdx), %zmm7
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rdx), %zmm21
; AVX512DQ-BW-NEXT:    vmovdqa64 (%rcx), %zmm18
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%rcx), %zmm13
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%rcx), %zmm12
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm27 = [4,12,5,13,4,12,5,13]
; AVX512DQ-BW-NEXT:    # zmm27 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm19, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm20, %zmm27, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm23, %zmm27, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm25, %zmm27, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vpermi2q %zmm29, %zmm11, %zmm27
; AVX512DQ-BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm14 = [2,10,2,10,2,10,2,10]
; AVX512DQ-BW-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm29, %zmm14, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm15 = [6,14,6,14,6,14,6,14]
; AVX512DQ-BW-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm29, %zmm15, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm16 = [7,15,7,15,7,15,7,15]
; AVX512DQ-BW-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm24, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm18, %zmm16, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm29, %zmm16, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm25, %zmm14, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm25, %zmm15, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm26
; AVX512DQ-BW-NEXT:    vpermt2q %zmm13, %zmm16, %zmm26
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, %zmm22
; AVX512DQ-BW-NEXT:    vpermt2q %zmm25, %zmm16, %zmm22
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm30
; AVX512DQ-BW-NEXT:    vpermt2q %zmm23, %zmm14, %zmm30
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,8,1,9,0,8,1,9]
; AVX512DQ-BW-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm29, %zmm1, %zmm11
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm8
; AVX512DQ-BW-NEXT:    vpermt2q %zmm23, %zmm15, %zmm8
; AVX512DQ-BW-NEXT:    vpermt2q %zmm25, %zmm1, %zmm5
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm28
; AVX512DQ-BW-NEXT:    vpermt2q %zmm23, %zmm16, %zmm28
; AVX512DQ-BW-NEXT:    vpermt2q %zmm23, %zmm1, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, %zmm17
; AVX512DQ-BW-NEXT:    vpermt2q %zmm12, %zmm16, %zmm17
; AVX512DQ-BW-NEXT:    vpermi2q %zmm20, %zmm19, %zmm14
; AVX512DQ-BW-NEXT:    vpermi2q %zmm20, %zmm19, %zmm15
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%rcx), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm21, %zmm10
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm16, %zmm10
; AVX512DQ-BW-NEXT:    vpermi2q %zmm20, %zmm19, %zmm16
; AVX512DQ-BW-NEXT:    vpermt2q %zmm20, %zmm1, %zmm19
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,0,4,12]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm21, %zmm6
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm1, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, %zmm5
; AVX512DQ-BW-NEXT:    vpermt2q %zmm12, %zmm1, %zmm5
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm3
; AVX512DQ-BW-NEXT:    vpermt2q %zmm13, %zmm1, %zmm3
; AVX512DQ-BW-NEXT:    vpermi2q %zmm18, %zmm24, %zmm1
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm25 = [1,9,2,10,1,9,2,10]
; AVX512DQ-BW-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm24, %zmm20
; AVX512DQ-BW-NEXT:    vpermt2q %zmm18, %zmm25, %zmm20
; AVX512DQ-BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [5,13,6,14,5,13,6,14]
; AVX512DQ-BW-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm24, %zmm23
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512DQ-BW-NEXT:    vpermt2q %zmm18, %zmm29, %zmm23
; AVX512DQ-BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [3,11,3,11,3,11,3,11]
; AVX512DQ-BW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm18, %zmm0, %zmm9
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm9, (%rsp) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm18
; AVX512DQ-BW-NEXT:    vpermt2q %zmm13, %zmm25, %zmm18
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm31
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, %zmm24
; AVX512DQ-BW-NEXT:    vpermt2q %zmm13, %zmm29, %zmm31
; AVX512DQ-BW-NEXT:    vpermt2q %zmm13, %zmm0, %zmm24
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, %zmm13
; AVX512DQ-BW-NEXT:    vpermt2q %zmm12, %zmm25, %zmm13
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm7, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2q %zmm12, %zmm29, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2q %zmm12, %zmm0, %zmm7
; AVX512DQ-BW-NEXT:    vpermi2q %zmm2, %zmm21, %zmm25
; AVX512DQ-BW-NEXT:    vpermi2q %zmm2, %zmm21, %zmm29
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm0, %zmm21
; AVX512DQ-BW-NEXT:    movb $12, %al
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, %zmm0 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, %zmm0 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, %zmm9 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k1}
; AVX512DQ-BW-NEXT:    movb $48, %al
; AVX512DQ-BW-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k2}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k2}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm12 # 64-byte Folded Reload
; AVX512DQ-BW-NEXT:    # zmm12 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k2}
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k2}
; AVX512DQ-BW-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512DQ-BW-NEXT:    vshufi64x2 {{.*#+}} zmm22 = zmm22[0,1,2,3],zmm26[4,5,6,7]
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%r8), %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm30, %zmm13 {%k2}
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%r8), %zmm2
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k2}
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%r8), %zmm26
; AVX512DQ-BW-NEXT:    vshufi64x2 {{.*#+}} zmm3 = zmm28[0,1,2,3],zmm17[4,5,6,7]
; AVX512DQ-BW-NEXT:    vmovdqa64 (%r9), %zmm8
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm14, %zmm25 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,9,0,4,5,6,7]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm5, %zmm20
; AVX512DQ-BW-NEXT:    vpermt2q %zmm1, %zmm5, %zmm18
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm5, %zmm13
; AVX512DQ-BW-NEXT:    vpermt2q %zmm26, %zmm5, %zmm25
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,9,4,5,6,7]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm8, %zmm5, %zmm20
; AVX512DQ-BW-NEXT:    vmovdqa64 64(%r9), %zmm17
; AVX512DQ-BW-NEXT:    vpermt2q %zmm17, %zmm5, %zmm18
; AVX512DQ-BW-NEXT:    vmovdqa64 128(%r9), %zmm30
; AVX512DQ-BW-NEXT:    vpermt2q %zmm30, %zmm5, %zmm13
; AVX512DQ-BW-NEXT:    vmovdqa64 192(%r9), %zmm14
; AVX512DQ-BW-NEXT:    vpermt2q %zmm14, %zmm5, %zmm25
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm15, %zmm29 {%k2}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,13,0,4,5,6,7]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm5, %zmm23
; AVX512DQ-BW-NEXT:    vpermt2q %zmm1, %zmm5, %zmm31
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm5, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2q %zmm26, %zmm5, %zmm29
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,13,4,5,6,7]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm8, %zmm5, %zmm23
; AVX512DQ-BW-NEXT:    vpermt2q %zmm17, %zmm5, %zmm31
; AVX512DQ-BW-NEXT:    vpermt2q %zmm30, %zmm5, %zmm4
; AVX512DQ-BW-NEXT:    vpermt2q %zmm14, %zmm5, %zmm29
; AVX512DQ-BW-NEXT:    vshufi64x2 {{.*#+}} zmm15 = zmm16[0,1,2,3],zmm10[4,5,6,7]
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [14,0,2,3,4,5,15,0]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm5, %zmm12
; AVX512DQ-BW-NEXT:    vpermt2q %zmm1, %zmm5, %zmm22
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm5, %zmm3
; AVX512DQ-BW-NEXT:    vpermt2q %zmm26, %zmm5, %zmm15
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,14,2,3,4,5,6,15]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm8, %zmm5, %zmm12
; AVX512DQ-BW-NEXT:    vpermt2q %zmm17, %zmm5, %zmm22
; AVX512DQ-BW-NEXT:    vpermt2q %zmm30, %zmm5, %zmm3
; AVX512DQ-BW-NEXT:    vpermt2q %zmm14, %zmm5, %zmm15
; AVX512DQ-BW-NEXT:    vmovdqa (%rdx), %xmm5
; AVX512DQ-BW-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-BW-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm11 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa 64(%rdx), %xmm5
; AVX512DQ-BW-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm10 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa 128(%rdx), %xmm5
; AVX512DQ-BW-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm16 {%k1}
; AVX512DQ-BW-NEXT:    vmovdqa 192(%rdx), %xmm5
; AVX512DQ-BW-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512DQ-BW-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-BW-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm19 {%k1}
; AVX512DQ-BW-NEXT:    vinserti32x4 $2, (%r8), %zmm11, %zmm5
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,1,2,3,4,8,6,7]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm8, %zmm6, %zmm5
; AVX512DQ-BW-NEXT:    vinserti32x4 $2, 64(%r8), %zmm10, %zmm10
; AVX512DQ-BW-NEXT:    vpermt2q %zmm17, %zmm6, %zmm10
; AVX512DQ-BW-NEXT:    vinserti32x4 $2, 128(%r8), %zmm16, %zmm11
; AVX512DQ-BW-NEXT:    vpermt2q %zmm30, %zmm6, %zmm11
; AVX512DQ-BW-NEXT:    vinserti32x4 $2, 192(%r8), %zmm19, %zmm16
; AVX512DQ-BW-NEXT:    vpermt2q %zmm14, %zmm6, %zmm16
; AVX512DQ-BW-NEXT:    vmovdqa (%rdi), %ymm6
; AVX512DQ-BW-NEXT:    vpunpckhqdq {{.*#+}} ymm6 = ymm6[1],mem[1],ymm6[3],mem[3]
; AVX512DQ-BW-NEXT:    vmovdqu64 (%rsp), %zmm19 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vinserti64x4 $0, %ymm6, %zmm19, %zmm6
; AVX512DQ-BW-NEXT:    movb $16, %al
; AVX512DQ-BW-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k1}
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm19 = [10,0,2,3,4,5,11,0]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm0, %zmm19, %zmm6
; AVX512DQ-BW-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX512DQ-BW-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512DQ-BW-NEXT:    vinserti64x4 $0, %ymm0, %zmm24, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, %zmm9 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm1, %zmm19, %zmm0
; AVX512DQ-BW-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX512DQ-BW-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3]
; AVX512DQ-BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm7, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm28 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, %zmm28 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm2, %zmm19, %zmm1
; AVX512DQ-BW-NEXT:    vmovdqa 192(%rdi), %ymm2
; AVX512DQ-BW-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512DQ-BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm21, %zmm2
; AVX512DQ-BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm24 # 64-byte Reload
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm26, %zmm24 {%k1}
; AVX512DQ-BW-NEXT:    vpermt2q %zmm26, %zmm19, %zmm2
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm19 = [0,10,2,3,4,5,6,11]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm8, %zmm19, %zmm6
; AVX512DQ-BW-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [0,1,2,3,4,12,6,7]
; AVX512DQ-BW-NEXT:    vpermt2q %zmm8, %zmm21, %zmm27
; AVX512DQ-BW-NEXT:    vpermt2q %zmm17, %zmm19, %zmm0
; AVX512DQ-BW-NEXT:    vpermt2q %zmm17, %zmm21, %zmm9
; AVX512DQ-BW-NEXT:    vpermt2q %zmm30, %zmm19, %zmm1
; AVX512DQ-BW-NEXT:    vpermt2q %zmm30, %zmm21, %zmm28
; AVX512DQ-BW-NEXT:    vpermt2q %zmm14, %zmm19, %zmm2
; AVX512DQ-BW-NEXT:    vpermt2q %zmm14, %zmm21, %zmm24
; AVX512DQ-BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm15, 1472(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm29, 1408(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm24, 1344(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm2, 1280(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm25, 1216(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm3, 1088(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm4, 1024(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm28, 960(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm1, 896(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm13, 832(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm22, 704(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm31, 640(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm9, 576(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm0, 512(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm18, 448(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm12, 320(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm23, 256(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm27, 192(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm6, 128(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm20, 64(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm16, 1152(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm11, 768(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm10, 384(%rax)
; AVX512DQ-BW-NEXT:    vmovdqa64 %zmm5, (%rax)
; AVX512DQ-BW-NEXT:    addq $648, %rsp # imm = 0x288
; AVX512DQ-BW-NEXT:    vzeroupper
; AVX512DQ-BW-NEXT:    retq
;
; AVX512DQ-BW-FCP-LABEL: store_i64_stride6_vf32:
; AVX512DQ-BW-FCP:       # %bb.0:
; AVX512DQ-BW-FCP-NEXT:    subq $648, %rsp # imm = 0x288
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm11
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm19
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm29
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm25
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm23
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm20
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm24
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm4
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm7
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm21
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm18
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm13
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%rcx), %zmm12
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm27 = [4,12,5,13,4,12,5,13]
; AVX512DQ-BW-FCP-NEXT:    # zmm27 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm19, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm20, %zmm27, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm23, %zmm27, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm25, %zmm27, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm29, %zmm11, %zmm27
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm14 = [2,10,2,10,2,10,2,10]
; AVX512DQ-BW-FCP-NEXT:    # zmm14 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm29, %zmm14, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm15 = [6,14,6,14,6,14,6,14]
; AVX512DQ-BW-FCP-NEXT:    # zmm15 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm29, %zmm15, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm16 = [7,15,7,15,7,15,7,15]
; AVX512DQ-BW-FCP-NEXT:    # zmm16 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm24, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm18, %zmm16, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm29, %zmm16, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm25, %zmm14, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm25, %zmm15, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm26
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm13, %zmm16, %zmm26
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm25, %zmm16, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm30
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm23, %zmm14, %zmm30
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm1 = [0,8,1,9,0,8,1,9]
; AVX512DQ-BW-FCP-NEXT:    # zmm1 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm29, %zmm1, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm23, %zmm15, %zmm8
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm25, %zmm1, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm28
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm23, %zmm16, %zmm28
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm23, %zmm1, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm12, %zmm16, %zmm17
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm20, %zmm19, %zmm14
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm20, %zmm19, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%rcx), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm21, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm16, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm20, %zmm19, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm20, %zmm1, %zmm19
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,0,4,12]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm21, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm1, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm12, %zmm1, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm13, %zmm1, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm18, %zmm24, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm25 = [1,9,2,10,1,9,2,10]
; AVX512DQ-BW-FCP-NEXT:    # zmm25 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm24, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm18, %zmm25, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm29 = [5,13,6,14,5,13,6,14]
; AVX512DQ-BW-FCP-NEXT:    # zmm29 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm24, %zmm23
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm24, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm18, %zmm29, %zmm23
; AVX512DQ-BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [3,11,3,11,3,11,3,11]
; AVX512DQ-BW-FCP-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm18, %zmm0, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm9, (%rsp) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm18
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm13, %zmm25, %zmm18
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm31
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm24
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm13, %zmm29, %zmm31
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm13, %zmm0, %zmm24
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm12, %zmm25, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm12, %zmm29, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm12, %zmm0, %zmm7
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm2, %zmm21, %zmm25
; AVX512DQ-BW-FCP-NEXT:    vpermi2q %zmm2, %zmm21, %zmm29
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm0, %zmm21
; AVX512DQ-BW-FCP-NEXT:    movb $12, %al
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm0 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm0 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, %zmm9 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm27 {%k1}
; AVX512DQ-BW-FCP-NEXT:    movb $48, %al
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm20 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm12 # 64-byte Folded Reload
; AVX512DQ-BW-FCP-NEXT:    # zmm12 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm18 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm31 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%r8), %zmm0
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm22 = zmm22[0,1,2,3],zmm26[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%r8), %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm30, %zmm13 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%r8), %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm4 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%r8), %zmm26
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm3 = zmm28[0,1,2,3],zmm17[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 (%r9), %zmm8
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm14, %zmm25 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,9,0,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm5, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm1, %zmm5, %zmm18
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm5, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm26, %zmm5, %zmm25
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,9,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm8, %zmm5, %zmm20
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 64(%r9), %zmm17
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm17, %zmm5, %zmm18
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 128(%r9), %zmm30
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm30, %zmm5, %zmm13
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 192(%r9), %zmm14
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm14, %zmm5, %zmm25
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm29 {%k2}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,13,0,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm5, %zmm23
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm1, %zmm5, %zmm31
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm5, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm26, %zmm5, %zmm29
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,1,2,13,4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm8, %zmm5, %zmm23
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm17, %zmm5, %zmm31
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm30, %zmm5, %zmm4
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm14, %zmm5, %zmm29
; AVX512DQ-BW-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm15 = zmm16[0,1,2,3],zmm10[4,5,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [14,0,2,3,4,5,15,0]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm5, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm1, %zmm5, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm5, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm26, %zmm5, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm5 = [0,14,2,3,4,5,6,15]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm8, %zmm5, %zmm12
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm17, %zmm5, %zmm22
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm30, %zmm5, %zmm3
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm14, %zmm5, %zmm15
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdx), %xmm5
; AVX512DQ-BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm11 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 64(%rdx), %xmm5
; AVX512DQ-BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm10 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 128(%rdx), %xmm5
; AVX512DQ-BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm16 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 192(%rdx), %xmm5
; AVX512DQ-BW-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm5 = xmm5[0],mem[0]
; AVX512DQ-BW-FCP-NEXT:    vinserti128 $1, %xmm5, %ymm0, %ymm5
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $0, %ymm5, %zmm0, %zmm19 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vinserti32x4 $2, (%r8), %zmm11, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,1,2,3,4,8,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm8, %zmm6, %zmm5
; AVX512DQ-BW-FCP-NEXT:    vinserti32x4 $2, 64(%r8), %zmm10, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm17, %zmm6, %zmm10
; AVX512DQ-BW-FCP-NEXT:    vinserti32x4 $2, 128(%r8), %zmm16, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm30, %zmm6, %zmm11
; AVX512DQ-BW-FCP-NEXT:    vinserti32x4 $2, 192(%r8), %zmm19, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm14, %zmm6, %zmm16
; AVX512DQ-BW-FCP-NEXT:    vmovdqa (%rdi), %ymm6
; AVX512DQ-BW-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm6 = ymm6[1],mem[1],ymm6[3],mem[3]
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 (%rsp), %zmm19 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $0, %ymm6, %zmm19, %zmm6
; AVX512DQ-BW-FCP-NEXT:    movb $16, %al
; AVX512DQ-BW-FCP-NEXT:    kmovd %eax, %k1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm19 = [10,0,2,3,4,5,11,0]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm0, %zmm19, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 64(%rdi), %ymm0
; AVX512DQ-BW-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm0 = ymm0[1],mem[1],ymm0[3],mem[3]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $0, %ymm0, %zmm24, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm9 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm1, %zmm19, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 128(%rdi), %ymm1
; AVX512DQ-BW-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $0, %ymm1, %zmm7, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm28 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm28 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm2, %zmm19, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vmovdqa 192(%rdi), %ymm2
; AVX512DQ-BW-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512DQ-BW-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm21, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm24 # 64-byte Reload
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm26, %zmm24 {%k1}
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm26, %zmm19, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm19 = [0,10,2,3,4,5,6,11]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm8, %zmm19, %zmm6
; AVX512DQ-BW-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm21 = [0,1,2,3,4,12,6,7]
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm8, %zmm21, %zmm27
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm17, %zmm19, %zmm0
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm17, %zmm21, %zmm9
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm30, %zmm19, %zmm1
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm30, %zmm21, %zmm28
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm14, %zmm19, %zmm2
; AVX512DQ-BW-FCP-NEXT:    vpermt2q %zmm14, %zmm21, %zmm24
; AVX512DQ-BW-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm15, 1472(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm29, 1408(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm24, 1344(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm2, 1280(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm25, 1216(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm3, 1088(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm4, 1024(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm28, 960(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm1, 896(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm13, 832(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm22, 704(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm31, 640(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm9, 576(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm0, 512(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm18, 448(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm12, 320(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm23, 256(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm27, 192(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm6, 128(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm20, 64(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm16, 1152(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm11, 768(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm10, 384(%rax)
; AVX512DQ-BW-FCP-NEXT:    vmovdqa64 %zmm5, (%rax)
; AVX512DQ-BW-FCP-NEXT:    addq $648, %rsp # imm = 0x288
; AVX512DQ-BW-FCP-NEXT:    vzeroupper
; AVX512DQ-BW-FCP-NEXT:    retq
  %in.vec0 = load <32 x i64>, ptr %in.vecptr0, align 64
  %in.vec1 = load <32 x i64>, ptr %in.vecptr1, align 64
  %in.vec2 = load <32 x i64>, ptr %in.vecptr2, align 64
  %in.vec3 = load <32 x i64>, ptr %in.vecptr3, align 64
  %in.vec4 = load <32 x i64>, ptr %in.vecptr4, align 64
  %in.vec5 = load <32 x i64>, ptr %in.vecptr5, align 64
  %1 = shufflevector <32 x i64> %in.vec0, <32 x i64> %in.vec1, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %2 = shufflevector <32 x i64> %in.vec2, <32 x i64> %in.vec3, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %3 = shufflevector <32 x i64> %in.vec4, <32 x i64> %in.vec5, <64 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63>
  %4 = shufflevector <64 x i64> %1, <64 x i64> %2, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  %5 = shufflevector <64 x i64> %3, <64 x i64> poison, <128 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef, i32 undef>
  %6 = shufflevector <128 x i64> %4, <128 x i64> %5, <192 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127, i32 128, i32 129, i32 130, i32 131, i32 132, i32 133, i32 134, i32 135, i32 136, i32 137, i32 138, i32 139, i32 140, i32 141, i32 142, i32 143, i32 144, i32 145, i32 146, i32 147, i32 148, i32 149, i32 150, i32 151, i32 152, i32 153, i32 154, i32 155, i32 156, i32 157, i32 158, i32 159, i32 160, i32 161, i32 162, i32 163, i32 164, i32 165, i32 166, i32 167, i32 168, i32 169, i32 170, i32 171, i32 172, i32 173, i32 174, i32 175, i32 176, i32 177, i32 178, i32 179, i32 180, i32 181, i32 182, i32 183, i32 184, i32 185, i32 186, i32 187, i32 188, i32 189, i32 190, i32 191>
  %interleaved.vec = shufflevector <192 x i64> %6, <192 x i64> poison, <192 x i32> <i32 0, i32 32, i32 64, i32 96, i32 128, i32 160, i32 1, i32 33, i32 65, i32 97, i32 129, i32 161, i32 2, i32 34, i32 66, i32 98, i32 130, i32 162, i32 3, i32 35, i32 67, i32 99, i32 131, i32 163, i32 4, i32 36, i32 68, i32 100, i32 132, i32 164, i32 5, i32 37, i32 69, i32 101, i32 133, i32 165, i32 6, i32 38, i32 70, i32 102, i32 134, i32 166, i32 7, i32 39, i32 71, i32 103, i32 135, i32 167, i32 8, i32 40, i32 72, i32 104, i32 136, i32 168, i32 9, i32 41, i32 73, i32 105, i32 137, i32 169, i32 10, i32 42, i32 74, i32 106, i32 138, i32 170, i32 11, i32 43, i32 75, i32 107, i32 139, i32 171, i32 12, i32 44, i32 76, i32 108, i32 140, i32 172, i32 13, i32 45, i32 77, i32 109, i32 141, i32 173, i32 14, i32 46, i32 78, i32 110, i32 142, i32 174, i32 15, i32 47, i32 79, i32 111, i32 143, i32 175, i32 16, i32 48, i32 80, i32 112, i32 144, i32 176, i32 17, i32 49, i32 81, i32 113, i32 145, i32 177, i32 18, i32 50, i32 82, i32 114, i32 146, i32 178, i32 19, i32 51, i32 83, i32 115, i32 147, i32 179, i32 20, i32 52, i32 84, i32 116, i32 148, i32 180, i32 21, i32 53, i32 85, i32 117, i32 149, i32 181, i32 22, i32 54, i32 86, i32 118, i32 150, i32 182, i32 23, i32 55, i32 87, i32 119, i32 151, i32 183, i32 24, i32 56, i32 88, i32 120, i32 152, i32 184, i32 25, i32 57, i32 89, i32 121, i32 153, i32 185, i32 26, i32 58, i32 90, i32 122, i32 154, i32 186, i32 27, i32 59, i32 91, i32 123, i32 155, i32 187, i32 28, i32 60, i32 92, i32 124, i32 156, i32 188, i32 29, i32 61, i32 93, i32 125, i32 157, i32 189, i32 30, i32 62, i32 94, i32 126, i32 158, i32 190, i32 31, i32 63, i32 95, i32 127, i32 159, i32 191>
  store <192 x i64> %interleaved.vec, ptr %out.vec, align 64
  ret void
}

define void @store_i64_stride6_vf64(ptr %in.vecptr0, ptr %in.vecptr1, ptr %in.vecptr2, ptr %in.vecptr3, ptr %in.vecptr4, ptr %in.vecptr5, ptr %out.vec) nounwind {
; SSE-LABEL: store_i64_stride6_vf64:
; SSE:       # %bb.0:
; SSE-NEXT:    subq $2712, %rsp # imm = 0xA98
; SSE-NEXT:    movaps (%rdi), %xmm7
; SSE-NEXT:    movaps 16(%rdi), %xmm8
; SSE-NEXT:    movaps 32(%rdi), %xmm9
; SSE-NEXT:    movaps (%rsi), %xmm2
; SSE-NEXT:    movaps 16(%rsi), %xmm1
; SSE-NEXT:    movaps 32(%rsi), %xmm0
; SSE-NEXT:    movaps (%rdx), %xmm10
; SSE-NEXT:    movaps 16(%rdx), %xmm11
; SSE-NEXT:    movaps 32(%rdx), %xmm12
; SSE-NEXT:    movaps (%rcx), %xmm4
; SSE-NEXT:    movaps 16(%rcx), %xmm3
; SSE-NEXT:    movaps 16(%r8), %xmm14
; SSE-NEXT:    movaps (%r8), %xmm13
; SSE-NEXT:    movaps 16(%r9), %xmm5
; SSE-NEXT:    movaps (%r9), %xmm6
; SSE-NEXT:    movaps %xmm7, %xmm15
; SSE-NEXT:    movlhps {{.*#+}} xmm15 = xmm15[0],xmm2[0]
; SSE-NEXT:    movaps %xmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm7 = xmm7[1],xmm2[1]
; SSE-NEXT:    movaps %xmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm10, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm4[0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm10 = xmm10[1],xmm4[1]
; SSE-NEXT:    movaps %xmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm13, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm6[0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm13 = xmm13[1],xmm6[1]
; SSE-NEXT:    movaps %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm8, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm1[0]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm1[1]
; SSE-NEXT:    movaps %xmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm11, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm3[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm3[1]
; SSE-NEXT:    movaps %xmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm14, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm5[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm5[1]
; SSE-NEXT:    movaps %xmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps %xmm9, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm9 = xmm9[1],xmm0[1]
; SSE-NEXT:    movaps %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm12, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm0[1]
; SSE-NEXT:    movaps %xmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 32(%r8), %xmm2
; SSE-NEXT:    movaps 32(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%rdi), %xmm2
; SSE-NEXT:    movaps 48(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%rdx), %xmm2
; SSE-NEXT:    movaps 48(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 48(%r8), %xmm2
; SSE-NEXT:    movaps 48(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdi), %xmm2
; SSE-NEXT:    movaps 64(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%rdx), %xmm2
; SSE-NEXT:    movaps 64(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 64(%r8), %xmm2
; SSE-NEXT:    movaps 64(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rdi), %xmm2
; SSE-NEXT:    movaps 80(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%rdx), %xmm2
; SSE-NEXT:    movaps 80(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 80(%r8), %xmm2
; SSE-NEXT:    movaps 80(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%rdi), %xmm2
; SSE-NEXT:    movaps 96(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%rdx), %xmm2
; SSE-NEXT:    movaps 96(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 96(%r8), %xmm2
; SSE-NEXT:    movaps 96(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%rdi), %xmm2
; SSE-NEXT:    movaps 112(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%rdx), %xmm2
; SSE-NEXT:    movaps 112(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 112(%r8), %xmm2
; SSE-NEXT:    movaps 112(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%rdi), %xmm2
; SSE-NEXT:    movaps 128(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%rdx), %xmm2
; SSE-NEXT:    movaps 128(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 128(%r8), %xmm2
; SSE-NEXT:    movaps 128(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%rdi), %xmm2
; SSE-NEXT:    movaps 144(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%rdx), %xmm2
; SSE-NEXT:    movaps 144(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 144(%r8), %xmm2
; SSE-NEXT:    movaps 144(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%rdi), %xmm2
; SSE-NEXT:    movaps 160(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%rdx), %xmm2
; SSE-NEXT:    movaps 160(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 160(%r8), %xmm2
; SSE-NEXT:    movaps 160(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%rdi), %xmm2
; SSE-NEXT:    movaps 176(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%rdx), %xmm2
; SSE-NEXT:    movaps 176(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 176(%r8), %xmm2
; SSE-NEXT:    movaps 176(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%rdi), %xmm2
; SSE-NEXT:    movaps 192(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%rdx), %xmm2
; SSE-NEXT:    movaps 192(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 192(%r8), %xmm2
; SSE-NEXT:    movaps 192(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 208(%rdi), %xmm2
; SSE-NEXT:    movaps 208(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 208(%rdx), %xmm2
; SSE-NEXT:    movaps 208(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 208(%r8), %xmm2
; SSE-NEXT:    movaps 208(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 224(%rdi), %xmm2
; SSE-NEXT:    movaps 224(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 224(%rdx), %xmm2
; SSE-NEXT:    movaps 224(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 224(%r8), %xmm2
; SSE-NEXT:    movaps 224(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 240(%rdi), %xmm2
; SSE-NEXT:    movaps 240(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 240(%rdx), %xmm2
; SSE-NEXT:    movaps 240(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 240(%r8), %xmm2
; SSE-NEXT:    movaps 240(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 256(%rdi), %xmm2
; SSE-NEXT:    movaps 256(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 256(%rdx), %xmm2
; SSE-NEXT:    movaps 256(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 256(%r8), %xmm2
; SSE-NEXT:    movaps 256(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 272(%rdi), %xmm2
; SSE-NEXT:    movaps 272(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 272(%rdx), %xmm2
; SSE-NEXT:    movaps 272(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 272(%r8), %xmm2
; SSE-NEXT:    movaps 272(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 288(%rdi), %xmm2
; SSE-NEXT:    movaps 288(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 288(%rdx), %xmm2
; SSE-NEXT:    movaps 288(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 288(%r8), %xmm2
; SSE-NEXT:    movaps 288(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 304(%rdi), %xmm2
; SSE-NEXT:    movaps 304(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 304(%rdx), %xmm2
; SSE-NEXT:    movaps 304(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 304(%r8), %xmm2
; SSE-NEXT:    movaps 304(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 320(%rdi), %xmm2
; SSE-NEXT:    movaps 320(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 320(%rdx), %xmm2
; SSE-NEXT:    movaps 320(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 320(%r8), %xmm2
; SSE-NEXT:    movaps 320(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 336(%rdi), %xmm2
; SSE-NEXT:    movaps 336(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 336(%rdx), %xmm2
; SSE-NEXT:    movaps 336(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 336(%r8), %xmm2
; SSE-NEXT:    movaps 336(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 352(%rdi), %xmm2
; SSE-NEXT:    movaps 352(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 352(%rdx), %xmm2
; SSE-NEXT:    movaps 352(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 352(%r8), %xmm2
; SSE-NEXT:    movaps 352(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 368(%rdi), %xmm2
; SSE-NEXT:    movaps 368(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 368(%rdx), %xmm2
; SSE-NEXT:    movaps 368(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 368(%r8), %xmm2
; SSE-NEXT:    movaps 368(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 384(%rdi), %xmm2
; SSE-NEXT:    movaps 384(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 384(%rdx), %xmm2
; SSE-NEXT:    movaps 384(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 384(%r8), %xmm2
; SSE-NEXT:    movaps 384(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 400(%rdi), %xmm2
; SSE-NEXT:    movaps 400(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 400(%rdx), %xmm2
; SSE-NEXT:    movaps 400(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 400(%r8), %xmm2
; SSE-NEXT:    movaps 400(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 416(%rdi), %xmm2
; SSE-NEXT:    movaps 416(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 416(%rdx), %xmm2
; SSE-NEXT:    movaps 416(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 416(%r8), %xmm2
; SSE-NEXT:    movaps 416(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 432(%rdi), %xmm2
; SSE-NEXT:    movaps 432(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 432(%rdx), %xmm2
; SSE-NEXT:    movaps 432(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 432(%r8), %xmm2
; SSE-NEXT:    movaps 432(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 448(%rdi), %xmm2
; SSE-NEXT:    movaps 448(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, (%rsp) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 448(%rdx), %xmm2
; SSE-NEXT:    movaps 448(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 448(%r8), %xmm2
; SSE-NEXT:    movaps 448(%r9), %xmm0
; SSE-NEXT:    movaps %xmm2, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE-NEXT:    movaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movaps 464(%rdi), %xmm15
; SSE-NEXT:    movaps 464(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm15, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm15 = xmm15[1],xmm0[1]
; SSE-NEXT:    movaps 464(%rdx), %xmm14
; SSE-NEXT:    movaps 464(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm14, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm14 = xmm14[1],xmm0[1]
; SSE-NEXT:    movaps 464(%r8), %xmm11
; SSE-NEXT:    movaps 464(%r9), %xmm0
; SSE-NEXT:    movaps %xmm11, %xmm1
; SSE-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE-NEXT:    movaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    unpckhpd {{.*#+}} xmm11 = xmm11[1],xmm0[1]
; SSE-NEXT:    movaps 480(%rdi), %xmm12
; SSE-NEXT:    movaps 480(%rsi), %xmm0
; SSE-NEXT:    movaps %xmm12, %xmm13
; SSE-NEXT:    movlhps {{.*#+}} xmm13 = xmm13[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm12 = xmm12[1],xmm0[1]
; SSE-NEXT:    movaps 480(%rdx), %xmm8
; SSE-NEXT:    movaps 480(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm8, %xmm10
; SSE-NEXT:    movlhps {{.*#+}} xmm10 = xmm10[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm0[1]
; SSE-NEXT:    movaps 480(%r8), %xmm5
; SSE-NEXT:    movaps 480(%r9), %xmm0
; SSE-NEXT:    movaps %xmm5, %xmm9
; SSE-NEXT:    movlhps {{.*#+}} xmm9 = xmm9[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm5 = xmm5[1],xmm0[1]
; SSE-NEXT:    movaps 496(%rdi), %xmm6
; SSE-NEXT:    movaps 496(%rsi), %xmm1
; SSE-NEXT:    movaps %xmm6, %xmm7
; SSE-NEXT:    movlhps {{.*#+}} xmm7 = xmm7[0],xmm1[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm6 = xmm6[1],xmm1[1]
; SSE-NEXT:    movaps 496(%rdx), %xmm1
; SSE-NEXT:    movaps 496(%rcx), %xmm0
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    movlhps {{.*#+}} xmm4 = xmm4[0],xmm0[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm0[1]
; SSE-NEXT:    movaps 496(%r8), %xmm0
; SSE-NEXT:    movaps 496(%r9), %xmm3
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    movlhps {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSE-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm3[1]
; SSE-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; SSE-NEXT:    movaps %xmm0, 3056(%rax)
; SSE-NEXT:    movaps %xmm1, 3040(%rax)
; SSE-NEXT:    movaps %xmm6, 3024(%rax)
; SSE-NEXT:    movaps %xmm2, 3008(%rax)
; SSE-NEXT:    movaps %xmm4, 2992(%rax)
; SSE-NEXT:    movaps %xmm7, 2976(%rax)
; SSE-NEXT:    movaps %xmm5, 2960(%rax)
; SSE-NEXT:    movaps %xmm8, 2944(%rax)
; SSE-NEXT:    movaps %xmm12, 2928(%rax)
; SSE-NEXT:    movaps %xmm9, 2912(%rax)
; SSE-NEXT:    movaps %xmm10, 2896(%rax)
; SSE-NEXT:    movaps %xmm13, 2880(%rax)
; SSE-NEXT:    movaps %xmm11, 2864(%rax)
; SSE-NEXT:    movaps %xmm14, 2848(%rax)
; SSE-NEXT:    movaps %xmm15, 2832(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2816(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2800(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2784(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2768(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2752(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2736(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2720(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2704(%rax)
; SSE-NEXT:    movaps (%rsp), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2688(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2672(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2656(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2640(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2624(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2608(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2592(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2576(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2560(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2544(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2528(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2512(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2496(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2480(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2464(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2448(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2432(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2416(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2400(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2384(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2368(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2336(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2320(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2304(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2288(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2096(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2080(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2064(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2048(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2032(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2016(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 2000(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1984(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1968(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1952(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1936(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1920(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1904(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1888(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1872(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1856(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1840(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1824(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1808(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1792(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1776(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1760(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1744(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1728(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1712(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1696(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1680(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1664(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1648(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1632(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1616(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1600(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1584(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1568(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1552(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1536(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1520(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1504(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1488(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1472(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1456(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1440(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1424(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1408(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1392(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1376(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1360(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1344(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1328(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1312(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1296(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1280(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1264(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1248(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1232(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1216(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1200(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1184(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1168(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1152(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1136(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1120(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1104(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1088(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1072(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1056(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1040(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1024(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 1008(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 992(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 976(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 960(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 944(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 928(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 912(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 896(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 880(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 864(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 848(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 832(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 816(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 800(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 784(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 768(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 752(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 736(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 720(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 704(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 688(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 672(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 656(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 640(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 624(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 608(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 592(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 576(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 560(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 544(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 528(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 512(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 496(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 480(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 464(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 448(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 432(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 416(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 400(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 384(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 368(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 352(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 336(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 320(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 304(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 288(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 272(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 256(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 240(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 224(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 208(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 192(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 176(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 160(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 144(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 128(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 112(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 96(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 80(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 64(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 48(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 32(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, 16(%rax)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rax)
; SSE-NEXT:    addq $2712, %rsp # imm = 0xA98
; SSE-NEXT:    retq
;
; AVX-LABEL: store_i64_stride6_vf64:
; AVX:       # %bb.0:
; AVX-NEXT:    subq $3464, %rsp # imm = 0xD88
; AVX-NEXT:    vmovaps 32(%r8), %ymm7
; AVX-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd (%r8), %ymm0
; AVX-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX-NEXT:    vmovaps (%rsi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 32(%rsi), %xmm5
; AVX-NEXT:    vmovaps %xmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 64(%rsi), %xmm6
; AVX-NEXT:    vmovaps %xmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps (%rdi), %xmm3
; AVX-NEXT:    vmovaps %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX-NEXT:    vblendpd {{.*#+}} ymm3 = ymm0[0,1],ymm3[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm3[0],ymm1[1],ymm3[2,3]
; AVX-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps (%rcx), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps (%rdx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vinsertf128 $1, (%r9), %ymm1, %ymm3
; AVX-NEXT:    vbroadcastsd 8(%r8), %ymm4
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm4[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3],ymm1[4,5],ymm3[6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovddup {{.*#+}} xmm1 = mem[0,0]
; AVX-NEXT:    vmovaps 32(%rdi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm3 = xmm2[1],xmm5[1]
; AVX-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm7[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 32(%rcx), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 32(%rdx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vbroadcastsd 40(%r8), %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 32(%r9), %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3],ymm3[4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 64(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm6[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovapd 64(%r8), %ymm15
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm15[0,1],ymm1[2,3]
; AVX-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0],ymm3[1],ymm1[2,3]
; AVX-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 64(%rcx), %xmm2
; AVX-NEXT:    vmovaps %xmm2, (%rsp) # 16-byte Spill
; AVX-NEXT:    vmovaps 64(%rdx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vbroadcastsd 72(%r8), %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 64(%r9), %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3],ymm3[4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rsi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 96(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovapd 96(%r8), %ymm9
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm9[0,1],ymm1[2,3]
; AVX-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0],ymm3[1],ymm1[2,3]
; AVX-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 96(%rcx), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 96(%rdx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vbroadcastsd 104(%r8), %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 96(%r9), %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3],ymm3[4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 128(%rsi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 128(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovaps 128(%r8), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 128(%rcx), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 128(%rdx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vbroadcastsd 136(%r8), %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 128(%r9), %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3],ymm3[4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 160(%rsi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 160(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovapd 160(%r8), %ymm8
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm8[0,1],ymm1[2,3]
; AVX-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0],ymm3[1],ymm1[2,3]
; AVX-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 160(%rcx), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 160(%rdx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vbroadcastsd 168(%r8), %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 160(%r9), %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3],ymm3[4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 192(%rsi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 192(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovapd 192(%r8), %ymm7
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm7[0,1],ymm1[2,3]
; AVX-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0],ymm3[1],ymm1[2,3]
; AVX-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 192(%rcx), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 192(%rdx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vbroadcastsd 200(%r8), %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 192(%r9), %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3],ymm3[4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 224(%rsi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 224(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovapd 224(%r8), %ymm11
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm11[0,1],ymm1[2,3]
; AVX-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0],ymm3[1],ymm1[2,3]
; AVX-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 224(%rcx), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 224(%rdx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vbroadcastsd 232(%r8), %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 224(%r9), %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3],ymm3[4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 256(%rsi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 256(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovaps 256(%r8), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 256(%rcx), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 256(%rdx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vbroadcastsd 264(%r8), %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 256(%r9), %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3],ymm3[4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 288(%rsi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 288(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovaps 288(%r8), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 288(%rcx), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 288(%rdx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vbroadcastsd 296(%r8), %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 288(%r9), %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3],ymm3[4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 320(%rsi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 320(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovaps 320(%r8), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 320(%rcx), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 320(%rdx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vbroadcastsd 328(%r8), %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 320(%r9), %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3],ymm3[4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 352(%rsi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 352(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovaps 352(%r8), %ymm2
; AVX-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm3[2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 352(%rcx), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 352(%rdx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vbroadcastsd 360(%r8), %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 352(%r9), %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3],ymm3[4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 384(%rsi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 384(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovapd 384(%r8), %ymm12
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm12[0,1],ymm1[2,3]
; AVX-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0],ymm3[1],ymm1[2,3]
; AVX-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 384(%rcx), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 384(%rdx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vbroadcastsd 392(%r8), %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 384(%r9), %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3],ymm3[4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 416(%rsi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 416(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovapd 416(%r8), %ymm13
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm13[0,1],ymm1[2,3]
; AVX-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0],ymm3[1],ymm1[2,3]
; AVX-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 416(%rcx), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 416(%rdx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vbroadcastsd 424(%r8), %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 416(%r9), %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3],ymm3[4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 448(%rsi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 448(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX-NEXT:    vmovapd 448(%r8), %ymm14
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm14[0,1],ymm1[2,3]
; AVX-NEXT:    vmovddup {{.*#+}} xmm3 = mem[0,0]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm1[0],ymm3[1],ymm1[2,3]
; AVX-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 448(%rcx), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 448(%rdx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vbroadcastsd 456(%r8), %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 448(%r9), %ymm1, %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm1[2,3],ymm3[4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 480(%rsi), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 480(%rdi), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm3
; AVX-NEXT:    vmovapd 480(%r8), %ymm5
; AVX-NEXT:    vblendpd {{.*#+}} ymm3 = ymm5[0,1],ymm3[2,3]
; AVX-NEXT:    vmovddup {{.*#+}} xmm2 = mem[0,0]
; AVX-NEXT:    vblendpd {{.*#+}} ymm1 = ymm3[0],ymm2[1],ymm3[2,3]
; AVX-NEXT:    vmovupd %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 480(%rcx), %xmm1
; AVX-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps 480(%rdx), %xmm2
; AVX-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm2[1],xmm1[1]
; AVX-NEXT:    vbroadcastsd 488(%r8), %ymm3
; AVX-NEXT:    vblendps {{.*#+}} ymm3 = ymm2[0,1,2,3],ymm3[4,5,6,7]
; AVX-NEXT:    vinsertf128 $1, 480(%r9), %ymm2, %ymm2
; AVX-NEXT:    vblendps {{.*#+}} ymm1 = ymm3[0,1],ymm2[2,3],ymm3[4,5],ymm2[6,7]
; AVX-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd (%rdi), %ymm2
; AVX-NEXT:    vmovapd (%rsi), %ymm3
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm0[2,3],ymm2[2,3]
; AVX-NEXT:    vmovapd (%r9), %ymm4
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm4[2,3],ymm3[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm2[0],ymm3[0],ymm2[2],ymm3[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 32(%rdi), %ymm2
; AVX-NEXT:    vmovapd 32(%rsi), %ymm3
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm2 = ymm2[1],ymm3[1],ymm2[3],ymm3[3]
; AVX-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm2, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[2,3],ymm2[2,3]
; AVX-NEXT:    vmovapd 32(%r9), %ymm6
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm6[2,3],ymm3[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[2],ymm3[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 64(%rdi), %ymm0
; AVX-NEXT:    vmovapd 64(%rsi), %ymm3
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm3[1],ymm0[3],ymm3[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm15[2,3],ymm0[2,3]
; AVX-NEXT:    vmovapd 64(%r9), %ymm15
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm15[2,3],ymm3[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm3[0],ymm0[2],ymm3[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 96(%rdi), %ymm3
; AVX-NEXT:    vmovapd 96(%rsi), %ymm0
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm3 = ymm3[1],ymm0[1],ymm3[3],ymm0[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm9 = ymm9[2,3],ymm3[2,3]
; AVX-NEXT:    vmovapd 96(%r9), %ymm3
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm3[2,3],ymm0[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm9[0],ymm0[0],ymm9[2],ymm0[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 128(%rdi), %ymm9
; AVX-NEXT:    vmovapd 128(%rsi), %ymm0
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm9 = ymm9[1],ymm0[1],ymm9[3],ymm0[3]
; AVX-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm9, %ymm1 # 32-byte Folded Reload
; AVX-NEXT:    # ymm1 = mem[2,3],ymm9[2,3]
; AVX-NEXT:    vmovapd 128(%r9), %ymm9
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm9[2,3],ymm0[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 160(%rdi), %ymm0
; AVX-NEXT:    vmovapd 160(%rsi), %ymm1
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm8[2,3],ymm0[2,3]
; AVX-NEXT:    vmovapd 160(%r9), %ymm8
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm8[2,3],ymm1[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 192(%rdi), %ymm0
; AVX-NEXT:    vmovapd 192(%rsi), %ymm1
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm7[2,3],ymm0[2,3]
; AVX-NEXT:    vmovapd 192(%r9), %ymm7
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm7[2,3],ymm1[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 224(%rdi), %ymm0
; AVX-NEXT:    vmovapd 224(%rsi), %ymm1
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm11[2,3],ymm0[2,3]
; AVX-NEXT:    vmovapd 224(%r9), %ymm10
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm10[2,3],ymm1[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 256(%rdi), %ymm1
; AVX-NEXT:    vmovapd 256(%rsi), %ymm0
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX-NEXT:    # ymm1 = mem[2,3],ymm1[2,3]
; AVX-NEXT:    vmovapd 256(%r9), %ymm11
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm11[2,3],ymm0[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 288(%rdi), %ymm0
; AVX-NEXT:    vmovapd 288(%rsi), %ymm1
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX-NEXT:    vmovapd 288(%r9), %ymm2
; AVX-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm2[2,3],ymm1[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 320(%rdi), %ymm1
; AVX-NEXT:    vmovapd 320(%rsi), %ymm0
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm0[1],ymm1[3],ymm0[3]
; AVX-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX-NEXT:    # ymm1 = mem[2,3],ymm1[2,3]
; AVX-NEXT:    vmovapd 320(%r9), %ymm2
; AVX-NEXT:    vmovupd %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm2[2,3],ymm0[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 352(%rdi), %ymm0
; AVX-NEXT:    vmovapd 352(%rsi), %ymm1
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm2 # 32-byte Folded Reload
; AVX-NEXT:    # ymm2 = mem[2,3],ymm0[2,3]
; AVX-NEXT:    vmovapd 352(%r9), %ymm0
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3],ymm1[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm2[0],ymm1[0],ymm2[2],ymm1[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 384(%rdi), %ymm0
; AVX-NEXT:    vmovapd 384(%rsi), %ymm1
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm12[2,3],ymm0[2,3]
; AVX-NEXT:    vmovapd 384(%r9), %ymm12
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm12[2,3],ymm1[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 416(%rdi), %ymm0
; AVX-NEXT:    vmovapd 416(%rsi), %ymm1
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm13[2,3],ymm0[2,3]
; AVX-NEXT:    vmovapd 416(%r9), %ymm13
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm13[2,3],ymm1[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 448(%rdi), %ymm0
; AVX-NEXT:    vmovapd 448(%rsi), %ymm1
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm14[2,3],ymm0[2,3]
; AVX-NEXT:    vmovapd 448(%r9), %ymm14
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm14[2,3],ymm1[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 480(%rdi), %ymm0
; AVX-NEXT:    vmovapd 480(%rsi), %ymm1
; AVX-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm5[2,3],ymm0[2,3]
; AVX-NEXT:    vmovapd 480(%r9), %ymm5
; AVX-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm5[2,3],ymm1[2,3]
; AVX-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[0],ymm1[0],ymm0[2],ymm1[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 16(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 16(%rcx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 16(%rdx), %xmm0
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX-NEXT:    vbroadcastsd 24(%r8), %ymm1
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm4[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 48(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 48(%rcx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 48(%rdx), %xmm0
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX-NEXT:    vbroadcastsd 56(%r8), %ymm1
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm6[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 80(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 80(%rcx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 80(%rdx), %xmm0
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX-NEXT:    vbroadcastsd 88(%r8), %ymm1
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm15[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 112(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 112(%rcx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 112(%rdx), %xmm0
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX-NEXT:    vbroadcastsd 120(%r8), %ymm1
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm3[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 144(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 144(%rcx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 144(%rdx), %xmm0
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX-NEXT:    vbroadcastsd 152(%r8), %ymm1
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm9[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 176(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 176(%rcx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 176(%rdx), %xmm0
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX-NEXT:    vbroadcastsd 184(%r8), %ymm1
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm8[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 208(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 208(%rcx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 208(%rdx), %xmm0
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX-NEXT:    vbroadcastsd 216(%r8), %ymm1
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm7[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 240(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 240(%rcx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 240(%rdx), %xmm0
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX-NEXT:    vbroadcastsd 248(%r8), %ymm1
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm10[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 272(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 272(%rcx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 272(%rdx), %xmm0
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX-NEXT:    vbroadcastsd 280(%r8), %ymm1
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm11[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 304(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 304(%rcx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 304(%rdx), %xmm0
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX-NEXT:    vbroadcastsd 312(%r8), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vblendps $192, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 336(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 336(%rcx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 336(%rdx), %xmm0
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX-NEXT:    vbroadcastsd 344(%r8), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vblendps $192, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 368(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 368(%rcx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 368(%rdx), %xmm0
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX-NEXT:    vbroadcastsd 376(%r8), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm1[4,5,6,7]
; AVX-NEXT:    vblendps $192, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX-NEXT:    # ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 400(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 400(%rcx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 400(%rdx), %xmm0
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX-NEXT:    vbroadcastsd 408(%r8), %ymm1
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm12[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 432(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 432(%rcx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 432(%rdx), %xmm0
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX-NEXT:    vbroadcastsd 440(%r8), %ymm1
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm13[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 464(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 464(%rcx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 464(%rdx), %xmm0
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX-NEXT:    vbroadcastsd 472(%r8), %ymm1
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm14[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps 496(%rdi), %xmm0
; AVX-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],mem[4,5,6,7]
; AVX-NEXT:    vbroadcastsd 496(%rcx), %ymm1
; AVX-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovapd 496(%rdx), %xmm0
; AVX-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],mem[1]
; AVX-NEXT:    vbroadcastsd 504(%r8), %ymm1
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3]
; AVX-NEXT:    vblendpd {{.*#+}} ymm0 = ymm0[0,1,2],ymm5[3]
; AVX-NEXT:    vmovupd %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd (%rsp), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps %xmm0, (%rsp) # 16-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm15 # 16-byte Folded Reload
; AVX-NEXT:    # xmm15 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm14 # 16-byte Folded Reload
; AVX-NEXT:    # xmm14 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm13 # 16-byte Folded Reload
; AVX-NEXT:    # xmm13 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm12 # 16-byte Folded Reload
; AVX-NEXT:    # xmm12 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm11 # 16-byte Folded Reload
; AVX-NEXT:    # xmm11 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm10 # 16-byte Folded Reload
; AVX-NEXT:    # xmm10 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm9 # 16-byte Folded Reload
; AVX-NEXT:    # xmm9 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm8 # 16-byte Folded Reload
; AVX-NEXT:    # xmm8 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm7 # 16-byte Folded Reload
; AVX-NEXT:    # xmm7 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm6 # 16-byte Folded Reload
; AVX-NEXT:    # xmm6 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm5 # 16-byte Folded Reload
; AVX-NEXT:    # xmm5 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm4 # 16-byte Folded Reload
; AVX-NEXT:    # xmm4 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm3 # 16-byte Folded Reload
; AVX-NEXT:    # xmm3 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm2 # 16-byte Folded Reload
; AVX-NEXT:    # xmm2 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm1 # 16-byte Folded Reload
; AVX-NEXT:    # xmm1 = xmm0[0],mem[0]
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vunpcklpd {{[-0-9]+}}(%r{{[sb]}}p), %xmm0, %xmm0 # 16-byte Folded Reload
; AVX-NEXT:    # xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX-NEXT:    vmovaps %xmm0, 16(%rax)
; AVX-NEXT:    vmovaps %xmm1, (%rax)
; AVX-NEXT:    vmovaps %xmm2, 2320(%rax)
; AVX-NEXT:    vmovaps %xmm3, 2304(%rax)
; AVX-NEXT:    vmovaps %xmm4, 2704(%rax)
; AVX-NEXT:    vmovaps %xmm5, 2688(%rax)
; AVX-NEXT:    vmovaps %xmm6, 2896(%rax)
; AVX-NEXT:    vmovaps %xmm7, 2880(%rax)
; AVX-NEXT:    vmovaps %xmm8, 2512(%rax)
; AVX-NEXT:    vmovaps %xmm9, 2496(%rax)
; AVX-NEXT:    vmovaps %xmm10, 1936(%rax)
; AVX-NEXT:    vmovaps %xmm11, 1920(%rax)
; AVX-NEXT:    vmovaps %xmm12, 2128(%rax)
; AVX-NEXT:    vmovaps %xmm13, 2112(%rax)
; AVX-NEXT:    vmovaps %xmm14, 1744(%rax)
; AVX-NEXT:    vmovaps %xmm15, 1728(%rax)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1168(%rax)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1152(%rax)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1360(%rax)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1344(%rax)
; AVX-NEXT:    vmovaps (%rsp), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 976(%rax)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 960(%rax)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 592(%rax)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 576(%rax)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 208(%rax)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 192(%rax)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 400(%rax)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 384(%rax)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 784(%rax)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 768(%rax)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1552(%rax)
; AVX-NEXT:    vmovaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX-NEXT:    vmovaps %xmm0, 1536(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 3008(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2816(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2624(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2432(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2240(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2048(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1856(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1664(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1472(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1280(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1088(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 896(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 3040(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2976(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2944(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2912(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2848(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2784(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2752(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2720(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2656(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2592(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2560(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2528(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2464(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2400(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2368(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2336(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2272(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2208(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2176(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2144(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2080(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 2016(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1984(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1952(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1888(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1824(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1792(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1760(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1696(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1632(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1600(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1568(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1504(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1440(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1408(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1376(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1312(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1248(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1216(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1184(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1120(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1056(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 1024(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 992(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 928(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 864(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 736(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 544(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX-NEXT:    addq $3464, %rsp # imm = 0xD88
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
;
; AVX2-LABEL: store_i64_stride6_vf64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    subq $2968, %rsp # imm = 0xB98
; AVX2-NEXT:    vmovaps 32(%r8), %ymm3
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%r8), %ymm4
; AVX2-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%r9), %xmm0
; AVX2-NEXT:    vmovddup {{.*#+}} xmm1 = xmm0[0,0]
; AVX2-NEXT:    vmovaps (%rsi), %xmm7
; AVX2-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rsi), %xmm5
; AVX2-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rdi), %xmm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rdi), %xmm6
; AVX2-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm2[1],xmm7[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm4[0,1],ymm2[0,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vmovaps (%rcx), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps (%rdx), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 32(%rdx), %xmm4
; AVX2-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX2-NEXT:    vbroadcastsd 8(%r8), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%r9), %xmm0
; AVX2-NEXT:    vmovddup {{.*#+}} xmm1 = xmm0[0,0]
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm6[1],xmm5[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm3[0,1],ymm2[0,1]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 32(%rcx), %xmm1
; AVX2-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm4[1],xmm1[1]
; AVX2-NEXT:    vbroadcastsd 40(%r8), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vmovaps 64(%r8), %ymm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rsi), %xmm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rdi), %xmm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm2[0,1],ymm0[0,1]
; AVX2-NEXT:    vmovaps 64(%r9), %xmm1
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 64(%rdx), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 64(%rcx), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vbroadcastsd 72(%r8), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%rsi), %xmm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%rdi), %xmm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-NEXT:    vmovaps 96(%r9), %xmm1
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 96(%rcx), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 96(%rdx), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vbroadcastsd 104(%r8), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 128(%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 128(%rsi), %xmm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 128(%rdi), %xmm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-NEXT:    vmovaps 128(%r9), %xmm1
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 128(%rcx), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 128(%rdx), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vbroadcastsd 136(%r8), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 160(%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 160(%rsi), %xmm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 160(%rdi), %xmm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-NEXT:    vmovaps 160(%r9), %xmm1
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 160(%rcx), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 160(%rdx), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vbroadcastsd 168(%r8), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 192(%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 192(%rsi), %xmm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 192(%rdi), %xmm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-NEXT:    vmovaps 192(%r9), %xmm1
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 192(%rcx), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 192(%rdx), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vbroadcastsd 200(%r8), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 224(%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 224(%rsi), %xmm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 224(%rdi), %xmm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-NEXT:    vmovaps 224(%r9), %xmm1
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 224(%rcx), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 224(%rdx), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vbroadcastsd 232(%r8), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 256(%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 256(%rsi), %xmm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 256(%rdi), %xmm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-NEXT:    vmovaps 256(%r9), %xmm1
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 256(%rcx), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 256(%rdx), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vbroadcastsd 264(%r8), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 288(%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 288(%rsi), %xmm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 288(%rdi), %xmm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-NEXT:    vmovaps 288(%r9), %xmm1
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 288(%rcx), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 288(%rdx), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vbroadcastsd 296(%r8), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 320(%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 320(%rsi), %xmm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 320(%rdi), %xmm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-NEXT:    vmovaps 320(%r9), %xmm1
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 320(%rcx), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 320(%rdx), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vbroadcastsd 328(%r8), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 352(%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 352(%rsi), %xmm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 352(%rdi), %xmm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-NEXT:    vmovaps 352(%r9), %xmm1
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 352(%rcx), %xmm2
; AVX2-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 352(%rdx), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vbroadcastsd 360(%r8), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 384(%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 384(%rsi), %xmm2
; AVX2-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 384(%rdi), %xmm0
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-NEXT:    vmovaps 384(%r9), %xmm1
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 384(%rcx), %xmm0
; AVX2-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-NEXT:    vmovaps 384(%rdx), %xmm15
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm15[1],xmm0[1]
; AVX2-NEXT:    vbroadcastsd 392(%r8), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 416(%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 416(%rsi), %xmm12
; AVX2-NEXT:    vmovaps 416(%rdi), %xmm13
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm13[1],xmm12[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-NEXT:    vmovaps 416(%r9), %xmm1
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 416(%rcx), %xmm10
; AVX2-NEXT:    vmovaps 416(%rdx), %xmm11
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm11[1],xmm10[1]
; AVX2-NEXT:    vbroadcastsd 424(%r8), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 448(%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 448(%rsi), %xmm8
; AVX2-NEXT:    vmovaps 448(%rdi), %xmm9
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm9[1],xmm8[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-NEXT:    vmovaps 448(%r9), %xmm1
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 448(%rcx), %xmm6
; AVX2-NEXT:    vmovaps 448(%rdx), %xmm7
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm7[1],xmm6[1]
; AVX2-NEXT:    vbroadcastsd 456(%r8), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 480(%r8), %ymm1
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 480(%rsi), %xmm4
; AVX2-NEXT:    vmovaps 480(%rdi), %xmm5
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm5[1],xmm4[1]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[0,1],ymm0[0,1]
; AVX2-NEXT:    vmovaps 480(%r9), %xmm0
; AVX2-NEXT:    vmovddup {{.*#+}} xmm2 = xmm0[0,0]
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 480(%rcx), %xmm2
; AVX2-NEXT:    vmovaps 480(%rdx), %xmm3
; AVX2-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm3[1],xmm2[1]
; AVX2-NEXT:    vbroadcastsd 488(%r8), %ymm14
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm14[4,5,6,7]
; AVX2-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vinsertf128 $1, %xmm15, %ymm1, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm10, %ymm12, %ymm0
; AVX2-NEXT:    vinsertf128 $1, %xmm11, %ymm13, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm6, %ymm8, %ymm0
; AVX2-NEXT:    vinsertf128 $1, %xmm7, %ymm9, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vinsertf128 $1, %xmm2, %ymm4, %ymm0
; AVX2-NEXT:    vinsertf128 $1, %xmm3, %ymm5, %ymm1
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 16(%rcx), %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 16(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 24(%r8), %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm12 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 32(%rdx), %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 48(%rcx), %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 48(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 56(%r8), %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm13 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovaps 64(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 64(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 64(%rdx), %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 80(%rcx), %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 80(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 88(%r8), %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovaps 96(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 96(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 96(%rdx), %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 112(%rcx), %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 112(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 120(%r8), %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 128(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 128(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 128(%rdx), %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 144(%rcx), %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 144(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 152(%r8), %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 160(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 160(%rdx), %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 176(%rcx), %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 176(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 184(%r8), %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 192(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 192(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 192(%rdx), %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 208(%rcx), %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 208(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 216(%r8), %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 224(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 224(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 224(%rdx), %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 240(%rcx), %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 240(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 248(%r8), %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 256(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 256(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 256(%rdx), %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 272(%rcx), %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 272(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 280(%r8), %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 288(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 288(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 288(%rdx), %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 304(%rcx), %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 304(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 312(%r8), %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 320(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 320(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 320(%rdx), %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 336(%rcx), %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 336(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 344(%r8), %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 352(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 352(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 352(%rdx), %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 368(%rcx), %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 368(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 376(%r8), %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovaps 384(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 384(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 384(%rdx), %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 400(%rcx), %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 400(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 408(%r8), %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm15 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovaps 416(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 416(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 416(%rdx), %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 432(%rcx), %ymm4
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 432(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 440(%r8), %ymm1
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm0[2,3],ymm1[2,3]
; AVX2-NEXT:    vmovaps 448(%rdi), %ymm0
; AVX2-NEXT:    vmovaps 448(%rsi), %ymm1
; AVX2-NEXT:    vmovaps 448(%rdx), %ymm2
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],ymm2[2,3]
; AVX2-NEXT:    vbroadcastsd 464(%rcx), %ymm5
; AVX2-NEXT:    vblendps {{.*#+}} ymm11 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-NEXT:    vbroadcastsd 464(%r9), %ymm1
; AVX2-NEXT:    vblendps {{.*#+}} ymm9 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 472(%r8), %ymm2
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm0[2,3],ymm2[2,3]
; AVX2-NEXT:    vmovaps 480(%rdi), %ymm1
; AVX2-NEXT:    vmovaps 480(%rsi), %ymm2
; AVX2-NEXT:    vmovaps 480(%rdx), %ymm4
; AVX2-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm7[2,3],ymm4[2,3]
; AVX2-NEXT:    vbroadcastsd 496(%rcx), %ymm8
; AVX2-NEXT:    vblendps {{.*#+}} ymm5 = ymm7[0,1,2,3,4,5],ymm8[6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-NEXT:    # ymm1 = mem[2,3],ymm1[2,3]
; AVX2-NEXT:    vbroadcastsd 496(%r9), %ymm2
; AVX2-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm4[1],mem[1],ymm4[3],mem[3]
; AVX2-NEXT:    vbroadcastsd 504(%r8), %ymm2
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[2,3],ymm2[2,3]
; AVX2-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm12[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm13[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm14[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vblendps {{.*#+}} ymm14 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vblendps {{.*#+}} ymm13 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vblendps {{.*#+}} ymm12 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vblendps {{.*#+}} ymm8 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vblendps {{.*#+}} ymm7 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vblendps {{.*#+}} ymm4 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm15 = ymm15[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-NEXT:    vmovaps %ymm0, 3040(%rax)
; AVX2-NEXT:    vmovaps %ymm3, 3008(%rax)
; AVX2-NEXT:    vmovaps %ymm5, 2976(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2880(%rax)
; AVX2-NEXT:    vmovaps %ymm6, 2848(%rax)
; AVX2-NEXT:    vmovaps %ymm9, 2816(%rax)
; AVX2-NEXT:    vmovaps %ymm11, 2784(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2688(%rax)
; AVX2-NEXT:    vmovaps %ymm10, 2656(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2624(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2592(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2496(%rax)
; AVX2-NEXT:    vmovaps %ymm15, 2464(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2432(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2400(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2304(%rax)
; AVX2-NEXT:    vmovaps %ymm1, 2272(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2240(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2208(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2112(%rax)
; AVX2-NEXT:    vmovaps %ymm2, 2080(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2048(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2016(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1920(%rax)
; AVX2-NEXT:    vmovaps %ymm4, 1888(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1856(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1824(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1728(%rax)
; AVX2-NEXT:    vmovaps %ymm7, 1696(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1664(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1632(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1536(%rax)
; AVX2-NEXT:    vmovaps %ymm8, 1504(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1472(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1440(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1344(%rax)
; AVX2-NEXT:    vmovaps %ymm12, 1312(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1280(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1248(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1152(%rax)
; AVX2-NEXT:    vmovaps %ymm13, 1120(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1088(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1056(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 960(%rax)
; AVX2-NEXT:    vmovaps %ymm14, 928(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 896(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 864(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 768(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 736(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 544(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2944(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2912(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2752(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2720(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2560(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2528(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2368(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2336(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2176(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 2144(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1984(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1952(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1792(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1760(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1600(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1568(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1408(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1376(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1216(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1184(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 1024(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 992(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-NEXT:    addq $2968, %rsp # imm = 0xB98
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX2-FP-LABEL: store_i64_stride6_vf64:
; AVX2-FP:       # %bb.0:
; AVX2-FP-NEXT:    subq $2968, %rsp # imm = 0xB98
; AVX2-FP-NEXT:    vmovaps 32(%r8), %ymm3
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%r8), %ymm4
; AVX2-FP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%r9), %xmm0
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm1 = xmm0[0,0]
; AVX2-FP-NEXT:    vmovaps (%rsi), %xmm7
; AVX2-FP-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %xmm5
; AVX2-FP-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rdi), %xmm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %xmm6
; AVX2-FP-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm2[1],xmm7[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm4[0,1],ymm2[0,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FP-NEXT:    vmovaps (%rcx), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rdx), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %xmm4
; AVX2-FP-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX2-FP-NEXT:    vbroadcastsd 8(%r8), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%r9), %xmm0
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm1 = xmm0[0,0]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm6[1],xmm5[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm3[0,1],ymm2[0,1]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 32(%rcx), %xmm1
; AVX2-FP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm4[1],xmm1[1]
; AVX2-FP-NEXT:    vbroadcastsd 40(%r8), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vmovaps 64(%r8), %ymm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %xmm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %xmm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm2[0,1],ymm0[0,1]
; AVX2-FP-NEXT:    vmovaps 64(%r9), %xmm1
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rdx), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 64(%rcx), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vbroadcastsd 72(%r8), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %xmm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %xmm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FP-NEXT:    vmovaps 96(%r9), %xmm1
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rcx), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 96(%rdx), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vbroadcastsd 104(%r8), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%rsi), %xmm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%rdi), %xmm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FP-NEXT:    vmovaps 128(%r9), %xmm1
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%rcx), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%rdx), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vbroadcastsd 136(%r8), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%rsi), %xmm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%rdi), %xmm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FP-NEXT:    vmovaps 160(%r9), %xmm1
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%rcx), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%rdx), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vbroadcastsd 168(%r8), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%rsi), %xmm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%rdi), %xmm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FP-NEXT:    vmovaps 192(%r9), %xmm1
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%rcx), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%rdx), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vbroadcastsd 200(%r8), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 224(%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 224(%rsi), %xmm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 224(%rdi), %xmm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FP-NEXT:    vmovaps 224(%r9), %xmm1
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 224(%rcx), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 224(%rdx), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vbroadcastsd 232(%r8), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 256(%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 256(%rsi), %xmm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 256(%rdi), %xmm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FP-NEXT:    vmovaps 256(%r9), %xmm1
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 256(%rcx), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 256(%rdx), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vbroadcastsd 264(%r8), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 288(%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 288(%rsi), %xmm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 288(%rdi), %xmm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FP-NEXT:    vmovaps 288(%r9), %xmm1
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 288(%rcx), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 288(%rdx), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vbroadcastsd 296(%r8), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 320(%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 320(%rsi), %xmm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 320(%rdi), %xmm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FP-NEXT:    vmovaps 320(%r9), %xmm1
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 320(%rcx), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 320(%rdx), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vbroadcastsd 328(%r8), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 352(%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 352(%rsi), %xmm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 352(%rdi), %xmm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FP-NEXT:    vmovaps 352(%r9), %xmm1
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 352(%rcx), %xmm2
; AVX2-FP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 352(%rdx), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vbroadcastsd 360(%r8), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 384(%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 384(%rsi), %xmm2
; AVX2-FP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 384(%rdi), %xmm0
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FP-NEXT:    vmovaps 384(%r9), %xmm1
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 384(%rcx), %xmm0
; AVX2-FP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FP-NEXT:    vmovaps 384(%rdx), %xmm15
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm15[1],xmm0[1]
; AVX2-FP-NEXT:    vbroadcastsd 392(%r8), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 416(%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 416(%rsi), %xmm12
; AVX2-FP-NEXT:    vmovaps 416(%rdi), %xmm13
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm13[1],xmm12[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FP-NEXT:    vmovaps 416(%r9), %xmm1
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 416(%rcx), %xmm10
; AVX2-FP-NEXT:    vmovaps 416(%rdx), %xmm11
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm11[1],xmm10[1]
; AVX2-FP-NEXT:    vbroadcastsd 424(%r8), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 448(%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 448(%rsi), %xmm8
; AVX2-FP-NEXT:    vmovaps 448(%rdi), %xmm9
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm9[1],xmm8[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FP-NEXT:    vmovaps 448(%r9), %xmm1
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 448(%rcx), %xmm6
; AVX2-FP-NEXT:    vmovaps 448(%rdx), %xmm7
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm7[1],xmm6[1]
; AVX2-FP-NEXT:    vbroadcastsd 456(%r8), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 480(%r8), %ymm1
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 480(%rsi), %xmm4
; AVX2-FP-NEXT:    vmovaps 480(%rdi), %xmm5
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm5[1],xmm4[1]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[0,1],ymm0[0,1]
; AVX2-FP-NEXT:    vmovaps 480(%r9), %xmm0
; AVX2-FP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm0[0,0]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 480(%rcx), %xmm2
; AVX2-FP-NEXT:    vmovaps 480(%rdx), %xmm3
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm3[1],xmm2[1]
; AVX2-FP-NEXT:    vbroadcastsd 488(%r8), %ymm14
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm14[4,5,6,7]
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm15, %ymm1, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm10, %ymm12, %ymm0
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm11, %ymm13, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm6, %ymm8, %ymm0
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm7, %ymm9, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm2, %ymm4, %ymm0
; AVX2-FP-NEXT:    vinsertf128 $1, %xmm3, %ymm5, %ymm1
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 16(%rcx), %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 16(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 24(%r8), %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm12 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 32(%rdx), %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 48(%rcx), %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 48(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 56(%r8), %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm13 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovaps 64(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 64(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 64(%rdx), %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 80(%rcx), %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 80(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 88(%r8), %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovaps 96(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 96(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 96(%rdx), %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 112(%rcx), %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 112(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 120(%r8), %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 128(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 128(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 128(%rdx), %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 144(%rcx), %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 144(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 152(%r8), %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 160(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 160(%rdx), %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 176(%rcx), %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 176(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 184(%r8), %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 192(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 192(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 192(%rdx), %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 208(%rcx), %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 208(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 216(%r8), %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 224(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 224(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 224(%rdx), %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 240(%rcx), %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 240(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 248(%r8), %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 256(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 256(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 256(%rdx), %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 272(%rcx), %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 272(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 280(%r8), %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 288(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 288(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 288(%rdx), %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 304(%rcx), %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 304(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 312(%r8), %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 320(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 320(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 320(%rdx), %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 336(%rcx), %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 336(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 344(%r8), %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 352(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 352(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 352(%rdx), %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 368(%rcx), %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 368(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 376(%r8), %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovaps 384(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 384(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 384(%rdx), %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 400(%rcx), %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 400(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 408(%r8), %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm15 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovaps 416(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 416(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 416(%rdx), %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 432(%rcx), %ymm4
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 432(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 440(%r8), %ymm1
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm0[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vmovaps 448(%rdi), %ymm0
; AVX2-FP-NEXT:    vmovaps 448(%rsi), %ymm1
; AVX2-FP-NEXT:    vmovaps 448(%rdx), %ymm2
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 464(%rcx), %ymm5
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm11 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 464(%r9), %ymm1
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm9 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 472(%r8), %ymm2
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm0[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    vmovaps 480(%rdi), %ymm1
; AVX2-FP-NEXT:    vmovaps 480(%rsi), %ymm2
; AVX2-FP-NEXT:    vmovaps 480(%rdx), %ymm4
; AVX2-FP-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm7[2,3],ymm4[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 496(%rcx), %ymm8
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm5 = ymm7[0,1,2,3,4,5],ymm8[6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-FP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FP-NEXT:    # ymm1 = mem[2,3],ymm1[2,3]
; AVX2-FP-NEXT:    vbroadcastsd 496(%r9), %ymm2
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm4[1],mem[1],ymm4[3],mem[3]
; AVX2-FP-NEXT:    vbroadcastsd 504(%r8), %ymm2
; AVX2-FP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[2,3],ymm2[2,3]
; AVX2-FP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm12[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm13[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm14[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm14 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm13 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm12 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm8 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm7 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm4 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm15 = ymm15[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-FP-NEXT:    vmovaps %ymm0, 3040(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm3, 3008(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm5, 2976(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2880(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm6, 2848(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm9, 2816(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm11, 2784(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2688(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm10, 2656(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2624(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2592(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2496(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm15, 2464(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2432(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2400(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2304(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm1, 2272(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2240(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2208(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2112(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm2, 2080(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2048(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2016(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1920(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm4, 1888(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1856(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1824(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1728(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm7, 1696(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1664(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1632(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1536(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm8, 1504(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1472(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1440(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1344(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm12, 1312(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1280(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1248(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1152(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm13, 1120(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1088(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1056(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 960(%rax)
; AVX2-FP-NEXT:    vmovaps %ymm14, 928(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 896(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 864(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 768(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 736(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 544(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2944(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2912(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2752(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2720(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2560(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2528(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2368(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2336(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2176(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 2144(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1984(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1952(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1792(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1760(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1600(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1568(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1408(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1376(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1216(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1184(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 1024(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 992(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-FP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FP-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FP-NEXT:    addq $2968, %rsp # imm = 0xB98
; AVX2-FP-NEXT:    vzeroupper
; AVX2-FP-NEXT:    retq
;
; AVX2-FCP-LABEL: store_i64_stride6_vf64:
; AVX2-FCP:       # %bb.0:
; AVX2-FCP-NEXT:    subq $2968, %rsp # imm = 0xB98
; AVX2-FCP-NEXT:    vmovaps 32(%r8), %ymm3
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%r8), %ymm4
; AVX2-FCP-NEXT:    vmovups %ymm4, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%r9), %xmm0
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm1 = xmm0[0,0]
; AVX2-FCP-NEXT:    vmovaps (%rsi), %xmm7
; AVX2-FCP-NEXT:    vmovups %ymm7, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %xmm5
; AVX2-FCP-NEXT:    vmovups %ymm5, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rdi), %xmm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %xmm6
; AVX2-FCP-NEXT:    vmovups %ymm6, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm2[1],xmm7[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm4[0,1],ymm2[0,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vmovaps (%rcx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rdx), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %xmm4
; AVX2-FCP-NEXT:    vmovaps %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; AVX2-FCP-NEXT:    vbroadcastsd 8(%r8), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%r9), %xmm0
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm1 = xmm0[0,0]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm2 = xmm6[1],xmm5[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm2 = ymm3[0,1],ymm2[0,1]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm2[0,1],ymm1[2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 32(%rcx), %xmm1
; AVX2-FCP-NEXT:    vmovaps %xmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm4[1],xmm1[1]
; AVX2-FCP-NEXT:    vbroadcastsd 40(%r8), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vmovaps 64(%r8), %ymm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %xmm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm2[0,1],ymm0[0,1]
; AVX2-FCP-NEXT:    vmovaps 64(%r9), %xmm1
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rdx), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 64(%rcx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vbroadcastsd 72(%r8), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%r8), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %xmm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FCP-NEXT:    vmovaps 96(%r9), %xmm1
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rcx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 96(%rdx), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vbroadcastsd 104(%r8), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%r8), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%rsi), %xmm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FCP-NEXT:    vmovaps 128(%r9), %xmm1
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%rcx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%rdx), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vbroadcastsd 136(%r8), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%r8), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%rsi), %xmm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FCP-NEXT:    vmovaps 160(%r9), %xmm1
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%rcx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%rdx), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vbroadcastsd 168(%r8), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 192(%r8), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 192(%rsi), %xmm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 192(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FCP-NEXT:    vmovaps 192(%r9), %xmm1
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 192(%rcx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 192(%rdx), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vbroadcastsd 200(%r8), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 224(%r8), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 224(%rsi), %xmm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 224(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FCP-NEXT:    vmovaps 224(%r9), %xmm1
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 224(%rcx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 224(%rdx), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vbroadcastsd 232(%r8), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 256(%r8), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 256(%rsi), %xmm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 256(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FCP-NEXT:    vmovaps 256(%r9), %xmm1
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 256(%rcx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 256(%rdx), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vbroadcastsd 264(%r8), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 288(%r8), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 288(%rsi), %xmm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 288(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FCP-NEXT:    vmovaps 288(%r9), %xmm1
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 288(%rcx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 288(%rdx), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vbroadcastsd 296(%r8), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 320(%r8), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 320(%rsi), %xmm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 320(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FCP-NEXT:    vmovaps 320(%r9), %xmm1
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 320(%rcx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 320(%rdx), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vbroadcastsd 328(%r8), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 352(%r8), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 352(%rsi), %xmm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 352(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FCP-NEXT:    vmovaps 352(%r9), %xmm1
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 352(%rcx), %xmm2
; AVX2-FCP-NEXT:    vmovaps %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 352(%rdx), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vbroadcastsd 360(%r8), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 384(%r8), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 384(%rsi), %xmm2
; AVX2-FCP-NEXT:    vmovups %ymm2, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 384(%rdi), %xmm0
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm0[1],xmm2[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FCP-NEXT:    vmovaps 384(%r9), %xmm1
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 384(%rcx), %xmm0
; AVX2-FCP-NEXT:    vmovaps %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX2-FCP-NEXT:    vmovaps 384(%rdx), %xmm15
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm15[1],xmm0[1]
; AVX2-FCP-NEXT:    vbroadcastsd 392(%r8), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 416(%r8), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 416(%rsi), %xmm12
; AVX2-FCP-NEXT:    vmovaps 416(%rdi), %xmm13
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm13[1],xmm12[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FCP-NEXT:    vmovaps 416(%r9), %xmm1
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 416(%rcx), %xmm10
; AVX2-FCP-NEXT:    vmovaps 416(%rdx), %xmm11
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm11[1],xmm10[1]
; AVX2-FCP-NEXT:    vbroadcastsd 424(%r8), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 448(%r8), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 448(%rsi), %xmm8
; AVX2-FCP-NEXT:    vmovaps 448(%rdi), %xmm9
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm9[1],xmm8[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[0,1],ymm0[0,1]
; AVX2-FCP-NEXT:    vmovaps 448(%r9), %xmm1
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm1[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm2[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 448(%rcx), %xmm6
; AVX2-FCP-NEXT:    vmovaps 448(%rdx), %xmm7
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm7[1],xmm6[1]
; AVX2-FCP-NEXT:    vbroadcastsd 456(%r8), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3],ymm2[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],ymm1[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 480(%r8), %ymm1
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 480(%rsi), %xmm4
; AVX2-FCP-NEXT:    vmovaps 480(%rdi), %xmm5
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm0 = xmm5[1],xmm4[1]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm1[0,1],ymm0[0,1]
; AVX2-FCP-NEXT:    vmovaps 480(%r9), %xmm0
; AVX2-FCP-NEXT:    vmovddup {{.*#+}} xmm2 = xmm0[0,0]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 480(%rcx), %xmm2
; AVX2-FCP-NEXT:    vmovaps 480(%rdx), %xmm3
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} xmm1 = xmm3[1],xmm2[1]
; AVX2-FCP-NEXT:    vbroadcastsd 488(%r8), %ymm14
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3],ymm14[4,5,6,7]
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm0, %ymm0, %ymm0
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2,3,4,5],ymm0[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 16-byte Folded Reload
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm15, %ymm1, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm10, %ymm12, %ymm0
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm11, %ymm13, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm6, %ymm8, %ymm0
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm7, %ymm9, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm2, %ymm4, %ymm0
; AVX2-FCP-NEXT:    vinsertf128 $1, %xmm3, %ymm5, %ymm1
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm0 = ymm1[0],ymm0[0],ymm1[2],ymm0[2]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps (%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps (%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps (%rdx), %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 16(%rcx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 16(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 24(%r8), %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm12 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovaps 32(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 32(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 32(%rdx), %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 48(%rcx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 48(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 56(%r8), %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm13 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovaps 64(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 64(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 64(%rdx), %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 80(%rcx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 80(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 88(%r8), %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm14 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovaps 96(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 96(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 96(%rdx), %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 112(%rcx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 112(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 120(%r8), %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 128(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 128(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 128(%rdx), %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 144(%rcx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 144(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 152(%r8), %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 160(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 160(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 160(%rdx), %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 176(%rcx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 176(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 184(%r8), %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 192(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 192(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 192(%rdx), %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 208(%rcx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 208(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 216(%r8), %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 224(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 224(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 224(%rdx), %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 240(%rcx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 240(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 248(%r8), %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 256(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 256(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 256(%rdx), %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 272(%rcx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 272(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 280(%r8), %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 288(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 288(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 288(%rdx), %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 304(%rcx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 304(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 312(%r8), %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 320(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 320(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 320(%rdx), %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 336(%rcx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 336(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 344(%r8), %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 352(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 352(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 352(%rdx), %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 368(%rcx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 368(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 376(%r8), %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovaps 384(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 384(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 384(%rdx), %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 400(%rcx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 400(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 408(%r8), %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm15 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovaps 416(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 416(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 416(%rdx), %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm3 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm3 = ymm3[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 432(%rcx), %ymm4
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm3[0,1,2,3,4,5],ymm4[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm3, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 432(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vmovups %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 440(%r8), %ymm1
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm10 = ymm0[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vmovaps 448(%rdi), %ymm0
; AVX2-FCP-NEXT:    vmovaps 448(%rsi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 448(%rdx), %ymm2
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm4 = ymm0[0],ymm1[0],ymm0[2],ymm1[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm4 = ymm4[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 464(%rcx), %ymm5
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm11 = ymm4[0,1,2,3,4,5],ymm5[6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm0[1],ymm1[1],ymm0[3],ymm1[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm0, %ymm0 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm0 = mem[2,3],ymm0[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 464(%r9), %ymm1
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm9 = ymm0[0,1],ymm1[2,3],ymm0[4,5,6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm0 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 472(%r8), %ymm2
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm6 = ymm0[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    vmovaps 480(%rdi), %ymm1
; AVX2-FCP-NEXT:    vmovaps 480(%rsi), %ymm2
; AVX2-FCP-NEXT:    vmovaps 480(%rdx), %ymm4
; AVX2-FCP-NEXT:    vunpcklpd {{.*#+}} ymm7 = ymm1[0],ymm2[0],ymm1[2],ymm2[2]
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm7 = ymm7[2,3],ymm4[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 496(%rcx), %ymm8
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm5 = ymm7[0,1,2,3,4,5],ymm8[6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm1[1],ymm2[1],ymm1[3],ymm2[3]
; AVX2-FCP-NEXT:    vperm2f128 $19, {{[-0-9]+}}(%r{{[sb]}}p), %ymm1, %ymm1 # 32-byte Folded Reload
; AVX2-FCP-NEXT:    # ymm1 = mem[2,3],ymm1[2,3]
; AVX2-FCP-NEXT:    vbroadcastsd 496(%r9), %ymm2
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm3 = ymm1[0,1],ymm2[2,3],ymm1[4,5,6,7]
; AVX2-FCP-NEXT:    vunpckhpd {{.*#+}} ymm1 = ymm4[1],mem[1],ymm4[3],mem[3]
; AVX2-FCP-NEXT:    vbroadcastsd 504(%r8), %ymm2
; AVX2-FCP-NEXT:    vperm2f128 {{.*#+}} ymm0 = ymm1[2,3],ymm2[2,3]
; AVX2-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm12[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm13[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm14[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovups %ymm1, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm14 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm13 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm12 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm8 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm7 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm4 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm2 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm1 # 32-byte Reload
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm15 = ymm15[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm10 = ymm10[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm6 = ymm6[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vblendps {{.*#+}} ymm0 = ymm0[0,1,2,3,4,5],mem[6,7]
; AVX2-FCP-NEXT:    vmovaps %ymm0, 3040(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm3, 3008(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm5, 2976(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2880(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm6, 2848(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm9, 2816(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm11, 2784(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2688(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm10, 2656(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2624(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2592(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2496(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm15, 2464(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2432(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2400(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2304(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm1, 2272(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2240(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2208(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2112(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm2, 2080(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2048(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2016(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1920(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm4, 1888(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1856(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1824(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1728(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm7, 1696(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1664(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1632(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1536(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm8, 1504(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1472(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1440(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1344(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm12, 1312(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1280(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1248(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1152(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm13, 1120(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1088(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1056(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 960(%rax)
; AVX2-FCP-NEXT:    vmovaps %ymm14, 928(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 896(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 864(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 768(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 736(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 704(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 672(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 576(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 544(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 512(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 480(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 384(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 352(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 320(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 288(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 192(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 160(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 128(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 96(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, (%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2944(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2912(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2752(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2720(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2560(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2528(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2368(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2336(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2176(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 2144(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1984(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1952(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1792(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1760(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1600(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1568(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1408(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1376(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1216(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1184(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 1024(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 992(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 832(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 800(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 640(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 608(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 448(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 416(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 256(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 224(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 64(%rax)
; AVX2-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %ymm0 # 32-byte Reload
; AVX2-FCP-NEXT:    vmovaps %ymm0, 32(%rax)
; AVX2-FCP-NEXT:    addq $2968, %rsp # imm = 0xB98
; AVX2-FCP-NEXT:    vzeroupper
; AVX2-FCP-NEXT:    retq
;
; AVX512-LABEL: store_i64_stride6_vf64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    subq $3720, %rsp # imm = 0xE88
; AVX512-NEXT:    vmovdqa64 (%rdi), %zmm11
; AVX512-NEXT:    vmovdqa64 64(%rdi), %zmm10
; AVX512-NEXT:    vmovdqa64 128(%rdi), %zmm9
; AVX512-NEXT:    vmovdqa64 192(%rdi), %zmm8
; AVX512-NEXT:    vmovdqa64 256(%rdi), %zmm7
; AVX512-NEXT:    vmovdqa64 320(%rdi), %zmm6
; AVX512-NEXT:    vmovdqa64 384(%rdi), %zmm5
; AVX512-NEXT:    vmovdqa64 448(%rdi), %zmm4
; AVX512-NEXT:    vmovdqa64 (%rsi), %zmm30
; AVX512-NEXT:    vmovdqa64 64(%rsi), %zmm29
; AVX512-NEXT:    vmovdqa64 128(%rsi), %zmm28
; AVX512-NEXT:    vmovdqa64 192(%rsi), %zmm27
; AVX512-NEXT:    vmovdqa64 256(%rsi), %zmm1
; AVX512-NEXT:    vmovdqa64 320(%rsi), %zmm13
; AVX512-NEXT:    vmovdqa64 384(%rsi), %zmm24
; AVX512-NEXT:    vmovdqa64 448(%rsi), %zmm0
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [4,12,5,13,4,12,5,13]
; AVX512-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm22
; AVX512-NEXT:    vpermt2q %zmm0, %zmm2, %zmm22
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm3
; AVX512-NEXT:    vpermt2q %zmm24, %zmm2, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm6, %zmm3
; AVX512-NEXT:    vpermt2q %zmm13, %zmm2, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm3
; AVX512-NEXT:    vpermt2q %zmm1, %zmm2, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm8, %zmm3
; AVX512-NEXT:    vpermt2q %zmm27, %zmm2, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm9, %zmm3
; AVX512-NEXT:    vpermt2q %zmm28, %zmm2, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm10, %zmm3
; AVX512-NEXT:    vpermt2q %zmm29, %zmm2, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermi2q %zmm30, %zmm11, %zmm2
; AVX512-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} zmm12 = [2,10,2,10,2,10,2,10]
; AVX512-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm11, %zmm3
; AVX512-NEXT:    vpermt2q %zmm30, %zmm12, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [6,14,6,14,6,14,6,14]
; AVX512-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm11, %zmm3
; AVX512-NEXT:    vpermt2q %zmm30, %zmm2, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} zmm21 = [7,15,7,15,7,15,7,15]
; AVX512-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm11, %zmm3
; AVX512-NEXT:    vpermt2q %zmm30, %zmm21, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm10, %zmm3
; AVX512-NEXT:    vpermt2q %zmm29, %zmm12, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,8,1,9,0,8,1,9]
; AVX512-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermt2q %zmm30, %zmm3, %zmm11
; AVX512-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm10, %zmm11
; AVX512-NEXT:    vpermt2q %zmm29, %zmm2, %zmm11
; AVX512-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm10, %zmm11
; AVX512-NEXT:    vpermt2q %zmm29, %zmm21, %zmm11
; AVX512-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm29, %zmm3, %zmm10
; AVX512-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512-NEXT:    vpermt2q %zmm28, %zmm12, %zmm10
; AVX512-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512-NEXT:    vpermt2q %zmm28, %zmm2, %zmm10
; AVX512-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512-NEXT:    vpermt2q %zmm28, %zmm21, %zmm10
; AVX512-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm28, %zmm3, %zmm9
; AVX512-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512-NEXT:    vpermt2q %zmm27, %zmm12, %zmm9
; AVX512-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512-NEXT:    vpermt2q %zmm27, %zmm2, %zmm9
; AVX512-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512-NEXT:    vpermt2q %zmm27, %zmm21, %zmm9
; AVX512-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm27, %zmm3, %zmm8
; AVX512-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm8
; AVX512-NEXT:    vpermt2q %zmm1, %zmm12, %zmm8
; AVX512-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm8
; AVX512-NEXT:    vpermt2q %zmm1, %zmm2, %zmm8
; AVX512-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm8
; AVX512-NEXT:    vpermt2q %zmm1, %zmm21, %zmm8
; AVX512-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm1, %zmm3, %zmm7
; AVX512-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512-NEXT:    vpermt2q %zmm13, %zmm12, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512-NEXT:    vpermt2q %zmm13, %zmm2, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512-NEXT:    vpermt2q %zmm13, %zmm21, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm13, %zmm3, %zmm6
; AVX512-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512-NEXT:    vpermt2q %zmm24, %zmm12, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512-NEXT:    vpermt2q %zmm24, %zmm2, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm8
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512-NEXT:    vpermt2q %zmm24, %zmm21, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm24, %zmm3, %zmm5
; AVX512-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 (%rdx), %zmm5
; AVX512-NEXT:    vmovdqa64 (%rcx), %zmm14
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm29
; AVX512-NEXT:    vpermt2q %zmm14, %zmm21, %zmm29
; AVX512-NEXT:    vmovdqa64 64(%rdx), %zmm1
; AVX512-NEXT:    vmovdqa64 64(%rcx), %zmm11
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm20
; AVX512-NEXT:    vpermt2q %zmm11, %zmm21, %zmm2
; AVX512-NEXT:    vmovdqu64 %zmm2, (%rsp) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 128(%rdx), %zmm23
; AVX512-NEXT:    vmovdqa64 128(%rcx), %zmm9
; AVX512-NEXT:    vmovdqa64 %zmm23, %zmm1
; AVX512-NEXT:    vpermt2q %zmm9, %zmm21, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 192(%rdx), %zmm18
; AVX512-NEXT:    vmovdqa64 192(%rcx), %zmm6
; AVX512-NEXT:    vmovdqa64 %zmm18, %zmm1
; AVX512-NEXT:    vpermt2q %zmm6, %zmm21, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 256(%rdx), %zmm17
; AVX512-NEXT:    vmovdqa64 256(%rcx), %zmm7
; AVX512-NEXT:    vmovdqa64 %zmm17, %zmm1
; AVX512-NEXT:    vpermt2q %zmm7, %zmm21, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 320(%rdx), %zmm15
; AVX512-NEXT:    vmovdqa64 320(%rcx), %zmm10
; AVX512-NEXT:    vmovdqa64 %zmm15, %zmm1
; AVX512-NEXT:    vpermt2q %zmm10, %zmm21, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 384(%rdx), %zmm13
; AVX512-NEXT:    vmovdqa64 384(%rcx), %zmm2
; AVX512-NEXT:    vmovdqa64 %zmm13, %zmm1
; AVX512-NEXT:    vpermt2q %zmm2, %zmm21, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm1
; AVX512-NEXT:    vpermi2q %zmm0, %zmm4, %zmm12
; AVX512-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermi2q %zmm0, %zmm4, %zmm8
; AVX512-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 448(%rdx), %zmm16
; AVX512-NEXT:    vmovdqa64 448(%rcx), %zmm4
; AVX512-NEXT:    vmovdqa64 %zmm16, %zmm8
; AVX512-NEXT:    vpermt2q %zmm4, %zmm21, %zmm8
; AVX512-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermi2q %zmm0, %zmm1, %zmm21
; AVX512-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm0, %zmm3, %zmm1
; AVX512-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,0,4,12]
; AVX512-NEXT:    vmovdqa64 %zmm16, %zmm24
; AVX512-NEXT:    vpermt2q %zmm4, %zmm1, %zmm24
; AVX512-NEXT:    vmovdqa64 %zmm13, %zmm19
; AVX512-NEXT:    vpermt2q %zmm2, %zmm1, %zmm19
; AVX512-NEXT:    vmovdqa64 %zmm15, %zmm0
; AVX512-NEXT:    vpermt2q %zmm10, %zmm1, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm17, %zmm31
; AVX512-NEXT:    vpermt2q %zmm7, %zmm1, %zmm31
; AVX512-NEXT:    vmovdqa64 %zmm18, %zmm21
; AVX512-NEXT:    vpermt2q %zmm6, %zmm1, %zmm21
; AVX512-NEXT:    vmovdqa64 %zmm23, %zmm12
; AVX512-NEXT:    vpermt2q %zmm9, %zmm1, %zmm12
; AVX512-NEXT:    vmovdqa64 %zmm20, %zmm3
; AVX512-NEXT:    vpermt2q %zmm11, %zmm1, %zmm3
; AVX512-NEXT:    vpermi2q %zmm14, %zmm5, %zmm1
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm27 = [1,9,2,10,1,9,2,10]
; AVX512-NEXT:    # zmm27 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512-NEXT:    vpermt2q %zmm14, %zmm27, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [5,13,6,14,5,13,6,14]
; AVX512-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512-NEXT:    vpermt2q %zmm14, %zmm28, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [3,11,3,11,3,11,3,11]
; AVX512-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-NEXT:    vpermt2q %zmm14, %zmm0, %zmm5
; AVX512-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm20, %zmm5
; AVX512-NEXT:    vpermt2q %zmm11, %zmm27, %zmm5
; AVX512-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm20, %zmm5
; AVX512-NEXT:    vpermt2q %zmm11, %zmm28, %zmm5
; AVX512-NEXT:    vpermt2q %zmm11, %zmm0, %zmm20
; AVX512-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm23, %zmm8
; AVX512-NEXT:    vpermt2q %zmm9, %zmm27, %zmm8
; AVX512-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm23, %zmm11
; AVX512-NEXT:    vpermt2q %zmm9, %zmm28, %zmm11
; AVX512-NEXT:    vmovdqa64 %zmm11, %zmm30
; AVX512-NEXT:    vpermt2q %zmm9, %zmm0, %zmm23
; AVX512-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm18, %zmm9
; AVX512-NEXT:    vpermt2q %zmm6, %zmm27, %zmm9
; AVX512-NEXT:    vmovdqa64 %zmm18, %zmm8
; AVX512-NEXT:    vpermt2q %zmm6, %zmm28, %zmm8
; AVX512-NEXT:    vpermt2q %zmm6, %zmm0, %zmm18
; AVX512-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm17, %zmm6
; AVX512-NEXT:    vpermt2q %zmm7, %zmm27, %zmm6
; AVX512-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm17, %zmm6
; AVX512-NEXT:    vmovdqa64 %zmm17, %zmm14
; AVX512-NEXT:    vpermt2q %zmm7, %zmm28, %zmm6
; AVX512-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512-NEXT:    vpermt2q %zmm7, %zmm0, %zmm14
; AVX512-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm15, %zmm6
; AVX512-NEXT:    vmovdqa64 %zmm15, %zmm7
; AVX512-NEXT:    vpermt2q %zmm10, %zmm27, %zmm7
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm26
; AVX512-NEXT:    vmovdqa64 %zmm15, %zmm7
; AVX512-NEXT:    vpermt2q %zmm10, %zmm28, %zmm7
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm25
; AVX512-NEXT:    vpermt2q %zmm10, %zmm0, %zmm6
; AVX512-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm13, %zmm6
; AVX512-NEXT:    vmovdqa64 %zmm13, %zmm7
; AVX512-NEXT:    vpermt2q %zmm2, %zmm27, %zmm7
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm10
; AVX512-NEXT:    vmovdqa64 %zmm13, %zmm7
; AVX512-NEXT:    vpermt2q %zmm2, %zmm28, %zmm7
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm23
; AVX512-NEXT:    vpermt2q %zmm2, %zmm0, %zmm6
; AVX512-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermi2q %zmm4, %zmm16, %zmm27
; AVX512-NEXT:    vpermi2q %zmm4, %zmm16, %zmm28
; AVX512-NEXT:    vpermt2q %zmm4, %zmm0, %zmm16
; AVX512-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    movb $12, %al
; AVX512-NEXT:    kmovw %eax, %k1
; AVX512-NEXT:    vmovdqa64 %zmm24, %zmm22 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm19, %zmm18 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm19 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm17 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm31, %zmm17 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm21, %zmm16 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm12, %zmm21 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm3, %zmm31 {%k1}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm20 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm20 {%k1}
; AVX512-NEXT:    movb $48, %al
; AVX512-NEXT:    kmovw %eax, %k2
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vshufi64x2 {{.*#+}} zmm14 = zmm0[0,1,2,3],zmm29[4,5,6,7]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vshufi64x2 $228, (%rsp), %zmm0, %zmm0 # 64-byte Folded Reload
; AVX512-NEXT:    # zmm0 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm15 # 64-byte Folded Reload
; AVX512-NEXT:    # zmm15 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm13 # 64-byte Folded Reload
; AVX512-NEXT:    # zmm13 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm12 # 64-byte Folded Reload
; AVX512-NEXT:    # zmm12 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm26 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm25 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm0 # 64-byte Folded Reload
; AVX512-NEXT:    # zmm0 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k2}
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm0 # 64-byte Folded Reload
; AVX512-NEXT:    # zmm0 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k2}
; AVX512-NEXT:    vmovdqa64 (%r8), %zmm29
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,9,0,4,5,6,7]
; AVX512-NEXT:    vpermt2q %zmm29, %zmm1, %zmm2
; AVX512-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 64(%r8), %zmm2
; AVX512-NEXT:    vpermt2q %zmm2, %zmm1, %zmm4
; AVX512-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 128(%r8), %zmm0
; AVX512-NEXT:    vpermt2q %zmm0, %zmm1, %zmm6
; AVX512-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 192(%r8), %zmm4
; AVX512-NEXT:    vpermt2q %zmm4, %zmm1, %zmm9
; AVX512-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 256(%r8), %zmm6
; AVX512-NEXT:    vpermt2q %zmm6, %zmm1, %zmm7
; AVX512-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 320(%r8), %zmm7
; AVX512-NEXT:    vpermt2q %zmm7, %zmm1, %zmm26
; AVX512-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 384(%r8), %zmm9
; AVX512-NEXT:    vpermt2q %zmm9, %zmm1, %zmm10
; AVX512-NEXT:    vmovdqa64 %zmm10, %zmm24
; AVX512-NEXT:    vmovdqa64 448(%r8), %zmm10
; AVX512-NEXT:    vpermt2q %zmm10, %zmm1, %zmm27
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm28 {%k2}
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,13,0,4,5,6,7]
; AVX512-NEXT:    vpermt2q %zmm29, %zmm1, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm2, %zmm1, %zmm5
; AVX512-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm0, %zmm1, %zmm30
; AVX512-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm4, %zmm1, %zmm8
; AVX512-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm6, %zmm1, %zmm11
; AVX512-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm7, %zmm1, %zmm25
; AVX512-NEXT:    vmovdqu64 %zmm25, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm9, %zmm1, %zmm23
; AVX512-NEXT:    vpermt2q %zmm10, %zmm1, %zmm28
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm3 # 64-byte Folded Reload
; AVX512-NEXT:    # zmm3 = zmm1[0,1,2,3],mem[4,5,6,7]
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [14,0,2,3,4,5,15,0]
; AVX512-NEXT:    vpermt2q %zmm29, %zmm1, %zmm14
; AVX512-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 (%rsp), %zmm14 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm2, %zmm1, %zmm14
; AVX512-NEXT:    vpermt2q %zmm0, %zmm1, %zmm15
; AVX512-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm4, %zmm1, %zmm13
; AVX512-NEXT:    vpermt2q %zmm6, %zmm1, %zmm12
; AVX512-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm7, %zmm1, %zmm12
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm9, %zmm1, %zmm15
; AVX512-NEXT:    vpermt2q %zmm10, %zmm1, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-NEXT:    vinserti64x4 $0, %ymm1, %zmm3, %zmm3
; AVX512-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX512-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512-NEXT:    vinserti64x4 $0, %ymm1, %zmm5, %zmm5
; AVX512-NEXT:    movb $16, %al
; AVX512-NEXT:    kmovw %eax, %k2
; AVX512-NEXT:    vmovdqa64 %zmm2, %zmm31 {%k2}
; AVX512-NEXT:    vmovdqu64 %zmm31, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [10,0,2,3,4,5,11,0]
; AVX512-NEXT:    vpermt2q %zmm2, %zmm1, %zmm5
; AVX512-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa 128(%rdi), %ymm2
; AVX512-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512-NEXT:    vinserti64x4 $0, %ymm2, %zmm5, %zmm31
; AVX512-NEXT:    vmovdqa64 %zmm0, %zmm21 {%k2}
; AVX512-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm0, %zmm1, %zmm31
; AVX512-NEXT:    vmovdqa 192(%rdi), %ymm2
; AVX512-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm30
; AVX512-NEXT:    vmovdqa64 %zmm4, %zmm16 {%k2}
; AVX512-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm4, %zmm1, %zmm30
; AVX512-NEXT:    vmovdqa 256(%rdi), %ymm2
; AVX512-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm26
; AVX512-NEXT:    vmovdqa64 %zmm6, %zmm17 {%k2}
; AVX512-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm6, %zmm1, %zmm26
; AVX512-NEXT:    vmovdqa 320(%rdi), %ymm2
; AVX512-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm25
; AVX512-NEXT:    vmovdqa64 %zmm7, %zmm19 {%k2}
; AVX512-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm7, %zmm1, %zmm25
; AVX512-NEXT:    vmovdqa 384(%rdi), %ymm2
; AVX512-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm19
; AVX512-NEXT:    vmovdqa64 %zmm9, %zmm18 {%k2}
; AVX512-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm9, %zmm1, %zmm19
; AVX512-NEXT:    vmovdqa 448(%rdi), %ymm2
; AVX512-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm16
; AVX512-NEXT:    vmovdqa64 %zmm10, %zmm22 {%k2}
; AVX512-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm10, %zmm1, %zmm16
; AVX512-NEXT:    vpermt2q %zmm29, %zmm1, %zmm3
; AVX512-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 %zmm29, %zmm20 {%k2}
; AVX512-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 (%r9), %zmm29
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,1,2,9,4,5,6,7]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm29, %zmm6, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 64(%r9), %zmm3
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm3, %zmm6, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 128(%r9), %zmm4
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm4, %zmm6, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 192(%r9), %zmm5
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm5, %zmm6, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 256(%r9), %zmm11
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm11, %zmm6, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 320(%r9), %zmm8
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm8, %zmm6, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 384(%r9), %zmm7
; AVX512-NEXT:    vpermt2q %zmm7, %zmm6, %zmm24
; AVX512-NEXT:    vmovdqu64 %zmm24, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa64 448(%r9), %zmm22
; AVX512-NEXT:    vpermt2q %zmm22, %zmm6, %zmm27
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,1,2,13,4,5,6,7]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm29, %zmm6, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm3, %zmm6, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm4, %zmm6, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm5, %zmm6, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm11, %zmm6, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm8, %zmm6, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm7, %zmm6, %zmm23
; AVX512-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm22, %zmm6, %zmm28
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,14,2,3,4,5,6,15]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm29, %zmm6, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm3, %zmm6, %zmm14
; AVX512-NEXT:    vmovdqu64 %zmm14, (%rsp) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm4, %zmm6, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm5, %zmm6, %zmm13
; AVX512-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm11, %zmm6, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm8, %zmm6, %zmm12
; AVX512-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vpermt2q %zmm7, %zmm6, %zmm15
; AVX512-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm22, %zmm6, %zmm0
; AVX512-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-NEXT:    vmovdqa (%rdx), %xmm6
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm0 {%k1}
; AVX512-NEXT:    vmovdqa 64(%rdx), %xmm6
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm14 {%k1}
; AVX512-NEXT:    vmovdqa 128(%rdx), %xmm6
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm15 {%k1}
; AVX512-NEXT:    vmovdqa 192(%rdx), %xmm6
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm10 {%k1}
; AVX512-NEXT:    vmovdqa 256(%rdx), %xmm6
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm12 {%k1}
; AVX512-NEXT:    vmovdqa 320(%rdx), %xmm6
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm2 {%k1}
; AVX512-NEXT:    vmovdqa 384(%rdx), %xmm6
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm9 {%k1}
; AVX512-NEXT:    vmovdqa 448(%rdx), %xmm6
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm1 {%k1}
; AVX512-NEXT:    vinserti32x4 $2, (%r8), %zmm0, %zmm24
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [0,1,2,3,4,8,6,7]
; AVX512-NEXT:    vpermt2q %zmm29, %zmm0, %zmm24
; AVX512-NEXT:    vinserti32x4 $2, 64(%r8), %zmm14, %zmm23
; AVX512-NEXT:    vpermt2q %zmm3, %zmm0, %zmm23
; AVX512-NEXT:    vinserti32x4 $2, 128(%r8), %zmm15, %zmm21
; AVX512-NEXT:    vpermt2q %zmm4, %zmm0, %zmm21
; AVX512-NEXT:    vinserti32x4 $2, 192(%r8), %zmm10, %zmm20
; AVX512-NEXT:    vpermt2q %zmm5, %zmm0, %zmm20
; AVX512-NEXT:    vinserti32x4 $2, 256(%r8), %zmm12, %zmm18
; AVX512-NEXT:    vpermt2q %zmm11, %zmm0, %zmm18
; AVX512-NEXT:    vinserti32x4 $2, 320(%r8), %zmm2, %zmm17
; AVX512-NEXT:    vpermt2q %zmm8, %zmm0, %zmm17
; AVX512-NEXT:    vinserti32x4 $2, 384(%r8), %zmm9, %zmm15
; AVX512-NEXT:    vpermt2q %zmm7, %zmm0, %zmm15
; AVX512-NEXT:    vinserti32x4 $2, 448(%r8), %zmm1, %zmm14
; AVX512-NEXT:    vpermt2q %zmm22, %zmm0, %zmm14
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [0,10,2,3,4,5,6,11]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm29, %zmm0, %zmm13
; AVX512-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,2,3,4,12,6,7]
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm29, %zmm1, %zmm12
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm3, %zmm0, %zmm10
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm3, %zmm1, %zmm9
; AVX512-NEXT:    vpermt2q %zmm4, %zmm0, %zmm31
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm4, %zmm1, %zmm6
; AVX512-NEXT:    vpermt2q %zmm5, %zmm0, %zmm30
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm29 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm5, %zmm1, %zmm29
; AVX512-NEXT:    vpermt2q %zmm11, %zmm0, %zmm26
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm11, %zmm1, %zmm4
; AVX512-NEXT:    vpermt2q %zmm8, %zmm0, %zmm25
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm8, %zmm1, %zmm3
; AVX512-NEXT:    vpermt2q %zmm7, %zmm0, %zmm19
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm7, %zmm1, %zmm2
; AVX512-NEXT:    vpermt2q %zmm22, %zmm0, %zmm16
; AVX512-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vpermt2q %zmm22, %zmm1, %zmm0
; AVX512-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm1, 3008(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm28, 2944(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm0, 2880(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm16, 2816(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm27, 2752(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 2624(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 2560(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm2, 2496(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm19, 2432(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 2368(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 2240(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 2176(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm3, 2112(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm25, 2048(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 1984(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 1856(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 1792(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm4, 1728(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm26, 1664(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 1600(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 1472(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 1408(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm29, 1344(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm30, 1280(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 1216(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 1088(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 1024(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm6, 960(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm31, 896(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 832(%rax)
; AVX512-NEXT:    vmovups (%rsp), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 704(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 640(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm9, 576(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm10, 512(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 448(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 320(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 256(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm12, 192(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm13, 128(%rax)
; AVX512-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-NEXT:    vmovaps %zmm0, 64(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm14, 2688(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm15, 2304(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm17, 1920(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm18, 1536(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm20, 1152(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm21, 768(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm23, 384(%rax)
; AVX512-NEXT:    vmovdqa64 %zmm24, (%rax)
; AVX512-NEXT:    addq $3720, %rsp # imm = 0xE88
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
;
; AVX512-FCP-LABEL: store_i64_stride6_vf64:
; AVX512-FCP:       # %bb.0:
; AVX512-FCP-NEXT:    subq $3720, %rsp # imm = 0xE88
; AVX512-FCP-NEXT:    vmovdqa64 (%rdi), %zmm11
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm10
; AVX512-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm9
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm8
; AVX512-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm7
; AVX512-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 (%rsi), %zmm30
; AVX512-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm29
; AVX512-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm28
; AVX512-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm27
; AVX512-FCP-NEXT:    vmovdqa64 256(%rsi), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 320(%rsi), %zmm13
; AVX512-FCP-NEXT:    vmovdqa64 384(%rsi), %zmm24
; AVX512-FCP-NEXT:    vmovdqa64 448(%rsi), %zmm0
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [4,12,5,13,4,12,5,13]
; AVX512-FCP-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm22
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm2, %zmm22
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm3
; AVX512-FCP-NEXT:    vpermt2q %zmm24, %zmm2, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, %zmm3
; AVX512-FCP-NEXT:    vpermt2q %zmm13, %zmm2, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm3
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm2, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, %zmm3
; AVX512-FCP-NEXT:    vpermt2q %zmm27, %zmm2, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, %zmm3
; AVX512-FCP-NEXT:    vpermt2q %zmm28, %zmm2, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, %zmm3
; AVX512-FCP-NEXT:    vpermt2q %zmm29, %zmm2, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermi2q %zmm30, %zmm11, %zmm2
; AVX512-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm12 = [2,10,2,10,2,10,2,10]
; AVX512-FCP-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, %zmm3
; AVX512-FCP-NEXT:    vpermt2q %zmm30, %zmm12, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [6,14,6,14,6,14,6,14]
; AVX512-FCP-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, %zmm3
; AVX512-FCP-NEXT:    vpermt2q %zmm30, %zmm2, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm21 = [7,15,7,15,7,15,7,15]
; AVX512-FCP-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, %zmm3
; AVX512-FCP-NEXT:    vpermt2q %zmm30, %zmm21, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, %zmm3
; AVX512-FCP-NEXT:    vpermt2q %zmm29, %zmm12, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,8,1,9,0,8,1,9]
; AVX512-FCP-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermt2q %zmm30, %zmm3, %zmm11
; AVX512-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, %zmm11
; AVX512-FCP-NEXT:    vpermt2q %zmm29, %zmm2, %zmm11
; AVX512-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, %zmm11
; AVX512-FCP-NEXT:    vpermt2q %zmm29, %zmm21, %zmm11
; AVX512-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm29, %zmm3, %zmm10
; AVX512-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512-FCP-NEXT:    vpermt2q %zmm28, %zmm12, %zmm10
; AVX512-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512-FCP-NEXT:    vpermt2q %zmm28, %zmm2, %zmm10
; AVX512-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512-FCP-NEXT:    vpermt2q %zmm28, %zmm21, %zmm10
; AVX512-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm28, %zmm3, %zmm9
; AVX512-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512-FCP-NEXT:    vpermt2q %zmm27, %zmm12, %zmm9
; AVX512-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512-FCP-NEXT:    vpermt2q %zmm27, %zmm2, %zmm9
; AVX512-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512-FCP-NEXT:    vpermt2q %zmm27, %zmm21, %zmm9
; AVX512-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm27, %zmm3, %zmm8
; AVX512-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm8
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm12, %zmm8
; AVX512-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm8
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm2, %zmm8
; AVX512-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm8
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm21, %zmm8
; AVX512-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm1, %zmm3, %zmm7
; AVX512-FCP-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm13, %zmm12, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm13, %zmm2, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm13, %zmm21, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm13, %zmm3, %zmm6
; AVX512-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm24, %zmm12, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm24, %zmm2, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm8
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm24, %zmm21, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm24, %zmm3, %zmm5
; AVX512-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 (%rdx), %zmm5
; AVX512-FCP-NEXT:    vmovdqa64 (%rcx), %zmm14
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm29
; AVX512-FCP-NEXT:    vpermt2q %zmm14, %zmm21, %zmm29
; AVX512-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm1
; AVX512-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm11
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm20
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm21, %zmm2
; AVX512-FCP-NEXT:    vmovdqu64 %zmm2, (%rsp) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm23
; AVX512-FCP-NEXT:    vmovdqa64 128(%rcx), %zmm9
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm9, %zmm21, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm18
; AVX512-FCP-NEXT:    vmovdqa64 192(%rcx), %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm21, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 256(%rdx), %zmm17
; AVX512-FCP-NEXT:    vmovdqa64 256(%rcx), %zmm7
; AVX512-FCP-NEXT:    vmovdqa64 %zmm17, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm21, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 320(%rdx), %zmm15
; AVX512-FCP-NEXT:    vmovdqa64 320(%rcx), %zmm10
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm21, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 384(%rdx), %zmm13
; AVX512-FCP-NEXT:    vmovdqa64 384(%rcx), %zmm2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, %zmm1
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm21, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm1
; AVX512-FCP-NEXT:    vpermi2q %zmm0, %zmm4, %zmm12
; AVX512-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermi2q %zmm0, %zmm4, %zmm8
; AVX512-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 448(%rdx), %zmm16
; AVX512-FCP-NEXT:    vmovdqa64 448(%rcx), %zmm4
; AVX512-FCP-NEXT:    vmovdqa64 %zmm16, %zmm8
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm21, %zmm8
; AVX512-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm21
; AVX512-FCP-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm3, %zmm1
; AVX512-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,0,4,12]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm16, %zmm24
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm1, %zmm24
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, %zmm19
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm1, %zmm19
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm1, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm17, %zmm31
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm1, %zmm31
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, %zmm21
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm1, %zmm21
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, %zmm12
; AVX512-FCP-NEXT:    vpermt2q %zmm9, %zmm1, %zmm12
; AVX512-FCP-NEXT:    vmovdqa64 %zmm20, %zmm3
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm1, %zmm3
; AVX512-FCP-NEXT:    vpermi2q %zmm14, %zmm5, %zmm1
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm27 = [1,9,2,10,1,9,2,10]
; AVX512-FCP-NEXT:    # zmm27 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm14, %zmm27, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [5,13,6,14,5,13,6,14]
; AVX512-FCP-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm14, %zmm28, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [3,11,3,11,3,11,3,11]
; AVX512-FCP-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512-FCP-NEXT:    vpermt2q %zmm14, %zmm0, %zmm5
; AVX512-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm20, %zmm5
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm27, %zmm5
; AVX512-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm20, %zmm5
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm28, %zmm5
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm0, %zmm20
; AVX512-FCP-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, %zmm8
; AVX512-FCP-NEXT:    vpermt2q %zmm9, %zmm27, %zmm8
; AVX512-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, %zmm11
; AVX512-FCP-NEXT:    vpermt2q %zmm9, %zmm28, %zmm11
; AVX512-FCP-NEXT:    vmovdqa64 %zmm11, %zmm30
; AVX512-FCP-NEXT:    vpermt2q %zmm9, %zmm0, %zmm23
; AVX512-FCP-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, %zmm9
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm27, %zmm9
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, %zmm8
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm28, %zmm8
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm0, %zmm18
; AVX512-FCP-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm17, %zmm6
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm27, %zmm6
; AVX512-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm17, %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 %zmm17, %zmm14
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm28, %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm0, %zmm14
; AVX512-FCP-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, %zmm7
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm27, %zmm7
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm26
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, %zmm7
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm28, %zmm7
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm25
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm0, %zmm6
; AVX512-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, %zmm6
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, %zmm7
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm27, %zmm7
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm10
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, %zmm7
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm28, %zmm7
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm23
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm0, %zmm6
; AVX512-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermi2q %zmm4, %zmm16, %zmm27
; AVX512-FCP-NEXT:    vpermi2q %zmm4, %zmm16, %zmm28
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm0, %zmm16
; AVX512-FCP-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    movb $12, %al
; AVX512-FCP-NEXT:    kmovw %eax, %k1
; AVX512-FCP-NEXT:    vmovdqa64 %zmm24, %zmm22 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm19, %zmm18 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm19 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm17 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm31, %zmm17 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm21, %zmm16 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm12, %zmm21 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, %zmm31 {%k1}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm20 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm20 {%k1}
; AVX512-FCP-NEXT:    movb $48, %al
; AVX512-FCP-NEXT:    kmovw %eax, %k2
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm14 = zmm0[0,1,2,3],zmm29[4,5,6,7]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vshufi64x2 $228, (%rsp), %zmm0, %zmm0 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    # zmm0 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm15 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    # zmm15 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm13 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    # zmm13 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm12 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    # zmm12 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm26 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm25 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm0 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    # zmm0 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm0 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    # zmm0 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k2}
; AVX512-FCP-NEXT:    vmovdqa64 (%r8), %zmm29
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,9,0,4,5,6,7]
; AVX512-FCP-NEXT:    vpermt2q %zmm29, %zmm1, %zmm2
; AVX512-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 64(%r8), %zmm2
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm1, %zmm4
; AVX512-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 128(%r8), %zmm0
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm1, %zmm6
; AVX512-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 192(%r8), %zmm4
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm1, %zmm9
; AVX512-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 256(%r8), %zmm6
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm1, %zmm7
; AVX512-FCP-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 320(%r8), %zmm7
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm1, %zmm26
; AVX512-FCP-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 384(%r8), %zmm9
; AVX512-FCP-NEXT:    vpermt2q %zmm9, %zmm1, %zmm10
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, %zmm24
; AVX512-FCP-NEXT:    vmovdqa64 448(%r8), %zmm10
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm1, %zmm27
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovdqa64 %zmm1, %zmm28 {%k2}
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,13,0,4,5,6,7]
; AVX512-FCP-NEXT:    vpermt2q %zmm29, %zmm1, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm1, %zmm5
; AVX512-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm1, %zmm30
; AVX512-FCP-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm1, %zmm8
; AVX512-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm1, %zmm11
; AVX512-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm1, %zmm25
; AVX512-FCP-NEXT:    vmovdqu64 %zmm25, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm9, %zmm1, %zmm23
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm1, %zmm28
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm3 # 64-byte Folded Reload
; AVX512-FCP-NEXT:    # zmm3 = zmm1[0,1,2,3],mem[4,5,6,7]
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [14,0,2,3,4,5,15,0]
; AVX512-FCP-NEXT:    vpermt2q %zmm29, %zmm1, %zmm14
; AVX512-FCP-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 (%rsp), %zmm14 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm1, %zmm14
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm1, %zmm15
; AVX512-FCP-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm1, %zmm13
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm1, %zmm12
; AVX512-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm1, %zmm12
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm9, %zmm1, %zmm15
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm1, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm1, %zmm3, %zmm3
; AVX512-FCP-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX512-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm1, %zmm5, %zmm5
; AVX512-FCP-NEXT:    movb $16, %al
; AVX512-FCP-NEXT:    kmovw %eax, %k2
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, %zmm31 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 %zmm31, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [10,0,2,3,4,5,11,0]
; AVX512-FCP-NEXT:    vpermt2q %zmm2, %zmm1, %zmm5
; AVX512-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa 128(%rdi), %ymm2
; AVX512-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm5, %zmm31
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, %zmm21 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm0, %zmm1, %zmm31
; AVX512-FCP-NEXT:    vmovdqa 192(%rdi), %ymm2
; AVX512-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm30
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, %zmm16 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm1, %zmm30
; AVX512-FCP-NEXT:    vmovdqa 256(%rdi), %ymm2
; AVX512-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm26
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, %zmm17 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm6, %zmm1, %zmm26
; AVX512-FCP-NEXT:    vmovdqa 320(%rdi), %ymm2
; AVX512-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm25
; AVX512-FCP-NEXT:    vmovdqa64 %zmm7, %zmm19 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm1, %zmm25
; AVX512-FCP-NEXT:    vmovdqa 384(%rdi), %ymm2
; AVX512-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm19
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, %zmm18 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm9, %zmm1, %zmm19
; AVX512-FCP-NEXT:    vmovdqa 448(%rdi), %ymm2
; AVX512-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm16
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, %zmm22 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm10, %zmm1, %zmm16
; AVX512-FCP-NEXT:    vpermt2q %zmm29, %zmm1, %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 %zmm29, %zmm20 {%k2}
; AVX512-FCP-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 (%r9), %zmm29
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,1,2,9,4,5,6,7]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm29, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 64(%r9), %zmm3
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 128(%r9), %zmm4
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 192(%r9), %zmm5
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm5, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 256(%r9), %zmm11
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 320(%r9), %zmm8
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm8, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 384(%r9), %zmm7
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm6, %zmm24
; AVX512-FCP-NEXT:    vmovdqu64 %zmm24, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa64 448(%r9), %zmm22
; AVX512-FCP-NEXT:    vpermt2q %zmm22, %zmm6, %zmm27
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,1,2,13,4,5,6,7]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm29, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm5, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm8, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm6, %zmm23
; AVX512-FCP-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm22, %zmm6, %zmm28
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,14,2,3,4,5,6,15]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm29, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm6, %zmm14
; AVX512-FCP-NEXT:    vmovdqu64 %zmm14, (%rsp) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm5, %zmm6, %zmm13
; AVX512-FCP-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm8, %zmm6, %zmm12
; AVX512-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm6, %zmm15
; AVX512-FCP-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm22, %zmm6, %zmm0
; AVX512-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512-FCP-NEXT:    vmovdqa (%rdx), %xmm6
; AVX512-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm0 {%k1}
; AVX512-FCP-NEXT:    vmovdqa 64(%rdx), %xmm6
; AVX512-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm14 {%k1}
; AVX512-FCP-NEXT:    vmovdqa 128(%rdx), %xmm6
; AVX512-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm15 {%k1}
; AVX512-FCP-NEXT:    vmovdqa 192(%rdx), %xmm6
; AVX512-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm10 {%k1}
; AVX512-FCP-NEXT:    vmovdqa 256(%rdx), %xmm6
; AVX512-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm12 {%k1}
; AVX512-FCP-NEXT:    vmovdqa 320(%rdx), %xmm6
; AVX512-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm2 {%k1}
; AVX512-FCP-NEXT:    vmovdqa 384(%rdx), %xmm6
; AVX512-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm9 {%k1}
; AVX512-FCP-NEXT:    vmovdqa 448(%rdx), %xmm6
; AVX512-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm1 {%k1}
; AVX512-FCP-NEXT:    vinserti32x4 $2, (%r8), %zmm0, %zmm24
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [0,1,2,3,4,8,6,7]
; AVX512-FCP-NEXT:    vpermt2q %zmm29, %zmm0, %zmm24
; AVX512-FCP-NEXT:    vinserti32x4 $2, 64(%r8), %zmm14, %zmm23
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm0, %zmm23
; AVX512-FCP-NEXT:    vinserti32x4 $2, 128(%r8), %zmm15, %zmm21
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm0, %zmm21
; AVX512-FCP-NEXT:    vinserti32x4 $2, 192(%r8), %zmm10, %zmm20
; AVX512-FCP-NEXT:    vpermt2q %zmm5, %zmm0, %zmm20
; AVX512-FCP-NEXT:    vinserti32x4 $2, 256(%r8), %zmm12, %zmm18
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm0, %zmm18
; AVX512-FCP-NEXT:    vinserti32x4 $2, 320(%r8), %zmm2, %zmm17
; AVX512-FCP-NEXT:    vpermt2q %zmm8, %zmm0, %zmm17
; AVX512-FCP-NEXT:    vinserti32x4 $2, 384(%r8), %zmm9, %zmm15
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm0, %zmm15
; AVX512-FCP-NEXT:    vinserti32x4 $2, 448(%r8), %zmm1, %zmm14
; AVX512-FCP-NEXT:    vpermt2q %zmm22, %zmm0, %zmm14
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [0,10,2,3,4,5,6,11]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm29, %zmm0, %zmm13
; AVX512-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,2,3,4,12,6,7]
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm29, %zmm1, %zmm12
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm0, %zmm10
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm3, %zmm1, %zmm9
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm0, %zmm31
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm4, %zmm1, %zmm6
; AVX512-FCP-NEXT:    vpermt2q %zmm5, %zmm0, %zmm30
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm29 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm5, %zmm1, %zmm29
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm0, %zmm26
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm11, %zmm1, %zmm4
; AVX512-FCP-NEXT:    vpermt2q %zmm8, %zmm0, %zmm25
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm8, %zmm1, %zmm3
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm0, %zmm19
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm7, %zmm1, %zmm2
; AVX512-FCP-NEXT:    vpermt2q %zmm22, %zmm0, %zmm16
; AVX512-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vpermt2q %zmm22, %zmm1, %zmm0
; AVX512-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm1, 3008(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm28, 2944(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm0, 2880(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm16, 2816(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm27, 2752(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 2624(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 2560(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm2, 2496(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm19, 2432(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 2368(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 2240(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 2176(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm3, 2112(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm25, 2048(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 1984(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 1856(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 1792(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm4, 1728(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm26, 1664(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 1600(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 1472(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 1408(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm29, 1344(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm30, 1280(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 1216(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 1088(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 1024(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm6, 960(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm31, 896(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 832(%rax)
; AVX512-FCP-NEXT:    vmovups (%rsp), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 704(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 640(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm9, 576(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm10, 512(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 448(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 320(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 256(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm12, 192(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm13, 128(%rax)
; AVX512-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512-FCP-NEXT:    vmovaps %zmm0, 64(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm14, 2688(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm15, 2304(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm17, 1920(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm18, 1536(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm20, 1152(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm21, 768(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm23, 384(%rax)
; AVX512-FCP-NEXT:    vmovdqa64 %zmm24, (%rax)
; AVX512-FCP-NEXT:    addq $3720, %rsp # imm = 0xE88
; AVX512-FCP-NEXT:    vzeroupper
; AVX512-FCP-NEXT:    retq
;
; AVX512DQ-LABEL: store_i64_stride6_vf64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    subq $3720, %rsp # imm = 0xE88
; AVX512DQ-NEXT:    vmovdqa64 (%rdi), %zmm11
; AVX512DQ-NEXT:    vmovdqa64 64(%rdi), %zmm10
; AVX512DQ-NEXT:    vmovdqa64 128(%rdi), %zmm9
; AVX512DQ-NEXT:    vmovdqa64 192(%rdi), %zmm8
; AVX512DQ-NEXT:    vmovdqa64 256(%rdi), %zmm7
; AVX512DQ-NEXT:    vmovdqa64 320(%rdi), %zmm6
; AVX512DQ-NEXT:    vmovdqa64 384(%rdi), %zmm5
; AVX512DQ-NEXT:    vmovdqa64 448(%rdi), %zmm4
; AVX512DQ-NEXT:    vmovdqa64 (%rsi), %zmm30
; AVX512DQ-NEXT:    vmovdqa64 64(%rsi), %zmm29
; AVX512DQ-NEXT:    vmovdqa64 128(%rsi), %zmm28
; AVX512DQ-NEXT:    vmovdqa64 192(%rsi), %zmm27
; AVX512DQ-NEXT:    vmovdqa64 256(%rsi), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 320(%rsi), %zmm13
; AVX512DQ-NEXT:    vmovdqa64 384(%rsi), %zmm24
; AVX512DQ-NEXT:    vmovdqa64 448(%rsi), %zmm0
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [4,12,5,13,4,12,5,13]
; AVX512DQ-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm22
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm2, %zmm22
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm3
; AVX512DQ-NEXT:    vpermt2q %zmm24, %zmm2, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, %zmm3
; AVX512DQ-NEXT:    vpermt2q %zmm13, %zmm2, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm3
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm2, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, %zmm3
; AVX512DQ-NEXT:    vpermt2q %zmm27, %zmm2, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, %zmm3
; AVX512DQ-NEXT:    vpermt2q %zmm28, %zmm2, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, %zmm3
; AVX512DQ-NEXT:    vpermt2q %zmm29, %zmm2, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermi2q %zmm30, %zmm11, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vbroadcasti32x4 {{.*#+}} zmm12 = [2,10,2,10,2,10,2,10]
; AVX512DQ-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, %zmm3
; AVX512DQ-NEXT:    vpermt2q %zmm30, %zmm12, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [6,14,6,14,6,14,6,14]
; AVX512DQ-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, %zmm3
; AVX512DQ-NEXT:    vpermt2q %zmm30, %zmm2, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vbroadcasti32x4 {{.*#+}} zmm21 = [7,15,7,15,7,15,7,15]
; AVX512DQ-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, %zmm3
; AVX512DQ-NEXT:    vpermt2q %zmm30, %zmm21, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, %zmm3
; AVX512DQ-NEXT:    vpermt2q %zmm29, %zmm12, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,8,1,9,0,8,1,9]
; AVX512DQ-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermt2q %zmm30, %zmm3, %zmm11
; AVX512DQ-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, %zmm11
; AVX512DQ-NEXT:    vpermt2q %zmm29, %zmm2, %zmm11
; AVX512DQ-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, %zmm11
; AVX512DQ-NEXT:    vpermt2q %zmm29, %zmm21, %zmm11
; AVX512DQ-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm29, %zmm3, %zmm10
; AVX512DQ-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512DQ-NEXT:    vpermt2q %zmm28, %zmm12, %zmm10
; AVX512DQ-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512DQ-NEXT:    vpermt2q %zmm28, %zmm2, %zmm10
; AVX512DQ-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512DQ-NEXT:    vpermt2q %zmm28, %zmm21, %zmm10
; AVX512DQ-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm28, %zmm3, %zmm9
; AVX512DQ-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512DQ-NEXT:    vpermt2q %zmm27, %zmm12, %zmm9
; AVX512DQ-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512DQ-NEXT:    vpermt2q %zmm27, %zmm2, %zmm9
; AVX512DQ-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512DQ-NEXT:    vpermt2q %zmm27, %zmm21, %zmm9
; AVX512DQ-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm27, %zmm3, %zmm8
; AVX512DQ-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm8
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm12, %zmm8
; AVX512DQ-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm8
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm2, %zmm8
; AVX512DQ-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm8
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm21, %zmm8
; AVX512DQ-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm1, %zmm3, %zmm7
; AVX512DQ-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm13, %zmm12, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm13, %zmm2, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm13, %zmm21, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm13, %zmm3, %zmm6
; AVX512DQ-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm24, %zmm12, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm24, %zmm2, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm8
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm24, %zmm21, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm24, %zmm3, %zmm5
; AVX512DQ-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 (%rdx), %zmm5
; AVX512DQ-NEXT:    vmovdqa64 (%rcx), %zmm14
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm29
; AVX512DQ-NEXT:    vpermt2q %zmm14, %zmm21, %zmm29
; AVX512DQ-NEXT:    vmovdqa64 64(%rdx), %zmm1
; AVX512DQ-NEXT:    vmovdqa64 64(%rcx), %zmm11
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm20
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm21, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, (%rsp) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 128(%rdx), %zmm23
; AVX512DQ-NEXT:    vmovdqa64 128(%rcx), %zmm9
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm9, %zmm21, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 192(%rdx), %zmm18
; AVX512DQ-NEXT:    vmovdqa64 192(%rcx), %zmm6
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm21, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 256(%rdx), %zmm17
; AVX512DQ-NEXT:    vmovdqa64 256(%rcx), %zmm7
; AVX512DQ-NEXT:    vmovdqa64 %zmm17, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm21, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 320(%rdx), %zmm15
; AVX512DQ-NEXT:    vmovdqa64 320(%rcx), %zmm10
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm21, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 384(%rdx), %zmm13
; AVX512DQ-NEXT:    vmovdqa64 384(%rcx), %zmm2
; AVX512DQ-NEXT:    vmovdqa64 %zmm13, %zmm1
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm21, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm1
; AVX512DQ-NEXT:    vpermi2q %zmm0, %zmm4, %zmm12
; AVX512DQ-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermi2q %zmm0, %zmm4, %zmm8
; AVX512DQ-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 448(%rdx), %zmm16
; AVX512DQ-NEXT:    vmovdqa64 448(%rcx), %zmm4
; AVX512DQ-NEXT:    vmovdqa64 %zmm16, %zmm8
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm21, %zmm8
; AVX512DQ-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermi2q %zmm0, %zmm1, %zmm21
; AVX512DQ-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm3, %zmm1
; AVX512DQ-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,0,4,12]
; AVX512DQ-NEXT:    vmovdqa64 %zmm16, %zmm24
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm1, %zmm24
; AVX512DQ-NEXT:    vmovdqa64 %zmm13, %zmm19
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm1, %zmm19
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm1, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm17, %zmm31
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm1, %zmm31
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, %zmm21
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm1, %zmm21
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, %zmm12
; AVX512DQ-NEXT:    vpermt2q %zmm9, %zmm1, %zmm12
; AVX512DQ-NEXT:    vmovdqa64 %zmm20, %zmm3
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm1, %zmm3
; AVX512DQ-NEXT:    vpermi2q %zmm14, %zmm5, %zmm1
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm27 = [1,9,2,10,1,9,2,10]
; AVX512DQ-NEXT:    # zmm27 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm14, %zmm27, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [5,13,6,14,5,13,6,14]
; AVX512DQ-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm14, %zmm28, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [3,11,3,11,3,11,3,11]
; AVX512DQ-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-NEXT:    vpermt2q %zmm14, %zmm0, %zmm5
; AVX512DQ-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm20, %zmm5
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm27, %zmm5
; AVX512DQ-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm20, %zmm5
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm28, %zmm5
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm0, %zmm20
; AVX512DQ-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, %zmm8
; AVX512DQ-NEXT:    vpermt2q %zmm9, %zmm27, %zmm8
; AVX512DQ-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, %zmm11
; AVX512DQ-NEXT:    vpermt2q %zmm9, %zmm28, %zmm11
; AVX512DQ-NEXT:    vmovdqa64 %zmm11, %zmm30
; AVX512DQ-NEXT:    vpermt2q %zmm9, %zmm0, %zmm23
; AVX512DQ-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, %zmm9
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm27, %zmm9
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, %zmm8
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm28, %zmm8
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm0, %zmm18
; AVX512DQ-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm17, %zmm6
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm27, %zmm6
; AVX512DQ-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm17, %zmm6
; AVX512DQ-NEXT:    vmovdqa64 %zmm17, %zmm14
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm28, %zmm6
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm0, %zmm14
; AVX512DQ-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, %zmm6
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, %zmm7
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm27, %zmm7
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm26
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, %zmm7
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm28, %zmm7
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm25
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm0, %zmm6
; AVX512DQ-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm13, %zmm6
; AVX512DQ-NEXT:    vmovdqa64 %zmm13, %zmm7
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm27, %zmm7
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm10
; AVX512DQ-NEXT:    vmovdqa64 %zmm13, %zmm7
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm28, %zmm7
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm23
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm0, %zmm6
; AVX512DQ-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermi2q %zmm4, %zmm16, %zmm27
; AVX512DQ-NEXT:    vpermi2q %zmm4, %zmm16, %zmm28
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm0, %zmm16
; AVX512DQ-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    movb $12, %al
; AVX512DQ-NEXT:    kmovw %eax, %k1
; AVX512DQ-NEXT:    vmovdqa64 %zmm24, %zmm22 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm19, %zmm18 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm19 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm17 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm31, %zmm17 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm21, %zmm16 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm12, %zmm21 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, %zmm31 {%k1}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm20 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm20 {%k1}
; AVX512DQ-NEXT:    movb $48, %al
; AVX512DQ-NEXT:    kmovw %eax, %k2
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vshufi64x2 {{.*#+}} zmm14 = zmm0[0,1,2,3],zmm29[4,5,6,7]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vshufi64x2 $228, (%rsp), %zmm0, %zmm0 # 64-byte Folded Reload
; AVX512DQ-NEXT:    # zmm0 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm15 # 64-byte Folded Reload
; AVX512DQ-NEXT:    # zmm15 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm13 # 64-byte Folded Reload
; AVX512DQ-NEXT:    # zmm13 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm12 # 64-byte Folded Reload
; AVX512DQ-NEXT:    # zmm12 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm26 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm25 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm0 # 64-byte Folded Reload
; AVX512DQ-NEXT:    # zmm0 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm0 # 64-byte Folded Reload
; AVX512DQ-NEXT:    # zmm0 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k2}
; AVX512DQ-NEXT:    vmovdqa64 (%r8), %zmm29
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,9,0,4,5,6,7]
; AVX512DQ-NEXT:    vpermt2q %zmm29, %zmm1, %zmm2
; AVX512DQ-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 64(%r8), %zmm2
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm1, %zmm4
; AVX512DQ-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 128(%r8), %zmm0
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm1, %zmm6
; AVX512DQ-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 192(%r8), %zmm4
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm1, %zmm9
; AVX512DQ-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 256(%r8), %zmm6
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm1, %zmm7
; AVX512DQ-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 320(%r8), %zmm7
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm1, %zmm26
; AVX512DQ-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 384(%r8), %zmm9
; AVX512DQ-NEXT:    vpermt2q %zmm9, %zmm1, %zmm10
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, %zmm24
; AVX512DQ-NEXT:    vmovdqa64 448(%r8), %zmm10
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm1, %zmm27
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vmovdqa64 %zmm1, %zmm28 {%k2}
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,13,0,4,5,6,7]
; AVX512DQ-NEXT:    vpermt2q %zmm29, %zmm1, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm1, %zmm5
; AVX512DQ-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm1, %zmm30
; AVX512DQ-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm1, %zmm8
; AVX512DQ-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm1, %zmm11
; AVX512DQ-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm1, %zmm25
; AVX512DQ-NEXT:    vmovdqu64 %zmm25, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm9, %zmm1, %zmm23
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm1, %zmm28
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm3 # 64-byte Folded Reload
; AVX512DQ-NEXT:    # zmm3 = zmm1[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [14,0,2,3,4,5,15,0]
; AVX512DQ-NEXT:    vpermt2q %zmm29, %zmm1, %zmm14
; AVX512DQ-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 (%rsp), %zmm14 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm1, %zmm14
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm1, %zmm15
; AVX512DQ-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm1, %zmm13
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm1, %zmm12
; AVX512DQ-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm1, %zmm12
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm9, %zmm1, %zmm15
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm1, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512DQ-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm1, %zmm3, %zmm3
; AVX512DQ-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX512DQ-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm1, %zmm5, %zmm5
; AVX512DQ-NEXT:    movb $16, %al
; AVX512DQ-NEXT:    kmovw %eax, %k2
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, %zmm31 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 %zmm31, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [10,0,2,3,4,5,11,0]
; AVX512DQ-NEXT:    vpermt2q %zmm2, %zmm1, %zmm5
; AVX512DQ-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa 128(%rdi), %ymm2
; AVX512DQ-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm2, %zmm5, %zmm31
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, %zmm21 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm0, %zmm1, %zmm31
; AVX512DQ-NEXT:    vmovdqa 192(%rdi), %ymm2
; AVX512DQ-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm30
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, %zmm16 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm1, %zmm30
; AVX512DQ-NEXT:    vmovdqa 256(%rdi), %ymm2
; AVX512DQ-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm26
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, %zmm17 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm6, %zmm1, %zmm26
; AVX512DQ-NEXT:    vmovdqa 320(%rdi), %ymm2
; AVX512DQ-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm25
; AVX512DQ-NEXT:    vmovdqa64 %zmm7, %zmm19 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm1, %zmm25
; AVX512DQ-NEXT:    vmovdqa 384(%rdi), %ymm2
; AVX512DQ-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm19
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, %zmm18 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm9, %zmm1, %zmm19
; AVX512DQ-NEXT:    vmovdqa 448(%rdi), %ymm2
; AVX512DQ-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm16
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, %zmm22 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm10, %zmm1, %zmm16
; AVX512DQ-NEXT:    vpermt2q %zmm29, %zmm1, %zmm3
; AVX512DQ-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 %zmm29, %zmm20 {%k2}
; AVX512DQ-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 (%r9), %zmm29
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,1,2,9,4,5,6,7]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm29, %zmm6, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 64(%r9), %zmm3
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm6, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 128(%r9), %zmm4
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm6, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 192(%r9), %zmm5
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm5, %zmm6, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 256(%r9), %zmm11
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm6, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 320(%r9), %zmm8
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm8, %zmm6, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 384(%r9), %zmm7
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm6, %zmm24
; AVX512DQ-NEXT:    vmovdqu64 %zmm24, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa64 448(%r9), %zmm22
; AVX512DQ-NEXT:    vpermt2q %zmm22, %zmm6, %zmm27
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,1,2,13,4,5,6,7]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm29, %zmm6, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm6, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm6, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm5, %zmm6, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm6, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm8, %zmm6, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm6, %zmm23
; AVX512DQ-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm22, %zmm6, %zmm28
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,14,2,3,4,5,6,15]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm29, %zmm6, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm6, %zmm14
; AVX512DQ-NEXT:    vmovdqu64 %zmm14, (%rsp) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm6, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm5, %zmm6, %zmm13
; AVX512DQ-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm6, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm8, %zmm6, %zmm12
; AVX512DQ-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm6, %zmm15
; AVX512DQ-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm22, %zmm6, %zmm0
; AVX512DQ-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-NEXT:    vmovdqa (%rdx), %xmm6
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm0 {%k1}
; AVX512DQ-NEXT:    vmovdqa 64(%rdx), %xmm6
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm14 {%k1}
; AVX512DQ-NEXT:    vmovdqa 128(%rdx), %xmm6
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm15 {%k1}
; AVX512DQ-NEXT:    vmovdqa 192(%rdx), %xmm6
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm10 {%k1}
; AVX512DQ-NEXT:    vmovdqa 256(%rdx), %xmm6
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm12 {%k1}
; AVX512DQ-NEXT:    vmovdqa 320(%rdx), %xmm6
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm2 {%k1}
; AVX512DQ-NEXT:    vmovdqa 384(%rdx), %xmm6
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm9 {%k1}
; AVX512DQ-NEXT:    vmovdqa 448(%rdx), %xmm6
; AVX512DQ-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512DQ-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm1 {%k1}
; AVX512DQ-NEXT:    vinserti32x4 $2, (%r8), %zmm0, %zmm24
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [0,1,2,3,4,8,6,7]
; AVX512DQ-NEXT:    vpermt2q %zmm29, %zmm0, %zmm24
; AVX512DQ-NEXT:    vinserti32x4 $2, 64(%r8), %zmm14, %zmm23
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm0, %zmm23
; AVX512DQ-NEXT:    vinserti32x4 $2, 128(%r8), %zmm15, %zmm21
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm0, %zmm21
; AVX512DQ-NEXT:    vinserti32x4 $2, 192(%r8), %zmm10, %zmm20
; AVX512DQ-NEXT:    vpermt2q %zmm5, %zmm0, %zmm20
; AVX512DQ-NEXT:    vinserti32x4 $2, 256(%r8), %zmm12, %zmm18
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm0, %zmm18
; AVX512DQ-NEXT:    vinserti32x4 $2, 320(%r8), %zmm2, %zmm17
; AVX512DQ-NEXT:    vpermt2q %zmm8, %zmm0, %zmm17
; AVX512DQ-NEXT:    vinserti32x4 $2, 384(%r8), %zmm9, %zmm15
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm0, %zmm15
; AVX512DQ-NEXT:    vinserti32x4 $2, 448(%r8), %zmm1, %zmm14
; AVX512DQ-NEXT:    vpermt2q %zmm22, %zmm0, %zmm14
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [0,10,2,3,4,5,6,11]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm29, %zmm0, %zmm13
; AVX512DQ-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,2,3,4,12,6,7]
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm29, %zmm1, %zmm12
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm0, %zmm10
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm3, %zmm1, %zmm9
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm0, %zmm31
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm4, %zmm1, %zmm6
; AVX512DQ-NEXT:    vpermt2q %zmm5, %zmm0, %zmm30
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm29 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm5, %zmm1, %zmm29
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm0, %zmm26
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm11, %zmm1, %zmm4
; AVX512DQ-NEXT:    vpermt2q %zmm8, %zmm0, %zmm25
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm8, %zmm1, %zmm3
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm0, %zmm19
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm7, %zmm1, %zmm2
; AVX512DQ-NEXT:    vpermt2q %zmm22, %zmm0, %zmm16
; AVX512DQ-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vpermt2q %zmm22, %zmm1, %zmm0
; AVX512DQ-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm1, 3008(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm28, 2944(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm0, 2880(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm16, 2816(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm27, 2752(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 2624(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 2560(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm2, 2496(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm19, 2432(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 2368(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 2240(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 2176(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm3, 2112(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm25, 2048(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 1984(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 1856(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 1792(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm4, 1728(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm26, 1664(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 1600(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 1472(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 1408(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm29, 1344(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm30, 1280(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 1216(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 1088(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 1024(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm6, 960(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm31, 896(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 832(%rax)
; AVX512DQ-NEXT:    vmovups (%rsp), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 704(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 640(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm9, 576(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm10, 512(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 448(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 320(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 256(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm12, 192(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm13, 128(%rax)
; AVX512DQ-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-NEXT:    vmovaps %zmm0, 64(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm14, 2688(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm15, 2304(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm17, 1920(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm18, 1536(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm20, 1152(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm21, 768(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm23, 384(%rax)
; AVX512DQ-NEXT:    vmovdqa64 %zmm24, (%rax)
; AVX512DQ-NEXT:    addq $3720, %rsp # imm = 0xE88
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    retq
;
; AVX512DQ-FCP-LABEL: store_i64_stride6_vf64:
; AVX512DQ-FCP:       # %bb.0:
; AVX512DQ-FCP-NEXT:    subq $3720, %rsp # imm = 0xE88
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdi), %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rsi), %zmm30
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm29
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm28
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm27
; AVX512DQ-FCP-NEXT:    vmovdqa64 256(%rsi), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 320(%rsi), %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqa64 384(%rsi), %zmm24
; AVX512DQ-FCP-NEXT:    vmovdqa64 448(%rsi), %zmm0
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [4,12,5,13,4,12,5,13]
; AVX512DQ-FCP-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm22
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm2, %zmm22
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm24, %zmm2, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm13, %zmm2, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm2, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm27, %zmm2, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm28, %zmm2, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm29, %zmm2, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm30, %zmm11, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm12 = [2,10,2,10,2,10,2,10]
; AVX512DQ-FCP-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm30, %zmm12, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [6,14,6,14,6,14,6,14]
; AVX512DQ-FCP-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm30, %zmm2, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm21 = [7,15,7,15,7,15,7,15]
; AVX512DQ-FCP-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm30, %zmm21, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm29, %zmm12, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,8,1,9,0,8,1,9]
; AVX512DQ-FCP-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm30, %zmm3, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, %zmm11
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm29, %zmm2, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, %zmm11
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm29, %zmm21, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm29, %zmm3, %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm28, %zmm12, %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm28, %zmm2, %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm28, %zmm21, %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm28, %zmm3, %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm27, %zmm12, %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm27, %zmm2, %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm27, %zmm21, %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm27, %zmm3, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm8
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm12, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm8
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm2, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm8
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm21, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm1, %zmm3, %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm13, %zmm12, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm13, %zmm2, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm13, %zmm21, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm13, %zmm3, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm24, %zmm12, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm24, %zmm2, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm24, %zmm21, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm24, %zmm3, %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rdx), %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%rcx), %zmm14
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm29
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm14, %zmm21, %zmm29
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm20
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm21, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm2, (%rsp) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm23
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%rcx), %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm9, %zmm21, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm18
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%rcx), %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm21, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 256(%rdx), %zmm17
; AVX512DQ-FCP-NEXT:    vmovdqa64 256(%rcx), %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm17, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm21, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 320(%rdx), %zmm15
; AVX512DQ-FCP-NEXT:    vmovdqa64 320(%rcx), %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm21, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 384(%rdx), %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqa64 384(%rcx), %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, %zmm1
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm21, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm1
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm0, %zmm4, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm0, %zmm4, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 448(%rdx), %zmm16
; AVX512DQ-FCP-NEXT:    vmovdqa64 448(%rcx), %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm16, %zmm8
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm21, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm21
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm3, %zmm1
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,0,4,12]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm16, %zmm24
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm1, %zmm24
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, %zmm19
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm1, %zmm19
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm1, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm17, %zmm31
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm1, %zmm31
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, %zmm21
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm1, %zmm21
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, %zmm12
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm9, %zmm1, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm20, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm1, %zmm3
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm14, %zmm5, %zmm1
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm27 = [1,9,2,10,1,9,2,10]
; AVX512DQ-FCP-NEXT:    # zmm27 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm14, %zmm27, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [5,13,6,14,5,13,6,14]
; AVX512DQ-FCP-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm14, %zmm28, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [3,11,3,11,3,11,3,11]
; AVX512DQ-FCP-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm14, %zmm0, %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm20, %zmm5
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm27, %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm20, %zmm5
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm28, %zmm5
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm0, %zmm20
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, %zmm8
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm9, %zmm27, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, %zmm11
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm9, %zmm28, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm11, %zmm30
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm9, %zmm0, %zmm23
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, %zmm9
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm27, %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, %zmm8
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm28, %zmm8
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm0, %zmm18
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm17, %zmm6
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm27, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm17, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm17, %zmm14
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm28, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm0, %zmm14
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, %zmm7
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm27, %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm26
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, %zmm7
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm28, %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm25
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm0, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, %zmm7
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm27, %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, %zmm7
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm28, %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm23
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm0, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm4, %zmm16, %zmm27
; AVX512DQ-FCP-NEXT:    vpermi2q %zmm4, %zmm16, %zmm28
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm0, %zmm16
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    movb $12, %al
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k1
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm24, %zmm22 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm19, %zmm18 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm19 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm17 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm31, %zmm17 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm21, %zmm16 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm12, %zmm21 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, %zmm31 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm20 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm20 {%k1}
; AVX512DQ-FCP-NEXT:    movb $48, %al
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k2
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vshufi64x2 {{.*#+}} zmm14 = zmm0[0,1,2,3],zmm29[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vshufi64x2 $228, (%rsp), %zmm0, %zmm0 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    # zmm0 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm15 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    # zmm15 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm13 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    # zmm13 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm12 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    # zmm12 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm26 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm25 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm0 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    # zmm0 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm0 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    # zmm0 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%r8), %zmm29
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,9,0,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm29, %zmm1, %zmm2
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%r8), %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm1, %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%r8), %zmm0
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm1, %zmm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%r8), %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm1, %zmm9
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 256(%r8), %zmm6
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm1, %zmm7
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 320(%r8), %zmm7
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm1, %zmm26
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 384(%r8), %zmm9
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm9, %zmm1, %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, %zmm24
; AVX512DQ-FCP-NEXT:    vmovdqa64 448(%r8), %zmm10
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm1, %zmm27
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm1, %zmm28 {%k2}
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,13,0,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm29, %zmm1, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm1, %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm1, %zmm30
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm1, %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm1, %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm1, %zmm25
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm25, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm9, %zmm1, %zmm23
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm1, %zmm28
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm3 # 64-byte Folded Reload
; AVX512DQ-FCP-NEXT:    # zmm3 = zmm1[0,1,2,3],mem[4,5,6,7]
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [14,0,2,3,4,5,15,0]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm29, %zmm1, %zmm14
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 (%rsp), %zmm14 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm1, %zmm14
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm1, %zmm15
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm1, %zmm13
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm1, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm1, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm9, %zmm1, %zmm15
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm1, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512DQ-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm1, %zmm3, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX512DQ-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm1, %zmm5, %zmm5
; AVX512DQ-FCP-NEXT:    movb $16, %al
; AVX512DQ-FCP-NEXT:    kmovw %eax, %k2
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, %zmm31 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm31, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [10,0,2,3,4,5,11,0]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm2, %zmm1, %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa 128(%rdi), %ymm2
; AVX512DQ-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm5, %zmm31
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, %zmm21 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm0, %zmm1, %zmm31
; AVX512DQ-FCP-NEXT:    vmovdqa 192(%rdi), %ymm2
; AVX512DQ-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm30
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, %zmm16 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm1, %zmm30
; AVX512DQ-FCP-NEXT:    vmovdqa 256(%rdi), %ymm2
; AVX512DQ-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm26
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, %zmm17 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm6, %zmm1, %zmm26
; AVX512DQ-FCP-NEXT:    vmovdqa 320(%rdi), %ymm2
; AVX512DQ-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm25
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm7, %zmm19 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm1, %zmm25
; AVX512DQ-FCP-NEXT:    vmovdqa 384(%rdi), %ymm2
; AVX512DQ-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm19
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, %zmm18 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm9, %zmm1, %zmm19
; AVX512DQ-FCP-NEXT:    vmovdqa 448(%rdi), %ymm2
; AVX512DQ-FCP-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm16
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, %zmm22 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm10, %zmm1, %zmm16
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm29, %zmm1, %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm29, %zmm20 {%k2}
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 (%r9), %zmm29
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,1,2,9,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm29, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 64(%r9), %zmm3
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 128(%r9), %zmm4
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 192(%r9), %zmm5
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm5, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 256(%r9), %zmm11
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 320(%r9), %zmm8
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm8, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 384(%r9), %zmm7
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm6, %zmm24
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm24, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa64 448(%r9), %zmm22
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm22, %zmm6, %zmm27
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,1,2,13,4,5,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm29, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm5, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm8, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm6, %zmm23
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm22, %zmm6, %zmm28
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,14,2,3,4,5,6,15]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm29, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm6, %zmm14
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm14, (%rsp) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm5, %zmm6, %zmm13
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm8, %zmm6, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm6, %zmm15
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm22, %zmm6, %zmm0
; AVX512DQ-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512DQ-FCP-NEXT:    vmovdqa (%rdx), %xmm6
; AVX512DQ-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm0 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa 64(%rdx), %xmm6
; AVX512DQ-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm14 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa 128(%rdx), %xmm6
; AVX512DQ-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm15 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa 192(%rdx), %xmm6
; AVX512DQ-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm10 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa 256(%rdx), %xmm6
; AVX512DQ-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm12 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa 320(%rdx), %xmm6
; AVX512DQ-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm2 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa 384(%rdx), %xmm6
; AVX512DQ-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm9 {%k1}
; AVX512DQ-FCP-NEXT:    vmovdqa 448(%rdx), %xmm6
; AVX512DQ-FCP-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512DQ-FCP-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm1 {%k1}
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, (%r8), %zmm0, %zmm24
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [0,1,2,3,4,8,6,7]
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm29, %zmm0, %zmm24
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, 64(%r8), %zmm14, %zmm23
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm0, %zmm23
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, 128(%r8), %zmm15, %zmm21
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm0, %zmm21
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, 192(%r8), %zmm10, %zmm20
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm5, %zmm0, %zmm20
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, 256(%r8), %zmm12, %zmm18
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm0, %zmm18
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, 320(%r8), %zmm2, %zmm17
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm8, %zmm0, %zmm17
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, 384(%r8), %zmm9, %zmm15
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm0, %zmm15
; AVX512DQ-FCP-NEXT:    vinserti32x4 $2, 448(%r8), %zmm1, %zmm14
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm22, %zmm0, %zmm14
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [0,10,2,3,4,5,6,11]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm29, %zmm0, %zmm13
; AVX512DQ-FCP-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,2,3,4,12,6,7]
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm29, %zmm1, %zmm12
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm0, %zmm10
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm3, %zmm1, %zmm9
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm0, %zmm31
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm4, %zmm1, %zmm6
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm5, %zmm0, %zmm30
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm29 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm5, %zmm1, %zmm29
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm0, %zmm26
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm11, %zmm1, %zmm4
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm8, %zmm0, %zmm25
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm8, %zmm1, %zmm3
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm0, %zmm19
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm7, %zmm1, %zmm2
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm22, %zmm0, %zmm16
; AVX512DQ-FCP-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vpermt2q %zmm22, %zmm1, %zmm0
; AVX512DQ-FCP-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm1, 3008(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm28, 2944(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm0, 2880(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm16, 2816(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm27, 2752(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 2624(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 2560(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm2, 2496(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm19, 2432(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 2368(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 2240(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 2176(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm3, 2112(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm25, 2048(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 1984(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 1856(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 1792(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm4, 1728(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm26, 1664(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 1600(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 1472(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 1408(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm29, 1344(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm30, 1280(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 1216(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 1088(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 1024(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm6, 960(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm31, 896(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 832(%rax)
; AVX512DQ-FCP-NEXT:    vmovups (%rsp), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 704(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 640(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm9, 576(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm10, 512(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 448(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 320(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 256(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm12, 192(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm13, 128(%rax)
; AVX512DQ-FCP-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512DQ-FCP-NEXT:    vmovaps %zmm0, 64(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm14, 2688(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm15, 2304(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm17, 1920(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm18, 1536(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm20, 1152(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm21, 768(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm23, 384(%rax)
; AVX512DQ-FCP-NEXT:    vmovdqa64 %zmm24, (%rax)
; AVX512DQ-FCP-NEXT:    addq $3720, %rsp # imm = 0xE88
; AVX512DQ-FCP-NEXT:    vzeroupper
; AVX512DQ-FCP-NEXT:    retq
;
; AVX512BW-LABEL: store_i64_stride6_vf64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    subq $3720, %rsp # imm = 0xE88
; AVX512BW-NEXT:    vmovdqa64 (%rdi), %zmm11
; AVX512BW-NEXT:    vmovdqa64 64(%rdi), %zmm10
; AVX512BW-NEXT:    vmovdqa64 128(%rdi), %zmm9
; AVX512BW-NEXT:    vmovdqa64 192(%rdi), %zmm8
; AVX512BW-NEXT:    vmovdqa64 256(%rdi), %zmm7
; AVX512BW-NEXT:    vmovdqa64 320(%rdi), %zmm6
; AVX512BW-NEXT:    vmovdqa64 384(%rdi), %zmm5
; AVX512BW-NEXT:    vmovdqa64 448(%rdi), %zmm4
; AVX512BW-NEXT:    vmovdqa64 (%rsi), %zmm30
; AVX512BW-NEXT:    vmovdqa64 64(%rsi), %zmm29
; AVX512BW-NEXT:    vmovdqa64 128(%rsi), %zmm28
; AVX512BW-NEXT:    vmovdqa64 192(%rsi), %zmm27
; AVX512BW-NEXT:    vmovdqa64 256(%rsi), %zmm1
; AVX512BW-NEXT:    vmovdqa64 320(%rsi), %zmm13
; AVX512BW-NEXT:    vmovdqa64 384(%rsi), %zmm24
; AVX512BW-NEXT:    vmovdqa64 448(%rsi), %zmm0
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [4,12,5,13,4,12,5,13]
; AVX512BW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm22
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm2, %zmm22
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm24, %zmm2, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm2, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm2, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm27, %zmm2, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm28, %zmm2, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm2, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2q %zmm30, %zmm11, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm12 = [2,10,2,10,2,10,2,10]
; AVX512BW-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm11, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm12, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [6,14,6,14,6,14,6,14]
; AVX512BW-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm11, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm2, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm21 = [7,15,7,15,7,15,7,15]
; AVX512BW-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm11, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm21, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm12, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,8,1,9,0,8,1,9]
; AVX512BW-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm30, %zmm3, %zmm11
; AVX512BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm11
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm2, %zmm11
; AVX512BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm11
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm21, %zmm11
; AVX512BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm3, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm28, %zmm12, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm28, %zmm2, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm28, %zmm21, %zmm10
; AVX512BW-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm28, %zmm3, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512BW-NEXT:    vpermt2q %zmm27, %zmm12, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512BW-NEXT:    vpermt2q %zmm27, %zmm2, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512BW-NEXT:    vpermt2q %zmm27, %zmm21, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm27, %zmm3, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm12, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm2, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm21, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm1, %zmm3, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm12, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm2, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm21, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm13, %zmm3, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm24, %zmm12, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm24, %zmm2, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm8
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm24, %zmm21, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm24, %zmm3, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 (%rdx), %zmm5
; AVX512BW-NEXT:    vmovdqa64 (%rcx), %zmm14
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm29
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm21, %zmm29
; AVX512BW-NEXT:    vmovdqa64 64(%rdx), %zmm1
; AVX512BW-NEXT:    vmovdqa64 64(%rcx), %zmm11
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm20
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm21, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 128(%rdx), %zmm23
; AVX512BW-NEXT:    vmovdqa64 128(%rcx), %zmm9
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm21, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 192(%rdx), %zmm18
; AVX512BW-NEXT:    vmovdqa64 192(%rcx), %zmm6
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm21, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 256(%rdx), %zmm17
; AVX512BW-NEXT:    vmovdqa64 256(%rcx), %zmm7
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm21, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 320(%rdx), %zmm15
; AVX512BW-NEXT:    vmovdqa64 320(%rcx), %zmm10
; AVX512BW-NEXT:    vmovdqa64 %zmm15, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm21, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 384(%rdx), %zmm13
; AVX512BW-NEXT:    vmovdqa64 384(%rcx), %zmm2
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm1
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm21, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm1
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm4, %zmm12
; AVX512BW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm4, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 448(%rdx), %zmm16
; AVX512BW-NEXT:    vmovdqa64 448(%rcx), %zmm4
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm21, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2q %zmm0, %zmm1, %zmm21
; AVX512BW-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm3, %zmm1
; AVX512BW-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,0,4,12]
; AVX512BW-NEXT:    vmovdqa64 %zmm16, %zmm24
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm1, %zmm24
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm19
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm1, %zmm19
; AVX512BW-NEXT:    vmovdqa64 %zmm15, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm1, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm31
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm1, %zmm31
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm21
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm1, %zmm21
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm12
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm1, %zmm12
; AVX512BW-NEXT:    vmovdqa64 %zmm20, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm1, %zmm3
; AVX512BW-NEXT:    vpermi2q %zmm14, %zmm5, %zmm1
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm27 = [1,9,2,10,1,9,2,10]
; AVX512BW-NEXT:    # zmm27 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm27, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [5,13,6,14,5,13,6,14]
; AVX512BW-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm28, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [3,11,3,11,3,11,3,11]
; AVX512BW-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-NEXT:    vpermt2q %zmm14, %zmm0, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm20, %zmm5
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm27, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm20, %zmm5
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm28, %zmm5
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm0, %zmm20
; AVX512BW-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm27, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm23, %zmm11
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm28, %zmm11
; AVX512BW-NEXT:    vmovdqa64 %zmm11, %zmm30
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm0, %zmm23
; AVX512BW-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm9
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm27, %zmm9
; AVX512BW-NEXT:    vmovdqa64 %zmm18, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm28, %zmm8
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm0, %zmm18
; AVX512BW-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm27, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm6
; AVX512BW-NEXT:    vmovdqa64 %zmm17, %zmm14
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm28, %zmm6
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm0, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm15, %zmm6
; AVX512BW-NEXT:    vmovdqa64 %zmm15, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm27, %zmm7
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm26
; AVX512BW-NEXT:    vmovdqa64 %zmm15, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm28, %zmm7
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm25
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm0, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm6
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm27, %zmm7
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm10
; AVX512BW-NEXT:    vmovdqa64 %zmm13, %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm28, %zmm7
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm23
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm0, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm16, %zmm27
; AVX512BW-NEXT:    vpermi2q %zmm4, %zmm16, %zmm28
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm0, %zmm16
; AVX512BW-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    movb $12, %al
; AVX512BW-NEXT:    kmovd %eax, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm24, %zmm22 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm18 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm19, %zmm18 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm19 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm19 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm17 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm31, %zmm17 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm16 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm21, %zmm16 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm21 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm12, %zmm21 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm31 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm3, %zmm31 {%k1}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm20 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm20 {%k1}
; AVX512BW-NEXT:    movb $48, %al
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm2 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm3 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vshufi64x2 {{.*#+}} zmm14 = zmm0[0,1,2,3],zmm29[4,5,6,7]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm4 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm5 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vshufi64x2 $228, (%rsp), %zmm0, %zmm0 # 64-byte Folded Reload
; AVX512BW-NEXT:    # zmm0 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vmovdqu64 %zmm0, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm6 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm30 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm15 # 64-byte Folded Reload
; AVX512BW-NEXT:    # zmm15 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm9 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm8 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm13 # 64-byte Folded Reload
; AVX512BW-NEXT:    # zmm13 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm7 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm7 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm11 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm12 # 64-byte Folded Reload
; AVX512BW-NEXT:    # zmm12 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm26 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm25 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm0 # 64-byte Folded Reload
; AVX512BW-NEXT:    # zmm0 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm10 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm23 {%k2}
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm0, %zmm0 # 64-byte Folded Reload
; AVX512BW-NEXT:    # zmm0 = zmm0[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm27 {%k2}
; AVX512BW-NEXT:    vmovdqa64 (%r8), %zmm29
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,9,0,4,5,6,7]
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm1, %zmm2
; AVX512BW-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 64(%r8), %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm1, %zmm4
; AVX512BW-NEXT:    vmovdqu64 %zmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 128(%r8), %zmm0
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm1, %zmm6
; AVX512BW-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 192(%r8), %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm1, %zmm9
; AVX512BW-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 256(%r8), %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm1, %zmm7
; AVX512BW-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 320(%r8), %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm1, %zmm26
; AVX512BW-NEXT:    vmovdqu64 %zmm26, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 384(%r8), %zmm9
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm1, %zmm10
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm24
; AVX512BW-NEXT:    vmovdqa64 448(%r8), %zmm10
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm1, %zmm27
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm28 {%k2}
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,13,0,4,5,6,7]
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm1, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm1, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm1, %zmm30
; AVX512BW-NEXT:    vmovdqu64 %zmm30, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm1, %zmm8
; AVX512BW-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm1, %zmm11
; AVX512BW-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm1, %zmm25
; AVX512BW-NEXT:    vmovdqu64 %zmm25, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm1, %zmm23
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm1, %zmm28
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vshufi64x2 $228, {{[-0-9]+}}(%r{{[sb]}}p), %zmm1, %zmm3 # 64-byte Folded Reload
; AVX512BW-NEXT:    # zmm3 = zmm1[0,1,2,3],mem[4,5,6,7]
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [14,0,2,3,4,5,15,0]
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm1, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 (%rsp), %zmm14 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm1, %zmm14
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm1, %zmm15
; AVX512BW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm1, %zmm13
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm1, %zmm12
; AVX512BW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm1, %zmm12
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm1, %zmm15
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm1, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm3, %zmm3
; AVX512BW-NEXT:    vmovdqa 64(%rdi), %ymm1
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm1 = ymm1[1],mem[1],ymm1[3],mem[3]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm1, %zmm5, %zmm5
; AVX512BW-NEXT:    movb $16, %al
; AVX512BW-NEXT:    kmovd %eax, %k2
; AVX512BW-NEXT:    vmovdqa64 %zmm2, %zmm31 {%k2}
; AVX512BW-NEXT:    vmovdqu64 %zmm31, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [10,0,2,3,4,5,11,0]
; AVX512BW-NEXT:    vpermt2q %zmm2, %zmm1, %zmm5
; AVX512BW-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa 128(%rdi), %ymm2
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm5 # 64-byte Reload
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm5, %zmm31
; AVX512BW-NEXT:    vmovdqa64 %zmm0, %zmm21 {%k2}
; AVX512BW-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm0, %zmm1, %zmm31
; AVX512BW-NEXT:    vmovdqa 192(%rdi), %ymm2
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm30
; AVX512BW-NEXT:    vmovdqa64 %zmm4, %zmm16 {%k2}
; AVX512BW-NEXT:    vmovdqu64 %zmm16, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm1, %zmm30
; AVX512BW-NEXT:    vmovdqa 256(%rdi), %ymm2
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm26
; AVX512BW-NEXT:    vmovdqa64 %zmm6, %zmm17 {%k2}
; AVX512BW-NEXT:    vmovdqu64 %zmm17, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm6, %zmm1, %zmm26
; AVX512BW-NEXT:    vmovdqa 320(%rdi), %ymm2
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm25
; AVX512BW-NEXT:    vmovdqa64 %zmm7, %zmm19 {%k2}
; AVX512BW-NEXT:    vmovdqu64 %zmm19, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm1, %zmm25
; AVX512BW-NEXT:    vmovdqa 384(%rdi), %ymm2
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm19
; AVX512BW-NEXT:    vmovdqa64 %zmm9, %zmm18 {%k2}
; AVX512BW-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm9, %zmm1, %zmm19
; AVX512BW-NEXT:    vmovdqa 448(%rdi), %ymm2
; AVX512BW-NEXT:    vpunpckhqdq {{.*#+}} ymm2 = ymm2[1],mem[1],ymm2[3],mem[3]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm2, %zmm0, %zmm16
; AVX512BW-NEXT:    vmovdqa64 %zmm10, %zmm22 {%k2}
; AVX512BW-NEXT:    vmovdqu64 %zmm22, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm10, %zmm1, %zmm16
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm1, %zmm3
; AVX512BW-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 %zmm29, %zmm20 {%k2}
; AVX512BW-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 (%r9), %zmm29
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,1,2,9,4,5,6,7]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 64(%r9), %zmm3
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 128(%r9), %zmm4
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 192(%r9), %zmm5
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 256(%r9), %zmm11
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 320(%r9), %zmm8
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm8, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 384(%r9), %zmm7
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm6, %zmm24
; AVX512BW-NEXT:    vmovdqu64 %zmm24, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa64 448(%r9), %zmm22
; AVX512BW-NEXT:    vpermt2q %zmm22, %zmm6, %zmm27
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,1,2,13,4,5,6,7]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm8, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm6, %zmm23
; AVX512BW-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm22, %zmm6, %zmm28
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm6 = [0,14,2,3,4,5,6,15]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm6, %zmm14
; AVX512BW-NEXT:    vmovdqu64 %zmm14, (%rsp) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm6, %zmm13
; AVX512BW-NEXT:    vmovdqu64 %zmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm8, %zmm6, %zmm12
; AVX512BW-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm6, %zmm15
; AVX512BW-NEXT:    vmovdqu64 %zmm15, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm22, %zmm6, %zmm0
; AVX512BW-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-NEXT:    vmovdqa (%rdx), %xmm6
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm0 {%k1}
; AVX512BW-NEXT:    vmovdqa 64(%rdx), %xmm6
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm14 # 64-byte Reload
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm14 {%k1}
; AVX512BW-NEXT:    vmovdqa 128(%rdx), %xmm6
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm15 # 64-byte Reload
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm15 {%k1}
; AVX512BW-NEXT:    vmovdqa 192(%rdx), %xmm6
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm10 {%k1}
; AVX512BW-NEXT:    vmovdqa 256(%rdx), %xmm6
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm12 {%k1}
; AVX512BW-NEXT:    vmovdqa 320(%rdx), %xmm6
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm2 {%k1}
; AVX512BW-NEXT:    vmovdqa 384(%rdx), %xmm6
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm9 {%k1}
; AVX512BW-NEXT:    vmovdqa 448(%rdx), %xmm6
; AVX512BW-NEXT:    vpunpcklqdq {{.*#+}} xmm6 = xmm6[0],mem[0]
; AVX512BW-NEXT:    vinserti128 $1, %xmm6, %ymm0, %ymm6
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vinserti64x4 $0, %ymm6, %zmm0, %zmm1 {%k1}
; AVX512BW-NEXT:    vinserti32x4 $2, (%r8), %zmm0, %zmm24
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [0,1,2,3,4,8,6,7]
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm0, %zmm24
; AVX512BW-NEXT:    vinserti32x4 $2, 64(%r8), %zmm14, %zmm23
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm0, %zmm23
; AVX512BW-NEXT:    vinserti32x4 $2, 128(%r8), %zmm15, %zmm21
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm0, %zmm21
; AVX512BW-NEXT:    vinserti32x4 $2, 192(%r8), %zmm10, %zmm20
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm0, %zmm20
; AVX512BW-NEXT:    vinserti32x4 $2, 256(%r8), %zmm12, %zmm18
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm0, %zmm18
; AVX512BW-NEXT:    vinserti32x4 $2, 320(%r8), %zmm2, %zmm17
; AVX512BW-NEXT:    vpermt2q %zmm8, %zmm0, %zmm17
; AVX512BW-NEXT:    vinserti32x4 $2, 384(%r8), %zmm9, %zmm15
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm0, %zmm15
; AVX512BW-NEXT:    vinserti32x4 $2, 448(%r8), %zmm1, %zmm14
; AVX512BW-NEXT:    vpermt2q %zmm22, %zmm0, %zmm14
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm0 = [0,10,2,3,4,5,6,11]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm13 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm0, %zmm13
; AVX512BW-NEXT:    vpmovsxbq {{.*#+}} zmm1 = [0,1,2,3,4,12,6,7]
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm12 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm29, %zmm1, %zmm12
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm10 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm0, %zmm10
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm9 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm3, %zmm1, %zmm9
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm0, %zmm31
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm6 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm4, %zmm1, %zmm6
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm0, %zmm30
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm29 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm5, %zmm1, %zmm29
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm0, %zmm26
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm4 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm11, %zmm1, %zmm4
; AVX512BW-NEXT:    vpermt2q %zmm8, %zmm0, %zmm25
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm3 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm8, %zmm1, %zmm3
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm0, %zmm19
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm2 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm7, %zmm1, %zmm2
; AVX512BW-NEXT:    vpermt2q %zmm22, %zmm0, %zmm16
; AVX512BW-NEXT:    vmovdqu64 {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vpermt2q %zmm22, %zmm1, %zmm0
; AVX512BW-NEXT:    movq {{[0-9]+}}(%rsp), %rax
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm1 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm1, 3008(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm28, 2944(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm0, 2880(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm16, 2816(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm27, 2752(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 2624(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 2560(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm2, 2496(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm19, 2432(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 2368(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 2240(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 2176(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm3, 2112(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm25, 2048(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 1984(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 1856(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 1792(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm4, 1728(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm26, 1664(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 1600(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 1472(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 1408(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm29, 1344(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm30, 1280(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 1216(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 1088(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 1024(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm6, 960(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm31, 896(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 832(%rax)
; AVX512BW-NEXT:    vmovups (%rsp), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 704(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 640(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm9, 576(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm10, 512(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 448(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 320(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 256(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm12, 192(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm13, 128(%rax)
; AVX512BW-NEXT:    vmovups {{[-0-9]+}}(%r{{[sb]}}p), %zmm0 # 64-byte Reload
; AVX512BW-NEXT:    vmovaps %zmm0, 64(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm14, 2688(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm15, 2304(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm17, 1920(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm18, 1536(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm20, 1152(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm21, 768(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm23, 384(%rax)
; AVX512BW-NEXT:    vmovdqa64 %zmm24, (%rax)
; AVX512BW-NEXT:    addq $3720, %rsp # imm = 0xE88
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512BW-FCP-LABEL: store_i64_stride6_vf64:
; AVX512BW-FCP:       # %bb.0:
; AVX512BW-FCP-NEXT:    subq $3720, %rsp # imm = 0xE88
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdi), %zmm11
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdi), %zmm10
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rdi), %zmm9
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rdi), %zmm8
; AVX512BW-FCP-NEXT:    vmovdqa64 256(%rdi), %zmm7
; AVX512BW-FCP-NEXT:    vmovdqa64 320(%rdi), %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 384(%rdi), %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa64 448(%rdi), %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rsi), %zmm30
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rsi), %zmm29
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rsi), %zmm28
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rsi), %zmm27
; AVX512BW-FCP-NEXT:    vmovdqa64 256(%rsi), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 320(%rsi), %zmm13
; AVX512BW-FCP-NEXT:    vmovdqa64 384(%rsi), %zmm24
; AVX512BW-FCP-NEXT:    vmovdqa64 448(%rsi), %zmm0
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm2 = [4,12,5,13,4,12,5,13]
; AVX512BW-FCP-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm22
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm2, %zmm22
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm3
; AVX512BW-FCP-NEXT:    vpermt2q %zmm24, %zmm2, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm3
; AVX512BW-FCP-NEXT:    vpermt2q %zmm13, %zmm2, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm3
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm2, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm3
; AVX512BW-FCP-NEXT:    vpermt2q %zmm27, %zmm2, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm3
; AVX512BW-FCP-NEXT:    vpermt2q %zmm28, %zmm2, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, %zmm3
; AVX512BW-FCP-NEXT:    vpermt2q %zmm29, %zmm2, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermi2q %zmm30, %zmm11, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm12 = [2,10,2,10,2,10,2,10]
; AVX512BW-FCP-NEXT:    # zmm12 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm3
; AVX512BW-FCP-NEXT:    vpermt2q %zmm30, %zmm12, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm2 = [6,14,6,14,6,14,6,14]
; AVX512BW-FCP-NEXT:    # zmm2 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm3
; AVX512BW-FCP-NEXT:    vpermt2q %zmm30, %zmm2, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm21 = [7,15,7,15,7,15,7,15]
; AVX512BW-FCP-NEXT:    # zmm21 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm3
; AVX512BW-FCP-NEXT:    vpermt2q %zmm30, %zmm21, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, %zmm3
; AVX512BW-FCP-NEXT:    vpermt2q %zmm29, %zmm12, %zmm3
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm3 = [0,8,1,9,0,8,1,9]
; AVX512BW-FCP-NEXT:    # zmm3 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm30, %zmm3, %zmm11
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, %zmm11
; AVX512BW-FCP-NEXT:    vpermt2q %zmm29, %zmm2, %zmm11
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm10, %zmm11
; AVX512BW-FCP-NEXT:    vpermt2q %zmm29, %zmm21, %zmm11
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm11, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm29, %zmm3, %zmm10
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512BW-FCP-NEXT:    vpermt2q %zmm28, %zmm12, %zmm10
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512BW-FCP-NEXT:    vpermt2q %zmm28, %zmm2, %zmm10
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm9, %zmm10
; AVX512BW-FCP-NEXT:    vpermt2q %zmm28, %zmm21, %zmm10
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm10, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm28, %zmm3, %zmm9
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512BW-FCP-NEXT:    vpermt2q %zmm27, %zmm12, %zmm9
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512BW-FCP-NEXT:    vpermt2q %zmm27, %zmm2, %zmm9
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm8, %zmm9
; AVX512BW-FCP-NEXT:    vpermt2q %zmm27, %zmm21, %zmm9
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm27, %zmm3, %zmm8
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm8
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm12, %zmm8
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm8
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm2, %zmm8
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm8
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm21, %zmm8
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm1, %zmm3, %zmm7
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm7, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm13, %zmm12, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm13, %zmm2, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm13, %zmm21, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm13, %zmm3, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm24, %zmm12, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm24, %zmm2, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm2, %zmm8
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm24, %zmm21, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm24, %zmm3, %zmm5
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rdx), %zmm5
; AVX512BW-FCP-NEXT:    vmovdqa64 (%rcx), %zmm14
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm29
; AVX512BW-FCP-NEXT:    vpermt2q %zmm14, %zmm21, %zmm29
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rdx), %zmm1
; AVX512BW-FCP-NEXT:    vmovdqa64 64(%rcx), %zmm11
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm1, %zmm20
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm21, %zmm2
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm2, (%rsp) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rdx), %zmm23
; AVX512BW-FCP-NEXT:    vmovdqa64 128(%rcx), %zmm9
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm9, %zmm21, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rdx), %zmm18
; AVX512BW-FCP-NEXT:    vmovdqa64 192(%rcx), %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm21, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 256(%rdx), %zmm17
; AVX512BW-FCP-NEXT:    vmovdqa64 256(%rcx), %zmm7
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm17, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm7, %zmm21, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 320(%rdx), %zmm15
; AVX512BW-FCP-NEXT:    vmovdqa64 320(%rcx), %zmm10
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm10, %zmm21, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 384(%rdx), %zmm13
; AVX512BW-FCP-NEXT:    vmovdqa64 384(%rcx), %zmm2
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm13, %zmm1
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm21, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm4, %zmm1
; AVX512BW-FCP-NEXT:    vpermi2q %zmm0, %zmm4, %zmm12
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm12, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermi2q %zmm0, %zmm4, %zmm8
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 448(%rdx), %zmm16
; AVX512BW-FCP-NEXT:    vmovdqa64 448(%rcx), %zmm4
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm16, %zmm8
; AVX512BW-FCP-NEXT:    vpermt2q %zmm4, %zmm21, %zmm8
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermi2q %zmm0, %zmm1, %zmm21
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm21, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermt2q %zmm0, %zmm3, %zmm1
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm1, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpmovsxbq {{.*#+}} ymm1 = [0,0,4,12]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm16, %zmm24
; AVX512BW-FCP-NEXT:    vpermt2q %zmm4, %zmm1, %zmm24
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm13, %zmm19
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm1, %zmm19
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm10, %zmm1, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm17, %zmm31
; AVX512BW-FCP-NEXT:    vpermt2q %zmm7, %zmm1, %zmm31
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm21
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm1, %zmm21
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm12
; AVX512BW-FCP-NEXT:    vpermt2q %zmm9, %zmm1, %zmm12
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm20, %zmm3
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm1, %zmm3
; AVX512BW-FCP-NEXT:    vpermi2q %zmm14, %zmm5, %zmm1
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm27 = [1,9,2,10,1,9,2,10]
; AVX512BW-FCP-NEXT:    # zmm27 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm14, %zmm27, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vbroadcasti64x4 {{.*#+}} zmm28 = [5,13,6,14,5,13,6,14]
; AVX512BW-FCP-NEXT:    # zmm28 = mem[0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm5, %zmm0
; AVX512BW-FCP-NEXT:    vpermt2q %zmm14, %zmm28, %zmm0
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vbroadcasti32x4 {{.*#+}} zmm0 = [3,11,3,11,3,11,3,11]
; AVX512BW-FCP-NEXT:    # zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; AVX512BW-FCP-NEXT:    vpermt2q %zmm14, %zmm0, %zmm5
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm20, %zmm5
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm27, %zmm5
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm5, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm20, %zmm5
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm28, %zmm5
; AVX512BW-FCP-NEXT:    vpermt2q %zmm11, %zmm0, %zmm20
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm20, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm8
; AVX512BW-FCP-NEXT:    vpermt2q %zmm9, %zmm27, %zmm8
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm8, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm23, %zmm11
; AVX512BW-FCP-NEXT:    vpermt2q %zmm9, %zmm28, %zmm11
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm11, %zmm30
; AVX512BW-FCP-NEXT:    vpermt2q %zmm9, %zmm0, %zmm23
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm23, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm9
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm27, %zmm9
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm18, %zmm8
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm28, %zmm8
; AVX512BW-FCP-NEXT:    vpermt2q %zmm6, %zmm0, %zmm18
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm18, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm17, %zmm6
; AVX512BW-FCP-NEXT:    vpermt2q %zmm7, %zmm27, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm17, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm17, %zmm14
; AVX512BW-FCP-NEXT:    vpermt2q %zmm7, %zmm28, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm6, %zmm11
; AVX512BW-FCP-NEXT:    vpermt2q %zmm7, %zmm0, %zmm14
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm14, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm7
; AVX512BW-FCP-NEXT:    vpermt2q %zmm10, %zmm27, %zmm7
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm26
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm15, %zmm7
; AVX512BW-FCP-NEXT:    vpermt2q %zmm10, %zmm28, %zmm7
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm25
; AVX512BW-FCP-NEXT:    vpermt2q %zmm10, %zmm0, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm13, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm13, %zmm7
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm27, %zmm7
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm10
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm13, %zmm7
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm28, %zmm7
; AVX512BW-FCP-NEXT:    vmovdqa64 %zmm7, %zmm23
; AVX512BW-FCP-NEXT:    vpermt2q %zmm2, %zmm0, %zmm6
; AVX512BW-FCP-NEXT:    vmovdqu64 %zmm6, {{[-0-9]+}}(%r{{[sb]}}p) # 64-byte Spill
; AVX512BW-FCP-NEXT:    vpermi2q %zmm4, %zmm16, %zmm27
; AVX512BW-FCP-NEXT:    vpermi2q %zmm4, %zmm