; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=riscv32 -global-isel | FileCheck %s --check-prefix=RV32I
; RUN: llc < %s -mtriple=riscv64 -global-isel | FileCheck %s --check-prefix=RV64I

define i8 @ucmp.8.8(i8 zeroext %x, i8 zeroext %y) nounwind {
; RV32I-LABEL: ucmp.8.8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sltu a2, a1, a0
; RV32I-NEXT:    sltu a0, a0, a1
; RV32I-NEXT:    sub a0, a2, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ucmp.8.8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a2, a1, a0
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    sub a0, a2, a0
; RV64I-NEXT:    ret
  %1 = call i8 @llvm.ucmp(i8 %x, i8 %y)
  ret i8 %1
}

define i8 @ucmp.8.16(i16 zeroext %x, i16 zeroext %y) nounwind {
; RV32I-LABEL: ucmp.8.16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sltu a2, a1, a0
; RV32I-NEXT:    sltu a0, a0, a1
; RV32I-NEXT:    sub a0, a2, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ucmp.8.16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a2, a1, a0
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    sub a0, a2, a0
; RV64I-NEXT:    ret
  %1 = call i8 @llvm.ucmp(i16 %x, i16 %y)
  ret i8 %1
}

define i8 @ucmp.8.32(i32 %x, i32 %y) nounwind {
; RV32I-LABEL: ucmp.8.32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sltu a2, a1, a0
; RV32I-NEXT:    sltu a0, a0, a1
; RV32I-NEXT:    sub a0, a2, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ucmp.8.32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    sext.w a1, a1
; RV64I-NEXT:    sltu a2, a1, a0
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    sub a0, a2, a0
; RV64I-NEXT:    ret
  %1 = call i8 @llvm.ucmp(i32 %x, i32 %y)
  ret i8 %1
}

define i8 @ucmp.8.64(i64 %x, i64 %y) nounwind {
; RV32I-LABEL: ucmp.8.64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    beq a1, a3, .LBB3_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    sltu a4, a3, a1
; RV32I-NEXT:    sltu a0, a1, a3
; RV32I-NEXT:    sub a0, a4, a0
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB3_2:
; RV32I-NEXT:    sltu a4, a2, a0
; RV32I-NEXT:    sltu a0, a0, a2
; RV32I-NEXT:    sub a0, a4, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ucmp.8.64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a2, a1, a0
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    sub a0, a2, a0
; RV64I-NEXT:    ret
  %1 = call i8 @llvm.ucmp(i64 %x, i64 %y)
  ret i8 %1
}

define i32 @ucmp.32.32(i32 %x, i32 %y) nounwind {
; RV32I-LABEL: ucmp.32.32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sltu a2, a1, a0
; RV32I-NEXT:    sltu a0, a0, a1
; RV32I-NEXT:    sub a0, a2, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ucmp.32.32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    sext.w a1, a1
; RV64I-NEXT:    sltu a2, a1, a0
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    subw a0, a2, a0
; RV64I-NEXT:    ret
  %1 = call i32 @llvm.ucmp(i32 %x, i32 %y)
  ret i32 %1
}

define i32 @ucmp.32.32_sext(i32 signext %x, i32 signext %y) nounwind {
; RV32I-LABEL: ucmp.32.32_sext:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sltu a2, a1, a0
; RV32I-NEXT:    sltu a0, a0, a1
; RV32I-NEXT:    sub a0, a2, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ucmp.32.32_sext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a2, a1, a0
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    subw a0, a2, a0
; RV64I-NEXT:    ret
  %1 = call i32 @llvm.ucmp(i32 %x, i32 %y)
  ret i32 %1
}

define i32 @ucmp.32.32_zext(i32 zeroext %x, i32 zeroext %y) nounwind {
; RV32I-LABEL: ucmp.32.32_zext:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sltu a2, a1, a0
; RV32I-NEXT:    sltu a0, a0, a1
; RV32I-NEXT:    sub a0, a2, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ucmp.32.32_zext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    sext.w a1, a1
; RV64I-NEXT:    sltu a2, a1, a0
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    subw a0, a2, a0
; RV64I-NEXT:    ret
  %1 = call i32 @llvm.ucmp(i32 %x, i32 %y)
  ret i32 %1
}

define i32 @ucmp.32.64(i64 %x, i64 %y) nounwind {
; RV32I-LABEL: ucmp.32.64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    beq a1, a3, .LBB7_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    sltu a4, a3, a1
; RV32I-NEXT:    sltu a0, a1, a3
; RV32I-NEXT:    sub a0, a4, a0
; RV32I-NEXT:    ret
; RV32I-NEXT:  .LBB7_2:
; RV32I-NEXT:    sltu a4, a2, a0
; RV32I-NEXT:    sltu a0, a0, a2
; RV32I-NEXT:    sub a0, a4, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ucmp.32.64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a2, a1, a0
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    subw a0, a2, a0
; RV64I-NEXT:    ret
  %1 = call i32 @llvm.ucmp(i64 %x, i64 %y)
  ret i32 %1
}

define i64 @ucmp.64.64(i64 %x, i64 %y) nounwind {
; RV32I-LABEL: ucmp.64.64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    beq a1, a3, .LBB8_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    sltu a4, a3, a1
; RV32I-NEXT:    sltu a1, a1, a3
; RV32I-NEXT:    j .LBB8_3
; RV32I-NEXT:  .LBB8_2:
; RV32I-NEXT:    sltu a4, a2, a0
; RV32I-NEXT:    sltu a1, a0, a2
; RV32I-NEXT:  .LBB8_3:
; RV32I-NEXT:    sub a0, a4, a1
; RV32I-NEXT:    sltu a1, a4, a1
; RV32I-NEXT:    neg a1, a1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: ucmp.64.64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a2, a1, a0
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    sub a0, a2, a0
; RV64I-NEXT:    ret
  %1 = call i64 @llvm.ucmp(i64 %x, i64 %y)
  ret i64 %1
}
