; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx803 < %s | FileCheck -check-prefixes=GFX8 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx803 -mattr=+architected-flat-scratch < %s | FileCheck -check-prefixes=GFX8-ARCH-FLAT %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 < %s | FileCheck -check-prefixes=GFX9 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 -mattr=+architected-flat-scratch < %s | FileCheck -check-prefixes=GFX9-ARCH-FLAT %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx942 -mattr=+architected-flat-scratch < %s | FileCheck -check-prefixes=GFX942-ARCH-FLAT %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1010 < %s | FileCheck -check-prefixes=GFX10 %s

;
; None of these functions should have the attribute amdgpu-no-flat-scratch-init. In these tests
; we manually set the attribute for the functions. The purpose is to test how llc handles this.
;

;; tests of addrspacecast

define void @with_private_to_flat_addrspacecast(ptr addrspace(5) %ptr) #0 {
; GFX8-LABEL: with_private_to_flat_addrspacecast:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b64 s[4:5], 0xc0
; GFX8-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX8-NEXT:    v_cmp_ne_u32_e32 vcc, -1, v0
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, 0, v0, vcc
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s4
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-ARCH-FLAT-LABEL: with_private_to_flat_addrspacecast:
; GFX8-ARCH-FLAT:       ; %bb.0:
; GFX8-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-ARCH-FLAT-NEXT:    s_mov_b64 s[0:1], 0xc0
; GFX8-ARCH-FLAT-NEXT:    s_load_dword s0, s[0:1], 0x0
; GFX8-ARCH-FLAT-NEXT:    v_cmp_ne_u32_e32 vcc, -1, v0
; GFX8-ARCH-FLAT-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-ARCH-FLAT-NEXT:    v_cndmask_b32_e32 v0, 0, v0, vcc
; GFX8-ARCH-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-ARCH-FLAT-NEXT:    v_mov_b32_e32 v1, s0
; GFX8-ARCH-FLAT-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX8-ARCH-FLAT-NEXT:    flat_store_dword v[0:1], v2
; GFX8-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-ARCH-FLAT-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: with_private_to_flat_addrspacecast:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_mov_b64 s[4:5], src_private_base
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, -1, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX9-NEXT:    v_cndmask_b32_e32 v0, 0, v0, vcc
; GFX9-NEXT:    flat_store_dword v[0:1], v2
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-ARCH-FLAT-LABEL: with_private_to_flat_addrspacecast:
; GFX9-ARCH-FLAT:       ; %bb.0:
; GFX9-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-ARCH-FLAT-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX9-ARCH-FLAT-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-ARCH-FLAT-NEXT:    v_cmp_ne_u32_e32 vcc, -1, v0
; GFX9-ARCH-FLAT-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-ARCH-FLAT-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX9-ARCH-FLAT-NEXT:    v_cndmask_b32_e32 v0, 0, v0, vcc
; GFX9-ARCH-FLAT-NEXT:    flat_store_dword v[0:1], v2
; GFX9-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-ARCH-FLAT-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-ARCH-FLAT-LABEL: with_private_to_flat_addrspacecast:
; GFX942-ARCH-FLAT:       ; %bb.0:
; GFX942-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-ARCH-FLAT-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX942-ARCH-FLAT-NEXT:    v_mov_b32_e32 v1, s1
; GFX942-ARCH-FLAT-NEXT:    v_cmp_ne_u32_e32 vcc, -1, v0
; GFX942-ARCH-FLAT-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-ARCH-FLAT-NEXT:    s_nop 0
; GFX942-ARCH-FLAT-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX942-ARCH-FLAT-NEXT:    v_cndmask_b32_e32 v0, 0, v0, vcc
; GFX942-ARCH-FLAT-NEXT:    flat_store_dword v[0:1], v2 sc0 sc1
; GFX942-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX942-ARCH-FLAT-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: with_private_to_flat_addrspacecast:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_ne_u32_e32 vcc_lo, -1, v0
; GFX10-NEXT:    s_mov_b64 s[4:5], src_private_base
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_cndmask_b32_e64 v1, 0, s5, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e32 v0, 0, v0, vcc_lo
; GFX10-NEXT:    flat_store_dword v[0:1], v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %stof = addrspacecast ptr addrspace(5) %ptr to ptr
  store volatile i32 0, ptr %stof
  ret void
}

define amdgpu_kernel void @with_private_to_flat_addrspacecast_cc_kernel(ptr addrspace(5) %ptr) #0 {
; GFX8-LABEL: with_private_to_flat_addrspacecast_cc_kernel:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s0, s[8:9], 0x0
; GFX8-NEXT:    s_load_dword s1, s[8:9], 0xc8
; GFX8-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_cmp_lg_u32 s0, -1
; GFX8-NEXT:    s_cselect_b32 s1, s1, 0
; GFX8-NEXT:    s_cselect_b32 s0, s0, 0
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX8-ARCH-FLAT-LABEL: with_private_to_flat_addrspacecast_cc_kernel:
; GFX8-ARCH-FLAT:       ; %bb.0:
; GFX8-ARCH-FLAT-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX8-ARCH-FLAT-NEXT:    s_load_dword s1, s[4:5], 0xc8
; GFX8-ARCH-FLAT-NEXT:    v_mov_b32_e32 v2, 0
; GFX8-ARCH-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-ARCH-FLAT-NEXT:    s_cmp_lg_u32 s0, -1
; GFX8-ARCH-FLAT-NEXT:    s_cselect_b32 s1, s1, 0
; GFX8-ARCH-FLAT-NEXT:    s_cselect_b32 s0, s0, 0
; GFX8-ARCH-FLAT-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-ARCH-FLAT-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-ARCH-FLAT-NEXT:    flat_store_dword v[0:1], v2
; GFX8-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0)
; GFX8-ARCH-FLAT-NEXT:    s_endpgm
;
; GFX9-LABEL: with_private_to_flat_addrspacecast_cc_kernel:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[8:9], 0x0
; GFX9-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s2, -1
; GFX9-NEXT:    s_cselect_b32 s0, s1, 0
; GFX9-NEXT:    s_cselect_b32 s1, s2, 0
; GFX9-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    flat_store_dword v[0:1], v2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX9-ARCH-FLAT-LABEL: with_private_to_flat_addrspacecast_cc_kernel:
; GFX9-ARCH-FLAT:       ; %bb.0:
; GFX9-ARCH-FLAT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX9-ARCH-FLAT-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX9-ARCH-FLAT-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-ARCH-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-ARCH-FLAT-NEXT:    s_cmp_lg_u32 s2, -1
; GFX9-ARCH-FLAT-NEXT:    s_cselect_b32 s0, s1, 0
; GFX9-ARCH-FLAT-NEXT:    s_cselect_b32 s1, s2, 0
; GFX9-ARCH-FLAT-NEXT:    v_mov_b32_e32 v0, s1
; GFX9-ARCH-FLAT-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-ARCH-FLAT-NEXT:    flat_store_dword v[0:1], v2
; GFX9-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0)
; GFX9-ARCH-FLAT-NEXT:    s_endpgm
;
; GFX942-ARCH-FLAT-LABEL: with_private_to_flat_addrspacecast_cc_kernel:
; GFX942-ARCH-FLAT:       ; %bb.0:
; GFX942-ARCH-FLAT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX942-ARCH-FLAT-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX942-ARCH-FLAT-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-ARCH-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-ARCH-FLAT-NEXT:    s_cmp_lg_u32 s2, -1
; GFX942-ARCH-FLAT-NEXT:    s_cselect_b32 s0, s1, 0
; GFX942-ARCH-FLAT-NEXT:    s_cselect_b32 s1, s2, 0
; GFX942-ARCH-FLAT-NEXT:    v_mov_b32_e32 v0, s1
; GFX942-ARCH-FLAT-NEXT:    v_mov_b32_e32 v1, s0
; GFX942-ARCH-FLAT-NEXT:    flat_store_dword v[0:1], v2 sc0 sc1
; GFX942-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0)
; GFX942-ARCH-FLAT-NEXT:    s_endpgm
;
; GFX10-LABEL: with_private_to_flat_addrspacecast_cc_kernel:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dword s2, s[8:9], 0x0
; GFX10-NEXT:    s_mov_b64 s[0:1], src_private_base
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_cmp_lg_u32 s2, -1
; GFX10-NEXT:    s_cselect_b32 s0, s2, 0
; GFX10-NEXT:    s_cselect_b32 s1, s1, 0
; GFX10-NEXT:    v_mov_b32_e32 v0, s0
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    flat_store_dword v[0:1], v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_endpgm
  %stof = addrspacecast ptr addrspace(5) %ptr to ptr
  store volatile i32 0, ptr %stof
  ret void
}

define void @call_with_private_to_flat_addrspacecast(ptr addrspace(5) %ptr) #0 {
; GFX8-LABEL: call_with_private_to_flat_addrspacecast:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b32 s18, s33
; GFX8-NEXT:    s_mov_b32 s33, s32
; GFX8-NEXT:    s_xor_saveexec_b64 s[16:17], -1
; GFX8-NEXT:    buffer_store_dword v3, off, s[0:3], s33 ; 4-byte Folded Spill
; GFX8-NEXT:    s_mov_b64 exec, s[16:17]
; GFX8-NEXT:    s_addk_i32 s32, 0x400
; GFX8-NEXT:    s_getpc_b64 s[16:17]
; GFX8-NEXT:    s_add_u32 s16, s16, with_private_to_flat_addrspacecast@gotpcrel32@lo+4
; GFX8-NEXT:    s_addc_u32 s17, s17, with_private_to_flat_addrspacecast@gotpcrel32@hi+12
; GFX8-NEXT:    s_load_dwordx2 s[16:17], s[16:17], 0x0
; GFX8-NEXT:    v_writelane_b32 v3, s30, 0
; GFX8-NEXT:    v_writelane_b32 v3, s31, 1
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX8-NEXT:    v_readlane_b32 s31, v3, 1
; GFX8-NEXT:    v_readlane_b32 s30, v3, 0
; GFX8-NEXT:    s_mov_b32 s32, s33
; GFX8-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX8-NEXT:    buffer_load_dword v3, off, s[0:3], s33 ; 4-byte Folded Reload
; GFX8-NEXT:    s_mov_b64 exec, s[4:5]
; GFX8-NEXT:    s_mov_b32 s33, s18
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-ARCH-FLAT-LABEL: call_with_private_to_flat_addrspacecast:
; GFX8-ARCH-FLAT:       ; %bb.0:
; GFX8-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-ARCH-FLAT-NEXT:    s_mov_b32 s2, s33
; GFX8-ARCH-FLAT-NEXT:    s_mov_b32 s33, s32
; GFX8-ARCH-FLAT-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX8-ARCH-FLAT-NEXT:    s_add_i32 s3, s33, 8
; GFX8-ARCH-FLAT-NEXT:    scratch_store_dword off, v3, s3 ; 4-byte Folded Spill
; GFX8-ARCH-FLAT-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8-ARCH-FLAT-NEXT:    s_add_i32 s32, s32, 16
; GFX8-ARCH-FLAT-NEXT:    s_getpc_b64 s[0:1]
; GFX8-ARCH-FLAT-NEXT:    s_add_u32 s0, s0, with_private_to_flat_addrspacecast@gotpcrel32@lo+4
; GFX8-ARCH-FLAT-NEXT:    s_addc_u32 s1, s1, with_private_to_flat_addrspacecast@gotpcrel32@hi+12
; GFX8-ARCH-FLAT-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX8-ARCH-FLAT-NEXT:    v_writelane_b32 v3, s30, 0
; GFX8-ARCH-FLAT-NEXT:    v_writelane_b32 v3, s31, 1
; GFX8-ARCH-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-ARCH-FLAT-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX8-ARCH-FLAT-NEXT:    v_readlane_b32 s31, v3, 1
; GFX8-ARCH-FLAT-NEXT:    v_readlane_b32 s30, v3, 0
; GFX8-ARCH-FLAT-NEXT:    s_mov_b32 s32, s33
; GFX8-ARCH-FLAT-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX8-ARCH-FLAT-NEXT:    s_add_i32 s3, s33, 8
; GFX8-ARCH-FLAT-NEXT:    scratch_load_dword v3, off, s3 ; 4-byte Folded Reload
; GFX8-ARCH-FLAT-NEXT:    s_mov_b64 exec, s[0:1]
; GFX8-ARCH-FLAT-NEXT:    s_mov_b32 s33, s2
; GFX8-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0)
; GFX8-ARCH-FLAT-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: call_with_private_to_flat_addrspacecast:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s18, s33
; GFX9-NEXT:    s_mov_b32 s33, s32
; GFX9-NEXT:    s_xor_saveexec_b64 s[16:17], -1
; GFX9-NEXT:    buffer_store_dword v3, off, s[0:3], s33 ; 4-byte Folded Spill
; GFX9-NEXT:    s_mov_b64 exec, s[16:17]
; GFX9-NEXT:    s_addk_i32 s32, 0x400
; GFX9-NEXT:    s_getpc_b64 s[16:17]
; GFX9-NEXT:    s_add_u32 s16, s16, with_private_to_flat_addrspacecast@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s17, s17, with_private_to_flat_addrspacecast@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[16:17], 0x0
; GFX9-NEXT:    v_writelane_b32 v3, s30, 0
; GFX9-NEXT:    v_writelane_b32 v3, s31, 1
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    v_readlane_b32 s31, v3, 1
; GFX9-NEXT:    v_readlane_b32 s30, v3, 0
; GFX9-NEXT:    s_mov_b32 s32, s33
; GFX9-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; GFX9-NEXT:    buffer_load_dword v3, off, s[0:3], s33 ; 4-byte Folded Reload
; GFX9-NEXT:    s_mov_b64 exec, s[4:5]
; GFX9-NEXT:    s_mov_b32 s33, s18
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-ARCH-FLAT-LABEL: call_with_private_to_flat_addrspacecast:
; GFX9-ARCH-FLAT:       ; %bb.0:
; GFX9-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-ARCH-FLAT-NEXT:    s_mov_b32 s2, s33
; GFX9-ARCH-FLAT-NEXT:    s_mov_b32 s33, s32
; GFX9-ARCH-FLAT-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX9-ARCH-FLAT-NEXT:    scratch_store_dword off, v3, s33 ; 4-byte Folded Spill
; GFX9-ARCH-FLAT-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-ARCH-FLAT-NEXT:    s_add_i32 s32, s32, 16
; GFX9-ARCH-FLAT-NEXT:    s_getpc_b64 s[0:1]
; GFX9-ARCH-FLAT-NEXT:    s_add_u32 s0, s0, with_private_to_flat_addrspacecast@gotpcrel32@lo+4
; GFX9-ARCH-FLAT-NEXT:    s_addc_u32 s1, s1, with_private_to_flat_addrspacecast@gotpcrel32@hi+12
; GFX9-ARCH-FLAT-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX9-ARCH-FLAT-NEXT:    v_writelane_b32 v3, s30, 0
; GFX9-ARCH-FLAT-NEXT:    v_writelane_b32 v3, s31, 1
; GFX9-ARCH-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-ARCH-FLAT-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX9-ARCH-FLAT-NEXT:    v_readlane_b32 s31, v3, 1
; GFX9-ARCH-FLAT-NEXT:    v_readlane_b32 s30, v3, 0
; GFX9-ARCH-FLAT-NEXT:    s_mov_b32 s32, s33
; GFX9-ARCH-FLAT-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX9-ARCH-FLAT-NEXT:    scratch_load_dword v3, off, s33 ; 4-byte Folded Reload
; GFX9-ARCH-FLAT-NEXT:    s_mov_b64 exec, s[0:1]
; GFX9-ARCH-FLAT-NEXT:    s_mov_b32 s33, s2
; GFX9-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0)
; GFX9-ARCH-FLAT-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-ARCH-FLAT-LABEL: call_with_private_to_flat_addrspacecast:
; GFX942-ARCH-FLAT:       ; %bb.0:
; GFX942-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-ARCH-FLAT-NEXT:    s_mov_b32 s2, s33
; GFX942-ARCH-FLAT-NEXT:    s_mov_b32 s33, s32
; GFX942-ARCH-FLAT-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-ARCH-FLAT-NEXT:    scratch_store_dword off, v3, s33 ; 4-byte Folded Spill
; GFX942-ARCH-FLAT-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-ARCH-FLAT-NEXT:    s_add_i32 s32, s32, 16
; GFX942-ARCH-FLAT-NEXT:    s_getpc_b64 s[0:1]
; GFX942-ARCH-FLAT-NEXT:    s_add_u32 s0, s0, with_private_to_flat_addrspacecast@gotpcrel32@lo+4
; GFX942-ARCH-FLAT-NEXT:    s_addc_u32 s1, s1, with_private_to_flat_addrspacecast@gotpcrel32@hi+12
; GFX942-ARCH-FLAT-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x0
; GFX942-ARCH-FLAT-NEXT:    v_writelane_b32 v3, s30, 0
; GFX942-ARCH-FLAT-NEXT:    v_writelane_b32 v3, s31, 1
; GFX942-ARCH-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-ARCH-FLAT-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; GFX942-ARCH-FLAT-NEXT:    v_readlane_b32 s31, v3, 1
; GFX942-ARCH-FLAT-NEXT:    v_readlane_b32 s30, v3, 0
; GFX942-ARCH-FLAT-NEXT:    s_mov_b32 s32, s33
; GFX942-ARCH-FLAT-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; GFX942-ARCH-FLAT-NEXT:    scratch_load_dword v3, off, s33 ; 4-byte Folded Reload
; GFX942-ARCH-FLAT-NEXT:    s_mov_b64 exec, s[0:1]
; GFX942-ARCH-FLAT-NEXT:    s_mov_b32 s33, s2
; GFX942-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0)
; GFX942-ARCH-FLAT-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: call_with_private_to_flat_addrspacecast:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s18, s33
; GFX10-NEXT:    s_mov_b32 s33, s32
; GFX10-NEXT:    s_xor_saveexec_b32 s16, -1
; GFX10-NEXT:    buffer_store_dword v3, off, s[0:3], s33 ; 4-byte Folded Spill
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_mov_b32 exec_lo, s16
; GFX10-NEXT:    s_addk_i32 s32, 0x200
; GFX10-NEXT:    s_getpc_b64 s[16:17]
; GFX10-NEXT:    s_add_u32 s16, s16, with_private_to_flat_addrspacecast@gotpcrel32@lo+4
; GFX10-NEXT:    s_addc_u32 s17, s17, with_private_to_flat_addrspacecast@gotpcrel32@hi+12
; GFX10-NEXT:    v_writelane_b32 v3, s30, 0
; GFX10-NEXT:    s_load_dwordx2 s[16:17], s[16:17], 0x0
; GFX10-NEXT:    v_writelane_b32 v3, s31, 1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX10-NEXT:    v_readlane_b32 s31, v3, 1
; GFX10-NEXT:    v_readlane_b32 s30, v3, 0
; GFX10-NEXT:    s_mov_b32 s32, s33
; GFX10-NEXT:    s_xor_saveexec_b32 s4, -1
; GFX10-NEXT:    buffer_load_dword v3, off, s[0:3], s33 ; 4-byte Folded Reload
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_mov_b32 exec_lo, s4
; GFX10-NEXT:    s_mov_b32 s33, s18
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  call void @with_private_to_flat_addrspacecast(ptr addrspace(5) %ptr)
  ret void
}

define amdgpu_kernel void @call_with_private_to_flat_addrspacecast_cc_kernel(ptr addrspace(5) %ptr) #0 {
; GFX8-LABEL: call_with_private_to_flat_addrspacecast_cc_kernel:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_add_u32 s0, s0, s15
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    s_load_dword s15, s[8:9], 0x0
; GFX8-NEXT:    s_add_u32 s8, s8, 8
; GFX8-NEXT:    s_addc_u32 s9, s9, 0
; GFX8-NEXT:    s_getpc_b64 s[16:17]
; GFX8-NEXT:    s_add_u32 s16, s16, with_private_to_flat_addrspacecast@gotpcrel32@lo+4
; GFX8-NEXT:    s_addc_u32 s17, s17, with_private_to_flat_addrspacecast@gotpcrel32@hi+12
; GFX8-NEXT:    s_load_dwordx2 s[16:17], s[16:17], 0x0
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s15
; GFX8-NEXT:    s_mov_b32 s32, 0
; GFX8-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX8-NEXT:    s_endpgm
;
; GFX8-ARCH-FLAT-LABEL: call_with_private_to_flat_addrspacecast_cc_kernel:
; GFX8-ARCH-FLAT:       ; %bb.0:
; GFX8-ARCH-FLAT-NEXT:    s_mov_b32 s12, s8
; GFX8-ARCH-FLAT-NEXT:    s_add_u32 s8, s4, 8
; GFX8-ARCH-FLAT-NEXT:    s_mov_b32 s13, s9
; GFX8-ARCH-FLAT-NEXT:    s_addc_u32 s9, s5, 0
; GFX8-ARCH-FLAT-NEXT:    s_load_dword s15, s[4:5], 0x0
; GFX8-ARCH-FLAT-NEXT:    s_getpc_b64 s[4:5]
; GFX8-ARCH-FLAT-NEXT:    s_add_u32 s4, s4, with_private_to_flat_addrspacecast@gotpcrel32@lo+4
; GFX8-ARCH-FLAT-NEXT:    s_addc_u32 s5, s5, with_private_to_flat_addrspacecast@gotpcrel32@hi+12
; GFX8-ARCH-FLAT-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX8-ARCH-FLAT-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX8-ARCH-FLAT-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX8-ARCH-FLAT-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-ARCH-FLAT-NEXT:    s_mov_b32 s14, s10
; GFX8-ARCH-FLAT-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX8-ARCH-FLAT-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX8-ARCH-FLAT-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX8-ARCH-FLAT-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX8-ARCH-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-ARCH-FLAT-NEXT:    v_mov_b32_e32 v0, s15
; GFX8-ARCH-FLAT-NEXT:    s_mov_b32 s32, 0
; GFX8-ARCH-FLAT-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX8-ARCH-FLAT-NEXT:    s_endpgm
;
; GFX9-LABEL: call_with_private_to_flat_addrspacecast_cc_kernel:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_add_u32 s0, s0, s15
; GFX9-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-NEXT:    s_load_dword s15, s[8:9], 0x0
; GFX9-NEXT:    s_add_u32 s8, s8, 8
; GFX9-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-NEXT:    s_getpc_b64 s[16:17]
; GFX9-NEXT:    s_add_u32 s16, s16, with_private_to_flat_addrspacecast@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s17, s17, with_private_to_flat_addrspacecast@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[16:17], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s15
; GFX9-NEXT:    s_mov_b32 s32, 0
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    s_endpgm
;
; GFX9-ARCH-FLAT-LABEL: call_with_private_to_flat_addrspacecast_cc_kernel:
; GFX9-ARCH-FLAT:       ; %bb.0:
; GFX9-ARCH-FLAT-NEXT:    s_mov_b32 s12, s8
; GFX9-ARCH-FLAT-NEXT:    s_add_u32 s8, s4, 8
; GFX9-ARCH-FLAT-NEXT:    s_mov_b32 s13, s9
; GFX9-ARCH-FLAT-NEXT:    s_addc_u32 s9, s5, 0
; GFX9-ARCH-FLAT-NEXT:    s_load_dword s15, s[4:5], 0x0
; GFX9-ARCH-FLAT-NEXT:    s_getpc_b64 s[4:5]
; GFX9-ARCH-FLAT-NEXT:    s_add_u32 s4, s4, with_private_to_flat_addrspacecast@gotpcrel32@lo+4
; GFX9-ARCH-FLAT-NEXT:    s_addc_u32 s5, s5, with_private_to_flat_addrspacecast@gotpcrel32@hi+12
; GFX9-ARCH-FLAT-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-ARCH-FLAT-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-ARCH-FLAT-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-ARCH-FLAT-NEXT:    s_mov_b32 s14, s10
; GFX9-ARCH-FLAT-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-ARCH-FLAT-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-ARCH-FLAT-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-ARCH-FLAT-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-ARCH-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-ARCH-FLAT-NEXT:    v_mov_b32_e32 v0, s15
; GFX9-ARCH-FLAT-NEXT:    s_mov_b32 s32, 0
; GFX9-ARCH-FLAT-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-ARCH-FLAT-NEXT:    s_endpgm
;
; GFX942-ARCH-FLAT-LABEL: call_with_private_to_flat_addrspacecast_cc_kernel:
; GFX942-ARCH-FLAT:       ; %bb.0:
; GFX942-ARCH-FLAT-NEXT:    s_mov_b32 s12, s8
; GFX942-ARCH-FLAT-NEXT:    s_add_u32 s8, s4, 8
; GFX942-ARCH-FLAT-NEXT:    s_mov_b32 s13, s9
; GFX942-ARCH-FLAT-NEXT:    s_addc_u32 s9, s5, 0
; GFX942-ARCH-FLAT-NEXT:    s_load_dword s15, s[4:5], 0x0
; GFX942-ARCH-FLAT-NEXT:    s_getpc_b64 s[4:5]
; GFX942-ARCH-FLAT-NEXT:    s_add_u32 s4, s4, with_private_to_flat_addrspacecast@gotpcrel32@lo+4
; GFX942-ARCH-FLAT-NEXT:    s_addc_u32 s5, s5, with_private_to_flat_addrspacecast@gotpcrel32@hi+12
; GFX942-ARCH-FLAT-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX942-ARCH-FLAT-NEXT:    s_mov_b32 s14, s10
; GFX942-ARCH-FLAT-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX942-ARCH-FLAT-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX942-ARCH-FLAT-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX942-ARCH-FLAT-NEXT:    v_mov_b32_e32 v31, v0
; GFX942-ARCH-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-ARCH-FLAT-NEXT:    v_mov_b32_e32 v0, s15
; GFX942-ARCH-FLAT-NEXT:    s_mov_b32 s32, 0
; GFX942-ARCH-FLAT-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX942-ARCH-FLAT-NEXT:    s_endpgm
;
; GFX10-LABEL: call_with_private_to_flat_addrspacecast_cc_kernel:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_add_u32 s0, s0, s15
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    s_load_dword s15, s[8:9], 0x0
; GFX10-NEXT:    s_add_u32 s8, s8, 8
; GFX10-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-NEXT:    s_getpc_b64 s[16:17]
; GFX10-NEXT:    s_add_u32 s16, s16, with_private_to_flat_addrspacecast@gotpcrel32@lo+4
; GFX10-NEXT:    s_addc_u32 s17, s17, with_private_to_flat_addrspacecast@gotpcrel32@hi+12
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX10-NEXT:    s_load_dwordx2 s[16:17], s[16:17], 0x0
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX10-NEXT:    s_mov_b32 s32, 0
; GFX10-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s15
; GFX10-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX10-NEXT:    s_endpgm
  call void @with_private_to_flat_addrspacecast(ptr addrspace(5) %ptr)
  ret void
}

;; tests of addrspacecast in a constant

define amdgpu_kernel void @private_constant_expression_use(ptr addrspace(1) nocapture %out) #0 {
; GFX8-LABEL: private_constant_expression_use:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s2, s[8:9], 0xc8
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX8-NEXT:    v_mov_b32_e32 v0, 0x7b
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX8-ARCH-FLAT-LABEL: private_constant_expression_use:
; GFX8-ARCH-FLAT:       ; %bb.0:
; GFX8-ARCH-FLAT-NEXT:    s_load_dword s2, s[4:5], 0xc8
; GFX8-ARCH-FLAT-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX8-ARCH-FLAT-NEXT:    v_mov_b32_e32 v0, 0x7b
; GFX8-ARCH-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-ARCH-FLAT-NEXT:    v_mov_b32_e32 v1, s2
; GFX8-ARCH-FLAT-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-ARCH-FLAT-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-ARCH-FLAT-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0)
; GFX8-ARCH-FLAT-NEXT:    s_endpgm
;
; GFX9-LABEL: private_constant_expression_use:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX9-NEXT:    s_mov_b64 s[2:3], src_private_base
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x7b
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX9-ARCH-FLAT-LABEL: private_constant_expression_use:
; GFX9-ARCH-FLAT:       ; %bb.0:
; GFX9-ARCH-FLAT-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX9-ARCH-FLAT-NEXT:    s_mov_b64 s[2:3], src_private_base
; GFX9-ARCH-FLAT-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-ARCH-FLAT-NEXT:    v_mov_b32_e32 v0, 0x7b
; GFX9-ARCH-FLAT-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-ARCH-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-ARCH-FLAT-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0)
; GFX9-ARCH-FLAT-NEXT:    s_endpgm
;
; GFX942-ARCH-FLAT-LABEL: private_constant_expression_use:
; GFX942-ARCH-FLAT:       ; %bb.0:
; GFX942-ARCH-FLAT-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX942-ARCH-FLAT-NEXT:    s_mov_b64 s[2:3], src_private_base
; GFX942-ARCH-FLAT-NEXT:    v_mov_b32_e32 v2, 0
; GFX942-ARCH-FLAT-NEXT:    v_mov_b32_e32 v0, 0x7b
; GFX942-ARCH-FLAT-NEXT:    v_mov_b32_e32 v1, s3
; GFX942-ARCH-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-ARCH-FLAT-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] sc0 sc1
; GFX942-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0)
; GFX942-ARCH-FLAT-NEXT:    s_endpgm
;
; GFX10-LABEL: private_constant_expression_use:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[8:9], 0x0
; GFX10-NEXT:    s_mov_b64 s[2:3], src_private_base
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_mov_b32_e32 v0, 0x7b
; GFX10-NEXT:    v_mov_b32_e32 v1, s3
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_endpgm
  store volatile ptr addrspacecast (ptr addrspace(5) inttoptr (i32 123 to ptr addrspace(5)) to ptr), ptr addrspace(1) %out, align 8
  ret void
}

;; tests of intrinsics

define amdgpu_kernel void @calls_intrin_ascast_cc_kernel(ptr addrspace(3) %ptr) #0 {
; GFX8-LABEL: calls_intrin_ascast_cc_kernel:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s0, s[8:9], 0x0
; GFX8-NEXT:    s_load_dword s1, s[8:9], 0xcc
; GFX8-NEXT:    v_mov_b32_e32 v2, 7
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    s_endpgm
;
; GFX8-ARCH-FLAT-LABEL: calls_intrin_ascast_cc_kernel:
; GFX8-ARCH-FLAT:       ; %bb.0:
; GFX8-ARCH-FLAT-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX8-ARCH-FLAT-NEXT:    s_load_dword s1, s[4:5], 0xcc
; GFX8-ARCH-FLAT-NEXT:    v_mov_b32_e32 v2, 7
; GFX8-ARCH-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-ARCH-FLAT-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-ARCH-FLAT-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-ARCH-FLAT-NEXT:    flat_store_dword v[0:1], v2
; GFX8-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0)
; GFX8-ARCH-FLAT-NEXT:    s_endpgm
;
; GFX9-LABEL: calls_intrin_ascast_cc_kernel:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[8:9], 0x0
; GFX9-NEXT:    s_mov_b64 s[0:1], src_shared_base
; GFX9-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-NEXT:    v_mov_b32_e32 v2, 7
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    flat_store_dword v[0:1], v2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX9-ARCH-FLAT-LABEL: calls_intrin_ascast_cc_kernel:
; GFX9-ARCH-FLAT:       ; %bb.0:
; GFX9-ARCH-FLAT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX9-ARCH-FLAT-NEXT:    s_mov_b64 s[0:1], src_shared_base
; GFX9-ARCH-FLAT-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-ARCH-FLAT-NEXT:    v_mov_b32_e32 v2, 7
; GFX9-ARCH-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-ARCH-FLAT-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-ARCH-FLAT-NEXT:    flat_store_dword v[0:1], v2
; GFX9-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0)
; GFX9-ARCH-FLAT-NEXT:    s_endpgm
;
; GFX942-ARCH-FLAT-LABEL: calls_intrin_ascast_cc_kernel:
; GFX942-ARCH-FLAT:       ; %bb.0:
; GFX942-ARCH-FLAT-NEXT:    s_load_dword s2, s[4:5], 0x0
; GFX942-ARCH-FLAT-NEXT:    s_mov_b64 s[0:1], src_shared_base
; GFX942-ARCH-FLAT-NEXT:    v_mov_b32_e32 v1, s1
; GFX942-ARCH-FLAT-NEXT:    v_mov_b32_e32 v2, 7
; GFX942-ARCH-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-ARCH-FLAT-NEXT:    v_mov_b32_e32 v0, s2
; GFX942-ARCH-FLAT-NEXT:    flat_store_dword v[0:1], v2 sc0 sc1
; GFX942-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0)
; GFX942-ARCH-FLAT-NEXT:    s_endpgm
;
; GFX10-LABEL: calls_intrin_ascast_cc_kernel:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_load_dword s2, s[8:9], 0x0
; GFX10-NEXT:    s_mov_b64 s[0:1], src_shared_base
; GFX10-NEXT:    v_mov_b32_e32 v2, 7
; GFX10-NEXT:    v_mov_b32_e32 v1, s1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GFX10-NEXT:    flat_store_dword v[0:1], v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_endpgm
  %1 = call ptr @llvm.amdgcn.addrspacecast.nonnull.p0.p3(ptr addrspace(3) %ptr)
  store volatile i32 7, ptr %1, align 4
  ret void
}

define void @calls_intrin_ascast(ptr addrspace(3) %ptr) #0 {
; GFX8-LABEL: calls_intrin_ascast:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_mov_b64 s[4:5], 0xc4
; GFX8-NEXT:    s_load_dword s4, s[4:5], 0x0
; GFX8-NEXT:    v_mov_b32_e32 v2, 7
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v1, s4
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-ARCH-FLAT-LABEL: calls_intrin_ascast:
; GFX8-ARCH-FLAT:       ; %bb.0:
; GFX8-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-ARCH-FLAT-NEXT:    s_mov_b64 s[0:1], 0xc4
; GFX8-ARCH-FLAT-NEXT:    s_load_dword s0, s[0:1], 0x0
; GFX8-ARCH-FLAT-NEXT:    v_mov_b32_e32 v2, 7
; GFX8-ARCH-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-ARCH-FLAT-NEXT:    v_mov_b32_e32 v1, s0
; GFX8-ARCH-FLAT-NEXT:    flat_store_dword v[0:1], v2
; GFX8-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX8-ARCH-FLAT-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: calls_intrin_ascast:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, 7
; GFX9-NEXT:    flat_store_dword v[0:1], v2
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-ARCH-FLAT-LABEL: calls_intrin_ascast:
; GFX9-ARCH-FLAT:       ; %bb.0:
; GFX9-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-ARCH-FLAT-NEXT:    s_mov_b64 s[0:1], src_shared_base
; GFX9-ARCH-FLAT-NEXT:    v_mov_b32_e32 v1, s1
; GFX9-ARCH-FLAT-NEXT:    v_mov_b32_e32 v2, 7
; GFX9-ARCH-FLAT-NEXT:    flat_store_dword v[0:1], v2
; GFX9-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-ARCH-FLAT-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-ARCH-FLAT-LABEL: calls_intrin_ascast:
; GFX942-ARCH-FLAT:       ; %bb.0:
; GFX942-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-ARCH-FLAT-NEXT:    s_mov_b64 s[0:1], src_shared_base
; GFX942-ARCH-FLAT-NEXT:    v_mov_b32_e32 v1, s1
; GFX942-ARCH-FLAT-NEXT:    v_mov_b32_e32 v2, 7
; GFX942-ARCH-FLAT-NEXT:    flat_store_dword v[0:1], v2 sc0 sc1
; GFX942-ARCH-FLAT-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX942-ARCH-FLAT-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: calls_intrin_ascast:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_mov_b64 s[4:5], src_shared_base
; GFX10-NEXT:    v_mov_b32_e32 v2, 7
; GFX10-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-NEXT:    flat_store_dword v[0:1], v2
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
  %1 = call ptr @llvm.amdgcn.addrspacecast.nonnull.p0.p3(ptr addrspace(3) %ptr)
  store volatile i32 7, ptr %1, align 4
  ret void
}

define amdgpu_kernel void @call_calls_intrin_ascast_cc_kernel(ptr addrspace(3) %ptr) #0 {
; GFX8-LABEL: call_calls_intrin_ascast_cc_kernel:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_add_u32 s0, s0, s15
; GFX8-NEXT:    s_addc_u32 s1, s1, 0
; GFX8-NEXT:    s_load_dword s15, s[8:9], 0x0
; GFX8-NEXT:    s_add_u32 s8, s8, 8
; GFX8-NEXT:    s_addc_u32 s9, s9, 0
; GFX8-NEXT:    s_getpc_b64 s[16:17]
; GFX8-NEXT:    s_add_u32 s16, s16, calls_intrin_ascast@gotpcrel32@lo+4
; GFX8-NEXT:    s_addc_u32 s17, s17, calls_intrin_ascast@gotpcrel32@hi+12
; GFX8-NEXT:    s_load_dwordx2 s[16:17], s[16:17], 0x0
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX8-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s15
; GFX8-NEXT:    s_mov_b32 s32, 0
; GFX8-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX8-NEXT:    s_endpgm
;
; GFX8-ARCH-FLAT-LABEL: call_calls_intrin_ascast_cc_kernel:
; GFX8-ARCH-FLAT:       ; %bb.0:
; GFX8-ARCH-FLAT-NEXT:    s_mov_b32 s12, s8
; GFX8-ARCH-FLAT-NEXT:    s_add_u32 s8, s4, 8
; GFX8-ARCH-FLAT-NEXT:    s_mov_b32 s13, s9
; GFX8-ARCH-FLAT-NEXT:    s_addc_u32 s9, s5, 0
; GFX8-ARCH-FLAT-NEXT:    s_load_dword s15, s[4:5], 0x0
; GFX8-ARCH-FLAT-NEXT:    s_getpc_b64 s[4:5]
; GFX8-ARCH-FLAT-NEXT:    s_add_u32 s4, s4, calls_intrin_ascast@gotpcrel32@lo+4
; GFX8-ARCH-FLAT-NEXT:    s_addc_u32 s5, s5, calls_intrin_ascast@gotpcrel32@hi+12
; GFX8-ARCH-FLAT-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX8-ARCH-FLAT-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX8-ARCH-FLAT-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX8-ARCH-FLAT-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX8-ARCH-FLAT-NEXT:    s_mov_b32 s14, s10
; GFX8-ARCH-FLAT-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX8-ARCH-FLAT-NEXT:    v_or_b32_e32 v31, v0, v2
; GFX8-ARCH-FLAT-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX8-ARCH-FLAT-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX8-ARCH-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-ARCH-FLAT-NEXT:    v_mov_b32_e32 v0, s15
; GFX8-ARCH-FLAT-NEXT:    s_mov_b32 s32, 0
; GFX8-ARCH-FLAT-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX8-ARCH-FLAT-NEXT:    s_endpgm
;
; GFX9-LABEL: call_calls_intrin_ascast_cc_kernel:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_add_u32 s0, s0, s15
; GFX9-NEXT:    s_addc_u32 s1, s1, 0
; GFX9-NEXT:    s_load_dword s15, s[8:9], 0x0
; GFX9-NEXT:    s_add_u32 s8, s8, 8
; GFX9-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-NEXT:    s_getpc_b64 s[16:17]
; GFX9-NEXT:    s_add_u32 s16, s16, calls_intrin_ascast@gotpcrel32@lo+4
; GFX9-NEXT:    s_addc_u32 s17, s17, calls_intrin_ascast@gotpcrel32@hi+12
; GFX9-NEXT:    s_load_dwordx2 s[16:17], s[16:17], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, s15
; GFX9-NEXT:    s_mov_b32 s32, 0
; GFX9-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-NEXT:    s_endpgm
;
; GFX9-ARCH-FLAT-LABEL: call_calls_intrin_ascast_cc_kernel:
; GFX9-ARCH-FLAT:       ; %bb.0:
; GFX9-ARCH-FLAT-NEXT:    s_mov_b32 s12, s8
; GFX9-ARCH-FLAT-NEXT:    s_add_u32 s8, s4, 8
; GFX9-ARCH-FLAT-NEXT:    s_mov_b32 s13, s9
; GFX9-ARCH-FLAT-NEXT:    s_addc_u32 s9, s5, 0
; GFX9-ARCH-FLAT-NEXT:    s_load_dword s15, s[4:5], 0x0
; GFX9-ARCH-FLAT-NEXT:    s_getpc_b64 s[4:5]
; GFX9-ARCH-FLAT-NEXT:    s_add_u32 s4, s4, calls_intrin_ascast@gotpcrel32@lo+4
; GFX9-ARCH-FLAT-NEXT:    s_addc_u32 s5, s5, calls_intrin_ascast@gotpcrel32@hi+12
; GFX9-ARCH-FLAT-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX9-ARCH-FLAT-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX9-ARCH-FLAT-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX9-ARCH-FLAT-NEXT:    s_mov_b32 s14, s10
; GFX9-ARCH-FLAT-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX9-ARCH-FLAT-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX9-ARCH-FLAT-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX9-ARCH-FLAT-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX9-ARCH-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-ARCH-FLAT-NEXT:    v_mov_b32_e32 v0, s15
; GFX9-ARCH-FLAT-NEXT:    s_mov_b32 s32, 0
; GFX9-ARCH-FLAT-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX9-ARCH-FLAT-NEXT:    s_endpgm
;
; GFX942-ARCH-FLAT-LABEL: call_calls_intrin_ascast_cc_kernel:
; GFX942-ARCH-FLAT:       ; %bb.0:
; GFX942-ARCH-FLAT-NEXT:    s_mov_b32 s12, s8
; GFX942-ARCH-FLAT-NEXT:    s_add_u32 s8, s4, 8
; GFX942-ARCH-FLAT-NEXT:    s_mov_b32 s13, s9
; GFX942-ARCH-FLAT-NEXT:    s_addc_u32 s9, s5, 0
; GFX942-ARCH-FLAT-NEXT:    s_load_dword s15, s[4:5], 0x0
; GFX942-ARCH-FLAT-NEXT:    s_getpc_b64 s[4:5]
; GFX942-ARCH-FLAT-NEXT:    s_add_u32 s4, s4, calls_intrin_ascast@gotpcrel32@lo+4
; GFX942-ARCH-FLAT-NEXT:    s_addc_u32 s5, s5, calls_intrin_ascast@gotpcrel32@hi+12
; GFX942-ARCH-FLAT-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x0
; GFX942-ARCH-FLAT-NEXT:    s_mov_b32 s14, s10
; GFX942-ARCH-FLAT-NEXT:    s_mov_b64 s[10:11], s[6:7]
; GFX942-ARCH-FLAT-NEXT:    s_mov_b64 s[4:5], s[0:1]
; GFX942-ARCH-FLAT-NEXT:    s_mov_b64 s[6:7], s[2:3]
; GFX942-ARCH-FLAT-NEXT:    v_mov_b32_e32 v31, v0
; GFX942-ARCH-FLAT-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-ARCH-FLAT-NEXT:    v_mov_b32_e32 v0, s15
; GFX942-ARCH-FLAT-NEXT:    s_mov_b32 s32, 0
; GFX942-ARCH-FLAT-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX942-ARCH-FLAT-NEXT:    s_endpgm
;
; GFX10-LABEL: call_calls_intrin_ascast_cc_kernel:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_add_u32 s0, s0, s15
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    s_load_dword s15, s[8:9], 0x0
; GFX10-NEXT:    s_add_u32 s8, s8, 8
; GFX10-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-NEXT:    s_getpc_b64 s[16:17]
; GFX10-NEXT:    s_add_u32 s16, s16, calls_intrin_ascast@gotpcrel32@lo+4
; GFX10-NEXT:    s_addc_u32 s17, s17, calls_intrin_ascast@gotpcrel32@hi+12
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 20, v2
; GFX10-NEXT:    s_load_dwordx2 s[16:17], s[16:17], 0x0
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 10, v1
; GFX10-NEXT:    s_mov_b32 s32, 0
; GFX10-NEXT:    v_or3_b32 v31, v0, v1, v2
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, s15
; GFX10-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; GFX10-NEXT:    s_endpgm
  call void @calls_intrin_ascast(ptr addrspace(3) %ptr)
  ret void
}

attributes #0 = { "amdgpu-no-flat-scratch-init" }
