; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve < %s | FileCheck %s


target triple = "aarch64-unknown-linux-gnu"

;
; Masked Store
;

define void @masked_store_v16i8(ptr %dst, <16 x i1> %mask) {
; CHECK-LABEL: masked_store_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    shl v0.16b, v0.16b, #7
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    cmlt v0.16b, v0.16b, #0
; CHECK-NEXT:    cmpne p0.b, p0/z, z0.b, #0
; CHECK-NEXT:    movi v0.2d, #0000000000000000
; CHECK-NEXT:    st1b { z0.b }, p0, [x0]
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v16i8(<16 x i8> zeroinitializer, ptr %dst, i32 8, <16 x i1> %mask)
  ret void
}

define void @masked_store_v8f16(ptr %dst, <8 x i1> %mask) {
; CHECK-LABEL: masked_store_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll v0.8h, v0.8b, #0
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    shl v0.8h, v0.8h, #15
; CHECK-NEXT:    cmlt v0.8h, v0.8h, #0
; CHECK-NEXT:    cmpne p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    movi v0.2d, #0000000000000000
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v8f16(<8 x half> zeroinitializer, ptr %dst, i32 8, <8 x i1> %mask)
  ret void
}

define void @masked_store_v4f32(ptr %dst, <4 x i1> %mask) {
; CHECK-LABEL: masked_store_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    shl v0.4s, v0.4s, #31
; CHECK-NEXT:    cmlt v0.4s, v0.4s, #0
; CHECK-NEXT:    cmpne p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    movi v0.2d, #0000000000000000
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v4f32(<4 x float> zeroinitializer, ptr %dst, i32 8, <4 x i1> %mask)
  ret void
}

define void @masked_store_v2f64(ptr %dst, <2 x i1> %mask) {
; CHECK-LABEL: masked_store_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    shl v0.2d, v0.2d, #63
; CHECK-NEXT:    cmlt v0.2d, v0.2d, #0
; CHECK-NEXT:    cmpne p0.d, p0/z, z0.d, #0
; CHECK-NEXT:    movi v0.2d, #0000000000000000
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  call void @llvm.masked.store.v2f64(<2 x double> zeroinitializer, ptr %dst, i32 8, <2 x i1> %mask)
  ret void
}

declare void @llvm.masked.store.v16i8(<16 x i8>, ptr, i32, <16 x i1>)
declare void @llvm.masked.store.v8f16(<8 x half>, ptr, i32, <8 x i1>)
declare void @llvm.masked.store.v4f32(<4 x float>, ptr, i32, <4 x i1>)
declare void @llvm.masked.store.v2f64(<2 x double>, ptr, i32, <2 x i1>)
