; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=aarch64-linux | FileCheck %s

define i8 @andnot_add_with_neg_i8(i8 %a0, i8 %a1) {
; CHECK-LABEL: andnot_add_with_neg_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w0, w1
; CHECK-NEXT:    bic w0, w0, w8
; CHECK-NEXT:    ret
  %not = xor i8 %a0, -1
  %sum = add i8 %not, %a1
  %and = and i8 %sum, %a0
  ret i8 %and
}

define i8 @andnot_sub_with_neg_i8(i8 %a0, i8 %a1) {
; CHECK-LABEL: andnot_sub_with_neg_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add w8, w0, w1
; CHECK-NEXT:    bic w0, w0, w8
; CHECK-NEXT:    ret
  %not = xor i8 %a0, -1
  %diff = sub i8 %not, %a1
  %and = and i8 %diff, %a0
  ret i8 %and
}

define i16 @andnot_add_with_neg_i16(i16 %a0, i16 %a1) {
; CHECK-LABEL: andnot_add_with_neg_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w0, w1
; CHECK-NEXT:    bic w0, w0, w8
; CHECK-NEXT:    ret
  %not = xor i16 %a0, -1
  %sum = add i16 %not, %a1
  %and = and i16 %sum, %a0
  ret i16 %and
}

define i16 @andnot_sub_with_neg_i16(i16 %a0, i16 %a1) {
; CHECK-LABEL: andnot_sub_with_neg_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add w8, w0, w1
; CHECK-NEXT:    bic w0, w0, w8
; CHECK-NEXT:    ret
  %not = xor i16 %a0, -1
  %diff = sub i16 %not, %a1
  %and = and i16 %diff, %a0
  ret i16 %and
}

define i32 @andnot_add_with_neg_i32(i32 %a0, i32 %a1) {
; CHECK-LABEL: andnot_add_with_neg_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w0, w1
; CHECK-NEXT:    bic w0, w0, w8
; CHECK-NEXT:    ret
  %not = xor i32 %a0, -1
  %sum = add i32 %not, %a1
  %and = and i32 %sum, %a0
  ret i32 %and
}

define i32 @andnot_sub_with_neg_i32(i32 %a0, i32 %a1) {
; CHECK-LABEL: andnot_sub_with_neg_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add w8, w0, w1
; CHECK-NEXT:    bic w0, w0, w8
; CHECK-NEXT:    ret
  %not = xor i32 %a0, -1
  %diff = sub i32 %not, %a1
  %and = and i32 %diff, %a0
  ret i32 %and
}

define i64 @andnot_add_with_neg_i64(i64 %a0, i64 %a1) {
; CHECK-LABEL: andnot_add_with_neg_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub x8, x0, x1
; CHECK-NEXT:    bic x0, x0, x8
; CHECK-NEXT:    ret
  %not = xor i64 %a0, -1
  %sum = add i64 %not, %a1
  %and = and i64 %sum, %a0
  ret i64 %and
}

define i64 @andnot_sub_with_neg_i64(i64 %a0, i64 %a1) {
; CHECK-LABEL: andnot_sub_with_neg_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    add x8, x0, x1
; CHECK-NEXT:    bic x0, x0, x8
; CHECK-NEXT:    ret
  %not = xor i64 %a0, -1
  %diff = sub i64 %not, %a1
  %and = and i64 %diff, %a0
  ret i64 %and
}

define i32 @and_not_select_eq(i32 %a, i32 %b, i32 %c) {
; CHECK-LABEL: and_not_select_eq:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bics wzr, w1, w0
; CHECK-NEXT:    csel w0, w0, w2, eq
; CHECK-NEXT:    ret
  %or = or i32 %b, %a
  %cmp = icmp eq i32 %or, %a
  %a.c = select i1 %cmp, i32 %a, i32 %c
  ret i32 %a.c
}

define i32 @and_not_select_ne(i32 %a, i32 %b, i32 %c) {
; CHECK-LABEL: and_not_select_ne:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bics wzr, w1, w0
; CHECK-NEXT:    csel w0, w0, w2, ne
; CHECK-NEXT:    ret
  %or = or i32 %b, %a
  %cmp = icmp ne i32 %or, %a
  %a.c = select i1 %cmp, i32 %a, i32 %c
  ret i32 %a.c
}

define i32 @and_not_select_eq_swap(i32 %a, i32 %b, i32 %c) {
; CHECK-LABEL: and_not_select_eq_swap:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bics wzr, w1, w0
; CHECK-NEXT:    csel w0, w0, w2, eq
; CHECK-NEXT:    ret
  %or = or i32 %b, %a
  %cmp = icmp eq i32 %a, %or
  %a.c = select i1 %cmp, i32 %a, i32 %c
  ret i32 %a.c
}

define i32 @and_not_select_ne_swap(i32 %a, i32 %b, i32 %c) {
; CHECK-LABEL: and_not_select_ne_swap:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bics wzr, w1, w0
; CHECK-NEXT:    csel w0, w0, w2, ne
; CHECK-NEXT:    ret
  %or = or i32 %a, %b
  %cmp = icmp ne i32 %a, %or
  %a.c = select i1 %cmp, i32 %a, i32 %c
  ret i32 %a.c
}
