; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define i1 @PR1738(double %x, double %y) {
; CHECK-LABEL: @PR1738(
; CHECK-NEXT:    [[OR:%.*]] = fcmp uno double [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %cmp1 = fcmp uno double %x, 0.0
  %cmp2 = fcmp uno double %y, 0.0
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

; TODO: this can be fixed by freezing %y
define i1 @PR1738_logical(double %x, double %y) {
; CHECK-LABEL: @PR1738_logical(
; CHECK-NEXT:    [[CMP1:%.*]] = fcmp uno double [[X:%.*]], 0.000000e+00
; CHECK-NEXT:    [[CMP2:%.*]] = fcmp uno double [[Y:%.*]], 0.000000e+00
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[CMP1]], i1 true, i1 [[CMP2]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %cmp1 = fcmp uno double %x, 0.0
  %cmp2 = fcmp uno double %y, 0.0
  %or = select i1 %cmp1, i1 true, i1 %cmp2
  ret i1 %or
}

define <2 x i1> @PR1738_vec_undef(<2 x double> %x, <2 x double> %y) {
; CHECK-LABEL: @PR1738_vec_undef(
; CHECK-NEXT:    [[CMP1:%.*]] = fcmp uno <2 x double> [[X:%.*]], <double 0.000000e+00, double undef>
; CHECK-NEXT:    [[CMP2:%.*]] = fcmp uno <2 x double> [[Y:%.*]], <double undef, double 0.000000e+00>
; CHECK-NEXT:    [[OR:%.*]] = or <2 x i1> [[CMP1]], [[CMP2]]
; CHECK-NEXT:    ret <2 x i1> [[OR]]
;
  %cmp1 = fcmp uno <2 x double> %x, <double 0.0, double undef>
  %cmp2 = fcmp uno <2 x double> %y, <double undef, double 0.0>
  %or = or <2 x i1> %cmp1, %cmp2
  ret <2 x i1> %or
}

define <2 x i1> @PR1738_vec_poison(<2 x double> %x, <2 x double> %y) {
; CHECK-LABEL: @PR1738_vec_poison(
; CHECK-NEXT:    [[OR:%.*]] = fcmp uno <2 x double> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret <2 x i1> [[OR]]
;
  %cmp1 = fcmp uno <2 x double> %x, <double 0.0, double poison>
  %cmp2 = fcmp uno <2 x double> %y, <double poison, double 0.0>
  %or = or <2 x i1> %cmp1, %cmp2
  ret <2 x i1> %or
}

define i1 @PR41069(double %a, double %b, double %c, double %d) {
; CHECK-LABEL: @PR41069(
; CHECK-NEXT:    [[UNO1:%.*]] = fcmp uno double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = fcmp uno double [[D:%.*]], [[C:%.*]]
; CHECK-NEXT:    [[R:%.*]] = or i1 [[UNO1]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %uno1 = fcmp uno double %a, %b
  %uno2 = fcmp uno double %c, 0.0
  %or = or i1 %uno1, %uno2
  %uno3 = fcmp uno double %d, 0.0
  %r = or i1 %or, %uno3
  ret i1 %r
}

; TODO: this can be fixed by freezing %c and %d
define i1 @PR41069_logical(double %a, double %b, double %c, double %d) {
; CHECK-LABEL: @PR41069_logical(
; CHECK-NEXT:    [[UNO1:%.*]] = fcmp uno double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[UNO2:%.*]] = fcmp uno double [[C:%.*]], 0.000000e+00
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[UNO1]], i1 true, i1 [[UNO2]]
; CHECK-NEXT:    [[UNO3:%.*]] = fcmp uno double [[D:%.*]], 0.000000e+00
; CHECK-NEXT:    [[R:%.*]] = select i1 [[OR]], i1 true, i1 [[UNO3]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %uno1 = fcmp uno double %a, %b
  %uno2 = fcmp uno double %c, 0.0
  %or = select i1 %uno1, i1 true, i1 %uno2
  %uno3 = fcmp uno double %d, 0.0
  %r = select i1 %or, i1 true, i1 %uno3
  ret i1 %r
}

define i1 @PR41069_commute(double %a, double %b, double %c, double %d) {
; CHECK-LABEL: @PR41069_commute(
; CHECK-NEXT:    [[UNO1:%.*]] = fcmp uno double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = fcmp uno double [[D:%.*]], [[C:%.*]]
; CHECK-NEXT:    [[R:%.*]] = or i1 [[UNO1]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %uno1 = fcmp uno double %a, %b
  %uno2 = fcmp uno double %c, 0.0
  %or = or i1 %uno1, %uno2
  %uno3 = fcmp uno double %d, 0.0
  %r = or i1 %uno3, %or
  ret i1 %r
}

; TODO: this can be fixed by freezing %c and %d
define i1 @PR41069_commute_logical(double %a, double %b, double %c, double %d) {
; CHECK-LABEL: @PR41069_commute_logical(
; CHECK-NEXT:    [[UNO1:%.*]] = fcmp uno double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[UNO2:%.*]] = fcmp uno double [[C:%.*]], 0.000000e+00
; CHECK-NEXT:    [[UNO3:%.*]] = fcmp uno double [[D:%.*]], 0.000000e+00
; CHECK-NEXT:    [[TMP1:%.*]] = select i1 [[UNO3]], i1 true, i1 [[UNO1]]
; CHECK-NEXT:    [[R:%.*]] = select i1 [[TMP1]], i1 true, i1 [[UNO2]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %uno1 = fcmp uno double %a, %b
  %uno2 = fcmp uno double %c, 0.0
  %or = select i1 %uno1, i1 true, i1 %uno2
  %uno3 = fcmp uno double %d, 0.0
  %r = select i1 %uno3, i1 true, i1 %or
  ret i1 %r
}

define <2 x i1> @PR41069_vec(<2 x i1> %z, <2 x float> %c, <2 x float> %d) {
; CHECK-LABEL: @PR41069_vec(
; CHECK-NEXT:    [[UNO1:%.*]] = fcmp uno <2 x float> [[C:%.*]], zeroinitializer
; CHECK-NEXT:    [[OR:%.*]] = or <2 x i1> [[UNO1]], [[Z:%.*]]
; CHECK-NEXT:    [[UNO2:%.*]] = fcmp uno <2 x float> [[D:%.*]], <float 0.000000e+00, float undef>
; CHECK-NEXT:    [[R:%.*]] = or <2 x i1> [[OR]], [[UNO2]]
; CHECK-NEXT:    ret <2 x i1> [[R]]
;
  %uno1 = fcmp uno <2 x float> %c, zeroinitializer
  %or = or <2 x i1> %uno1, %z
  %uno2 = fcmp uno <2 x float> %d, <float 0.0, float undef>
  %r = or <2 x i1> %or, %uno2
  ret <2 x i1> %r
}

define <2 x i1> @PR41069_vec_poison(<2 x i1> %z, <2 x float> %c, <2 x float> %d) {
; CHECK-LABEL: @PR41069_vec_poison(
; CHECK-NEXT:    [[TMP1:%.*]] = fcmp uno <2 x float> [[D:%.*]], [[C:%.*]]
; CHECK-NEXT:    [[R:%.*]] = or <2 x i1> [[TMP1]], [[Z:%.*]]
; CHECK-NEXT:    ret <2 x i1> [[R]]
;
  %uno1 = fcmp uno <2 x float> %c, zeroinitializer
  %or = or <2 x i1> %uno1, %z
  %uno2 = fcmp uno <2 x float> %d, <float 0.0, float poison>
  %r = or <2 x i1> %or, %uno2
  ret <2 x i1> %r
}

define <2 x i1> @PR41069_vec_commute(<2 x i1> %z, <2 x float> %c, <2 x float> %d) {
; CHECK-LABEL: @PR41069_vec_commute(
; CHECK-NEXT:    [[UNO1:%.*]] = fcmp uno <2 x float> [[C:%.*]], zeroinitializer
; CHECK-NEXT:    [[OR:%.*]] = or <2 x i1> [[UNO1]], [[Z:%.*]]
; CHECK-NEXT:    [[UNO2:%.*]] = fcmp uno <2 x float> [[D:%.*]], <float 0.000000e+00, float undef>
; CHECK-NEXT:    [[R:%.*]] = or <2 x i1> [[UNO2]], [[OR]]
; CHECK-NEXT:    ret <2 x i1> [[R]]
;
  %uno1 = fcmp uno <2 x float> %c, zeroinitializer
  %or = or <2 x i1> %uno1, %z
  %uno2 = fcmp uno <2 x float> %d, <float 0.0, float undef>
  %r = or <2 x i1> %uno2, %or
  ret <2 x i1> %r
}

define <2 x i1> @PR41069_vec_commute_poison(<2 x i1> %z, <2 x float> %c, <2 x float> %d) {
; CHECK-LABEL: @PR41069_vec_commute_poison(
; CHECK-NEXT:    [[TMP1:%.*]] = fcmp uno <2 x float> [[D:%.*]], [[C:%.*]]
; CHECK-NEXT:    [[R:%.*]] = or <2 x i1> [[TMP1]], [[Z:%.*]]
; CHECK-NEXT:    ret <2 x i1> [[R]]
;
  %uno1 = fcmp uno <2 x float> %c, zeroinitializer
  %or = or <2 x i1> %uno1, %z
  %uno2 = fcmp uno <2 x float> %d, <float 0.0, float poison>
  %r = or <2 x i1> %uno2, %or
  ret <2 x i1> %r
}

define i1 @fcmp_uno_nonzero(float %x, float %y) {
; CHECK-LABEL: @fcmp_uno_nonzero(
; CHECK-NEXT:    [[OR:%.*]] = fcmp uno float [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %cmp1 = fcmp uno float %x, 1.0
  %cmp2 = fcmp uno float %y, 2.0
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

; TODO: this can be fixed by freezing %y
define i1 @fcmp_uno_nonzero_logical(float %x, float %y) {
; CHECK-LABEL: @fcmp_uno_nonzero_logical(
; CHECK-NEXT:    [[CMP1:%.*]] = fcmp uno float [[X:%.*]], 0.000000e+00
; CHECK-NEXT:    [[CMP2:%.*]] = fcmp uno float [[Y:%.*]], 0.000000e+00
; CHECK-NEXT:    [[OR:%.*]] = select i1 [[CMP1]], i1 true, i1 [[CMP2]]
; CHECK-NEXT:    ret i1 [[OR]]
;
  %cmp1 = fcmp uno float %x, 1.0
  %cmp2 = fcmp uno float %y, 2.0
  %or = select i1 %cmp1, i1 true, i1 %cmp2
  ret i1 %or
}

define <3 x i1> @fcmp_uno_nonzero_vec(<3 x float> %x, <3 x float> %y) {
; CHECK-LABEL: @fcmp_uno_nonzero_vec(
; CHECK-NEXT:    [[OR:%.*]] = fcmp uno <3 x float> [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret <3 x i1> [[OR]]
;
  %cmp1 = fcmp uno <3 x float> %x, <float 1.0, float 2.0, float 3.0>
  %cmp2 = fcmp uno <3 x float> %y, <float 3.0, float 2.0, float 1.0>
  %or = or <3 x i1> %cmp1, %cmp2
  ret <3 x i1> %or
}

define i1 @auto_gen_0(double %a, double %b) {
; CHECK-LABEL: @auto_gen_0(
; CHECK-NEXT:    ret i1 false
;
  %cmp = fcmp false double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_0_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_0_logical(
; CHECK-NEXT:    ret i1 false
;
  %cmp = fcmp false double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_0_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_0_logical_fmf(
; CHECK-NEXT:    ret i1 false
;
  %cmp = fcmp false double %a, %b
  %cmp1 = fcmp fast false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_1(double %a, double %b) {
; CHECK-LABEL: @auto_gen_1(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oeq double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp oeq double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_1_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_1_logical(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oeq double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp oeq double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_1_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_1_logical_fmf(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp fast oeq double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp fast oeq double %a, %b
  %cmp1 = fcmp fast false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_2(double %a, double %b) {
; CHECK-LABEL: @auto_gen_2(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp oeq double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp oeq double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_2_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_2_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp oeq double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp oeq double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_2_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_2_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp oeq double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp oeq double %a, %b
  %cmp1 = fcmp fast oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_3(double %a, double %b) {
; CHECK-LABEL: @auto_gen_3(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ogt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ogt double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_3_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_3_logical(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ogt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ogt double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_3_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_3_logical_fmf(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp fast ogt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp fast ogt double %a, %b
  %cmp1 = fcmp fast false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_4(double %a, double %b) {
; CHECK-LABEL: @auto_gen_4(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp oge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ogt double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_4_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_4_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp oge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ogt double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_4_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_4_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp oge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ogt double %a, %b
  %cmp1 = fcmp fast oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_5(double %a, double %b) {
; CHECK-LABEL: @auto_gen_5(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ogt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ogt double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_5_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_5_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ogt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ogt double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_5_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_5_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast ogt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast ogt double %a, %b
  %cmp1 = fcmp fast ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_6(double %a, double %b) {
; CHECK-LABEL: @auto_gen_6(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp oge double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_6_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_6_logical(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp oge double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_6_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_6_logical_fmf(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp oge double %a, %b
  %cmp1 = fcmp fast false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_7(double %a, double %b) {
; CHECK-LABEL: @auto_gen_7(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp oge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp oge double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_7_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_7_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp oge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp oge double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_7_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_7_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast oge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast oge double %a, %b
  %cmp1 = fcmp fast oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_8(double %a, double %b) {
; CHECK-LABEL: @auto_gen_8(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp oge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp oge double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_8_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_8_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp oge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp oge double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_8_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_8_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp oge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp oge double %a, %b
  %cmp1 = fcmp fast ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_9(double %a, double %b) {
; CHECK-LABEL: @auto_gen_9(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp oge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp oge double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_9_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_9_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp oge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp oge double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_9_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_9_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast oge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast oge double %a, %b
  %cmp1 = fcmp fast oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_10(double %a, double %b) {
; CHECK-LABEL: @auto_gen_10(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp olt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp olt double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_10_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_10_logical(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp olt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp olt double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_10_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_10_logical_fmf(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp olt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp olt double %a, %b
  %cmp1 = fcmp fast false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_11(double %a, double %b) {
; CHECK-LABEL: @auto_gen_11(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ole double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp olt double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_11_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_11_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ole double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp olt double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_11_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_11_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast ole double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast olt double %a, %b
  %cmp1 = fcmp fast oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_12(double %a, double %b) {
; CHECK-LABEL: @auto_gen_12(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp olt double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_12_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_12_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp olt double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_12_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_12_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp olt double %a, %b
  %cmp1 = fcmp fast ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_13(double %a, double %b) {
; CHECK-LABEL: @auto_gen_13(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp olt double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_13_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_13_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp olt double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_13_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_13_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast olt double %a, %b
  %cmp1 = fcmp fast oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_14(double %a, double %b) {
; CHECK-LABEL: @auto_gen_14(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp olt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp olt double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_14_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_14_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp olt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp olt double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_14_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_14_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp olt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp olt double %a, %b
  %cmp1 = fcmp fast olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_15(double %a, double %b) {
; CHECK-LABEL: @auto_gen_15(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ole double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ole double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_15_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_15_logical(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ole double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ole double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_15_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_15_logical_fmf(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp fast ole double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp fast ole double %a, %b
  %cmp1 = fcmp fast false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_16(double %a, double %b) {
; CHECK-LABEL: @auto_gen_16(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ole double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ole double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_16_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_16_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ole double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ole double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_16_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_16_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ole double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ole double %a, %b
  %cmp1 = fcmp fast oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_17(double %a, double %b) {
; CHECK-LABEL: @auto_gen_17(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ole double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_17_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_17_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ole double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_17_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_17_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast ole double %a, %b
  %cmp1 = fcmp fast ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_18(double %a, double %b) {
; CHECK-LABEL: @auto_gen_18(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ole double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_18_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_18_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ole double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_18_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_18_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ole double %a, %b
  %cmp1 = fcmp fast oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_19(double %a, double %b) {
; CHECK-LABEL: @auto_gen_19(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ole double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ole double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_19_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_19_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ole double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ole double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_19_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_19_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast ole double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast ole double %a, %b
  %cmp1 = fcmp fast olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_20(double %a, double %b) {
; CHECK-LABEL: @auto_gen_20(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ole double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ole double %a, %b
  %cmp1 = fcmp ole double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_20_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_20_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ole double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ole double %a, %b
  %cmp1 = fcmp ole double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_20_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_20_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ole double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ole double %a, %b
  %cmp1 = fcmp fast ole double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_21(double %a, double %b) {
; CHECK-LABEL: @auto_gen_21(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp one double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_21_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_21_logical(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp one double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_21_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_21_logical_fmf(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp fast one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp fast one double %a, %b
  %cmp1 = fcmp fast false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_22(double %a, double %b) {
; CHECK-LABEL: @auto_gen_22(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp one double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_22_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_22_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp one double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_22_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_22_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp one double %a, %b
  %cmp1 = fcmp fast oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_23(double %a, double %b) {
; CHECK-LABEL: @auto_gen_23(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp one double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_23_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_23_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp one double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_23_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_23_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast one double %a, %b
  %cmp1 = fcmp fast ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_24(double %a, double %b) {
; CHECK-LABEL: @auto_gen_24(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp one double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_24_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_24_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp one double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_24_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_24_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp one double %a, %b
  %cmp1 = fcmp fast oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_25(double %a, double %b) {
; CHECK-LABEL: @auto_gen_25(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp one double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_25_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_25_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp one double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_25_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_25_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast one double %a, %b
  %cmp1 = fcmp fast olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_26(double %a, double %b) {
; CHECK-LABEL: @auto_gen_26(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp one double %a, %b
  %cmp1 = fcmp ole double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_26_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_26_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp one double %a, %b
  %cmp1 = fcmp ole double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_26_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_26_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp one double %a, %b
  %cmp1 = fcmp fast ole double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_27(double %a, double %b) {
; CHECK-LABEL: @auto_gen_27(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp one double %a, %b
  %cmp1 = fcmp one double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_27_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_27_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp one double %a, %b
  %cmp1 = fcmp one double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_27_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_27_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast one double %a, %b
  %cmp1 = fcmp fast one double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_28(double %a, double %b) {
; CHECK-LABEL: @auto_gen_28(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ord double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_28_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_28_logical(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ord double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_28_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_28_logical_fmf(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ord double %a, %b
  %cmp1 = fcmp fast false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_29(double %a, double %b) {
; CHECK-LABEL: @auto_gen_29(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ord double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_29_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_29_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ord double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_29_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_29_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast ord double %a, %b
  %cmp1 = fcmp fast oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_30(double %a, double %b) {
; CHECK-LABEL: @auto_gen_30(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ord double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_30_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_30_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ord double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_30_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_30_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ord double %a, %b
  %cmp1 = fcmp fast ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_31(double %a, double %b) {
; CHECK-LABEL: @auto_gen_31(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ord double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_31_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_31_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ord double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_31_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_31_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast ord double %a, %b
  %cmp1 = fcmp fast oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_32(double %a, double %b) {
; CHECK-LABEL: @auto_gen_32(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ord double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_32_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_32_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ord double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_32_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_32_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ord double %a, %b
  %cmp1 = fcmp fast olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_33(double %a, double %b) {
; CHECK-LABEL: @auto_gen_33(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ord double %a, %b
  %cmp1 = fcmp ole double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_33_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_33_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ord double %a, %b
  %cmp1 = fcmp ole double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_33_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_33_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast ord double %a, %b
  %cmp1 = fcmp fast ole double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_34(double %a, double %b) {
; CHECK-LABEL: @auto_gen_34(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ord double %a, %b
  %cmp1 = fcmp one double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_34_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_34_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ord double %a, %b
  %cmp1 = fcmp one double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_34_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_34_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ord double %a, %b
  %cmp1 = fcmp fast one double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_35(double %a, double %b) {
; CHECK-LABEL: @auto_gen_35(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ord double %a, %b
  %cmp1 = fcmp ord double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_35_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_35_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ord double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ord double %a, %b
  %cmp1 = fcmp ord double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_35_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_35_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast ord double %a, %b
  %cmp1 = fcmp fast ord double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_36(double %a, double %b) {
; CHECK-LABEL: @auto_gen_36(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ueq double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_36_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_36_logical(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ueq double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_36_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_36_logical_fmf(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ueq double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp fast false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_37(double %a, double %b) {
; CHECK-LABEL: @auto_gen_37(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ueq double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_37_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_37_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ueq double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_37_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_37_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast ueq double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast ueq double %a, %b
  %cmp1 = fcmp fast oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_38(double %a, double %b) {
; CHECK-LABEL: @auto_gen_38(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_38_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_38_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_38_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_38_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp fast ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_39(double %a, double %b) {
; CHECK-LABEL: @auto_gen_39(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_39_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_39_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_39_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_39_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast ueq double %a, %b
  %cmp1 = fcmp fast oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_40(double %a, double %b) {
; CHECK-LABEL: @auto_gen_40(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_40_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_40_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_40_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_40_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp fast olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_41(double %a, double %b) {
; CHECK-LABEL: @auto_gen_41(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp ole double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_41_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_41_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp ole double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_41_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_41_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast ueq double %a, %b
  %cmp1 = fcmp fast ole double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_42(double %a, double %b) {
; CHECK-LABEL: @auto_gen_42(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp one double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_42_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_42_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp one double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_42_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_42_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp fast one double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_43(double %a, double %b) {
; CHECK-LABEL: @auto_gen_43(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp ord double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_43_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_43_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp ord double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_43_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_43_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast ueq double %a, %b
  %cmp1 = fcmp fast ord double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_44(double %a, double %b) {
; CHECK-LABEL: @auto_gen_44(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ueq double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp ueq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_44_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_44_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ueq double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp ueq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_44_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_44_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ueq double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ueq double %a, %b
  %cmp1 = fcmp fast ueq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_45(double %a, double %b) {
; CHECK-LABEL: @auto_gen_45(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ugt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_45_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_45_logical(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ugt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_45_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_45_logical_fmf(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp fast ugt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp fast ugt double %a, %b
  %cmp1 = fcmp fast false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_46(double %a, double %b) {
; CHECK-LABEL: @auto_gen_46(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_46_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_46_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_46_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_46_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp fast oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_47(double %a, double %b) {
; CHECK-LABEL: @auto_gen_47(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ugt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_47_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_47_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ugt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_47_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_47_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast ugt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast ugt double %a, %b
  %cmp1 = fcmp fast ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_48(double %a, double %b) {
; CHECK-LABEL: @auto_gen_48(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_48_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_48_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_48_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_48_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp fast oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_49(double %a, double %b) {
; CHECK-LABEL: @auto_gen_49(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_49_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_49_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_49_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_49_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast ugt double %a, %b
  %cmp1 = fcmp fast olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_50(double %a, double %b) {
; CHECK-LABEL: @auto_gen_50(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp ole double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_50_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_50_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp ole double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_50_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_50_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp fast ole double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_51(double %a, double %b) {
; CHECK-LABEL: @auto_gen_51(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp one double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_51_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_51_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp one double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_51_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_51_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast ugt double %a, %b
  %cmp1 = fcmp fast one double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_52(double %a, double %b) {
; CHECK-LABEL: @auto_gen_52(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp ord double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_52_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_52_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp ord double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_52_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_52_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp fast ord double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_53(double %a, double %b) {
; CHECK-LABEL: @auto_gen_53(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp ueq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_53_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_53_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp ueq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_53_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_53_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast ugt double %a, %b
  %cmp1 = fcmp fast ueq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_54(double %a, double %b) {
; CHECK-LABEL: @auto_gen_54(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ugt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp ugt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_54_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_54_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ugt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp ugt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_54_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_54_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ugt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ugt double %a, %b
  %cmp1 = fcmp fast ugt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_55(double %a, double %b) {
; CHECK-LABEL: @auto_gen_55(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_55_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_55_logical(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_55_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_55_logical_fmf(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp fast uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp fast uge double %a, %b
  %cmp1 = fcmp fast false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_56(double %a, double %b) {
; CHECK-LABEL: @auto_gen_56(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_56_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_56_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_56_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_56_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp fast oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_57(double %a, double %b) {
; CHECK-LABEL: @auto_gen_57(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_57_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_57_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_57_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_57_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast uge double %a, %b
  %cmp1 = fcmp fast ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_58(double %a, double %b) {
; CHECK-LABEL: @auto_gen_58(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_58_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_58_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_58_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_58_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp fast oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_59(double %a, double %b) {
; CHECK-LABEL: @auto_gen_59(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_59_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_59_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_59_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_59_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast uge double %a, %b
  %cmp1 = fcmp fast olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_60(double %a, double %b) {
; CHECK-LABEL: @auto_gen_60(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp ole double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_60_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_60_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp ole double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_60_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_60_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp fast ole double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_61(double %a, double %b) {
; CHECK-LABEL: @auto_gen_61(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp one double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_61_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_61_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp one double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_61_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_61_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast uge double %a, %b
  %cmp1 = fcmp fast one double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_62(double %a, double %b) {
; CHECK-LABEL: @auto_gen_62(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp ord double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_62_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_62_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp ord double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_62_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_62_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp fast ord double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_63(double %a, double %b) {
; CHECK-LABEL: @auto_gen_63(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp ueq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_63_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_63_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp ueq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_63_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_63_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast uge double %a, %b
  %cmp1 = fcmp fast ueq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_64(double %a, double %b) {
; CHECK-LABEL: @auto_gen_64(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp ugt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_64_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_64_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp ugt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_64_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_64_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp fast ugt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_65(double %a, double %b) {
; CHECK-LABEL: @auto_gen_65(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp uge double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_65_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_65_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uge double %a, %b
  %cmp1 = fcmp uge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_65_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_65_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast uge double %a, %b
  %cmp1 = fcmp fast uge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_66(double %a, double %b) {
; CHECK-LABEL: @auto_gen_66(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ult double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_66_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_66_logical(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ult double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_66_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_66_logical_fmf(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ult double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp fast false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_67(double %a, double %b) {
; CHECK-LABEL: @auto_gen_67(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_67_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_67_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_67_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_67_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast ult double %a, %b
  %cmp1 = fcmp fast oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_68(double %a, double %b) {
; CHECK-LABEL: @auto_gen_68(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_68_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_68_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_68_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_68_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp fast ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_69(double %a, double %b) {
; CHECK-LABEL: @auto_gen_69(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_69_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_69_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_69_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_69_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast ult double %a, %b
  %cmp1 = fcmp fast oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_70(double %a, double %b) {
; CHECK-LABEL: @auto_gen_70(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ult double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_70_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_70_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ult double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_70_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_70_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ult double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp fast olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_71(double %a, double %b) {
; CHECK-LABEL: @auto_gen_71(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp ole double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_71_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_71_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp ole double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_71_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_71_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast ult double %a, %b
  %cmp1 = fcmp fast ole double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_72(double %a, double %b) {
; CHECK-LABEL: @auto_gen_72(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp one double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_72_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_72_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp one double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_72_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_72_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp fast one double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_73(double %a, double %b) {
; CHECK-LABEL: @auto_gen_73(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp ord double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_73_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_73_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp ord double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_73_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_73_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast ult double %a, %b
  %cmp1 = fcmp fast ord double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_74(double %a, double %b) {
; CHECK-LABEL: @auto_gen_74(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp ueq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_74_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_74_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp ueq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_74_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_74_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp fast ueq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_75(double %a, double %b) {
; CHECK-LABEL: @auto_gen_75(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp ugt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_75_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_75_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp ugt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_75_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_75_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast ult double %a, %b
  %cmp1 = fcmp fast ugt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_76(double %a, double %b) {
; CHECK-LABEL: @auto_gen_76(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp uge double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_76_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_76_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp uge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_76_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_76_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp fast uge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_77(double %a, double %b) {
; CHECK-LABEL: @auto_gen_77(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ult double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp ult double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_77_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_77_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ult double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ult double %a, %b
  %cmp1 = fcmp ult double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_77_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_77_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast ult double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast ult double %a, %b
  %cmp1 = fcmp fast ult double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_78(double %a, double %b) {
; CHECK-LABEL: @auto_gen_78(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_78_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_78_logical(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_78_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_78_logical_fmf(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp fast false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_79(double %a, double %b) {
; CHECK-LABEL: @auto_gen_79(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_79_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_79_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_79_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_79_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast ule double %a, %b
  %cmp1 = fcmp fast oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_80(double %a, double %b) {
; CHECK-LABEL: @auto_gen_80(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_80_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_80_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_80_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_80_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp fast ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_81(double %a, double %b) {
; CHECK-LABEL: @auto_gen_81(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_81_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_81_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_81_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_81_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast ule double %a, %b
  %cmp1 = fcmp fast oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_82(double %a, double %b) {
; CHECK-LABEL: @auto_gen_82(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_82_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_82_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_82_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_82_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp fast olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_83(double %a, double %b) {
; CHECK-LABEL: @auto_gen_83(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp ole double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_83_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_83_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp ole double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_83_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_83_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast ule double %a, %b
  %cmp1 = fcmp fast ole double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_84(double %a, double %b) {
; CHECK-LABEL: @auto_gen_84(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp one double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_84_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_84_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp one double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_84_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_84_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp fast one double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_85(double %a, double %b) {
; CHECK-LABEL: @auto_gen_85(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp ord double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_85_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_85_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp ord double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_85_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_85_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast ule double %a, %b
  %cmp1 = fcmp fast ord double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_86(double %a, double %b) {
; CHECK-LABEL: @auto_gen_86(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp ueq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_86_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_86_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp ueq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_86_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_86_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp fast ueq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_87(double %a, double %b) {
; CHECK-LABEL: @auto_gen_87(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp ugt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_87_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_87_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp ugt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_87_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_87_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast ule double %a, %b
  %cmp1 = fcmp fast ugt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_88(double %a, double %b) {
; CHECK-LABEL: @auto_gen_88(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp uge double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_88_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_88_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp uge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_88_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_88_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp fast uge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_89(double %a, double %b) {
; CHECK-LABEL: @auto_gen_89(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp ult double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_89_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_89_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp ult double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_89_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_89_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast ule double %a, %b
  %cmp1 = fcmp fast ult double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_90(double %a, double %b) {
; CHECK-LABEL: @auto_gen_90(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp ule double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_90_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_90_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp ule double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_90_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_90_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ule double %a, %b
  %cmp1 = fcmp fast ule double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_91(double %a, double %b) {
; CHECK-LABEL: @auto_gen_91(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_91_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_91_logical(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_91_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_91_logical_fmf(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp fast une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp fast une double %a, %b
  %cmp1 = fcmp fast false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_92(double %a, double %b) {
; CHECK-LABEL: @auto_gen_92(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_92_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_92_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_92_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_92_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp fast oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_93(double %a, double %b) {
; CHECK-LABEL: @auto_gen_93(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_93_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_93_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_93_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_93_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast une double %a, %b
  %cmp1 = fcmp fast ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_94(double %a, double %b) {
; CHECK-LABEL: @auto_gen_94(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_94_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_94_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_94_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_94_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp fast oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_95(double %a, double %b) {
; CHECK-LABEL: @auto_gen_95(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_95_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_95_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_95_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_95_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast une double %a, %b
  %cmp1 = fcmp fast olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_96(double %a, double %b) {
; CHECK-LABEL: @auto_gen_96(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp ole double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_96_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_96_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp ole double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_96_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_96_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp fast ole double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_97(double %a, double %b) {
; CHECK-LABEL: @auto_gen_97(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp one double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_97_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_97_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp one double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_97_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_97_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast une double %a, %b
  %cmp1 = fcmp fast one double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_98(double %a, double %b) {
; CHECK-LABEL: @auto_gen_98(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp ord double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_98_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_98_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp ord double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_98_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_98_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp fast ord double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_99(double %a, double %b) {
; CHECK-LABEL: @auto_gen_99(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp ueq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_99_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_99_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp ueq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_99_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_99_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast une double %a, %b
  %cmp1 = fcmp fast ueq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_100(double %a, double %b) {
; CHECK-LABEL: @auto_gen_100(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp ugt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_100_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_100_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp ugt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_100_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_100_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp fast ugt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_101(double %a, double %b) {
; CHECK-LABEL: @auto_gen_101(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp uge double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_101_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_101_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp uge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_101_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_101_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast une double %a, %b
  %cmp1 = fcmp fast uge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_102(double %a, double %b) {
; CHECK-LABEL: @auto_gen_102(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp ult double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_102_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_102_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp ult double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_102_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_102_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp fast ult double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_103(double %a, double %b) {
; CHECK-LABEL: @auto_gen_103(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp ule double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_103_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_103_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp ule double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_103_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_103_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast une double %a, %b
  %cmp1 = fcmp fast ule double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_104(double %a, double %b) {
; CHECK-LABEL: @auto_gen_104(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp une double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_104_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_104_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp une double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_104_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_104_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp une double %a, %b
  %cmp1 = fcmp fast une double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_105(double %a, double %b) {
; CHECK-LABEL: @auto_gen_105(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp uno double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_105_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_105_logical(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp uno double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_105_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_105_logical_fmf(
; CHECK-NEXT:    ret i1 false
;
  %cmp = fcmp fast uno double %a, %b
  %cmp1 = fcmp fast false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_106(double %a, double %b) {
; CHECK-LABEL: @auto_gen_106(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ueq double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_106_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_106_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ueq double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_106_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_106_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ueq double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp fast oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_107(double %a, double %b) {
; CHECK-LABEL: @auto_gen_107(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ugt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_107_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_107_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ugt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_107_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_107_logical_fmf(
; CHECK-NEXT:    [[CMP1:%.*]] = fcmp fast ogt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP1]]
;
  %cmp = fcmp fast uno double %a, %b
  %cmp1 = fcmp fast ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_108(double %a, double %b) {
; CHECK-LABEL: @auto_gen_108(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_108_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_108_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_108_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_108_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp fast oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_109(double %a, double %b) {
; CHECK-LABEL: @auto_gen_109(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ult double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_109_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_109_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ult double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_109_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_109_logical_fmf(
; CHECK-NEXT:    [[CMP1:%.*]] = fcmp fast olt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP1]]
;
  %cmp = fcmp fast uno double %a, %b
  %cmp1 = fcmp fast olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_110(double %a, double %b) {
; CHECK-LABEL: @auto_gen_110(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp ole double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_110_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_110_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp ole double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_110_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_110_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp fast ole double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_111(double %a, double %b) {
; CHECK-LABEL: @auto_gen_111(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp one double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_111_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_111_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp one double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_111_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_111_logical_fmf(
; CHECK-NEXT:    [[CMP1:%.*]] = fcmp fast one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP1]]
;
  %cmp = fcmp fast uno double %a, %b
  %cmp1 = fcmp fast one double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_112(double %a, double %b) {
; CHECK-LABEL: @auto_gen_112(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp ord double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_112_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_112_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp ord double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_112_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_112_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp fast ord double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_113(double %a, double %b) {
; CHECK-LABEL: @auto_gen_113(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ueq double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp ueq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_113_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_113_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ueq double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp ueq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_113_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_113_logical_fmf(
; CHECK-NEXT:    [[CMP1:%.*]] = fcmp fast ueq double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP1]]
;
  %cmp = fcmp fast uno double %a, %b
  %cmp1 = fcmp fast ueq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_114(double %a, double %b) {
; CHECK-LABEL: @auto_gen_114(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ugt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp ugt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_114_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_114_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ugt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp ugt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_114_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_114_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ugt double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp fast ugt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_115(double %a, double %b) {
; CHECK-LABEL: @auto_gen_115(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp uge double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_115_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_115_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp uge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_115_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_115_logical_fmf(
; CHECK-NEXT:    [[CMP1:%.*]] = fcmp fast uge double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP1]]
;
  %cmp = fcmp fast uno double %a, %b
  %cmp1 = fcmp fast uge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_116(double %a, double %b) {
; CHECK-LABEL: @auto_gen_116(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ult double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp ult double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_116_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_116_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ult double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp ult double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_116_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_116_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ult double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp fast ult double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_117(double %a, double %b) {
; CHECK-LABEL: @auto_gen_117(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp ule double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_117_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_117_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp ule double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_117_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_117_logical_fmf(
; CHECK-NEXT:    [[CMP1:%.*]] = fcmp fast ule double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[CMP1]]
;
  %cmp = fcmp fast uno double %a, %b
  %cmp1 = fcmp fast ule double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_118(double %a, double %b) {
; CHECK-LABEL: @auto_gen_118(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp une double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_118_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_118_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp une double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_118_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_118_logical_fmf(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp une double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp fast une double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_119(double %a, double %b) {
; CHECK-LABEL: @auto_gen_119(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uno double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp uno double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_119_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_119_logical(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp uno double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp uno double %a, %b
  %cmp1 = fcmp uno double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_119_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_119_logical_fmf(
; CHECK-NEXT:    ret i1 false
;
  %cmp = fcmp fast uno double %a, %b
  %cmp1 = fcmp fast uno double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_120(double %a, double %b) {
; CHECK-LABEL: @auto_gen_120(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_120_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_120_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_120_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_120_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp fast false double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_121(double %a, double %b) {
; CHECK-LABEL: @auto_gen_121(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_121_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_121_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_121_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_121_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast true double %a, %b
  %cmp1 = fcmp fast oeq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_122(double %a, double %b) {
; CHECK-LABEL: @auto_gen_122(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_122_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_122_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_122_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_122_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp fast ogt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_123(double %a, double %b) {
; CHECK-LABEL: @auto_gen_123(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_123_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_123_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_123_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_123_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast true double %a, %b
  %cmp1 = fcmp fast oge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_124(double %a, double %b) {
; CHECK-LABEL: @auto_gen_124(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_124_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_124_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_124_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_124_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp fast olt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_125(double %a, double %b) {
; CHECK-LABEL: @auto_gen_125(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp ole double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_125_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_125_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp ole double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_125_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_125_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast true double %a, %b
  %cmp1 = fcmp fast ole double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_126(double %a, double %b) {
; CHECK-LABEL: @auto_gen_126(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp one double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_126_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_126_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp one double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_126_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_126_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp fast one double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_127(double %a, double %b) {
; CHECK-LABEL: @auto_gen_127(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp ord double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_127_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_127_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp ord double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_127_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_127_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast true double %a, %b
  %cmp1 = fcmp fast ord double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_128(double %a, double %b) {
; CHECK-LABEL: @auto_gen_128(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp ueq double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_128_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_128_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp ueq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_128_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_128_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp fast ueq double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_129(double %a, double %b) {
; CHECK-LABEL: @auto_gen_129(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp ugt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_129_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_129_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp ugt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_129_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_129_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast true double %a, %b
  %cmp1 = fcmp fast ugt double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_130(double %a, double %b) {
; CHECK-LABEL: @auto_gen_130(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp uge double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_130_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_130_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp uge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_130_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_130_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp fast uge double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_131(double %a, double %b) {
; CHECK-LABEL: @auto_gen_131(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp ult double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_131_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_131_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp ult double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_131_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_131_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast true double %a, %b
  %cmp1 = fcmp fast ult double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_132(double %a, double %b) {
; CHECK-LABEL: @auto_gen_132(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp ule double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_132_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_132_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp ule double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_132_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_132_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp fast ule double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_133(double %a, double %b) {
; CHECK-LABEL: @auto_gen_133(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp une double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_133_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_133_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp une double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_133_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_133_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast true double %a, %b
  %cmp1 = fcmp fast une double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_134(double %a, double %b) {
; CHECK-LABEL: @auto_gen_134(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp uno double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_134_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_134_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp uno double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_134_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_134_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp fast uno double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_135(double %a, double %b) {
; CHECK-LABEL: @auto_gen_135(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp true double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @auto_gen_135_logical(double %a, double %b) {
; CHECK-LABEL: @auto_gen_135_logical(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true double %a, %b
  %cmp1 = fcmp true double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @auto_gen_135_logical_fmf(double %a, double %b) {
; CHECK-LABEL: @auto_gen_135_logical_fmf(
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp fast true double %a, %b
  %cmp1 = fcmp fast true double %a, %b
  %retval = select i1 %cmp, i1 true, i1 %cmp1
  ret i1 %retval
}

define i1 @intersect_fmf_1(double %a, double %b) {
; CHECK-LABEL: @intersect_fmf_1(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp fast one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast olt double %a, %b
  %cmp1 = fcmp fast ogt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @intersect_fmf_2(double %a, double %b) {
; CHECK-LABEL: @intersect_fmf_2(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp fast olt double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @intersect_fmf_3(double %a, double %b) {
; CHECK-LABEL: @intersect_fmf_3(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp olt double %a, %b
  %cmp1 = fcmp fast ogt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @intersect_fmf_4(double %a, double %b) {
; CHECK-LABEL: @intersect_fmf_4(
; CHECK-NEXT:    [[RETVAL:%.*]] = fcmp one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp ninf olt double %a, %b
  %cmp1 = fcmp nnan ogt double %a, %b
  %retval = or i1 %cmp, %cmp1
  ret i1 %retval
}

define i1 @or_fcmp_reassoc1(i1 %x, double %a, double %b) {
; CHECK-LABEL: @or_fcmp_reassoc1(
; CHECK-NEXT:    [[OR:%.*]] = fcmp one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[RETVAL:%.*]] = or i1 [[OR]], [[CMP1:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp olt double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %or = or i1 %cmp, %x
  %retval = or i1 %or, %cmp1
  ret i1 %retval
}

define i1 @or_fcmp_reassoc2(i1 %x, double %a, double %b) {
; CHECK-LABEL: @or_fcmp_reassoc2(
; CHECK-NEXT:    [[TMP1:%.*]] = fcmp one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[RETVAL:%.*]] = or i1 [[X:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp olt double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %or = or i1 %x, %cmp
  %retval = or i1 %or, %cmp1
  ret i1 %retval
}

define i1 @or_fcmp_reassoc3(i1 %x, double %a, double %b) {
; CHECK-LABEL: @or_fcmp_reassoc3(
; CHECK-NEXT:    [[TMP1:%.*]] = fcmp one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[RETVAL:%.*]] = or i1 [[TMP1]], [[X:%.*]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp olt double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %or = or i1 %cmp, %x
  %retval = or i1 %cmp1, %or
  ret i1 %retval
}

define i1 @or_fcmp_reassoc4(i1 %x, double %a, double %b) {
; CHECK-LABEL: @or_fcmp_reassoc4(
; CHECK-NEXT:    [[TMP1:%.*]] = fcmp one double [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[RETVAL:%.*]] = or i1 [[X:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[RETVAL]]
;
  %cmp = fcmp olt double %a, %b
  %cmp1 = fcmp ogt double %a, %b
  %or = or i1 %x, %cmp
  %retval = or i1 %cmp1, %or
  ret i1 %retval
}
