; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_20 | FileCheck %s
; RUN: %if ptxas %{ llc < %s -mtriple=nvptx64 -mcpu=sm_20 | %ptxas-verify %}

target triple = "nvptx-nvidia-cuda"

define i32 @test_select_i1_trunc(i32 %a, i32 %b, i32 %c, i32 %true, i32 %false) {
; CHECK-LABEL: test_select_i1_trunc(
; CHECK:       {
; CHECK-NEXT:    .reg .pred %p<3>;
; CHECK-NEXT:    .reg .b32 %r<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_select_i1_trunc_param_0];
; CHECK-NEXT:    and.b32 %r2, %r1, 1;
; CHECK-NEXT:    setp.ne.b32 %p1, %r2, 0;
; CHECK-NEXT:    ld.param.b32 %r3, [test_select_i1_trunc_param_1];
; CHECK-NEXT:    ld.param.b32 %r4, [test_select_i1_trunc_param_2];
; CHECK-NEXT:    ld.param.b32 %r5, [test_select_i1_trunc_param_3];
; CHECK-NEXT:    selp.b32 %r6, %r3, %r4, %p1;
; CHECK-NEXT:    and.b32 %r7, %r6, 1;
; CHECK-NEXT:    setp.ne.b32 %p2, %r7, 0;
; CHECK-NEXT:    ld.param.b32 %r8, [test_select_i1_trunc_param_4];
; CHECK-NEXT:    selp.b32 %r9, %r5, %r8, %p2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r9;
; CHECK-NEXT:    ret;
  %a_trunc = trunc i32 %a to i1
  %b_trunc = trunc i32 %b to i1
  %c_trunc = trunc i32 %c to i1
  %select_i1 = select i1 %a_trunc, i1 %b_trunc, i1 %c_trunc
  %select_ret = select i1 %select_i1, i32 %true, i32 %false
  ret i32 %select_ret
}

define i32 @test_select_i1_trunc_2(i64 %a, i16 %b, i32 %c, i32 %true, i32 %false) {
; CHECK-LABEL: test_select_i1_trunc_2(
; CHECK:       {
; CHECK-NEXT:    .reg .pred %p<3>;
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [test_select_i1_trunc_2_param_0];
; CHECK-NEXT:    and.b64 %rd2, %rd1, 1;
; CHECK-NEXT:    setp.ne.b64 %p1, %rd2, 0;
; CHECK-NEXT:    ld.param.b16 %rs1, [test_select_i1_trunc_2_param_1];
; CHECK-NEXT:    ld.param.b16 %rs2, [test_select_i1_trunc_2_param_2];
; CHECK-NEXT:    ld.param.b32 %r1, [test_select_i1_trunc_2_param_3];
; CHECK-NEXT:    selp.b16 %rs3, %rs1, %rs2, %p1;
; CHECK-NEXT:    and.b16 %rs4, %rs3, 1;
; CHECK-NEXT:    setp.ne.b16 %p2, %rs4, 0;
; CHECK-NEXT:    ld.param.b32 %r2, [test_select_i1_trunc_2_param_4];
; CHECK-NEXT:    selp.b32 %r3, %r1, %r2, %p2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %a_trunc = trunc i64 %a to i1
  %b_trunc = trunc i16 %b to i1
  %c_trunc = trunc i32 %c to i1
  %select_i1 = select i1 %a_trunc, i1 %b_trunc, i1 %c_trunc
  %select_ret = select i1 %select_i1, i32 %true, i32 %false
  ret i32 %select_ret
}

define i32 @test_select_i1_basic(i32 %v1, i32 %v2, i32 %v3, i32 %true, i32 %false) {
; CHECK-LABEL: test_select_i1_basic(
; CHECK:       {
; CHECK-NEXT:    .reg .pred %p<4>;
; CHECK-NEXT:    .reg .b32 %r<12>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_select_i1_basic_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [test_select_i1_basic_param_1];
; CHECK-NEXT:    or.b32 %r4, %r1, %r2;
; CHECK-NEXT:    setp.ne.b32 %p1, %r1, 0;
; CHECK-NEXT:    ld.param.b32 %r5, [test_select_i1_basic_param_2];
; CHECK-NEXT:    setp.eq.b32 %p2, %r5, 0;
; CHECK-NEXT:    ld.param.b32 %r7, [test_select_i1_basic_param_3];
; CHECK-NEXT:    setp.eq.b32 %p3, %r4, 0;
; CHECK-NEXT:    ld.param.b32 %r8, [test_select_i1_basic_param_4];
; CHECK-NEXT:    selp.b32 %r9, %r7, %r8, %p2;
; CHECK-NEXT:    selp.b32 %r10, %r9, %r8, %p1;
; CHECK-NEXT:    selp.b32 %r11, %r7, %r10, %p3;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r11;
; CHECK-NEXT:    ret;
  %b1 = icmp eq i32 %v1, 0
  %b2 = icmp eq i32 %v2, 0
  %b3 = icmp eq i32 %v3, 0
  %select_i1 = select i1 %b1, i1 %b2, i1 %b3
  %select_ret = select i1 %select_i1, i32 %true, i32 %false
  ret i32 %select_ret
}

define i32 @test_select_i1_basic_folding(i32 %v1, i32 %v2, i32 %v3, i32 %true, i32 %false) {
; CHECK-LABEL: test_select_i1_basic_folding(
; CHECK:       {
; CHECK-NEXT:    .reg .pred %p<13>;
; CHECK-NEXT:    .reg .b32 %r<7>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_select_i1_basic_folding_param_0];
; CHECK-NEXT:    setp.eq.b32 %p1, %r1, 0;
; CHECK-NEXT:    ld.param.b32 %r2, [test_select_i1_basic_folding_param_1];
; CHECK-NEXT:    setp.ne.b32 %p2, %r2, 0;
; CHECK-NEXT:    setp.eq.b32 %p3, %r2, 0;
; CHECK-NEXT:    ld.param.b32 %r3, [test_select_i1_basic_folding_param_2];
; CHECK-NEXT:    setp.eq.b32 %p4, %r3, 0;
; CHECK-NEXT:    ld.param.b32 %r4, [test_select_i1_basic_folding_param_3];
; CHECK-NEXT:    xor.pred %p6, %p1, %p3;
; CHECK-NEXT:    ld.param.b32 %r5, [test_select_i1_basic_folding_param_4];
; CHECK-NEXT:    and.pred %p7, %p6, %p4;
; CHECK-NEXT:    and.pred %p9, %p2, %p4;
; CHECK-NEXT:    and.pred %p10, %p3, %p7;
; CHECK-NEXT:    or.pred %p11, %p10, %p9;
; CHECK-NEXT:    xor.pred %p12, %p11, %p3;
; CHECK-NEXT:    selp.b32 %r6, %r4, %r5, %p12;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r6;
; CHECK-NEXT:    ret;
  %b1 = icmp eq i32 %v1, 0
  %b2 = icmp eq i32 %v2, 0
  %b3 = icmp eq i32 %v3, 0
  %b4 = xor i1 %b1, %b2
  %b5 = and i1 %b4, %b3
  %select_i1 = select i1 %b2, i1 %b5, i1 %b3
  %b6 = xor i1 %select_i1, %b2
  %select_ret = select i1 %b6, i32 %true, i32 %false
  ret i32 %select_ret
}
