; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt -passes=bpf-aspace-simplify -mtriple=bpf-pc-linux -S < %s | FileCheck %s

; Check that bpf-aspace-simplify pass removes unnecessary (for BPF)
; address space casts for cast M->N -> GEP -> cast N->M chain,
; where chain is split between several BBs.

define dso_local ptr addrspace(1) @test (ptr addrspace(1) %p) {
; CHECK-LABEL: define dso_local ptr addrspace(1) @test(
; CHECK-SAME: ptr addrspace(1) [[P:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    [[B1:%.*]] = getelementptr inbounds i8, ptr addrspace(1) [[P]], i64 8
; CHECK-NEXT:    ret ptr addrspace(1) [[B1]]
;
entry:
  %a = addrspacecast ptr addrspace(1) %p to ptr
  %b = getelementptr inbounds i8, ptr %a, i64 8
  br label %exit

exit:
  %c = addrspacecast ptr %b to ptr addrspace(1)
  ret ptr addrspace(1) %c
}
