; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py UTC_ARGS: --version 2
; RUN: llc -global-isel=1 -global-isel-abort=2 -mtriple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32 -stop-after=finalize-isel -verify-machineinstrs < %s | FileCheck -check-prefix=GISEL-GFX11 %s
; RUN: llc -global-isel=1 -global-isel-abort=2 -mtriple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize64 -stop-after=finalize-isel -verify-machineinstrs < %s | FileCheck -check-prefix=GISEL-GFX11 %s
; RUN: llc -global-isel=1 -global-isel-abort=2 -mtriple=amdgcn -mcpu=gfx1030 -mattr=+wavefrontsize32 -stop-after=finalize-isel -verify-machineinstrs < %s | FileCheck -check-prefix=GISEL-GFX10 %s
; RUN: llc -global-isel=1 -global-isel-abort=2 -mtriple=amdgcn -mcpu=gfx1030 -mattr=+wavefrontsize64 -stop-after=finalize-isel -verify-machineinstrs < %s | FileCheck -check-prefix=GISEL-GFX10 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32 -stop-after=finalize-isel -verify-machineinstrs < %s | FileCheck -check-prefix=DAGISEL-GFX11 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize64 -stop-after=finalize-isel -verify-machineinstrs < %s | FileCheck -check-prefix=DAGISEL-GFX11 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1030 -mattr=+wavefrontsize32 -stop-after=finalize-isel -verify-machineinstrs < %s | FileCheck -check-prefix=DAGISEL-GFX10 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1030 -mattr=+wavefrontsize64 -stop-after=finalize-isel -verify-machineinstrs < %s | FileCheck -check-prefix=DAGISEL-GFX10 %s

; Test formal argument lowering as well as calls to amdgpu_gfx functions.

declare amdgpu_gfx void @use(...)

define amdgpu_cs_chain void @amdgpu_cs_chain_cc(<4 x i32> inreg %a, <4 x i32> %b) {
  ; GISEL-GFX11-LABEL: name: amdgpu_cs_chain_cc
  ; GISEL-GFX11: bb.1 (%ir-block.0):
  ; GISEL-GFX11-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $vgpr8, $vgpr9, $vgpr10, $vgpr11
  ; GISEL-GFX11-NEXT: {{  $}}
  ; GISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr1
  ; GISEL-GFX11-NEXT:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GISEL-GFX11-NEXT:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GISEL-GFX11-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX11-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; GISEL-GFX11-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; GISEL-GFX11-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; GISEL-GFX11-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX11-NEXT:   $vgpr0 = COPY [[COPY]]
  ; GISEL-GFX11-NEXT:   $vgpr1 = COPY [[COPY1]]
  ; GISEL-GFX11-NEXT:   $vgpr2 = COPY [[COPY2]]
  ; GISEL-GFX11-NEXT:   $vgpr3 = COPY [[COPY3]]
  ; GISEL-GFX11-NEXT:   $vgpr4 = COPY [[COPY4]]
  ; GISEL-GFX11-NEXT:   $vgpr5 = COPY [[COPY5]]
  ; GISEL-GFX11-NEXT:   $vgpr6 = COPY [[COPY6]]
  ; GISEL-GFX11-NEXT:   $vgpr7 = COPY [[COPY7]]
  ; GISEL-GFX11-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def $scc
  ; GISEL-GFX11-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (p0) from got, addrspace 4)
  ; GISEL-GFX11-NEXT:   $sgpr30_sgpr31 = noconvergent SI_CALL [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; GISEL-GFX11-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; GISEL-GFX10-LABEL: name: amdgpu_cs_chain_cc
  ; GISEL-GFX10: bb.1 (%ir-block.0):
  ; GISEL-GFX10-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $vgpr8, $vgpr9, $vgpr10, $vgpr11
  ; GISEL-GFX10-NEXT: {{  $}}
  ; GISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr1
  ; GISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GISEL-GFX10-NEXT:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GISEL-GFX10-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX10-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; GISEL-GFX10-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; GISEL-GFX10-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; GISEL-GFX10-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX10-NEXT:   $vgpr0 = COPY [[COPY]]
  ; GISEL-GFX10-NEXT:   $vgpr1 = COPY [[COPY1]]
  ; GISEL-GFX10-NEXT:   $vgpr2 = COPY [[COPY2]]
  ; GISEL-GFX10-NEXT:   $vgpr3 = COPY [[COPY3]]
  ; GISEL-GFX10-NEXT:   $vgpr4 = COPY [[COPY4]]
  ; GISEL-GFX10-NEXT:   $vgpr5 = COPY [[COPY5]]
  ; GISEL-GFX10-NEXT:   $vgpr6 = COPY [[COPY6]]
  ; GISEL-GFX10-NEXT:   $vgpr7 = COPY [[COPY7]]
  ; GISEL-GFX10-NEXT:   [[COPY8:%[0-9]+]]:sgpr_128 = COPY $sgpr48_sgpr49_sgpr50_sgpr51
  ; GISEL-GFX10-NEXT:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY8]]
  ; GISEL-GFX10-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def $scc
  ; GISEL-GFX10-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (p0) from got, addrspace 4)
  ; GISEL-GFX10-NEXT:   $sgpr30_sgpr31 = noconvergent SI_CALL [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $sgpr0_sgpr1_sgpr2_sgpr3
  ; GISEL-GFX10-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX10-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-LABEL: name: amdgpu_cs_chain_cc
  ; DAGISEL-GFX11: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $vgpr8, $vgpr9, $vgpr10, $vgpr11
  ; DAGISEL-GFX11-NEXT: {{  $}}
  ; DAGISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX11-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX11-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-NEXT:   [[COPY4:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX11-NEXT:   [[COPY5:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX11-NEXT:   [[COPY6:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX11-NEXT:   [[COPY7:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX11-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM killed [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (s64) from got, addrspace 4)
  ; DAGISEL-GFX11-NEXT:   $vgpr0 = COPY [[COPY7]]
  ; DAGISEL-GFX11-NEXT:   $vgpr1 = COPY [[COPY6]]
  ; DAGISEL-GFX11-NEXT:   $vgpr2 = COPY [[COPY5]]
  ; DAGISEL-GFX11-NEXT:   $vgpr3 = COPY [[COPY4]]
  ; DAGISEL-GFX11-NEXT:   $vgpr4 = COPY [[COPY3]]
  ; DAGISEL-GFX11-NEXT:   $vgpr5 = COPY [[COPY2]]
  ; DAGISEL-GFX11-NEXT:   $vgpr6 = COPY [[COPY1]]
  ; DAGISEL-GFX11-NEXT:   $vgpr7 = COPY [[COPY]]
  ; DAGISEL-GFX11-NEXT:   $sgpr30_sgpr31 = SI_CALL killed [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; DAGISEL-GFX11-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-LABEL: name: amdgpu_cs_chain_cc
  ; DAGISEL-GFX10: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $vgpr8, $vgpr9, $vgpr10, $vgpr11
  ; DAGISEL-GFX10-NEXT: {{  $}}
  ; DAGISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX10-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-NEXT:   [[COPY4:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX10-NEXT:   [[COPY5:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX10-NEXT:   [[COPY6:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX10-NEXT:   [[COPY7:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX10-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def dead $scc
  ; DAGISEL-GFX10-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM killed [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (s64) from got, addrspace 4)
  ; DAGISEL-GFX10-NEXT:   [[COPY8:%[0-9]+]]:sgpr_128 = COPY $sgpr48_sgpr49_sgpr50_sgpr51
  ; DAGISEL-GFX10-NEXT:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY8]]
  ; DAGISEL-GFX10-NEXT:   $vgpr0 = COPY [[COPY7]]
  ; DAGISEL-GFX10-NEXT:   $vgpr1 = COPY [[COPY6]]
  ; DAGISEL-GFX10-NEXT:   $vgpr2 = COPY [[COPY5]]
  ; DAGISEL-GFX10-NEXT:   $vgpr3 = COPY [[COPY4]]
  ; DAGISEL-GFX10-NEXT:   $vgpr4 = COPY [[COPY3]]
  ; DAGISEL-GFX10-NEXT:   $vgpr5 = COPY [[COPY2]]
  ; DAGISEL-GFX10-NEXT:   $vgpr6 = COPY [[COPY1]]
  ; DAGISEL-GFX10-NEXT:   $vgpr7 = COPY [[COPY]]
  ; DAGISEL-GFX10-NEXT:   $sgpr30_sgpr31 = SI_CALL killed [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7
  ; DAGISEL-GFX10-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX10-NEXT:   S_ENDPGM 0
  call amdgpu_gfx void @use(<4 x i32> %a, <4 x i32> %b)
  ret void
}

define amdgpu_cs_chain void @amdgpu_cs_chain_cc_ptr(ptr inreg %a, ptr %b, ptr addrspace(1) inreg %a1, ptr addrspace(1) %b1, ptr addrspace(3) inreg %a3, ptr addrspace(3) %b3, ptr addrspace(5) inreg %a5, ptr addrspace(5) %b5) {
  ; GISEL-GFX11-LABEL: name: amdgpu_cs_chain_cc_ptr
  ; GISEL-GFX11: bb.1 (%ir-block.0):
  ; GISEL-GFX11-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13
  ; GISEL-GFX11-NEXT: {{  $}}
  ; GISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr1
  ; GISEL-GFX11-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX11-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; GISEL-GFX11-NEXT:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GISEL-GFX11-NEXT:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GISEL-GFX11-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; GISEL-GFX11-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; GISEL-GFX11-NEXT:   [[COPY8:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GISEL-GFX11-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; GISEL-GFX11-NEXT:   [[COPY10:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GISEL-GFX11-NEXT:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; GISEL-GFX11-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX11-NEXT:   $vgpr0 = COPY [[COPY]]
  ; GISEL-GFX11-NEXT:   $vgpr1 = COPY [[COPY1]]
  ; GISEL-GFX11-NEXT:   $vgpr2 = COPY [[COPY2]]
  ; GISEL-GFX11-NEXT:   $vgpr3 = COPY [[COPY3]]
  ; GISEL-GFX11-NEXT:   $vgpr4 = COPY [[COPY4]]
  ; GISEL-GFX11-NEXT:   $vgpr5 = COPY [[COPY5]]
  ; GISEL-GFX11-NEXT:   $vgpr6 = COPY [[COPY6]]
  ; GISEL-GFX11-NEXT:   $vgpr7 = COPY [[COPY7]]
  ; GISEL-GFX11-NEXT:   $vgpr8 = COPY [[COPY8]]
  ; GISEL-GFX11-NEXT:   $vgpr9 = COPY [[COPY9]]
  ; GISEL-GFX11-NEXT:   $vgpr10 = COPY [[COPY10]]
  ; GISEL-GFX11-NEXT:   $vgpr11 = COPY [[COPY11]]
  ; GISEL-GFX11-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def $scc
  ; GISEL-GFX11-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (p0) from got, addrspace 4)
  ; GISEL-GFX11-NEXT:   $sgpr30_sgpr31 = noconvergent SI_CALL [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11
  ; GISEL-GFX11-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; GISEL-GFX10-LABEL: name: amdgpu_cs_chain_cc_ptr
  ; GISEL-GFX10: bb.1 (%ir-block.0):
  ; GISEL-GFX10-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13
  ; GISEL-GFX10-NEXT: {{  $}}
  ; GISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr1
  ; GISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX10-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; GISEL-GFX10-NEXT:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GISEL-GFX10-NEXT:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GISEL-GFX10-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; GISEL-GFX10-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; GISEL-GFX10-NEXT:   [[COPY8:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GISEL-GFX10-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; GISEL-GFX10-NEXT:   [[COPY10:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GISEL-GFX10-NEXT:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; GISEL-GFX10-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX10-NEXT:   $vgpr0 = COPY [[COPY]]
  ; GISEL-GFX10-NEXT:   $vgpr1 = COPY [[COPY1]]
  ; GISEL-GFX10-NEXT:   $vgpr2 = COPY [[COPY2]]
  ; GISEL-GFX10-NEXT:   $vgpr3 = COPY [[COPY3]]
  ; GISEL-GFX10-NEXT:   $vgpr4 = COPY [[COPY4]]
  ; GISEL-GFX10-NEXT:   $vgpr5 = COPY [[COPY5]]
  ; GISEL-GFX10-NEXT:   $vgpr6 = COPY [[COPY6]]
  ; GISEL-GFX10-NEXT:   $vgpr7 = COPY [[COPY7]]
  ; GISEL-GFX10-NEXT:   $vgpr8 = COPY [[COPY8]]
  ; GISEL-GFX10-NEXT:   $vgpr9 = COPY [[COPY9]]
  ; GISEL-GFX10-NEXT:   $vgpr10 = COPY [[COPY10]]
  ; GISEL-GFX10-NEXT:   $vgpr11 = COPY [[COPY11]]
  ; GISEL-GFX10-NEXT:   [[COPY12:%[0-9]+]]:sgpr_128 = COPY $sgpr48_sgpr49_sgpr50_sgpr51
  ; GISEL-GFX10-NEXT:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY12]]
  ; GISEL-GFX10-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def $scc
  ; GISEL-GFX10-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (p0) from got, addrspace 4)
  ; GISEL-GFX10-NEXT:   $sgpr30_sgpr31 = noconvergent SI_CALL [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $sgpr0_sgpr1_sgpr2_sgpr3
  ; GISEL-GFX10-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX10-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-LABEL: name: amdgpu_cs_chain_cc_ptr
  ; DAGISEL-GFX11: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-NEXT:   liveins: $sgpr0, $sgpr1, $vgpr8, $vgpr9, $sgpr2, $sgpr3, $vgpr10, $vgpr11, $sgpr4, $vgpr12, $sgpr5, $vgpr13
  ; DAGISEL-GFX11-NEXT: {{  $}}
  ; DAGISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; DAGISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX11-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; DAGISEL-GFX11-NEXT:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX11-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX11-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX11-NEXT:   [[COPY6:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX11-NEXT:   [[COPY7:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX11-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX11-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-NEXT:   [[COPY10:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX11-NEXT:   [[COPY11:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX11-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM killed [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (s64) from got, addrspace 4)
  ; DAGISEL-GFX11-NEXT:   $vgpr0 = COPY [[COPY11]]
  ; DAGISEL-GFX11-NEXT:   $vgpr1 = COPY [[COPY10]]
  ; DAGISEL-GFX11-NEXT:   $vgpr2 = COPY [[COPY9]]
  ; DAGISEL-GFX11-NEXT:   $vgpr3 = COPY [[COPY8]]
  ; DAGISEL-GFX11-NEXT:   $vgpr4 = COPY [[COPY7]]
  ; DAGISEL-GFX11-NEXT:   $vgpr5 = COPY [[COPY6]]
  ; DAGISEL-GFX11-NEXT:   $vgpr6 = COPY [[COPY5]]
  ; DAGISEL-GFX11-NEXT:   $vgpr7 = COPY [[COPY4]]
  ; DAGISEL-GFX11-NEXT:   $vgpr8 = COPY [[COPY3]]
  ; DAGISEL-GFX11-NEXT:   $vgpr9 = COPY [[COPY2]]
  ; DAGISEL-GFX11-NEXT:   $vgpr10 = COPY [[COPY1]]
  ; DAGISEL-GFX11-NEXT:   $vgpr11 = COPY [[COPY]]
  ; DAGISEL-GFX11-NEXT:   $sgpr30_sgpr31 = SI_CALL killed [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11
  ; DAGISEL-GFX11-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-LABEL: name: amdgpu_cs_chain_cc_ptr
  ; DAGISEL-GFX10: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-NEXT:   liveins: $sgpr0, $sgpr1, $vgpr8, $vgpr9, $sgpr2, $sgpr3, $vgpr10, $vgpr11, $sgpr4, $vgpr12, $sgpr5, $vgpr13
  ; DAGISEL-GFX10-NEXT: {{  $}}
  ; DAGISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; DAGISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; DAGISEL-GFX10-NEXT:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX10-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX10-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX10-NEXT:   [[COPY6:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX10-NEXT:   [[COPY7:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX10-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX10-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-NEXT:   [[COPY10:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX10-NEXT:   [[COPY11:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX10-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def dead $scc
  ; DAGISEL-GFX10-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM killed [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (s64) from got, addrspace 4)
  ; DAGISEL-GFX10-NEXT:   [[COPY12:%[0-9]+]]:sgpr_128 = COPY $sgpr48_sgpr49_sgpr50_sgpr51
  ; DAGISEL-GFX10-NEXT:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY12]]
  ; DAGISEL-GFX10-NEXT:   $vgpr0 = COPY [[COPY11]]
  ; DAGISEL-GFX10-NEXT:   $vgpr1 = COPY [[COPY10]]
  ; DAGISEL-GFX10-NEXT:   $vgpr2 = COPY [[COPY9]]
  ; DAGISEL-GFX10-NEXT:   $vgpr3 = COPY [[COPY8]]
  ; DAGISEL-GFX10-NEXT:   $vgpr4 = COPY [[COPY7]]
  ; DAGISEL-GFX10-NEXT:   $vgpr5 = COPY [[COPY6]]
  ; DAGISEL-GFX10-NEXT:   $vgpr6 = COPY [[COPY5]]
  ; DAGISEL-GFX10-NEXT:   $vgpr7 = COPY [[COPY4]]
  ; DAGISEL-GFX10-NEXT:   $vgpr8 = COPY [[COPY3]]
  ; DAGISEL-GFX10-NEXT:   $vgpr9 = COPY [[COPY2]]
  ; DAGISEL-GFX10-NEXT:   $vgpr10 = COPY [[COPY1]]
  ; DAGISEL-GFX10-NEXT:   $vgpr11 = COPY [[COPY]]
  ; DAGISEL-GFX10-NEXT:   $sgpr30_sgpr31 = SI_CALL killed [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11
  ; DAGISEL-GFX10-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX10-NEXT:   S_ENDPGM 0
  call amdgpu_gfx void @use(ptr %a, ptr %b, ptr addrspace(1) %a1, ptr addrspace(1) %b1, ptr addrspace(3) %a3, ptr addrspace(3) %b3, ptr addrspace(5) %a5, ptr addrspace(5) %b5)
  ret void
}

define amdgpu_cs_chain void @amdgpu_cs_chain_cc_struct( {ptr, i32, <4 x i32>} inreg %a, {ptr, i32, <4 x i32>} %b) {
  ; GISEL-GFX11-LABEL: name: amdgpu_cs_chain_cc_struct
  ; GISEL-GFX11: bb.1 (%ir-block.0):
  ; GISEL-GFX11-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14
  ; GISEL-GFX11-NEXT: {{  $}}
  ; GISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr1
  ; GISEL-GFX11-NEXT:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GISEL-GFX11-NEXT:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GISEL-GFX11-NEXT:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GISEL-GFX11-NEXT:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GISEL-GFX11-NEXT:   [[COPY6:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GISEL-GFX11-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX11-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; GISEL-GFX11-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; GISEL-GFX11-NEXT:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; GISEL-GFX11-NEXT:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; GISEL-GFX11-NEXT:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; GISEL-GFX11-NEXT:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; GISEL-GFX11-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX11-NEXT:   $vgpr0 = COPY [[COPY]]
  ; GISEL-GFX11-NEXT:   $vgpr1 = COPY [[COPY1]]
  ; GISEL-GFX11-NEXT:   $vgpr2 = COPY [[COPY2]]
  ; GISEL-GFX11-NEXT:   $vgpr3 = COPY [[COPY3]]
  ; GISEL-GFX11-NEXT:   $vgpr4 = COPY [[COPY4]]
  ; GISEL-GFX11-NEXT:   $vgpr5 = COPY [[COPY5]]
  ; GISEL-GFX11-NEXT:   $vgpr6 = COPY [[COPY6]]
  ; GISEL-GFX11-NEXT:   $vgpr7 = COPY [[COPY7]]
  ; GISEL-GFX11-NEXT:   $vgpr8 = COPY [[COPY8]]
  ; GISEL-GFX11-NEXT:   $vgpr9 = COPY [[COPY9]]
  ; GISEL-GFX11-NEXT:   $vgpr10 = COPY [[COPY10]]
  ; GISEL-GFX11-NEXT:   $vgpr11 = COPY [[COPY11]]
  ; GISEL-GFX11-NEXT:   $vgpr12 = COPY [[COPY12]]
  ; GISEL-GFX11-NEXT:   $vgpr13 = COPY [[COPY13]]
  ; GISEL-GFX11-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def $scc
  ; GISEL-GFX11-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (p0) from got, addrspace 4)
  ; GISEL-GFX11-NEXT:   $sgpr30_sgpr31 = noconvergent SI_CALL [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13
  ; GISEL-GFX11-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; GISEL-GFX10-LABEL: name: amdgpu_cs_chain_cc_struct
  ; GISEL-GFX10: bb.1 (%ir-block.0):
  ; GISEL-GFX10-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14
  ; GISEL-GFX10-NEXT: {{  $}}
  ; GISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr1
  ; GISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GISEL-GFX10-NEXT:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GISEL-GFX10-NEXT:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GISEL-GFX10-NEXT:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GISEL-GFX10-NEXT:   [[COPY6:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GISEL-GFX10-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX10-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; GISEL-GFX10-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; GISEL-GFX10-NEXT:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; GISEL-GFX10-NEXT:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; GISEL-GFX10-NEXT:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; GISEL-GFX10-NEXT:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; GISEL-GFX10-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX10-NEXT:   $vgpr0 = COPY [[COPY]]
  ; GISEL-GFX10-NEXT:   $vgpr1 = COPY [[COPY1]]
  ; GISEL-GFX10-NEXT:   $vgpr2 = COPY [[COPY2]]
  ; GISEL-GFX10-NEXT:   $vgpr3 = COPY [[COPY3]]
  ; GISEL-GFX10-NEXT:   $vgpr4 = COPY [[COPY4]]
  ; GISEL-GFX10-NEXT:   $vgpr5 = COPY [[COPY5]]
  ; GISEL-GFX10-NEXT:   $vgpr6 = COPY [[COPY6]]
  ; GISEL-GFX10-NEXT:   $vgpr7 = COPY [[COPY7]]
  ; GISEL-GFX10-NEXT:   $vgpr8 = COPY [[COPY8]]
  ; GISEL-GFX10-NEXT:   $vgpr9 = COPY [[COPY9]]
  ; GISEL-GFX10-NEXT:   $vgpr10 = COPY [[COPY10]]
  ; GISEL-GFX10-NEXT:   $vgpr11 = COPY [[COPY11]]
  ; GISEL-GFX10-NEXT:   $vgpr12 = COPY [[COPY12]]
  ; GISEL-GFX10-NEXT:   $vgpr13 = COPY [[COPY13]]
  ; GISEL-GFX10-NEXT:   [[COPY14:%[0-9]+]]:sgpr_128 = COPY $sgpr48_sgpr49_sgpr50_sgpr51
  ; GISEL-GFX10-NEXT:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY14]]
  ; GISEL-GFX10-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def $scc
  ; GISEL-GFX10-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (p0) from got, addrspace 4)
  ; GISEL-GFX10-NEXT:   $sgpr30_sgpr31 = noconvergent SI_CALL [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $sgpr0_sgpr1_sgpr2_sgpr3
  ; GISEL-GFX10-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX10-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-LABEL: name: amdgpu_cs_chain_cc_struct
  ; DAGISEL-GFX11: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14
  ; DAGISEL-GFX11-NEXT: {{  $}}
  ; DAGISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; DAGISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; DAGISEL-GFX11-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; DAGISEL-GFX11-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX11-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX11-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX11-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-NEXT:   [[COPY7:%[0-9]+]]:sgpr_32 = COPY $sgpr6
  ; DAGISEL-GFX11-NEXT:   [[COPY8:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX11-NEXT:   [[COPY9:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX11-NEXT:   [[COPY10:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX11-NEXT:   [[COPY11:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX11-NEXT:   [[COPY12:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX11-NEXT:   [[COPY13:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_64 = REG_SEQUENCE [[COPY13]], %subreg.sub0, [[COPY12]], %subreg.sub1
  ; DAGISEL-GFX11-NEXT:   [[COPY14:%[0-9]+]]:sreg_32 = COPY [[REG_SEQUENCE]].sub1
  ; DAGISEL-GFX11-NEXT:   [[DEF:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-NEXT:   [[DEF1:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY6]], %subreg.sub0, [[COPY5]], %subreg.sub1
  ; DAGISEL-GFX11-NEXT:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub1
  ; DAGISEL-GFX11-NEXT:   [[COPY16:%[0-9]+]]:sreg_32 = COPY [[REG_SEQUENCE]].sub0
  ; DAGISEL-GFX11-NEXT:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub0
  ; DAGISEL-GFX11-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX11-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM killed [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (s64) from got, addrspace 4)
  ; DAGISEL-GFX11-NEXT:   $vgpr0 = COPY [[COPY16]]
  ; DAGISEL-GFX11-NEXT:   $vgpr1 = COPY [[COPY14]]
  ; DAGISEL-GFX11-NEXT:   $vgpr2 = COPY [[COPY11]]
  ; DAGISEL-GFX11-NEXT:   $vgpr3 = COPY [[COPY10]]
  ; DAGISEL-GFX11-NEXT:   $vgpr4 = COPY [[COPY9]]
  ; DAGISEL-GFX11-NEXT:   $vgpr5 = COPY [[COPY8]]
  ; DAGISEL-GFX11-NEXT:   $vgpr6 = COPY [[COPY7]]
  ; DAGISEL-GFX11-NEXT:   $vgpr7 = COPY [[COPY17]]
  ; DAGISEL-GFX11-NEXT:   $vgpr8 = COPY [[COPY15]]
  ; DAGISEL-GFX11-NEXT:   $vgpr9 = COPY [[COPY4]]
  ; DAGISEL-GFX11-NEXT:   $vgpr10 = COPY [[COPY3]]
  ; DAGISEL-GFX11-NEXT:   $vgpr11 = COPY [[COPY2]]
  ; DAGISEL-GFX11-NEXT:   $vgpr12 = COPY [[COPY1]]
  ; DAGISEL-GFX11-NEXT:   $vgpr13 = COPY [[COPY]]
  ; DAGISEL-GFX11-NEXT:   $sgpr30_sgpr31 = SI_CALL killed [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13
  ; DAGISEL-GFX11-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-LABEL: name: amdgpu_cs_chain_cc_struct
  ; DAGISEL-GFX10: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14
  ; DAGISEL-GFX10-NEXT: {{  $}}
  ; DAGISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; DAGISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; DAGISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; DAGISEL-GFX10-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX10-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX10-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX10-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-NEXT:   [[COPY7:%[0-9]+]]:sgpr_32 = COPY $sgpr6
  ; DAGISEL-GFX10-NEXT:   [[COPY8:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX10-NEXT:   [[COPY9:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX10-NEXT:   [[COPY10:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX10-NEXT:   [[COPY11:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX10-NEXT:   [[COPY12:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX10-NEXT:   [[COPY13:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_64 = REG_SEQUENCE [[COPY13]], %subreg.sub0, [[COPY12]], %subreg.sub1
  ; DAGISEL-GFX10-NEXT:   [[COPY14:%[0-9]+]]:sreg_32 = COPY [[REG_SEQUENCE]].sub1
  ; DAGISEL-GFX10-NEXT:   [[DEF:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-NEXT:   [[DEF1:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY6]], %subreg.sub0, [[COPY5]], %subreg.sub1
  ; DAGISEL-GFX10-NEXT:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub1
  ; DAGISEL-GFX10-NEXT:   [[COPY16:%[0-9]+]]:sreg_32 = COPY [[REG_SEQUENCE]].sub0
  ; DAGISEL-GFX10-NEXT:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY [[REG_SEQUENCE1]].sub0
  ; DAGISEL-GFX10-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX10-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def dead $scc
  ; DAGISEL-GFX10-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM killed [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (s64) from got, addrspace 4)
  ; DAGISEL-GFX10-NEXT:   [[COPY18:%[0-9]+]]:sgpr_128 = COPY $sgpr48_sgpr49_sgpr50_sgpr51
  ; DAGISEL-GFX10-NEXT:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY18]]
  ; DAGISEL-GFX10-NEXT:   $vgpr0 = COPY [[COPY16]]
  ; DAGISEL-GFX10-NEXT:   $vgpr1 = COPY [[COPY14]]
  ; DAGISEL-GFX10-NEXT:   $vgpr2 = COPY [[COPY11]]
  ; DAGISEL-GFX10-NEXT:   $vgpr3 = COPY [[COPY10]]
  ; DAGISEL-GFX10-NEXT:   $vgpr4 = COPY [[COPY9]]
  ; DAGISEL-GFX10-NEXT:   $vgpr5 = COPY [[COPY8]]
  ; DAGISEL-GFX10-NEXT:   $vgpr6 = COPY [[COPY7]]
  ; DAGISEL-GFX10-NEXT:   $vgpr7 = COPY [[COPY17]]
  ; DAGISEL-GFX10-NEXT:   $vgpr8 = COPY [[COPY15]]
  ; DAGISEL-GFX10-NEXT:   $vgpr9 = COPY [[COPY4]]
  ; DAGISEL-GFX10-NEXT:   $vgpr10 = COPY [[COPY3]]
  ; DAGISEL-GFX10-NEXT:   $vgpr11 = COPY [[COPY2]]
  ; DAGISEL-GFX10-NEXT:   $vgpr12 = COPY [[COPY1]]
  ; DAGISEL-GFX10-NEXT:   $vgpr13 = COPY [[COPY]]
  ; DAGISEL-GFX10-NEXT:   $sgpr30_sgpr31 = SI_CALL killed [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13
  ; DAGISEL-GFX10-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX10-NEXT:   S_ENDPGM 0
  call amdgpu_gfx void @use({ptr, i32, <4 x i32>} %a, {ptr, i32, <4 x i32>} %b)
  ret void
}

define amdgpu_cs_chain void @amdgpu_cs_chain_cc_float(float inreg %a, float %b) {
  ; GISEL-GFX11-LABEL: name: amdgpu_cs_chain_cc_float
  ; GISEL-GFX11: bb.1 (%ir-block.0):
  ; GISEL-GFX11-NEXT:   liveins: $sgpr0, $vgpr8
  ; GISEL-GFX11-NEXT: {{  $}}
  ; GISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX11-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX11-NEXT:   $vgpr0 = COPY [[COPY]]
  ; GISEL-GFX11-NEXT:   $vgpr1 = COPY [[COPY1]]
  ; GISEL-GFX11-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def $scc
  ; GISEL-GFX11-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (p0) from got, addrspace 4)
  ; GISEL-GFX11-NEXT:   $sgpr30_sgpr31 = noconvergent SI_CALL [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1
  ; GISEL-GFX11-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; GISEL-GFX10-LABEL: name: amdgpu_cs_chain_cc_float
  ; GISEL-GFX10: bb.1 (%ir-block.0):
  ; GISEL-GFX10-NEXT:   liveins: $sgpr0, $vgpr8
  ; GISEL-GFX10-NEXT: {{  $}}
  ; GISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX10-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX10-NEXT:   $vgpr0 = COPY [[COPY]]
  ; GISEL-GFX10-NEXT:   $vgpr1 = COPY [[COPY1]]
  ; GISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:sgpr_128 = COPY $sgpr48_sgpr49_sgpr50_sgpr51
  ; GISEL-GFX10-NEXT:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY2]]
  ; GISEL-GFX10-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def $scc
  ; GISEL-GFX10-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (p0) from got, addrspace 4)
  ; GISEL-GFX10-NEXT:   $sgpr30_sgpr31 = noconvergent SI_CALL [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1, implicit $sgpr0_sgpr1_sgpr2_sgpr3
  ; GISEL-GFX10-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX10-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-LABEL: name: amdgpu_cs_chain_cc_float
  ; DAGISEL-GFX11: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX11-NEXT: {{  $}}
  ; DAGISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX11-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM killed [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (s64) from got, addrspace 4)
  ; DAGISEL-GFX11-NEXT:   $vgpr0 = COPY [[COPY1]]
  ; DAGISEL-GFX11-NEXT:   $vgpr1 = COPY [[COPY]]
  ; DAGISEL-GFX11-NEXT:   $sgpr30_sgpr31 = SI_CALL killed [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1
  ; DAGISEL-GFX11-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-LABEL: name: amdgpu_cs_chain_cc_float
  ; DAGISEL-GFX10: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX10-NEXT: {{  $}}
  ; DAGISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX10-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def dead $scc
  ; DAGISEL-GFX10-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM killed [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (s64) from got, addrspace 4)
  ; DAGISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:sgpr_128 = COPY $sgpr48_sgpr49_sgpr50_sgpr51
  ; DAGISEL-GFX10-NEXT:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY2]]
  ; DAGISEL-GFX10-NEXT:   $vgpr0 = COPY [[COPY1]]
  ; DAGISEL-GFX10-NEXT:   $vgpr1 = COPY [[COPY]]
  ; DAGISEL-GFX10-NEXT:   $sgpr30_sgpr31 = SI_CALL killed [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $vgpr0, implicit $vgpr1
  ; DAGISEL-GFX10-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX10-NEXT:   S_ENDPGM 0
  call amdgpu_gfx void @use(float %a, float %b)
  ret void
}

define amdgpu_cs_chain void @amdgpu_cs_chain_cc_half(half inreg %a, half %b) {
  ; GISEL-GFX11-LABEL: name: amdgpu_cs_chain_cc_half
  ; GISEL-GFX11: bb.1 (%ir-block.0):
  ; GISEL-GFX11-NEXT:   liveins: $sgpr0, $vgpr8
  ; GISEL-GFX11-NEXT: {{  $}}
  ; GISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX11-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX11-NEXT:   $vgpr0 = COPY [[COPY]]
  ; GISEL-GFX11-NEXT:   $vgpr1 = COPY [[COPY1]]
  ; GISEL-GFX11-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def $scc
  ; GISEL-GFX11-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (p0) from got, addrspace 4)
  ; GISEL-GFX11-NEXT:   $sgpr30_sgpr31 = noconvergent SI_CALL [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1
  ; GISEL-GFX11-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; GISEL-GFX10-LABEL: name: amdgpu_cs_chain_cc_half
  ; GISEL-GFX10: bb.1 (%ir-block.0):
  ; GISEL-GFX10-NEXT:   liveins: $sgpr0, $vgpr8
  ; GISEL-GFX10-NEXT: {{  $}}
  ; GISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX10-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX10-NEXT:   $vgpr0 = COPY [[COPY]]
  ; GISEL-GFX10-NEXT:   $vgpr1 = COPY [[COPY1]]
  ; GISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:sgpr_128 = COPY $sgpr48_sgpr49_sgpr50_sgpr51
  ; GISEL-GFX10-NEXT:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY2]]
  ; GISEL-GFX10-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def $scc
  ; GISEL-GFX10-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (p0) from got, addrspace 4)
  ; GISEL-GFX10-NEXT:   $sgpr30_sgpr31 = noconvergent SI_CALL [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1, implicit $sgpr0_sgpr1_sgpr2_sgpr3
  ; GISEL-GFX10-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX10-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-LABEL: name: amdgpu_cs_chain_cc_half
  ; DAGISEL-GFX11: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX11-NEXT: {{  $}}
  ; DAGISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX11-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM killed [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (s64) from got, addrspace 4)
  ; DAGISEL-GFX11-NEXT:   $vgpr0 = COPY [[COPY1]]
  ; DAGISEL-GFX11-NEXT:   $vgpr1 = COPY [[COPY]]
  ; DAGISEL-GFX11-NEXT:   $sgpr30_sgpr31 = SI_CALL killed [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1
  ; DAGISEL-GFX11-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-LABEL: name: amdgpu_cs_chain_cc_half
  ; DAGISEL-GFX10: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX10-NEXT: {{  $}}
  ; DAGISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX10-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def dead $scc
  ; DAGISEL-GFX10-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM killed [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (s64) from got, addrspace 4)
  ; DAGISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:sgpr_128 = COPY $sgpr48_sgpr49_sgpr50_sgpr51
  ; DAGISEL-GFX10-NEXT:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY2]]
  ; DAGISEL-GFX10-NEXT:   $vgpr0 = COPY [[COPY1]]
  ; DAGISEL-GFX10-NEXT:   $vgpr1 = COPY [[COPY]]
  ; DAGISEL-GFX10-NEXT:   $sgpr30_sgpr31 = SI_CALL killed [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $vgpr0, implicit $vgpr1
  ; DAGISEL-GFX10-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX10-NEXT:   S_ENDPGM 0
  call amdgpu_gfx void @use(half %a, half %b)
  ret void
}

define amdgpu_cs_chain void @amdgpu_cs_chain_cc_bfloat(bfloat inreg %a, bfloat %b) {
  ; GISEL-GFX11-LABEL: name: amdgpu_cs_chain_cc_bfloat
  ; GISEL-GFX11: bb.0 (%ir-block.0):
  ; GISEL-GFX11-NEXT:   liveins: $sgpr0, $vgpr8
  ; GISEL-GFX11-NEXT: {{  $}}
  ; GISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; GISEL-GFX11-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX11-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM killed [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (s64) from got, addrspace 4)
  ; GISEL-GFX11-NEXT:   $vgpr0 = COPY [[COPY1]]
  ; GISEL-GFX11-NEXT:   $vgpr1 = COPY [[COPY]]
  ; GISEL-GFX11-NEXT:   $sgpr30_sgpr31 = SI_CALL killed [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1
  ; GISEL-GFX11-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; GISEL-GFX10-LABEL: name: amdgpu_cs_chain_cc_bfloat
  ; GISEL-GFX10: bb.0 (%ir-block.0):
  ; GISEL-GFX10-NEXT:   liveins: $sgpr0, $vgpr8
  ; GISEL-GFX10-NEXT: {{  $}}
  ; GISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; GISEL-GFX10-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX10-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def dead $scc
  ; GISEL-GFX10-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM killed [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (s64) from got, addrspace 4)
  ; GISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:sgpr_128 = COPY $sgpr48_sgpr49_sgpr50_sgpr51
  ; GISEL-GFX10-NEXT:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY2]]
  ; GISEL-GFX10-NEXT:   $vgpr0 = COPY [[COPY1]]
  ; GISEL-GFX10-NEXT:   $vgpr1 = COPY [[COPY]]
  ; GISEL-GFX10-NEXT:   $sgpr30_sgpr31 = SI_CALL killed [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $vgpr0, implicit $vgpr1
  ; GISEL-GFX10-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX10-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-LABEL: name: amdgpu_cs_chain_cc_bfloat
  ; DAGISEL-GFX11: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX11-NEXT: {{  $}}
  ; DAGISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX11-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM killed [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (s64) from got, addrspace 4)
  ; DAGISEL-GFX11-NEXT:   $vgpr0 = COPY [[COPY1]]
  ; DAGISEL-GFX11-NEXT:   $vgpr1 = COPY [[COPY]]
  ; DAGISEL-GFX11-NEXT:   $sgpr30_sgpr31 = SI_CALL killed [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1
  ; DAGISEL-GFX11-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-LABEL: name: amdgpu_cs_chain_cc_bfloat
  ; DAGISEL-GFX10: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX10-NEXT: {{  $}}
  ; DAGISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX10-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def dead $scc
  ; DAGISEL-GFX10-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM killed [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (s64) from got, addrspace 4)
  ; DAGISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:sgpr_128 = COPY $sgpr48_sgpr49_sgpr50_sgpr51
  ; DAGISEL-GFX10-NEXT:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY2]]
  ; DAGISEL-GFX10-NEXT:   $vgpr0 = COPY [[COPY1]]
  ; DAGISEL-GFX10-NEXT:   $vgpr1 = COPY [[COPY]]
  ; DAGISEL-GFX10-NEXT:   $sgpr30_sgpr31 = SI_CALL killed [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $vgpr0, implicit $vgpr1
  ; DAGISEL-GFX10-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX10-NEXT:   S_ENDPGM 0
  call amdgpu_gfx void @use(bfloat %a, bfloat %b)
  ret void
}

define amdgpu_cs_chain void @amdgpu_cs_chain_cc_i16(i16 inreg %a, i16 %b) {
  ; GISEL-GFX11-LABEL: name: amdgpu_cs_chain_cc_i16
  ; GISEL-GFX11: bb.1 (%ir-block.0):
  ; GISEL-GFX11-NEXT:   liveins: $sgpr0, $vgpr8
  ; GISEL-GFX11-NEXT: {{  $}}
  ; GISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX11-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX11-NEXT:   $vgpr0 = COPY [[COPY]]
  ; GISEL-GFX11-NEXT:   $vgpr1 = COPY [[COPY1]]
  ; GISEL-GFX11-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def $scc
  ; GISEL-GFX11-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (p0) from got, addrspace 4)
  ; GISEL-GFX11-NEXT:   $sgpr30_sgpr31 = noconvergent SI_CALL [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1
  ; GISEL-GFX11-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; GISEL-GFX10-LABEL: name: amdgpu_cs_chain_cc_i16
  ; GISEL-GFX10: bb.1 (%ir-block.0):
  ; GISEL-GFX10-NEXT:   liveins: $sgpr0, $vgpr8
  ; GISEL-GFX10-NEXT: {{  $}}
  ; GISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX10-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX10-NEXT:   $vgpr0 = COPY [[COPY]]
  ; GISEL-GFX10-NEXT:   $vgpr1 = COPY [[COPY1]]
  ; GISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:sgpr_128 = COPY $sgpr48_sgpr49_sgpr50_sgpr51
  ; GISEL-GFX10-NEXT:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY2]]
  ; GISEL-GFX10-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def $scc
  ; GISEL-GFX10-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (p0) from got, addrspace 4)
  ; GISEL-GFX10-NEXT:   $sgpr30_sgpr31 = noconvergent SI_CALL [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1, implicit $sgpr0_sgpr1_sgpr2_sgpr3
  ; GISEL-GFX10-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX10-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-LABEL: name: amdgpu_cs_chain_cc_i16
  ; DAGISEL-GFX11: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX11-NEXT: {{  $}}
  ; DAGISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX11-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM killed [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (s64) from got, addrspace 4)
  ; DAGISEL-GFX11-NEXT:   $vgpr0 = COPY [[COPY1]]
  ; DAGISEL-GFX11-NEXT:   $vgpr1 = COPY [[COPY]]
  ; DAGISEL-GFX11-NEXT:   $sgpr30_sgpr31 = SI_CALL killed [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1
  ; DAGISEL-GFX11-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-LABEL: name: amdgpu_cs_chain_cc_i16
  ; DAGISEL-GFX10: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX10-NEXT: {{  $}}
  ; DAGISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX10-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def dead $scc
  ; DAGISEL-GFX10-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM killed [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (s64) from got, addrspace 4)
  ; DAGISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:sgpr_128 = COPY $sgpr48_sgpr49_sgpr50_sgpr51
  ; DAGISEL-GFX10-NEXT:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY2]]
  ; DAGISEL-GFX10-NEXT:   $vgpr0 = COPY [[COPY1]]
  ; DAGISEL-GFX10-NEXT:   $vgpr1 = COPY [[COPY]]
  ; DAGISEL-GFX10-NEXT:   $sgpr30_sgpr31 = SI_CALL killed [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $vgpr0, implicit $vgpr1
  ; DAGISEL-GFX10-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX10-NEXT:   S_ENDPGM 0
  call amdgpu_gfx void @use(i16 %a, i16 %b)
  ret void
}

define amdgpu_cs_chain void @amdgpu_cs_chain_cc_v16i16(<16 x i16> inreg %a, <16 x i16> %b) {
  ; GISEL-GFX11-LABEL: name: amdgpu_cs_chain_cc_v16i16
  ; GISEL-GFX11: bb.1 (%ir-block.0):
  ; GISEL-GFX11-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15
  ; GISEL-GFX11-NEXT: {{  $}}
  ; GISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr1
  ; GISEL-GFX11-NEXT:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GISEL-GFX11-NEXT:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GISEL-GFX11-NEXT:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GISEL-GFX11-NEXT:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GISEL-GFX11-NEXT:   [[COPY6:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GISEL-GFX11-NEXT:   [[COPY7:%[0-9]+]]:sreg_32 = COPY $sgpr7
  ; GISEL-GFX11-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX11-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; GISEL-GFX11-NEXT:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; GISEL-GFX11-NEXT:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; GISEL-GFX11-NEXT:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; GISEL-GFX11-NEXT:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; GISEL-GFX11-NEXT:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; GISEL-GFX11-NEXT:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY $vgpr15
  ; GISEL-GFX11-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX11-NEXT:   $vgpr0 = COPY [[COPY]]
  ; GISEL-GFX11-NEXT:   $vgpr1 = COPY [[COPY1]]
  ; GISEL-GFX11-NEXT:   $vgpr2 = COPY [[COPY2]]
  ; GISEL-GFX11-NEXT:   $vgpr3 = COPY [[COPY3]]
  ; GISEL-GFX11-NEXT:   $vgpr4 = COPY [[COPY4]]
  ; GISEL-GFX11-NEXT:   $vgpr5 = COPY [[COPY5]]
  ; GISEL-GFX11-NEXT:   $vgpr6 = COPY [[COPY6]]
  ; GISEL-GFX11-NEXT:   $vgpr7 = COPY [[COPY7]]
  ; GISEL-GFX11-NEXT:   $vgpr8 = COPY [[COPY8]]
  ; GISEL-GFX11-NEXT:   $vgpr9 = COPY [[COPY9]]
  ; GISEL-GFX11-NEXT:   $vgpr10 = COPY [[COPY10]]
  ; GISEL-GFX11-NEXT:   $vgpr11 = COPY [[COPY11]]
  ; GISEL-GFX11-NEXT:   $vgpr12 = COPY [[COPY12]]
  ; GISEL-GFX11-NEXT:   $vgpr13 = COPY [[COPY13]]
  ; GISEL-GFX11-NEXT:   $vgpr14 = COPY [[COPY14]]
  ; GISEL-GFX11-NEXT:   $vgpr15 = COPY [[COPY15]]
  ; GISEL-GFX11-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def $scc
  ; GISEL-GFX11-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (p0) from got, addrspace 4)
  ; GISEL-GFX11-NEXT:   $sgpr30_sgpr31 = noconvergent SI_CALL [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15
  ; GISEL-GFX11-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; GISEL-GFX10-LABEL: name: amdgpu_cs_chain_cc_v16i16
  ; GISEL-GFX10: bb.1 (%ir-block.0):
  ; GISEL-GFX10-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15
  ; GISEL-GFX10-NEXT: {{  $}}
  ; GISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr1
  ; GISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GISEL-GFX10-NEXT:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GISEL-GFX10-NEXT:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GISEL-GFX10-NEXT:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GISEL-GFX10-NEXT:   [[COPY6:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GISEL-GFX10-NEXT:   [[COPY7:%[0-9]+]]:sreg_32 = COPY $sgpr7
  ; GISEL-GFX10-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX10-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; GISEL-GFX10-NEXT:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; GISEL-GFX10-NEXT:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; GISEL-GFX10-NEXT:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; GISEL-GFX10-NEXT:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; GISEL-GFX10-NEXT:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; GISEL-GFX10-NEXT:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY $vgpr15
  ; GISEL-GFX10-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX10-NEXT:   $vgpr0 = COPY [[COPY]]
  ; GISEL-GFX10-NEXT:   $vgpr1 = COPY [[COPY1]]
  ; GISEL-GFX10-NEXT:   $vgpr2 = COPY [[COPY2]]
  ; GISEL-GFX10-NEXT:   $vgpr3 = COPY [[COPY3]]
  ; GISEL-GFX10-NEXT:   $vgpr4 = COPY [[COPY4]]
  ; GISEL-GFX10-NEXT:   $vgpr5 = COPY [[COPY5]]
  ; GISEL-GFX10-NEXT:   $vgpr6 = COPY [[COPY6]]
  ; GISEL-GFX10-NEXT:   $vgpr7 = COPY [[COPY7]]
  ; GISEL-GFX10-NEXT:   $vgpr8 = COPY [[COPY8]]
  ; GISEL-GFX10-NEXT:   $vgpr9 = COPY [[COPY9]]
  ; GISEL-GFX10-NEXT:   $vgpr10 = COPY [[COPY10]]
  ; GISEL-GFX10-NEXT:   $vgpr11 = COPY [[COPY11]]
  ; GISEL-GFX10-NEXT:   $vgpr12 = COPY [[COPY12]]
  ; GISEL-GFX10-NEXT:   $vgpr13 = COPY [[COPY13]]
  ; GISEL-GFX10-NEXT:   $vgpr14 = COPY [[COPY14]]
  ; GISEL-GFX10-NEXT:   $vgpr15 = COPY [[COPY15]]
  ; GISEL-GFX10-NEXT:   [[COPY16:%[0-9]+]]:sgpr_128 = COPY $sgpr48_sgpr49_sgpr50_sgpr51
  ; GISEL-GFX10-NEXT:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY16]]
  ; GISEL-GFX10-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def $scc
  ; GISEL-GFX10-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (p0) from got, addrspace 4)
  ; GISEL-GFX10-NEXT:   $sgpr30_sgpr31 = noconvergent SI_CALL [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15, implicit $sgpr0_sgpr1_sgpr2_sgpr3
  ; GISEL-GFX10-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX10-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-LABEL: name: amdgpu_cs_chain_cc_v16i16
  ; DAGISEL-GFX11: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15
  ; DAGISEL-GFX11-NEXT: {{  $}}
  ; DAGISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr15
  ; DAGISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; DAGISEL-GFX11-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; DAGISEL-GFX11-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; DAGISEL-GFX11-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX11-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX11-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX11-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-NEXT:   [[COPY8:%[0-9]+]]:sgpr_32 = COPY $sgpr7
  ; DAGISEL-GFX11-NEXT:   [[COPY9:%[0-9]+]]:sgpr_32 = COPY $sgpr6
  ; DAGISEL-GFX11-NEXT:   [[COPY10:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX11-NEXT:   [[COPY11:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX11-NEXT:   [[COPY12:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX11-NEXT:   [[COPY13:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX11-NEXT:   [[COPY14:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX11-NEXT:   [[COPY15:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX11-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM killed [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (s64) from got, addrspace 4)
  ; DAGISEL-GFX11-NEXT:   $vgpr0 = COPY [[COPY15]]
  ; DAGISEL-GFX11-NEXT:   $vgpr1 = COPY [[COPY14]]
  ; DAGISEL-GFX11-NEXT:   $vgpr2 = COPY [[COPY13]]
  ; DAGISEL-GFX11-NEXT:   $vgpr3 = COPY [[COPY12]]
  ; DAGISEL-GFX11-NEXT:   $vgpr4 = COPY [[COPY11]]
  ; DAGISEL-GFX11-NEXT:   $vgpr5 = COPY [[COPY10]]
  ; DAGISEL-GFX11-NEXT:   $vgpr6 = COPY [[COPY9]]
  ; DAGISEL-GFX11-NEXT:   $vgpr7 = COPY [[COPY8]]
  ; DAGISEL-GFX11-NEXT:   $vgpr8 = COPY [[COPY7]]
  ; DAGISEL-GFX11-NEXT:   $vgpr9 = COPY [[COPY6]]
  ; DAGISEL-GFX11-NEXT:   $vgpr10 = COPY [[COPY5]]
  ; DAGISEL-GFX11-NEXT:   $vgpr11 = COPY [[COPY4]]
  ; DAGISEL-GFX11-NEXT:   $vgpr12 = COPY [[COPY3]]
  ; DAGISEL-GFX11-NEXT:   $vgpr13 = COPY [[COPY2]]
  ; DAGISEL-GFX11-NEXT:   $vgpr14 = COPY [[COPY1]]
  ; DAGISEL-GFX11-NEXT:   $vgpr15 = COPY [[COPY]]
  ; DAGISEL-GFX11-NEXT:   $sgpr30_sgpr31 = SI_CALL killed [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15
  ; DAGISEL-GFX11-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-LABEL: name: amdgpu_cs_chain_cc_v16i16
  ; DAGISEL-GFX10: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15
  ; DAGISEL-GFX10-NEXT: {{  $}}
  ; DAGISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr15
  ; DAGISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; DAGISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; DAGISEL-GFX10-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; DAGISEL-GFX10-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX10-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX10-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX10-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-NEXT:   [[COPY8:%[0-9]+]]:sgpr_32 = COPY $sgpr7
  ; DAGISEL-GFX10-NEXT:   [[COPY9:%[0-9]+]]:sgpr_32 = COPY $sgpr6
  ; DAGISEL-GFX10-NEXT:   [[COPY10:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX10-NEXT:   [[COPY11:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX10-NEXT:   [[COPY12:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX10-NEXT:   [[COPY13:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX10-NEXT:   [[COPY14:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX10-NEXT:   [[COPY15:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX10-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def dead $scc
  ; DAGISEL-GFX10-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM killed [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (s64) from got, addrspace 4)
  ; DAGISEL-GFX10-NEXT:   [[COPY16:%[0-9]+]]:sgpr_128 = COPY $sgpr48_sgpr49_sgpr50_sgpr51
  ; DAGISEL-GFX10-NEXT:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY16]]
  ; DAGISEL-GFX10-NEXT:   $vgpr0 = COPY [[COPY15]]
  ; DAGISEL-GFX10-NEXT:   $vgpr1 = COPY [[COPY14]]
  ; DAGISEL-GFX10-NEXT:   $vgpr2 = COPY [[COPY13]]
  ; DAGISEL-GFX10-NEXT:   $vgpr3 = COPY [[COPY12]]
  ; DAGISEL-GFX10-NEXT:   $vgpr4 = COPY [[COPY11]]
  ; DAGISEL-GFX10-NEXT:   $vgpr5 = COPY [[COPY10]]
  ; DAGISEL-GFX10-NEXT:   $vgpr6 = COPY [[COPY9]]
  ; DAGISEL-GFX10-NEXT:   $vgpr7 = COPY [[COPY8]]
  ; DAGISEL-GFX10-NEXT:   $vgpr8 = COPY [[COPY7]]
  ; DAGISEL-GFX10-NEXT:   $vgpr9 = COPY [[COPY6]]
  ; DAGISEL-GFX10-NEXT:   $vgpr10 = COPY [[COPY5]]
  ; DAGISEL-GFX10-NEXT:   $vgpr11 = COPY [[COPY4]]
  ; DAGISEL-GFX10-NEXT:   $vgpr12 = COPY [[COPY3]]
  ; DAGISEL-GFX10-NEXT:   $vgpr13 = COPY [[COPY2]]
  ; DAGISEL-GFX10-NEXT:   $vgpr14 = COPY [[COPY1]]
  ; DAGISEL-GFX10-NEXT:   $vgpr15 = COPY [[COPY]]
  ; DAGISEL-GFX10-NEXT:   $sgpr30_sgpr31 = SI_CALL killed [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15
  ; DAGISEL-GFX10-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX10-NEXT:   S_ENDPGM 0
  call amdgpu_gfx void @use(<16 x i16> %a, <16 x i16> %b)
  ret void
}

; Test that we can pass more than 32 SGPRs (but less than 48, so it works for GFX10).
; Also an arbitrary (large) number of VGPRS.
define amdgpu_cs_chain void @amdgpu_cs_chain_many_regs(<36 x i32> inreg %a, <128 x i32> %b) {
  ; GISEL-GFX11-LABEL: name: amdgpu_cs_chain_many_regs
  ; GISEL-GFX11: bb.1 (%ir-block.0):
  ; GISEL-GFX11-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $sgpr14, $sgpr15, $sgpr16, $sgpr17, $sgpr18, $sgpr19, $sgpr20, $sgpr21, $sgpr22, $sgpr23, $sgpr24, $sgpr25, $sgpr26, $sgpr27, $sgpr28, $sgpr29, $sgpr30, $sgpr31, $sgpr32, $sgpr33, $sgpr34, $sgpr35, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $vgpr32, $vgpr33, $vgpr34, $vgpr35, $vgpr36, $vgpr37, $vgpr38, $vgpr39, $vgpr40, $vgpr41, $vgpr42, $vgpr43, $vgpr44, $vgpr45, $vgpr46, $vgpr47, $vgpr48, $vgpr49, $vgpr50, $vgpr51, $vgpr52, $vgpr53, $vgpr54, $vgpr55, $vgpr56, $vgpr57, $vgpr58, $vgpr59, $vgpr60, $vgpr61, $vgpr62, $vgpr63, $vgpr64, $vgpr65, $vgpr66, $vgpr67, $vgpr68, $vgpr69, $vgpr70, $vgpr71, $vgpr72, $vgpr73, $vgpr74, $vgpr75, $vgpr76, $vgpr77, $vgpr78, $vgpr79, $vgpr80, $vgpr81, $vgpr82, $vgpr83, $vgpr84, $vgpr85, $vgpr86, $vgpr87, $vgpr88, $vgpr89, $vgpr90, $vgpr91, $vgpr92, $vgpr93, $vgpr94, $vgpr95, $vgpr96, $vgpr97, $vgpr98, $vgpr99, $vgpr100, $vgpr101, $vgpr102, $vgpr103, $vgpr104, $vgpr105, $vgpr106, $vgpr107, $vgpr108, $vgpr109, $vgpr110, $vgpr111, $vgpr112, $vgpr113, $vgpr114, $vgpr115, $vgpr116, $vgpr117, $vgpr118, $vgpr119, $vgpr120, $vgpr121, $vgpr122, $vgpr123, $vgpr124, $vgpr125, $vgpr126, $vgpr127, $vgpr128, $vgpr129, $vgpr130, $vgpr131, $vgpr132, $vgpr133, $vgpr134, $vgpr135
  ; GISEL-GFX11-NEXT: {{  $}}
  ; GISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr1
  ; GISEL-GFX11-NEXT:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GISEL-GFX11-NEXT:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GISEL-GFX11-NEXT:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GISEL-GFX11-NEXT:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GISEL-GFX11-NEXT:   [[COPY6:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GISEL-GFX11-NEXT:   [[COPY7:%[0-9]+]]:sreg_32 = COPY $sgpr7
  ; GISEL-GFX11-NEXT:   [[COPY8:%[0-9]+]]:sreg_32 = COPY $sgpr8
  ; GISEL-GFX11-NEXT:   [[COPY9:%[0-9]+]]:sreg_32 = COPY $sgpr9
  ; GISEL-GFX11-NEXT:   [[COPY10:%[0-9]+]]:sreg_32 = COPY $sgpr10
  ; GISEL-GFX11-NEXT:   [[COPY11:%[0-9]+]]:sreg_32 = COPY $sgpr11
  ; GISEL-GFX11-NEXT:   [[COPY12:%[0-9]+]]:sreg_32 = COPY $sgpr12
  ; GISEL-GFX11-NEXT:   [[COPY13:%[0-9]+]]:sreg_32 = COPY $sgpr13
  ; GISEL-GFX11-NEXT:   [[COPY14:%[0-9]+]]:sreg_32 = COPY $sgpr14
  ; GISEL-GFX11-NEXT:   [[COPY15:%[0-9]+]]:sreg_32 = COPY $sgpr15
  ; GISEL-GFX11-NEXT:   [[COPY16:%[0-9]+]]:sreg_32 = COPY $sgpr16
  ; GISEL-GFX11-NEXT:   [[COPY17:%[0-9]+]]:sreg_32 = COPY $sgpr17
  ; GISEL-GFX11-NEXT:   [[COPY18:%[0-9]+]]:sreg_32 = COPY $sgpr18
  ; GISEL-GFX11-NEXT:   [[COPY19:%[0-9]+]]:sreg_32 = COPY $sgpr19
  ; GISEL-GFX11-NEXT:   [[COPY20:%[0-9]+]]:sreg_32 = COPY $sgpr20
  ; GISEL-GFX11-NEXT:   [[COPY21:%[0-9]+]]:sreg_32 = COPY $sgpr21
  ; GISEL-GFX11-NEXT:   [[COPY22:%[0-9]+]]:sreg_32 = COPY $sgpr22
  ; GISEL-GFX11-NEXT:   [[COPY23:%[0-9]+]]:sreg_32 = COPY $sgpr23
  ; GISEL-GFX11-NEXT:   [[COPY24:%[0-9]+]]:sreg_32 = COPY $sgpr24
  ; GISEL-GFX11-NEXT:   [[COPY25:%[0-9]+]]:sreg_32 = COPY $sgpr25
  ; GISEL-GFX11-NEXT:   [[COPY26:%[0-9]+]]:sreg_32 = COPY $sgpr26
  ; GISEL-GFX11-NEXT:   [[COPY27:%[0-9]+]]:sreg_32 = COPY $sgpr27
  ; GISEL-GFX11-NEXT:   [[COPY28:%[0-9]+]]:sreg_32 = COPY $sgpr28
  ; GISEL-GFX11-NEXT:   [[COPY29:%[0-9]+]]:sreg_32 = COPY $sgpr29
  ; GISEL-GFX11-NEXT:   [[COPY30:%[0-9]+]]:sreg_32 = COPY $sgpr30
  ; GISEL-GFX11-NEXT:   [[COPY31:%[0-9]+]]:sreg_32 = COPY $sgpr31
  ; GISEL-GFX11-NEXT:   [[COPY32:%[0-9]+]]:sreg_32 = COPY $sgpr32
  ; GISEL-GFX11-NEXT:   [[COPY33:%[0-9]+]]:sreg_32 = COPY $sgpr33
  ; GISEL-GFX11-NEXT:   [[COPY34:%[0-9]+]]:sreg_32 = COPY $sgpr34
  ; GISEL-GFX11-NEXT:   [[COPY35:%[0-9]+]]:sreg_32 = COPY $sgpr35
  ; GISEL-GFX11-NEXT:   [[COPY36:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX11-NEXT:   [[COPY37:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; GISEL-GFX11-NEXT:   [[COPY38:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; GISEL-GFX11-NEXT:   [[COPY39:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; GISEL-GFX11-NEXT:   [[COPY40:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; GISEL-GFX11-NEXT:   [[COPY41:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; GISEL-GFX11-NEXT:   [[COPY42:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; GISEL-GFX11-NEXT:   [[COPY43:%[0-9]+]]:vgpr_32 = COPY $vgpr15
  ; GISEL-GFX11-NEXT:   [[COPY44:%[0-9]+]]:vgpr_32 = COPY $vgpr16
  ; GISEL-GFX11-NEXT:   [[COPY45:%[0-9]+]]:vgpr_32 = COPY $vgpr17
  ; GISEL-GFX11-NEXT:   [[COPY46:%[0-9]+]]:vgpr_32 = COPY $vgpr18
  ; GISEL-GFX11-NEXT:   [[COPY47:%[0-9]+]]:vgpr_32 = COPY $vgpr19
  ; GISEL-GFX11-NEXT:   [[COPY48:%[0-9]+]]:vgpr_32 = COPY $vgpr20
  ; GISEL-GFX11-NEXT:   [[COPY49:%[0-9]+]]:vgpr_32 = COPY $vgpr21
  ; GISEL-GFX11-NEXT:   [[COPY50:%[0-9]+]]:vgpr_32 = COPY $vgpr22
  ; GISEL-GFX11-NEXT:   [[COPY51:%[0-9]+]]:vgpr_32 = COPY $vgpr23
  ; GISEL-GFX11-NEXT:   [[COPY52:%[0-9]+]]:vgpr_32 = COPY $vgpr24
  ; GISEL-GFX11-NEXT:   [[COPY53:%[0-9]+]]:vgpr_32 = COPY $vgpr25
  ; GISEL-GFX11-NEXT:   [[COPY54:%[0-9]+]]:vgpr_32 = COPY $vgpr26
  ; GISEL-GFX11-NEXT:   [[COPY55:%[0-9]+]]:vgpr_32 = COPY $vgpr27
  ; GISEL-GFX11-NEXT:   [[COPY56:%[0-9]+]]:vgpr_32 = COPY $vgpr28
  ; GISEL-GFX11-NEXT:   [[COPY57:%[0-9]+]]:vgpr_32 = COPY $vgpr29
  ; GISEL-GFX11-NEXT:   [[COPY58:%[0-9]+]]:vgpr_32 = COPY $vgpr30
  ; GISEL-GFX11-NEXT:   [[COPY59:%[0-9]+]]:vgpr_32 = COPY $vgpr31
  ; GISEL-GFX11-NEXT:   [[COPY60:%[0-9]+]]:vgpr_32 = COPY $vgpr32
  ; GISEL-GFX11-NEXT:   [[COPY61:%[0-9]+]]:vgpr_32 = COPY $vgpr33
  ; GISEL-GFX11-NEXT:   [[COPY62:%[0-9]+]]:vgpr_32 = COPY $vgpr34
  ; GISEL-GFX11-NEXT:   [[COPY63:%[0-9]+]]:vgpr_32 = COPY $vgpr35
  ; GISEL-GFX11-NEXT:   [[COPY64:%[0-9]+]]:vgpr_32 = COPY $vgpr36
  ; GISEL-GFX11-NEXT:   [[COPY65:%[0-9]+]]:vgpr_32 = COPY $vgpr37
  ; GISEL-GFX11-NEXT:   [[COPY66:%[0-9]+]]:vgpr_32 = COPY $vgpr38
  ; GISEL-GFX11-NEXT:   [[COPY67:%[0-9]+]]:vgpr_32 = COPY $vgpr39
  ; GISEL-GFX11-NEXT:   [[COPY68:%[0-9]+]]:vgpr_32 = COPY $vgpr40
  ; GISEL-GFX11-NEXT:   [[COPY69:%[0-9]+]]:vgpr_32 = COPY $vgpr41
  ; GISEL-GFX11-NEXT:   [[COPY70:%[0-9]+]]:vgpr_32 = COPY $vgpr42
  ; GISEL-GFX11-NEXT:   [[COPY71:%[0-9]+]]:vgpr_32 = COPY $vgpr43
  ; GISEL-GFX11-NEXT:   [[COPY72:%[0-9]+]]:vgpr_32 = COPY $vgpr44
  ; GISEL-GFX11-NEXT:   [[COPY73:%[0-9]+]]:vgpr_32 = COPY $vgpr45
  ; GISEL-GFX11-NEXT:   [[COPY74:%[0-9]+]]:vgpr_32 = COPY $vgpr46
  ; GISEL-GFX11-NEXT:   [[COPY75:%[0-9]+]]:vgpr_32 = COPY $vgpr47
  ; GISEL-GFX11-NEXT:   [[COPY76:%[0-9]+]]:vgpr_32 = COPY $vgpr48
  ; GISEL-GFX11-NEXT:   [[COPY77:%[0-9]+]]:vgpr_32 = COPY $vgpr49
  ; GISEL-GFX11-NEXT:   [[COPY78:%[0-9]+]]:vgpr_32 = COPY $vgpr50
  ; GISEL-GFX11-NEXT:   [[COPY79:%[0-9]+]]:vgpr_32 = COPY $vgpr51
  ; GISEL-GFX11-NEXT:   [[COPY80:%[0-9]+]]:vgpr_32 = COPY $vgpr52
  ; GISEL-GFX11-NEXT:   [[COPY81:%[0-9]+]]:vgpr_32 = COPY $vgpr53
  ; GISEL-GFX11-NEXT:   [[COPY82:%[0-9]+]]:vgpr_32 = COPY $vgpr54
  ; GISEL-GFX11-NEXT:   [[COPY83:%[0-9]+]]:vgpr_32 = COPY $vgpr55
  ; GISEL-GFX11-NEXT:   [[COPY84:%[0-9]+]]:vgpr_32 = COPY $vgpr56
  ; GISEL-GFX11-NEXT:   [[COPY85:%[0-9]+]]:vgpr_32 = COPY $vgpr57
  ; GISEL-GFX11-NEXT:   [[COPY86:%[0-9]+]]:vgpr_32 = COPY $vgpr58
  ; GISEL-GFX11-NEXT:   [[COPY87:%[0-9]+]]:vgpr_32 = COPY $vgpr59
  ; GISEL-GFX11-NEXT:   [[COPY88:%[0-9]+]]:vgpr_32 = COPY $vgpr60
  ; GISEL-GFX11-NEXT:   [[COPY89:%[0-9]+]]:vgpr_32 = COPY $vgpr61
  ; GISEL-GFX11-NEXT:   [[COPY90:%[0-9]+]]:vgpr_32 = COPY $vgpr62
  ; GISEL-GFX11-NEXT:   [[COPY91:%[0-9]+]]:vgpr_32 = COPY $vgpr63
  ; GISEL-GFX11-NEXT:   [[COPY92:%[0-9]+]]:vgpr_32 = COPY $vgpr64
  ; GISEL-GFX11-NEXT:   [[COPY93:%[0-9]+]]:vgpr_32 = COPY $vgpr65
  ; GISEL-GFX11-NEXT:   [[COPY94:%[0-9]+]]:vgpr_32 = COPY $vgpr66
  ; GISEL-GFX11-NEXT:   [[COPY95:%[0-9]+]]:vgpr_32 = COPY $vgpr67
  ; GISEL-GFX11-NEXT:   [[COPY96:%[0-9]+]]:vgpr_32 = COPY $vgpr68
  ; GISEL-GFX11-NEXT:   [[COPY97:%[0-9]+]]:vgpr_32 = COPY $vgpr69
  ; GISEL-GFX11-NEXT:   [[COPY98:%[0-9]+]]:vgpr_32 = COPY $vgpr70
  ; GISEL-GFX11-NEXT:   [[COPY99:%[0-9]+]]:vgpr_32 = COPY $vgpr71
  ; GISEL-GFX11-NEXT:   [[COPY100:%[0-9]+]]:vgpr_32 = COPY $vgpr72
  ; GISEL-GFX11-NEXT:   [[COPY101:%[0-9]+]]:vgpr_32 = COPY $vgpr73
  ; GISEL-GFX11-NEXT:   [[COPY102:%[0-9]+]]:vgpr_32 = COPY $vgpr74
  ; GISEL-GFX11-NEXT:   [[COPY103:%[0-9]+]]:vgpr_32 = COPY $vgpr75
  ; GISEL-GFX11-NEXT:   [[COPY104:%[0-9]+]]:vgpr_32 = COPY $vgpr76
  ; GISEL-GFX11-NEXT:   [[COPY105:%[0-9]+]]:vgpr_32 = COPY $vgpr77
  ; GISEL-GFX11-NEXT:   [[COPY106:%[0-9]+]]:vgpr_32 = COPY $vgpr78
  ; GISEL-GFX11-NEXT:   [[COPY107:%[0-9]+]]:vgpr_32 = COPY $vgpr79
  ; GISEL-GFX11-NEXT:   [[COPY108:%[0-9]+]]:vgpr_32 = COPY $vgpr80
  ; GISEL-GFX11-NEXT:   [[COPY109:%[0-9]+]]:vgpr_32 = COPY $vgpr81
  ; GISEL-GFX11-NEXT:   [[COPY110:%[0-9]+]]:vgpr_32 = COPY $vgpr82
  ; GISEL-GFX11-NEXT:   [[COPY111:%[0-9]+]]:vgpr_32 = COPY $vgpr83
  ; GISEL-GFX11-NEXT:   [[COPY112:%[0-9]+]]:vgpr_32 = COPY $vgpr84
  ; GISEL-GFX11-NEXT:   [[COPY113:%[0-9]+]]:vgpr_32 = COPY $vgpr85
  ; GISEL-GFX11-NEXT:   [[COPY114:%[0-9]+]]:vgpr_32 = COPY $vgpr86
  ; GISEL-GFX11-NEXT:   [[COPY115:%[0-9]+]]:vgpr_32 = COPY $vgpr87
  ; GISEL-GFX11-NEXT:   [[COPY116:%[0-9]+]]:vgpr_32 = COPY $vgpr88
  ; GISEL-GFX11-NEXT:   [[COPY117:%[0-9]+]]:vgpr_32 = COPY $vgpr89
  ; GISEL-GFX11-NEXT:   [[COPY118:%[0-9]+]]:vgpr_32 = COPY $vgpr90
  ; GISEL-GFX11-NEXT:   [[COPY119:%[0-9]+]]:vgpr_32 = COPY $vgpr91
  ; GISEL-GFX11-NEXT:   [[COPY120:%[0-9]+]]:vgpr_32 = COPY $vgpr92
  ; GISEL-GFX11-NEXT:   [[COPY121:%[0-9]+]]:vgpr_32 = COPY $vgpr93
  ; GISEL-GFX11-NEXT:   [[COPY122:%[0-9]+]]:vgpr_32 = COPY $vgpr94
  ; GISEL-GFX11-NEXT:   [[COPY123:%[0-9]+]]:vgpr_32 = COPY $vgpr95
  ; GISEL-GFX11-NEXT:   [[COPY124:%[0-9]+]]:vgpr_32 = COPY $vgpr96
  ; GISEL-GFX11-NEXT:   [[COPY125:%[0-9]+]]:vgpr_32 = COPY $vgpr97
  ; GISEL-GFX11-NEXT:   [[COPY126:%[0-9]+]]:vgpr_32 = COPY $vgpr98
  ; GISEL-GFX11-NEXT:   [[COPY127:%[0-9]+]]:vgpr_32 = COPY $vgpr99
  ; GISEL-GFX11-NEXT:   [[COPY128:%[0-9]+]]:vgpr_32 = COPY $vgpr100
  ; GISEL-GFX11-NEXT:   [[COPY129:%[0-9]+]]:vgpr_32 = COPY $vgpr101
  ; GISEL-GFX11-NEXT:   [[COPY130:%[0-9]+]]:vgpr_32 = COPY $vgpr102
  ; GISEL-GFX11-NEXT:   [[COPY131:%[0-9]+]]:vgpr_32 = COPY $vgpr103
  ; GISEL-GFX11-NEXT:   [[COPY132:%[0-9]+]]:vgpr_32 = COPY $vgpr104
  ; GISEL-GFX11-NEXT:   [[COPY133:%[0-9]+]]:vgpr_32 = COPY $vgpr105
  ; GISEL-GFX11-NEXT:   [[COPY134:%[0-9]+]]:vgpr_32 = COPY $vgpr106
  ; GISEL-GFX11-NEXT:   [[COPY135:%[0-9]+]]:vgpr_32 = COPY $vgpr107
  ; GISEL-GFX11-NEXT:   [[COPY136:%[0-9]+]]:vgpr_32 = COPY $vgpr108
  ; GISEL-GFX11-NEXT:   [[COPY137:%[0-9]+]]:vgpr_32 = COPY $vgpr109
  ; GISEL-GFX11-NEXT:   [[COPY138:%[0-9]+]]:vgpr_32 = COPY $vgpr110
  ; GISEL-GFX11-NEXT:   [[COPY139:%[0-9]+]]:vgpr_32 = COPY $vgpr111
  ; GISEL-GFX11-NEXT:   [[COPY140:%[0-9]+]]:vgpr_32 = COPY $vgpr112
  ; GISEL-GFX11-NEXT:   [[COPY141:%[0-9]+]]:vgpr_32 = COPY $vgpr113
  ; GISEL-GFX11-NEXT:   [[COPY142:%[0-9]+]]:vgpr_32 = COPY $vgpr114
  ; GISEL-GFX11-NEXT:   [[COPY143:%[0-9]+]]:vgpr_32 = COPY $vgpr115
  ; GISEL-GFX11-NEXT:   [[COPY144:%[0-9]+]]:vgpr_32 = COPY $vgpr116
  ; GISEL-GFX11-NEXT:   [[COPY145:%[0-9]+]]:vgpr_32 = COPY $vgpr117
  ; GISEL-GFX11-NEXT:   [[COPY146:%[0-9]+]]:vgpr_32 = COPY $vgpr118
  ; GISEL-GFX11-NEXT:   [[COPY147:%[0-9]+]]:vgpr_32 = COPY $vgpr119
  ; GISEL-GFX11-NEXT:   [[COPY148:%[0-9]+]]:vgpr_32 = COPY $vgpr120
  ; GISEL-GFX11-NEXT:   [[COPY149:%[0-9]+]]:vgpr_32 = COPY $vgpr121
  ; GISEL-GFX11-NEXT:   [[COPY150:%[0-9]+]]:vgpr_32 = COPY $vgpr122
  ; GISEL-GFX11-NEXT:   [[COPY151:%[0-9]+]]:vgpr_32 = COPY $vgpr123
  ; GISEL-GFX11-NEXT:   [[COPY152:%[0-9]+]]:vgpr_32 = COPY $vgpr124
  ; GISEL-GFX11-NEXT:   [[COPY153:%[0-9]+]]:vgpr_32 = COPY $vgpr125
  ; GISEL-GFX11-NEXT:   [[COPY154:%[0-9]+]]:vgpr_32 = COPY $vgpr126
  ; GISEL-GFX11-NEXT:   [[COPY155:%[0-9]+]]:vgpr_32 = COPY $vgpr127
  ; GISEL-GFX11-NEXT:   [[COPY156:%[0-9]+]]:vgpr_32 = COPY $vgpr128
  ; GISEL-GFX11-NEXT:   [[COPY157:%[0-9]+]]:vgpr_32 = COPY $vgpr129
  ; GISEL-GFX11-NEXT:   [[COPY158:%[0-9]+]]:vgpr_32 = COPY $vgpr130
  ; GISEL-GFX11-NEXT:   [[COPY159:%[0-9]+]]:vgpr_32 = COPY $vgpr131
  ; GISEL-GFX11-NEXT:   [[COPY160:%[0-9]+]]:vgpr_32 = COPY $vgpr132
  ; GISEL-GFX11-NEXT:   [[COPY161:%[0-9]+]]:vgpr_32 = COPY $vgpr133
  ; GISEL-GFX11-NEXT:   [[COPY162:%[0-9]+]]:vgpr_32 = COPY $vgpr134
  ; GISEL-GFX11-NEXT:   [[COPY163:%[0-9]+]]:vgpr_32 = COPY $vgpr135
  ; GISEL-GFX11-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX11-NEXT:   [[COPY164:%[0-9]+]]:sreg_32_xexec_hi = COPY $sgpr32
  ; GISEL-GFX11-NEXT:   [[COPY165:%[0-9]+]]:vgpr_32 = COPY [[COPY32]]
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY165]], [[COPY164]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 4
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   [[COPY166:%[0-9]+]]:vgpr_32 = COPY [[COPY33]]
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY166]], [[S_ADD_U32_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 4, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 8
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_1:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_1]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   [[COPY167:%[0-9]+]]:vgpr_32 = COPY [[COPY34]]
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY167]], [[S_ADD_U32_1]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 8, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_2:%[0-9]+]]:sreg_32 = S_MOV_B32 12
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_2:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_2]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   [[COPY168:%[0-9]+]]:vgpr_32 = COPY [[COPY35]]
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY168]], [[S_ADD_U32_2]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 12, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_3:%[0-9]+]]:sreg_32 = S_MOV_B32 16
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_3:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_3]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY36]], [[S_ADD_U32_3]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 16, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_4:%[0-9]+]]:sreg_32 = S_MOV_B32 20
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_4:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_4]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY37]], [[S_ADD_U32_4]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 20, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_5:%[0-9]+]]:sreg_32 = S_MOV_B32 24
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_5:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_5]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY38]], [[S_ADD_U32_5]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 24, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_6:%[0-9]+]]:sreg_32 = S_MOV_B32 28
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_6:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_6]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY39]], [[S_ADD_U32_6]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 28, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_7:%[0-9]+]]:sreg_32 = S_MOV_B32 32
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_7:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_7]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY40]], [[S_ADD_U32_7]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 32, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_8:%[0-9]+]]:sreg_32 = S_MOV_B32 36
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_8:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_8]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY41]], [[S_ADD_U32_8]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 36, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_9:%[0-9]+]]:sreg_32 = S_MOV_B32 40
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_9:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_9]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY42]], [[S_ADD_U32_9]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 40, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_10:%[0-9]+]]:sreg_32 = S_MOV_B32 44
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_10:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_10]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY43]], [[S_ADD_U32_10]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 44, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_11:%[0-9]+]]:sreg_32 = S_MOV_B32 48
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_11:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_11]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY44]], [[S_ADD_U32_11]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 48, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_12:%[0-9]+]]:sreg_32 = S_MOV_B32 52
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_12:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_12]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY45]], [[S_ADD_U32_12]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 52, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_13:%[0-9]+]]:sreg_32 = S_MOV_B32 56
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_13:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_13]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY46]], [[S_ADD_U32_13]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 56, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_14:%[0-9]+]]:sreg_32 = S_MOV_B32 60
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_14:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_14]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY47]], [[S_ADD_U32_14]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 60, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_15:%[0-9]+]]:sreg_32 = S_MOV_B32 64
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_15:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_15]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY48]], [[S_ADD_U32_15]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 64, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_16:%[0-9]+]]:sreg_32 = S_MOV_B32 68
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_16:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_16]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY49]], [[S_ADD_U32_16]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 68, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_17:%[0-9]+]]:sreg_32 = S_MOV_B32 72
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_17:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_17]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY50]], [[S_ADD_U32_17]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 72, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_18:%[0-9]+]]:sreg_32 = S_MOV_B32 76
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_18:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_18]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY51]], [[S_ADD_U32_18]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 76, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_19:%[0-9]+]]:sreg_32 = S_MOV_B32 80
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_19:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_19]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY52]], [[S_ADD_U32_19]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 80, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_20:%[0-9]+]]:sreg_32 = S_MOV_B32 84
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_20:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_20]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY53]], [[S_ADD_U32_20]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 84, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_21:%[0-9]+]]:sreg_32 = S_MOV_B32 88
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_21:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_21]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY54]], [[S_ADD_U32_21]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 88, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_22:%[0-9]+]]:sreg_32 = S_MOV_B32 92
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_22:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_22]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY55]], [[S_ADD_U32_22]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 92, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_23:%[0-9]+]]:sreg_32 = S_MOV_B32 96
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_23:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_23]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY56]], [[S_ADD_U32_23]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 96, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_24:%[0-9]+]]:sreg_32 = S_MOV_B32 100
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_24:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_24]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY57]], [[S_ADD_U32_24]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 100, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_25:%[0-9]+]]:sreg_32 = S_MOV_B32 104
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_25:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_25]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY58]], [[S_ADD_U32_25]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 104, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_26:%[0-9]+]]:sreg_32 = S_MOV_B32 108
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_26:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_26]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY59]], [[S_ADD_U32_26]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 108, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_27:%[0-9]+]]:sreg_32 = S_MOV_B32 112
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_27:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_27]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY60]], [[S_ADD_U32_27]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 112, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_28:%[0-9]+]]:sreg_32 = S_MOV_B32 116
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_28:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_28]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY61]], [[S_ADD_U32_28]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 116, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_29:%[0-9]+]]:sreg_32 = S_MOV_B32 120
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_29:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_29]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY62]], [[S_ADD_U32_29]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 120, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_30:%[0-9]+]]:sreg_32 = S_MOV_B32 124
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_30:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_30]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY63]], [[S_ADD_U32_30]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 124, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_31:%[0-9]+]]:sreg_32 = S_MOV_B32 128
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_31:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_31]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY64]], [[S_ADD_U32_31]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 128, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_32:%[0-9]+]]:sreg_32 = S_MOV_B32 132
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_32:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_32]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY65]], [[S_ADD_U32_32]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 132, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_33:%[0-9]+]]:sreg_32 = S_MOV_B32 136
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_33:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_33]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY66]], [[S_ADD_U32_33]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 136, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_34:%[0-9]+]]:sreg_32 = S_MOV_B32 140
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_34:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_34]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY67]], [[S_ADD_U32_34]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 140, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_35:%[0-9]+]]:sreg_32 = S_MOV_B32 144
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_35:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_35]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY68]], [[S_ADD_U32_35]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 144, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_36:%[0-9]+]]:sreg_32 = S_MOV_B32 148
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_36:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_36]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY69]], [[S_ADD_U32_36]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 148, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_37:%[0-9]+]]:sreg_32 = S_MOV_B32 152
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_37:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_37]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY70]], [[S_ADD_U32_37]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 152, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_38:%[0-9]+]]:sreg_32 = S_MOV_B32 156
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_38:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_38]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY71]], [[S_ADD_U32_38]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 156, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_39:%[0-9]+]]:sreg_32 = S_MOV_B32 160
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_39:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_39]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY72]], [[S_ADD_U32_39]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 160, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_40:%[0-9]+]]:sreg_32 = S_MOV_B32 164
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_40:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_40]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY73]], [[S_ADD_U32_40]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 164, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_41:%[0-9]+]]:sreg_32 = S_MOV_B32 168
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_41:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_41]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY74]], [[S_ADD_U32_41]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 168, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_42:%[0-9]+]]:sreg_32 = S_MOV_B32 172
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_42:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_42]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY75]], [[S_ADD_U32_42]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 172, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_43:%[0-9]+]]:sreg_32 = S_MOV_B32 176
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_43:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_43]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY76]], [[S_ADD_U32_43]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 176, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_44:%[0-9]+]]:sreg_32 = S_MOV_B32 180
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_44:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_44]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY77]], [[S_ADD_U32_44]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 180, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_45:%[0-9]+]]:sreg_32 = S_MOV_B32 184
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_45:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_45]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY78]], [[S_ADD_U32_45]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 184, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_46:%[0-9]+]]:sreg_32 = S_MOV_B32 188
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_46:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_46]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY79]], [[S_ADD_U32_46]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 188, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_47:%[0-9]+]]:sreg_32 = S_MOV_B32 192
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_47:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_47]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY80]], [[S_ADD_U32_47]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 192, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_48:%[0-9]+]]:sreg_32 = S_MOV_B32 196
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_48:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_48]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY81]], [[S_ADD_U32_48]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 196, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_49:%[0-9]+]]:sreg_32 = S_MOV_B32 200
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_49:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_49]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY82]], [[S_ADD_U32_49]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 200, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_50:%[0-9]+]]:sreg_32 = S_MOV_B32 204
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_50:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_50]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY83]], [[S_ADD_U32_50]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 204, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_51:%[0-9]+]]:sreg_32 = S_MOV_B32 208
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_51:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_51]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY84]], [[S_ADD_U32_51]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 208, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_52:%[0-9]+]]:sreg_32 = S_MOV_B32 212
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_52:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_52]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY85]], [[S_ADD_U32_52]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 212, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_53:%[0-9]+]]:sreg_32 = S_MOV_B32 216
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_53:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_53]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY86]], [[S_ADD_U32_53]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 216, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_54:%[0-9]+]]:sreg_32 = S_MOV_B32 220
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_54:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_54]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY87]], [[S_ADD_U32_54]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 220, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_55:%[0-9]+]]:sreg_32 = S_MOV_B32 224
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_55:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_55]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY88]], [[S_ADD_U32_55]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 224, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_56:%[0-9]+]]:sreg_32 = S_MOV_B32 228
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_56:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_56]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY89]], [[S_ADD_U32_56]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 228, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_57:%[0-9]+]]:sreg_32 = S_MOV_B32 232
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_57:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_57]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY90]], [[S_ADD_U32_57]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 232, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_58:%[0-9]+]]:sreg_32 = S_MOV_B32 236
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_58:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_58]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY91]], [[S_ADD_U32_58]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 236, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_59:%[0-9]+]]:sreg_32 = S_MOV_B32 240
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_59:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_59]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY92]], [[S_ADD_U32_59]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 240, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_60:%[0-9]+]]:sreg_32 = S_MOV_B32 244
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_60:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_60]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY93]], [[S_ADD_U32_60]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 244, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_61:%[0-9]+]]:sreg_32 = S_MOV_B32 248
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_61:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_61]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY94]], [[S_ADD_U32_61]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 248, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_62:%[0-9]+]]:sreg_32 = S_MOV_B32 252
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_62:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_62]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY95]], [[S_ADD_U32_62]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 252, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_63:%[0-9]+]]:sreg_32 = S_MOV_B32 256
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_63:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_63]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY96]], [[S_ADD_U32_63]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 256, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_64:%[0-9]+]]:sreg_32 = S_MOV_B32 260
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_64:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_64]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY97]], [[S_ADD_U32_64]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 260, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_65:%[0-9]+]]:sreg_32 = S_MOV_B32 264
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_65:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_65]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY98]], [[S_ADD_U32_65]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 264, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_66:%[0-9]+]]:sreg_32 = S_MOV_B32 268
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_66:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_66]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY99]], [[S_ADD_U32_66]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 268, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_67:%[0-9]+]]:sreg_32 = S_MOV_B32 272
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_67:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_67]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY100]], [[S_ADD_U32_67]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 272, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_68:%[0-9]+]]:sreg_32 = S_MOV_B32 276
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_68:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_68]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY101]], [[S_ADD_U32_68]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 276, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_69:%[0-9]+]]:sreg_32 = S_MOV_B32 280
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_69:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_69]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY102]], [[S_ADD_U32_69]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 280, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_70:%[0-9]+]]:sreg_32 = S_MOV_B32 284
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_70:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_70]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY103]], [[S_ADD_U32_70]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 284, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_71:%[0-9]+]]:sreg_32 = S_MOV_B32 288
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_71:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_71]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY104]], [[S_ADD_U32_71]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 288, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_72:%[0-9]+]]:sreg_32 = S_MOV_B32 292
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_72:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_72]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY105]], [[S_ADD_U32_72]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 292, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_73:%[0-9]+]]:sreg_32 = S_MOV_B32 296
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_73:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_73]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY106]], [[S_ADD_U32_73]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 296, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_74:%[0-9]+]]:sreg_32 = S_MOV_B32 300
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_74:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_74]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY107]], [[S_ADD_U32_74]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 300, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_75:%[0-9]+]]:sreg_32 = S_MOV_B32 304
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_75:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_75]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY108]], [[S_ADD_U32_75]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 304, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_76:%[0-9]+]]:sreg_32 = S_MOV_B32 308
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_76:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_76]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY109]], [[S_ADD_U32_76]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 308, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_77:%[0-9]+]]:sreg_32 = S_MOV_B32 312
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_77:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_77]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY110]], [[S_ADD_U32_77]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 312, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_78:%[0-9]+]]:sreg_32 = S_MOV_B32 316
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_78:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_78]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY111]], [[S_ADD_U32_78]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 316, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_79:%[0-9]+]]:sreg_32 = S_MOV_B32 320
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_79:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_79]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY112]], [[S_ADD_U32_79]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 320, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_80:%[0-9]+]]:sreg_32 = S_MOV_B32 324
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_80:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_80]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY113]], [[S_ADD_U32_80]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 324, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_81:%[0-9]+]]:sreg_32 = S_MOV_B32 328
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_81:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_81]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY114]], [[S_ADD_U32_81]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 328, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_82:%[0-9]+]]:sreg_32 = S_MOV_B32 332
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_82:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_82]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY115]], [[S_ADD_U32_82]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 332, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_83:%[0-9]+]]:sreg_32 = S_MOV_B32 336
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_83:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_83]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY116]], [[S_ADD_U32_83]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 336, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_84:%[0-9]+]]:sreg_32 = S_MOV_B32 340
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_84:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_84]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY117]], [[S_ADD_U32_84]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 340, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_85:%[0-9]+]]:sreg_32 = S_MOV_B32 344
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_85:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_85]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY118]], [[S_ADD_U32_85]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 344, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_86:%[0-9]+]]:sreg_32 = S_MOV_B32 348
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_86:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_86]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY119]], [[S_ADD_U32_86]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 348, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_87:%[0-9]+]]:sreg_32 = S_MOV_B32 352
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_87:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_87]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY120]], [[S_ADD_U32_87]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 352, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_88:%[0-9]+]]:sreg_32 = S_MOV_B32 356
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_88:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_88]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY121]], [[S_ADD_U32_88]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 356, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_89:%[0-9]+]]:sreg_32 = S_MOV_B32 360
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_89:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_89]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY122]], [[S_ADD_U32_89]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 360, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_90:%[0-9]+]]:sreg_32 = S_MOV_B32 364
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_90:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_90]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY123]], [[S_ADD_U32_90]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 364, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_91:%[0-9]+]]:sreg_32 = S_MOV_B32 368
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_91:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_91]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY124]], [[S_ADD_U32_91]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 368, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_92:%[0-9]+]]:sreg_32 = S_MOV_B32 372
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_92:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_92]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY125]], [[S_ADD_U32_92]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 372, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_93:%[0-9]+]]:sreg_32 = S_MOV_B32 376
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_93:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_93]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY126]], [[S_ADD_U32_93]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 376, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_94:%[0-9]+]]:sreg_32 = S_MOV_B32 380
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_94:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_94]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY127]], [[S_ADD_U32_94]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 380, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_95:%[0-9]+]]:sreg_32 = S_MOV_B32 384
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_95:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_95]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY128]], [[S_ADD_U32_95]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 384, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_96:%[0-9]+]]:sreg_32 = S_MOV_B32 388
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_96:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_96]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY129]], [[S_ADD_U32_96]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 388, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_97:%[0-9]+]]:sreg_32 = S_MOV_B32 392
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_97:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_97]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY130]], [[S_ADD_U32_97]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 392, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_98:%[0-9]+]]:sreg_32 = S_MOV_B32 396
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_98:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_98]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY131]], [[S_ADD_U32_98]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 396, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_99:%[0-9]+]]:sreg_32 = S_MOV_B32 400
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_99:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_99]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY132]], [[S_ADD_U32_99]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 400, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_100:%[0-9]+]]:sreg_32 = S_MOV_B32 404
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_100:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_100]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY133]], [[S_ADD_U32_100]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 404, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_101:%[0-9]+]]:sreg_32 = S_MOV_B32 408
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_101:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_101]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY134]], [[S_ADD_U32_101]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 408, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_102:%[0-9]+]]:sreg_32 = S_MOV_B32 412
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_102:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_102]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY135]], [[S_ADD_U32_102]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 412, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_103:%[0-9]+]]:sreg_32 = S_MOV_B32 416
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_103:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_103]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY136]], [[S_ADD_U32_103]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 416, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_104:%[0-9]+]]:sreg_32 = S_MOV_B32 420
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_104:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_104]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY137]], [[S_ADD_U32_104]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 420, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_105:%[0-9]+]]:sreg_32 = S_MOV_B32 424
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_105:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_105]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY138]], [[S_ADD_U32_105]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 424, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_106:%[0-9]+]]:sreg_32 = S_MOV_B32 428
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_106:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_106]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY139]], [[S_ADD_U32_106]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 428, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_107:%[0-9]+]]:sreg_32 = S_MOV_B32 432
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_107:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_107]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY140]], [[S_ADD_U32_107]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 432, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_108:%[0-9]+]]:sreg_32 = S_MOV_B32 436
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_108:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_108]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY141]], [[S_ADD_U32_108]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 436, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_109:%[0-9]+]]:sreg_32 = S_MOV_B32 440
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_109:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_109]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY142]], [[S_ADD_U32_109]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 440, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_110:%[0-9]+]]:sreg_32 = S_MOV_B32 444
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_110:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_110]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY143]], [[S_ADD_U32_110]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 444, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_111:%[0-9]+]]:sreg_32 = S_MOV_B32 448
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_111:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_111]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY144]], [[S_ADD_U32_111]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 448, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_112:%[0-9]+]]:sreg_32 = S_MOV_B32 452
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_112:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_112]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY145]], [[S_ADD_U32_112]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 452, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_113:%[0-9]+]]:sreg_32 = S_MOV_B32 456
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_113:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_113]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY146]], [[S_ADD_U32_113]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 456, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_114:%[0-9]+]]:sreg_32 = S_MOV_B32 460
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_114:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_114]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY147]], [[S_ADD_U32_114]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 460, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_115:%[0-9]+]]:sreg_32 = S_MOV_B32 464
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_115:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_115]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY148]], [[S_ADD_U32_115]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 464, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_116:%[0-9]+]]:sreg_32 = S_MOV_B32 468
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_116:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_116]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY149]], [[S_ADD_U32_116]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 468, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_117:%[0-9]+]]:sreg_32 = S_MOV_B32 472
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_117:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_117]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY150]], [[S_ADD_U32_117]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 472, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_118:%[0-9]+]]:sreg_32 = S_MOV_B32 476
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_118:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_118]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY151]], [[S_ADD_U32_118]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 476, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_119:%[0-9]+]]:sreg_32 = S_MOV_B32 480
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_119:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_119]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY152]], [[S_ADD_U32_119]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 480, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_120:%[0-9]+]]:sreg_32 = S_MOV_B32 484
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_120:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_120]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY153]], [[S_ADD_U32_120]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 484, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_121:%[0-9]+]]:sreg_32 = S_MOV_B32 488
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_121:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_121]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY154]], [[S_ADD_U32_121]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 488, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_122:%[0-9]+]]:sreg_32 = S_MOV_B32 492
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_122:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_122]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY155]], [[S_ADD_U32_122]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 492, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_123:%[0-9]+]]:sreg_32 = S_MOV_B32 496
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_123:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_123]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY156]], [[S_ADD_U32_123]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 496, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_124:%[0-9]+]]:sreg_32 = S_MOV_B32 500
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_124:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_124]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY157]], [[S_ADD_U32_124]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 500, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_125:%[0-9]+]]:sreg_32 = S_MOV_B32 504
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_125:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_125]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY158]], [[S_ADD_U32_125]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 504, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_126:%[0-9]+]]:sreg_32 = S_MOV_B32 508
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_126:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_126]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY159]], [[S_ADD_U32_126]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 508, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_127:%[0-9]+]]:sreg_32 = S_MOV_B32 512
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_127:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_127]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY160]], [[S_ADD_U32_127]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 512, align 16, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_128:%[0-9]+]]:sreg_32 = S_MOV_B32 516
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_128:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_128]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY161]], [[S_ADD_U32_128]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 516, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_129:%[0-9]+]]:sreg_32 = S_MOV_B32 520
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_129:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_129]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY162]], [[S_ADD_U32_129]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 520, align 8, addrspace 5)
  ; GISEL-GFX11-NEXT:   [[S_MOV_B32_130:%[0-9]+]]:sreg_32 = S_MOV_B32 524
  ; GISEL-GFX11-NEXT:   [[S_ADD_U32_130:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_U32 [[COPY164]], [[S_MOV_B32_130]], implicit-def dead $scc
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY163]], [[S_ADD_U32_130]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 524, addrspace 5)
  ; GISEL-GFX11-NEXT:   $vgpr0 = COPY [[COPY]]
  ; GISEL-GFX11-NEXT:   $vgpr1 = COPY [[COPY1]]
  ; GISEL-GFX11-NEXT:   $vgpr2 = COPY [[COPY2]]
  ; GISEL-GFX11-NEXT:   $vgpr3 = COPY [[COPY3]]
  ; GISEL-GFX11-NEXT:   $vgpr4 = COPY [[COPY4]]
  ; GISEL-GFX11-NEXT:   $vgpr5 = COPY [[COPY5]]
  ; GISEL-GFX11-NEXT:   $vgpr6 = COPY [[COPY6]]
  ; GISEL-GFX11-NEXT:   $vgpr7 = COPY [[COPY7]]
  ; GISEL-GFX11-NEXT:   $vgpr8 = COPY [[COPY8]]
  ; GISEL-GFX11-NEXT:   $vgpr9 = COPY [[COPY9]]
  ; GISEL-GFX11-NEXT:   $vgpr10 = COPY [[COPY10]]
  ; GISEL-GFX11-NEXT:   $vgpr11 = COPY [[COPY11]]
  ; GISEL-GFX11-NEXT:   $vgpr12 = COPY [[COPY12]]
  ; GISEL-GFX11-NEXT:   $vgpr13 = COPY [[COPY13]]
  ; GISEL-GFX11-NEXT:   $vgpr14 = COPY [[COPY14]]
  ; GISEL-GFX11-NEXT:   $vgpr15 = COPY [[COPY15]]
  ; GISEL-GFX11-NEXT:   $vgpr16 = COPY [[COPY16]]
  ; GISEL-GFX11-NEXT:   $vgpr17 = COPY [[COPY17]]
  ; GISEL-GFX11-NEXT:   $vgpr18 = COPY [[COPY18]]
  ; GISEL-GFX11-NEXT:   $vgpr19 = COPY [[COPY19]]
  ; GISEL-GFX11-NEXT:   $vgpr20 = COPY [[COPY20]]
  ; GISEL-GFX11-NEXT:   $vgpr21 = COPY [[COPY21]]
  ; GISEL-GFX11-NEXT:   $vgpr22 = COPY [[COPY22]]
  ; GISEL-GFX11-NEXT:   $vgpr23 = COPY [[COPY23]]
  ; GISEL-GFX11-NEXT:   $vgpr24 = COPY [[COPY24]]
  ; GISEL-GFX11-NEXT:   $vgpr25 = COPY [[COPY25]]
  ; GISEL-GFX11-NEXT:   $vgpr26 = COPY [[COPY26]]
  ; GISEL-GFX11-NEXT:   $vgpr27 = COPY [[COPY27]]
  ; GISEL-GFX11-NEXT:   $vgpr28 = COPY [[COPY28]]
  ; GISEL-GFX11-NEXT:   $vgpr29 = COPY [[COPY29]]
  ; GISEL-GFX11-NEXT:   $vgpr30 = COPY [[COPY30]]
  ; GISEL-GFX11-NEXT:   $vgpr31 = COPY [[COPY31]]
  ; GISEL-GFX11-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def $scc
  ; GISEL-GFX11-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (p0) from got, addrspace 4)
  ; GISEL-GFX11-NEXT:   $sgpr30_sgpr31 = noconvergent SI_CALL [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15, implicit $vgpr16, implicit $vgpr17, implicit $vgpr18, implicit $vgpr19, implicit $vgpr20, implicit $vgpr21, implicit $vgpr22, implicit $vgpr23, implicit $vgpr24, implicit $vgpr25, implicit $vgpr26, implicit $vgpr27, implicit $vgpr28, implicit $vgpr29, implicit $vgpr30, implicit $vgpr31
  ; GISEL-GFX11-NEXT:   ADJCALLSTACKDOWN 0, 528, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; GISEL-GFX10-LABEL: name: amdgpu_cs_chain_many_regs
  ; GISEL-GFX10: bb.1 (%ir-block.0):
  ; GISEL-GFX10-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $sgpr14, $sgpr15, $sgpr16, $sgpr17, $sgpr18, $sgpr19, $sgpr20, $sgpr21, $sgpr22, $sgpr23, $sgpr24, $sgpr25, $sgpr26, $sgpr27, $sgpr28, $sgpr29, $sgpr30, $sgpr31, $sgpr32, $sgpr33, $sgpr34, $sgpr35, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $vgpr32, $vgpr33, $vgpr34, $vgpr35, $vgpr36, $vgpr37, $vgpr38, $vgpr39, $vgpr40, $vgpr41, $vgpr42, $vgpr43, $vgpr44, $vgpr45, $vgpr46, $vgpr47, $vgpr48, $vgpr49, $vgpr50, $vgpr51, $vgpr52, $vgpr53, $vgpr54, $vgpr55, $vgpr56, $vgpr57, $vgpr58, $vgpr59, $vgpr60, $vgpr61, $vgpr62, $vgpr63, $vgpr64, $vgpr65, $vgpr66, $vgpr67, $vgpr68, $vgpr69, $vgpr70, $vgpr71, $vgpr72, $vgpr73, $vgpr74, $vgpr75, $vgpr76, $vgpr77, $vgpr78, $vgpr79, $vgpr80, $vgpr81, $vgpr82, $vgpr83, $vgpr84, $vgpr85, $vgpr86, $vgpr87, $vgpr88, $vgpr89, $vgpr90, $vgpr91, $vgpr92, $vgpr93, $vgpr94, $vgpr95, $vgpr96, $vgpr97, $vgpr98, $vgpr99, $vgpr100, $vgpr101, $vgpr102, $vgpr103, $vgpr104, $vgpr105, $vgpr106, $vgpr107, $vgpr108, $vgpr109, $vgpr110, $vgpr111, $vgpr112, $vgpr113, $vgpr114, $vgpr115, $vgpr116, $vgpr117, $vgpr118, $vgpr119, $vgpr120, $vgpr121, $vgpr122, $vgpr123, $vgpr124, $vgpr125, $vgpr126, $vgpr127, $vgpr128, $vgpr129, $vgpr130, $vgpr131, $vgpr132, $vgpr133, $vgpr134, $vgpr135
  ; GISEL-GFX10-NEXT: {{  $}}
  ; GISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr1
  ; GISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GISEL-GFX10-NEXT:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GISEL-GFX10-NEXT:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GISEL-GFX10-NEXT:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GISEL-GFX10-NEXT:   [[COPY6:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GISEL-GFX10-NEXT:   [[COPY7:%[0-9]+]]:sreg_32 = COPY $sgpr7
  ; GISEL-GFX10-NEXT:   [[COPY8:%[0-9]+]]:sreg_32 = COPY $sgpr8
  ; GISEL-GFX10-NEXT:   [[COPY9:%[0-9]+]]:sreg_32 = COPY $sgpr9
  ; GISEL-GFX10-NEXT:   [[COPY10:%[0-9]+]]:sreg_32 = COPY $sgpr10
  ; GISEL-GFX10-NEXT:   [[COPY11:%[0-9]+]]:sreg_32 = COPY $sgpr11
  ; GISEL-GFX10-NEXT:   [[COPY12:%[0-9]+]]:sreg_32 = COPY $sgpr12
  ; GISEL-GFX10-NEXT:   [[COPY13:%[0-9]+]]:sreg_32 = COPY $sgpr13
  ; GISEL-GFX10-NEXT:   [[COPY14:%[0-9]+]]:sreg_32 = COPY $sgpr14
  ; GISEL-GFX10-NEXT:   [[COPY15:%[0-9]+]]:sreg_32 = COPY $sgpr15
  ; GISEL-GFX10-NEXT:   [[COPY16:%[0-9]+]]:sreg_32 = COPY $sgpr16
  ; GISEL-GFX10-NEXT:   [[COPY17:%[0-9]+]]:sreg_32 = COPY $sgpr17
  ; GISEL-GFX10-NEXT:   [[COPY18:%[0-9]+]]:sreg_32 = COPY $sgpr18
  ; GISEL-GFX10-NEXT:   [[COPY19:%[0-9]+]]:sreg_32 = COPY $sgpr19
  ; GISEL-GFX10-NEXT:   [[COPY20:%[0-9]+]]:sreg_32 = COPY $sgpr20
  ; GISEL-GFX10-NEXT:   [[COPY21:%[0-9]+]]:sreg_32 = COPY $sgpr21
  ; GISEL-GFX10-NEXT:   [[COPY22:%[0-9]+]]:sreg_32 = COPY $sgpr22
  ; GISEL-GFX10-NEXT:   [[COPY23:%[0-9]+]]:sreg_32 = COPY $sgpr23
  ; GISEL-GFX10-NEXT:   [[COPY24:%[0-9]+]]:sreg_32 = COPY $sgpr24
  ; GISEL-GFX10-NEXT:   [[COPY25:%[0-9]+]]:sreg_32 = COPY $sgpr25
  ; GISEL-GFX10-NEXT:   [[COPY26:%[0-9]+]]:sreg_32 = COPY $sgpr26
  ; GISEL-GFX10-NEXT:   [[COPY27:%[0-9]+]]:sreg_32 = COPY $sgpr27
  ; GISEL-GFX10-NEXT:   [[COPY28:%[0-9]+]]:sreg_32 = COPY $sgpr28
  ; GISEL-GFX10-NEXT:   [[COPY29:%[0-9]+]]:sreg_32 = COPY $sgpr29
  ; GISEL-GFX10-NEXT:   [[COPY30:%[0-9]+]]:sreg_32 = COPY $sgpr30
  ; GISEL-GFX10-NEXT:   [[COPY31:%[0-9]+]]:sreg_32 = COPY $sgpr31
  ; GISEL-GFX10-NEXT:   [[COPY32:%[0-9]+]]:sreg_32 = COPY $sgpr32
  ; GISEL-GFX10-NEXT:   [[COPY33:%[0-9]+]]:sreg_32 = COPY $sgpr33
  ; GISEL-GFX10-NEXT:   [[COPY34:%[0-9]+]]:sreg_32 = COPY $sgpr34
  ; GISEL-GFX10-NEXT:   [[COPY35:%[0-9]+]]:sreg_32 = COPY $sgpr35
  ; GISEL-GFX10-NEXT:   [[COPY36:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX10-NEXT:   [[COPY37:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; GISEL-GFX10-NEXT:   [[COPY38:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; GISEL-GFX10-NEXT:   [[COPY39:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; GISEL-GFX10-NEXT:   [[COPY40:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; GISEL-GFX10-NEXT:   [[COPY41:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; GISEL-GFX10-NEXT:   [[COPY42:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; GISEL-GFX10-NEXT:   [[COPY43:%[0-9]+]]:vgpr_32 = COPY $vgpr15
  ; GISEL-GFX10-NEXT:   [[COPY44:%[0-9]+]]:vgpr_32 = COPY $vgpr16
  ; GISEL-GFX10-NEXT:   [[COPY45:%[0-9]+]]:vgpr_32 = COPY $vgpr17
  ; GISEL-GFX10-NEXT:   [[COPY46:%[0-9]+]]:vgpr_32 = COPY $vgpr18
  ; GISEL-GFX10-NEXT:   [[COPY47:%[0-9]+]]:vgpr_32 = COPY $vgpr19
  ; GISEL-GFX10-NEXT:   [[COPY48:%[0-9]+]]:vgpr_32 = COPY $vgpr20
  ; GISEL-GFX10-NEXT:   [[COPY49:%[0-9]+]]:vgpr_32 = COPY $vgpr21
  ; GISEL-GFX10-NEXT:   [[COPY50:%[0-9]+]]:vgpr_32 = COPY $vgpr22
  ; GISEL-GFX10-NEXT:   [[COPY51:%[0-9]+]]:vgpr_32 = COPY $vgpr23
  ; GISEL-GFX10-NEXT:   [[COPY52:%[0-9]+]]:vgpr_32 = COPY $vgpr24
  ; GISEL-GFX10-NEXT:   [[COPY53:%[0-9]+]]:vgpr_32 = COPY $vgpr25
  ; GISEL-GFX10-NEXT:   [[COPY54:%[0-9]+]]:vgpr_32 = COPY $vgpr26
  ; GISEL-GFX10-NEXT:   [[COPY55:%[0-9]+]]:vgpr_32 = COPY $vgpr27
  ; GISEL-GFX10-NEXT:   [[COPY56:%[0-9]+]]:vgpr_32 = COPY $vgpr28
  ; GISEL-GFX10-NEXT:   [[COPY57:%[0-9]+]]:vgpr_32 = COPY $vgpr29
  ; GISEL-GFX10-NEXT:   [[COPY58:%[0-9]+]]:vgpr_32 = COPY $vgpr30
  ; GISEL-GFX10-NEXT:   [[COPY59:%[0-9]+]]:vgpr_32 = COPY $vgpr31
  ; GISEL-GFX10-NEXT:   [[COPY60:%[0-9]+]]:vgpr_32 = COPY $vgpr32
  ; GISEL-GFX10-NEXT:   [[COPY61:%[0-9]+]]:vgpr_32 = COPY $vgpr33
  ; GISEL-GFX10-NEXT:   [[COPY62:%[0-9]+]]:vgpr_32 = COPY $vgpr34
  ; GISEL-GFX10-NEXT:   [[COPY63:%[0-9]+]]:vgpr_32 = COPY $vgpr35
  ; GISEL-GFX10-NEXT:   [[COPY64:%[0-9]+]]:vgpr_32 = COPY $vgpr36
  ; GISEL-GFX10-NEXT:   [[COPY65:%[0-9]+]]:vgpr_32 = COPY $vgpr37
  ; GISEL-GFX10-NEXT:   [[COPY66:%[0-9]+]]:vgpr_32 = COPY $vgpr38
  ; GISEL-GFX10-NEXT:   [[COPY67:%[0-9]+]]:vgpr_32 = COPY $vgpr39
  ; GISEL-GFX10-NEXT:   [[COPY68:%[0-9]+]]:vgpr_32 = COPY $vgpr40
  ; GISEL-GFX10-NEXT:   [[COPY69:%[0-9]+]]:vgpr_32 = COPY $vgpr41
  ; GISEL-GFX10-NEXT:   [[COPY70:%[0-9]+]]:vgpr_32 = COPY $vgpr42
  ; GISEL-GFX10-NEXT:   [[COPY71:%[0-9]+]]:vgpr_32 = COPY $vgpr43
  ; GISEL-GFX10-NEXT:   [[COPY72:%[0-9]+]]:vgpr_32 = COPY $vgpr44
  ; GISEL-GFX10-NEXT:   [[COPY73:%[0-9]+]]:vgpr_32 = COPY $vgpr45
  ; GISEL-GFX10-NEXT:   [[COPY74:%[0-9]+]]:vgpr_32 = COPY $vgpr46
  ; GISEL-GFX10-NEXT:   [[COPY75:%[0-9]+]]:vgpr_32 = COPY $vgpr47
  ; GISEL-GFX10-NEXT:   [[COPY76:%[0-9]+]]:vgpr_32 = COPY $vgpr48
  ; GISEL-GFX10-NEXT:   [[COPY77:%[0-9]+]]:vgpr_32 = COPY $vgpr49
  ; GISEL-GFX10-NEXT:   [[COPY78:%[0-9]+]]:vgpr_32 = COPY $vgpr50
  ; GISEL-GFX10-NEXT:   [[COPY79:%[0-9]+]]:vgpr_32 = COPY $vgpr51
  ; GISEL-GFX10-NEXT:   [[COPY80:%[0-9]+]]:vgpr_32 = COPY $vgpr52
  ; GISEL-GFX10-NEXT:   [[COPY81:%[0-9]+]]:vgpr_32 = COPY $vgpr53
  ; GISEL-GFX10-NEXT:   [[COPY82:%[0-9]+]]:vgpr_32 = COPY $vgpr54
  ; GISEL-GFX10-NEXT:   [[COPY83:%[0-9]+]]:vgpr_32 = COPY $vgpr55
  ; GISEL-GFX10-NEXT:   [[COPY84:%[0-9]+]]:vgpr_32 = COPY $vgpr56
  ; GISEL-GFX10-NEXT:   [[COPY85:%[0-9]+]]:vgpr_32 = COPY $vgpr57
  ; GISEL-GFX10-NEXT:   [[COPY86:%[0-9]+]]:vgpr_32 = COPY $vgpr58
  ; GISEL-GFX10-NEXT:   [[COPY87:%[0-9]+]]:vgpr_32 = COPY $vgpr59
  ; GISEL-GFX10-NEXT:   [[COPY88:%[0-9]+]]:vgpr_32 = COPY $vgpr60
  ; GISEL-GFX10-NEXT:   [[COPY89:%[0-9]+]]:vgpr_32 = COPY $vgpr61
  ; GISEL-GFX10-NEXT:   [[COPY90:%[0-9]+]]:vgpr_32 = COPY $vgpr62
  ; GISEL-GFX10-NEXT:   [[COPY91:%[0-9]+]]:vgpr_32 = COPY $vgpr63
  ; GISEL-GFX10-NEXT:   [[COPY92:%[0-9]+]]:vgpr_32 = COPY $vgpr64
  ; GISEL-GFX10-NEXT:   [[COPY93:%[0-9]+]]:vgpr_32 = COPY $vgpr65
  ; GISEL-GFX10-NEXT:   [[COPY94:%[0-9]+]]:vgpr_32 = COPY $vgpr66
  ; GISEL-GFX10-NEXT:   [[COPY95:%[0-9]+]]:vgpr_32 = COPY $vgpr67
  ; GISEL-GFX10-NEXT:   [[COPY96:%[0-9]+]]:vgpr_32 = COPY $vgpr68
  ; GISEL-GFX10-NEXT:   [[COPY97:%[0-9]+]]:vgpr_32 = COPY $vgpr69
  ; GISEL-GFX10-NEXT:   [[COPY98:%[0-9]+]]:vgpr_32 = COPY $vgpr70
  ; GISEL-GFX10-NEXT:   [[COPY99:%[0-9]+]]:vgpr_32 = COPY $vgpr71
  ; GISEL-GFX10-NEXT:   [[COPY100:%[0-9]+]]:vgpr_32 = COPY $vgpr72
  ; GISEL-GFX10-NEXT:   [[COPY101:%[0-9]+]]:vgpr_32 = COPY $vgpr73
  ; GISEL-GFX10-NEXT:   [[COPY102:%[0-9]+]]:vgpr_32 = COPY $vgpr74
  ; GISEL-GFX10-NEXT:   [[COPY103:%[0-9]+]]:vgpr_32 = COPY $vgpr75
  ; GISEL-GFX10-NEXT:   [[COPY104:%[0-9]+]]:vgpr_32 = COPY $vgpr76
  ; GISEL-GFX10-NEXT:   [[COPY105:%[0-9]+]]:vgpr_32 = COPY $vgpr77
  ; GISEL-GFX10-NEXT:   [[COPY106:%[0-9]+]]:vgpr_32 = COPY $vgpr78
  ; GISEL-GFX10-NEXT:   [[COPY107:%[0-9]+]]:vgpr_32 = COPY $vgpr79
  ; GISEL-GFX10-NEXT:   [[COPY108:%[0-9]+]]:vgpr_32 = COPY $vgpr80
  ; GISEL-GFX10-NEXT:   [[COPY109:%[0-9]+]]:vgpr_32 = COPY $vgpr81
  ; GISEL-GFX10-NEXT:   [[COPY110:%[0-9]+]]:vgpr_32 = COPY $vgpr82
  ; GISEL-GFX10-NEXT:   [[COPY111:%[0-9]+]]:vgpr_32 = COPY $vgpr83
  ; GISEL-GFX10-NEXT:   [[COPY112:%[0-9]+]]:vgpr_32 = COPY $vgpr84
  ; GISEL-GFX10-NEXT:   [[COPY113:%[0-9]+]]:vgpr_32 = COPY $vgpr85
  ; GISEL-GFX10-NEXT:   [[COPY114:%[0-9]+]]:vgpr_32 = COPY $vgpr86
  ; GISEL-GFX10-NEXT:   [[COPY115:%[0-9]+]]:vgpr_32 = COPY $vgpr87
  ; GISEL-GFX10-NEXT:   [[COPY116:%[0-9]+]]:vgpr_32 = COPY $vgpr88
  ; GISEL-GFX10-NEXT:   [[COPY117:%[0-9]+]]:vgpr_32 = COPY $vgpr89
  ; GISEL-GFX10-NEXT:   [[COPY118:%[0-9]+]]:vgpr_32 = COPY $vgpr90
  ; GISEL-GFX10-NEXT:   [[COPY119:%[0-9]+]]:vgpr_32 = COPY $vgpr91
  ; GISEL-GFX10-NEXT:   [[COPY120:%[0-9]+]]:vgpr_32 = COPY $vgpr92
  ; GISEL-GFX10-NEXT:   [[COPY121:%[0-9]+]]:vgpr_32 = COPY $vgpr93
  ; GISEL-GFX10-NEXT:   [[COPY122:%[0-9]+]]:vgpr_32 = COPY $vgpr94
  ; GISEL-GFX10-NEXT:   [[COPY123:%[0-9]+]]:vgpr_32 = COPY $vgpr95
  ; GISEL-GFX10-NEXT:   [[COPY124:%[0-9]+]]:vgpr_32 = COPY $vgpr96
  ; GISEL-GFX10-NEXT:   [[COPY125:%[0-9]+]]:vgpr_32 = COPY $vgpr97
  ; GISEL-GFX10-NEXT:   [[COPY126:%[0-9]+]]:vgpr_32 = COPY $vgpr98
  ; GISEL-GFX10-NEXT:   [[COPY127:%[0-9]+]]:vgpr_32 = COPY $vgpr99
  ; GISEL-GFX10-NEXT:   [[COPY128:%[0-9]+]]:vgpr_32 = COPY $vgpr100
  ; GISEL-GFX10-NEXT:   [[COPY129:%[0-9]+]]:vgpr_32 = COPY $vgpr101
  ; GISEL-GFX10-NEXT:   [[COPY130:%[0-9]+]]:vgpr_32 = COPY $vgpr102
  ; GISEL-GFX10-NEXT:   [[COPY131:%[0-9]+]]:vgpr_32 = COPY $vgpr103
  ; GISEL-GFX10-NEXT:   [[COPY132:%[0-9]+]]:vgpr_32 = COPY $vgpr104
  ; GISEL-GFX10-NEXT:   [[COPY133:%[0-9]+]]:vgpr_32 = COPY $vgpr105
  ; GISEL-GFX10-NEXT:   [[COPY134:%[0-9]+]]:vgpr_32 = COPY $vgpr106
  ; GISEL-GFX10-NEXT:   [[COPY135:%[0-9]+]]:vgpr_32 = COPY $vgpr107
  ; GISEL-GFX10-NEXT:   [[COPY136:%[0-9]+]]:vgpr_32 = COPY $vgpr108
  ; GISEL-GFX10-NEXT:   [[COPY137:%[0-9]+]]:vgpr_32 = COPY $vgpr109
  ; GISEL-GFX10-NEXT:   [[COPY138:%[0-9]+]]:vgpr_32 = COPY $vgpr110
  ; GISEL-GFX10-NEXT:   [[COPY139:%[0-9]+]]:vgpr_32 = COPY $vgpr111
  ; GISEL-GFX10-NEXT:   [[COPY140:%[0-9]+]]:vgpr_32 = COPY $vgpr112
  ; GISEL-GFX10-NEXT:   [[COPY141:%[0-9]+]]:vgpr_32 = COPY $vgpr113
  ; GISEL-GFX10-NEXT:   [[COPY142:%[0-9]+]]:vgpr_32 = COPY $vgpr114
  ; GISEL-GFX10-NEXT:   [[COPY143:%[0-9]+]]:vgpr_32 = COPY $vgpr115
  ; GISEL-GFX10-NEXT:   [[COPY144:%[0-9]+]]:vgpr_32 = COPY $vgpr116
  ; GISEL-GFX10-NEXT:   [[COPY145:%[0-9]+]]:vgpr_32 = COPY $vgpr117
  ; GISEL-GFX10-NEXT:   [[COPY146:%[0-9]+]]:vgpr_32 = COPY $vgpr118
  ; GISEL-GFX10-NEXT:   [[COPY147:%[0-9]+]]:vgpr_32 = COPY $vgpr119
  ; GISEL-GFX10-NEXT:   [[COPY148:%[0-9]+]]:vgpr_32 = COPY $vgpr120
  ; GISEL-GFX10-NEXT:   [[COPY149:%[0-9]+]]:vgpr_32 = COPY $vgpr121
  ; GISEL-GFX10-NEXT:   [[COPY150:%[0-9]+]]:vgpr_32 = COPY $vgpr122
  ; GISEL-GFX10-NEXT:   [[COPY151:%[0-9]+]]:vgpr_32 = COPY $vgpr123
  ; GISEL-GFX10-NEXT:   [[COPY152:%[0-9]+]]:vgpr_32 = COPY $vgpr124
  ; GISEL-GFX10-NEXT:   [[COPY153:%[0-9]+]]:vgpr_32 = COPY $vgpr125
  ; GISEL-GFX10-NEXT:   [[COPY154:%[0-9]+]]:vgpr_32 = COPY $vgpr126
  ; GISEL-GFX10-NEXT:   [[COPY155:%[0-9]+]]:vgpr_32 = COPY $vgpr127
  ; GISEL-GFX10-NEXT:   [[COPY156:%[0-9]+]]:vgpr_32 = COPY $vgpr128
  ; GISEL-GFX10-NEXT:   [[COPY157:%[0-9]+]]:vgpr_32 = COPY $vgpr129
  ; GISEL-GFX10-NEXT:   [[COPY158:%[0-9]+]]:vgpr_32 = COPY $vgpr130
  ; GISEL-GFX10-NEXT:   [[COPY159:%[0-9]+]]:vgpr_32 = COPY $vgpr131
  ; GISEL-GFX10-NEXT:   [[COPY160:%[0-9]+]]:vgpr_32 = COPY $vgpr132
  ; GISEL-GFX10-NEXT:   [[COPY161:%[0-9]+]]:vgpr_32 = COPY $vgpr133
  ; GISEL-GFX10-NEXT:   [[COPY162:%[0-9]+]]:vgpr_32 = COPY $vgpr134
  ; GISEL-GFX10-NEXT:   [[COPY163:%[0-9]+]]:vgpr_32 = COPY $vgpr135
  ; GISEL-GFX10-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX10-NEXT:   [[COPY164:%[0-9]+]]:vgpr_32 = COPY [[COPY32]]
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY164]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 0, 0, 0, implicit $exec :: (store (s32) into stack, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   [[COPY165:%[0-9]+]]:vgpr_32 = COPY [[COPY33]]
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY165]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 4, 0, 0, implicit $exec :: (store (s32) into stack + 4, addrspace 5)
  ; GISEL-GFX10-NEXT:   [[COPY166:%[0-9]+]]:vgpr_32 = COPY [[COPY34]]
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY166]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 8, 0, 0, implicit $exec :: (store (s32) into stack + 8, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   [[COPY167:%[0-9]+]]:vgpr_32 = COPY [[COPY35]]
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY167]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 12, 0, 0, implicit $exec :: (store (s32) into stack + 12, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY36]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 16, 0, 0, implicit $exec :: (store (s32) into stack + 16, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY37]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 20, 0, 0, implicit $exec :: (store (s32) into stack + 20, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY38]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 24, 0, 0, implicit $exec :: (store (s32) into stack + 24, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY39]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 28, 0, 0, implicit $exec :: (store (s32) into stack + 28, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY40]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 32, 0, 0, implicit $exec :: (store (s32) into stack + 32, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY41]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 36, 0, 0, implicit $exec :: (store (s32) into stack + 36, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY42]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 40, 0, 0, implicit $exec :: (store (s32) into stack + 40, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY43]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 44, 0, 0, implicit $exec :: (store (s32) into stack + 44, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY44]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 48, 0, 0, implicit $exec :: (store (s32) into stack + 48, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY45]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 52, 0, 0, implicit $exec :: (store (s32) into stack + 52, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY46]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 56, 0, 0, implicit $exec :: (store (s32) into stack + 56, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY47]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 60, 0, 0, implicit $exec :: (store (s32) into stack + 60, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY48]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 64, 0, 0, implicit $exec :: (store (s32) into stack + 64, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY49]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 68, 0, 0, implicit $exec :: (store (s32) into stack + 68, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY50]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 72, 0, 0, implicit $exec :: (store (s32) into stack + 72, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY51]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 76, 0, 0, implicit $exec :: (store (s32) into stack + 76, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY52]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 80, 0, 0, implicit $exec :: (store (s32) into stack + 80, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY53]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 84, 0, 0, implicit $exec :: (store (s32) into stack + 84, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY54]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 88, 0, 0, implicit $exec :: (store (s32) into stack + 88, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY55]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 92, 0, 0, implicit $exec :: (store (s32) into stack + 92, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY56]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 96, 0, 0, implicit $exec :: (store (s32) into stack + 96, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY57]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 100, 0, 0, implicit $exec :: (store (s32) into stack + 100, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY58]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 104, 0, 0, implicit $exec :: (store (s32) into stack + 104, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY59]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 108, 0, 0, implicit $exec :: (store (s32) into stack + 108, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY60]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 112, 0, 0, implicit $exec :: (store (s32) into stack + 112, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY61]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 116, 0, 0, implicit $exec :: (store (s32) into stack + 116, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY62]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 120, 0, 0, implicit $exec :: (store (s32) into stack + 120, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY63]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 124, 0, 0, implicit $exec :: (store (s32) into stack + 124, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY64]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 128, 0, 0, implicit $exec :: (store (s32) into stack + 128, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY65]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 132, 0, 0, implicit $exec :: (store (s32) into stack + 132, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY66]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 136, 0, 0, implicit $exec :: (store (s32) into stack + 136, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY67]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 140, 0, 0, implicit $exec :: (store (s32) into stack + 140, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY68]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 144, 0, 0, implicit $exec :: (store (s32) into stack + 144, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY69]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 148, 0, 0, implicit $exec :: (store (s32) into stack + 148, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY70]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 152, 0, 0, implicit $exec :: (store (s32) into stack + 152, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY71]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 156, 0, 0, implicit $exec :: (store (s32) into stack + 156, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY72]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 160, 0, 0, implicit $exec :: (store (s32) into stack + 160, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY73]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 164, 0, 0, implicit $exec :: (store (s32) into stack + 164, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY74]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 168, 0, 0, implicit $exec :: (store (s32) into stack + 168, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY75]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 172, 0, 0, implicit $exec :: (store (s32) into stack + 172, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY76]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 176, 0, 0, implicit $exec :: (store (s32) into stack + 176, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY77]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 180, 0, 0, implicit $exec :: (store (s32) into stack + 180, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY78]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 184, 0, 0, implicit $exec :: (store (s32) into stack + 184, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY79]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 188, 0, 0, implicit $exec :: (store (s32) into stack + 188, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY80]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 192, 0, 0, implicit $exec :: (store (s32) into stack + 192, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY81]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 196, 0, 0, implicit $exec :: (store (s32) into stack + 196, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY82]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 200, 0, 0, implicit $exec :: (store (s32) into stack + 200, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY83]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 204, 0, 0, implicit $exec :: (store (s32) into stack + 204, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY84]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 208, 0, 0, implicit $exec :: (store (s32) into stack + 208, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY85]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 212, 0, 0, implicit $exec :: (store (s32) into stack + 212, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY86]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 216, 0, 0, implicit $exec :: (store (s32) into stack + 216, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY87]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 220, 0, 0, implicit $exec :: (store (s32) into stack + 220, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY88]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 224, 0, 0, implicit $exec :: (store (s32) into stack + 224, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY89]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 228, 0, 0, implicit $exec :: (store (s32) into stack + 228, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY90]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 232, 0, 0, implicit $exec :: (store (s32) into stack + 232, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY91]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 236, 0, 0, implicit $exec :: (store (s32) into stack + 236, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY92]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 240, 0, 0, implicit $exec :: (store (s32) into stack + 240, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY93]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 244, 0, 0, implicit $exec :: (store (s32) into stack + 244, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY94]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 248, 0, 0, implicit $exec :: (store (s32) into stack + 248, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY95]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 252, 0, 0, implicit $exec :: (store (s32) into stack + 252, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY96]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 256, 0, 0, implicit $exec :: (store (s32) into stack + 256, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY97]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 260, 0, 0, implicit $exec :: (store (s32) into stack + 260, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY98]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 264, 0, 0, implicit $exec :: (store (s32) into stack + 264, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY99]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 268, 0, 0, implicit $exec :: (store (s32) into stack + 268, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY100]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 272, 0, 0, implicit $exec :: (store (s32) into stack + 272, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY101]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 276, 0, 0, implicit $exec :: (store (s32) into stack + 276, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY102]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 280, 0, 0, implicit $exec :: (store (s32) into stack + 280, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY103]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 284, 0, 0, implicit $exec :: (store (s32) into stack + 284, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY104]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 288, 0, 0, implicit $exec :: (store (s32) into stack + 288, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY105]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 292, 0, 0, implicit $exec :: (store (s32) into stack + 292, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY106]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 296, 0, 0, implicit $exec :: (store (s32) into stack + 296, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY107]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 300, 0, 0, implicit $exec :: (store (s32) into stack + 300, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY108]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 304, 0, 0, implicit $exec :: (store (s32) into stack + 304, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY109]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 308, 0, 0, implicit $exec :: (store (s32) into stack + 308, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY110]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 312, 0, 0, implicit $exec :: (store (s32) into stack + 312, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY111]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 316, 0, 0, implicit $exec :: (store (s32) into stack + 316, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY112]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 320, 0, 0, implicit $exec :: (store (s32) into stack + 320, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY113]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 324, 0, 0, implicit $exec :: (store (s32) into stack + 324, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY114]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 328, 0, 0, implicit $exec :: (store (s32) into stack + 328, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY115]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 332, 0, 0, implicit $exec :: (store (s32) into stack + 332, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY116]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 336, 0, 0, implicit $exec :: (store (s32) into stack + 336, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY117]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 340, 0, 0, implicit $exec :: (store (s32) into stack + 340, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY118]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 344, 0, 0, implicit $exec :: (store (s32) into stack + 344, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY119]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 348, 0, 0, implicit $exec :: (store (s32) into stack + 348, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY120]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 352, 0, 0, implicit $exec :: (store (s32) into stack + 352, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY121]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 356, 0, 0, implicit $exec :: (store (s32) into stack + 356, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY122]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 360, 0, 0, implicit $exec :: (store (s32) into stack + 360, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY123]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 364, 0, 0, implicit $exec :: (store (s32) into stack + 364, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY124]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 368, 0, 0, implicit $exec :: (store (s32) into stack + 368, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY125]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 372, 0, 0, implicit $exec :: (store (s32) into stack + 372, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY126]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 376, 0, 0, implicit $exec :: (store (s32) into stack + 376, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY127]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 380, 0, 0, implicit $exec :: (store (s32) into stack + 380, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY128]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 384, 0, 0, implicit $exec :: (store (s32) into stack + 384, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY129]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 388, 0, 0, implicit $exec :: (store (s32) into stack + 388, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY130]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 392, 0, 0, implicit $exec :: (store (s32) into stack + 392, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY131]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 396, 0, 0, implicit $exec :: (store (s32) into stack + 396, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY132]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 400, 0, 0, implicit $exec :: (store (s32) into stack + 400, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY133]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 404, 0, 0, implicit $exec :: (store (s32) into stack + 404, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY134]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 408, 0, 0, implicit $exec :: (store (s32) into stack + 408, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY135]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 412, 0, 0, implicit $exec :: (store (s32) into stack + 412, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY136]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 416, 0, 0, implicit $exec :: (store (s32) into stack + 416, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY137]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 420, 0, 0, implicit $exec :: (store (s32) into stack + 420, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY138]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 424, 0, 0, implicit $exec :: (store (s32) into stack + 424, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY139]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 428, 0, 0, implicit $exec :: (store (s32) into stack + 428, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY140]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 432, 0, 0, implicit $exec :: (store (s32) into stack + 432, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY141]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 436, 0, 0, implicit $exec :: (store (s32) into stack + 436, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY142]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 440, 0, 0, implicit $exec :: (store (s32) into stack + 440, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY143]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 444, 0, 0, implicit $exec :: (store (s32) into stack + 444, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY144]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 448, 0, 0, implicit $exec :: (store (s32) into stack + 448, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY145]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 452, 0, 0, implicit $exec :: (store (s32) into stack + 452, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY146]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 456, 0, 0, implicit $exec :: (store (s32) into stack + 456, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY147]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 460, 0, 0, implicit $exec :: (store (s32) into stack + 460, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY148]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 464, 0, 0, implicit $exec :: (store (s32) into stack + 464, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY149]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 468, 0, 0, implicit $exec :: (store (s32) into stack + 468, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY150]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 472, 0, 0, implicit $exec :: (store (s32) into stack + 472, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY151]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 476, 0, 0, implicit $exec :: (store (s32) into stack + 476, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY152]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 480, 0, 0, implicit $exec :: (store (s32) into stack + 480, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY153]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 484, 0, 0, implicit $exec :: (store (s32) into stack + 484, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY154]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 488, 0, 0, implicit $exec :: (store (s32) into stack + 488, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY155]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 492, 0, 0, implicit $exec :: (store (s32) into stack + 492, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY156]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 496, 0, 0, implicit $exec :: (store (s32) into stack + 496, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY157]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 500, 0, 0, implicit $exec :: (store (s32) into stack + 500, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY158]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 504, 0, 0, implicit $exec :: (store (s32) into stack + 504, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY159]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 508, 0, 0, implicit $exec :: (store (s32) into stack + 508, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY160]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 512, 0, 0, implicit $exec :: (store (s32) into stack + 512, align 16, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY161]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 516, 0, 0, implicit $exec :: (store (s32) into stack + 516, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY162]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 520, 0, 0, implicit $exec :: (store (s32) into stack + 520, align 8, addrspace 5)
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY163]], $sgpr48_sgpr49_sgpr50_sgpr51, $sgpr32, 524, 0, 0, implicit $exec :: (store (s32) into stack + 524, addrspace 5)
  ; GISEL-GFX10-NEXT:   $vgpr0 = COPY [[COPY]]
  ; GISEL-GFX10-NEXT:   $vgpr1 = COPY [[COPY1]]
  ; GISEL-GFX10-NEXT:   $vgpr2 = COPY [[COPY2]]
  ; GISEL-GFX10-NEXT:   $vgpr3 = COPY [[COPY3]]
  ; GISEL-GFX10-NEXT:   $vgpr4 = COPY [[COPY4]]
  ; GISEL-GFX10-NEXT:   $vgpr5 = COPY [[COPY5]]
  ; GISEL-GFX10-NEXT:   $vgpr6 = COPY [[COPY6]]
  ; GISEL-GFX10-NEXT:   $vgpr7 = COPY [[COPY7]]
  ; GISEL-GFX10-NEXT:   $vgpr8 = COPY [[COPY8]]
  ; GISEL-GFX10-NEXT:   $vgpr9 = COPY [[COPY9]]
  ; GISEL-GFX10-NEXT:   $vgpr10 = COPY [[COPY10]]
  ; GISEL-GFX10-NEXT:   $vgpr11 = COPY [[COPY11]]
  ; GISEL-GFX10-NEXT:   $vgpr12 = COPY [[COPY12]]
  ; GISEL-GFX10-NEXT:   $vgpr13 = COPY [[COPY13]]
  ; GISEL-GFX10-NEXT:   $vgpr14 = COPY [[COPY14]]
  ; GISEL-GFX10-NEXT:   $vgpr15 = COPY [[COPY15]]
  ; GISEL-GFX10-NEXT:   $vgpr16 = COPY [[COPY16]]
  ; GISEL-GFX10-NEXT:   $vgpr17 = COPY [[COPY17]]
  ; GISEL-GFX10-NEXT:   $vgpr18 = COPY [[COPY18]]
  ; GISEL-GFX10-NEXT:   $vgpr19 = COPY [[COPY19]]
  ; GISEL-GFX10-NEXT:   $vgpr20 = COPY [[COPY20]]
  ; GISEL-GFX10-NEXT:   $vgpr21 = COPY [[COPY21]]
  ; GISEL-GFX10-NEXT:   $vgpr22 = COPY [[COPY22]]
  ; GISEL-GFX10-NEXT:   $vgpr23 = COPY [[COPY23]]
  ; GISEL-GFX10-NEXT:   $vgpr24 = COPY [[COPY24]]
  ; GISEL-GFX10-NEXT:   $vgpr25 = COPY [[COPY25]]
  ; GISEL-GFX10-NEXT:   $vgpr26 = COPY [[COPY26]]
  ; GISEL-GFX10-NEXT:   $vgpr27 = COPY [[COPY27]]
  ; GISEL-GFX10-NEXT:   $vgpr28 = COPY [[COPY28]]
  ; GISEL-GFX10-NEXT:   $vgpr29 = COPY [[COPY29]]
  ; GISEL-GFX10-NEXT:   $vgpr30 = COPY [[COPY30]]
  ; GISEL-GFX10-NEXT:   $vgpr31 = COPY [[COPY31]]
  ; GISEL-GFX10-NEXT:   [[COPY168:%[0-9]+]]:sgpr_128 = COPY $sgpr48_sgpr49_sgpr50_sgpr51
  ; GISEL-GFX10-NEXT:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY168]]
  ; GISEL-GFX10-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def $scc
  ; GISEL-GFX10-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (p0) from got, addrspace 4)
  ; GISEL-GFX10-NEXT:   $sgpr30_sgpr31 = noconvergent SI_CALL [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15, implicit $vgpr16, implicit $vgpr17, implicit $vgpr18, implicit $vgpr19, implicit $vgpr20, implicit $vgpr21, implicit $vgpr22, implicit $vgpr23, implicit $vgpr24, implicit $vgpr25, implicit $vgpr26, implicit $vgpr27, implicit $vgpr28, implicit $vgpr29, implicit $vgpr30, implicit $vgpr31, implicit $sgpr0_sgpr1_sgpr2_sgpr3
  ; GISEL-GFX10-NEXT:   ADJCALLSTACKDOWN 0, 528, implicit-def $scc, implicit-def $sgpr32, implicit $sgpr32
  ; GISEL-GFX10-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-LABEL: name: amdgpu_cs_chain_many_regs
  ; DAGISEL-GFX11: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $sgpr14, $sgpr15, $sgpr16, $sgpr17, $sgpr18, $sgpr19, $sgpr20, $sgpr21, $sgpr22, $sgpr23, $sgpr24, $sgpr25, $sgpr26, $sgpr27, $sgpr28, $sgpr29, $sgpr30, $sgpr31, $sgpr32, $sgpr33, $sgpr34, $sgpr35, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $vgpr32, $vgpr33, $vgpr34, $vgpr35, $vgpr36, $vgpr37, $vgpr38, $vgpr39, $vgpr40, $vgpr41, $vgpr42, $vgpr43, $vgpr44, $vgpr45, $vgpr46, $vgpr47, $vgpr48, $vgpr49, $vgpr50, $vgpr51, $vgpr52, $vgpr53, $vgpr54, $vgpr55, $vgpr56, $vgpr57, $vgpr58, $vgpr59, $vgpr60, $vgpr61, $vgpr62, $vgpr63, $vgpr64, $vgpr65, $vgpr66, $vgpr67, $vgpr68, $vgpr69, $vgpr70, $vgpr71, $vgpr72, $vgpr73, $vgpr74, $vgpr75, $vgpr76, $vgpr77, $vgpr78, $vgpr79, $vgpr80, $vgpr81, $vgpr82, $vgpr83, $vgpr84, $vgpr85, $vgpr86, $vgpr87, $vgpr88, $vgpr89, $vgpr90, $vgpr91, $vgpr92, $vgpr93, $vgpr94, $vgpr95, $vgpr96, $vgpr97, $vgpr98, $vgpr99, $vgpr100, $vgpr101, $vgpr102, $vgpr103, $vgpr104, $vgpr105, $vgpr106, $vgpr107, $vgpr108, $vgpr109, $vgpr110, $vgpr111, $vgpr112, $vgpr113, $vgpr114, $vgpr115, $vgpr116, $vgpr117, $vgpr118, $vgpr119, $vgpr120, $vgpr121, $vgpr122, $vgpr123, $vgpr124, $vgpr125, $vgpr126, $vgpr127, $vgpr128, $vgpr129, $vgpr130, $vgpr131, $vgpr132, $vgpr133, $vgpr134, $vgpr135
  ; DAGISEL-GFX11-NEXT: {{  $}}
  ; DAGISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr135
  ; DAGISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr134
  ; DAGISEL-GFX11-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr133
  ; DAGISEL-GFX11-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr132
  ; DAGISEL-GFX11-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr131
  ; DAGISEL-GFX11-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr130
  ; DAGISEL-GFX11-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr129
  ; DAGISEL-GFX11-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY $vgpr128
  ; DAGISEL-GFX11-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY $vgpr127
  ; DAGISEL-GFX11-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr126
  ; DAGISEL-GFX11-NEXT:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY $vgpr125
  ; DAGISEL-GFX11-NEXT:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY $vgpr124
  ; DAGISEL-GFX11-NEXT:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY $vgpr123
  ; DAGISEL-GFX11-NEXT:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY $vgpr122
  ; DAGISEL-GFX11-NEXT:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY $vgpr121
  ; DAGISEL-GFX11-NEXT:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY $vgpr120
  ; DAGISEL-GFX11-NEXT:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY $vgpr119
  ; DAGISEL-GFX11-NEXT:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY $vgpr118
  ; DAGISEL-GFX11-NEXT:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY $vgpr117
  ; DAGISEL-GFX11-NEXT:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY $vgpr116
  ; DAGISEL-GFX11-NEXT:   [[COPY20:%[0-9]+]]:vgpr_32 = COPY $vgpr115
  ; DAGISEL-GFX11-NEXT:   [[COPY21:%[0-9]+]]:vgpr_32 = COPY $vgpr114
  ; DAGISEL-GFX11-NEXT:   [[COPY22:%[0-9]+]]:vgpr_32 = COPY $vgpr113
  ; DAGISEL-GFX11-NEXT:   [[COPY23:%[0-9]+]]:vgpr_32 = COPY $vgpr112
  ; DAGISEL-GFX11-NEXT:   [[COPY24:%[0-9]+]]:vgpr_32 = COPY $vgpr111
  ; DAGISEL-GFX11-NEXT:   [[COPY25:%[0-9]+]]:vgpr_32 = COPY $vgpr110
  ; DAGISEL-GFX11-NEXT:   [[COPY26:%[0-9]+]]:vgpr_32 = COPY $vgpr109
  ; DAGISEL-GFX11-NEXT:   [[COPY27:%[0-9]+]]:vgpr_32 = COPY $vgpr108
  ; DAGISEL-GFX11-NEXT:   [[COPY28:%[0-9]+]]:vgpr_32 = COPY $vgpr107
  ; DAGISEL-GFX11-NEXT:   [[COPY29:%[0-9]+]]:vgpr_32 = COPY $vgpr106
  ; DAGISEL-GFX11-NEXT:   [[COPY30:%[0-9]+]]:vgpr_32 = COPY $vgpr105
  ; DAGISEL-GFX11-NEXT:   [[COPY31:%[0-9]+]]:vgpr_32 = COPY $vgpr104
  ; DAGISEL-GFX11-NEXT:   [[COPY32:%[0-9]+]]:vgpr_32 = COPY $vgpr103
  ; DAGISEL-GFX11-NEXT:   [[COPY33:%[0-9]+]]:vgpr_32 = COPY $vgpr102
  ; DAGISEL-GFX11-NEXT:   [[COPY34:%[0-9]+]]:vgpr_32 = COPY $vgpr101
  ; DAGISEL-GFX11-NEXT:   [[COPY35:%[0-9]+]]:vgpr_32 = COPY $vgpr100
  ; DAGISEL-GFX11-NEXT:   [[COPY36:%[0-9]+]]:vgpr_32 = COPY $vgpr99
  ; DAGISEL-GFX11-NEXT:   [[COPY37:%[0-9]+]]:vgpr_32 = COPY $vgpr98
  ; DAGISEL-GFX11-NEXT:   [[COPY38:%[0-9]+]]:vgpr_32 = COPY $vgpr97
  ; DAGISEL-GFX11-NEXT:   [[COPY39:%[0-9]+]]:vgpr_32 = COPY $vgpr96
  ; DAGISEL-GFX11-NEXT:   [[COPY40:%[0-9]+]]:vgpr_32 = COPY $vgpr95
  ; DAGISEL-GFX11-NEXT:   [[COPY41:%[0-9]+]]:vgpr_32 = COPY $vgpr94
  ; DAGISEL-GFX11-NEXT:   [[COPY42:%[0-9]+]]:vgpr_32 = COPY $vgpr93
  ; DAGISEL-GFX11-NEXT:   [[COPY43:%[0-9]+]]:vgpr_32 = COPY $vgpr92
  ; DAGISEL-GFX11-NEXT:   [[COPY44:%[0-9]+]]:vgpr_32 = COPY $vgpr91
  ; DAGISEL-GFX11-NEXT:   [[COPY45:%[0-9]+]]:vgpr_32 = COPY $vgpr90
  ; DAGISEL-GFX11-NEXT:   [[COPY46:%[0-9]+]]:vgpr_32 = COPY $vgpr89
  ; DAGISEL-GFX11-NEXT:   [[COPY47:%[0-9]+]]:vgpr_32 = COPY $vgpr88
  ; DAGISEL-GFX11-NEXT:   [[COPY48:%[0-9]+]]:vgpr_32 = COPY $vgpr87
  ; DAGISEL-GFX11-NEXT:   [[COPY49:%[0-9]+]]:vgpr_32 = COPY $vgpr86
  ; DAGISEL-GFX11-NEXT:   [[COPY50:%[0-9]+]]:vgpr_32 = COPY $vgpr85
  ; DAGISEL-GFX11-NEXT:   [[COPY51:%[0-9]+]]:vgpr_32 = COPY $vgpr84
  ; DAGISEL-GFX11-NEXT:   [[COPY52:%[0-9]+]]:vgpr_32 = COPY $vgpr83
  ; DAGISEL-GFX11-NEXT:   [[COPY53:%[0-9]+]]:vgpr_32 = COPY $vgpr82
  ; DAGISEL-GFX11-NEXT:   [[COPY54:%[0-9]+]]:vgpr_32 = COPY $vgpr81
  ; DAGISEL-GFX11-NEXT:   [[COPY55:%[0-9]+]]:vgpr_32 = COPY $vgpr80
  ; DAGISEL-GFX11-NEXT:   [[COPY56:%[0-9]+]]:vgpr_32 = COPY $vgpr79
  ; DAGISEL-GFX11-NEXT:   [[COPY57:%[0-9]+]]:vgpr_32 = COPY $vgpr78
  ; DAGISEL-GFX11-NEXT:   [[COPY58:%[0-9]+]]:vgpr_32 = COPY $vgpr77
  ; DAGISEL-GFX11-NEXT:   [[COPY59:%[0-9]+]]:vgpr_32 = COPY $vgpr76
  ; DAGISEL-GFX11-NEXT:   [[COPY60:%[0-9]+]]:vgpr_32 = COPY $vgpr75
  ; DAGISEL-GFX11-NEXT:   [[COPY61:%[0-9]+]]:vgpr_32 = COPY $vgpr74
  ; DAGISEL-GFX11-NEXT:   [[COPY62:%[0-9]+]]:vgpr_32 = COPY $vgpr73
  ; DAGISEL-GFX11-NEXT:   [[COPY63:%[0-9]+]]:vgpr_32 = COPY $vgpr72
  ; DAGISEL-GFX11-NEXT:   [[COPY64:%[0-9]+]]:vgpr_32 = COPY $vgpr71
  ; DAGISEL-GFX11-NEXT:   [[COPY65:%[0-9]+]]:vgpr_32 = COPY $vgpr70
  ; DAGISEL-GFX11-NEXT:   [[COPY66:%[0-9]+]]:vgpr_32 = COPY $vgpr69
  ; DAGISEL-GFX11-NEXT:   [[COPY67:%[0-9]+]]:vgpr_32 = COPY $vgpr68
  ; DAGISEL-GFX11-NEXT:   [[COPY68:%[0-9]+]]:vgpr_32 = COPY $vgpr67
  ; DAGISEL-GFX11-NEXT:   [[COPY69:%[0-9]+]]:vgpr_32 = COPY $vgpr66
  ; DAGISEL-GFX11-NEXT:   [[COPY70:%[0-9]+]]:vgpr_32 = COPY $vgpr65
  ; DAGISEL-GFX11-NEXT:   [[COPY71:%[0-9]+]]:vgpr_32 = COPY $vgpr64
  ; DAGISEL-GFX11-NEXT:   [[COPY72:%[0-9]+]]:vgpr_32 = COPY $vgpr63
  ; DAGISEL-GFX11-NEXT:   [[COPY73:%[0-9]+]]:vgpr_32 = COPY $vgpr62
  ; DAGISEL-GFX11-NEXT:   [[COPY74:%[0-9]+]]:vgpr_32 = COPY $vgpr61
  ; DAGISEL-GFX11-NEXT:   [[COPY75:%[0-9]+]]:vgpr_32 = COPY $vgpr60
  ; DAGISEL-GFX11-NEXT:   [[COPY76:%[0-9]+]]:vgpr_32 = COPY $vgpr59
  ; DAGISEL-GFX11-NEXT:   [[COPY77:%[0-9]+]]:vgpr_32 = COPY $vgpr58
  ; DAGISEL-GFX11-NEXT:   [[COPY78:%[0-9]+]]:vgpr_32 = COPY $vgpr57
  ; DAGISEL-GFX11-NEXT:   [[COPY79:%[0-9]+]]:vgpr_32 = COPY $vgpr56
  ; DAGISEL-GFX11-NEXT:   [[COPY80:%[0-9]+]]:vgpr_32 = COPY $vgpr55
  ; DAGISEL-GFX11-NEXT:   [[COPY81:%[0-9]+]]:vgpr_32 = COPY $vgpr54
  ; DAGISEL-GFX11-NEXT:   [[COPY82:%[0-9]+]]:vgpr_32 = COPY $vgpr53
  ; DAGISEL-GFX11-NEXT:   [[COPY83:%[0-9]+]]:vgpr_32 = COPY $vgpr52
  ; DAGISEL-GFX11-NEXT:   [[COPY84:%[0-9]+]]:vgpr_32 = COPY $vgpr51
  ; DAGISEL-GFX11-NEXT:   [[COPY85:%[0-9]+]]:vgpr_32 = COPY $vgpr50
  ; DAGISEL-GFX11-NEXT:   [[COPY86:%[0-9]+]]:vgpr_32 = COPY $vgpr49
  ; DAGISEL-GFX11-NEXT:   [[COPY87:%[0-9]+]]:vgpr_32 = COPY $vgpr48
  ; DAGISEL-GFX11-NEXT:   [[COPY88:%[0-9]+]]:vgpr_32 = COPY $vgpr47
  ; DAGISEL-GFX11-NEXT:   [[COPY89:%[0-9]+]]:vgpr_32 = COPY $vgpr46
  ; DAGISEL-GFX11-NEXT:   [[COPY90:%[0-9]+]]:vgpr_32 = COPY $vgpr45
  ; DAGISEL-GFX11-NEXT:   [[COPY91:%[0-9]+]]:vgpr_32 = COPY $vgpr44
  ; DAGISEL-GFX11-NEXT:   [[COPY92:%[0-9]+]]:vgpr_32 = COPY $vgpr43
  ; DAGISEL-GFX11-NEXT:   [[COPY93:%[0-9]+]]:vgpr_32 = COPY $vgpr42
  ; DAGISEL-GFX11-NEXT:   [[COPY94:%[0-9]+]]:vgpr_32 = COPY $vgpr41
  ; DAGISEL-GFX11-NEXT:   [[COPY95:%[0-9]+]]:vgpr_32 = COPY $vgpr40
  ; DAGISEL-GFX11-NEXT:   [[COPY96:%[0-9]+]]:vgpr_32 = COPY $vgpr39
  ; DAGISEL-GFX11-NEXT:   [[COPY97:%[0-9]+]]:vgpr_32 = COPY $vgpr38
  ; DAGISEL-GFX11-NEXT:   [[COPY98:%[0-9]+]]:vgpr_32 = COPY $vgpr37
  ; DAGISEL-GFX11-NEXT:   [[COPY99:%[0-9]+]]:vgpr_32 = COPY $vgpr36
  ; DAGISEL-GFX11-NEXT:   [[COPY100:%[0-9]+]]:vgpr_32 = COPY $vgpr35
  ; DAGISEL-GFX11-NEXT:   [[COPY101:%[0-9]+]]:vgpr_32 = COPY $vgpr34
  ; DAGISEL-GFX11-NEXT:   [[COPY102:%[0-9]+]]:vgpr_32 = COPY $vgpr33
  ; DAGISEL-GFX11-NEXT:   [[COPY103:%[0-9]+]]:vgpr_32 = COPY $vgpr32
  ; DAGISEL-GFX11-NEXT:   [[COPY104:%[0-9]+]]:vgpr_32 = COPY $vgpr31
  ; DAGISEL-GFX11-NEXT:   [[COPY105:%[0-9]+]]:vgpr_32 = COPY $vgpr30
  ; DAGISEL-GFX11-NEXT:   [[COPY106:%[0-9]+]]:vgpr_32 = COPY $vgpr29
  ; DAGISEL-GFX11-NEXT:   [[COPY107:%[0-9]+]]:vgpr_32 = COPY $vgpr28
  ; DAGISEL-GFX11-NEXT:   [[COPY108:%[0-9]+]]:vgpr_32 = COPY $vgpr27
  ; DAGISEL-GFX11-NEXT:   [[COPY109:%[0-9]+]]:vgpr_32 = COPY $vgpr26
  ; DAGISEL-GFX11-NEXT:   [[COPY110:%[0-9]+]]:vgpr_32 = COPY $vgpr25
  ; DAGISEL-GFX11-NEXT:   [[COPY111:%[0-9]+]]:vgpr_32 = COPY $vgpr24
  ; DAGISEL-GFX11-NEXT:   [[COPY112:%[0-9]+]]:vgpr_32 = COPY $vgpr23
  ; DAGISEL-GFX11-NEXT:   [[COPY113:%[0-9]+]]:vgpr_32 = COPY $vgpr22
  ; DAGISEL-GFX11-NEXT:   [[COPY114:%[0-9]+]]:vgpr_32 = COPY $vgpr21
  ; DAGISEL-GFX11-NEXT:   [[COPY115:%[0-9]+]]:vgpr_32 = COPY $vgpr20
  ; DAGISEL-GFX11-NEXT:   [[COPY116:%[0-9]+]]:vgpr_32 = COPY $vgpr19
  ; DAGISEL-GFX11-NEXT:   [[COPY117:%[0-9]+]]:vgpr_32 = COPY $vgpr18
  ; DAGISEL-GFX11-NEXT:   [[COPY118:%[0-9]+]]:vgpr_32 = COPY $vgpr17
  ; DAGISEL-GFX11-NEXT:   [[COPY119:%[0-9]+]]:vgpr_32 = COPY $vgpr16
  ; DAGISEL-GFX11-NEXT:   [[COPY120:%[0-9]+]]:vgpr_32 = COPY $vgpr15
  ; DAGISEL-GFX11-NEXT:   [[COPY121:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; DAGISEL-GFX11-NEXT:   [[COPY122:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; DAGISEL-GFX11-NEXT:   [[COPY123:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; DAGISEL-GFX11-NEXT:   [[COPY124:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX11-NEXT:   [[COPY125:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX11-NEXT:   [[COPY126:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX11-NEXT:   [[COPY127:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-NEXT:   [[COPY128:%[0-9]+]]:sgpr_32 = COPY $sgpr35
  ; DAGISEL-GFX11-NEXT:   [[COPY129:%[0-9]+]]:sgpr_32 = COPY $sgpr34
  ; DAGISEL-GFX11-NEXT:   [[COPY130:%[0-9]+]]:sgpr_32 = COPY $sgpr33
  ; DAGISEL-GFX11-NEXT:   [[COPY131:%[0-9]+]]:sgpr_32 = COPY $sgpr32
  ; DAGISEL-GFX11-NEXT:   [[COPY132:%[0-9]+]]:sgpr_32 = COPY $sgpr31
  ; DAGISEL-GFX11-NEXT:   [[COPY133:%[0-9]+]]:sgpr_32 = COPY $sgpr30
  ; DAGISEL-GFX11-NEXT:   [[COPY134:%[0-9]+]]:sgpr_32 = COPY $sgpr29
  ; DAGISEL-GFX11-NEXT:   [[COPY135:%[0-9]+]]:sgpr_32 = COPY $sgpr28
  ; DAGISEL-GFX11-NEXT:   [[COPY136:%[0-9]+]]:sgpr_32 = COPY $sgpr27
  ; DAGISEL-GFX11-NEXT:   [[COPY137:%[0-9]+]]:sgpr_32 = COPY $sgpr26
  ; DAGISEL-GFX11-NEXT:   [[COPY138:%[0-9]+]]:sgpr_32 = COPY $sgpr25
  ; DAGISEL-GFX11-NEXT:   [[COPY139:%[0-9]+]]:sgpr_32 = COPY $sgpr24
  ; DAGISEL-GFX11-NEXT:   [[COPY140:%[0-9]+]]:sgpr_32 = COPY $sgpr23
  ; DAGISEL-GFX11-NEXT:   [[COPY141:%[0-9]+]]:sgpr_32 = COPY $sgpr22
  ; DAGISEL-GFX11-NEXT:   [[COPY142:%[0-9]+]]:sgpr_32 = COPY $sgpr21
  ; DAGISEL-GFX11-NEXT:   [[COPY143:%[0-9]+]]:sgpr_32 = COPY $sgpr20
  ; DAGISEL-GFX11-NEXT:   [[COPY144:%[0-9]+]]:sgpr_32 = COPY $sgpr19
  ; DAGISEL-GFX11-NEXT:   [[COPY145:%[0-9]+]]:sgpr_32 = COPY $sgpr18
  ; DAGISEL-GFX11-NEXT:   [[COPY146:%[0-9]+]]:sgpr_32 = COPY $sgpr17
  ; DAGISEL-GFX11-NEXT:   [[COPY147:%[0-9]+]]:sgpr_32 = COPY $sgpr16
  ; DAGISEL-GFX11-NEXT:   [[COPY148:%[0-9]+]]:sgpr_32 = COPY $sgpr15
  ; DAGISEL-GFX11-NEXT:   [[COPY149:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; DAGISEL-GFX11-NEXT:   [[COPY150:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; DAGISEL-GFX11-NEXT:   [[COPY151:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; DAGISEL-GFX11-NEXT:   [[COPY152:%[0-9]+]]:sgpr_32 = COPY $sgpr11
  ; DAGISEL-GFX11-NEXT:   [[COPY153:%[0-9]+]]:sgpr_32 = COPY $sgpr10
  ; DAGISEL-GFX11-NEXT:   [[COPY154:%[0-9]+]]:sgpr_32 = COPY $sgpr9
  ; DAGISEL-GFX11-NEXT:   [[COPY155:%[0-9]+]]:sgpr_32 = COPY $sgpr8
  ; DAGISEL-GFX11-NEXT:   [[COPY156:%[0-9]+]]:sgpr_32 = COPY $sgpr7
  ; DAGISEL-GFX11-NEXT:   [[COPY157:%[0-9]+]]:sgpr_32 = COPY $sgpr6
  ; DAGISEL-GFX11-NEXT:   [[COPY158:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX11-NEXT:   [[COPY159:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX11-NEXT:   [[COPY160:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX11-NEXT:   [[COPY161:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX11-NEXT:   [[COPY162:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX11-NEXT:   [[COPY163:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX11-NEXT:   [[COPY164:%[0-9]+]]:sreg_32_xexec_hi = COPY $sgpr32
  ; DAGISEL-GFX11-NEXT:   [[COPY165:%[0-9]+]]:vgpr_32 = COPY [[COPY131]]
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY165]], [[COPY164]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 524
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY]], killed [[S_ADD_I32_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 524, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 520
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_1:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_1]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY1]], killed [[S_ADD_I32_1]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 520, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_2:%[0-9]+]]:sreg_32 = S_MOV_B32 516
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_2:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_2]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY2]], killed [[S_ADD_I32_2]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 516, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_3:%[0-9]+]]:sreg_32 = S_MOV_B32 512
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_3:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_3]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY3]], killed [[S_ADD_I32_3]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 512, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_4:%[0-9]+]]:sreg_32 = S_MOV_B32 508
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_4:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_4]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY4]], killed [[S_ADD_I32_4]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 508, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_5:%[0-9]+]]:sreg_32 = S_MOV_B32 504
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_5:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_5]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY5]], killed [[S_ADD_I32_5]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 504, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_6:%[0-9]+]]:sreg_32 = S_MOV_B32 500
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_6:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_6]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY6]], killed [[S_ADD_I32_6]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 500, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_7:%[0-9]+]]:sreg_32 = S_MOV_B32 496
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_7:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_7]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY7]], killed [[S_ADD_I32_7]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 496, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_8:%[0-9]+]]:sreg_32 = S_MOV_B32 492
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_8:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_8]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY8]], killed [[S_ADD_I32_8]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 492, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_9:%[0-9]+]]:sreg_32 = S_MOV_B32 488
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_9:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_9]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY9]], killed [[S_ADD_I32_9]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 488, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_10:%[0-9]+]]:sreg_32 = S_MOV_B32 484
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_10:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_10]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY10]], killed [[S_ADD_I32_10]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 484, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_11:%[0-9]+]]:sreg_32 = S_MOV_B32 480
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_11:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_11]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY11]], killed [[S_ADD_I32_11]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 480, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_12:%[0-9]+]]:sreg_32 = S_MOV_B32 476
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_12:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_12]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY12]], killed [[S_ADD_I32_12]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 476, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_13:%[0-9]+]]:sreg_32 = S_MOV_B32 472
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_13:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_13]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY13]], killed [[S_ADD_I32_13]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 472, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_14:%[0-9]+]]:sreg_32 = S_MOV_B32 468
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_14:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_14]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY14]], killed [[S_ADD_I32_14]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 468, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_15:%[0-9]+]]:sreg_32 = S_MOV_B32 464
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_15:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_15]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY15]], killed [[S_ADD_I32_15]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 464, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_16:%[0-9]+]]:sreg_32 = S_MOV_B32 460
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_16:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_16]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY16]], killed [[S_ADD_I32_16]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 460, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_17:%[0-9]+]]:sreg_32 = S_MOV_B32 456
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_17:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_17]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY17]], killed [[S_ADD_I32_17]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 456, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_18:%[0-9]+]]:sreg_32 = S_MOV_B32 452
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_18:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_18]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY18]], killed [[S_ADD_I32_18]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 452, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_19:%[0-9]+]]:sreg_32 = S_MOV_B32 448
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_19:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_19]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY19]], killed [[S_ADD_I32_19]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 448, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_20:%[0-9]+]]:sreg_32 = S_MOV_B32 444
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_20:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_20]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY20]], killed [[S_ADD_I32_20]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 444, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_21:%[0-9]+]]:sreg_32 = S_MOV_B32 440
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_21:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_21]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY21]], killed [[S_ADD_I32_21]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 440, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_22:%[0-9]+]]:sreg_32 = S_MOV_B32 436
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_22:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_22]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY22]], killed [[S_ADD_I32_22]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 436, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_23:%[0-9]+]]:sreg_32 = S_MOV_B32 432
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_23:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_23]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY23]], killed [[S_ADD_I32_23]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 432, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_24:%[0-9]+]]:sreg_32 = S_MOV_B32 428
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_24:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_24]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY24]], killed [[S_ADD_I32_24]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 428, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_25:%[0-9]+]]:sreg_32 = S_MOV_B32 424
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_25:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_25]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY25]], killed [[S_ADD_I32_25]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 424, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_26:%[0-9]+]]:sreg_32 = S_MOV_B32 420
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_26:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_26]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY26]], killed [[S_ADD_I32_26]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 420, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_27:%[0-9]+]]:sreg_32 = S_MOV_B32 416
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_27:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_27]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY27]], killed [[S_ADD_I32_27]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 416, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_28:%[0-9]+]]:sreg_32 = S_MOV_B32 412
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_28:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_28]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY28]], killed [[S_ADD_I32_28]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 412, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_29:%[0-9]+]]:sreg_32 = S_MOV_B32 408
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_29:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_29]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY29]], killed [[S_ADD_I32_29]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 408, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_30:%[0-9]+]]:sreg_32 = S_MOV_B32 404
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_30:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_30]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY30]], killed [[S_ADD_I32_30]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 404, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_31:%[0-9]+]]:sreg_32 = S_MOV_B32 400
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_31:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_31]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY31]], killed [[S_ADD_I32_31]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 400, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_32:%[0-9]+]]:sreg_32 = S_MOV_B32 396
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_32:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_32]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY32]], killed [[S_ADD_I32_32]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 396, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_33:%[0-9]+]]:sreg_32 = S_MOV_B32 392
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_33:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_33]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY33]], killed [[S_ADD_I32_33]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 392, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_34:%[0-9]+]]:sreg_32 = S_MOV_B32 388
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_34:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_34]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY34]], killed [[S_ADD_I32_34]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 388, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_35:%[0-9]+]]:sreg_32 = S_MOV_B32 384
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_35:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_35]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY35]], killed [[S_ADD_I32_35]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 384, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_36:%[0-9]+]]:sreg_32 = S_MOV_B32 380
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_36:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_36]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY36]], killed [[S_ADD_I32_36]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 380, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_37:%[0-9]+]]:sreg_32 = S_MOV_B32 376
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_37:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_37]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY37]], killed [[S_ADD_I32_37]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 376, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_38:%[0-9]+]]:sreg_32 = S_MOV_B32 372
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_38:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_38]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY38]], killed [[S_ADD_I32_38]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 372, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_39:%[0-9]+]]:sreg_32 = S_MOV_B32 368
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_39:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_39]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY39]], killed [[S_ADD_I32_39]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 368, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_40:%[0-9]+]]:sreg_32 = S_MOV_B32 364
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_40:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_40]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY40]], killed [[S_ADD_I32_40]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 364, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_41:%[0-9]+]]:sreg_32 = S_MOV_B32 360
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_41:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_41]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY41]], killed [[S_ADD_I32_41]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 360, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_42:%[0-9]+]]:sreg_32 = S_MOV_B32 356
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_42:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_42]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY42]], killed [[S_ADD_I32_42]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 356, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_43:%[0-9]+]]:sreg_32 = S_MOV_B32 352
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_43:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_43]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY43]], killed [[S_ADD_I32_43]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 352, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_44:%[0-9]+]]:sreg_32 = S_MOV_B32 348
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_44:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_44]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY44]], killed [[S_ADD_I32_44]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 348, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_45:%[0-9]+]]:sreg_32 = S_MOV_B32 344
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_45:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_45]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY45]], killed [[S_ADD_I32_45]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 344, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_46:%[0-9]+]]:sreg_32 = S_MOV_B32 340
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_46:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_46]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY46]], killed [[S_ADD_I32_46]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 340, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_47:%[0-9]+]]:sreg_32 = S_MOV_B32 336
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_47:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_47]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY47]], killed [[S_ADD_I32_47]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 336, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_48:%[0-9]+]]:sreg_32 = S_MOV_B32 332
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_48:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_48]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY48]], killed [[S_ADD_I32_48]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 332, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_49:%[0-9]+]]:sreg_32 = S_MOV_B32 328
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_49:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_49]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY49]], killed [[S_ADD_I32_49]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 328, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_50:%[0-9]+]]:sreg_32 = S_MOV_B32 324
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_50:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_50]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY50]], killed [[S_ADD_I32_50]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 324, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_51:%[0-9]+]]:sreg_32 = S_MOV_B32 320
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_51:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_51]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY51]], killed [[S_ADD_I32_51]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 320, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_52:%[0-9]+]]:sreg_32 = S_MOV_B32 316
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_52:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_52]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY52]], killed [[S_ADD_I32_52]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 316, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_53:%[0-9]+]]:sreg_32 = S_MOV_B32 312
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_53:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_53]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY53]], killed [[S_ADD_I32_53]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 312, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_54:%[0-9]+]]:sreg_32 = S_MOV_B32 308
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_54:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_54]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY54]], killed [[S_ADD_I32_54]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 308, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_55:%[0-9]+]]:sreg_32 = S_MOV_B32 304
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_55:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_55]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY55]], killed [[S_ADD_I32_55]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 304, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_56:%[0-9]+]]:sreg_32 = S_MOV_B32 300
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_56:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_56]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY56]], killed [[S_ADD_I32_56]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 300, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_57:%[0-9]+]]:sreg_32 = S_MOV_B32 296
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_57:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_57]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY57]], killed [[S_ADD_I32_57]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 296, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_58:%[0-9]+]]:sreg_32 = S_MOV_B32 292
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_58:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_58]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY58]], killed [[S_ADD_I32_58]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 292, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_59:%[0-9]+]]:sreg_32 = S_MOV_B32 288
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_59:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_59]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY59]], killed [[S_ADD_I32_59]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 288, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_60:%[0-9]+]]:sreg_32 = S_MOV_B32 284
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_60:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_60]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY60]], killed [[S_ADD_I32_60]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 284, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_61:%[0-9]+]]:sreg_32 = S_MOV_B32 280
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_61:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_61]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY61]], killed [[S_ADD_I32_61]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 280, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_62:%[0-9]+]]:sreg_32 = S_MOV_B32 276
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_62:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_62]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY62]], killed [[S_ADD_I32_62]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 276, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_63:%[0-9]+]]:sreg_32 = S_MOV_B32 272
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_63:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_63]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY63]], killed [[S_ADD_I32_63]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 272, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_64:%[0-9]+]]:sreg_32 = S_MOV_B32 268
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_64:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_64]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY64]], killed [[S_ADD_I32_64]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 268, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_65:%[0-9]+]]:sreg_32 = S_MOV_B32 264
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_65:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_65]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY65]], killed [[S_ADD_I32_65]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 264, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_66:%[0-9]+]]:sreg_32 = S_MOV_B32 260
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_66:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_66]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY66]], killed [[S_ADD_I32_66]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 260, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_67:%[0-9]+]]:sreg_32 = S_MOV_B32 256
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_67:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_67]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY67]], killed [[S_ADD_I32_67]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 256, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_68:%[0-9]+]]:sreg_32 = S_MOV_B32 252
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_68:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_68]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY68]], killed [[S_ADD_I32_68]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 252, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_69:%[0-9]+]]:sreg_32 = S_MOV_B32 248
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_69:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_69]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY69]], killed [[S_ADD_I32_69]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 248, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_70:%[0-9]+]]:sreg_32 = S_MOV_B32 244
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_70:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_70]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY70]], killed [[S_ADD_I32_70]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 244, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_71:%[0-9]+]]:sreg_32 = S_MOV_B32 240
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_71:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_71]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY71]], killed [[S_ADD_I32_71]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 240, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_72:%[0-9]+]]:sreg_32 = S_MOV_B32 236
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_72:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_72]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY72]], killed [[S_ADD_I32_72]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 236, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_73:%[0-9]+]]:sreg_32 = S_MOV_B32 232
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_73:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_73]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY73]], killed [[S_ADD_I32_73]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 232, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_74:%[0-9]+]]:sreg_32 = S_MOV_B32 228
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_74:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_74]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY74]], killed [[S_ADD_I32_74]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 228, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_75:%[0-9]+]]:sreg_32 = S_MOV_B32 224
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_75:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_75]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY75]], killed [[S_ADD_I32_75]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 224, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_76:%[0-9]+]]:sreg_32 = S_MOV_B32 220
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_76:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_76]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY76]], killed [[S_ADD_I32_76]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 220, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_77:%[0-9]+]]:sreg_32 = S_MOV_B32 216
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_77:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_77]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY77]], killed [[S_ADD_I32_77]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 216, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_78:%[0-9]+]]:sreg_32 = S_MOV_B32 212
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_78:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_78]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY78]], killed [[S_ADD_I32_78]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 212, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_79:%[0-9]+]]:sreg_32 = S_MOV_B32 208
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_79:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_79]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY79]], killed [[S_ADD_I32_79]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 208, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_80:%[0-9]+]]:sreg_32 = S_MOV_B32 204
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_80:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_80]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY80]], killed [[S_ADD_I32_80]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 204, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_81:%[0-9]+]]:sreg_32 = S_MOV_B32 200
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_81:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_81]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY81]], killed [[S_ADD_I32_81]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 200, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_82:%[0-9]+]]:sreg_32 = S_MOV_B32 196
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_82:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_82]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY82]], killed [[S_ADD_I32_82]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 196, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_83:%[0-9]+]]:sreg_32 = S_MOV_B32 192
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_83:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_83]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY83]], killed [[S_ADD_I32_83]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 192, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_84:%[0-9]+]]:sreg_32 = S_MOV_B32 188
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_84:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_84]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY84]], killed [[S_ADD_I32_84]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 188, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_85:%[0-9]+]]:sreg_32 = S_MOV_B32 184
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_85:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_85]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY85]], killed [[S_ADD_I32_85]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 184, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_86:%[0-9]+]]:sreg_32 = S_MOV_B32 180
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_86:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_86]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY86]], killed [[S_ADD_I32_86]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 180, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_87:%[0-9]+]]:sreg_32 = S_MOV_B32 176
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_87:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_87]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY87]], killed [[S_ADD_I32_87]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 176, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_88:%[0-9]+]]:sreg_32 = S_MOV_B32 172
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_88:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_88]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY88]], killed [[S_ADD_I32_88]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 172, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_89:%[0-9]+]]:sreg_32 = S_MOV_B32 168
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_89:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_89]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY89]], killed [[S_ADD_I32_89]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 168, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_90:%[0-9]+]]:sreg_32 = S_MOV_B32 164
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_90:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_90]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY90]], killed [[S_ADD_I32_90]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 164, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_91:%[0-9]+]]:sreg_32 = S_MOV_B32 160
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_91:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_91]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY91]], killed [[S_ADD_I32_91]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 160, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_92:%[0-9]+]]:sreg_32 = S_MOV_B32 156
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_92:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_92]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY92]], killed [[S_ADD_I32_92]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 156, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_93:%[0-9]+]]:sreg_32 = S_MOV_B32 152
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_93:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_93]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY93]], killed [[S_ADD_I32_93]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 152, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_94:%[0-9]+]]:sreg_32 = S_MOV_B32 148
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_94:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_94]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY94]], killed [[S_ADD_I32_94]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 148, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_95:%[0-9]+]]:sreg_32 = S_MOV_B32 144
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_95:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_95]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY95]], killed [[S_ADD_I32_95]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 144, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_96:%[0-9]+]]:sreg_32 = S_MOV_B32 140
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_96:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_96]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY96]], killed [[S_ADD_I32_96]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 140, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_97:%[0-9]+]]:sreg_32 = S_MOV_B32 136
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_97:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_97]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY97]], killed [[S_ADD_I32_97]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 136, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_98:%[0-9]+]]:sreg_32 = S_MOV_B32 132
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_98:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_98]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY98]], killed [[S_ADD_I32_98]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 132, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_99:%[0-9]+]]:sreg_32 = S_MOV_B32 128
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_99:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_99]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY99]], killed [[S_ADD_I32_99]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 128, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_100:%[0-9]+]]:sreg_32 = S_MOV_B32 124
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_100:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_100]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY100]], killed [[S_ADD_I32_100]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 124, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_101:%[0-9]+]]:sreg_32 = S_MOV_B32 120
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_101:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_101]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY101]], killed [[S_ADD_I32_101]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 120, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_102:%[0-9]+]]:sreg_32 = S_MOV_B32 116
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_102:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_102]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY102]], killed [[S_ADD_I32_102]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 116, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_103:%[0-9]+]]:sreg_32 = S_MOV_B32 112
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_103:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_103]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY103]], killed [[S_ADD_I32_103]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 112, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_104:%[0-9]+]]:sreg_32 = S_MOV_B32 108
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_104:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_104]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY104]], killed [[S_ADD_I32_104]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 108, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_105:%[0-9]+]]:sreg_32 = S_MOV_B32 104
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_105:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_105]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY105]], killed [[S_ADD_I32_105]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 104, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_106:%[0-9]+]]:sreg_32 = S_MOV_B32 100
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_106:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_106]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY106]], killed [[S_ADD_I32_106]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 100, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_107:%[0-9]+]]:sreg_32 = S_MOV_B32 96
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_107:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_107]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY107]], killed [[S_ADD_I32_107]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 96, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_108:%[0-9]+]]:sreg_32 = S_MOV_B32 92
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_108:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_108]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY108]], killed [[S_ADD_I32_108]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 92, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_109:%[0-9]+]]:sreg_32 = S_MOV_B32 88
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_109:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_109]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY109]], killed [[S_ADD_I32_109]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 88, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_110:%[0-9]+]]:sreg_32 = S_MOV_B32 84
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_110:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_110]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY110]], killed [[S_ADD_I32_110]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 84, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_111:%[0-9]+]]:sreg_32 = S_MOV_B32 80
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_111:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_111]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY111]], killed [[S_ADD_I32_111]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 80, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_112:%[0-9]+]]:sreg_32 = S_MOV_B32 76
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_112:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_112]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY112]], killed [[S_ADD_I32_112]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 76, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_113:%[0-9]+]]:sreg_32 = S_MOV_B32 72
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_113:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_113]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY113]], killed [[S_ADD_I32_113]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 72, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_114:%[0-9]+]]:sreg_32 = S_MOV_B32 68
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_114:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_114]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY114]], killed [[S_ADD_I32_114]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 68, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_115:%[0-9]+]]:sreg_32 = S_MOV_B32 64
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_115:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_115]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY115]], killed [[S_ADD_I32_115]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 64, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_116:%[0-9]+]]:sreg_32 = S_MOV_B32 60
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_116:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_116]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY116]], killed [[S_ADD_I32_116]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 60, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_117:%[0-9]+]]:sreg_32 = S_MOV_B32 56
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_117:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_117]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY117]], killed [[S_ADD_I32_117]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 56, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_118:%[0-9]+]]:sreg_32 = S_MOV_B32 52
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_118:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_118]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY118]], killed [[S_ADD_I32_118]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 52, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_119:%[0-9]+]]:sreg_32 = S_MOV_B32 48
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_119:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_119]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY119]], killed [[S_ADD_I32_119]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 48, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_120:%[0-9]+]]:sreg_32 = S_MOV_B32 44
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_120:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_120]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY120]], killed [[S_ADD_I32_120]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 44, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_121:%[0-9]+]]:sreg_32 = S_MOV_B32 40
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_121:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_121]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY121]], killed [[S_ADD_I32_121]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 40, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_122:%[0-9]+]]:sreg_32 = S_MOV_B32 36
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_122:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_122]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY122]], killed [[S_ADD_I32_122]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 36, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_123:%[0-9]+]]:sreg_32 = S_MOV_B32 32
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_123:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_123]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY123]], killed [[S_ADD_I32_123]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 32, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_124:%[0-9]+]]:sreg_32 = S_MOV_B32 28
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_124:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_124]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY124]], killed [[S_ADD_I32_124]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 28, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_125:%[0-9]+]]:sreg_32 = S_MOV_B32 24
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_125:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_125]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY125]], killed [[S_ADD_I32_125]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 24, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_126:%[0-9]+]]:sreg_32 = S_MOV_B32 20
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_126:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_126]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY126]], killed [[S_ADD_I32_126]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 20, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_127:%[0-9]+]]:sreg_32 = S_MOV_B32 16
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_127:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_127]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY127]], killed [[S_ADD_I32_127]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 16, align 16, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_128:%[0-9]+]]:sreg_32 = S_MOV_B32 12
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_128:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_128]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   [[COPY166:%[0-9]+]]:vgpr_32 = COPY [[COPY128]]
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY166]], killed [[S_ADD_I32_128]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 12, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_129:%[0-9]+]]:sreg_32 = S_MOV_B32 8
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_129:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_129]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   [[COPY167:%[0-9]+]]:vgpr_32 = COPY [[COPY129]]
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY167]], killed [[S_ADD_I32_129]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 8, align 8, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[S_MOV_B32_130:%[0-9]+]]:sreg_32 = S_MOV_B32 4
  ; DAGISEL-GFX11-NEXT:   [[S_ADD_I32_130:%[0-9]+]]:sreg_32_xexec_hi = S_ADD_I32 [[COPY164]], killed [[S_MOV_B32_130]], implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   [[COPY168:%[0-9]+]]:vgpr_32 = COPY [[COPY130]]
  ; DAGISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD_SADDR [[COPY168]], killed [[S_ADD_I32_130]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into stack + 4, addrspace 5)
  ; DAGISEL-GFX11-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def dead $scc
  ; DAGISEL-GFX11-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM killed [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (s64) from got, addrspace 4)
  ; DAGISEL-GFX11-NEXT:   $vgpr0 = COPY [[COPY163]]
  ; DAGISEL-GFX11-NEXT:   $vgpr1 = COPY [[COPY162]]
  ; DAGISEL-GFX11-NEXT:   $vgpr2 = COPY [[COPY161]]
  ; DAGISEL-GFX11-NEXT:   $vgpr3 = COPY [[COPY160]]
  ; DAGISEL-GFX11-NEXT:   $vgpr4 = COPY [[COPY159]]
  ; DAGISEL-GFX11-NEXT:   $vgpr5 = COPY [[COPY158]]
  ; DAGISEL-GFX11-NEXT:   $vgpr6 = COPY [[COPY157]]
  ; DAGISEL-GFX11-NEXT:   $vgpr7 = COPY [[COPY156]]
  ; DAGISEL-GFX11-NEXT:   $vgpr8 = COPY [[COPY155]]
  ; DAGISEL-GFX11-NEXT:   $vgpr9 = COPY [[COPY154]]
  ; DAGISEL-GFX11-NEXT:   $vgpr10 = COPY [[COPY153]]
  ; DAGISEL-GFX11-NEXT:   $vgpr11 = COPY [[COPY152]]
  ; DAGISEL-GFX11-NEXT:   $vgpr12 = COPY [[COPY151]]
  ; DAGISEL-GFX11-NEXT:   $vgpr13 = COPY [[COPY150]]
  ; DAGISEL-GFX11-NEXT:   $vgpr14 = COPY [[COPY149]]
  ; DAGISEL-GFX11-NEXT:   $vgpr15 = COPY [[COPY148]]
  ; DAGISEL-GFX11-NEXT:   $vgpr16 = COPY [[COPY147]]
  ; DAGISEL-GFX11-NEXT:   $vgpr17 = COPY [[COPY146]]
  ; DAGISEL-GFX11-NEXT:   $vgpr18 = COPY [[COPY145]]
  ; DAGISEL-GFX11-NEXT:   $vgpr19 = COPY [[COPY144]]
  ; DAGISEL-GFX11-NEXT:   $vgpr20 = COPY [[COPY143]]
  ; DAGISEL-GFX11-NEXT:   $vgpr21 = COPY [[COPY142]]
  ; DAGISEL-GFX11-NEXT:   $vgpr22 = COPY [[COPY141]]
  ; DAGISEL-GFX11-NEXT:   $vgpr23 = COPY [[COPY140]]
  ; DAGISEL-GFX11-NEXT:   $vgpr24 = COPY [[COPY139]]
  ; DAGISEL-GFX11-NEXT:   $vgpr25 = COPY [[COPY138]]
  ; DAGISEL-GFX11-NEXT:   $vgpr26 = COPY [[COPY137]]
  ; DAGISEL-GFX11-NEXT:   $vgpr27 = COPY [[COPY136]]
  ; DAGISEL-GFX11-NEXT:   $vgpr28 = COPY [[COPY135]]
  ; DAGISEL-GFX11-NEXT:   $vgpr29 = COPY [[COPY134]]
  ; DAGISEL-GFX11-NEXT:   $vgpr30 = COPY [[COPY133]]
  ; DAGISEL-GFX11-NEXT:   $vgpr31 = COPY [[COPY132]]
  ; DAGISEL-GFX11-NEXT:   $sgpr30_sgpr31 = SI_CALL killed [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15, implicit $vgpr16, implicit $vgpr17, implicit $vgpr18, implicit $vgpr19, implicit $vgpr20, implicit $vgpr21, implicit $vgpr22, implicit $vgpr23, implicit $vgpr24, implicit $vgpr25, implicit $vgpr26, implicit $vgpr27, implicit $vgpr28, implicit $vgpr29, implicit $vgpr30, implicit $vgpr31
  ; DAGISEL-GFX11-NEXT:   ADJCALLSTACKDOWN 0, 528, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-LABEL: name: amdgpu_cs_chain_many_regs
  ; DAGISEL-GFX10: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $sgpr14, $sgpr15, $sgpr16, $sgpr17, $sgpr18, $sgpr19, $sgpr20, $sgpr21, $sgpr22, $sgpr23, $sgpr24, $sgpr25, $sgpr26, $sgpr27, $sgpr28, $sgpr29, $sgpr30, $sgpr31, $sgpr32, $sgpr33, $sgpr34, $sgpr35, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $vgpr32, $vgpr33, $vgpr34, $vgpr35, $vgpr36, $vgpr37, $vgpr38, $vgpr39, $vgpr40, $vgpr41, $vgpr42, $vgpr43, $vgpr44, $vgpr45, $vgpr46, $vgpr47, $vgpr48, $vgpr49, $vgpr50, $vgpr51, $vgpr52, $vgpr53, $vgpr54, $vgpr55, $vgpr56, $vgpr57, $vgpr58, $vgpr59, $vgpr60, $vgpr61, $vgpr62, $vgpr63, $vgpr64, $vgpr65, $vgpr66, $vgpr67, $vgpr68, $vgpr69, $vgpr70, $vgpr71, $vgpr72, $vgpr73, $vgpr74, $vgpr75, $vgpr76, $vgpr77, $vgpr78, $vgpr79, $vgpr80, $vgpr81, $vgpr82, $vgpr83, $vgpr84, $vgpr85, $vgpr86, $vgpr87, $vgpr88, $vgpr89, $vgpr90, $vgpr91, $vgpr92, $vgpr93, $vgpr94, $vgpr95, $vgpr96, $vgpr97, $vgpr98, $vgpr99, $vgpr100, $vgpr101, $vgpr102, $vgpr103, $vgpr104, $vgpr105, $vgpr106, $vgpr107, $vgpr108, $vgpr109, $vgpr110, $vgpr111, $vgpr112, $vgpr113, $vgpr114, $vgpr115, $vgpr116, $vgpr117, $vgpr118, $vgpr119, $vgpr120, $vgpr121, $vgpr122, $vgpr123, $vgpr124, $vgpr125, $vgpr126, $vgpr127, $vgpr128, $vgpr129, $vgpr130, $vgpr131, $vgpr132, $vgpr133, $vgpr134, $vgpr135
  ; DAGISEL-GFX10-NEXT: {{  $}}
  ; DAGISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr135
  ; DAGISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr134
  ; DAGISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr133
  ; DAGISEL-GFX10-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr132
  ; DAGISEL-GFX10-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr131
  ; DAGISEL-GFX10-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr130
  ; DAGISEL-GFX10-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr129
  ; DAGISEL-GFX10-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY $vgpr128
  ; DAGISEL-GFX10-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY $vgpr127
  ; DAGISEL-GFX10-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr126
  ; DAGISEL-GFX10-NEXT:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY $vgpr125
  ; DAGISEL-GFX10-NEXT:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY $vgpr124
  ; DAGISEL-GFX10-NEXT:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY $vgpr123
  ; DAGISEL-GFX10-NEXT:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY $vgpr122
  ; DAGISEL-GFX10-NEXT:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY $vgpr121
  ; DAGISEL-GFX10-NEXT:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY $vgpr120
  ; DAGISEL-GFX10-NEXT:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY $vgpr119
  ; DAGISEL-GFX10-NEXT:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY $vgpr118
  ; DAGISEL-GFX10-NEXT:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY $vgpr117
  ; DAGISEL-GFX10-NEXT:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY $vgpr116
  ; DAGISEL-GFX10-NEXT:   [[COPY20:%[0-9]+]]:vgpr_32 = COPY $vgpr115
  ; DAGISEL-GFX10-NEXT:   [[COPY21:%[0-9]+]]:vgpr_32 = COPY $vgpr114
  ; DAGISEL-GFX10-NEXT:   [[COPY22:%[0-9]+]]:vgpr_32 = COPY $vgpr113
  ; DAGISEL-GFX10-NEXT:   [[COPY23:%[0-9]+]]:vgpr_32 = COPY $vgpr112
  ; DAGISEL-GFX10-NEXT:   [[COPY24:%[0-9]+]]:vgpr_32 = COPY $vgpr111
  ; DAGISEL-GFX10-NEXT:   [[COPY25:%[0-9]+]]:vgpr_32 = COPY $vgpr110
  ; DAGISEL-GFX10-NEXT:   [[COPY26:%[0-9]+]]:vgpr_32 = COPY $vgpr109
  ; DAGISEL-GFX10-NEXT:   [[COPY27:%[0-9]+]]:vgpr_32 = COPY $vgpr108
  ; DAGISEL-GFX10-NEXT:   [[COPY28:%[0-9]+]]:vgpr_32 = COPY $vgpr107
  ; DAGISEL-GFX10-NEXT:   [[COPY29:%[0-9]+]]:vgpr_32 = COPY $vgpr106
  ; DAGISEL-GFX10-NEXT:   [[COPY30:%[0-9]+]]:vgpr_32 = COPY $vgpr105
  ; DAGISEL-GFX10-NEXT:   [[COPY31:%[0-9]+]]:vgpr_32 = COPY $vgpr104
  ; DAGISEL-GFX10-NEXT:   [[COPY32:%[0-9]+]]:vgpr_32 = COPY $vgpr103
  ; DAGISEL-GFX10-NEXT:   [[COPY33:%[0-9]+]]:vgpr_32 = COPY $vgpr102
  ; DAGISEL-GFX10-NEXT:   [[COPY34:%[0-9]+]]:vgpr_32 = COPY $vgpr101
  ; DAGISEL-GFX10-NEXT:   [[COPY35:%[0-9]+]]:vgpr_32 = COPY $vgpr100
  ; DAGISEL-GFX10-NEXT:   [[COPY36:%[0-9]+]]:vgpr_32 = COPY $vgpr99
  ; DAGISEL-GFX10-NEXT:   [[COPY37:%[0-9]+]]:vgpr_32 = COPY $vgpr98
  ; DAGISEL-GFX10-NEXT:   [[COPY38:%[0-9]+]]:vgpr_32 = COPY $vgpr97
  ; DAGISEL-GFX10-NEXT:   [[COPY39:%[0-9]+]]:vgpr_32 = COPY $vgpr96
  ; DAGISEL-GFX10-NEXT:   [[COPY40:%[0-9]+]]:vgpr_32 = COPY $vgpr95
  ; DAGISEL-GFX10-NEXT:   [[COPY41:%[0-9]+]]:vgpr_32 = COPY $vgpr94
  ; DAGISEL-GFX10-NEXT:   [[COPY42:%[0-9]+]]:vgpr_32 = COPY $vgpr93
  ; DAGISEL-GFX10-NEXT:   [[COPY43:%[0-9]+]]:vgpr_32 = COPY $vgpr92
  ; DAGISEL-GFX10-NEXT:   [[COPY44:%[0-9]+]]:vgpr_32 = COPY $vgpr91
  ; DAGISEL-GFX10-NEXT:   [[COPY45:%[0-9]+]]:vgpr_32 = COPY $vgpr90
  ; DAGISEL-GFX10-NEXT:   [[COPY46:%[0-9]+]]:vgpr_32 = COPY $vgpr89
  ; DAGISEL-GFX10-NEXT:   [[COPY47:%[0-9]+]]:vgpr_32 = COPY $vgpr88
  ; DAGISEL-GFX10-NEXT:   [[COPY48:%[0-9]+]]:vgpr_32 = COPY $vgpr87
  ; DAGISEL-GFX10-NEXT:   [[COPY49:%[0-9]+]]:vgpr_32 = COPY $vgpr86
  ; DAGISEL-GFX10-NEXT:   [[COPY50:%[0-9]+]]:vgpr_32 = COPY $vgpr85
  ; DAGISEL-GFX10-NEXT:   [[COPY51:%[0-9]+]]:vgpr_32 = COPY $vgpr84
  ; DAGISEL-GFX10-NEXT:   [[COPY52:%[0-9]+]]:vgpr_32 = COPY $vgpr83
  ; DAGISEL-GFX10-NEXT:   [[COPY53:%[0-9]+]]:vgpr_32 = COPY $vgpr82
  ; DAGISEL-GFX10-NEXT:   [[COPY54:%[0-9]+]]:vgpr_32 = COPY $vgpr81
  ; DAGISEL-GFX10-NEXT:   [[COPY55:%[0-9]+]]:vgpr_32 = COPY $vgpr80
  ; DAGISEL-GFX10-NEXT:   [[COPY56:%[0-9]+]]:vgpr_32 = COPY $vgpr79
  ; DAGISEL-GFX10-NEXT:   [[COPY57:%[0-9]+]]:vgpr_32 = COPY $vgpr78
  ; DAGISEL-GFX10-NEXT:   [[COPY58:%[0-9]+]]:vgpr_32 = COPY $vgpr77
  ; DAGISEL-GFX10-NEXT:   [[COPY59:%[0-9]+]]:vgpr_32 = COPY $vgpr76
  ; DAGISEL-GFX10-NEXT:   [[COPY60:%[0-9]+]]:vgpr_32 = COPY $vgpr75
  ; DAGISEL-GFX10-NEXT:   [[COPY61:%[0-9]+]]:vgpr_32 = COPY $vgpr74
  ; DAGISEL-GFX10-NEXT:   [[COPY62:%[0-9]+]]:vgpr_32 = COPY $vgpr73
  ; DAGISEL-GFX10-NEXT:   [[COPY63:%[0-9]+]]:vgpr_32 = COPY $vgpr72
  ; DAGISEL-GFX10-NEXT:   [[COPY64:%[0-9]+]]:vgpr_32 = COPY $vgpr71
  ; DAGISEL-GFX10-NEXT:   [[COPY65:%[0-9]+]]:vgpr_32 = COPY $vgpr70
  ; DAGISEL-GFX10-NEXT:   [[COPY66:%[0-9]+]]:vgpr_32 = COPY $vgpr69
  ; DAGISEL-GFX10-NEXT:   [[COPY67:%[0-9]+]]:vgpr_32 = COPY $vgpr68
  ; DAGISEL-GFX10-NEXT:   [[COPY68:%[0-9]+]]:vgpr_32 = COPY $vgpr67
  ; DAGISEL-GFX10-NEXT:   [[COPY69:%[0-9]+]]:vgpr_32 = COPY $vgpr66
  ; DAGISEL-GFX10-NEXT:   [[COPY70:%[0-9]+]]:vgpr_32 = COPY $vgpr65
  ; DAGISEL-GFX10-NEXT:   [[COPY71:%[0-9]+]]:vgpr_32 = COPY $vgpr64
  ; DAGISEL-GFX10-NEXT:   [[COPY72:%[0-9]+]]:vgpr_32 = COPY $vgpr63
  ; DAGISEL-GFX10-NEXT:   [[COPY73:%[0-9]+]]:vgpr_32 = COPY $vgpr62
  ; DAGISEL-GFX10-NEXT:   [[COPY74:%[0-9]+]]:vgpr_32 = COPY $vgpr61
  ; DAGISEL-GFX10-NEXT:   [[COPY75:%[0-9]+]]:vgpr_32 = COPY $vgpr60
  ; DAGISEL-GFX10-NEXT:   [[COPY76:%[0-9]+]]:vgpr_32 = COPY $vgpr59
  ; DAGISEL-GFX10-NEXT:   [[COPY77:%[0-9]+]]:vgpr_32 = COPY $vgpr58
  ; DAGISEL-GFX10-NEXT:   [[COPY78:%[0-9]+]]:vgpr_32 = COPY $vgpr57
  ; DAGISEL-GFX10-NEXT:   [[COPY79:%[0-9]+]]:vgpr_32 = COPY $vgpr56
  ; DAGISEL-GFX10-NEXT:   [[COPY80:%[0-9]+]]:vgpr_32 = COPY $vgpr55
  ; DAGISEL-GFX10-NEXT:   [[COPY81:%[0-9]+]]:vgpr_32 = COPY $vgpr54
  ; DAGISEL-GFX10-NEXT:   [[COPY82:%[0-9]+]]:vgpr_32 = COPY $vgpr53
  ; DAGISEL-GFX10-NEXT:   [[COPY83:%[0-9]+]]:vgpr_32 = COPY $vgpr52
  ; DAGISEL-GFX10-NEXT:   [[COPY84:%[0-9]+]]:vgpr_32 = COPY $vgpr51
  ; DAGISEL-GFX10-NEXT:   [[COPY85:%[0-9]+]]:vgpr_32 = COPY $vgpr50
  ; DAGISEL-GFX10-NEXT:   [[COPY86:%[0-9]+]]:vgpr_32 = COPY $vgpr49
  ; DAGISEL-GFX10-NEXT:   [[COPY87:%[0-9]+]]:vgpr_32 = COPY $vgpr48
  ; DAGISEL-GFX10-NEXT:   [[COPY88:%[0-9]+]]:vgpr_32 = COPY $vgpr47
  ; DAGISEL-GFX10-NEXT:   [[COPY89:%[0-9]+]]:vgpr_32 = COPY $vgpr46
  ; DAGISEL-GFX10-NEXT:   [[COPY90:%[0-9]+]]:vgpr_32 = COPY $vgpr45
  ; DAGISEL-GFX10-NEXT:   [[COPY91:%[0-9]+]]:vgpr_32 = COPY $vgpr44
  ; DAGISEL-GFX10-NEXT:   [[COPY92:%[0-9]+]]:vgpr_32 = COPY $vgpr43
  ; DAGISEL-GFX10-NEXT:   [[COPY93:%[0-9]+]]:vgpr_32 = COPY $vgpr42
  ; DAGISEL-GFX10-NEXT:   [[COPY94:%[0-9]+]]:vgpr_32 = COPY $vgpr41
  ; DAGISEL-GFX10-NEXT:   [[COPY95:%[0-9]+]]:vgpr_32 = COPY $vgpr40
  ; DAGISEL-GFX10-NEXT:   [[COPY96:%[0-9]+]]:vgpr_32 = COPY $vgpr39
  ; DAGISEL-GFX10-NEXT:   [[COPY97:%[0-9]+]]:vgpr_32 = COPY $vgpr38
  ; DAGISEL-GFX10-NEXT:   [[COPY98:%[0-9]+]]:vgpr_32 = COPY $vgpr37
  ; DAGISEL-GFX10-NEXT:   [[COPY99:%[0-9]+]]:vgpr_32 = COPY $vgpr36
  ; DAGISEL-GFX10-NEXT:   [[COPY100:%[0-9]+]]:vgpr_32 = COPY $vgpr35
  ; DAGISEL-GFX10-NEXT:   [[COPY101:%[0-9]+]]:vgpr_32 = COPY $vgpr34
  ; DAGISEL-GFX10-NEXT:   [[COPY102:%[0-9]+]]:vgpr_32 = COPY $vgpr33
  ; DAGISEL-GFX10-NEXT:   [[COPY103:%[0-9]+]]:vgpr_32 = COPY $vgpr32
  ; DAGISEL-GFX10-NEXT:   [[COPY104:%[0-9]+]]:vgpr_32 = COPY $vgpr31
  ; DAGISEL-GFX10-NEXT:   [[COPY105:%[0-9]+]]:vgpr_32 = COPY $vgpr30
  ; DAGISEL-GFX10-NEXT:   [[COPY106:%[0-9]+]]:vgpr_32 = COPY $vgpr29
  ; DAGISEL-GFX10-NEXT:   [[COPY107:%[0-9]+]]:vgpr_32 = COPY $vgpr28
  ; DAGISEL-GFX10-NEXT:   [[COPY108:%[0-9]+]]:vgpr_32 = COPY $vgpr27
  ; DAGISEL-GFX10-NEXT:   [[COPY109:%[0-9]+]]:vgpr_32 = COPY $vgpr26
  ; DAGISEL-GFX10-NEXT:   [[COPY110:%[0-9]+]]:vgpr_32 = COPY $vgpr25
  ; DAGISEL-GFX10-NEXT:   [[COPY111:%[0-9]+]]:vgpr_32 = COPY $vgpr24
  ; DAGISEL-GFX10-NEXT:   [[COPY112:%[0-9]+]]:vgpr_32 = COPY $vgpr23
  ; DAGISEL-GFX10-NEXT:   [[COPY113:%[0-9]+]]:vgpr_32 = COPY $vgpr22
  ; DAGISEL-GFX10-NEXT:   [[COPY114:%[0-9]+]]:vgpr_32 = COPY $vgpr21
  ; DAGISEL-GFX10-NEXT:   [[COPY115:%[0-9]+]]:vgpr_32 = COPY $vgpr20
  ; DAGISEL-GFX10-NEXT:   [[COPY116:%[0-9]+]]:vgpr_32 = COPY $vgpr19
  ; DAGISEL-GFX10-NEXT:   [[COPY117:%[0-9]+]]:vgpr_32 = COPY $vgpr18
  ; DAGISEL-GFX10-NEXT:   [[COPY118:%[0-9]+]]:vgpr_32 = COPY $vgpr17
  ; DAGISEL-GFX10-NEXT:   [[COPY119:%[0-9]+]]:vgpr_32 = COPY $vgpr16
  ; DAGISEL-GFX10-NEXT:   [[COPY120:%[0-9]+]]:vgpr_32 = COPY $vgpr15
  ; DAGISEL-GFX10-NEXT:   [[COPY121:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; DAGISEL-GFX10-NEXT:   [[COPY122:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; DAGISEL-GFX10-NEXT:   [[COPY123:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; DAGISEL-GFX10-NEXT:   [[COPY124:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX10-NEXT:   [[COPY125:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX10-NEXT:   [[COPY126:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX10-NEXT:   [[COPY127:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-NEXT:   [[COPY128:%[0-9]+]]:sgpr_32 = COPY $sgpr35
  ; DAGISEL-GFX10-NEXT:   [[COPY129:%[0-9]+]]:sgpr_32 = COPY $sgpr34
  ; DAGISEL-GFX10-NEXT:   [[COPY130:%[0-9]+]]:sgpr_32 = COPY $sgpr33
  ; DAGISEL-GFX10-NEXT:   [[COPY131:%[0-9]+]]:sgpr_32 = COPY $sgpr32
  ; DAGISEL-GFX10-NEXT:   [[COPY132:%[0-9]+]]:sgpr_32 = COPY $sgpr31
  ; DAGISEL-GFX10-NEXT:   [[COPY133:%[0-9]+]]:sgpr_32 = COPY $sgpr30
  ; DAGISEL-GFX10-NEXT:   [[COPY134:%[0-9]+]]:sgpr_32 = COPY $sgpr29
  ; DAGISEL-GFX10-NEXT:   [[COPY135:%[0-9]+]]:sgpr_32 = COPY $sgpr28
  ; DAGISEL-GFX10-NEXT:   [[COPY136:%[0-9]+]]:sgpr_32 = COPY $sgpr27
  ; DAGISEL-GFX10-NEXT:   [[COPY137:%[0-9]+]]:sgpr_32 = COPY $sgpr26
  ; DAGISEL-GFX10-NEXT:   [[COPY138:%[0-9]+]]:sgpr_32 = COPY $sgpr25
  ; DAGISEL-GFX10-NEXT:   [[COPY139:%[0-9]+]]:sgpr_32 = COPY $sgpr24
  ; DAGISEL-GFX10-NEXT:   [[COPY140:%[0-9]+]]:sgpr_32 = COPY $sgpr23
  ; DAGISEL-GFX10-NEXT:   [[COPY141:%[0-9]+]]:sgpr_32 = COPY $sgpr22
  ; DAGISEL-GFX10-NEXT:   [[COPY142:%[0-9]+]]:sgpr_32 = COPY $sgpr21
  ; DAGISEL-GFX10-NEXT:   [[COPY143:%[0-9]+]]:sgpr_32 = COPY $sgpr20
  ; DAGISEL-GFX10-NEXT:   [[COPY144:%[0-9]+]]:sgpr_32 = COPY $sgpr19
  ; DAGISEL-GFX10-NEXT:   [[COPY145:%[0-9]+]]:sgpr_32 = COPY $sgpr18
  ; DAGISEL-GFX10-NEXT:   [[COPY146:%[0-9]+]]:sgpr_32 = COPY $sgpr17
  ; DAGISEL-GFX10-NEXT:   [[COPY147:%[0-9]+]]:sgpr_32 = COPY $sgpr16
  ; DAGISEL-GFX10-NEXT:   [[COPY148:%[0-9]+]]:sgpr_32 = COPY $sgpr15
  ; DAGISEL-GFX10-NEXT:   [[COPY149:%[0-9]+]]:sgpr_32 = COPY $sgpr14
  ; DAGISEL-GFX10-NEXT:   [[COPY150:%[0-9]+]]:sgpr_32 = COPY $sgpr13
  ; DAGISEL-GFX10-NEXT:   [[COPY151:%[0-9]+]]:sgpr_32 = COPY $sgpr12
  ; DAGISEL-GFX10-NEXT:   [[COPY152:%[0-9]+]]:sgpr_32 = COPY $sgpr11
  ; DAGISEL-GFX10-NEXT:   [[COPY153:%[0-9]+]]:sgpr_32 = COPY $sgpr10
  ; DAGISEL-GFX10-NEXT:   [[COPY154:%[0-9]+]]:sgpr_32 = COPY $sgpr9
  ; DAGISEL-GFX10-NEXT:   [[COPY155:%[0-9]+]]:sgpr_32 = COPY $sgpr8
  ; DAGISEL-GFX10-NEXT:   [[COPY156:%[0-9]+]]:sgpr_32 = COPY $sgpr7
  ; DAGISEL-GFX10-NEXT:   [[COPY157:%[0-9]+]]:sgpr_32 = COPY $sgpr6
  ; DAGISEL-GFX10-NEXT:   [[COPY158:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX10-NEXT:   [[COPY159:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX10-NEXT:   [[COPY160:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX10-NEXT:   [[COPY161:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX10-NEXT:   [[COPY162:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX10-NEXT:   [[COPY163:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX10-NEXT:   [[COPY164:%[0-9]+]]:sgpr_128 = COPY $sgpr48_sgpr49_sgpr50_sgpr51
  ; DAGISEL-GFX10-NEXT:   [[COPY165:%[0-9]+]]:sreg_32 = COPY $sgpr32
  ; DAGISEL-GFX10-NEXT:   [[COPY166:%[0-9]+]]:vgpr_32 = COPY [[COPY131]]
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY166]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 0, 0, 0, implicit $exec :: (store (s32) into stack, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   [[COPY167:%[0-9]+]]:vgpr_32 = COPY [[COPY130]]
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY167]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 4, 0, 0, implicit $exec :: (store (s32) into stack + 4, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   [[COPY168:%[0-9]+]]:vgpr_32 = COPY [[COPY129]]
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY168]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 8, 0, 0, implicit $exec :: (store (s32) into stack + 8, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   [[COPY169:%[0-9]+]]:vgpr_32 = COPY [[COPY128]]
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY169]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 12, 0, 0, implicit $exec :: (store (s32) into stack + 12, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY127]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 16, 0, 0, implicit $exec :: (store (s32) into stack + 16, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY126]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 20, 0, 0, implicit $exec :: (store (s32) into stack + 20, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY125]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 24, 0, 0, implicit $exec :: (store (s32) into stack + 24, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY124]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 28, 0, 0, implicit $exec :: (store (s32) into stack + 28, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY123]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 32, 0, 0, implicit $exec :: (store (s32) into stack + 32, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY122]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 36, 0, 0, implicit $exec :: (store (s32) into stack + 36, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY121]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 40, 0, 0, implicit $exec :: (store (s32) into stack + 40, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY120]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 44, 0, 0, implicit $exec :: (store (s32) into stack + 44, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY119]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 48, 0, 0, implicit $exec :: (store (s32) into stack + 48, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY118]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 52, 0, 0, implicit $exec :: (store (s32) into stack + 52, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY117]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 56, 0, 0, implicit $exec :: (store (s32) into stack + 56, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY116]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 60, 0, 0, implicit $exec :: (store (s32) into stack + 60, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY115]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 64, 0, 0, implicit $exec :: (store (s32) into stack + 64, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY114]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 68, 0, 0, implicit $exec :: (store (s32) into stack + 68, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY113]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 72, 0, 0, implicit $exec :: (store (s32) into stack + 72, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY112]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 76, 0, 0, implicit $exec :: (store (s32) into stack + 76, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY111]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 80, 0, 0, implicit $exec :: (store (s32) into stack + 80, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY110]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 84, 0, 0, implicit $exec :: (store (s32) into stack + 84, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY109]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 88, 0, 0, implicit $exec :: (store (s32) into stack + 88, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY108]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 92, 0, 0, implicit $exec :: (store (s32) into stack + 92, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY107]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 96, 0, 0, implicit $exec :: (store (s32) into stack + 96, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY106]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 100, 0, 0, implicit $exec :: (store (s32) into stack + 100, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY105]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 104, 0, 0, implicit $exec :: (store (s32) into stack + 104, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY104]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 108, 0, 0, implicit $exec :: (store (s32) into stack + 108, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY103]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 112, 0, 0, implicit $exec :: (store (s32) into stack + 112, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY102]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 116, 0, 0, implicit $exec :: (store (s32) into stack + 116, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY101]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 120, 0, 0, implicit $exec :: (store (s32) into stack + 120, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY100]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 124, 0, 0, implicit $exec :: (store (s32) into stack + 124, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY99]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 128, 0, 0, implicit $exec :: (store (s32) into stack + 128, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY98]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 132, 0, 0, implicit $exec :: (store (s32) into stack + 132, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY97]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 136, 0, 0, implicit $exec :: (store (s32) into stack + 136, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY96]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 140, 0, 0, implicit $exec :: (store (s32) into stack + 140, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY95]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 144, 0, 0, implicit $exec :: (store (s32) into stack + 144, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY94]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 148, 0, 0, implicit $exec :: (store (s32) into stack + 148, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY93]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 152, 0, 0, implicit $exec :: (store (s32) into stack + 152, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY92]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 156, 0, 0, implicit $exec :: (store (s32) into stack + 156, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY91]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 160, 0, 0, implicit $exec :: (store (s32) into stack + 160, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY90]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 164, 0, 0, implicit $exec :: (store (s32) into stack + 164, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY89]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 168, 0, 0, implicit $exec :: (store (s32) into stack + 168, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY88]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 172, 0, 0, implicit $exec :: (store (s32) into stack + 172, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY87]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 176, 0, 0, implicit $exec :: (store (s32) into stack + 176, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY86]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 180, 0, 0, implicit $exec :: (store (s32) into stack + 180, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY85]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 184, 0, 0, implicit $exec :: (store (s32) into stack + 184, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY84]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 188, 0, 0, implicit $exec :: (store (s32) into stack + 188, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY83]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 192, 0, 0, implicit $exec :: (store (s32) into stack + 192, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY82]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 196, 0, 0, implicit $exec :: (store (s32) into stack + 196, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY81]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 200, 0, 0, implicit $exec :: (store (s32) into stack + 200, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY80]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 204, 0, 0, implicit $exec :: (store (s32) into stack + 204, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY79]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 208, 0, 0, implicit $exec :: (store (s32) into stack + 208, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY78]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 212, 0, 0, implicit $exec :: (store (s32) into stack + 212, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY77]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 216, 0, 0, implicit $exec :: (store (s32) into stack + 216, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY76]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 220, 0, 0, implicit $exec :: (store (s32) into stack + 220, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY75]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 224, 0, 0, implicit $exec :: (store (s32) into stack + 224, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY74]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 228, 0, 0, implicit $exec :: (store (s32) into stack + 228, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY73]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 232, 0, 0, implicit $exec :: (store (s32) into stack + 232, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY72]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 236, 0, 0, implicit $exec :: (store (s32) into stack + 236, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY71]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 240, 0, 0, implicit $exec :: (store (s32) into stack + 240, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY70]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 244, 0, 0, implicit $exec :: (store (s32) into stack + 244, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY69]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 248, 0, 0, implicit $exec :: (store (s32) into stack + 248, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY68]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 252, 0, 0, implicit $exec :: (store (s32) into stack + 252, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY67]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 256, 0, 0, implicit $exec :: (store (s32) into stack + 256, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY66]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 260, 0, 0, implicit $exec :: (store (s32) into stack + 260, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY65]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 264, 0, 0, implicit $exec :: (store (s32) into stack + 264, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY64]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 268, 0, 0, implicit $exec :: (store (s32) into stack + 268, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY63]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 272, 0, 0, implicit $exec :: (store (s32) into stack + 272, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY62]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 276, 0, 0, implicit $exec :: (store (s32) into stack + 276, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY61]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 280, 0, 0, implicit $exec :: (store (s32) into stack + 280, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY60]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 284, 0, 0, implicit $exec :: (store (s32) into stack + 284, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY59]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 288, 0, 0, implicit $exec :: (store (s32) into stack + 288, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY58]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 292, 0, 0, implicit $exec :: (store (s32) into stack + 292, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY57]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 296, 0, 0, implicit $exec :: (store (s32) into stack + 296, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY56]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 300, 0, 0, implicit $exec :: (store (s32) into stack + 300, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY55]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 304, 0, 0, implicit $exec :: (store (s32) into stack + 304, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY54]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 308, 0, 0, implicit $exec :: (store (s32) into stack + 308, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY53]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 312, 0, 0, implicit $exec :: (store (s32) into stack + 312, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY52]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 316, 0, 0, implicit $exec :: (store (s32) into stack + 316, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY51]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 320, 0, 0, implicit $exec :: (store (s32) into stack + 320, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY50]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 324, 0, 0, implicit $exec :: (store (s32) into stack + 324, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY49]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 328, 0, 0, implicit $exec :: (store (s32) into stack + 328, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY48]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 332, 0, 0, implicit $exec :: (store (s32) into stack + 332, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY47]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 336, 0, 0, implicit $exec :: (store (s32) into stack + 336, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY46]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 340, 0, 0, implicit $exec :: (store (s32) into stack + 340, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY45]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 344, 0, 0, implicit $exec :: (store (s32) into stack + 344, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY44]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 348, 0, 0, implicit $exec :: (store (s32) into stack + 348, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY43]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 352, 0, 0, implicit $exec :: (store (s32) into stack + 352, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY42]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 356, 0, 0, implicit $exec :: (store (s32) into stack + 356, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY41]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 360, 0, 0, implicit $exec :: (store (s32) into stack + 360, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY40]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 364, 0, 0, implicit $exec :: (store (s32) into stack + 364, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY39]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 368, 0, 0, implicit $exec :: (store (s32) into stack + 368, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY38]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 372, 0, 0, implicit $exec :: (store (s32) into stack + 372, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY37]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 376, 0, 0, implicit $exec :: (store (s32) into stack + 376, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY36]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 380, 0, 0, implicit $exec :: (store (s32) into stack + 380, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY35]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 384, 0, 0, implicit $exec :: (store (s32) into stack + 384, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY34]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 388, 0, 0, implicit $exec :: (store (s32) into stack + 388, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY33]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 392, 0, 0, implicit $exec :: (store (s32) into stack + 392, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY32]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 396, 0, 0, implicit $exec :: (store (s32) into stack + 396, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY31]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 400, 0, 0, implicit $exec :: (store (s32) into stack + 400, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY30]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 404, 0, 0, implicit $exec :: (store (s32) into stack + 404, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY29]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 408, 0, 0, implicit $exec :: (store (s32) into stack + 408, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY28]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 412, 0, 0, implicit $exec :: (store (s32) into stack + 412, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY27]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 416, 0, 0, implicit $exec :: (store (s32) into stack + 416, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY26]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 420, 0, 0, implicit $exec :: (store (s32) into stack + 420, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY25]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 424, 0, 0, implicit $exec :: (store (s32) into stack + 424, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY24]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 428, 0, 0, implicit $exec :: (store (s32) into stack + 428, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY23]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 432, 0, 0, implicit $exec :: (store (s32) into stack + 432, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY22]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 436, 0, 0, implicit $exec :: (store (s32) into stack + 436, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY21]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 440, 0, 0, implicit $exec :: (store (s32) into stack + 440, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY20]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 444, 0, 0, implicit $exec :: (store (s32) into stack + 444, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY19]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 448, 0, 0, implicit $exec :: (store (s32) into stack + 448, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY18]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 452, 0, 0, implicit $exec :: (store (s32) into stack + 452, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY17]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 456, 0, 0, implicit $exec :: (store (s32) into stack + 456, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY16]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 460, 0, 0, implicit $exec :: (store (s32) into stack + 460, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY15]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 464, 0, 0, implicit $exec :: (store (s32) into stack + 464, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY14]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 468, 0, 0, implicit $exec :: (store (s32) into stack + 468, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY13]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 472, 0, 0, implicit $exec :: (store (s32) into stack + 472, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY12]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 476, 0, 0, implicit $exec :: (store (s32) into stack + 476, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY11]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 480, 0, 0, implicit $exec :: (store (s32) into stack + 480, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY10]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 484, 0, 0, implicit $exec :: (store (s32) into stack + 484, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY9]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 488, 0, 0, implicit $exec :: (store (s32) into stack + 488, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY8]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 492, 0, 0, implicit $exec :: (store (s32) into stack + 492, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY7]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 496, 0, 0, implicit $exec :: (store (s32) into stack + 496, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY6]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 500, 0, 0, implicit $exec :: (store (s32) into stack + 500, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY5]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 504, 0, 0, implicit $exec :: (store (s32) into stack + 504, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY4]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 508, 0, 0, implicit $exec :: (store (s32) into stack + 508, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY3]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 512, 0, 0, implicit $exec :: (store (s32) into stack + 512, align 16, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY2]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 516, 0, 0, implicit $exec :: (store (s32) into stack + 516, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY1]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 520, 0, 0, implicit $exec :: (store (s32) into stack + 520, align 8, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFSET [[COPY]], $sgpr48_sgpr49_sgpr50_sgpr51, [[COPY165]], 524, 0, 0, implicit $exec :: (store (s32) into stack + 524, addrspace 5)
  ; DAGISEL-GFX10-NEXT:   [[SI_PC_ADD_REL_OFFSET:%[0-9]+]]:sreg_64 = SI_PC_ADD_REL_OFFSET target-flags(amdgpu-gotprel32-lo) @use, target-flags(amdgpu-gotprel32-hi) @use, implicit-def dead $scc
  ; DAGISEL-GFX10-NEXT:   [[S_LOAD_DWORDX2_IMM:%[0-9]+]]:sreg_64_xexec = S_LOAD_DWORDX2_IMM killed [[SI_PC_ADD_REL_OFFSET]], 0, 0 :: (dereferenceable invariant load (s64) from got, addrspace 4)
  ; DAGISEL-GFX10-NEXT:   $sgpr0_sgpr1_sgpr2_sgpr3 = COPY [[COPY164]]
  ; DAGISEL-GFX10-NEXT:   $vgpr0 = COPY [[COPY163]]
  ; DAGISEL-GFX10-NEXT:   $vgpr1 = COPY [[COPY162]]
  ; DAGISEL-GFX10-NEXT:   $vgpr2 = COPY [[COPY161]]
  ; DAGISEL-GFX10-NEXT:   $vgpr3 = COPY [[COPY160]]
  ; DAGISEL-GFX10-NEXT:   $vgpr4 = COPY [[COPY159]]
  ; DAGISEL-GFX10-NEXT:   $vgpr5 = COPY [[COPY158]]
  ; DAGISEL-GFX10-NEXT:   $vgpr6 = COPY [[COPY157]]
  ; DAGISEL-GFX10-NEXT:   $vgpr7 = COPY [[COPY156]]
  ; DAGISEL-GFX10-NEXT:   $vgpr8 = COPY [[COPY155]]
  ; DAGISEL-GFX10-NEXT:   $vgpr9 = COPY [[COPY154]]
  ; DAGISEL-GFX10-NEXT:   $vgpr10 = COPY [[COPY153]]
  ; DAGISEL-GFX10-NEXT:   $vgpr11 = COPY [[COPY152]]
  ; DAGISEL-GFX10-NEXT:   $vgpr12 = COPY [[COPY151]]
  ; DAGISEL-GFX10-NEXT:   $vgpr13 = COPY [[COPY150]]
  ; DAGISEL-GFX10-NEXT:   $vgpr14 = COPY [[COPY149]]
  ; DAGISEL-GFX10-NEXT:   $vgpr15 = COPY [[COPY148]]
  ; DAGISEL-GFX10-NEXT:   $vgpr16 = COPY [[COPY147]]
  ; DAGISEL-GFX10-NEXT:   $vgpr17 = COPY [[COPY146]]
  ; DAGISEL-GFX10-NEXT:   $vgpr18 = COPY [[COPY145]]
  ; DAGISEL-GFX10-NEXT:   $vgpr19 = COPY [[COPY144]]
  ; DAGISEL-GFX10-NEXT:   $vgpr20 = COPY [[COPY143]]
  ; DAGISEL-GFX10-NEXT:   $vgpr21 = COPY [[COPY142]]
  ; DAGISEL-GFX10-NEXT:   $vgpr22 = COPY [[COPY141]]
  ; DAGISEL-GFX10-NEXT:   $vgpr23 = COPY [[COPY140]]
  ; DAGISEL-GFX10-NEXT:   $vgpr24 = COPY [[COPY139]]
  ; DAGISEL-GFX10-NEXT:   $vgpr25 = COPY [[COPY138]]
  ; DAGISEL-GFX10-NEXT:   $vgpr26 = COPY [[COPY137]]
  ; DAGISEL-GFX10-NEXT:   $vgpr27 = COPY [[COPY136]]
  ; DAGISEL-GFX10-NEXT:   $vgpr28 = COPY [[COPY135]]
  ; DAGISEL-GFX10-NEXT:   $vgpr29 = COPY [[COPY134]]
  ; DAGISEL-GFX10-NEXT:   $vgpr30 = COPY [[COPY133]]
  ; DAGISEL-GFX10-NEXT:   $vgpr31 = COPY [[COPY132]]
  ; DAGISEL-GFX10-NEXT:   $sgpr30_sgpr31 = SI_CALL killed [[S_LOAD_DWORDX2_IMM]], @use, csr_amdgpu_si_gfx, implicit $sgpr0_sgpr1_sgpr2_sgpr3, implicit $vgpr0, implicit $vgpr1, implicit $vgpr2, implicit $vgpr3, implicit $vgpr4, implicit $vgpr5, implicit $vgpr6, implicit $vgpr7, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11, implicit $vgpr12, implicit $vgpr13, implicit $vgpr14, implicit $vgpr15, implicit $vgpr16, implicit $vgpr17, implicit $vgpr18, implicit $vgpr19, implicit $vgpr20, implicit $vgpr21, implicit $vgpr22, implicit $vgpr23, implicit $vgpr24, implicit $vgpr25, implicit $vgpr26, implicit $vgpr27, implicit $vgpr28, implicit $vgpr29, implicit $vgpr30, implicit $vgpr31
  ; DAGISEL-GFX10-NEXT:   ADJCALLSTACKDOWN 0, 528, implicit-def dead $scc, implicit-def $sgpr32, implicit $sgpr32
  ; DAGISEL-GFX10-NEXT:   S_ENDPGM 0
  call amdgpu_gfx void @use(<36 x i32> %a, <128 x i32> %b)
  ret void
}

