; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -passes=instcombine < %s | FileCheck %s

define void @memset_null(i64 %len) {
; CHECK-LABEL: define void @memset_null(
; CHECK-SAME: i64 [[LEN:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[LEN]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP1]])
; CHECK-NEXT:    ret void
;
  call void @llvm.memset.p0.i64(ptr null, i8 0, i64 %len, i1 false)
  ret void
}

define void @memset_null_ub() {
; CHECK-LABEL: define void @memset_null_ub() {
; CHECK-NEXT:    store i64 poison, ptr null, align 4294967296
; CHECK-NEXT:    ret void
;
  call void @llvm.memset.p0.i64(ptr null, i8 0, i64 8, i1 false)
  ret void
}

define void @memcpy_null_src(ptr %dst, i64 %len) {
; CHECK-LABEL: define void @memcpy_null_src(
; CHECK-SAME: ptr [[DST:%.*]], i64 [[LEN:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[LEN]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP1]])
; CHECK-NEXT:    ret void
;
  call void @llvm.memcpy.p0.i64(ptr %dst, ptr null, i64 %len, i1 false)
  ret void
}

define void @memmove_null_src(ptr %dst, i64 %len) {
; CHECK-LABEL: define void @memmove_null_src(
; CHECK-SAME: ptr [[DST:%.*]], i64 [[LEN:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[LEN]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP1]])
; CHECK-NEXT:    ret void
;
  call void @llvm.memmove.p0.i64(ptr %dst, ptr null, i64 %len, i1 false)
  ret void
}

define void @memset_element_atomic(i64 %len) {
; CHECK-LABEL: define void @memset_element_atomic(
; CHECK-SAME: i64 [[LEN:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[LEN]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[TMP1]])
; CHECK-NEXT:    ret void
;
  call void @llvm.memset.element.unordered.atomic.p0.i64(ptr align 1 null, i8 0, i64 %len, i32 1)
  ret void
}

; negative tests

define void @memset_null_volatile(i64 %len) {
; CHECK-LABEL: define void @memset_null_volatile(
; CHECK-SAME: i64 [[LEN:%.*]]) {
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr null, i8 0, i64 [[LEN]], i1 true)
; CHECK-NEXT:    ret void
;
  call void @llvm.memset.p0.i64(ptr null, i8 0, i64 %len, i1 true)
  ret void
}

define void @memset_null_is_defined(i64 %len) null_pointer_is_valid {
; CHECK-LABEL: define void @memset_null_is_defined(
; CHECK-SAME: i64 [[LEN:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 4294967296 null, i8 0, i64 [[LEN]], i1 false)
; CHECK-NEXT:    ret void
;
  call void @llvm.memset.p0.i64(ptr null, i8 0, i64 %len, i1 false)
  ret void
}
