; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn -mcpu=hawaii -verify-machineinstrs < %s | FileCheck  -enable-var-scope -check-prefixes=GCN,MUBUF %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck  -enable-var-scope -check-prefixes=GCN,MUBUF %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs -mattr=+enable-flat-scratch < %s | FileCheck  -enable-var-scope -check-prefixes=GCN,FLATSCR %s

define void @callee_no_stack() #0 {
; GCN-LABEL: callee_no_stack:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
  ret void
}

define void @callee_no_stack_no_fp_elim_all() #1 {
; MUBUF-LABEL: callee_no_stack_no_fp_elim_all:
; MUBUF:       ; %bb.0:
; MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; MUBUF-NEXT:    s_mov_b32 s4, s33
; MUBUF-NEXT:    s_mov_b32 s33, s32
; MUBUF-NEXT:    s_mov_b32 s33, s4
; MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; FLATSCR-LABEL: callee_no_stack_no_fp_elim_all:
; FLATSCR:       ; %bb.0:
; FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; FLATSCR-NEXT:    s_mov_b32 s0, s33
; FLATSCR-NEXT:    s_mov_b32 s33, s32
; FLATSCR-NEXT:    s_mov_b32 s33, s0
; FLATSCR-NEXT:    s_setpc_b64 s[30:31]
  ret void
}

define void @callee_no_stack_no_fp_elim_nonleaf() #2 {
; GCN-LABEL: callee_no_stack_no_fp_elim_nonleaf:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
  ret void
}

define void @callee_with_stack() #0 {
; MUBUF-LABEL: callee_with_stack:
; MUBUF:       ; %bb.0:
; MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; MUBUF-NEXT:    v_mov_b32_e32 v0, 0
; MUBUF-NEXT:    buffer_store_dword v0, off, s[0:3], s32
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; FLATSCR-LABEL: callee_with_stack:
; FLATSCR:       ; %bb.0:
; FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; FLATSCR-NEXT:    v_mov_b32_e32 v0, 0
; FLATSCR-NEXT:    scratch_store_dword off, v0, s32
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    s_setpc_b64 s[30:31]
  %alloca = alloca i32, addrspace(5)
  store volatile i32 0, ptr addrspace(5) %alloca
  ret void
}

; Can use free call clobbered register to preserve original FP value.
define void @callee_with_stack_no_fp_elim_all() #1 {
; MUBUF-LABEL: callee_with_stack_no_fp_elim_all:
; MUBUF:       ; %bb.0:
; MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; MUBUF-NEXT:    s_mov_b32 s4, s33
; MUBUF-NEXT:    s_mov_b32 s33, s32
; MUBUF-NEXT:    s_addk_i32 s32, 0x200
; MUBUF-NEXT:    v_mov_b32_e32 v0, 0
; MUBUF-NEXT:    buffer_store_dword v0, off, s[0:3], s33
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    s_mov_b32 s32, s33
; MUBUF-NEXT:    s_mov_b32 s33, s4
; MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; FLATSCR-LABEL: callee_with_stack_no_fp_elim_all:
; FLATSCR:       ; %bb.0:
; FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; FLATSCR-NEXT:    s_mov_b32 s0, s33
; FLATSCR-NEXT:    s_mov_b32 s33, s32
; FLATSCR-NEXT:    s_add_i32 s32, s32, 8
; FLATSCR-NEXT:    v_mov_b32_e32 v0, 0
; FLATSCR-NEXT:    scratch_store_dword off, v0, s33
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    s_mov_b32 s32, s33
; FLATSCR-NEXT:    s_mov_b32 s33, s0
; FLATSCR-NEXT:    s_setpc_b64 s[30:31]
  %alloca = alloca i32, addrspace(5)
  store volatile i32 0, ptr addrspace(5) %alloca
  ret void
}

define void @callee_with_stack_no_fp_elim_non_leaf() #2 {
; MUBUF-LABEL: callee_with_stack_no_fp_elim_non_leaf:
; MUBUF:       ; %bb.0:
; MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; MUBUF-NEXT:    v_mov_b32_e32 v0, 0
; MUBUF-NEXT:    buffer_store_dword v0, off, s[0:3], s32
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; FLATSCR-LABEL: callee_with_stack_no_fp_elim_non_leaf:
; FLATSCR:       ; %bb.0:
; FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; FLATSCR-NEXT:    v_mov_b32_e32 v0, 0
; FLATSCR-NEXT:    scratch_store_dword off, v0, s32
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    s_setpc_b64 s[30:31]
  %alloca = alloca i32, addrspace(5)
  store volatile i32 0, ptr addrspace(5) %alloca
  ret void
}

define void @callee_with_stack_and_call() #0 {
; MUBUF-LABEL: callee_with_stack_and_call:
; MUBUF:       ; %bb.0:
; MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; MUBUF-NEXT:    s_mov_b32 s16, s33
; MUBUF-NEXT:    s_mov_b32 s33, s32
; MUBUF-NEXT:    s_or_saveexec_b64 s[18:19], -1
; MUBUF-NEXT:    buffer_store_dword v40, off, s[0:3], s33 offset:4 ; 4-byte Folded Spill
; MUBUF-NEXT:    s_mov_b64 exec, s[18:19]
; MUBUF-NEXT:    v_writelane_b32 v40, s16, 2
; MUBUF-NEXT:    s_addk_i32 s32, 0x400
; MUBUF-NEXT:    v_writelane_b32 v40, s30, 0
; MUBUF-NEXT:    v_mov_b32_e32 v0, 0
; MUBUF-NEXT:    s_getpc_b64 s[16:17]
; MUBUF-NEXT:    s_add_u32 s16, s16, external_void_func_void@rel32@lo+4
; MUBUF-NEXT:    s_addc_u32 s17, s17, external_void_func_void@rel32@hi+12
; MUBUF-NEXT:    v_writelane_b32 v40, s31, 1
; MUBUF-NEXT:    buffer_store_dword v0, off, s[0:3], s33
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; MUBUF-NEXT:    v_readlane_b32 s31, v40, 1
; MUBUF-NEXT:    v_readlane_b32 s30, v40, 0
; MUBUF-NEXT:    s_mov_b32 s32, s33
; MUBUF-NEXT:    v_readlane_b32 s4, v40, 2
; MUBUF-NEXT:    s_or_saveexec_b64 s[6:7], -1
; MUBUF-NEXT:    buffer_load_dword v40, off, s[0:3], s33 offset:4 ; 4-byte Folded Reload
; MUBUF-NEXT:    s_mov_b64 exec, s[6:7]
; MUBUF-NEXT:    s_mov_b32 s33, s4
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; FLATSCR-LABEL: callee_with_stack_and_call:
; FLATSCR:       ; %bb.0:
; FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; FLATSCR-NEXT:    s_mov_b32 s0, s33
; FLATSCR-NEXT:    s_mov_b32 s33, s32
; FLATSCR-NEXT:    s_or_saveexec_b64 s[2:3], -1
; FLATSCR-NEXT:    scratch_store_dword off, v40, s33 offset:4 ; 4-byte Folded Spill
; FLATSCR-NEXT:    s_mov_b64 exec, s[2:3]
; FLATSCR-NEXT:    v_writelane_b32 v40, s0, 2
; FLATSCR-NEXT:    s_add_i32 s32, s32, 16
; FLATSCR-NEXT:    v_writelane_b32 v40, s30, 0
; FLATSCR-NEXT:    v_mov_b32_e32 v0, 0
; FLATSCR-NEXT:    s_getpc_b64 s[0:1]
; FLATSCR-NEXT:    s_add_u32 s0, s0, external_void_func_void@rel32@lo+4
; FLATSCR-NEXT:    s_addc_u32 s1, s1, external_void_func_void@rel32@hi+12
; FLATSCR-NEXT:    v_writelane_b32 v40, s31, 1
; FLATSCR-NEXT:    scratch_store_dword off, v0, s33
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; FLATSCR-NEXT:    v_readlane_b32 s31, v40, 1
; FLATSCR-NEXT:    v_readlane_b32 s30, v40, 0
; FLATSCR-NEXT:    s_mov_b32 s32, s33
; FLATSCR-NEXT:    v_readlane_b32 s0, v40, 2
; FLATSCR-NEXT:    s_or_saveexec_b64 s[2:3], -1
; FLATSCR-NEXT:    scratch_load_dword v40, off, s33 offset:4 ; 4-byte Folded Reload
; FLATSCR-NEXT:    s_mov_b64 exec, s[2:3]
; FLATSCR-NEXT:    s_mov_b32 s33, s0
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    s_setpc_b64 s[30:31]
  %alloca = alloca i32, addrspace(5)
  store volatile i32 0, ptr addrspace(5) %alloca
  call void @external_void_func_void()
  ret void
}

; Should be able to copy incoming stack pointer directly to inner
; call's stack pointer argument.

; There is stack usage only because of the need to evict a VGPR for
; spilling CSR SGPRs.

define void @callee_no_stack_with_call() #0 {
; MUBUF-LABEL: callee_no_stack_with_call:
; MUBUF:       ; %bb.0:
; MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; MUBUF-NEXT:    s_mov_b32 s16, s33
; MUBUF-NEXT:    s_mov_b32 s33, s32
; MUBUF-NEXT:    s_or_saveexec_b64 s[18:19], -1
; MUBUF-NEXT:    buffer_store_dword v40, off, s[0:3], s33 ; 4-byte Folded Spill
; MUBUF-NEXT:    s_mov_b64 exec, s[18:19]
; MUBUF-NEXT:    v_writelane_b32 v40, s16, 2
; MUBUF-NEXT:    s_addk_i32 s32, 0x400
; MUBUF-NEXT:    v_writelane_b32 v40, s30, 0
; MUBUF-NEXT:    s_getpc_b64 s[16:17]
; MUBUF-NEXT:    s_add_u32 s16, s16, external_void_func_void@rel32@lo+4
; MUBUF-NEXT:    s_addc_u32 s17, s17, external_void_func_void@rel32@hi+12
; MUBUF-NEXT:    v_writelane_b32 v40, s31, 1
; MUBUF-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; MUBUF-NEXT:    v_readlane_b32 s31, v40, 1
; MUBUF-NEXT:    v_readlane_b32 s30, v40, 0
; MUBUF-NEXT:    s_mov_b32 s32, s33
; MUBUF-NEXT:    v_readlane_b32 s4, v40, 2
; MUBUF-NEXT:    s_or_saveexec_b64 s[6:7], -1
; MUBUF-NEXT:    buffer_load_dword v40, off, s[0:3], s33 ; 4-byte Folded Reload
; MUBUF-NEXT:    s_mov_b64 exec, s[6:7]
; MUBUF-NEXT:    s_mov_b32 s33, s4
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; FLATSCR-LABEL: callee_no_stack_with_call:
; FLATSCR:       ; %bb.0:
; FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; FLATSCR-NEXT:    s_mov_b32 s0, s33
; FLATSCR-NEXT:    s_mov_b32 s33, s32
; FLATSCR-NEXT:    s_or_saveexec_b64 s[2:3], -1
; FLATSCR-NEXT:    scratch_store_dword off, v40, s33 ; 4-byte Folded Spill
; FLATSCR-NEXT:    s_mov_b64 exec, s[2:3]
; FLATSCR-NEXT:    v_writelane_b32 v40, s0, 2
; FLATSCR-NEXT:    s_add_i32 s32, s32, 16
; FLATSCR-NEXT:    v_writelane_b32 v40, s30, 0
; FLATSCR-NEXT:    s_getpc_b64 s[0:1]
; FLATSCR-NEXT:    s_add_u32 s0, s0, external_void_func_void@rel32@lo+4
; FLATSCR-NEXT:    s_addc_u32 s1, s1, external_void_func_void@rel32@hi+12
; FLATSCR-NEXT:    v_writelane_b32 v40, s31, 1
; FLATSCR-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; FLATSCR-NEXT:    v_readlane_b32 s31, v40, 1
; FLATSCR-NEXT:    v_readlane_b32 s30, v40, 0
; FLATSCR-NEXT:    s_mov_b32 s32, s33
; FLATSCR-NEXT:    v_readlane_b32 s0, v40, 2
; FLATSCR-NEXT:    s_or_saveexec_b64 s[2:3], -1
; FLATSCR-NEXT:    scratch_load_dword v40, off, s33 ; 4-byte Folded Reload
; FLATSCR-NEXT:    s_mov_b64 exec, s[2:3]
; FLATSCR-NEXT:    s_mov_b32 s33, s0
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    s_setpc_b64 s[30:31]
  call void @external_void_func_void()
  ret void
}

declare hidden void @external_void_func_void() #0

; Make sure if a CSR vgpr is used for SGPR spilling, it is saved and
; restored. No FP is required.
define void @callee_func_sgpr_spill_no_calls(i32 %in) #0 {
; MUBUF-LABEL: callee_func_sgpr_spill_no_calls:
; MUBUF:       ; %bb.0:
; MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; MUBUF-NEXT:    s_or_saveexec_b64 s[4:5], -1
; MUBUF-NEXT:    buffer_store_dword v40, off, s[0:3], s32 ; 4-byte Folded Spill
; MUBUF-NEXT:    s_mov_b64 exec, s[4:5]
; MUBUF-NEXT:    v_writelane_b32 v40, s36, 0
; MUBUF-NEXT:    v_writelane_b32 v40, s37, 1
; MUBUF-NEXT:    v_writelane_b32 v40, s38, 2
; MUBUF-NEXT:    v_writelane_b32 v40, s39, 3
; MUBUF-NEXT:    v_writelane_b32 v40, s48, 4
; MUBUF-NEXT:    v_writelane_b32 v40, s49, 5
; MUBUF-NEXT:    v_writelane_b32 v40, s50, 6
; MUBUF-NEXT:    v_writelane_b32 v40, s51, 7
; MUBUF-NEXT:    v_writelane_b32 v40, s52, 8
; MUBUF-NEXT:    v_writelane_b32 v40, s53, 9
; MUBUF-NEXT:    v_writelane_b32 v40, s54, 10
; MUBUF-NEXT:    v_writelane_b32 v40, s55, 11
; MUBUF-NEXT:    v_writelane_b32 v40, s64, 12
; MUBUF-NEXT:    v_writelane_b32 v40, s65, 13
; MUBUF-NEXT:    v_writelane_b32 v40, s66, 14
; MUBUF-NEXT:    v_writelane_b32 v40, s67, 15
; MUBUF-NEXT:    v_writelane_b32 v40, s68, 16
; MUBUF-NEXT:    v_writelane_b32 v40, s69, 17
; MUBUF-NEXT:    v_writelane_b32 v40, s70, 18
; MUBUF-NEXT:    v_writelane_b32 v40, s71, 19
; MUBUF-NEXT:    v_writelane_b32 v40, s80, 20
; MUBUF-NEXT:    v_writelane_b32 v40, s81, 21
; MUBUF-NEXT:    v_writelane_b32 v40, s82, 22
; MUBUF-NEXT:    v_writelane_b32 v40, s83, 23
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; def s[68:83]
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; def s[52:67]
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; def s[36:51]
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; def s[4:19]
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; def s[20:27]
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; def s[28:29]
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; use s[68:83]
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; use s[52:67]
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; use s[36:51]
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; use s[20:27]
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; use s[28:29]
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; use s[4:19]
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    v_readlane_b32 s83, v40, 23
; MUBUF-NEXT:    v_readlane_b32 s82, v40, 22
; MUBUF-NEXT:    v_readlane_b32 s81, v40, 21
; MUBUF-NEXT:    v_readlane_b32 s80, v40, 20
; MUBUF-NEXT:    v_readlane_b32 s71, v40, 19
; MUBUF-NEXT:    v_readlane_b32 s70, v40, 18
; MUBUF-NEXT:    v_readlane_b32 s69, v40, 17
; MUBUF-NEXT:    v_readlane_b32 s68, v40, 16
; MUBUF-NEXT:    v_readlane_b32 s67, v40, 15
; MUBUF-NEXT:    v_readlane_b32 s66, v40, 14
; MUBUF-NEXT:    v_readlane_b32 s65, v40, 13
; MUBUF-NEXT:    v_readlane_b32 s64, v40, 12
; MUBUF-NEXT:    v_readlane_b32 s55, v40, 11
; MUBUF-NEXT:    v_readlane_b32 s54, v40, 10
; MUBUF-NEXT:    v_readlane_b32 s53, v40, 9
; MUBUF-NEXT:    v_readlane_b32 s52, v40, 8
; MUBUF-NEXT:    v_readlane_b32 s51, v40, 7
; MUBUF-NEXT:    v_readlane_b32 s50, v40, 6
; MUBUF-NEXT:    v_readlane_b32 s49, v40, 5
; MUBUF-NEXT:    v_readlane_b32 s48, v40, 4
; MUBUF-NEXT:    v_readlane_b32 s39, v40, 3
; MUBUF-NEXT:    v_readlane_b32 s38, v40, 2
; MUBUF-NEXT:    v_readlane_b32 s37, v40, 1
; MUBUF-NEXT:    v_readlane_b32 s36, v40, 0
; MUBUF-NEXT:    s_or_saveexec_b64 s[4:5], -1
; MUBUF-NEXT:    buffer_load_dword v40, off, s[0:3], s32 ; 4-byte Folded Reload
; MUBUF-NEXT:    s_mov_b64 exec, s[4:5]
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; FLATSCR-LABEL: callee_func_sgpr_spill_no_calls:
; FLATSCR:       ; %bb.0:
; FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; FLATSCR-NEXT:    s_or_saveexec_b64 s[0:1], -1
; FLATSCR-NEXT:    scratch_store_dword off, v40, s32 ; 4-byte Folded Spill
; FLATSCR-NEXT:    s_mov_b64 exec, s[0:1]
; FLATSCR-NEXT:    v_writelane_b32 v40, s30, 0
; FLATSCR-NEXT:    v_writelane_b32 v40, s31, 1
; FLATSCR-NEXT:    v_writelane_b32 v40, s36, 2
; FLATSCR-NEXT:    v_writelane_b32 v40, s37, 3
; FLATSCR-NEXT:    v_writelane_b32 v40, s38, 4
; FLATSCR-NEXT:    v_writelane_b32 v40, s39, 5
; FLATSCR-NEXT:    v_writelane_b32 v40, s48, 6
; FLATSCR-NEXT:    v_writelane_b32 v40, s49, 7
; FLATSCR-NEXT:    v_writelane_b32 v40, s50, 8
; FLATSCR-NEXT:    v_writelane_b32 v40, s51, 9
; FLATSCR-NEXT:    v_writelane_b32 v40, s52, 10
; FLATSCR-NEXT:    v_writelane_b32 v40, s53, 11
; FLATSCR-NEXT:    v_writelane_b32 v40, s54, 12
; FLATSCR-NEXT:    v_writelane_b32 v40, s55, 13
; FLATSCR-NEXT:    v_writelane_b32 v40, s64, 14
; FLATSCR-NEXT:    v_writelane_b32 v40, s65, 15
; FLATSCR-NEXT:    v_writelane_b32 v40, s66, 16
; FLATSCR-NEXT:    v_writelane_b32 v40, s67, 17
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; def s[52:67]
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; def s[36:51]
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; def s[16:31]
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; def s[0:15]
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; def s[72:79]
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; def s[88:89]
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; use s[52:67]
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; use s[36:51]
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; use s[16:31]
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; use s[72:79]
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; use s[88:89]
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; use s[0:15]
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    v_readlane_b32 s67, v40, 17
; FLATSCR-NEXT:    v_readlane_b32 s66, v40, 16
; FLATSCR-NEXT:    v_readlane_b32 s65, v40, 15
; FLATSCR-NEXT:    v_readlane_b32 s64, v40, 14
; FLATSCR-NEXT:    v_readlane_b32 s55, v40, 13
; FLATSCR-NEXT:    v_readlane_b32 s54, v40, 12
; FLATSCR-NEXT:    v_readlane_b32 s53, v40, 11
; FLATSCR-NEXT:    v_readlane_b32 s52, v40, 10
; FLATSCR-NEXT:    v_readlane_b32 s51, v40, 9
; FLATSCR-NEXT:    v_readlane_b32 s50, v40, 8
; FLATSCR-NEXT:    v_readlane_b32 s49, v40, 7
; FLATSCR-NEXT:    v_readlane_b32 s48, v40, 6
; FLATSCR-NEXT:    v_readlane_b32 s39, v40, 5
; FLATSCR-NEXT:    v_readlane_b32 s38, v40, 4
; FLATSCR-NEXT:    v_readlane_b32 s37, v40, 3
; FLATSCR-NEXT:    v_readlane_b32 s36, v40, 2
; FLATSCR-NEXT:    v_readlane_b32 s31, v40, 1
; FLATSCR-NEXT:    v_readlane_b32 s30, v40, 0
; FLATSCR-NEXT:    s_or_saveexec_b64 s[0:1], -1
; FLATSCR-NEXT:    scratch_load_dword v40, off, s32 ; 4-byte Folded Reload
; FLATSCR-NEXT:    s_mov_b64 exec, s[0:1]
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    s_setpc_b64 s[30:31]
  call void asm sideeffect "", "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7}"() #0
  call void asm sideeffect "", "~{v8},~{v9},~{v10},~{v11},~{v12},~{v13},~{v14},~{v15}"() #0
  call void asm sideeffect "", "~{v16},~{v17},~{v18},~{v19},~{v20},~{v21},~{v22},~{v23}"() #0
  call void asm sideeffect "", "~{v24},~{v25},~{v26},~{v27},~{v28},~{v29},~{v30},~{v31}"() #0
  call void asm sideeffect "", "~{v32},~{v33},~{v34},~{v35},~{v36},~{v37},~{v38},~{v39}"() #0

  %wide.sgpr0 = call <16 x i32> asm sideeffect "; def $0", "=s" () #0
  %wide.sgpr1 = call <16 x i32> asm sideeffect "; def $0", "=s" () #0
  %wide.sgpr2 = call <16 x i32> asm sideeffect "; def $0", "=s" () #0
  %wide.sgpr5 = call <16 x i32> asm sideeffect "; def $0", "=s" () #0
  %wide.sgpr3 = call <8 x i32> asm sideeffect "; def $0", "=s" () #0
  %wide.sgpr4 = call <2 x i32> asm sideeffect "; def $0", "=s" () #0

  call void asm sideeffect "; use $0", "s"(<16 x i32> %wide.sgpr0) #0
  call void asm sideeffect "; use $0", "s"(<16 x i32> %wide.sgpr1) #0
  call void asm sideeffect "; use $0", "s"(<16 x i32> %wide.sgpr2) #0
  call void asm sideeffect "; use $0", "s"(<8 x i32> %wide.sgpr3) #0
  call void asm sideeffect "; use $0", "s"(<2 x i32> %wide.sgpr4) #0
  call void asm sideeffect "; use $0", "s"(<16 x i32> %wide.sgpr5) #0
  ret void
}

; Has no spilled CSR VGPRs used for SGPR spilling, so no need to
; enable all lanes and restore.
define void @spill_only_csr_sgpr() {
; GCN-LABEL: spill_only_csr_sgpr:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    ;;#ASMSTART
; GCN-NEXT:    ; clobber s42
; GCN-NEXT:    ;;#ASMEND
; GCN-NEXT:    s_setpc_b64 s[30:31]
  call void asm sideeffect "; clobber s42", "~{s42}"()
  ret void
}

; TODO: Can the SP inc/deec be remvoed?
define void @callee_with_stack_no_fp_elim_csr_vgpr() #1 {
; MUBUF-LABEL: callee_with_stack_no_fp_elim_csr_vgpr:
; MUBUF:       ; %bb.0:
; MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; MUBUF-NEXT:    s_mov_b32 s4, s33
; MUBUF-NEXT:    s_mov_b32 s33, s32
; MUBUF-NEXT:    v_mov_b32_e32 v0, 0
; MUBUF-NEXT:    buffer_store_dword v41, off, s[0:3], s33 ; 4-byte Folded Spill
; MUBUF-NEXT:    buffer_store_dword v0, off, s[0:3], s33 offset:4
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; clobber v41
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    buffer_load_dword v41, off, s[0:3], s33 ; 4-byte Folded Reload
; MUBUF-NEXT:    s_addk_i32 s32, 0x300
; MUBUF-NEXT:    s_mov_b32 s32, s33
; MUBUF-NEXT:    s_mov_b32 s33, s4
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; FLATSCR-LABEL: callee_with_stack_no_fp_elim_csr_vgpr:
; FLATSCR:       ; %bb.0:
; FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; FLATSCR-NEXT:    s_mov_b32 s0, s33
; FLATSCR-NEXT:    s_mov_b32 s33, s32
; FLATSCR-NEXT:    v_mov_b32_e32 v0, 0
; FLATSCR-NEXT:    scratch_store_dword off, v41, s33 ; 4-byte Folded Spill
; FLATSCR-NEXT:    scratch_store_dword off, v0, s33 offset:4
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; clobber v41
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    scratch_load_dword v41, off, s33 ; 4-byte Folded Reload
; FLATSCR-NEXT:    s_add_i32 s32, s32, 12
; FLATSCR-NEXT:    s_mov_b32 s32, s33
; FLATSCR-NEXT:    s_mov_b32 s33, s0
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    s_setpc_b64 s[30:31]
  %alloca = alloca i32, addrspace(5)
  store volatile i32 0, ptr addrspace(5) %alloca
  call void asm sideeffect "; clobber v41", "~{v41}"()
  ret void
}

; Use a copy to a free SGPR instead of introducing a second CSR VGPR.
define void @last_lane_vgpr_for_fp_csr() #1 {
; MUBUF-LABEL: last_lane_vgpr_for_fp_csr:
; MUBUF:       ; %bb.0:
; MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; MUBUF-NEXT:    s_mov_b32 s4, s33
; MUBUF-NEXT:    s_mov_b32 s33, s32
; MUBUF-NEXT:    s_xor_saveexec_b64 s[6:7], -1
; MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], s33 offset:8 ; 4-byte Folded Spill
; MUBUF-NEXT:    s_mov_b64 exec, s[6:7]
; MUBUF-NEXT:    v_writelane_b32 v1, s48, 0
; MUBUF-NEXT:    v_writelane_b32 v1, s49, 1
; MUBUF-NEXT:    v_writelane_b32 v1, s50, 2
; MUBUF-NEXT:    v_writelane_b32 v1, s51, 3
; MUBUF-NEXT:    v_writelane_b32 v1, s52, 4
; MUBUF-NEXT:    v_writelane_b32 v1, s53, 5
; MUBUF-NEXT:    v_writelane_b32 v1, s54, 6
; MUBUF-NEXT:    v_writelane_b32 v1, s55, 7
; MUBUF-NEXT:    v_writelane_b32 v1, s64, 8
; MUBUF-NEXT:    v_writelane_b32 v1, s65, 9
; MUBUF-NEXT:    v_writelane_b32 v1, s66, 10
; MUBUF-NEXT:    v_writelane_b32 v1, s67, 11
; MUBUF-NEXT:    v_writelane_b32 v1, s68, 12
; MUBUF-NEXT:    v_writelane_b32 v1, s69, 13
; MUBUF-NEXT:    v_writelane_b32 v1, s70, 14
; MUBUF-NEXT:    v_writelane_b32 v1, s71, 15
; MUBUF-NEXT:    v_writelane_b32 v1, s80, 16
; MUBUF-NEXT:    v_writelane_b32 v1, s81, 17
; MUBUF-NEXT:    v_writelane_b32 v1, s82, 18
; MUBUF-NEXT:    v_writelane_b32 v1, s83, 19
; MUBUF-NEXT:    v_writelane_b32 v1, s84, 20
; MUBUF-NEXT:    v_writelane_b32 v1, s85, 21
; MUBUF-NEXT:    v_writelane_b32 v1, s86, 22
; MUBUF-NEXT:    v_writelane_b32 v1, s87, 23
; MUBUF-NEXT:    v_writelane_b32 v1, s96, 24
; MUBUF-NEXT:    v_writelane_b32 v1, s97, 25
; MUBUF-NEXT:    v_writelane_b32 v1, s98, 26
; MUBUF-NEXT:    v_writelane_b32 v1, s99, 27
; MUBUF-NEXT:    v_writelane_b32 v1, s100, 28
; MUBUF-NEXT:    v_mov_b32_e32 v0, 0
; MUBUF-NEXT:    buffer_store_dword v41, off, s[0:3], s33 ; 4-byte Folded Spill
; MUBUF-NEXT:    v_writelane_b32 v1, s101, 29
; MUBUF-NEXT:    buffer_store_dword v0, off, s[0:3], s33 offset:4
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; clobber v41
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    v_writelane_b32 v1, s102, 30
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    buffer_load_dword v41, off, s[0:3], s33 ; 4-byte Folded Reload
; MUBUF-NEXT:    s_addk_i32 s32, 0x400
; MUBUF-NEXT:    v_readlane_b32 s102, v1, 30
; MUBUF-NEXT:    v_readlane_b32 s101, v1, 29
; MUBUF-NEXT:    v_readlane_b32 s100, v1, 28
; MUBUF-NEXT:    v_readlane_b32 s99, v1, 27
; MUBUF-NEXT:    v_readlane_b32 s98, v1, 26
; MUBUF-NEXT:    v_readlane_b32 s97, v1, 25
; MUBUF-NEXT:    v_readlane_b32 s96, v1, 24
; MUBUF-NEXT:    v_readlane_b32 s87, v1, 23
; MUBUF-NEXT:    v_readlane_b32 s86, v1, 22
; MUBUF-NEXT:    v_readlane_b32 s85, v1, 21
; MUBUF-NEXT:    v_readlane_b32 s84, v1, 20
; MUBUF-NEXT:    v_readlane_b32 s83, v1, 19
; MUBUF-NEXT:    v_readlane_b32 s82, v1, 18
; MUBUF-NEXT:    v_readlane_b32 s81, v1, 17
; MUBUF-NEXT:    v_readlane_b32 s80, v1, 16
; MUBUF-NEXT:    v_readlane_b32 s71, v1, 15
; MUBUF-NEXT:    v_readlane_b32 s70, v1, 14
; MUBUF-NEXT:    v_readlane_b32 s69, v1, 13
; MUBUF-NEXT:    v_readlane_b32 s68, v1, 12
; MUBUF-NEXT:    v_readlane_b32 s67, v1, 11
; MUBUF-NEXT:    v_readlane_b32 s66, v1, 10
; MUBUF-NEXT:    v_readlane_b32 s65, v1, 9
; MUBUF-NEXT:    v_readlane_b32 s64, v1, 8
; MUBUF-NEXT:    v_readlane_b32 s55, v1, 7
; MUBUF-NEXT:    v_readlane_b32 s54, v1, 6
; MUBUF-NEXT:    v_readlane_b32 s53, v1, 5
; MUBUF-NEXT:    v_readlane_b32 s52, v1, 4
; MUBUF-NEXT:    v_readlane_b32 s51, v1, 3
; MUBUF-NEXT:    v_readlane_b32 s50, v1, 2
; MUBUF-NEXT:    v_readlane_b32 s49, v1, 1
; MUBUF-NEXT:    v_readlane_b32 s48, v1, 0
; MUBUF-NEXT:    s_mov_b32 s32, s33
; MUBUF-NEXT:    s_xor_saveexec_b64 s[6:7], -1
; MUBUF-NEXT:    buffer_load_dword v1, off, s[0:3], s33 offset:8 ; 4-byte Folded Reload
; MUBUF-NEXT:    s_mov_b64 exec, s[6:7]
; MUBUF-NEXT:    s_mov_b32 s33, s4
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; FLATSCR-LABEL: last_lane_vgpr_for_fp_csr:
; FLATSCR:       ; %bb.0:
; FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; FLATSCR-NEXT:    s_mov_b32 s0, s33
; FLATSCR-NEXT:    s_mov_b32 s33, s32
; FLATSCR-NEXT:    s_xor_saveexec_b64 s[2:3], -1
; FLATSCR-NEXT:    scratch_store_dword off, v1, s33 offset:8 ; 4-byte Folded Spill
; FLATSCR-NEXT:    s_mov_b64 exec, s[2:3]
; FLATSCR-NEXT:    v_writelane_b32 v1, s48, 0
; FLATSCR-NEXT:    v_writelane_b32 v1, s49, 1
; FLATSCR-NEXT:    v_writelane_b32 v1, s50, 2
; FLATSCR-NEXT:    v_writelane_b32 v1, s51, 3
; FLATSCR-NEXT:    v_writelane_b32 v1, s52, 4
; FLATSCR-NEXT:    v_writelane_b32 v1, s53, 5
; FLATSCR-NEXT:    v_writelane_b32 v1, s54, 6
; FLATSCR-NEXT:    v_writelane_b32 v1, s55, 7
; FLATSCR-NEXT:    v_writelane_b32 v1, s64, 8
; FLATSCR-NEXT:    v_writelane_b32 v1, s65, 9
; FLATSCR-NEXT:    v_writelane_b32 v1, s66, 10
; FLATSCR-NEXT:    v_writelane_b32 v1, s67, 11
; FLATSCR-NEXT:    v_writelane_b32 v1, s68, 12
; FLATSCR-NEXT:    v_writelane_b32 v1, s69, 13
; FLATSCR-NEXT:    v_writelane_b32 v1, s70, 14
; FLATSCR-NEXT:    v_writelane_b32 v1, s71, 15
; FLATSCR-NEXT:    v_writelane_b32 v1, s80, 16
; FLATSCR-NEXT:    v_writelane_b32 v1, s81, 17
; FLATSCR-NEXT:    v_writelane_b32 v1, s82, 18
; FLATSCR-NEXT:    v_writelane_b32 v1, s83, 19
; FLATSCR-NEXT:    v_writelane_b32 v1, s84, 20
; FLATSCR-NEXT:    v_writelane_b32 v1, s85, 21
; FLATSCR-NEXT:    v_writelane_b32 v1, s86, 22
; FLATSCR-NEXT:    v_writelane_b32 v1, s87, 23
; FLATSCR-NEXT:    v_writelane_b32 v1, s96, 24
; FLATSCR-NEXT:    v_writelane_b32 v1, s97, 25
; FLATSCR-NEXT:    v_writelane_b32 v1, s98, 26
; FLATSCR-NEXT:    v_writelane_b32 v1, s99, 27
; FLATSCR-NEXT:    v_writelane_b32 v1, s100, 28
; FLATSCR-NEXT:    v_mov_b32_e32 v0, 0
; FLATSCR-NEXT:    scratch_store_dword off, v41, s33 ; 4-byte Folded Spill
; FLATSCR-NEXT:    v_writelane_b32 v1, s101, 29
; FLATSCR-NEXT:    scratch_store_dword off, v0, s33 offset:4
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; clobber v41
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    v_writelane_b32 v1, s102, 30
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    scratch_load_dword v41, off, s33 ; 4-byte Folded Reload
; FLATSCR-NEXT:    s_add_i32 s32, s32, 16
; FLATSCR-NEXT:    v_readlane_b32 s102, v1, 30
; FLATSCR-NEXT:    v_readlane_b32 s101, v1, 29
; FLATSCR-NEXT:    v_readlane_b32 s100, v1, 28
; FLATSCR-NEXT:    v_readlane_b32 s99, v1, 27
; FLATSCR-NEXT:    v_readlane_b32 s98, v1, 26
; FLATSCR-NEXT:    v_readlane_b32 s97, v1, 25
; FLATSCR-NEXT:    v_readlane_b32 s96, v1, 24
; FLATSCR-NEXT:    v_readlane_b32 s87, v1, 23
; FLATSCR-NEXT:    v_readlane_b32 s86, v1, 22
; FLATSCR-NEXT:    v_readlane_b32 s85, v1, 21
; FLATSCR-NEXT:    v_readlane_b32 s84, v1, 20
; FLATSCR-NEXT:    v_readlane_b32 s83, v1, 19
; FLATSCR-NEXT:    v_readlane_b32 s82, v1, 18
; FLATSCR-NEXT:    v_readlane_b32 s81, v1, 17
; FLATSCR-NEXT:    v_readlane_b32 s80, v1, 16
; FLATSCR-NEXT:    v_readlane_b32 s71, v1, 15
; FLATSCR-NEXT:    v_readlane_b32 s70, v1, 14
; FLATSCR-NEXT:    v_readlane_b32 s69, v1, 13
; FLATSCR-NEXT:    v_readlane_b32 s68, v1, 12
; FLATSCR-NEXT:    v_readlane_b32 s67, v1, 11
; FLATSCR-NEXT:    v_readlane_b32 s66, v1, 10
; FLATSCR-NEXT:    v_readlane_b32 s65, v1, 9
; FLATSCR-NEXT:    v_readlane_b32 s64, v1, 8
; FLATSCR-NEXT:    v_readlane_b32 s55, v1, 7
; FLATSCR-NEXT:    v_readlane_b32 s54, v1, 6
; FLATSCR-NEXT:    v_readlane_b32 s53, v1, 5
; FLATSCR-NEXT:    v_readlane_b32 s52, v1, 4
; FLATSCR-NEXT:    v_readlane_b32 s51, v1, 3
; FLATSCR-NEXT:    v_readlane_b32 s50, v1, 2
; FLATSCR-NEXT:    v_readlane_b32 s49, v1, 1
; FLATSCR-NEXT:    v_readlane_b32 s48, v1, 0
; FLATSCR-NEXT:    s_mov_b32 s32, s33
; FLATSCR-NEXT:    s_xor_saveexec_b64 s[2:3], -1
; FLATSCR-NEXT:    scratch_load_dword v1, off, s33 offset:8 ; 4-byte Folded Reload
; FLATSCR-NEXT:    s_mov_b64 exec, s[2:3]
; FLATSCR-NEXT:    s_mov_b32 s33, s0
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    s_setpc_b64 s[30:31]
  %alloca = alloca i32, addrspace(5)
  store volatile i32 0, ptr addrspace(5) %alloca
  call void asm sideeffect "; clobber v41", "~{v41}"()
  call void asm sideeffect "",
    "~{s40},~{s41},~{s42},~{s43},~{s44},~{s45},~{s46},~{s47},~{s48},~{s49}
    ,~{s50},~{s51},~{s52},~{s53},~{s54},~{s55},~{s56},~{s57},~{s58},~{s59}
    ,~{s60},~{s61},~{s62},~{s63},~{s64},~{s65},~{s66},~{s67},~{s68},~{s69}
    ,~{s70},~{s71},~{s72},~{s73},~{s74},~{s75},~{s76},~{s77},~{s78},~{s79}
    ,~{s80},~{s81},~{s82},~{s83},~{s84},~{s85},~{s86},~{s87},~{s88},~{s89}
    ,~{s90},~{s91},~{s92},~{s93},~{s94},~{s95},~{s96},~{s97},~{s98},~{s99}
    ,~{s100},~{s101},~{s102}"() #1

  ret void
}

; Use a copy to a free SGPR instead of introducing a second CSR VGPR.
define void @no_new_vgpr_for_fp_csr() #1 {
; MUBUF-LABEL: no_new_vgpr_for_fp_csr:
; MUBUF:       ; %bb.0:
; MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; MUBUF-NEXT:    s_mov_b32 s4, s33
; MUBUF-NEXT:    s_mov_b32 s33, s32
; MUBUF-NEXT:    s_xor_saveexec_b64 s[6:7], -1
; MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], s33 offset:8 ; 4-byte Folded Spill
; MUBUF-NEXT:    s_mov_b64 exec, s[6:7]
; MUBUF-NEXT:    v_writelane_b32 v1, s39, 0
; MUBUF-NEXT:    v_writelane_b32 v1, s48, 1
; MUBUF-NEXT:    v_writelane_b32 v1, s49, 2
; MUBUF-NEXT:    v_writelane_b32 v1, s50, 3
; MUBUF-NEXT:    v_writelane_b32 v1, s51, 4
; MUBUF-NEXT:    v_writelane_b32 v1, s52, 5
; MUBUF-NEXT:    v_writelane_b32 v1, s53, 6
; MUBUF-NEXT:    v_writelane_b32 v1, s54, 7
; MUBUF-NEXT:    v_writelane_b32 v1, s55, 8
; MUBUF-NEXT:    v_writelane_b32 v1, s64, 9
; MUBUF-NEXT:    v_writelane_b32 v1, s65, 10
; MUBUF-NEXT:    v_writelane_b32 v1, s66, 11
; MUBUF-NEXT:    v_writelane_b32 v1, s67, 12
; MUBUF-NEXT:    v_writelane_b32 v1, s68, 13
; MUBUF-NEXT:    v_writelane_b32 v1, s69, 14
; MUBUF-NEXT:    v_writelane_b32 v1, s70, 15
; MUBUF-NEXT:    v_writelane_b32 v1, s71, 16
; MUBUF-NEXT:    v_writelane_b32 v1, s80, 17
; MUBUF-NEXT:    v_writelane_b32 v1, s81, 18
; MUBUF-NEXT:    v_writelane_b32 v1, s82, 19
; MUBUF-NEXT:    v_writelane_b32 v1, s83, 20
; MUBUF-NEXT:    v_writelane_b32 v1, s84, 21
; MUBUF-NEXT:    v_writelane_b32 v1, s85, 22
; MUBUF-NEXT:    v_writelane_b32 v1, s86, 23
; MUBUF-NEXT:    v_writelane_b32 v1, s87, 24
; MUBUF-NEXT:    v_writelane_b32 v1, s96, 25
; MUBUF-NEXT:    v_writelane_b32 v1, s97, 26
; MUBUF-NEXT:    v_writelane_b32 v1, s98, 27
; MUBUF-NEXT:    v_writelane_b32 v1, s99, 28
; MUBUF-NEXT:    v_writelane_b32 v1, s100, 29
; MUBUF-NEXT:    v_mov_b32_e32 v0, 0
; MUBUF-NEXT:    buffer_store_dword v41, off, s[0:3], s33 ; 4-byte Folded Spill
; MUBUF-NEXT:    v_writelane_b32 v1, s101, 30
; MUBUF-NEXT:    buffer_store_dword v0, off, s[0:3], s33 offset:4
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; clobber v41
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    v_writelane_b32 v1, s102, 31
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    buffer_load_dword v41, off, s[0:3], s33 ; 4-byte Folded Reload
; MUBUF-NEXT:    s_addk_i32 s32, 0x400
; MUBUF-NEXT:    v_readlane_b32 s102, v1, 31
; MUBUF-NEXT:    v_readlane_b32 s101, v1, 30
; MUBUF-NEXT:    v_readlane_b32 s100, v1, 29
; MUBUF-NEXT:    v_readlane_b32 s99, v1, 28
; MUBUF-NEXT:    v_readlane_b32 s98, v1, 27
; MUBUF-NEXT:    v_readlane_b32 s97, v1, 26
; MUBUF-NEXT:    v_readlane_b32 s96, v1, 25
; MUBUF-NEXT:    v_readlane_b32 s87, v1, 24
; MUBUF-NEXT:    v_readlane_b32 s86, v1, 23
; MUBUF-NEXT:    v_readlane_b32 s85, v1, 22
; MUBUF-NEXT:    v_readlane_b32 s84, v1, 21
; MUBUF-NEXT:    v_readlane_b32 s83, v1, 20
; MUBUF-NEXT:    v_readlane_b32 s82, v1, 19
; MUBUF-NEXT:    v_readlane_b32 s81, v1, 18
; MUBUF-NEXT:    v_readlane_b32 s80, v1, 17
; MUBUF-NEXT:    v_readlane_b32 s71, v1, 16
; MUBUF-NEXT:    v_readlane_b32 s70, v1, 15
; MUBUF-NEXT:    v_readlane_b32 s69, v1, 14
; MUBUF-NEXT:    v_readlane_b32 s68, v1, 13
; MUBUF-NEXT:    v_readlane_b32 s67, v1, 12
; MUBUF-NEXT:    v_readlane_b32 s66, v1, 11
; MUBUF-NEXT:    v_readlane_b32 s65, v1, 10
; MUBUF-NEXT:    v_readlane_b32 s64, v1, 9
; MUBUF-NEXT:    v_readlane_b32 s55, v1, 8
; MUBUF-NEXT:    v_readlane_b32 s54, v1, 7
; MUBUF-NEXT:    v_readlane_b32 s53, v1, 6
; MUBUF-NEXT:    v_readlane_b32 s52, v1, 5
; MUBUF-NEXT:    v_readlane_b32 s51, v1, 4
; MUBUF-NEXT:    v_readlane_b32 s50, v1, 3
; MUBUF-NEXT:    v_readlane_b32 s49, v1, 2
; MUBUF-NEXT:    v_readlane_b32 s48, v1, 1
; MUBUF-NEXT:    v_readlane_b32 s39, v1, 0
; MUBUF-NEXT:    s_mov_b32 s32, s33
; MUBUF-NEXT:    s_xor_saveexec_b64 s[6:7], -1
; MUBUF-NEXT:    buffer_load_dword v1, off, s[0:3], s33 offset:8 ; 4-byte Folded Reload
; MUBUF-NEXT:    s_mov_b64 exec, s[6:7]
; MUBUF-NEXT:    s_mov_b32 s33, s4
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; FLATSCR-LABEL: no_new_vgpr_for_fp_csr:
; FLATSCR:       ; %bb.0:
; FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; FLATSCR-NEXT:    s_mov_b32 s0, s33
; FLATSCR-NEXT:    s_mov_b32 s33, s32
; FLATSCR-NEXT:    s_xor_saveexec_b64 s[2:3], -1
; FLATSCR-NEXT:    scratch_store_dword off, v1, s33 offset:8 ; 4-byte Folded Spill
; FLATSCR-NEXT:    s_mov_b64 exec, s[2:3]
; FLATSCR-NEXT:    v_writelane_b32 v1, s39, 0
; FLATSCR-NEXT:    v_writelane_b32 v1, s48, 1
; FLATSCR-NEXT:    v_writelane_b32 v1, s49, 2
; FLATSCR-NEXT:    v_writelane_b32 v1, s50, 3
; FLATSCR-NEXT:    v_writelane_b32 v1, s51, 4
; FLATSCR-NEXT:    v_writelane_b32 v1, s52, 5
; FLATSCR-NEXT:    v_writelane_b32 v1, s53, 6
; FLATSCR-NEXT:    v_writelane_b32 v1, s54, 7
; FLATSCR-NEXT:    v_writelane_b32 v1, s55, 8
; FLATSCR-NEXT:    v_writelane_b32 v1, s64, 9
; FLATSCR-NEXT:    v_writelane_b32 v1, s65, 10
; FLATSCR-NEXT:    v_writelane_b32 v1, s66, 11
; FLATSCR-NEXT:    v_writelane_b32 v1, s67, 12
; FLATSCR-NEXT:    v_writelane_b32 v1, s68, 13
; FLATSCR-NEXT:    v_writelane_b32 v1, s69, 14
; FLATSCR-NEXT:    v_writelane_b32 v1, s70, 15
; FLATSCR-NEXT:    v_writelane_b32 v1, s71, 16
; FLATSCR-NEXT:    v_writelane_b32 v1, s80, 17
; FLATSCR-NEXT:    v_writelane_b32 v1, s81, 18
; FLATSCR-NEXT:    v_writelane_b32 v1, s82, 19
; FLATSCR-NEXT:    v_writelane_b32 v1, s83, 20
; FLATSCR-NEXT:    v_writelane_b32 v1, s84, 21
; FLATSCR-NEXT:    v_writelane_b32 v1, s85, 22
; FLATSCR-NEXT:    v_writelane_b32 v1, s86, 23
; FLATSCR-NEXT:    v_writelane_b32 v1, s87, 24
; FLATSCR-NEXT:    v_writelane_b32 v1, s96, 25
; FLATSCR-NEXT:    v_writelane_b32 v1, s97, 26
; FLATSCR-NEXT:    v_writelane_b32 v1, s98, 27
; FLATSCR-NEXT:    v_writelane_b32 v1, s99, 28
; FLATSCR-NEXT:    v_writelane_b32 v1, s100, 29
; FLATSCR-NEXT:    v_mov_b32_e32 v0, 0
; FLATSCR-NEXT:    scratch_store_dword off, v41, s33 ; 4-byte Folded Spill
; FLATSCR-NEXT:    v_writelane_b32 v1, s101, 30
; FLATSCR-NEXT:    scratch_store_dword off, v0, s33 offset:4
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; clobber v41
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    v_writelane_b32 v1, s102, 31
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    scratch_load_dword v41, off, s33 ; 4-byte Folded Reload
; FLATSCR-NEXT:    s_add_i32 s32, s32, 16
; FLATSCR-NEXT:    v_readlane_b32 s102, v1, 31
; FLATSCR-NEXT:    v_readlane_b32 s101, v1, 30
; FLATSCR-NEXT:    v_readlane_b32 s100, v1, 29
; FLATSCR-NEXT:    v_readlane_b32 s99, v1, 28
; FLATSCR-NEXT:    v_readlane_b32 s98, v1, 27
; FLATSCR-NEXT:    v_readlane_b32 s97, v1, 26
; FLATSCR-NEXT:    v_readlane_b32 s96, v1, 25
; FLATSCR-NEXT:    v_readlane_b32 s87, v1, 24
; FLATSCR-NEXT:    v_readlane_b32 s86, v1, 23
; FLATSCR-NEXT:    v_readlane_b32 s85, v1, 22
; FLATSCR-NEXT:    v_readlane_b32 s84, v1, 21
; FLATSCR-NEXT:    v_readlane_b32 s83, v1, 20
; FLATSCR-NEXT:    v_readlane_b32 s82, v1, 19
; FLATSCR-NEXT:    v_readlane_b32 s81, v1, 18
; FLATSCR-NEXT:    v_readlane_b32 s80, v1, 17
; FLATSCR-NEXT:    v_readlane_b32 s71, v1, 16
; FLATSCR-NEXT:    v_readlane_b32 s70, v1, 15
; FLATSCR-NEXT:    v_readlane_b32 s69, v1, 14
; FLATSCR-NEXT:    v_readlane_b32 s68, v1, 13
; FLATSCR-NEXT:    v_readlane_b32 s67, v1, 12
; FLATSCR-NEXT:    v_readlane_b32 s66, v1, 11
; FLATSCR-NEXT:    v_readlane_b32 s65, v1, 10
; FLATSCR-NEXT:    v_readlane_b32 s64, v1, 9
; FLATSCR-NEXT:    v_readlane_b32 s55, v1, 8
; FLATSCR-NEXT:    v_readlane_b32 s54, v1, 7
; FLATSCR-NEXT:    v_readlane_b32 s53, v1, 6
; FLATSCR-NEXT:    v_readlane_b32 s52, v1, 5
; FLATSCR-NEXT:    v_readlane_b32 s51, v1, 4
; FLATSCR-NEXT:    v_readlane_b32 s50, v1, 3
; FLATSCR-NEXT:    v_readlane_b32 s49, v1, 2
; FLATSCR-NEXT:    v_readlane_b32 s48, v1, 1
; FLATSCR-NEXT:    v_readlane_b32 s39, v1, 0
; FLATSCR-NEXT:    s_mov_b32 s32, s33
; FLATSCR-NEXT:    s_xor_saveexec_b64 s[2:3], -1
; FLATSCR-NEXT:    scratch_load_dword v1, off, s33 offset:8 ; 4-byte Folded Reload
; FLATSCR-NEXT:    s_mov_b64 exec, s[2:3]
; FLATSCR-NEXT:    s_mov_b32 s33, s0
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    s_setpc_b64 s[30:31]
  %alloca = alloca i32, addrspace(5)
  store volatile i32 0, ptr addrspace(5) %alloca
  call void asm sideeffect "; clobber v41", "~{v41}"()
  call void asm sideeffect "",
    "~{s39},~{s40},~{s41},~{s42},~{s43},~{s44},~{s45},~{s46},~{s47},~{s48},~{s49}
    ,~{s50},~{s51},~{s52},~{s53},~{s54},~{s55},~{s56},~{s57},~{s58},~{s59}
    ,~{s60},~{s61},~{s62},~{s63},~{s64},~{s65},~{s66},~{s67},~{s68},~{s69}
    ,~{s70},~{s71},~{s72},~{s73},~{s74},~{s75},~{s76},~{s77},~{s78},~{s79}
    ,~{s80},~{s81},~{s82},~{s83},~{s84},~{s85},~{s86},~{s87},~{s88},~{s89}
    ,~{s90},~{s91},~{s92},~{s93},~{s94},~{s95},~{s96},~{s97},~{s98},~{s99}
    ,~{s100},~{s101},~{s102}"() #1

  ret void
}

define void @realign_stack_no_fp_elim() #1 {
; MUBUF-LABEL: realign_stack_no_fp_elim:
; MUBUF:       ; %bb.0:
; MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; MUBUF-NEXT:    s_mov_b32 s4, s33
; MUBUF-NEXT:    s_add_i32 s33, s32, 0x7ffc0
; MUBUF-NEXT:    s_and_b32 s33, s33, 0xfff80000
; MUBUF-NEXT:    s_mov_b32 s5, s34
; MUBUF-NEXT:    s_mov_b32 s34, s32
; MUBUF-NEXT:    s_add_i32 s32, s32, 0x180000
; MUBUF-NEXT:    v_mov_b32_e32 v0, 0
; MUBUF-NEXT:    v_mov_b32_e32 v1, 0x2000
; MUBUF-NEXT:    buffer_store_dword v0, v1, s[0:3], s33 offen
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    s_mov_b32 s32, s34
; MUBUF-NEXT:    s_mov_b32 s34, s5
; MUBUF-NEXT:    s_mov_b32 s33, s4
; MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; FLATSCR-LABEL: realign_stack_no_fp_elim:
; FLATSCR:       ; %bb.0:
; FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; FLATSCR-NEXT:    s_mov_b32 s0, s33
; FLATSCR-NEXT:    s_add_i32 s33, s32, 0x1fff
; FLATSCR-NEXT:    s_and_b32 s33, s33, 0xffffe000
; FLATSCR-NEXT:    s_mov_b32 s1, s34
; FLATSCR-NEXT:    s_mov_b32 s34, s32
; FLATSCR-NEXT:    s_addk_i32 s32, 0x6000
; FLATSCR-NEXT:    v_mov_b32_e32 v0, 0
; FLATSCR-NEXT:    s_add_i32 s2, s33, 0x2000
; FLATSCR-NEXT:    scratch_store_dword off, v0, s2
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    s_mov_b32 s32, s34
; FLATSCR-NEXT:    s_mov_b32 s34, s1
; FLATSCR-NEXT:    s_mov_b32 s33, s0
; FLATSCR-NEXT:    s_setpc_b64 s[30:31]
  %alloca = alloca i32, align 8192, addrspace(5)
  store volatile i32 0, ptr addrspace(5) %alloca
  ret void
}

define void @no_unused_non_csr_sgpr_for_fp() #1 {
; MUBUF-LABEL: no_unused_non_csr_sgpr_for_fp:
; MUBUF:       ; %bb.0:
; MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; MUBUF-NEXT:    s_mov_b32 s40, s33
; MUBUF-NEXT:    s_mov_b32 s33, s32
; MUBUF-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], s33 offset:4 ; 4-byte Folded Spill
; MUBUF-NEXT:    s_mov_b64 exec, s[4:5]
; MUBUF-NEXT:    v_writelane_b32 v1, s30, 0
; MUBUF-NEXT:    v_mov_b32_e32 v0, 0
; MUBUF-NEXT:    s_addk_i32 s32, 0x300
; MUBUF-NEXT:    v_writelane_b32 v1, s31, 1
; MUBUF-NEXT:    buffer_store_dword v0, off, s[0:3], s33
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    v_readlane_b32 s31, v1, 1
; MUBUF-NEXT:    v_readlane_b32 s30, v1, 0
; MUBUF-NEXT:    s_mov_b32 s32, s33
; MUBUF-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; MUBUF-NEXT:    buffer_load_dword v1, off, s[0:3], s33 offset:4 ; 4-byte Folded Reload
; MUBUF-NEXT:    s_mov_b64 exec, s[4:5]
; MUBUF-NEXT:    s_mov_b32 s33, s40
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; FLATSCR-LABEL: no_unused_non_csr_sgpr_for_fp:
; FLATSCR:       ; %bb.0:
; FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; FLATSCR-NEXT:    s_mov_b32 s40, s33
; FLATSCR-NEXT:    s_mov_b32 s33, s32
; FLATSCR-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; FLATSCR-NEXT:    scratch_store_dword off, v1, s33 offset:4 ; 4-byte Folded Spill
; FLATSCR-NEXT:    s_mov_b64 exec, s[0:1]
; FLATSCR-NEXT:    v_writelane_b32 v1, s30, 0
; FLATSCR-NEXT:    v_mov_b32_e32 v0, 0
; FLATSCR-NEXT:    s_add_i32 s32, s32, 12
; FLATSCR-NEXT:    v_writelane_b32 v1, s31, 1
; FLATSCR-NEXT:    scratch_store_dword off, v0, s33
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    v_readlane_b32 s31, v1, 1
; FLATSCR-NEXT:    v_readlane_b32 s30, v1, 0
; FLATSCR-NEXT:    s_mov_b32 s32, s33
; FLATSCR-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; FLATSCR-NEXT:    scratch_load_dword v1, off, s33 offset:4 ; 4-byte Folded Reload
; FLATSCR-NEXT:    s_mov_b64 exec, s[0:1]
; FLATSCR-NEXT:    s_mov_b32 s33, s40
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    s_setpc_b64 s[30:31]
  %alloca = alloca i32, addrspace(5)
  store volatile i32 0, ptr addrspace(5) %alloca

  ; Use all clobberable registers, so FP has to spill to a VGPR.
  call void asm sideeffect "",
    "~{s0},~{s1},~{s2},~{s3},~{s4},~{s5},~{s6},~{s7},~{s8},~{s9}
    ,~{s10},~{s11},~{s12},~{s13},~{s14},~{s15},~{s16},~{s17},~{s18},~{s19}
    ,~{s20},~{s21},~{s22},~{s23},~{s24},~{s25},~{s26},~{s27},~{s28},~{s29}
    ,~{s30},~{s31}"() #0

  ret void
}

; Need a new CSR VGPR to satisfy the FP spill.
define void @no_unused_non_csr_sgpr_for_fp_no_scratch_vgpr() #1 {
; MUBUF-LABEL: no_unused_non_csr_sgpr_for_fp_no_scratch_vgpr:
; MUBUF:       ; %bb.0:
; MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; MUBUF-NEXT:    s_mov_b32 s40, s33
; MUBUF-NEXT:    s_mov_b32 s33, s32
; MUBUF-NEXT:    s_or_saveexec_b64 s[4:5], -1
; MUBUF-NEXT:    buffer_store_dword v40, off, s[0:3], s33 offset:4 ; 4-byte Folded Spill
; MUBUF-NEXT:    s_mov_b64 exec, s[4:5]
; MUBUF-NEXT:    v_writelane_b32 v40, s30, 0
; MUBUF-NEXT:    v_mov_b32_e32 v0, 0
; MUBUF-NEXT:    s_addk_i32 s32, 0x300
; MUBUF-NEXT:    v_writelane_b32 v40, s31, 1
; MUBUF-NEXT:    buffer_store_dword v0, off, s[0:3], s33
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; clobber nonpreserved initial VGPRs
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    v_readlane_b32 s31, v40, 1
; MUBUF-NEXT:    v_readlane_b32 s30, v40, 0
; MUBUF-NEXT:    s_mov_b32 s32, s33
; MUBUF-NEXT:    s_or_saveexec_b64 s[4:5], -1
; MUBUF-NEXT:    buffer_load_dword v40, off, s[0:3], s33 offset:4 ; 4-byte Folded Reload
; MUBUF-NEXT:    s_mov_b64 exec, s[4:5]
; MUBUF-NEXT:    s_mov_b32 s33, s40
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; FLATSCR-LABEL: no_unused_non_csr_sgpr_for_fp_no_scratch_vgpr:
; FLATSCR:       ; %bb.0:
; FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; FLATSCR-NEXT:    s_mov_b32 s40, s33
; FLATSCR-NEXT:    s_mov_b32 s33, s32
; FLATSCR-NEXT:    s_or_saveexec_b64 s[0:1], -1
; FLATSCR-NEXT:    scratch_store_dword off, v40, s33 offset:4 ; 4-byte Folded Spill
; FLATSCR-NEXT:    s_mov_b64 exec, s[0:1]
; FLATSCR-NEXT:    v_writelane_b32 v40, s30, 0
; FLATSCR-NEXT:    v_mov_b32_e32 v0, 0
; FLATSCR-NEXT:    s_add_i32 s32, s32, 12
; FLATSCR-NEXT:    v_writelane_b32 v40, s31, 1
; FLATSCR-NEXT:    scratch_store_dword off, v0, s33
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; clobber nonpreserved initial VGPRs
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    v_readlane_b32 s31, v40, 1
; FLATSCR-NEXT:    v_readlane_b32 s30, v40, 0
; FLATSCR-NEXT:    s_mov_b32 s32, s33
; FLATSCR-NEXT:    s_or_saveexec_b64 s[0:1], -1
; FLATSCR-NEXT:    scratch_load_dword v40, off, s33 offset:4 ; 4-byte Folded Reload
; FLATSCR-NEXT:    s_mov_b64 exec, s[0:1]
; FLATSCR-NEXT:    s_mov_b32 s33, s40
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    s_setpc_b64 s[30:31]
  %alloca = alloca i32, addrspace(5)
  store volatile i32 0, ptr addrspace(5) %alloca

  ; Use all clobberable registers, so FP has to spill to a VGPR.
  call void asm sideeffect "",
    "~{s0},~{s1},~{s2},~{s3},~{s4},~{s5},~{s6},~{s7},~{s8},~{s9}
    ,~{s10},~{s11},~{s12},~{s13},~{s14},~{s15},~{s16},~{s17},~{s18},~{s19}
    ,~{s20},~{s21},~{s22},~{s23},~{s24},~{s25},~{s26},~{s27},~{s28},~{s29}
    ,~{s30},~{s31}"() #0

  call void asm sideeffect "; clobber nonpreserved initial VGPRs",
    "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{v8},~{v9}
    ,~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19}
    ,~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29}
    ,~{v30},~{v31},~{v32},~{v33},~{v34},~{v35},~{v36},~{v37},~{v38},~{v39}"() #1

  ret void
}

; The byval argument exceeds the MUBUF constant offset, so a scratch
; register is needed to access the CSR VGPR slot.
define void @scratch_reg_needed_mubuf_offset(ptr addrspace(5) byval([4096 x i8]) align 4 %arg) #1 {
; MUBUF-LABEL: scratch_reg_needed_mubuf_offset:
; MUBUF:       ; %bb.0:
; MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; MUBUF-NEXT:    s_mov_b32 s40, s33
; MUBUF-NEXT:    s_mov_b32 s33, s32
; MUBUF-NEXT:    s_or_saveexec_b64 s[4:5], -1
; MUBUF-NEXT:    s_add_i32 s6, s33, 0x40100
; MUBUF-NEXT:    buffer_store_dword v40, off, s[0:3], s6 ; 4-byte Folded Spill
; MUBUF-NEXT:    s_mov_b64 exec, s[4:5]
; MUBUF-NEXT:    v_writelane_b32 v40, s30, 0
; MUBUF-NEXT:    v_mov_b32_e32 v0, 0
; MUBUF-NEXT:    v_mov_b32_e32 v1, 0x1000
; MUBUF-NEXT:    s_add_i32 s32, s32, 0x40300
; MUBUF-NEXT:    v_writelane_b32 v40, s31, 1
; MUBUF-NEXT:    buffer_store_dword v0, v1, s[0:3], s33 offen
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; clobber nonpreserved SGPRs
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; clobber nonpreserved VGPRs
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    v_readlane_b32 s31, v40, 1
; MUBUF-NEXT:    v_readlane_b32 s30, v40, 0
; MUBUF-NEXT:    s_mov_b32 s32, s33
; MUBUF-NEXT:    s_or_saveexec_b64 s[4:5], -1
; MUBUF-NEXT:    s_add_i32 s6, s33, 0x40100
; MUBUF-NEXT:    buffer_load_dword v40, off, s[0:3], s6 ; 4-byte Folded Reload
; MUBUF-NEXT:    s_mov_b64 exec, s[4:5]
; MUBUF-NEXT:    s_mov_b32 s33, s40
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; FLATSCR-LABEL: scratch_reg_needed_mubuf_offset:
; FLATSCR:       ; %bb.0:
; FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; FLATSCR-NEXT:    s_mov_b32 s40, s33
; FLATSCR-NEXT:    s_mov_b32 s33, s32
; FLATSCR-NEXT:    s_or_saveexec_b64 s[0:1], -1
; FLATSCR-NEXT:    s_add_i32 s2, s33, 0x1004
; FLATSCR-NEXT:    scratch_store_dword off, v40, s2 ; 4-byte Folded Spill
; FLATSCR-NEXT:    s_mov_b64 exec, s[0:1]
; FLATSCR-NEXT:    s_addk_i32 s32, 0x100c
; FLATSCR-NEXT:    v_writelane_b32 v40, s30, 0
; FLATSCR-NEXT:    v_mov_b32_e32 v0, 0
; FLATSCR-NEXT:    s_add_i32 s0, s33, 0x1000
; FLATSCR-NEXT:    v_writelane_b32 v40, s31, 1
; FLATSCR-NEXT:    scratch_store_dword off, v0, s0
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; clobber nonpreserved SGPRs
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; clobber nonpreserved VGPRs
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    v_readlane_b32 s31, v40, 1
; FLATSCR-NEXT:    v_readlane_b32 s30, v40, 0
; FLATSCR-NEXT:    s_mov_b32 s32, s33
; FLATSCR-NEXT:    s_or_saveexec_b64 s[0:1], -1
; FLATSCR-NEXT:    s_add_i32 s2, s33, 0x1004
; FLATSCR-NEXT:    scratch_load_dword v40, off, s2 ; 4-byte Folded Reload
; FLATSCR-NEXT:    s_mov_b64 exec, s[0:1]
; FLATSCR-NEXT:    s_mov_b32 s33, s40
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    s_setpc_b64 s[30:31]
  %alloca = alloca i32, addrspace(5)
  store volatile i32 0, ptr addrspace(5) %alloca

  ; Use all clobberable registers, so FP has to spill to a VGPR.
  call void asm sideeffect "; clobber nonpreserved SGPRs",
    "~{s0},~{s1},~{s2},~{s3},~{s4},~{s5},~{s6},~{s7},~{s8},~{s9}
    ,~{s10},~{s11},~{s12},~{s13},~{s14},~{s15},~{s16},~{s17},~{s18},~{s19}
    ,~{s20},~{s21},~{s22},~{s23},~{s24},~{s25},~{s26},~{s27},~{s28},~{s29}
    ,~{s30},~{s31}"() #0

  ; Use all clobberable VGPRs, so a CSR spill is needed for the VGPR
  call void asm sideeffect "; clobber nonpreserved VGPRs",
    "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{v8},~{v9}
    ,~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19}
    ,~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29}
    ,~{v30},~{v31},~{v32},~{v33},~{v34},~{v35},~{v36},~{v37},~{v38},~{v39}"() #1

  ret void
}

define internal void @local_empty_func() #0 {
; GCN-LABEL: local_empty_func:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_setpc_b64 s[30:31]
  ret void
}

; An FP is needed, despite not needing any spills
; TODO: Ccould see callee does not use stack and omit FP.
define void @ipra_call_with_stack() #0 {
; MUBUF-LABEL: ipra_call_with_stack:
; MUBUF:       ; %bb.0:
; MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; MUBUF-NEXT:    s_mov_b32 s18, s33
; MUBUF-NEXT:    s_mov_b32 s33, s32
; MUBUF-NEXT:    s_xor_saveexec_b64 s[16:17], -1
; MUBUF-NEXT:    buffer_store_dword v1, off, s[0:3], s33 offset:4 ; 4-byte Folded Spill
; MUBUF-NEXT:    s_mov_b64 exec, s[16:17]
; MUBUF-NEXT:    s_addk_i32 s32, 0x400
; MUBUF-NEXT:    v_writelane_b32 v1, s30, 0
; MUBUF-NEXT:    v_mov_b32_e32 v0, 0
; MUBUF-NEXT:    s_getpc_b64 s[16:17]
; MUBUF-NEXT:    s_add_u32 s16, s16, local_empty_func@rel32@lo+4
; MUBUF-NEXT:    s_addc_u32 s17, s17, local_empty_func@rel32@hi+12
; MUBUF-NEXT:    v_writelane_b32 v1, s31, 1
; MUBUF-NEXT:    buffer_store_dword v0, off, s[0:3], s33
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    s_swappc_b64 s[30:31], s[16:17]
; MUBUF-NEXT:    v_readlane_b32 s31, v1, 1
; MUBUF-NEXT:    v_readlane_b32 s30, v1, 0
; MUBUF-NEXT:    s_mov_b32 s32, s33
; MUBUF-NEXT:    s_xor_saveexec_b64 s[4:5], -1
; MUBUF-NEXT:    buffer_load_dword v1, off, s[0:3], s33 offset:4 ; 4-byte Folded Reload
; MUBUF-NEXT:    s_mov_b64 exec, s[4:5]
; MUBUF-NEXT:    s_mov_b32 s33, s18
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; FLATSCR-LABEL: ipra_call_with_stack:
; FLATSCR:       ; %bb.0:
; FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; FLATSCR-NEXT:    s_mov_b32 s2, s33
; FLATSCR-NEXT:    s_mov_b32 s33, s32
; FLATSCR-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; FLATSCR-NEXT:    scratch_store_dword off, v1, s33 offset:4 ; 4-byte Folded Spill
; FLATSCR-NEXT:    s_mov_b64 exec, s[0:1]
; FLATSCR-NEXT:    s_add_i32 s32, s32, 16
; FLATSCR-NEXT:    v_writelane_b32 v1, s30, 0
; FLATSCR-NEXT:    v_mov_b32_e32 v0, 0
; FLATSCR-NEXT:    s_getpc_b64 s[0:1]
; FLATSCR-NEXT:    s_add_u32 s0, s0, local_empty_func@rel32@lo+4
; FLATSCR-NEXT:    s_addc_u32 s1, s1, local_empty_func@rel32@hi+12
; FLATSCR-NEXT:    v_writelane_b32 v1, s31, 1
; FLATSCR-NEXT:    scratch_store_dword off, v0, s33
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    s_swappc_b64 s[30:31], s[0:1]
; FLATSCR-NEXT:    v_readlane_b32 s31, v1, 1
; FLATSCR-NEXT:    v_readlane_b32 s30, v1, 0
; FLATSCR-NEXT:    s_mov_b32 s32, s33
; FLATSCR-NEXT:    s_xor_saveexec_b64 s[0:1], -1
; FLATSCR-NEXT:    scratch_load_dword v1, off, s33 offset:4 ; 4-byte Folded Reload
; FLATSCR-NEXT:    s_mov_b64 exec, s[0:1]
; FLATSCR-NEXT:    s_mov_b32 s33, s2
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    s_setpc_b64 s[30:31]
  %alloca = alloca i32, addrspace(5)
  store volatile i32 0, ptr addrspace(5) %alloca
  call void @local_empty_func()
  ret void
}

; With no free registers, we must spill the FP to memory.
define void @callee_need_to_spill_fp_to_memory() #3 {
; MUBUF-LABEL: callee_need_to_spill_fp_to_memory:
; MUBUF:       ; %bb.0:
; MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; MUBUF-NEXT:    s_mov_b32 s40, s33
; MUBUF-NEXT:    s_mov_b32 s33, s32
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; clobber nonpreserved SGPRs
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; clobber all VGPRs
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    s_mov_b32 s33, s40
; MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; FLATSCR-LABEL: callee_need_to_spill_fp_to_memory:
; FLATSCR:       ; %bb.0:
; FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; FLATSCR-NEXT:    s_mov_b32 s0, s33
; FLATSCR-NEXT:    s_mov_b32 s33, s32
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; clobber nonpreserved SGPRs
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; clobber all VGPRs
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    s_mov_b32 s33, s0
; FLATSCR-NEXT:    s_setpc_b64 s[30:31]
  call void asm sideeffect "; clobber nonpreserved SGPRs",
    "~{s4},~{s5},~{s6},~{s7},~{s8},~{s9}
    ,~{s10},~{s11},~{s12},~{s13},~{s14},~{s15},~{s16},~{s17},~{s18},~{s19}
    ,~{s20},~{s21},~{s22},~{s23},~{s24},~{s25},~{s26},~{s27},~{s28},~{s29}
    ,~{vcc}"()

  call void asm sideeffect "; clobber all VGPRs",
    "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{v8},~{v9}
    ,~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19}
    ,~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29}
    ,~{v30},~{v31},~{v32},~{v33},~{v34},~{v35},~{v36},~{v37},~{v38},~{v39}"()
  ret void
}

; If we have a reserved VGPR that can be used for SGPR spills, we may still
; need to spill the FP to memory if there are no free lanes in the reserved
; VGPR.
define void @callee_need_to_spill_fp_to_memory_full_reserved_vgpr() #3 {
; MUBUF-LABEL: callee_need_to_spill_fp_to_memory_full_reserved_vgpr:
; MUBUF:       ; %bb.0:
; MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; MUBUF-NEXT:    s_mov_b32 s4, s33
; MUBUF-NEXT:    s_mov_b32 s33, s32
; MUBUF-NEXT:    s_xor_saveexec_b64 s[6:7], -1
; MUBUF-NEXT:    buffer_store_dword v39, off, s[0:3], s33 ; 4-byte Folded Spill
; MUBUF-NEXT:    s_mov_b64 exec, s[6:7]
; MUBUF-NEXT:    v_writelane_b32 v39, s4, 32
; MUBUF-NEXT:    v_writelane_b32 v39, s39, 0
; MUBUF-NEXT:    v_writelane_b32 v39, s48, 1
; MUBUF-NEXT:    v_writelane_b32 v39, s49, 2
; MUBUF-NEXT:    v_writelane_b32 v39, s50, 3
; MUBUF-NEXT:    v_writelane_b32 v39, s51, 4
; MUBUF-NEXT:    v_writelane_b32 v39, s52, 5
; MUBUF-NEXT:    v_writelane_b32 v39, s53, 6
; MUBUF-NEXT:    v_writelane_b32 v39, s54, 7
; MUBUF-NEXT:    v_writelane_b32 v39, s55, 8
; MUBUF-NEXT:    v_writelane_b32 v39, s64, 9
; MUBUF-NEXT:    v_writelane_b32 v39, s65, 10
; MUBUF-NEXT:    v_writelane_b32 v39, s66, 11
; MUBUF-NEXT:    v_writelane_b32 v39, s67, 12
; MUBUF-NEXT:    v_writelane_b32 v39, s68, 13
; MUBUF-NEXT:    v_writelane_b32 v39, s69, 14
; MUBUF-NEXT:    v_writelane_b32 v39, s70, 15
; MUBUF-NEXT:    v_writelane_b32 v39, s71, 16
; MUBUF-NEXT:    v_writelane_b32 v39, s80, 17
; MUBUF-NEXT:    v_writelane_b32 v39, s81, 18
; MUBUF-NEXT:    v_writelane_b32 v39, s82, 19
; MUBUF-NEXT:    v_writelane_b32 v39, s83, 20
; MUBUF-NEXT:    v_writelane_b32 v39, s84, 21
; MUBUF-NEXT:    v_writelane_b32 v39, s85, 22
; MUBUF-NEXT:    v_writelane_b32 v39, s86, 23
; MUBUF-NEXT:    v_writelane_b32 v39, s87, 24
; MUBUF-NEXT:    v_writelane_b32 v39, s96, 25
; MUBUF-NEXT:    v_writelane_b32 v39, s97, 26
; MUBUF-NEXT:    v_writelane_b32 v39, s98, 27
; MUBUF-NEXT:    v_writelane_b32 v39, s99, 28
; MUBUF-NEXT:    v_writelane_b32 v39, s100, 29
; MUBUF-NEXT:    v_writelane_b32 v39, s101, 30
; MUBUF-NEXT:    s_addk_i32 s32, 0x200
; MUBUF-NEXT:    v_writelane_b32 v39, s102, 31
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; clobber nonpreserved SGPRs and 64 CSRs
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; clobber all VGPRs except CSR v40
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    v_readlane_b32 s102, v39, 31
; MUBUF-NEXT:    v_readlane_b32 s101, v39, 30
; MUBUF-NEXT:    v_readlane_b32 s100, v39, 29
; MUBUF-NEXT:    v_readlane_b32 s99, v39, 28
; MUBUF-NEXT:    v_readlane_b32 s98, v39, 27
; MUBUF-NEXT:    v_readlane_b32 s97, v39, 26
; MUBUF-NEXT:    v_readlane_b32 s96, v39, 25
; MUBUF-NEXT:    v_readlane_b32 s87, v39, 24
; MUBUF-NEXT:    v_readlane_b32 s86, v39, 23
; MUBUF-NEXT:    v_readlane_b32 s85, v39, 22
; MUBUF-NEXT:    v_readlane_b32 s84, v39, 21
; MUBUF-NEXT:    v_readlane_b32 s83, v39, 20
; MUBUF-NEXT:    v_readlane_b32 s82, v39, 19
; MUBUF-NEXT:    v_readlane_b32 s81, v39, 18
; MUBUF-NEXT:    v_readlane_b32 s80, v39, 17
; MUBUF-NEXT:    v_readlane_b32 s71, v39, 16
; MUBUF-NEXT:    v_readlane_b32 s70, v39, 15
; MUBUF-NEXT:    v_readlane_b32 s69, v39, 14
; MUBUF-NEXT:    v_readlane_b32 s68, v39, 13
; MUBUF-NEXT:    v_readlane_b32 s67, v39, 12
; MUBUF-NEXT:    v_readlane_b32 s66, v39, 11
; MUBUF-NEXT:    v_readlane_b32 s65, v39, 10
; MUBUF-NEXT:    v_readlane_b32 s64, v39, 9
; MUBUF-NEXT:    v_readlane_b32 s55, v39, 8
; MUBUF-NEXT:    v_readlane_b32 s54, v39, 7
; MUBUF-NEXT:    v_readlane_b32 s53, v39, 6
; MUBUF-NEXT:    v_readlane_b32 s52, v39, 5
; MUBUF-NEXT:    v_readlane_b32 s51, v39, 4
; MUBUF-NEXT:    v_readlane_b32 s50, v39, 3
; MUBUF-NEXT:    v_readlane_b32 s49, v39, 2
; MUBUF-NEXT:    v_readlane_b32 s48, v39, 1
; MUBUF-NEXT:    v_readlane_b32 s39, v39, 0
; MUBUF-NEXT:    s_mov_b32 s32, s33
; MUBUF-NEXT:    v_readlane_b32 s4, v39, 32
; MUBUF-NEXT:    s_xor_saveexec_b64 s[6:7], -1
; MUBUF-NEXT:    buffer_load_dword v39, off, s[0:3], s33 ; 4-byte Folded Reload
; MUBUF-NEXT:    s_mov_b64 exec, s[6:7]
; MUBUF-NEXT:    s_mov_b32 s33, s4
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; FLATSCR-LABEL: callee_need_to_spill_fp_to_memory_full_reserved_vgpr:
; FLATSCR:       ; %bb.0:
; FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; FLATSCR-NEXT:    s_mov_b32 s0, s33
; FLATSCR-NEXT:    s_mov_b32 s33, s32
; FLATSCR-NEXT:    s_xor_saveexec_b64 s[2:3], -1
; FLATSCR-NEXT:    scratch_store_dword off, v39, s33 ; 4-byte Folded Spill
; FLATSCR-NEXT:    s_mov_b64 exec, s[2:3]
; FLATSCR-NEXT:    v_writelane_b32 v39, s39, 0
; FLATSCR-NEXT:    v_writelane_b32 v39, s48, 1
; FLATSCR-NEXT:    v_writelane_b32 v39, s49, 2
; FLATSCR-NEXT:    v_writelane_b32 v39, s50, 3
; FLATSCR-NEXT:    v_writelane_b32 v39, s51, 4
; FLATSCR-NEXT:    v_writelane_b32 v39, s52, 5
; FLATSCR-NEXT:    v_writelane_b32 v39, s53, 6
; FLATSCR-NEXT:    v_writelane_b32 v39, s54, 7
; FLATSCR-NEXT:    v_writelane_b32 v39, s55, 8
; FLATSCR-NEXT:    v_writelane_b32 v39, s64, 9
; FLATSCR-NEXT:    v_writelane_b32 v39, s65, 10
; FLATSCR-NEXT:    v_writelane_b32 v39, s66, 11
; FLATSCR-NEXT:    v_writelane_b32 v39, s67, 12
; FLATSCR-NEXT:    v_writelane_b32 v39, s68, 13
; FLATSCR-NEXT:    v_writelane_b32 v39, s69, 14
; FLATSCR-NEXT:    v_writelane_b32 v39, s70, 15
; FLATSCR-NEXT:    v_writelane_b32 v39, s71, 16
; FLATSCR-NEXT:    v_writelane_b32 v39, s80, 17
; FLATSCR-NEXT:    v_writelane_b32 v39, s81, 18
; FLATSCR-NEXT:    v_writelane_b32 v39, s82, 19
; FLATSCR-NEXT:    v_writelane_b32 v39, s83, 20
; FLATSCR-NEXT:    v_writelane_b32 v39, s84, 21
; FLATSCR-NEXT:    v_writelane_b32 v39, s85, 22
; FLATSCR-NEXT:    v_writelane_b32 v39, s86, 23
; FLATSCR-NEXT:    v_writelane_b32 v39, s87, 24
; FLATSCR-NEXT:    v_writelane_b32 v39, s96, 25
; FLATSCR-NEXT:    v_writelane_b32 v39, s97, 26
; FLATSCR-NEXT:    v_writelane_b32 v39, s98, 27
; FLATSCR-NEXT:    v_writelane_b32 v39, s99, 28
; FLATSCR-NEXT:    v_writelane_b32 v39, s100, 29
; FLATSCR-NEXT:    v_writelane_b32 v39, s101, 30
; FLATSCR-NEXT:    s_add_i32 s32, s32, 8
; FLATSCR-NEXT:    v_writelane_b32 v39, s102, 31
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; clobber nonpreserved SGPRs and 64 CSRs
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; clobber all VGPRs except CSR v40
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    v_readlane_b32 s102, v39, 31
; FLATSCR-NEXT:    v_readlane_b32 s101, v39, 30
; FLATSCR-NEXT:    v_readlane_b32 s100, v39, 29
; FLATSCR-NEXT:    v_readlane_b32 s99, v39, 28
; FLATSCR-NEXT:    v_readlane_b32 s98, v39, 27
; FLATSCR-NEXT:    v_readlane_b32 s97, v39, 26
; FLATSCR-NEXT:    v_readlane_b32 s96, v39, 25
; FLATSCR-NEXT:    v_readlane_b32 s87, v39, 24
; FLATSCR-NEXT:    v_readlane_b32 s86, v39, 23
; FLATSCR-NEXT:    v_readlane_b32 s85, v39, 22
; FLATSCR-NEXT:    v_readlane_b32 s84, v39, 21
; FLATSCR-NEXT:    v_readlane_b32 s83, v39, 20
; FLATSCR-NEXT:    v_readlane_b32 s82, v39, 19
; FLATSCR-NEXT:    v_readlane_b32 s81, v39, 18
; FLATSCR-NEXT:    v_readlane_b32 s80, v39, 17
; FLATSCR-NEXT:    v_readlane_b32 s71, v39, 16
; FLATSCR-NEXT:    v_readlane_b32 s70, v39, 15
; FLATSCR-NEXT:    v_readlane_b32 s69, v39, 14
; FLATSCR-NEXT:    v_readlane_b32 s68, v39, 13
; FLATSCR-NEXT:    v_readlane_b32 s67, v39, 12
; FLATSCR-NEXT:    v_readlane_b32 s66, v39, 11
; FLATSCR-NEXT:    v_readlane_b32 s65, v39, 10
; FLATSCR-NEXT:    v_readlane_b32 s64, v39, 9
; FLATSCR-NEXT:    v_readlane_b32 s55, v39, 8
; FLATSCR-NEXT:    v_readlane_b32 s54, v39, 7
; FLATSCR-NEXT:    v_readlane_b32 s53, v39, 6
; FLATSCR-NEXT:    v_readlane_b32 s52, v39, 5
; FLATSCR-NEXT:    v_readlane_b32 s51, v39, 4
; FLATSCR-NEXT:    v_readlane_b32 s50, v39, 3
; FLATSCR-NEXT:    v_readlane_b32 s49, v39, 2
; FLATSCR-NEXT:    v_readlane_b32 s48, v39, 1
; FLATSCR-NEXT:    v_readlane_b32 s39, v39, 0
; FLATSCR-NEXT:    s_mov_b32 s32, s33
; FLATSCR-NEXT:    s_xor_saveexec_b64 s[2:3], -1
; FLATSCR-NEXT:    scratch_load_dword v39, off, s33 ; 4-byte Folded Reload
; FLATSCR-NEXT:    s_mov_b64 exec, s[2:3]
; FLATSCR-NEXT:    s_mov_b32 s33, s0
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    s_setpc_b64 s[30:31]
  call void asm sideeffect "; clobber nonpreserved SGPRs and 64 CSRs",
    "~{s4},~{s5},~{s6},~{s7},~{s8},~{s9}
    ,~{s10},~{s11},~{s12},~{s13},~{s14},~{s15},~{s16},~{s17},~{s18},~{s19}
    ,~{s20},~{s21},~{s22},~{s23},~{s24},~{s25},~{s26},~{s27},~{s28},~{s29}
    ,~{s40},~{s41},~{s42},~{s43},~{s44},~{s45},~{s46},~{s47},~{s48},~{s49}
    ,~{s50},~{s51},~{s52},~{s53},~{s54},~{s55},~{s56},~{s57},~{s58},~{s59}
    ,~{s60},~{s61},~{s62},~{s63},~{s64},~{s65},~{s66},~{s67},~{s68},~{s69}
    ,~{s70},~{s71},~{s72},~{s73},~{s74},~{s75},~{s76},~{s77},~{s78},~{s79}
    ,~{s80},~{s81},~{s82},~{s83},~{s84},~{s85},~{s86},~{s87},~{s88},~{s89}
    ,~{s90},~{s91},~{s92},~{s93},~{s94},~{s95},~{s96},~{s97},~{s98},~{s99}
    ,~{s100},~{s101},~{s102},~{s39},~{vcc}"()

  call void asm sideeffect "; clobber all VGPRs except CSR v40",
    "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{v8},~{v9}
    ,~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19}
    ,~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29}
    ,~{v30},~{v31},~{v32},~{v33},~{v34},~{v35},~{v36},~{v37},~{v38}"()
  ret void
}

; When flat-scratch is enabled, we save the FP to s0. At the same time,
; the exec register is saved to s0 when saving CSR in the function prolog.
; Make sure that the FP save happens after restoring exec from the same
; register.
define void @callee_need_to_spill_fp_to_reg() #1 {
; MUBUF-LABEL: callee_need_to_spill_fp_to_reg:
; MUBUF:       ; %bb.0:
; MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; MUBUF-NEXT:    s_mov_b32 s4, s33
; MUBUF-NEXT:    s_mov_b32 s33, s32
; MUBUF-NEXT:    s_or_saveexec_b64 s[6:7], -1
; MUBUF-NEXT:    buffer_store_dword v40, off, s[0:3], s33 ; 4-byte Folded Spill
; MUBUF-NEXT:    s_mov_b64 exec, s[6:7]
; MUBUF-NEXT:    v_writelane_b32 v40, s4, 32
; MUBUF-NEXT:    v_writelane_b32 v40, s39, 0
; MUBUF-NEXT:    v_writelane_b32 v40, s48, 1
; MUBUF-NEXT:    v_writelane_b32 v40, s49, 2
; MUBUF-NEXT:    v_writelane_b32 v40, s50, 3
; MUBUF-NEXT:    v_writelane_b32 v40, s51, 4
; MUBUF-NEXT:    v_writelane_b32 v40, s52, 5
; MUBUF-NEXT:    v_writelane_b32 v40, s53, 6
; MUBUF-NEXT:    v_writelane_b32 v40, s54, 7
; MUBUF-NEXT:    v_writelane_b32 v40, s55, 8
; MUBUF-NEXT:    v_writelane_b32 v40, s64, 9
; MUBUF-NEXT:    v_writelane_b32 v40, s65, 10
; MUBUF-NEXT:    v_writelane_b32 v40, s66, 11
; MUBUF-NEXT:    v_writelane_b32 v40, s67, 12
; MUBUF-NEXT:    v_writelane_b32 v40, s68, 13
; MUBUF-NEXT:    v_writelane_b32 v40, s69, 14
; MUBUF-NEXT:    v_writelane_b32 v40, s70, 15
; MUBUF-NEXT:    v_writelane_b32 v40, s71, 16
; MUBUF-NEXT:    v_writelane_b32 v40, s80, 17
; MUBUF-NEXT:    v_writelane_b32 v40, s81, 18
; MUBUF-NEXT:    v_writelane_b32 v40, s82, 19
; MUBUF-NEXT:    v_writelane_b32 v40, s83, 20
; MUBUF-NEXT:    v_writelane_b32 v40, s84, 21
; MUBUF-NEXT:    v_writelane_b32 v40, s85, 22
; MUBUF-NEXT:    v_writelane_b32 v40, s86, 23
; MUBUF-NEXT:    v_writelane_b32 v40, s87, 24
; MUBUF-NEXT:    v_writelane_b32 v40, s96, 25
; MUBUF-NEXT:    v_writelane_b32 v40, s97, 26
; MUBUF-NEXT:    v_writelane_b32 v40, s98, 27
; MUBUF-NEXT:    v_writelane_b32 v40, s99, 28
; MUBUF-NEXT:    v_writelane_b32 v40, s100, 29
; MUBUF-NEXT:    v_writelane_b32 v40, s101, 30
; MUBUF-NEXT:    s_addk_i32 s32, 0x200
; MUBUF-NEXT:    v_writelane_b32 v40, s102, 31
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; clobber nonpreserved SGPRs and 64 CSRs
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; clobber all VGPRs except CSR v40
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    v_readlane_b32 s102, v40, 31
; MUBUF-NEXT:    v_readlane_b32 s101, v40, 30
; MUBUF-NEXT:    v_readlane_b32 s100, v40, 29
; MUBUF-NEXT:    v_readlane_b32 s99, v40, 28
; MUBUF-NEXT:    v_readlane_b32 s98, v40, 27
; MUBUF-NEXT:    v_readlane_b32 s97, v40, 26
; MUBUF-NEXT:    v_readlane_b32 s96, v40, 25
; MUBUF-NEXT:    v_readlane_b32 s87, v40, 24
; MUBUF-NEXT:    v_readlane_b32 s86, v40, 23
; MUBUF-NEXT:    v_readlane_b32 s85, v40, 22
; MUBUF-NEXT:    v_readlane_b32 s84, v40, 21
; MUBUF-NEXT:    v_readlane_b32 s83, v40, 20
; MUBUF-NEXT:    v_readlane_b32 s82, v40, 19
; MUBUF-NEXT:    v_readlane_b32 s81, v40, 18
; MUBUF-NEXT:    v_readlane_b32 s80, v40, 17
; MUBUF-NEXT:    v_readlane_b32 s71, v40, 16
; MUBUF-NEXT:    v_readlane_b32 s70, v40, 15
; MUBUF-NEXT:    v_readlane_b32 s69, v40, 14
; MUBUF-NEXT:    v_readlane_b32 s68, v40, 13
; MUBUF-NEXT:    v_readlane_b32 s67, v40, 12
; MUBUF-NEXT:    v_readlane_b32 s66, v40, 11
; MUBUF-NEXT:    v_readlane_b32 s65, v40, 10
; MUBUF-NEXT:    v_readlane_b32 s64, v40, 9
; MUBUF-NEXT:    v_readlane_b32 s55, v40, 8
; MUBUF-NEXT:    v_readlane_b32 s54, v40, 7
; MUBUF-NEXT:    v_readlane_b32 s53, v40, 6
; MUBUF-NEXT:    v_readlane_b32 s52, v40, 5
; MUBUF-NEXT:    v_readlane_b32 s51, v40, 4
; MUBUF-NEXT:    v_readlane_b32 s50, v40, 3
; MUBUF-NEXT:    v_readlane_b32 s49, v40, 2
; MUBUF-NEXT:    v_readlane_b32 s48, v40, 1
; MUBUF-NEXT:    v_readlane_b32 s39, v40, 0
; MUBUF-NEXT:    s_mov_b32 s32, s33
; MUBUF-NEXT:    v_readlane_b32 s4, v40, 32
; MUBUF-NEXT:    s_or_saveexec_b64 s[6:7], -1
; MUBUF-NEXT:    buffer_load_dword v40, off, s[0:3], s33 ; 4-byte Folded Reload
; MUBUF-NEXT:    s_mov_b64 exec, s[6:7]
; MUBUF-NEXT:    s_mov_b32 s33, s4
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; FLATSCR-LABEL: callee_need_to_spill_fp_to_reg:
; FLATSCR:       ; %bb.0:
; FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; FLATSCR-NEXT:    s_mov_b32 s0, s33
; FLATSCR-NEXT:    s_mov_b32 s33, s32
; FLATSCR-NEXT:    s_or_saveexec_b64 s[2:3], -1
; FLATSCR-NEXT:    scratch_store_dword off, v40, s33 ; 4-byte Folded Spill
; FLATSCR-NEXT:    s_mov_b64 exec, s[2:3]
; FLATSCR-NEXT:    v_writelane_b32 v40, s39, 0
; FLATSCR-NEXT:    v_writelane_b32 v40, s48, 1
; FLATSCR-NEXT:    v_writelane_b32 v40, s49, 2
; FLATSCR-NEXT:    v_writelane_b32 v40, s50, 3
; FLATSCR-NEXT:    v_writelane_b32 v40, s51, 4
; FLATSCR-NEXT:    v_writelane_b32 v40, s52, 5
; FLATSCR-NEXT:    v_writelane_b32 v40, s53, 6
; FLATSCR-NEXT:    v_writelane_b32 v40, s54, 7
; FLATSCR-NEXT:    v_writelane_b32 v40, s55, 8
; FLATSCR-NEXT:    v_writelane_b32 v40, s64, 9
; FLATSCR-NEXT:    v_writelane_b32 v40, s65, 10
; FLATSCR-NEXT:    v_writelane_b32 v40, s66, 11
; FLATSCR-NEXT:    v_writelane_b32 v40, s67, 12
; FLATSCR-NEXT:    v_writelane_b32 v40, s68, 13
; FLATSCR-NEXT:    v_writelane_b32 v40, s69, 14
; FLATSCR-NEXT:    v_writelane_b32 v40, s70, 15
; FLATSCR-NEXT:    v_writelane_b32 v40, s71, 16
; FLATSCR-NEXT:    v_writelane_b32 v40, s80, 17
; FLATSCR-NEXT:    v_writelane_b32 v40, s81, 18
; FLATSCR-NEXT:    v_writelane_b32 v40, s82, 19
; FLATSCR-NEXT:    v_writelane_b32 v40, s83, 20
; FLATSCR-NEXT:    v_writelane_b32 v40, s84, 21
; FLATSCR-NEXT:    v_writelane_b32 v40, s85, 22
; FLATSCR-NEXT:    v_writelane_b32 v40, s86, 23
; FLATSCR-NEXT:    v_writelane_b32 v40, s87, 24
; FLATSCR-NEXT:    v_writelane_b32 v40, s96, 25
; FLATSCR-NEXT:    v_writelane_b32 v40, s97, 26
; FLATSCR-NEXT:    v_writelane_b32 v40, s98, 27
; FLATSCR-NEXT:    v_writelane_b32 v40, s99, 28
; FLATSCR-NEXT:    v_writelane_b32 v40, s100, 29
; FLATSCR-NEXT:    v_writelane_b32 v40, s101, 30
; FLATSCR-NEXT:    s_add_i32 s32, s32, 8
; FLATSCR-NEXT:    v_writelane_b32 v40, s102, 31
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; clobber nonpreserved SGPRs and 64 CSRs
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; clobber all VGPRs except CSR v40
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    v_readlane_b32 s102, v40, 31
; FLATSCR-NEXT:    v_readlane_b32 s101, v40, 30
; FLATSCR-NEXT:    v_readlane_b32 s100, v40, 29
; FLATSCR-NEXT:    v_readlane_b32 s99, v40, 28
; FLATSCR-NEXT:    v_readlane_b32 s98, v40, 27
; FLATSCR-NEXT:    v_readlane_b32 s97, v40, 26
; FLATSCR-NEXT:    v_readlane_b32 s96, v40, 25
; FLATSCR-NEXT:    v_readlane_b32 s87, v40, 24
; FLATSCR-NEXT:    v_readlane_b32 s86, v40, 23
; FLATSCR-NEXT:    v_readlane_b32 s85, v40, 22
; FLATSCR-NEXT:    v_readlane_b32 s84, v40, 21
; FLATSCR-NEXT:    v_readlane_b32 s83, v40, 20
; FLATSCR-NEXT:    v_readlane_b32 s82, v40, 19
; FLATSCR-NEXT:    v_readlane_b32 s81, v40, 18
; FLATSCR-NEXT:    v_readlane_b32 s80, v40, 17
; FLATSCR-NEXT:    v_readlane_b32 s71, v40, 16
; FLATSCR-NEXT:    v_readlane_b32 s70, v40, 15
; FLATSCR-NEXT:    v_readlane_b32 s69, v40, 14
; FLATSCR-NEXT:    v_readlane_b32 s68, v40, 13
; FLATSCR-NEXT:    v_readlane_b32 s67, v40, 12
; FLATSCR-NEXT:    v_readlane_b32 s66, v40, 11
; FLATSCR-NEXT:    v_readlane_b32 s65, v40, 10
; FLATSCR-NEXT:    v_readlane_b32 s64, v40, 9
; FLATSCR-NEXT:    v_readlane_b32 s55, v40, 8
; FLATSCR-NEXT:    v_readlane_b32 s54, v40, 7
; FLATSCR-NEXT:    v_readlane_b32 s53, v40, 6
; FLATSCR-NEXT:    v_readlane_b32 s52, v40, 5
; FLATSCR-NEXT:    v_readlane_b32 s51, v40, 4
; FLATSCR-NEXT:    v_readlane_b32 s50, v40, 3
; FLATSCR-NEXT:    v_readlane_b32 s49, v40, 2
; FLATSCR-NEXT:    v_readlane_b32 s48, v40, 1
; FLATSCR-NEXT:    v_readlane_b32 s39, v40, 0
; FLATSCR-NEXT:    s_mov_b32 s32, s33
; FLATSCR-NEXT:    s_or_saveexec_b64 s[2:3], -1
; FLATSCR-NEXT:    scratch_load_dword v40, off, s33 ; 4-byte Folded Reload
; FLATSCR-NEXT:    s_mov_b64 exec, s[2:3]
; FLATSCR-NEXT:    s_mov_b32 s33, s0
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    s_setpc_b64 s[30:31]
  call void asm sideeffect "; clobber nonpreserved SGPRs and 64 CSRs",
    "~{s4},~{s5},~{s6},~{s7},~{s8},~{s9}
    ,~{s10},~{s11},~{s12},~{s13},~{s14},~{s15},~{s16},~{s17},~{s18},~{s19}
    ,~{s20},~{s21},~{s22},~{s23},~{s24},~{s25},~{s26},~{s27},~{s28},~{s29}
    ,~{s40},~{s41},~{s42},~{s43},~{s44},~{s45},~{s46},~{s47},~{s48},~{s49}
    ,~{s50},~{s51},~{s52},~{s53},~{s54},~{s55},~{s56},~{s57},~{s58},~{s59}
    ,~{s60},~{s61},~{s62},~{s63},~{s64},~{s65},~{s66},~{s67},~{s68},~{s69}
    ,~{s70},~{s71},~{s72},~{s73},~{s74},~{s75},~{s76},~{s77},~{s78},~{s79}
    ,~{s80},~{s81},~{s82},~{s83},~{s84},~{s85},~{s86},~{s87},~{s88},~{s89}
    ,~{s90},~{s91},~{s92},~{s93},~{s94},~{s95},~{s96},~{s97},~{s98},~{s99}
    ,~{s100},~{s101},~{s102},~{s39},~{vcc}"()

  call void asm sideeffect "; clobber all VGPRs except CSR v40",
    "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{v8},~{v9}
    ,~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19}
    ,~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29}
    ,~{v30},~{v31},~{v32},~{v33},~{v34},~{v35},~{v36},~{v37},~{v38},~{v39}"()
  ret void
}

; If the size of the offset exceeds the MUBUF offset field we need another
; scratch VGPR to hold the offset.
define void @spill_fp_to_memory_scratch_reg_needed_mubuf_offset(ptr addrspace(5) byval([4096 x i8]) align 4 %arg) #3 {
; MUBUF-LABEL: spill_fp_to_memory_scratch_reg_needed_mubuf_offset:
; MUBUF:       ; %bb.0:
; MUBUF-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; MUBUF-NEXT:    s_mov_b32 s4, s33
; MUBUF-NEXT:    s_mov_b32 s33, s32
; MUBUF-NEXT:    s_xor_saveexec_b64 s[6:7], -1
; MUBUF-NEXT:    s_add_i32 s5, s33, 0x40100
; MUBUF-NEXT:    buffer_store_dword v39, off, s[0:3], s5 ; 4-byte Folded Spill
; MUBUF-NEXT:    s_mov_b64 exec, s[6:7]
; MUBUF-NEXT:    v_writelane_b32 v39, s4, 32
; MUBUF-NEXT:    v_writelane_b32 v39, s39, 0
; MUBUF-NEXT:    v_writelane_b32 v39, s48, 1
; MUBUF-NEXT:    v_writelane_b32 v39, s49, 2
; MUBUF-NEXT:    v_writelane_b32 v39, s50, 3
; MUBUF-NEXT:    v_writelane_b32 v39, s51, 4
; MUBUF-NEXT:    v_writelane_b32 v39, s52, 5
; MUBUF-NEXT:    v_writelane_b32 v39, s53, 6
; MUBUF-NEXT:    v_writelane_b32 v39, s54, 7
; MUBUF-NEXT:    v_writelane_b32 v39, s55, 8
; MUBUF-NEXT:    v_writelane_b32 v39, s64, 9
; MUBUF-NEXT:    v_writelane_b32 v39, s65, 10
; MUBUF-NEXT:    v_writelane_b32 v39, s66, 11
; MUBUF-NEXT:    v_writelane_b32 v39, s67, 12
; MUBUF-NEXT:    v_writelane_b32 v39, s68, 13
; MUBUF-NEXT:    v_writelane_b32 v39, s69, 14
; MUBUF-NEXT:    v_writelane_b32 v39, s70, 15
; MUBUF-NEXT:    v_writelane_b32 v39, s71, 16
; MUBUF-NEXT:    v_writelane_b32 v39, s80, 17
; MUBUF-NEXT:    v_writelane_b32 v39, s81, 18
; MUBUF-NEXT:    v_writelane_b32 v39, s82, 19
; MUBUF-NEXT:    v_writelane_b32 v39, s83, 20
; MUBUF-NEXT:    v_writelane_b32 v39, s84, 21
; MUBUF-NEXT:    v_writelane_b32 v39, s85, 22
; MUBUF-NEXT:    v_writelane_b32 v39, s86, 23
; MUBUF-NEXT:    v_writelane_b32 v39, s87, 24
; MUBUF-NEXT:    v_writelane_b32 v39, s96, 25
; MUBUF-NEXT:    v_writelane_b32 v39, s97, 26
; MUBUF-NEXT:    v_writelane_b32 v39, s98, 27
; MUBUF-NEXT:    v_writelane_b32 v39, s99, 28
; MUBUF-NEXT:    v_writelane_b32 v39, s100, 29
; MUBUF-NEXT:    v_writelane_b32 v39, s101, 30
; MUBUF-NEXT:    v_mov_b32_e32 v0, 0
; MUBUF-NEXT:    v_mov_b32_e32 v1, 0x1000
; MUBUF-NEXT:    s_add_i32 s32, s32, 0x40300
; MUBUF-NEXT:    v_writelane_b32 v39, s102, 31
; MUBUF-NEXT:    buffer_store_dword v0, v1, s[0:3], s33 offen
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; clobber nonpreserved SGPRs and 64 CSRs
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    ;;#ASMSTART
; MUBUF-NEXT:    ; clobber all VGPRs except CSR v40
; MUBUF-NEXT:    ;;#ASMEND
; MUBUF-NEXT:    v_readlane_b32 s102, v39, 31
; MUBUF-NEXT:    v_readlane_b32 s101, v39, 30
; MUBUF-NEXT:    v_readlane_b32 s100, v39, 29
; MUBUF-NEXT:    v_readlane_b32 s99, v39, 28
; MUBUF-NEXT:    v_readlane_b32 s98, v39, 27
; MUBUF-NEXT:    v_readlane_b32 s97, v39, 26
; MUBUF-NEXT:    v_readlane_b32 s96, v39, 25
; MUBUF-NEXT:    v_readlane_b32 s87, v39, 24
; MUBUF-NEXT:    v_readlane_b32 s86, v39, 23
; MUBUF-NEXT:    v_readlane_b32 s85, v39, 22
; MUBUF-NEXT:    v_readlane_b32 s84, v39, 21
; MUBUF-NEXT:    v_readlane_b32 s83, v39, 20
; MUBUF-NEXT:    v_readlane_b32 s82, v39, 19
; MUBUF-NEXT:    v_readlane_b32 s81, v39, 18
; MUBUF-NEXT:    v_readlane_b32 s80, v39, 17
; MUBUF-NEXT:    v_readlane_b32 s71, v39, 16
; MUBUF-NEXT:    v_readlane_b32 s70, v39, 15
; MUBUF-NEXT:    v_readlane_b32 s69, v39, 14
; MUBUF-NEXT:    v_readlane_b32 s68, v39, 13
; MUBUF-NEXT:    v_readlane_b32 s67, v39, 12
; MUBUF-NEXT:    v_readlane_b32 s66, v39, 11
; MUBUF-NEXT:    v_readlane_b32 s65, v39, 10
; MUBUF-NEXT:    v_readlane_b32 s64, v39, 9
; MUBUF-NEXT:    v_readlane_b32 s55, v39, 8
; MUBUF-NEXT:    v_readlane_b32 s54, v39, 7
; MUBUF-NEXT:    v_readlane_b32 s53, v39, 6
; MUBUF-NEXT:    v_readlane_b32 s52, v39, 5
; MUBUF-NEXT:    v_readlane_b32 s51, v39, 4
; MUBUF-NEXT:    v_readlane_b32 s50, v39, 3
; MUBUF-NEXT:    v_readlane_b32 s49, v39, 2
; MUBUF-NEXT:    v_readlane_b32 s48, v39, 1
; MUBUF-NEXT:    v_readlane_b32 s39, v39, 0
; MUBUF-NEXT:    s_mov_b32 s32, s33
; MUBUF-NEXT:    v_readlane_b32 s4, v39, 32
; MUBUF-NEXT:    s_xor_saveexec_b64 s[6:7], -1
; MUBUF-NEXT:    s_add_i32 s5, s33, 0x40100
; MUBUF-NEXT:    buffer_load_dword v39, off, s[0:3], s5 ; 4-byte Folded Reload
; MUBUF-NEXT:    s_mov_b64 exec, s[6:7]
; MUBUF-NEXT:    s_mov_b32 s33, s4
; MUBUF-NEXT:    s_waitcnt vmcnt(0)
; MUBUF-NEXT:    s_setpc_b64 s[30:31]
;
; FLATSCR-LABEL: spill_fp_to_memory_scratch_reg_needed_mubuf_offset:
; FLATSCR:       ; %bb.0:
; FLATSCR-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; FLATSCR-NEXT:    s_mov_b32 s0, s33
; FLATSCR-NEXT:    s_mov_b32 s33, s32
; FLATSCR-NEXT:    s_xor_saveexec_b64 s[2:3], -1
; FLATSCR-NEXT:    s_add_i32 s1, s33, 0x1004
; FLATSCR-NEXT:    scratch_store_dword off, v39, s1 ; 4-byte Folded Spill
; FLATSCR-NEXT:    s_mov_b64 exec, s[2:3]
; FLATSCR-NEXT:    v_writelane_b32 v39, s39, 0
; FLATSCR-NEXT:    v_writelane_b32 v39, s48, 1
; FLATSCR-NEXT:    v_writelane_b32 v39, s49, 2
; FLATSCR-NEXT:    v_writelane_b32 v39, s50, 3
; FLATSCR-NEXT:    v_writelane_b32 v39, s51, 4
; FLATSCR-NEXT:    v_writelane_b32 v39, s52, 5
; FLATSCR-NEXT:    v_writelane_b32 v39, s53, 6
; FLATSCR-NEXT:    v_writelane_b32 v39, s54, 7
; FLATSCR-NEXT:    v_writelane_b32 v39, s55, 8
; FLATSCR-NEXT:    v_writelane_b32 v39, s64, 9
; FLATSCR-NEXT:    v_writelane_b32 v39, s65, 10
; FLATSCR-NEXT:    v_writelane_b32 v39, s66, 11
; FLATSCR-NEXT:    v_writelane_b32 v39, s67, 12
; FLATSCR-NEXT:    v_writelane_b32 v39, s68, 13
; FLATSCR-NEXT:    v_writelane_b32 v39, s69, 14
; FLATSCR-NEXT:    v_writelane_b32 v39, s70, 15
; FLATSCR-NEXT:    v_writelane_b32 v39, s71, 16
; FLATSCR-NEXT:    v_writelane_b32 v39, s80, 17
; FLATSCR-NEXT:    v_writelane_b32 v39, s81, 18
; FLATSCR-NEXT:    v_writelane_b32 v39, s82, 19
; FLATSCR-NEXT:    v_writelane_b32 v39, s83, 20
; FLATSCR-NEXT:    v_writelane_b32 v39, s84, 21
; FLATSCR-NEXT:    v_writelane_b32 v39, s85, 22
; FLATSCR-NEXT:    v_writelane_b32 v39, s86, 23
; FLATSCR-NEXT:    v_writelane_b32 v39, s87, 24
; FLATSCR-NEXT:    v_writelane_b32 v39, s96, 25
; FLATSCR-NEXT:    v_writelane_b32 v39, s97, 26
; FLATSCR-NEXT:    v_writelane_b32 v39, s98, 27
; FLATSCR-NEXT:    v_writelane_b32 v39, s99, 28
; FLATSCR-NEXT:    s_addk_i32 s32, 0x100c
; FLATSCR-NEXT:    v_writelane_b32 v39, s100, 29
; FLATSCR-NEXT:    v_writelane_b32 v39, s101, 30
; FLATSCR-NEXT:    v_mov_b32_e32 v0, 0
; FLATSCR-NEXT:    s_add_i32 s1, s33, 0x1000
; FLATSCR-NEXT:    v_writelane_b32 v39, s102, 31
; FLATSCR-NEXT:    scratch_store_dword off, v0, s1
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; clobber nonpreserved SGPRs and 64 CSRs
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    ;;#ASMSTART
; FLATSCR-NEXT:    ; clobber all VGPRs except CSR v40
; FLATSCR-NEXT:    ;;#ASMEND
; FLATSCR-NEXT:    v_readlane_b32 s102, v39, 31
; FLATSCR-NEXT:    v_readlane_b32 s101, v39, 30
; FLATSCR-NEXT:    v_readlane_b32 s100, v39, 29
; FLATSCR-NEXT:    v_readlane_b32 s99, v39, 28
; FLATSCR-NEXT:    v_readlane_b32 s98, v39, 27
; FLATSCR-NEXT:    v_readlane_b32 s97, v39, 26
; FLATSCR-NEXT:    v_readlane_b32 s96, v39, 25
; FLATSCR-NEXT:    v_readlane_b32 s87, v39, 24
; FLATSCR-NEXT:    v_readlane_b32 s86, v39, 23
; FLATSCR-NEXT:    v_readlane_b32 s85, v39, 22
; FLATSCR-NEXT:    v_readlane_b32 s84, v39, 21
; FLATSCR-NEXT:    v_readlane_b32 s83, v39, 20
; FLATSCR-NEXT:    v_readlane_b32 s82, v39, 19
; FLATSCR-NEXT:    v_readlane_b32 s81, v39, 18
; FLATSCR-NEXT:    v_readlane_b32 s80, v39, 17
; FLATSCR-NEXT:    v_readlane_b32 s71, v39, 16
; FLATSCR-NEXT:    v_readlane_b32 s70, v39, 15
; FLATSCR-NEXT:    v_readlane_b32 s69, v39, 14
; FLATSCR-NEXT:    v_readlane_b32 s68, v39, 13
; FLATSCR-NEXT:    v_readlane_b32 s67, v39, 12
; FLATSCR-NEXT:    v_readlane_b32 s66, v39, 11
; FLATSCR-NEXT:    v_readlane_b32 s65, v39, 10
; FLATSCR-NEXT:    v_readlane_b32 s64, v39, 9
; FLATSCR-NEXT:    v_readlane_b32 s55, v39, 8
; FLATSCR-NEXT:    v_readlane_b32 s54, v39, 7
; FLATSCR-NEXT:    v_readlane_b32 s53, v39, 6
; FLATSCR-NEXT:    v_readlane_b32 s52, v39, 5
; FLATSCR-NEXT:    v_readlane_b32 s51, v39, 4
; FLATSCR-NEXT:    v_readlane_b32 s50, v39, 3
; FLATSCR-NEXT:    v_readlane_b32 s49, v39, 2
; FLATSCR-NEXT:    v_readlane_b32 s48, v39, 1
; FLATSCR-NEXT:    v_readlane_b32 s39, v39, 0
; FLATSCR-NEXT:    s_mov_b32 s32, s33
; FLATSCR-NEXT:    s_xor_saveexec_b64 s[2:3], -1
; FLATSCR-NEXT:    s_add_i32 s1, s33, 0x1004
; FLATSCR-NEXT:    scratch_load_dword v39, off, s1 ; 4-byte Folded Reload
; FLATSCR-NEXT:    s_mov_b64 exec, s[2:3]
; FLATSCR-NEXT:    s_mov_b32 s33, s0
; FLATSCR-NEXT:    s_waitcnt vmcnt(0)
; FLATSCR-NEXT:    s_setpc_b64 s[30:31]
  %alloca = alloca i32, addrspace(5)
  store volatile i32 0, ptr addrspace(5) %alloca

  call void asm sideeffect "; clobber nonpreserved SGPRs and 64 CSRs",
    "~{s4},~{s5},~{s6},~{s7},~{s8},~{s9}
    ,~{s10},~{s11},~{s12},~{s13},~{s14},~{s15},~{s16},~{s17},~{s18},~{s19}
    ,~{s20},~{s21},~{s22},~{s23},~{s24},~{s25},~{s26},~{s27},~{s28},~{s29}
    ,~{s40},~{s41},~{s42},~{s43},~{s44},~{s45},~{s46},~{s47},~{s48},~{s49}
    ,~{s50},~{s51},~{s52},~{s53},~{s54},~{s55},~{s56},~{s57},~{s58},~{s59}
    ,~{s60},~{s61},~{s62},~{s63},~{s64},~{s65},~{s66},~{s67},~{s68},~{s69}
    ,~{s70},~{s71},~{s72},~{s73},~{s74},~{s75},~{s76},~{s77},~{s78},~{s79}
    ,~{s80},~{s81},~{s82},~{s83},~{s84},~{s85},~{s86},~{s87},~{s88},~{s89}
    ,~{s90},~{s91},~{s92},~{s93},~{s94},~{s95},~{s96},~{s97},~{s98},~{s99}
    ,~{s100},~{s101},~{s102},~{s39},~{vcc}"()

  call void asm sideeffect "; clobber all VGPRs except CSR v40",
    "~{v0},~{v1},~{v2},~{v3},~{v4},~{v5},~{v6},~{v7},~{v8},~{v9}
    ,~{v10},~{v11},~{v12},~{v13},~{v14},~{v15},~{v16},~{v17},~{v18},~{v19}
    ,~{v20},~{v21},~{v22},~{v23},~{v24},~{v25},~{v26},~{v27},~{v28},~{v29}
    ,~{v30},~{v31},~{v32},~{v33},~{v34},~{v35},~{v36},~{v37},~{v38}"()
  ret void
}

attributes #0 = { nounwind }
attributes #1 = { nounwind "frame-pointer"="all" }
attributes #2 = { nounwind "frame-pointer"="non-leaf" }
attributes #3 = { nounwind "frame-pointer"="all" "amdgpu-waves-per-eu"="6,6" }
