; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s  -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: opt < %s  -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE,SSSE3
; RUN: opt < %s  -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE,SSE42
; RUN: opt < %s  -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx | FileCheck %s --check-prefixes=AVX1
; RUN: opt < %s  -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: opt < %s  -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512FVEC512
; RUN: opt < %s  -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512f,+avx512vl,+prefer-256-bit | FileCheck %s --check-prefixes=AVX512FVEC256
; RUN: opt < %s  -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512dq | FileCheck %s --check-prefixes=AVX512DQVEC512
; RUN: opt < %s  -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512dq,+avx512vl,+prefer-256-bit | FileCheck %s --check-prefixes=AVX512DQVEC256
; RUN: opt < %s  -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512bw | FileCheck %s --check-prefixes=AVX512BWVEC512
; RUN: opt < %s  -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512bw,+avx512vl,+prefer-256-bit | FileCheck %s --check-prefixes=AVX512BWVEC256
;
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mcpu=slm | FileCheck %s --check-prefixes=SSE,SSE42
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mcpu=goldmont | FileCheck %s --check-prefixes=SSE,SSE42
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-apple-macosx10.8.0 -mcpu=btver2 | FileCheck %s --check-prefixes=BTVER2

define i32 @trunc_vXi32() "min-legal-vector-width"="256" {
; SSE-LABEL: 'trunc_vXi32'
; SSE-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i32
; SSE-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = trunc <2 x i64> undef to <2 x i32>
; SSE-NEXT:  Cost Model: Found costs of 2 for: %V4i64 = trunc <4 x i64> undef to <4 x i32>
; SSE-NEXT:  Cost Model: Found costs of 4 for: %V8i64 = trunc <8 x i64> undef to <8 x i32>
; SSE-NEXT:  Cost Model: Found costs of 8 for: %V16i64 = trunc <16 x i64> undef to <16 x i32>
; SSE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'trunc_vXi32'
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i32
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = trunc <2 x i64> undef to <2 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V8i64 = trunc <8 x i64> undef to <8 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i32>
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'trunc_vXi32'
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i32
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = trunc <2 x i64> undef to <2 x i32>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4i64 = trunc <4 x i64> undef to <4 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V8i64 = trunc <8 x i64> undef to <8 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i32>
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512FVEC512-LABEL: 'trunc_vXi32'
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i32
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = trunc <2 x i64> undef to <2 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 1 for: %V4i64 = trunc <4 x i64> undef to <4 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 1 for: %V8i64 = trunc <8 x i64> undef to <8 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i32>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512FVEC256-LABEL: 'trunc_vXi32'
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i32
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = trunc <2 x i64> undef to <2 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 1 for: %V4i64 = trunc <4 x i64> undef to <4 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V8i64 = trunc <8 x i64> undef to <8 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i32>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQVEC512-LABEL: 'trunc_vXi32'
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i32
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = trunc <2 x i64> undef to <2 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 1 for: %V4i64 = trunc <4 x i64> undef to <4 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 1 for: %V8i64 = trunc <8 x i64> undef to <8 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i32>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQVEC256-LABEL: 'trunc_vXi32'
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i32
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = trunc <2 x i64> undef to <2 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 1 for: %V4i64 = trunc <4 x i64> undef to <4 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V8i64 = trunc <8 x i64> undef to <8 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i32>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BWVEC512-LABEL: 'trunc_vXi32'
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i32
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = trunc <2 x i64> undef to <2 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 1 for: %V4i64 = trunc <4 x i64> undef to <4 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 1 for: %V8i64 = trunc <8 x i64> undef to <8 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i32>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BWVEC256-LABEL: 'trunc_vXi32'
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i32
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = trunc <2 x i64> undef to <2 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 1 for: %V4i64 = trunc <4 x i64> undef to <4 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V8i64 = trunc <8 x i64> undef to <8 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i32>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; BTVER2-LABEL: 'trunc_vXi32'
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i32
; BTVER2-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = trunc <2 x i64> undef to <2 x i32>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i32>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V8i64 = trunc <8 x i64> undef to <8 x i32>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i32>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %i64 = trunc i64 undef to i32
  %V2i64 = trunc <2 x i64> undef to <2 x i32>
  %V4i64 = trunc <4 x i64> undef to <4 x i32>
  %V8i64 = trunc <8 x i64> undef to <8 x i32>
  %V16i64 = trunc <16 x i64> undef to <16 x i32>
  ret i32 undef
}

define i32 @trunc_vXi16() "min-legal-vector-width"="256" {
; SSE2-LABEL: 'trunc_vXi16'
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i16
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i16
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:32 Lat:32 SizeLat:32 for: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:32 Lat:32 SizeLat:32 for: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:32 Lat:32 SizeLat:32 for: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:32 Lat:32 SizeLat:32 for: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'trunc_vXi16'
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i16
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i16
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:32 Lat:32 SizeLat:32 for: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:32 Lat:32 SizeLat:32 for: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:32 Lat:32 SizeLat:32 for: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:32 Lat:32 SizeLat:32 for: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'trunc_vXi16'
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i16
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i16
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'trunc_vXi16'
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i16
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:23 CodeSize:1 Lat:1 SizeLat:1 for: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:27 CodeSize:1 Lat:1 SizeLat:1 for: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:31 CodeSize:1 Lat:1 SizeLat:1 for: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:61 CodeSize:1 Lat:1 SizeLat:1 for: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:1 Lat:1 SizeLat:1 for: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:85 CodeSize:1 Lat:1 SizeLat:1 for: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:102 CodeSize:1 Lat:1 SizeLat:1 for: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:119 CodeSize:1 Lat:1 SizeLat:1 for: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:1 Lat:1 SizeLat:1 for: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:170 CodeSize:1 Lat:1 SizeLat:1 for: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:204 CodeSize:1 Lat:1 SizeLat:1 for: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:238 CodeSize:1 Lat:1 SizeLat:1 for: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:104 CodeSize:1 Lat:1 SizeLat:1 for: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:340 CodeSize:1 Lat:1 SizeLat:1 for: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:408 CodeSize:1 Lat:1 SizeLat:1 for: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:476 CodeSize:1 Lat:1 SizeLat:1 for: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:208 CodeSize:1 Lat:1 SizeLat:1 for: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:680 CodeSize:1 Lat:1 SizeLat:1 for: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:816 CodeSize:1 Lat:1 SizeLat:1 for: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:952 CodeSize:1 Lat:1 SizeLat:1 for: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:416 CodeSize:1 Lat:1 SizeLat:1 for: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i16
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:23 CodeSize:1 Lat:1 SizeLat:1 for: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:27 CodeSize:1 Lat:1 SizeLat:1 for: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:31 CodeSize:1 Lat:1 SizeLat:1 for: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:61 CodeSize:1 Lat:1 SizeLat:1 for: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:85 CodeSize:1 Lat:1 SizeLat:1 for: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:102 CodeSize:1 Lat:1 SizeLat:1 for: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:119 CodeSize:1 Lat:1 SizeLat:1 for: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:1 Lat:1 SizeLat:1 for: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:170 CodeSize:1 Lat:1 SizeLat:1 for: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:204 CodeSize:1 Lat:1 SizeLat:1 for: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:238 CodeSize:1 Lat:1 SizeLat:1 for: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:1 Lat:1 SizeLat:1 for: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:340 CodeSize:1 Lat:1 SizeLat:1 for: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:408 CodeSize:1 Lat:1 SizeLat:1 for: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:476 CodeSize:1 Lat:1 SizeLat:1 for: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:1 Lat:1 SizeLat:1 for: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:680 CodeSize:1 Lat:1 SizeLat:1 for: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:816 CodeSize:1 Lat:1 SizeLat:1 for: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:952 CodeSize:1 Lat:1 SizeLat:1 for: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:1 Lat:1 SizeLat:1 for: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'trunc_vXi16'
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i16
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:23 CodeSize:1 Lat:1 SizeLat:1 for: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:27 CodeSize:1 Lat:1 SizeLat:1 for: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:31 CodeSize:1 Lat:1 SizeLat:1 for: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:61 CodeSize:1 Lat:1 SizeLat:1 for: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:42 CodeSize:1 Lat:1 SizeLat:1 for: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:85 CodeSize:1 Lat:1 SizeLat:1 for: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:102 CodeSize:1 Lat:1 SizeLat:1 for: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:119 CodeSize:1 Lat:1 SizeLat:1 for: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:84 CodeSize:1 Lat:1 SizeLat:1 for: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:170 CodeSize:1 Lat:1 SizeLat:1 for: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:204 CodeSize:1 Lat:1 SizeLat:1 for: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:238 CodeSize:1 Lat:1 SizeLat:1 for: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:168 CodeSize:1 Lat:1 SizeLat:1 for: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:340 CodeSize:1 Lat:1 SizeLat:1 for: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:408 CodeSize:1 Lat:1 SizeLat:1 for: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:476 CodeSize:1 Lat:1 SizeLat:1 for: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:336 CodeSize:1 Lat:1 SizeLat:1 for: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:680 CodeSize:1 Lat:1 SizeLat:1 for: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:816 CodeSize:1 Lat:1 SizeLat:1 for: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:952 CodeSize:1 Lat:1 SizeLat:1 for: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:672 CodeSize:1 Lat:1 SizeLat:1 for: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i16
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:23 CodeSize:1 Lat:1 SizeLat:1 for: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:27 CodeSize:1 Lat:1 SizeLat:1 for: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:31 CodeSize:1 Lat:1 SizeLat:1 for: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:61 CodeSize:1 Lat:1 SizeLat:1 for: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:85 CodeSize:1 Lat:1 SizeLat:1 for: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:102 CodeSize:1 Lat:1 SizeLat:1 for: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:119 CodeSize:1 Lat:1 SizeLat:1 for: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:1 Lat:1 SizeLat:1 for: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:170 CodeSize:1 Lat:1 SizeLat:1 for: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:204 CodeSize:1 Lat:1 SizeLat:1 for: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:238 CodeSize:1 Lat:1 SizeLat:1 for: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:1 Lat:1 SizeLat:1 for: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:340 CodeSize:1 Lat:1 SizeLat:1 for: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:408 CodeSize:1 Lat:1 SizeLat:1 for: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:476 CodeSize:1 Lat:1 SizeLat:1 for: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:1 Lat:1 SizeLat:1 for: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:680 CodeSize:1 Lat:1 SizeLat:1 for: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:816 CodeSize:1 Lat:1 SizeLat:1 for: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:952 CodeSize:1 Lat:1 SizeLat:1 for: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:1 Lat:1 SizeLat:1 for: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512FVEC512-LABEL: 'trunc_vXi16'
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i16
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i16
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 1 for: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 1 for: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 1 for: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512FVEC256-LABEL: 'trunc_vXi16'
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i16
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:23 CodeSize:1 Lat:1 SizeLat:1 for: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:27 CodeSize:1 Lat:1 SizeLat:1 for: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:31 CodeSize:1 Lat:1 SizeLat:1 for: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:61 CodeSize:1 Lat:1 SizeLat:1 for: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:42 CodeSize:1 Lat:1 SizeLat:1 for: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:85 CodeSize:1 Lat:1 SizeLat:1 for: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:102 CodeSize:1 Lat:1 SizeLat:1 for: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:119 CodeSize:1 Lat:1 SizeLat:1 for: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:84 CodeSize:1 Lat:1 SizeLat:1 for: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:170 CodeSize:1 Lat:1 SizeLat:1 for: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:204 CodeSize:1 Lat:1 SizeLat:1 for: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:238 CodeSize:1 Lat:1 SizeLat:1 for: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:168 CodeSize:1 Lat:1 SizeLat:1 for: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:340 CodeSize:1 Lat:1 SizeLat:1 for: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:408 CodeSize:1 Lat:1 SizeLat:1 for: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:476 CodeSize:1 Lat:1 SizeLat:1 for: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:336 CodeSize:1 Lat:1 SizeLat:1 for: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:680 CodeSize:1 Lat:1 SizeLat:1 for: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:816 CodeSize:1 Lat:1 SizeLat:1 for: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:952 CodeSize:1 Lat:1 SizeLat:1 for: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:672 CodeSize:1 Lat:1 SizeLat:1 for: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i16
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 1 for: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 1 for: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 1 for: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:23 CodeSize:1 Lat:1 SizeLat:1 for: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:27 CodeSize:1 Lat:1 SizeLat:1 for: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:31 CodeSize:1 Lat:1 SizeLat:1 for: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:61 CodeSize:1 Lat:1 SizeLat:1 for: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:85 CodeSize:1 Lat:1 SizeLat:1 for: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:102 CodeSize:1 Lat:1 SizeLat:1 for: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:119 CodeSize:1 Lat:1 SizeLat:1 for: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:1 Lat:1 SizeLat:1 for: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:170 CodeSize:1 Lat:1 SizeLat:1 for: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:204 CodeSize:1 Lat:1 SizeLat:1 for: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:238 CodeSize:1 Lat:1 SizeLat:1 for: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:1 Lat:1 SizeLat:1 for: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:340 CodeSize:1 Lat:1 SizeLat:1 for: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:408 CodeSize:1 Lat:1 SizeLat:1 for: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:476 CodeSize:1 Lat:1 SizeLat:1 for: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:1 Lat:1 SizeLat:1 for: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:680 CodeSize:1 Lat:1 SizeLat:1 for: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:816 CodeSize:1 Lat:1 SizeLat:1 for: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:952 CodeSize:1 Lat:1 SizeLat:1 for: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:1 Lat:1 SizeLat:1 for: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQVEC512-LABEL: 'trunc_vXi16'
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i16
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i16
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 1 for: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 1 for: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 1 for: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQVEC256-LABEL: 'trunc_vXi16'
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i16
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:23 CodeSize:1 Lat:1 SizeLat:1 for: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:27 CodeSize:1 Lat:1 SizeLat:1 for: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:31 CodeSize:1 Lat:1 SizeLat:1 for: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:61 CodeSize:1 Lat:1 SizeLat:1 for: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:42 CodeSize:1 Lat:1 SizeLat:1 for: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:85 CodeSize:1 Lat:1 SizeLat:1 for: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:102 CodeSize:1 Lat:1 SizeLat:1 for: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:119 CodeSize:1 Lat:1 SizeLat:1 for: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:84 CodeSize:1 Lat:1 SizeLat:1 for: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:170 CodeSize:1 Lat:1 SizeLat:1 for: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:204 CodeSize:1 Lat:1 SizeLat:1 for: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:238 CodeSize:1 Lat:1 SizeLat:1 for: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:168 CodeSize:1 Lat:1 SizeLat:1 for: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:340 CodeSize:1 Lat:1 SizeLat:1 for: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:408 CodeSize:1 Lat:1 SizeLat:1 for: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:476 CodeSize:1 Lat:1 SizeLat:1 for: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:336 CodeSize:1 Lat:1 SizeLat:1 for: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:680 CodeSize:1 Lat:1 SizeLat:1 for: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:816 CodeSize:1 Lat:1 SizeLat:1 for: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:952 CodeSize:1 Lat:1 SizeLat:1 for: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:672 CodeSize:1 Lat:1 SizeLat:1 for: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i16
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 1 for: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 1 for: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 1 for: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:23 CodeSize:1 Lat:1 SizeLat:1 for: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:27 CodeSize:1 Lat:1 SizeLat:1 for: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:31 CodeSize:1 Lat:1 SizeLat:1 for: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:61 CodeSize:1 Lat:1 SizeLat:1 for: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:85 CodeSize:1 Lat:1 SizeLat:1 for: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:102 CodeSize:1 Lat:1 SizeLat:1 for: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:119 CodeSize:1 Lat:1 SizeLat:1 for: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:1 Lat:1 SizeLat:1 for: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:170 CodeSize:1 Lat:1 SizeLat:1 for: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:204 CodeSize:1 Lat:1 SizeLat:1 for: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:238 CodeSize:1 Lat:1 SizeLat:1 for: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:1 Lat:1 SizeLat:1 for: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:340 CodeSize:1 Lat:1 SizeLat:1 for: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:408 CodeSize:1 Lat:1 SizeLat:1 for: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:476 CodeSize:1 Lat:1 SizeLat:1 for: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:1 Lat:1 SizeLat:1 for: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:680 CodeSize:1 Lat:1 SizeLat:1 for: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:816 CodeSize:1 Lat:1 SizeLat:1 for: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:952 CodeSize:1 Lat:1 SizeLat:1 for: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:1 Lat:1 SizeLat:1 for: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BWVEC512-LABEL: 'trunc_vXi16'
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i16
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i16
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 1 for: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 1 for: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 1 for: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BWVEC256-LABEL: 'trunc_vXi16'
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i16
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:23 CodeSize:1 Lat:1 SizeLat:1 for: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:27 CodeSize:1 Lat:1 SizeLat:1 for: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:31 CodeSize:1 Lat:1 SizeLat:1 for: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:21 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:61 CodeSize:1 Lat:1 SizeLat:1 for: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:42 CodeSize:1 Lat:1 SizeLat:1 for: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:85 CodeSize:1 Lat:1 SizeLat:1 for: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:102 CodeSize:1 Lat:1 SizeLat:1 for: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:119 CodeSize:1 Lat:1 SizeLat:1 for: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:84 CodeSize:1 Lat:1 SizeLat:1 for: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:170 CodeSize:1 Lat:1 SizeLat:1 for: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:204 CodeSize:1 Lat:1 SizeLat:1 for: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:238 CodeSize:1 Lat:1 SizeLat:1 for: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:168 CodeSize:1 Lat:1 SizeLat:1 for: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:340 CodeSize:1 Lat:1 SizeLat:1 for: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:408 CodeSize:1 Lat:1 SizeLat:1 for: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:476 CodeSize:1 Lat:1 SizeLat:1 for: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:336 CodeSize:1 Lat:1 SizeLat:1 for: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:680 CodeSize:1 Lat:1 SizeLat:1 for: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:816 CodeSize:1 Lat:1 SizeLat:1 for: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:952 CodeSize:1 Lat:1 SizeLat:1 for: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:672 CodeSize:1 Lat:1 SizeLat:1 for: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i16
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 1 for: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 1 for: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 1 for: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:23 CodeSize:1 Lat:1 SizeLat:1 for: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:27 CodeSize:1 Lat:1 SizeLat:1 for: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:31 CodeSize:1 Lat:1 SizeLat:1 for: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:61 CodeSize:1 Lat:1 SizeLat:1 for: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:85 CodeSize:1 Lat:1 SizeLat:1 for: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:102 CodeSize:1 Lat:1 SizeLat:1 for: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:119 CodeSize:1 Lat:1 SizeLat:1 for: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:1 Lat:1 SizeLat:1 for: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:170 CodeSize:1 Lat:1 SizeLat:1 for: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:204 CodeSize:1 Lat:1 SizeLat:1 for: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:238 CodeSize:1 Lat:1 SizeLat:1 for: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:1 Lat:1 SizeLat:1 for: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:340 CodeSize:1 Lat:1 SizeLat:1 for: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:408 CodeSize:1 Lat:1 SizeLat:1 for: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:476 CodeSize:1 Lat:1 SizeLat:1 for: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:1 Lat:1 SizeLat:1 for: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:680 CodeSize:1 Lat:1 SizeLat:1 for: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:816 CodeSize:1 Lat:1 SizeLat:1 for: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:952 CodeSize:1 Lat:1 SizeLat:1 for: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:1 Lat:1 SizeLat:1 for: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; BTVER2-LABEL: 'trunc_vXi16'
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i16
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i64 = trunc <2 x i64> undef to <2 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V3i64 = trunc <3 x i64> undef to <3 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V5i64 = trunc <5 x i64> undef to <5 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V6i64 = trunc <6 x i64> undef to <6 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V7i64 = trunc <7 x i64> undef to <7 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V8i64 = trunc <8 x i64> undef to <8 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:23 CodeSize:1 Lat:1 SizeLat:1 for: %V10i64 = trunc <10 x i64> undef to <10 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:27 CodeSize:1 Lat:1 SizeLat:1 for: %V12i64 = trunc <12 x i64> undef to <12 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:31 CodeSize:1 Lat:1 SizeLat:1 for: %V14i64 = trunc <14 x i64> undef to <14 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i64 = trunc <20 x i64> undef to <20 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i64 = trunc <24 x i64> undef to <24 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:61 CodeSize:1 Lat:1 SizeLat:1 for: %V28i64 = trunc <28 x i64> undef to <28 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:1 Lat:1 SizeLat:1 for: %V32i64 = trunc <32 x i64> undef to <32 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:85 CodeSize:1 Lat:1 SizeLat:1 for: %V40i64 = trunc <40 x i64> undef to <40 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:102 CodeSize:1 Lat:1 SizeLat:1 for: %V48i64 = trunc <48 x i64> undef to <48 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:119 CodeSize:1 Lat:1 SizeLat:1 for: %V56i64 = trunc <56 x i64> undef to <56 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:1 Lat:1 SizeLat:1 for: %V64i64 = trunc <64 x i64> undef to <64 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:170 CodeSize:1 Lat:1 SizeLat:1 for: %V80i64 = trunc <80 x i64> undef to <80 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:204 CodeSize:1 Lat:1 SizeLat:1 for: %V96i64 = trunc <96 x i64> undef to <96 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:238 CodeSize:1 Lat:1 SizeLat:1 for: %V112i64 = trunc <112 x i64> undef to <112 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:104 CodeSize:1 Lat:1 SizeLat:1 for: %V128i64 = trunc <128 x i64> undef to <128 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:340 CodeSize:1 Lat:1 SizeLat:1 for: %V160i64 = trunc <160 x i64> undef to <160 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:408 CodeSize:1 Lat:1 SizeLat:1 for: %V192i64 = trunc <192 x i64> undef to <192 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:476 CodeSize:1 Lat:1 SizeLat:1 for: %V224i64 = trunc <224 x i64> undef to <224 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:208 CodeSize:1 Lat:1 SizeLat:1 for: %V256i64 = trunc <256 x i64> undef to <256 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:680 CodeSize:1 Lat:1 SizeLat:1 for: %V320i64 = trunc <320 x i64> undef to <320 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:816 CodeSize:1 Lat:1 SizeLat:1 for: %V384i64 = trunc <384 x i64> undef to <384 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:952 CodeSize:1 Lat:1 SizeLat:1 for: %V448i64 = trunc <448 x i64> undef to <448 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:416 CodeSize:1 Lat:1 SizeLat:1 for: %V512i64 = trunc <512 x i64> undef to <512 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i16
; BTVER2-NEXT:  Cost Model: Found costs of 1 for: %V2i32 = trunc <2 x i32> undef to <2 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V3i32 = trunc <3 x i32> undef to <3 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i32 = trunc <4 x i32> undef to <4 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V5i32 = trunc <5 x i32> undef to <5 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V7i32 = trunc <7 x i32> undef to <7 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:23 CodeSize:1 Lat:1 SizeLat:1 for: %V10i32 = trunc <10 x i32> undef to <10 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:27 CodeSize:1 Lat:1 SizeLat:1 for: %V12i32 = trunc <12 x i32> undef to <12 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:31 CodeSize:1 Lat:1 SizeLat:1 for: %V14i32 = trunc <14 x i32> undef to <14 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i32 = trunc <20 x i32> undef to <20 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i32 = trunc <24 x i32> undef to <24 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:61 CodeSize:1 Lat:1 SizeLat:1 for: %V28i32 = trunc <28 x i32> undef to <28 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %V32i32 = trunc <32 x i32> undef to <32 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:85 CodeSize:1 Lat:1 SizeLat:1 for: %V40i32 = trunc <40 x i32> undef to <40 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:102 CodeSize:1 Lat:1 SizeLat:1 for: %V48i32 = trunc <48 x i32> undef to <48 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:119 CodeSize:1 Lat:1 SizeLat:1 for: %V56i32 = trunc <56 x i32> undef to <56 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:1 Lat:1 SizeLat:1 for: %V64i32 = trunc <64 x i32> undef to <64 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:170 CodeSize:1 Lat:1 SizeLat:1 for: %V80i32 = trunc <80 x i32> undef to <80 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:204 CodeSize:1 Lat:1 SizeLat:1 for: %V96i32 = trunc <96 x i32> undef to <96 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:238 CodeSize:1 Lat:1 SizeLat:1 for: %V112i32 = trunc <112 x i32> undef to <112 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:1 Lat:1 SizeLat:1 for: %V128i32 = trunc <128 x i32> undef to <128 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:340 CodeSize:1 Lat:1 SizeLat:1 for: %V160i32 = trunc <160 x i32> undef to <160 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:408 CodeSize:1 Lat:1 SizeLat:1 for: %V192i32 = trunc <192 x i32> undef to <192 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:476 CodeSize:1 Lat:1 SizeLat:1 for: %V224i32 = trunc <224 x i32> undef to <224 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:1 Lat:1 SizeLat:1 for: %V256i32 = trunc <256 x i32> undef to <256 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:680 CodeSize:1 Lat:1 SizeLat:1 for: %V320i32 = trunc <320 x i32> undef to <320 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:816 CodeSize:1 Lat:1 SizeLat:1 for: %V384i32 = trunc <384 x i32> undef to <384 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:952 CodeSize:1 Lat:1 SizeLat:1 for: %V448i32 = trunc <448 x i32> undef to <448 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:1 Lat:1 SizeLat:1 for: %V512i32 = trunc <512 x i32> undef to <512 x i16>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %i64 = trunc i64 undef to i16
  %V2i64 = trunc <2 x i64> undef to <2 x i16>
  %V3i64 = trunc <3 x i64> undef to <3 x i16>
  %V4i64 = trunc <4 x i64> undef to <4 x i16>
  %V5i64 = trunc <5 x i64> undef to <5 x i16>
  %V6i64 = trunc <6 x i64> undef to <6 x i16>
  %V7i64 = trunc <7 x i64> undef to <7 x i16>
  %V8i64 = trunc <8 x i64> undef to <8 x i16>
  %V10i64 = trunc <10 x i64> undef to <10 x i16>
  %V12i64 = trunc <12 x i64> undef to <12 x i16>
  %V14i64 = trunc <14 x i64> undef to <14 x i16>
  %V16i64 = trunc <16 x i64> undef to <16 x i16>
  %V20i64 = trunc <20 x i64> undef to <20 x i16>
  %V24i64 = trunc <24 x i64> undef to <24 x i16>
  %V28i64 = trunc <28 x i64> undef to <28 x i16>
  %V32i64 = trunc <32 x i64> undef to <32 x i16>
  %V40i64 = trunc <40 x i64> undef to <40 x i16>
  %V48i64 = trunc <48 x i64> undef to <48 x i16>
  %V56i64 = trunc <56 x i64> undef to <56 x i16>
  %V64i64 = trunc <64 x i64> undef to <64 x i16>
  %V80i64 = trunc <80 x i64> undef to <80 x i16>
  %V96i64 = trunc <96 x i64> undef to <96 x i16>
  %V112i64 = trunc <112 x i64> undef to <112 x i16>
  %V128i64 = trunc <128 x i64> undef to <128 x i16>
  %V160i64 = trunc <160 x i64> undef to <160 x i16>
  %V192i64 = trunc <192 x i64> undef to <192 x i16>
  %V224i64 = trunc <224 x i64> undef to <224 x i16>
  %V256i64 = trunc <256 x i64> undef to <256 x i16>
  %V320i64 = trunc <320 x i64> undef to <320 x i16>
  %V384i64 = trunc <384 x i64> undef to <384 x i16>
  %V448i64 = trunc <448 x i64> undef to <448 x i16>
  %V512i64 = trunc <512 x i64> undef to <512 x i16>

  %i32 = trunc i32 undef to i16
  %V2i32 = trunc <2 x i32> undef to <2 x i16>
  %V3i32 = trunc <3 x i32> undef to <3 x i16>
  %V4i32 = trunc <4 x i32> undef to <4 x i16>
  %V5i32 = trunc <5 x i32> undef to <5 x i16>
  %V6i32 = trunc <6 x i32> undef to <6 x i16>
  %V7i32 = trunc <7 x i32> undef to <7 x i16>
  %V8i32 = trunc <8 x i32> undef to <8 x i16>
  %V10i32 = trunc <10 x i32> undef to <10 x i16>
  %V12i32 = trunc <12 x i32> undef to <12 x i16>
  %V14i32 = trunc <14 x i32> undef to <14 x i16>
  %V16i32 = trunc <16 x i32> undef to <16 x i16>
  %V20i32 = trunc <20 x i32> undef to <20 x i16>
  %V24i32 = trunc <24 x i32> undef to <24 x i16>
  %V28i32 = trunc <28 x i32> undef to <28 x i16>
  %V32i32 = trunc <32 x i32> undef to <32 x i16>
  %V40i32 = trunc <40 x i32> undef to <40 x i16>
  %V48i32 = trunc <48 x i32> undef to <48 x i16>
  %V56i32 = trunc <56 x i32> undef to <56 x i16>
  %V64i32 = trunc <64 x i32> undef to <64 x i16>
  %V80i32 = trunc <80 x i32> undef to <80 x i16>
  %V96i32 = trunc <96 x i32> undef to <96 x i16>
  %V112i32 = trunc <112 x i32> undef to <112 x i16>
  %V128i32 = trunc <128 x i32> undef to <128 x i16>
  %V160i32 = trunc <160 x i32> undef to <160 x i16>
  %V192i32 = trunc <192 x i32> undef to <192 x i16>
  %V224i32 = trunc <224 x i32> undef to <224 x i16>
  %V256i32 = trunc <256 x i32> undef to <256 x i16>
  %V320i32 = trunc <320 x i32> undef to <320 x i16>
  %V384i32 = trunc <384 x i32> undef to <384 x i16>
  %V448i32 = trunc <448 x i32> undef to <448 x i16>
  %V512i32 = trunc <512 x i32> undef to <512 x i16>

  ret i32 undef
}

define i32 @trunc_vXi8() "min-legal-vector-width"="256" {
; SSE2-LABEL: 'trunc_vXi8'
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i8
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:8 Lat:8 SizeLat:8 for: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:8 Lat:8 SizeLat:8 for: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:8 Lat:8 SizeLat:8 for: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:8 Lat:8 SizeLat:8 for: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:16 Lat:16 SizeLat:16 for: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:16 Lat:16 SizeLat:16 for: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:16 Lat:16 SizeLat:16 for: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:16 Lat:16 SizeLat:16 for: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:32 Lat:32 SizeLat:32 for: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:32 Lat:32 SizeLat:32 for: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:32 Lat:32 SizeLat:32 for: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:32 Lat:32 SizeLat:32 for: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:64 Lat:64 SizeLat:64 for: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:64 Lat:64 SizeLat:64 for: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:64 Lat:64 SizeLat:64 for: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:64 Lat:64 SizeLat:64 for: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:128 Lat:128 SizeLat:128 for: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:128 Lat:128 SizeLat:128 for: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:128 Lat:128 SizeLat:128 for: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:128 Lat:128 SizeLat:128 for: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:256 Lat:256 SizeLat:256 for: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:256 Lat:256 SizeLat:256 for: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:256 Lat:256 SizeLat:256 for: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:256 Lat:256 SizeLat:256 for: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:2048 CodeSize:512 Lat:512 SizeLat:512 for: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:2048 CodeSize:512 Lat:512 SizeLat:512 for: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:2048 CodeSize:512 Lat:512 SizeLat:512 for: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:2048 CodeSize:512 Lat:512 SizeLat:512 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i8
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:32 Lat:32 SizeLat:32 for: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:32 Lat:32 SizeLat:32 for: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:32 Lat:32 SizeLat:32 for: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:32 Lat:32 SizeLat:32 for: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:256 Lat:256 SizeLat:256 for: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:256 Lat:256 SizeLat:256 for: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:256 Lat:256 SizeLat:256 for: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:256 Lat:256 SizeLat:256 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i8
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'trunc_vXi8'
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i8
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:8 Lat:8 SizeLat:8 for: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:8 Lat:8 SizeLat:8 for: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:8 Lat:8 SizeLat:8 for: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:8 Lat:8 SizeLat:8 for: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:16 Lat:16 SizeLat:16 for: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:16 Lat:16 SizeLat:16 for: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:16 Lat:16 SizeLat:16 for: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:16 Lat:16 SizeLat:16 for: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:32 Lat:32 SizeLat:32 for: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:32 Lat:32 SizeLat:32 for: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:32 Lat:32 SizeLat:32 for: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:32 Lat:32 SizeLat:32 for: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:64 Lat:64 SizeLat:64 for: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:64 Lat:64 SizeLat:64 for: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:64 Lat:64 SizeLat:64 for: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:64 Lat:64 SizeLat:64 for: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:128 Lat:128 SizeLat:128 for: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:128 Lat:128 SizeLat:128 for: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:128 Lat:128 SizeLat:128 for: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:128 Lat:128 SizeLat:128 for: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:256 Lat:256 SizeLat:256 for: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:256 Lat:256 SizeLat:256 for: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:256 Lat:256 SizeLat:256 for: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:256 Lat:256 SizeLat:256 for: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2048 CodeSize:512 Lat:512 SizeLat:512 for: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2048 CodeSize:512 Lat:512 SizeLat:512 for: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2048 CodeSize:512 Lat:512 SizeLat:512 for: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2048 CodeSize:512 Lat:512 SizeLat:512 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i8
; SSSE3-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:32 Lat:32 SizeLat:32 for: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:32 Lat:32 SizeLat:32 for: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:32 Lat:32 SizeLat:32 for: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:32 Lat:32 SizeLat:32 for: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:256 Lat:256 SizeLat:256 for: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:256 Lat:256 SizeLat:256 for: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:256 Lat:256 SizeLat:256 for: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:256 Lat:256 SizeLat:256 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i8
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'trunc_vXi8'
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i8
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:512 Lat:512 SizeLat:512 for: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:512 Lat:512 SizeLat:512 for: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:512 Lat:512 SizeLat:512 for: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:512 Lat:512 SizeLat:512 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i8
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i8
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'trunc_vXi8'
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:41 CodeSize:1 Lat:1 SizeLat:1 for: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:82 CodeSize:1 Lat:1 SizeLat:1 for: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:198 CodeSize:1 Lat:1 SizeLat:1 for: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:164 CodeSize:1 Lat:1 SizeLat:1 for: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:328 CodeSize:1 Lat:1 SizeLat:1 for: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:656 CodeSize:1 Lat:1 SizeLat:1 for: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:1312 CodeSize:1 Lat:1 SizeLat:1 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:1 Lat:1 SizeLat:1 for: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:1 Lat:1 SizeLat:1 for: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:198 CodeSize:1 Lat:1 SizeLat:1 for: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:1 Lat:1 SizeLat:1 for: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:104 CodeSize:1 Lat:1 SizeLat:1 for: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:208 CodeSize:1 Lat:1 SizeLat:1 for: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:416 CodeSize:1 Lat:1 SizeLat:1 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i8
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:198 CodeSize:1 Lat:1 SizeLat:1 for: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:1 Lat:1 SizeLat:1 for: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:1 Lat:1 SizeLat:1 for: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:160 CodeSize:1 Lat:1 SizeLat:1 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'trunc_vXi8'
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i8
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:33 CodeSize:1 Lat:1 SizeLat:1 for: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:66 CodeSize:1 Lat:1 SizeLat:1 for: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:198 CodeSize:1 Lat:1 SizeLat:1 for: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:132 CodeSize:1 Lat:1 SizeLat:1 for: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:264 CodeSize:1 Lat:1 SizeLat:1 for: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:528 CodeSize:1 Lat:1 SizeLat:1 for: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:1056 CodeSize:1 Lat:1 SizeLat:1 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i8
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:1 Lat:1 SizeLat:1 for: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:1 Lat:1 SizeLat:1 for: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:198 CodeSize:1 Lat:1 SizeLat:1 for: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:1 Lat:1 SizeLat:1 for: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:1 Lat:1 SizeLat:1 for: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:144 CodeSize:1 Lat:1 SizeLat:1 for: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:288 CodeSize:1 Lat:1 SizeLat:1 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i8
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:198 CodeSize:1 Lat:1 SizeLat:1 for: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:1 Lat:1 SizeLat:1 for: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:1 Lat:1 SizeLat:1 for: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:160 CodeSize:1 Lat:1 SizeLat:1 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512FVEC512-LABEL: 'trunc_vXi8'
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i8
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i8
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i8
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 1 for: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 1 for: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 1 for: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 1 for: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:8 Lat:8 SizeLat:8 for: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:8 Lat:8 SizeLat:8 for: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:8 Lat:8 SizeLat:8 for: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:8 Lat:8 SizeLat:8 for: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:16 Lat:16 SizeLat:16 for: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:16 Lat:16 SizeLat:16 for: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:16 Lat:16 SizeLat:16 for: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:16 Lat:16 SizeLat:16 for: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:32 Lat:32 SizeLat:32 for: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:32 Lat:32 SizeLat:32 for: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:32 Lat:32 SizeLat:32 for: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:32 Lat:32 SizeLat:32 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512FVEC256-LABEL: 'trunc_vXi8'
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i8
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:33 CodeSize:1 Lat:1 SizeLat:1 for: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:66 CodeSize:1 Lat:1 SizeLat:1 for: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:198 CodeSize:1 Lat:1 SizeLat:1 for: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:132 CodeSize:1 Lat:1 SizeLat:1 for: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:264 CodeSize:1 Lat:1 SizeLat:1 for: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:528 CodeSize:1 Lat:1 SizeLat:1 for: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:1056 CodeSize:1 Lat:1 SizeLat:1 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i8
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 1 for: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 1 for: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:1 Lat:1 SizeLat:1 for: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:1 Lat:1 SizeLat:1 for: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:198 CodeSize:1 Lat:1 SizeLat:1 for: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:1 Lat:1 SizeLat:1 for: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:1 Lat:1 SizeLat:1 for: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:144 CodeSize:1 Lat:1 SizeLat:1 for: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:288 CodeSize:1 Lat:1 SizeLat:1 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i8
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 1 for: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 1 for: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 1 for: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 1 for: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:198 CodeSize:1 Lat:1 SizeLat:1 for: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:1 Lat:1 SizeLat:1 for: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:1 Lat:1 SizeLat:1 for: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:160 CodeSize:1 Lat:1 SizeLat:1 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQVEC512-LABEL: 'trunc_vXi8'
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i8
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i8
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i8
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 1 for: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 1 for: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 1 for: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 1 for: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:8 Lat:8 SizeLat:8 for: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:8 Lat:8 SizeLat:8 for: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:8 Lat:8 SizeLat:8 for: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:8 Lat:8 SizeLat:8 for: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:16 Lat:16 SizeLat:16 for: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:16 Lat:16 SizeLat:16 for: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:16 Lat:16 SizeLat:16 for: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:16 Lat:16 SizeLat:16 for: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:32 Lat:32 SizeLat:32 for: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:32 Lat:32 SizeLat:32 for: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:32 Lat:32 SizeLat:32 for: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:32 Lat:32 SizeLat:32 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQVEC256-LABEL: 'trunc_vXi8'
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i8
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:33 CodeSize:1 Lat:1 SizeLat:1 for: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:66 CodeSize:1 Lat:1 SizeLat:1 for: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:198 CodeSize:1 Lat:1 SizeLat:1 for: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:132 CodeSize:1 Lat:1 SizeLat:1 for: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:264 CodeSize:1 Lat:1 SizeLat:1 for: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:528 CodeSize:1 Lat:1 SizeLat:1 for: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:1056 CodeSize:1 Lat:1 SizeLat:1 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i8
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 1 for: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 1 for: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:1 Lat:1 SizeLat:1 for: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:1 Lat:1 SizeLat:1 for: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:198 CodeSize:1 Lat:1 SizeLat:1 for: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:1 Lat:1 SizeLat:1 for: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:1 Lat:1 SizeLat:1 for: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:144 CodeSize:1 Lat:1 SizeLat:1 for: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:288 CodeSize:1 Lat:1 SizeLat:1 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i8
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 1 for: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 1 for: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 1 for: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 1 for: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:198 CodeSize:1 Lat:1 SizeLat:1 for: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:1 Lat:1 SizeLat:1 for: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:1 Lat:1 SizeLat:1 for: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:160 CodeSize:1 Lat:1 SizeLat:1 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BWVEC512-LABEL: 'trunc_vXi8'
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i8
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i8
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i8
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 1 for: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:8 Lat:8 SizeLat:8 for: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:8 Lat:8 SizeLat:8 for: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:8 Lat:8 SizeLat:8 for: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:8 Lat:8 SizeLat:8 for: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:16 Lat:16 SizeLat:16 for: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:16 Lat:16 SizeLat:16 for: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:16 Lat:16 SizeLat:16 for: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:16 Lat:16 SizeLat:16 for: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:32 Lat:32 SizeLat:32 for: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:32 Lat:32 SizeLat:32 for: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:32 Lat:32 SizeLat:32 for: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:32 Lat:32 SizeLat:32 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BWVEC256-LABEL: 'trunc_vXi8'
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i8
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 1 for: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:33 CodeSize:1 Lat:1 SizeLat:1 for: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:66 CodeSize:1 Lat:1 SizeLat:1 for: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:198 CodeSize:1 Lat:1 SizeLat:1 for: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:132 CodeSize:1 Lat:1 SizeLat:1 for: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:264 CodeSize:1 Lat:1 SizeLat:1 for: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:528 CodeSize:1 Lat:1 SizeLat:1 for: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:1056 CodeSize:1 Lat:1 SizeLat:1 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i8
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 1 for: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 1 for: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:1 Lat:1 SizeLat:1 for: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:18 CodeSize:1 Lat:1 SizeLat:1 for: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:198 CodeSize:1 Lat:1 SizeLat:1 for: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:36 CodeSize:1 Lat:1 SizeLat:1 for: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:72 CodeSize:1 Lat:1 SizeLat:1 for: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:144 CodeSize:1 Lat:1 SizeLat:1 for: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:288 CodeSize:1 Lat:1 SizeLat:1 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i8
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 1 for: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 1 for: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 1 for: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 1 for: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:198 CodeSize:1 Lat:1 SizeLat:1 for: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:1 Lat:1 SizeLat:1 for: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:1 Lat:1 SizeLat:1 for: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:160 CodeSize:1 Lat:1 SizeLat:1 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; BTVER2-LABEL: 'trunc_vXi8'
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i8
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i64 = trunc <2 x i64> undef to <2 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V6i64 = trunc <6 x i64> undef to <6 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V8i64 = trunc <8 x i64> undef to <8 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %V10i64 = trunc <10 x i64> undef to <10 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %V12i64 = trunc <12 x i64> undef to <12 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %V14i64 = trunc <14 x i64> undef to <14 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %V16i64 = trunc <16 x i64> undef to <16 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i64 = trunc <20 x i64> undef to <20 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i64 = trunc <24 x i64> undef to <24 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i64 = trunc <28 x i64> undef to <28 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:41 CodeSize:1 Lat:1 SizeLat:1 for: %V32i64 = trunc <32 x i64> undef to <32 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i64 = trunc <40 x i64> undef to <40 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i64 = trunc <48 x i64> undef to <48 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i64 = trunc <56 x i64> undef to <56 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:82 CodeSize:1 Lat:1 SizeLat:1 for: %V64i64 = trunc <64 x i64> undef to <64 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i64 = trunc <80 x i64> undef to <80 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:198 CodeSize:1 Lat:1 SizeLat:1 for: %V96i64 = trunc <96 x i64> undef to <96 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i64 = trunc <112 x i64> undef to <112 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:164 CodeSize:1 Lat:1 SizeLat:1 for: %V128i64 = trunc <128 x i64> undef to <128 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i64 = trunc <160 x i64> undef to <160 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i64 = trunc <192 x i64> undef to <192 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i64 = trunc <224 x i64> undef to <224 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:328 CodeSize:1 Lat:1 SizeLat:1 for: %V256i64 = trunc <256 x i64> undef to <256 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i64 = trunc <320 x i64> undef to <320 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i64 = trunc <384 x i64> undef to <384 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i64 = trunc <448 x i64> undef to <448 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:656 CodeSize:1 Lat:1 SizeLat:1 for: %V512i64 = trunc <512 x i64> undef to <512 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i64 = trunc <640 x i64> undef to <640 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i64 = trunc <768 x i64> undef to <768 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i64 = trunc <896 x i64> undef to <896 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1312 CodeSize:1 Lat:1 SizeLat:1 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i8
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i32 = trunc <2 x i32> undef to <2 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i32 = trunc <4 x i32> undef to <4 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V10i32 = trunc <10 x i32> undef to <10 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V12i32 = trunc <12 x i32> undef to <12 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V14i32 = trunc <14 x i32> undef to <14 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i32 = trunc <20 x i32> undef to <20 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i32 = trunc <24 x i32> undef to <24 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i32 = trunc <28 x i32> undef to <28 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:13 CodeSize:1 Lat:1 SizeLat:1 for: %V32i32 = trunc <32 x i32> undef to <32 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i32 = trunc <40 x i32> undef to <40 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i32 = trunc <48 x i32> undef to <48 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i32 = trunc <56 x i32> undef to <56 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:26 CodeSize:1 Lat:1 SizeLat:1 for: %V64i32 = trunc <64 x i32> undef to <64 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i32 = trunc <80 x i32> undef to <80 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:198 CodeSize:1 Lat:1 SizeLat:1 for: %V96i32 = trunc <96 x i32> undef to <96 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i32 = trunc <112 x i32> undef to <112 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:52 CodeSize:1 Lat:1 SizeLat:1 for: %V128i32 = trunc <128 x i32> undef to <128 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i32 = trunc <160 x i32> undef to <160 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i32 = trunc <192 x i32> undef to <192 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i32 = trunc <224 x i32> undef to <224 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:104 CodeSize:1 Lat:1 SizeLat:1 for: %V256i32 = trunc <256 x i32> undef to <256 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i32 = trunc <320 x i32> undef to <320 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i32 = trunc <384 x i32> undef to <384 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i32 = trunc <448 x i32> undef to <448 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:208 CodeSize:1 Lat:1 SizeLat:1 for: %V512i32 = trunc <512 x i32> undef to <512 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i32 = trunc <640 x i32> undef to <640 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i32 = trunc <768 x i32> undef to <768 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i32 = trunc <896 x i32> undef to <896 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:416 CodeSize:1 Lat:1 SizeLat:1 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i8
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i16 = trunc <2 x i16> undef to <2 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i16 = trunc <4 x i16> undef to <4 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i16 = trunc <6 x i16> undef to <6 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i16 = trunc <8 x i16> undef to <8 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i16 = trunc <10 x i16> undef to <10 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i16 = trunc <12 x i16> undef to <12 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i16 = trunc <14 x i16> undef to <14 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16i16 = trunc <16 x i16> undef to <16 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i16 = trunc <20 x i16> undef to <20 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i16 = trunc <24 x i16> undef to <24 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i16 = trunc <28 x i16> undef to <28 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V32i16 = trunc <32 x i16> undef to <32 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i16 = trunc <40 x i16> undef to <40 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i16 = trunc <48 x i16> undef to <48 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i16 = trunc <56 x i16> undef to <56 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %V64i16 = trunc <64 x i16> undef to <64 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i16 = trunc <80 x i16> undef to <80 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:198 CodeSize:1 Lat:1 SizeLat:1 for: %V96i16 = trunc <96 x i16> undef to <96 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i16 = trunc <112 x i16> undef to <112 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:1 Lat:1 SizeLat:1 for: %V128i16 = trunc <128 x i16> undef to <128 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i16 = trunc <160 x i16> undef to <160 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i16 = trunc <192 x i16> undef to <192 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i16 = trunc <224 x i16> undef to <224 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %V256i16 = trunc <256 x i16> undef to <256 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i16 = trunc <320 x i16> undef to <320 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i16 = trunc <384 x i16> undef to <384 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i16 = trunc <448 x i16> undef to <448 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:1 Lat:1 SizeLat:1 for: %V512i16 = trunc <512 x i16> undef to <512 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i16 = trunc <640 x i16> undef to <640 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i16 = trunc <768 x i16> undef to <768 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i16 = trunc <896 x i16> undef to <896 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:160 CodeSize:1 Lat:1 SizeLat:1 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %i64 = trunc i64 undef to i8
  %V2i64 = trunc <2 x i64> undef to <2 x i8>
  %V4i64 = trunc <4 x i64> undef to <4 x i8>
  %V6i64 = trunc <6 x i64> undef to <6 x i8>
  %V8i64 = trunc <8 x i64> undef to <8 x i8>
  %V10i64 = trunc <10 x i64> undef to <10 x i8>
  %V12i64 = trunc <12 x i64> undef to <12 x i8>
  %V14i64 = trunc <14 x i64> undef to <14 x i8>
  %V16i64 = trunc <16 x i64> undef to <16 x i8>
  %V20i64 = trunc <20 x i64> undef to <20 x i8>
  %V24i64 = trunc <24 x i64> undef to <24 x i8>
  %V28i64 = trunc <28 x i64> undef to <28 x i8>
  %V32i64 = trunc <32 x i64> undef to <32 x i8>
  %V40i64 = trunc <40 x i64> undef to <40 x i8>
  %V48i64 = trunc <48 x i64> undef to <48 x i8>
  %V56i64 = trunc <56 x i64> undef to <56 x i8>
  %V64i64 = trunc <64 x i64> undef to <64 x i8>
  %V80i64 = trunc <80 x i64> undef to <80 x i8>
  %V96i64 = trunc <96 x i64> undef to <96 x i8>
  %V112i64 = trunc <112 x i64> undef to <112 x i8>
  %V128i64 = trunc <128 x i64> undef to <128 x i8>
  %V160i64 = trunc <160 x i64> undef to <160 x i8>
  %V192i64 = trunc <192 x i64> undef to <192 x i8>
  %V224i64 = trunc <224 x i64> undef to <224 x i8>
  %V256i64 = trunc <256 x i64> undef to <256 x i8>
  %V320i64 = trunc <320 x i64> undef to <320 x i8>
  %V384i64 = trunc <384 x i64> undef to <384 x i8>
  %V448i64 = trunc <448 x i64> undef to <448 x i8>
  %V512i64 = trunc <512 x i64> undef to <512 x i8>
  %V640i64 = trunc <640 x i64> undef to <640 x i8>
  %V768i64 = trunc <768 x i64> undef to <768 x i8>
  %V896i64 = trunc <896 x i64> undef to <896 x i8>
  %V1024i64 = trunc <1024 x i64> undef to <1024 x i8>

  %i32 = trunc i32 undef to i8
  %V2i32 = trunc <2 x i32> undef to <2 x i8>
  %V4i32 = trunc <4 x i32> undef to <4 x i8>
  %V6i32 = trunc <6 x i32> undef to <6 x i8>
  %V8i32 = trunc <8 x i32> undef to <8 x i8>
  %V10i32 = trunc <10 x i32> undef to <10 x i8>
  %V12i32 = trunc <12 x i32> undef to <12 x i8>
  %V14i32 = trunc <14 x i32> undef to <14 x i8>
  %V16i32 = trunc <16 x i32> undef to <16 x i8>
  %V20i32 = trunc <20 x i32> undef to <20 x i8>
  %V24i32 = trunc <24 x i32> undef to <24 x i8>
  %V28i32 = trunc <28 x i32> undef to <28 x i8>
  %V32i32 = trunc <32 x i32> undef to <32 x i8>
  %V40i32 = trunc <40 x i32> undef to <40 x i8>
  %V48i32 = trunc <48 x i32> undef to <48 x i8>
  %V56i32 = trunc <56 x i32> undef to <56 x i8>
  %V64i32 = trunc <64 x i32> undef to <64 x i8>
  %V80i32 = trunc <80 x i32> undef to <80 x i8>
  %V96i32 = trunc <96 x i32> undef to <96 x i8>
  %V112i32 = trunc <112 x i32> undef to <112 x i8>
  %V128i32 = trunc <128 x i32> undef to <128 x i8>
  %V160i32 = trunc <160 x i32> undef to <160 x i8>
  %V192i32 = trunc <192 x i32> undef to <192 x i8>
  %V224i32 = trunc <224 x i32> undef to <224 x i8>
  %V256i32 = trunc <256 x i32> undef to <256 x i8>
  %V320i32 = trunc <320 x i32> undef to <320 x i8>
  %V384i32 = trunc <384 x i32> undef to <384 x i8>
  %V448i32 = trunc <448 x i32> undef to <448 x i8>
  %V512i32 = trunc <512 x i32> undef to <512 x i8>
  %V640i32 = trunc <640 x i32> undef to <640 x i8>
  %V768i32 = trunc <768 x i32> undef to <768 x i8>
  %V896i32 = trunc <896 x i32> undef to <896 x i8>
  %V1024i32 = trunc <1024 x i32> undef to <1024 x i8>

  %i16 = trunc i16 undef to i8
  %V2i16 = trunc <2 x i16> undef to <2 x i8>
  %V4i16 = trunc <4 x i16> undef to <4 x i8>
  %V6i16 = trunc <6 x i16> undef to <6 x i8>
  %V8i16 = trunc <8 x i16> undef to <8 x i8>
  %V10i16 = trunc <10 x i16> undef to <10 x i8>
  %V12i16 = trunc <12 x i16> undef to <12 x i8>
  %V14i16 = trunc <14 x i16> undef to <14 x i8>
  %V16i16 = trunc <16 x i16> undef to <16 x i8>
  %V20i16 = trunc <20 x i16> undef to <20 x i8>
  %V24i16 = trunc <24 x i16> undef to <24 x i8>
  %V28i16 = trunc <28 x i16> undef to <28 x i8>
  %V32i16 = trunc <32 x i16> undef to <32 x i8>
  %V40i16 = trunc <40 x i16> undef to <40 x i8>
  %V48i16 = trunc <48 x i16> undef to <48 x i8>
  %V56i16 = trunc <56 x i16> undef to <56 x i8>
  %V64i16 = trunc <64 x i16> undef to <64 x i8>
  %V80i16 = trunc <80 x i16> undef to <80 x i8>
  %V96i16 = trunc <96 x i16> undef to <96 x i8>
  %V112i16 = trunc <112 x i16> undef to <112 x i8>
  %V128i16 = trunc <128 x i16> undef to <128 x i8>
  %V160i16 = trunc <160 x i16> undef to <160 x i8>
  %V192i16 = trunc <192 x i16> undef to <192 x i8>
  %V224i16 = trunc <224 x i16> undef to <224 x i8>
  %V256i16 = trunc <256 x i16> undef to <256 x i8>
  %V320i16 = trunc <320 x i16> undef to <320 x i8>
  %V384i16 = trunc <384 x i16> undef to <384 x i8>
  %V448i16 = trunc <448 x i16> undef to <448 x i8>
  %V512i16 = trunc <512 x i16> undef to <512 x i8>
  %V640i16 = trunc <640 x i16> undef to <640 x i8>
  %V768i16 = trunc <768 x i16> undef to <768 x i8>
  %V896i16 = trunc <896 x i16> undef to <896 x i8>
  %V1024i16 = trunc <1024 x i16> undef to <1024 x i8>

  ret i32 undef
}

define i32 @trunc_vXi1() "min-legal-vector-width"="256" {
; SSE2-LABEL: 'trunc_vXi1'
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i1
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 2 for: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:8 Lat:8 SizeLat:8 for: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:8 Lat:8 SizeLat:8 for: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:8 Lat:8 SizeLat:8 for: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:8 Lat:8 SizeLat:8 for: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:16 Lat:16 SizeLat:16 for: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:16 Lat:16 SizeLat:16 for: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:16 Lat:16 SizeLat:16 for: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:16 Lat:16 SizeLat:16 for: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:32 Lat:32 SizeLat:32 for: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:32 Lat:32 SizeLat:32 for: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:32 Lat:32 SizeLat:32 for: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:32 Lat:32 SizeLat:32 for: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:64 Lat:64 SizeLat:64 for: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:64 Lat:64 SizeLat:64 for: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:64 Lat:64 SizeLat:64 for: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:128 Lat:128 SizeLat:128 for: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:128 Lat:128 SizeLat:128 for: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:128 Lat:128 SizeLat:128 for: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:128 Lat:128 SizeLat:128 for: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:256 Lat:256 SizeLat:256 for: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:256 Lat:256 SizeLat:256 for: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:256 Lat:256 SizeLat:256 for: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:256 Lat:256 SizeLat:256 for: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:2048 CodeSize:512 Lat:512 SizeLat:512 for: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:2048 CodeSize:512 Lat:512 SizeLat:512 for: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:2048 CodeSize:512 Lat:512 SizeLat:512 for: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:2048 CodeSize:512 Lat:512 SizeLat:512 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i1
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:32 Lat:32 SizeLat:32 for: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:32 Lat:32 SizeLat:32 for: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:32 Lat:32 SizeLat:32 for: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:256 Lat:256 SizeLat:256 for: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:256 Lat:256 SizeLat:256 for: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:256 Lat:256 SizeLat:256 for: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:256 Lat:256 SizeLat:256 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i1
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %i8 = trunc i8 undef to i1
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 1 for: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; SSE2-NEXT:  Cost Model: Found costs of 0 for: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'trunc_vXi1'
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i1
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 2 for: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:8 Lat:8 SizeLat:8 for: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:8 Lat:8 SizeLat:8 for: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:8 Lat:8 SizeLat:8 for: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:8 Lat:8 SizeLat:8 for: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:16 Lat:16 SizeLat:16 for: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:16 Lat:16 SizeLat:16 for: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:16 Lat:16 SizeLat:16 for: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:16 Lat:16 SizeLat:16 for: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:32 Lat:32 SizeLat:32 for: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:32 Lat:32 SizeLat:32 for: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:32 Lat:32 SizeLat:32 for: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:32 Lat:32 SizeLat:32 for: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:64 Lat:64 SizeLat:64 for: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:64 Lat:64 SizeLat:64 for: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:64 Lat:64 SizeLat:64 for: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:128 Lat:128 SizeLat:128 for: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:128 Lat:128 SizeLat:128 for: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:128 Lat:128 SizeLat:128 for: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:128 Lat:128 SizeLat:128 for: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:256 Lat:256 SizeLat:256 for: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:256 Lat:256 SizeLat:256 for: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:256 Lat:256 SizeLat:256 for: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:256 Lat:256 SizeLat:256 for: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2048 CodeSize:512 Lat:512 SizeLat:512 for: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2048 CodeSize:512 Lat:512 SizeLat:512 for: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2048 CodeSize:512 Lat:512 SizeLat:512 for: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2048 CodeSize:512 Lat:512 SizeLat:512 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i1
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:4 Lat:4 SizeLat:4 for: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:8 Lat:8 SizeLat:8 for: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:16 Lat:16 SizeLat:16 for: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:32 Lat:32 SizeLat:32 for: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:32 Lat:32 SizeLat:32 for: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:32 Lat:32 SizeLat:32 for: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:192 CodeSize:64 Lat:64 SizeLat:64 for: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:128 Lat:128 SizeLat:128 for: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:256 Lat:256 SizeLat:256 for: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:256 Lat:256 SizeLat:256 for: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:256 Lat:256 SizeLat:256 for: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:256 Lat:256 SizeLat:256 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i1
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %i8 = trunc i8 undef to i1
; SSSE3-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 1 for: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of 0 for: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'trunc_vXi1'
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i1
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 2 for: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:512 Lat:512 SizeLat:512 for: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:512 Lat:512 SizeLat:512 for: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:512 Lat:512 SizeLat:512 for: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:1024 CodeSize:512 Lat:512 SizeLat:512 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i1
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i1
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %i8 = trunc i8 undef to i1
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 1 for: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; SSE42-NEXT:  Cost Model: Found costs of 0 for: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'trunc_vXi1'
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i1
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:1 Lat:1 SizeLat:1 for: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i1
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i1
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %i8 = trunc i8 undef to i1
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 1 for: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; AVX1-NEXT:  Cost Model: Found costs of 0 for: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'trunc_vXi1'
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i1
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:1 Lat:1 SizeLat:1 for: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:4 Lat:4 SizeLat:4 for: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i1
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:2 Lat:2 SizeLat:2 for: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i1
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %i8 = trunc i8 undef to i1
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 1 for: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; AVX2-NEXT:  Cost Model: Found costs of 0 for: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512FVEC512-LABEL: 'trunc_vXi1'
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i1
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:1 Lat:1 SizeLat:1 for: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:1 Lat:1 SizeLat:1 for: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:1 Lat:1 SizeLat:1 for: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:1 Lat:1 SizeLat:1 for: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:1 Lat:1 SizeLat:1 for: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:1 Lat:1 SizeLat:1 for: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:1 Lat:1 SizeLat:1 for: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:112 CodeSize:1 Lat:1 SizeLat:1 for: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:160 CodeSize:1 Lat:1 SizeLat:1 for: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:224 CodeSize:1 Lat:1 SizeLat:1 for: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:320 CodeSize:1 Lat:1 SizeLat:1 for: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:1 Lat:1 SizeLat:1 for: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:448 CodeSize:1 Lat:1 SizeLat:1 for: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:640 CodeSize:1 Lat:1 SizeLat:1 for: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:1 Lat:1 SizeLat:1 for: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:896 CodeSize:1 Lat:1 SizeLat:1 for: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:1280 CodeSize:1 Lat:1 SizeLat:1 for: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:1536 CodeSize:1 Lat:1 SizeLat:1 for: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:1792 CodeSize:1 Lat:1 SizeLat:1 for: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i1
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i1
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:1 Lat:1 SizeLat:1 for: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:1 Lat:1 SizeLat:1 for: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:1 Lat:1 SizeLat:1 for: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:1 Lat:1 SizeLat:1 for: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:112 CodeSize:1 Lat:1 SizeLat:1 for: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:160 CodeSize:1 Lat:1 SizeLat:1 for: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:224 CodeSize:1 Lat:1 SizeLat:1 for: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:320 CodeSize:1 Lat:1 SizeLat:1 for: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:1 Lat:1 SizeLat:1 for: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:448 CodeSize:1 Lat:1 SizeLat:1 for: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:640 CodeSize:1 Lat:1 SizeLat:1 for: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:1 Lat:1 SizeLat:1 for: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:896 CodeSize:1 Lat:1 SizeLat:1 for: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:1280 CodeSize:1 Lat:1 SizeLat:1 for: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:1536 CodeSize:1 Lat:1 SizeLat:1 for: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:1792 CodeSize:1 Lat:1 SizeLat:1 for: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %i8 = trunc i8 undef to i1
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:1 Lat:1 SizeLat:1 for: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:1 Lat:1 SizeLat:1 for: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:1 Lat:1 SizeLat:1 for: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:1 Lat:1 SizeLat:1 for: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:112 CodeSize:1 Lat:1 SizeLat:1 for: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:160 CodeSize:1 Lat:1 SizeLat:1 for: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:224 CodeSize:1 Lat:1 SizeLat:1 for: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:320 CodeSize:1 Lat:1 SizeLat:1 for: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:1 Lat:1 SizeLat:1 for: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:448 CodeSize:1 Lat:1 SizeLat:1 for: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:640 CodeSize:1 Lat:1 SizeLat:1 for: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:1 Lat:1 SizeLat:1 for: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:896 CodeSize:1 Lat:1 SizeLat:1 for: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:1280 CodeSize:1 Lat:1 SizeLat:1 for: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:1536 CodeSize:1 Lat:1 SizeLat:1 for: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:1792 CodeSize:1 Lat:1 SizeLat:1 for: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of 0 for: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; AVX512FVEC512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512FVEC256-LABEL: 'trunc_vXi1'
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i1
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:1 Lat:1 SizeLat:1 for: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:1 Lat:1 SizeLat:1 for: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:1 Lat:1 SizeLat:1 for: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:1 Lat:1 SizeLat:1 for: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:1 Lat:1 SizeLat:1 for: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:1 Lat:1 SizeLat:1 for: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 0 for: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:1 Lat:1 SizeLat:1 for: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:1 Lat:1 SizeLat:1 for: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:112 CodeSize:1 Lat:1 SizeLat:1 for: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 0 for: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:160 CodeSize:1 Lat:1 SizeLat:1 for: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:224 CodeSize:1 Lat:1 SizeLat:1 for: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 0 for: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:320 CodeSize:1 Lat:1 SizeLat:1 for: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:1 Lat:1 SizeLat:1 for: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:448 CodeSize:1 Lat:1 SizeLat:1 for: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 0 for: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:640 CodeSize:1 Lat:1 SizeLat:1 for: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:1 Lat:1 SizeLat:1 for: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:896 CodeSize:1 Lat:1 SizeLat:1 for: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 0 for: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:1280 CodeSize:1 Lat:1 SizeLat:1 for: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:1536 CodeSize:1 Lat:1 SizeLat:1 for: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:1792 CodeSize:1 Lat:1 SizeLat:1 for: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 0 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i1
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i1
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:8 Lat:8 SizeLat:8 for: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:8 Lat:8 SizeLat:8 for: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:8 Lat:8 SizeLat:8 for: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:16 Lat:16 SizeLat:16 for: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:16 Lat:16 SizeLat:16 for: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:16 Lat:16 SizeLat:16 for: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:16 Lat:16 SizeLat:16 for: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:32 Lat:32 SizeLat:32 for: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:32 Lat:32 SizeLat:32 for: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:32 Lat:32 SizeLat:32 for: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:32 Lat:32 SizeLat:32 for: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:64 Lat:64 SizeLat:64 for: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:64 Lat:64 SizeLat:64 for: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:64 Lat:64 SizeLat:64 for: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:64 Lat:64 SizeLat:64 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 0 for: %i8 = trunc i8 undef to i1
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:1 Lat:1 SizeLat:1 for: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:1 Lat:1 SizeLat:1 for: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 0 for: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:1 Lat:1 SizeLat:1 for: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:1 Lat:1 SizeLat:1 for: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:112 CodeSize:1 Lat:1 SizeLat:1 for: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 0 for: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:160 CodeSize:1 Lat:1 SizeLat:1 for: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:224 CodeSize:1 Lat:1 SizeLat:1 for: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 0 for: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:320 CodeSize:1 Lat:1 SizeLat:1 for: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:1 Lat:1 SizeLat:1 for: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:448 CodeSize:1 Lat:1 SizeLat:1 for: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 0 for: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:640 CodeSize:1 Lat:1 SizeLat:1 for: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:1 Lat:1 SizeLat:1 for: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:896 CodeSize:1 Lat:1 SizeLat:1 for: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 0 for: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:1280 CodeSize:1 Lat:1 SizeLat:1 for: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:1536 CodeSize:1 Lat:1 SizeLat:1 for: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:1792 CodeSize:1 Lat:1 SizeLat:1 for: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of 0 for: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; AVX512FVEC256-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQVEC512-LABEL: 'trunc_vXi1'
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i1
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i1
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i1
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:1 Lat:1 SizeLat:1 for: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:1 Lat:1 SizeLat:1 for: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 0 for: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:1 Lat:1 SizeLat:1 for: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:1 Lat:1 SizeLat:1 for: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:112 CodeSize:1 Lat:1 SizeLat:1 for: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 0 for: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:160 CodeSize:1 Lat:1 SizeLat:1 for: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:224 CodeSize:1 Lat:1 SizeLat:1 for: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 0 for: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:320 CodeSize:1 Lat:1 SizeLat:1 for: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:1 Lat:1 SizeLat:1 for: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:448 CodeSize:1 Lat:1 SizeLat:1 for: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 0 for: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:640 CodeSize:1 Lat:1 SizeLat:1 for: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:1 Lat:1 SizeLat:1 for: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:896 CodeSize:1 Lat:1 SizeLat:1 for: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 0 for: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:1280 CodeSize:1 Lat:1 SizeLat:1 for: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:1536 CodeSize:1 Lat:1 SizeLat:1 for: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:1792 CodeSize:1 Lat:1 SizeLat:1 for: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 0 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 0 for: %i8 = trunc i8 undef to i1
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:1 Lat:1 SizeLat:1 for: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:1 Lat:1 SizeLat:1 for: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 0 for: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:1 Lat:1 SizeLat:1 for: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:1 Lat:1 SizeLat:1 for: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:112 CodeSize:1 Lat:1 SizeLat:1 for: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 0 for: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:160 CodeSize:1 Lat:1 SizeLat:1 for: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:224 CodeSize:1 Lat:1 SizeLat:1 for: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 0 for: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:320 CodeSize:1 Lat:1 SizeLat:1 for: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:1 Lat:1 SizeLat:1 for: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:448 CodeSize:1 Lat:1 SizeLat:1 for: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 0 for: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:640 CodeSize:1 Lat:1 SizeLat:1 for: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:1 Lat:1 SizeLat:1 for: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:896 CodeSize:1 Lat:1 SizeLat:1 for: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 0 for: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:1280 CodeSize:1 Lat:1 SizeLat:1 for: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:1536 CodeSize:1 Lat:1 SizeLat:1 for: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:1792 CodeSize:1 Lat:1 SizeLat:1 for: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of 0 for: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; AVX512DQVEC512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQVEC256-LABEL: 'trunc_vXi1'
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i1
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:1 Lat:1 SizeLat:1 for: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:256 Lat:256 SizeLat:256 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i1
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:128 Lat:128 SizeLat:128 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i1
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:2 Lat:2 SizeLat:2 for: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:4 Lat:4 SizeLat:4 for: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:8 Lat:8 SizeLat:8 for: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:8 Lat:8 SizeLat:8 for: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:8 Lat:8 SizeLat:8 for: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:16 Lat:16 SizeLat:16 for: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:16 Lat:16 SizeLat:16 for: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:16 Lat:16 SizeLat:16 for: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:16 Lat:16 SizeLat:16 for: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:32 Lat:32 SizeLat:32 for: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:32 Lat:32 SizeLat:32 for: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:32 Lat:32 SizeLat:32 for: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:256 CodeSize:32 Lat:32 SizeLat:32 for: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:64 Lat:64 SizeLat:64 for: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:64 Lat:64 SizeLat:64 for: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:64 Lat:64 SizeLat:64 for: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:512 CodeSize:64 Lat:64 SizeLat:64 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 0 for: %i8 = trunc i8 undef to i1
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:1 Lat:1 SizeLat:1 for: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:1 Lat:1 SizeLat:1 for: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:1 Lat:1 SizeLat:1 for: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:1 Lat:1 SizeLat:1 for: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:1 Lat:1 SizeLat:1 for: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 0 for: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:1 Lat:1 SizeLat:1 for: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:1 Lat:1 SizeLat:1 for: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:112 CodeSize:1 Lat:1 SizeLat:1 for: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 0 for: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:160 CodeSize:1 Lat:1 SizeLat:1 for: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:224 CodeSize:1 Lat:1 SizeLat:1 for: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 0 for: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:320 CodeSize:1 Lat:1 SizeLat:1 for: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:1 Lat:1 SizeLat:1 for: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:448 CodeSize:1 Lat:1 SizeLat:1 for: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 0 for: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:640 CodeSize:1 Lat:1 SizeLat:1 for: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:1 Lat:1 SizeLat:1 for: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:896 CodeSize:1 Lat:1 SizeLat:1 for: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 0 for: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:1280 CodeSize:1 Lat:1 SizeLat:1 for: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:1536 CodeSize:1 Lat:1 SizeLat:1 for: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:1792 CodeSize:1 Lat:1 SizeLat:1 for: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of 0 for: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; AVX512DQVEC256-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BWVEC512-LABEL: 'trunc_vXi1'
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i1
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:1 Lat:1 SizeLat:1 for: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:1 Lat:1 SizeLat:1 for: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:1 Lat:1 SizeLat:1 for: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:1 Lat:1 SizeLat:1 for: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:1 Lat:1 SizeLat:1 for: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 0 for: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:1 Lat:1 SizeLat:1 for: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:1 Lat:1 SizeLat:1 for: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:112 CodeSize:1 Lat:1 SizeLat:1 for: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 0 for: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:160 CodeSize:1 Lat:1 SizeLat:1 for: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:224 CodeSize:1 Lat:1 SizeLat:1 for: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 0 for: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:320 CodeSize:1 Lat:1 SizeLat:1 for: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:1 Lat:1 SizeLat:1 for: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:448 CodeSize:1 Lat:1 SizeLat:1 for: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 0 for: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:640 CodeSize:1 Lat:1 SizeLat:1 for: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:1 Lat:1 SizeLat:1 for: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:896 CodeSize:1 Lat:1 SizeLat:1 for: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 0 for: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:1280 CodeSize:1 Lat:1 SizeLat:1 for: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:1536 CodeSize:1 Lat:1 SizeLat:1 for: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:1792 CodeSize:1 Lat:1 SizeLat:1 for: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 0 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i1
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:1 Lat:1 SizeLat:1 for: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:1 Lat:1 SizeLat:1 for: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 0 for: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:1 Lat:1 SizeLat:1 for: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:1 Lat:1 SizeLat:1 for: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:112 CodeSize:1 Lat:1 SizeLat:1 for: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 0 for: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:160 CodeSize:1 Lat:1 SizeLat:1 for: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:224 CodeSize:1 Lat:1 SizeLat:1 for: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 0 for: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:320 CodeSize:1 Lat:1 SizeLat:1 for: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:1 Lat:1 SizeLat:1 for: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:448 CodeSize:1 Lat:1 SizeLat:1 for: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 0 for: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:640 CodeSize:1 Lat:1 SizeLat:1 for: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:1 Lat:1 SizeLat:1 for: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:896 CodeSize:1 Lat:1 SizeLat:1 for: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 0 for: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:1280 CodeSize:1 Lat:1 SizeLat:1 for: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:1536 CodeSize:1 Lat:1 SizeLat:1 for: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:1792 CodeSize:1 Lat:1 SizeLat:1 for: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 0 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i1
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of 0 for: %i8 = trunc i8 undef to i1
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; AVX512BWVEC512-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BWVEC256-LABEL: 'trunc_vXi1'
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i1
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:1 Lat:1 SizeLat:1 for: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:1 Lat:1 SizeLat:1 for: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:1 Lat:1 SizeLat:1 for: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:1 Lat:1 SizeLat:1 for: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:1 Lat:1 SizeLat:1 for: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:1 Lat:1 SizeLat:1 for: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:1 Lat:1 SizeLat:1 for: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:1 Lat:1 SizeLat:1 for: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:1 Lat:1 SizeLat:1 for: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 0 for: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:1 Lat:1 SizeLat:1 for: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:1 Lat:1 SizeLat:1 for: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:112 CodeSize:1 Lat:1 SizeLat:1 for: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 0 for: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:160 CodeSize:1 Lat:1 SizeLat:1 for: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:224 CodeSize:1 Lat:1 SizeLat:1 for: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 0 for: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:320 CodeSize:1 Lat:1 SizeLat:1 for: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:1 Lat:1 SizeLat:1 for: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:448 CodeSize:1 Lat:1 SizeLat:1 for: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 0 for: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:640 CodeSize:1 Lat:1 SizeLat:1 for: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:1 Lat:1 SizeLat:1 for: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:896 CodeSize:1 Lat:1 SizeLat:1 for: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 0 for: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:1280 CodeSize:1 Lat:1 SizeLat:1 for: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:1536 CodeSize:1 Lat:1 SizeLat:1 for: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:1792 CodeSize:1 Lat:1 SizeLat:1 for: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 0 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i1
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:40 CodeSize:1 Lat:1 SizeLat:1 for: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:48 CodeSize:1 Lat:1 SizeLat:1 for: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:56 CodeSize:1 Lat:1 SizeLat:1 for: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 0 for: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:80 CodeSize:1 Lat:1 SizeLat:1 for: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:96 CodeSize:1 Lat:1 SizeLat:1 for: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:112 CodeSize:1 Lat:1 SizeLat:1 for: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 0 for: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:160 CodeSize:1 Lat:1 SizeLat:1 for: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:224 CodeSize:1 Lat:1 SizeLat:1 for: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 0 for: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:320 CodeSize:1 Lat:1 SizeLat:1 for: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:384 CodeSize:1 Lat:1 SizeLat:1 for: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:448 CodeSize:1 Lat:1 SizeLat:1 for: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 0 for: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:640 CodeSize:1 Lat:1 SizeLat:1 for: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:768 CodeSize:1 Lat:1 SizeLat:1 for: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:896 CodeSize:1 Lat:1 SizeLat:1 for: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 0 for: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:1280 CodeSize:1 Lat:1 SizeLat:1 for: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:1536 CodeSize:1 Lat:1 SizeLat:1 for: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:1792 CodeSize:1 Lat:1 SizeLat:1 for: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 0 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i1
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:128 CodeSize:64 Lat:64 SizeLat:64 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of 0 for: %i8 = trunc i8 undef to i1
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:2 Lat:2 SizeLat:2 for: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:4 Lat:4 SizeLat:4 for: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:8 Lat:8 SizeLat:8 for: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:32 CodeSize:16 Lat:16 SizeLat:16 for: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:64 CodeSize:32 Lat:32 SizeLat:32 for: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; AVX512BWVEC256-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; BTVER2-LABEL: 'trunc_vXi1'
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %i64 = trunc i64 undef to i1
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V2i64 = trunc <2 x i64> undef to <2 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V3i64 = trunc <3 x i64> undef to <3 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V4i64 = trunc <4 x i64> undef to <4 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V5i64 = trunc <5 x i64> undef to <5 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V6i64 = trunc <6 x i64> undef to <6 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:2 Lat:2 SizeLat:2 for: %V7i64 = trunc <7 x i64> undef to <7 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:9 CodeSize:1 Lat:1 SizeLat:1 for: %V8i64 = trunc <8 x i64> undef to <8 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %V10i64 = trunc <10 x i64> undef to <10 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %V12i64 = trunc <12 x i64> undef to <12 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:20 CodeSize:4 Lat:4 SizeLat:4 for: %V14i64 = trunc <14 x i64> undef to <14 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:1 Lat:1 SizeLat:1 for: %V16i64 = trunc <16 x i64> undef to <16 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i64 = trunc <20 x i64> undef to <20 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i64 = trunc <24 x i64> undef to <24 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i64 = trunc <28 x i64> undef to <28 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V32i64 = trunc <32 x i64> undef to <32 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i64 = trunc <40 x i64> undef to <40 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i64 = trunc <48 x i64> undef to <48 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i64 = trunc <56 x i64> undef to <56 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V64i64 = trunc <64 x i64> undef to <64 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i64 = trunc <80 x i64> undef to <80 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i64 = trunc <112 x i64> undef to <112 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V128i64 = trunc <128 x i64> undef to <128 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i64 = trunc <160 x i64> undef to <160 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i64 = trunc <192 x i64> undef to <192 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i64 = trunc <224 x i64> undef to <224 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V256i64 = trunc <256 x i64> undef to <256 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i64 = trunc <320 x i64> undef to <320 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i64 = trunc <384 x i64> undef to <384 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i64 = trunc <448 x i64> undef to <448 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V512i64 = trunc <512 x i64> undef to <512 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i64 = trunc <640 x i64> undef to <640 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i64 = trunc <768 x i64> undef to <768 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i64 = trunc <896 x i64> undef to <896 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %i32 = trunc i32 undef to i1
; BTVER2-NEXT:  Cost Model: Found costs of 1 for: %V2i32 = trunc <2 x i32> undef to <2 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V3i32 = trunc <3 x i32> undef to <3 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V4i32 = trunc <4 x i32> undef to <4 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V5i32 = trunc <5 x i32> undef to <5 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V6i32 = trunc <6 x i32> undef to <6 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V7i32 = trunc <7 x i32> undef to <7 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:5 CodeSize:1 Lat:1 SizeLat:1 for: %V8i32 = trunc <8 x i32> undef to <8 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V10i32 = trunc <10 x i32> undef to <10 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V12i32 = trunc <12 x i32> undef to <12 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V14i32 = trunc <14 x i32> undef to <14 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:10 CodeSize:2 Lat:2 SizeLat:2 for: %V16i32 = trunc <16 x i32> undef to <16 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i32 = trunc <20 x i32> undef to <20 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i32 = trunc <24 x i32> undef to <24 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i32 = trunc <28 x i32> undef to <28 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V32i32 = trunc <32 x i32> undef to <32 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i32 = trunc <40 x i32> undef to <40 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i32 = trunc <48 x i32> undef to <48 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i32 = trunc <56 x i32> undef to <56 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V64i32 = trunc <64 x i32> undef to <64 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i32 = trunc <80 x i32> undef to <80 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i32 = trunc <112 x i32> undef to <112 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V128i32 = trunc <128 x i32> undef to <128 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i32 = trunc <160 x i32> undef to <160 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i32 = trunc <192 x i32> undef to <192 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i32 = trunc <224 x i32> undef to <224 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V256i32 = trunc <256 x i32> undef to <256 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i32 = trunc <320 x i32> undef to <320 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i32 = trunc <384 x i32> undef to <384 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i32 = trunc <448 x i32> undef to <448 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V512i32 = trunc <512 x i32> undef to <512 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i32 = trunc <640 x i32> undef to <640 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i32 = trunc <768 x i32> undef to <768 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i32 = trunc <896 x i32> undef to <896 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %i16 = trunc i16 undef to i1
; BTVER2-NEXT:  Cost Model: Found costs of 1 for: %V2i16 = trunc <2 x i16> undef to <2 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V3i16 = trunc <3 x i16> undef to <3 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 1 for: %V4i16 = trunc <4 x i16> undef to <4 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V5i16 = trunc <5 x i16> undef to <5 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V6i16 = trunc <6 x i16> undef to <6 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V7i16 = trunc <7 x i16> undef to <7 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V8i16 = trunc <8 x i16> undef to <8 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V10i16 = trunc <10 x i16> undef to <10 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V12i16 = trunc <12 x i16> undef to <12 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %V14i16 = trunc <14 x i16> undef to <14 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:1 Lat:1 SizeLat:1 for: %V16i16 = trunc <16 x i16> undef to <16 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:43 CodeSize:1 Lat:1 SizeLat:1 for: %V20i16 = trunc <20 x i16> undef to <20 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:51 CodeSize:1 Lat:1 SizeLat:1 for: %V24i16 = trunc <24 x i16> undef to <24 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:59 CodeSize:1 Lat:1 SizeLat:1 for: %V28i16 = trunc <28 x i16> undef to <28 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V32i16 = trunc <32 x i16> undef to <32 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:83 CodeSize:1 Lat:1 SizeLat:1 for: %V40i16 = trunc <40 x i16> undef to <40 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:99 CodeSize:1 Lat:1 SizeLat:1 for: %V48i16 = trunc <48 x i16> undef to <48 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:117 CodeSize:1 Lat:1 SizeLat:1 for: %V56i16 = trunc <56 x i16> undef to <56 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V64i16 = trunc <64 x i16> undef to <64 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:165 CodeSize:1 Lat:1 SizeLat:1 for: %V80i16 = trunc <80 x i16> undef to <80 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:231 CodeSize:1 Lat:1 SizeLat:1 for: %V112i16 = trunc <112 x i16> undef to <112 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V128i16 = trunc <128 x i16> undef to <128 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:330 CodeSize:1 Lat:1 SizeLat:1 for: %V160i16 = trunc <160 x i16> undef to <160 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:396 CodeSize:1 Lat:1 SizeLat:1 for: %V192i16 = trunc <192 x i16> undef to <192 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:462 CodeSize:1 Lat:1 SizeLat:1 for: %V224i16 = trunc <224 x i16> undef to <224 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V256i16 = trunc <256 x i16> undef to <256 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:660 CodeSize:1 Lat:1 SizeLat:1 for: %V320i16 = trunc <320 x i16> undef to <320 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:792 CodeSize:1 Lat:1 SizeLat:1 for: %V384i16 = trunc <384 x i16> undef to <384 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:924 CodeSize:1 Lat:1 SizeLat:1 for: %V448i16 = trunc <448 x i16> undef to <448 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V512i16 = trunc <512 x i16> undef to <512 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1320 CodeSize:1 Lat:1 SizeLat:1 for: %V640i16 = trunc <640 x i16> undef to <640 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1584 CodeSize:1 Lat:1 SizeLat:1 for: %V768i16 = trunc <768 x i16> undef to <768 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1848 CodeSize:1 Lat:1 SizeLat:1 for: %V896i16 = trunc <896 x i16> undef to <896 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %i8 = trunc i8 undef to i1
; BTVER2-NEXT:  Cost Model: Found costs of 1 for: %V2i8 = trunc <2 x i8> undef to <2 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V3i8 = trunc <3 x i8> undef to <3 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 1 for: %V4i8 = trunc <4 x i8> undef to <4 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V5i8 = trunc <5 x i8> undef to <5 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V6i8 = trunc <6 x i8> undef to <6 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V7i8 = trunc <7 x i8> undef to <7 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 1 for: %V8i8 = trunc <8 x i8> undef to <8 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V10i8 = trunc <10 x i8> undef to <10 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V12i8 = trunc <12 x i8> undef to <12 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V14i8 = trunc <14 x i8> undef to <14 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V16i8 = trunc <16 x i8> undef to <16 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V20i8 = trunc <20 x i8> undef to <20 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V24i8 = trunc <24 x i8> undef to <24 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V28i8 = trunc <28 x i8> undef to <28 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V32i8 = trunc <32 x i8> undef to <32 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V40i8 = trunc <40 x i8> undef to <40 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V48i8 = trunc <48 x i8> undef to <48 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V56i8 = trunc <56 x i8> undef to <56 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V64i8 = trunc <64 x i8> undef to <64 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V80i8 = trunc <80 x i8> undef to <80 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V112i8 = trunc <112 x i8> undef to <112 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V128i8 = trunc <128 x i8> undef to <128 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V160i8 = trunc <160 x i8> undef to <160 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V192i8 = trunc <192 x i8> undef to <192 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V224i8 = trunc <224 x i8> undef to <224 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V256i8 = trunc <256 x i8> undef to <256 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V320i8 = trunc <320 x i8> undef to <320 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V384i8 = trunc <384 x i8> undef to <384 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V448i8 = trunc <448 x i8> undef to <448 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V512i8 = trunc <512 x i8> undef to <512 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V640i8 = trunc <640 x i8> undef to <640 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V768i8 = trunc <768 x i8> undef to <768 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V896i8 = trunc <896 x i8> undef to <896 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of 0 for: %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>
; BTVER2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %i64 = trunc i64 undef to i1
  %V2i64 = trunc <2 x i64> undef to <2 x i1>
  %V3i64 = trunc <3 x i64> undef to <3 x i1>
  %V4i64 = trunc <4 x i64> undef to <4 x i1>
  %V5i64 = trunc <5 x i64> undef to <5 x i1>
  %V6i64 = trunc <6 x i64> undef to <6 x i1>
  %V7i64 = trunc <7 x i64> undef to <7 x i1>
  %V8i64 = trunc <8 x i64> undef to <8 x i1>
  %V10i64 = trunc <10 x i64> undef to <10 x i1>
  %V12i64 = trunc <12 x i64> undef to <12 x i1>
  %V14i64 = trunc <14 x i64> undef to <14 x i1>
  %V16i64 = trunc <16 x i64> undef to <16 x i1>
  %V20i64 = trunc <20 x i64> undef to <20 x i1>
  %V24i64 = trunc <24 x i64> undef to <24 x i1>
  %V28i64 = trunc <28 x i64> undef to <28 x i1>
  %V32i64 = trunc <32 x i64> undef to <32 x i1>
  %V40i64 = trunc <40 x i64> undef to <40 x i1>
  %V48i64 = trunc <48 x i64> undef to <48 x i1>
  %V56i64 = trunc <56 x i64> undef to <56 x i1>
  %V64i64 = trunc <64 x i64> undef to <64 x i1>
  %V80i64 = trunc <80 x i64> undef to <80 x i1>
  %V112i64 = trunc <112 x i64> undef to <112 x i1>
  %V128i64 = trunc <128 x i64> undef to <128 x i1>
  %V160i64 = trunc <160 x i64> undef to <160 x i1>
  %V192i64 = trunc <192 x i64> undef to <192 x i1>
  %V224i64 = trunc <224 x i64> undef to <224 x i1>
  %V256i64 = trunc <256 x i64> undef to <256 x i1>
  %V320i64 = trunc <320 x i64> undef to <320 x i1>
  %V384i64 = trunc <384 x i64> undef to <384 x i1>
  %V448i64 = trunc <448 x i64> undef to <448 x i1>
  %V512i64 = trunc <512 x i64> undef to <512 x i1>
  %V640i64 = trunc <640 x i64> undef to <640 x i1>
  %V768i64 = trunc <768 x i64> undef to <768 x i1>
  %V896i64 = trunc <896 x i64> undef to <896 x i1>
  %V1024i64 = trunc <1024 x i64> undef to <1024 x i1>

  %i32 = trunc i32 undef to i1
  %V2i32 = trunc <2 x i32> undef to <2 x i1>
  %V3i32 = trunc <3 x i32> undef to <3 x i1>
  %V4i32 = trunc <4 x i32> undef to <4 x i1>
  %V5i32 = trunc <5 x i32> undef to <5 x i1>
  %V6i32 = trunc <6 x i32> undef to <6 x i1>
  %V7i32 = trunc <7 x i32> undef to <7 x i1>
  %V8i32 = trunc <8 x i32> undef to <8 x i1>
  %V10i32 = trunc <10 x i32> undef to <10 x i1>
  %V12i32 = trunc <12 x i32> undef to <12 x i1>
  %V14i32 = trunc <14 x i32> undef to <14 x i1>
  %V16i32 = trunc <16 x i32> undef to <16 x i1>
  %V20i32 = trunc <20 x i32> undef to <20 x i1>
  %V24i32 = trunc <24 x i32> undef to <24 x i1>
  %V28i32 = trunc <28 x i32> undef to <28 x i1>
  %V32i32 = trunc <32 x i32> undef to <32 x i1>
  %V40i32 = trunc <40 x i32> undef to <40 x i1>
  %V48i32 = trunc <48 x i32> undef to <48 x i1>
  %V56i32 = trunc <56 x i32> undef to <56 x i1>
  %V64i32 = trunc <64 x i32> undef to <64 x i1>
  %V80i32 = trunc <80 x i32> undef to <80 x i1>
  %V112i32 = trunc <112 x i32> undef to <112 x i1>
  %V128i32 = trunc <128 x i32> undef to <128 x i1>
  %V160i32 = trunc <160 x i32> undef to <160 x i1>
  %V192i32 = trunc <192 x i32> undef to <192 x i1>
  %V224i32 = trunc <224 x i32> undef to <224 x i1>
  %V256i32 = trunc <256 x i32> undef to <256 x i1>
  %V320i32 = trunc <320 x i32> undef to <320 x i1>
  %V384i32 = trunc <384 x i32> undef to <384 x i1>
  %V448i32 = trunc <448 x i32> undef to <448 x i1>
  %V512i32 = trunc <512 x i32> undef to <512 x i1>
  %V640i32 = trunc <640 x i32> undef to <640 x i1>
  %V768i32 = trunc <768 x i32> undef to <768 x i1>
  %V896i32 = trunc <896 x i32> undef to <896 x i1>
  %V1024i32 = trunc <1024 x i32> undef to <1024 x i1>

  %i16 = trunc i16 undef to i1
  %V2i16 = trunc <2 x i16> undef to <2 x i1>
  %V3i16 = trunc <3 x i16> undef to <3 x i1>
  %V4i16 = trunc <4 x i16> undef to <4 x i1>
  %V5i16 = trunc <5 x i16> undef to <5 x i1>
  %V6i16 = trunc <6 x i16> undef to <6 x i1>
  %V7i16 = trunc <7 x i16> undef to <7 x i1>
  %V8i16 = trunc <8 x i16> undef to <8 x i1>
  %V10i16 = trunc <10 x i16> undef to <10 x i1>
  %V12i16 = trunc <12 x i16> undef to <12 x i1>
  %V14i16 = trunc <14 x i16> undef to <14 x i1>
  %V16i16 = trunc <16 x i16> undef to <16 x i1>
  %V20i16 = trunc <20 x i16> undef to <20 x i1>
  %V24i16 = trunc <24 x i16> undef to <24 x i1>
  %V28i16 = trunc <28 x i16> undef to <28 x i1>
  %V32i16 = trunc <32 x i16> undef to <32 x i1>
  %V40i16 = trunc <40 x i16> undef to <40 x i1>
  %V48i16 = trunc <48 x i16> undef to <48 x i1>
  %V56i16 = trunc <56 x i16> undef to <56 x i1>
  %V64i16 = trunc <64 x i16> undef to <64 x i1>
  %V80i16 = trunc <80 x i16> undef to <80 x i1>
  %V112i16 = trunc <112 x i16> undef to <112 x i1>
  %V128i16 = trunc <128 x i16> undef to <128 x i1>
  %V160i16 = trunc <160 x i16> undef to <160 x i1>
  %V192i16 = trunc <192 x i16> undef to <192 x i1>
  %V224i16 = trunc <224 x i16> undef to <224 x i1>
  %V256i16 = trunc <256 x i16> undef to <256 x i1>
  %V320i16 = trunc <320 x i16> undef to <320 x i1>
  %V384i16 = trunc <384 x i16> undef to <384 x i1>
  %V448i16 = trunc <448 x i16> undef to <448 x i1>
  %V512i16 = trunc <512 x i16> undef to <512 x i1>
  %V640i16 = trunc <640 x i16> undef to <640 x i1>
  %V768i16 = trunc <768 x i16> undef to <768 x i1>
  %V896i16 = trunc <896 x i16> undef to <896 x i1>
  %V1024i16 = trunc <1024 x i16> undef to <1024 x i1>

  %i8 = trunc i8 undef to i1
  %V2i8 = trunc <2 x i8> undef to <2 x i1>
  %V3i8 = trunc <3 x i8> undef to <3 x i1>
  %V4i8 = trunc <4 x i8> undef to <4 x i1>
  %V5i8 = trunc <5 x i8> undef to <5 x i1>
  %V6i8 = trunc <6 x i8> undef to <6 x i1>
  %V7i8 = trunc <7 x i8> undef to <7 x i1>
  %V8i8 = trunc <8 x i8> undef to <8 x i1>
  %V10i8 = trunc <10 x i8> undef to <10 x i1>
  %V12i8 = trunc <12 x i8> undef to <12 x i1>
  %V14i8 = trunc <14 x i8> undef to <14 x i1>
  %V16i8 = trunc <16 x i8> undef to <16 x i1>
  %V20i8 = trunc <20 x i8> undef to <20 x i1>
  %V24i8 = trunc <24 x i8> undef to <24 x i1>
  %V28i8 = trunc <28 x i8> undef to <28 x i1>
  %V32i8 = trunc <32 x i8> undef to <32 x i1>
  %V40i8 = trunc <40 x i8> undef to <40 x i1>
  %V48i8 = trunc <48 x i8> undef to <48 x i1>
  %V56i8 = trunc <56 x i8> undef to <56 x i1>
  %V64i8 = trunc <64 x i8> undef to <64 x i1>
  %V80i8 = trunc <80 x i8> undef to <80 x i1>
  %V112i8 = trunc <112 x i8> undef to <112 x i1>
  %V128i8 = trunc <128 x i8> undef to <128 x i1>
  %V160i8 = trunc <160 x i8> undef to <160 x i1>
  %V192i8 = trunc <192 x i8> undef to <192 x i1>
  %V224i8 = trunc <224 x i8> undef to <224 x i1>
  %V256i8 = trunc <256 x i8> undef to <256 x i1>
  %V320i8 = trunc <320 x i8> undef to <320 x i1>
  %V384i8 = trunc <384 x i8> undef to <384 x i1>
  %V448i8 = trunc <448 x i8> undef to <448 x i1>
  %V512i8 = trunc <512 x i8> undef to <512 x i1>
  %V640i8 = trunc <640 x i8> undef to <640 x i1>
  %V768i8 = trunc <768 x i8> undef to <768 x i1>
  %V896i8 = trunc <896 x i8> undef to <896 x i1>
  %V1024i8 = trunc <1024 x i8> undef to <1024 x i1>

  ret i32 undef
}
