; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=atomic-expand %s | FileCheck %s

; Make sure atomic loads are not bitcasted and lose metadata

define float @load_atomic_f32_global_system(ptr addrspace(1) %ptr) {
; CHECK-LABEL: define float @load_atomic_f32_global_system(
; CHECK-SAME: ptr addrspace(1) [[PTR:%.*]]) {
; CHECK-NEXT:    [[TMP2:%.*]] = load atomic float, ptr addrspace(1) [[PTR]] seq_cst, align 4, !some.unknown.md [[META0:![0-9]+]]
; CHECK-NEXT:    ret float [[TMP2]]
;
  %ld = load atomic float, ptr addrspace(1) %ptr seq_cst, align 4, !some.unknown.md !0
  ret float %ld
}

define float @load_atomic_f32_global_agent(ptr addrspace(1) %ptr) {
; CHECK-LABEL: define float @load_atomic_f32_global_agent(
; CHECK-SAME: ptr addrspace(1) [[PTR:%.*]]) {
; CHECK-NEXT:    [[TMP2:%.*]] = load atomic float, ptr addrspace(1) [[PTR]] syncscope("agent") seq_cst, align 4, !some.unknown.md [[META0]]
; CHECK-NEXT:    ret float [[TMP2]]
;
  %ld = load atomic float, ptr addrspace(1) %ptr syncscope("agent") seq_cst, align 4, !some.unknown.md !0
  ret float %ld
}

define float @load_atomic_f32_local(ptr addrspace(3) %ptr) {
; CHECK-LABEL: define float @load_atomic_f32_local(
; CHECK-SAME: ptr addrspace(3) [[PTR:%.*]]) {
; CHECK-NEXT:    [[TMP2:%.*]] = load atomic float, ptr addrspace(3) [[PTR]] seq_cst, align 4, !some.unknown.md [[META0]]
; CHECK-NEXT:    ret float [[TMP2]]
;
  %ld = load atomic float, ptr addrspace(3) %ptr seq_cst, align 4, !some.unknown.md !0
  ret float %ld
}

define float @load_atomic_f32_flat_system(ptr %ptr) {
; CHECK-LABEL: define float @load_atomic_f32_flat_system(
; CHECK-SAME: ptr [[PTR:%.*]]) {
; CHECK-NEXT:    [[TMP2:%.*]] = load atomic float, ptr [[PTR]] seq_cst, align 4, !some.unknown.md [[META0]]
; CHECK-NEXT:    ret float [[TMP2]]
;
  %ld = load atomic float, ptr %ptr seq_cst, align 4, !some.unknown.md !0
  ret float %ld
}

define float @load_atomic_f32_flat_agent(ptr %ptr) {
; CHECK-LABEL: define float @load_atomic_f32_flat_agent(
; CHECK-SAME: ptr [[PTR:%.*]]) {
; CHECK-NEXT:    [[TMP2:%.*]] = load atomic float, ptr [[PTR]] syncscope("agent") seq_cst, align 4, !some.unknown.md [[META0]]
; CHECK-NEXT:    ret float [[TMP2]]
;
  %ld = load atomic float, ptr %ptr syncscope("agent") seq_cst, align 4, !some.unknown.md !0
  ret float %ld
}

define half @load_atomic_f16_global_system(ptr addrspace(1) %ptr) {
; CHECK-LABEL: define half @load_atomic_f16_global_system(
; CHECK-SAME: ptr addrspace(1) [[PTR:%.*]]) {
; CHECK-NEXT:    [[TMP2:%.*]] = load atomic half, ptr addrspace(1) [[PTR]] seq_cst, align 4, !some.unknown.md [[META0]]
; CHECK-NEXT:    ret half [[TMP2]]
;
  %ld = load atomic half, ptr addrspace(1) %ptr seq_cst, align 4, !some.unknown.md !0
  ret half %ld
}

define half @load_atomic_f16_global_agent(ptr addrspace(1) %ptr) {
; CHECK-LABEL: define half @load_atomic_f16_global_agent(
; CHECK-SAME: ptr addrspace(1) [[PTR:%.*]]) {
; CHECK-NEXT:    [[TMP2:%.*]] = load atomic half, ptr addrspace(1) [[PTR]] syncscope("agent") seq_cst, align 4, !some.unknown.md [[META0]]
; CHECK-NEXT:    ret half [[TMP2]]
;
  %ld = load atomic half, ptr addrspace(1) %ptr syncscope("agent") seq_cst, align 4, !some.unknown.md !0
  ret half %ld
}

define half @load_atomic_f16_local(ptr addrspace(3) %ptr) {
; CHECK-LABEL: define half @load_atomic_f16_local(
; CHECK-SAME: ptr addrspace(3) [[PTR:%.*]]) {
; CHECK-NEXT:    [[TMP2:%.*]] = load atomic half, ptr addrspace(3) [[PTR]] seq_cst, align 2, !some.unknown.md [[META0]]
; CHECK-NEXT:    ret half [[TMP2]]
;
  %ld = load atomic half, ptr addrspace(3) %ptr seq_cst, align 2, !some.unknown.md !0
  ret half %ld
}

define bfloat @load_atomic_bf16_global_system(ptr addrspace(1) %ptr) {
; CHECK-LABEL: define bfloat @load_atomic_bf16_global_system(
; CHECK-SAME: ptr addrspace(1) [[PTR:%.*]]) {
; CHECK-NEXT:    [[TMP2:%.*]] = load atomic bfloat, ptr addrspace(1) [[PTR]] seq_cst, align 2, !some.unknown.md [[META0]]
; CHECK-NEXT:    ret bfloat [[TMP2]]
;
  %ld = load atomic bfloat, ptr addrspace(1) %ptr seq_cst, align 2, !some.unknown.md !0
  ret bfloat %ld
}

define bfloat @load_atomic_bf16_global_agent(ptr addrspace(1) %ptr) {
; CHECK-LABEL: define bfloat @load_atomic_bf16_global_agent(
; CHECK-SAME: ptr addrspace(1) [[PTR:%.*]]) {
; CHECK-NEXT:    [[TMP2:%.*]] = load atomic bfloat, ptr addrspace(1) [[PTR]] syncscope("agent") seq_cst, align 2, !some.unknown.md [[META0]]
; CHECK-NEXT:    ret bfloat [[TMP2]]
;
  %ld = load atomic bfloat, ptr addrspace(1) %ptr syncscope("agent") seq_cst, align 2, !some.unknown.md !0
  ret bfloat %ld
}

define bfloat @load_atomic_bf16_local(ptr addrspace(3) %ptr) {
; CHECK-LABEL: define bfloat @load_atomic_bf16_local(
; CHECK-SAME: ptr addrspace(3) [[PTR:%.*]]) {
; CHECK-NEXT:    [[TMP2:%.*]] = load atomic bfloat, ptr addrspace(3) [[PTR]] seq_cst, align 2, !some.unknown.md [[META0]]
; CHECK-NEXT:    ret bfloat [[TMP2]]
;
  %ld = load atomic bfloat, ptr addrspace(3) %ptr seq_cst, align 2, !some.unknown.md !0
  ret bfloat %ld
}

define bfloat @load_atomic_bf16_flat(ptr %ptr) {
; CHECK-LABEL: define bfloat @load_atomic_bf16_flat(
; CHECK-SAME: ptr [[PTR:%.*]]) {
; CHECK-NEXT:    [[TMP2:%.*]] = load atomic bfloat, ptr [[PTR]] seq_cst, align 2, !some.unknown.md [[META0]]
; CHECK-NEXT:    ret bfloat [[TMP2]]
;
  %ld = load atomic bfloat, ptr %ptr seq_cst, align 2, !some.unknown.md !0
  ret bfloat %ld
}

define double @load_atomic_f64_global_system(ptr addrspace(1) %ptr) {
; CHECK-LABEL: define double @load_atomic_f64_global_system(
; CHECK-SAME: ptr addrspace(1) [[PTR:%.*]]) {
; CHECK-NEXT:    [[TMP2:%.*]] = load atomic double, ptr addrspace(1) [[PTR]] seq_cst, align 8, !some.unknown.md [[META0]]
; CHECK-NEXT:    ret double [[TMP2]]
;
  %ld = load atomic double, ptr addrspace(1) %ptr seq_cst, align 8, !some.unknown.md !0
  ret double %ld
}

define double @load_atomic_f64_global_agent(ptr addrspace(1) %ptr) {
; CHECK-LABEL: define double @load_atomic_f64_global_agent(
; CHECK-SAME: ptr addrspace(1) [[PTR:%.*]]) {
; CHECK-NEXT:    [[TMP2:%.*]] = load atomic double, ptr addrspace(1) [[PTR]] syncscope("agent") seq_cst, align 8, !some.unknown.md [[META0]]
; CHECK-NEXT:    ret double [[TMP2]]
;
  %ld = load atomic double, ptr addrspace(1) %ptr syncscope("agent") seq_cst, align 8, !some.unknown.md !0
  ret double %ld
}

define double @load_atomic_f64_local(ptr addrspace(3) %ptr) {
; CHECK-LABEL: define double @load_atomic_f64_local(
; CHECK-SAME: ptr addrspace(3) [[PTR:%.*]]) {
; CHECK-NEXT:    [[TMP2:%.*]] = load atomic double, ptr addrspace(3) [[PTR]] seq_cst, align 8, !some.unknown.md [[META0]]
; CHECK-NEXT:    ret double [[TMP2]]
;
  %ld = load atomic double, ptr addrspace(3) %ptr seq_cst, align 8, !some.unknown.md !0
  ret double %ld
}

define double @load_atomic_f64_flat_system(ptr %ptr) {
; CHECK-LABEL: define double @load_atomic_f64_flat_system(
; CHECK-SAME: ptr [[PTR:%.*]]) {
; CHECK-NEXT:    [[TMP2:%.*]] = load atomic double, ptr [[PTR]] seq_cst, align 8, !some.unknown.md [[META0]]
; CHECK-NEXT:    ret double [[TMP2]]
;
  %ld = load atomic double, ptr %ptr seq_cst, align 8, !some.unknown.md !0
  ret double %ld
}

define double @load_atomic_f64_flat_agent(ptr %ptr) {
; CHECK-LABEL: define double @load_atomic_f64_flat_agent(
; CHECK-SAME: ptr [[PTR:%.*]]) {
; CHECK-NEXT:    [[TMP2:%.*]] = load atomic double, ptr [[PTR]] syncscope("agent") seq_cst, align 8, !some.unknown.md [[META0]]
; CHECK-NEXT:    ret double [[TMP2]]
;
  %ld = load atomic double, ptr %ptr syncscope("agent") seq_cst, align 8, !some.unknown.md !0
  ret double %ld
}

!0 = !{}


;.
; CHECK: [[META0]] = !{}
;.
