# Generated by default/object.tt
package Paws::CodeBuild::ReportWithRawData;
  use Moose;
  has Data => (is => 'ro', isa => 'Str', request_name => 'data', traits => ['NameInRequest']);
  has ReportArn => (is => 'ro', isa => 'Str', request_name => 'reportArn', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeBuild::ReportWithRawData

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeBuild::ReportWithRawData object:

  $service_obj->Method(Att1 => { Data => $value, ..., ReportArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeBuild::ReportWithRawData object:

  $result = $service_obj->Method(...);
  $result->Att1->Data

=head1 DESCRIPTION

Contains the unmodified data for the report. For more information, see
.

=head1 ATTRIBUTES


=head2 Data => Str

The value of the requested data field from the report.


=head2 ReportArn => Str

The ARN of the report.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeBuild>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

