# Generated by default/object.tt
package Paws::Budgets::Action;
  use Moose;
  has ActionId => (is => 'ro', isa => 'Str', required => 1);
  has ActionThreshold => (is => 'ro', isa => 'Paws::Budgets::ActionThreshold', required => 1);
  has ActionType => (is => 'ro', isa => 'Str', required => 1);
  has ApprovalModel => (is => 'ro', isa => 'Str', required => 1);
  has BudgetName => (is => 'ro', isa => 'Str', required => 1);
  has Definition => (is => 'ro', isa => 'Paws::Budgets::Definition', required => 1);
  has ExecutionRoleArn => (is => 'ro', isa => 'Str', required => 1);
  has NotificationType => (is => 'ro', isa => 'Str', required => 1);
  has Status => (is => 'ro', isa => 'Str', required => 1);
  has Subscribers => (is => 'ro', isa => 'ArrayRef[Paws::Budgets::Subscriber]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Budgets::Action

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Budgets::Action object:

  $service_obj->Method(Att1 => { ActionId => $value, ..., Subscribers => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Budgets::Action object:

  $result = $service_obj->Method(...);
  $result->Att1->ActionId

=head1 DESCRIPTION

A budget action resource.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ActionId => Str

A system-generated universally unique identifier (UUID) for the action.


=head2 B<REQUIRED> ActionThreshold => L<Paws::Budgets::ActionThreshold>

The trigger threshold of the action.


=head2 B<REQUIRED> ActionType => Str

The type of action. This defines the type of tasks that can be carried
out by this action. This field also determines the format for
definition.


=head2 B<REQUIRED> ApprovalModel => Str

This specifies if the action needs manual or automatic approval.


=head2 B<REQUIRED> BudgetName => Str




=head2 B<REQUIRED> Definition => L<Paws::Budgets::Definition>

Where you specify all of the type-specific parameters.


=head2 B<REQUIRED> ExecutionRoleArn => Str

The role passed for action execution and reversion. Roles and actions
must be in the same account.


=head2 B<REQUIRED> NotificationType => Str




=head2 B<REQUIRED> Status => Str

The status of action.


=head2 B<REQUIRED> Subscribers => ArrayRef[L<Paws::Budgets::Subscriber>]





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Budgets>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

