# **Spreadsheet Cloud API: getWorksheetCells**

Retrieve cell descriptions in a specified format. 


## **Quick Start**

- **Base URL**: `http://api.aspose.cloud/v3.0`
- **Authentication Method**: `JWT (OAuth2, application)`  **Token URL**: `https://api.aspose.cloud/connect/token`
- **Example** 

## **Interface Details**

### **Endpoint** 

```
GET http://api.aspose.cloud/v3.0/cells/{name}/worksheets/{sheetName}/cells
```
### **Function Description**
PageTitle: Unmerge cells in the worksheet.PageDescription: Aspose.Cells Cloud provides robust support for unmerging cells in the worksheet, a process known for its intricacy.HeadTitle: Unmerge cells in the worksheet.HeadSummary: Aspose.Cells Cloud provides robust support for unmerging cells in the worksheet, a process known for its intricacy.HeadContent: Aspose.Cells Cloud provides REST API which supports unmerging cells in the worksheet and offers SDKs for multiple programming languages. These programming languages are include of Net, Java, Go, NodeJS, Python, and so on.

### The request parameters of **getWorksheetCells** API are: 

| Parameter Name | Type | Path/Query String/HTTPBody | Description | 
| :- | :- | :- |:- | 
|name|String|Path|The file name.|
|sheetName|String|Path|The worksheet name.|
|offest|Integer|Query|Begginig offset.|
|count|Integer|Query|Maximum amount of cells in the response.|
|folder|String|Query|The folder where the file is situated.|
|storageName|String|Query|The storage name where the file is situated.|

### **Response Description**
```json
{
  "Name": "CellsResponse",
  "Description": [
    "Represents the Cells Response."
  ],
  "Type": "Class",
  "ParentName": "CellsCloudResponse",
  "IsAbstract": false,
  "Properties": [
    {
      "Name": "Cells",
      "Description": [
        "Property Summary: The class has a property called \"Cells\" which is annotated with the [XmlElement(\"cells\")] attribute."
      ],
      "Nullable": true,
      "ReadOnly": false,
      "IsInherit": false,
      "DataType": {
        "Identifier": "Class",
        "Reference": "Cells",
        "Name": "class:cells"
      }
    },
    {
      "Name": "Code",
      "Nullable": true,
      "ReadOnly": false,
      "IsInherit": true,
      "DataType": {
        "Identifier": "Integer",
        "Name": "integer"
      }
    },
    {
      "Name": "Status",
      "Nullable": true,
      "ReadOnly": false,
      "IsInherit": true,
      "DataType": {
        "Identifier": "String",
        "Name": "string"
      }
    }
  ]
}
```


## OpenAPI Specification

The [OpenAPI Specification](https://reference.aspose.cloud/cells/#/CellsController/GetWorksheetCells) defines a publicly accessible programming interface and lets you carry out REST interactions directly from a web browser.
