#!/usr/bin/env perl
use strict;
use warnings;

use Test::More;
use Math::Prime::Util qw/sqrtint/;

my @vals = (
  [qw/       1524155677489    1234567/],
  [qw/       1524158146623    1234567/],
  [qw/       1524155677488    1234566/],
  [qw/    4503599761588224   67108864/],
  [qw/  425822367781739534  652550662/],
  [qw/ 9223372036854775807 3037000499/],
  [qw/ 9223372036854775808 3037000499/],
  [qw/18446744065119617024 4294967294/],
  [qw/18446744065119617025 4294967295/],
  [qw/18446744073709551615 4294967295/],
  [qw/18446744073709551616 4294967296/],
  [qw/18446744082299486208 4294967296/],
  [qw/18446744082299486209 4294967297/],

  [qw/84274086103068221283760416414557757 290299993288095377/],
);

plan tests => 3;

ok(!defined eval { sqrtint(-1) }, "sqrtint(n): n must not be negative");

is_deeply( [map { sqrtint($_) } 0..100], [map { int(sqrt($_)) } 0..100], "sqrtint 0 .. 100" );

is_deeply( [map { sqrtint($_->[0]) } @vals],
           [map { $_->[1] } @vals],
           "sqrtint(n) for multiple values" );
