/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkLaplacianImageFilter_h
#define sitkLaplacianImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class LaplacianImageFilter
\brief This filter computes the Laplacian of a scalar-valued image.

The Laplacian is an isotropic measure of the 2nd spatial derivative of an image. The Laplacian of an image highlights regions of rapid intensity change and is therefore often used for edge detection. Often, the Laplacian is applied to an image that has first been smoothed with a Gaussian filter in order to reduce its sensitivity to noise.

\par 
The Laplacian at each pixel location is computed by convolution with the itk::LaplacianOperator .


\par Inputs and Outputs
The input to this filter is a scalar-valued itk::Image of arbitrary dimension. The output is a scalar-valued itk::Image .


\warning The pixel type of the input and output images must be of real type (float or double). ConceptChecking is used here to enforce the input pixel type. You will get a compilation error if the pixel type of the input and output images is not float or double.


\see Image 


\see Neighborhood 


\see NeighborhoodOperator 


\see NeighborhoodIterator 


\see LaplacianOperator
\sa itk::simple::Laplacian for the procedural interface
\sa itk::LaplacianImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT LaplacianImageFilter : public ImageFilter {
    public:
      using Self = LaplacianImageFilter;

      /** Destructor */
      virtual ~LaplacianImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      LaplacianImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = RealPixelIDTypeList;
\

      /**
       * Set/Get whether or not the filter will use the spacing of the input image in its calculations
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUseImageSpacing ( bool UseImageSpacing ) { this->m_UseImageSpacing = UseImageSpacing; return *this; }

      /** Set the value of UseImageSpacing to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER UseImageSpacingOn() { return this->SetUseImageSpacing(true); }
      SITK_RETURN_SELF_TYPE_HEADER UseImageSpacingOff() { return this->SetUseImageSpacing(false); }

      /**
       * Set/Get whether or not the filter will use the spacing of the input image in its calculations
       */
      bool GetUseImageSpacing() const { return this->m_UseImageSpacing; }

      /** Name of this class */
      std::string GetName() const { return std::string ("LaplacianImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      bool  m_UseImageSpacing{true};


    };

    /**\
     * \brief This filter computes the Laplacian of a scalar-valued image.
     *
     * This function directly calls the execute method of LaplacianImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::LaplacianImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image Laplacian ( const Image& image1, bool useImageSpacing = true );

     /** @} */
}
#endif
