/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.opensearch.timeseries.ExpiringState;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.Job;

public class NodeState
implements ExpiringState {
    private String configId;
    private Config configDef;
    private Instant lastAccessTime;
    private Optional<Exception> exception;
    private final Clock clock;
    private Job configJob;
    private int partitonNumber;
    private boolean checkPointExists;
    private boolean coldStartRunning;

    public NodeState(String configId, Clock clock) {
        this.configId = configId;
        this.configDef = null;
        this.lastAccessTime = clock.instant();
        this.exception = Optional.empty();
        this.clock = clock;
        this.partitonNumber = -1;
        this.checkPointExists = false;
        this.coldStartRunning = false;
        this.configJob = null;
    }

    public String getConfigId() {
        return this.configId;
    }

    public Config getConfigDef() {
        this.refreshLastUpdateTime();
        return this.configDef;
    }

    public void setConfigDef(Config configDef) {
        this.configDef = configDef;
        this.refreshLastUpdateTime();
    }

    public Optional<Exception> getException() {
        this.refreshLastUpdateTime();
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = Optional.ofNullable(exception);
        this.refreshLastUpdateTime();
    }

    protected void refreshLastUpdateTime() {
        this.lastAccessTime = this.clock.instant();
    }

    @Override
    public boolean expired(Duration stateTtl) {
        return this.expired(this.lastAccessTime, stateTtl, this.clock.instant());
    }

    public int getPartitonNumber() {
        this.refreshLastUpdateTime();
        return this.partitonNumber;
    }

    public void setPartitonNumber(int partitonNumber) {
        this.partitonNumber = partitonNumber;
        this.refreshLastUpdateTime();
    }

    public boolean doesCheckpointExists() {
        this.refreshLastUpdateTime();
        return this.checkPointExists;
    }

    public void setCheckpointExists(boolean checkpointExists) {
        this.refreshLastUpdateTime();
        this.checkPointExists = checkpointExists;
    }

    public boolean isColdStartRunning() {
        this.refreshLastUpdateTime();
        return this.coldStartRunning;
    }

    public void setColdStartRunning(boolean coldStartRunning) {
        this.coldStartRunning = coldStartRunning;
        this.refreshLastUpdateTime();
    }

    public Job getJob() {
        this.refreshLastUpdateTime();
        return this.configJob;
    }

    public void setJob(Job job) {
        this.configJob = job;
        this.refreshLastUpdateTime();
    }
}

