/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.MultiCollector;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.lucene.MinimumScoreCollector;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.BucketCollector;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.MultiBucketCollector;
import org.opensearch.search.profile.query.InternalProfileCollector;

@PublicApi(since="2.10.0")
public class BucketCollectorProcessor {
    public void processPostCollection(Collector collectorTree) throws IOException {
        LinkedList<Collector> collectors = new LinkedList<Collector>();
        collectors.offer(collectorTree);
        while (!collectors.isEmpty()) {
            Collector currentCollector = (Collector)collectors.poll();
            if (currentCollector instanceof InternalProfileCollector) {
                collectors.offer(((InternalProfileCollector)currentCollector).getCollector());
                continue;
            }
            if (currentCollector instanceof MinimumScoreCollector) {
                collectors.offer(((MinimumScoreCollector)currentCollector).getCollector());
                continue;
            }
            if (currentCollector instanceof MultiCollector) {
                for (Collector collector : ((MultiCollector)currentCollector).getCollectors()) {
                    collectors.offer(collector);
                }
                continue;
            }
            if (!(currentCollector instanceof BucketCollector)) continue;
            if (currentCollector instanceof Aggregator) {
                ((BucketCollector)currentCollector).postCollection();
                ((Aggregator)currentCollector).buildTopLevel();
                continue;
            }
            if (!(currentCollector instanceof MultiBucketCollector)) continue;
            for (Collector collector : ((MultiBucketCollector)currentCollector).getCollectors()) {
                collectors.offer(collector);
            }
        }
    }

    @ExperimentalApi
    public List<InternalAggregation> buildAggBatch(Collector collectorTree) throws IOException {
        ArrayList<InternalAggregation> aggregations = new ArrayList<InternalAggregation>();
        LinkedList<Collector> collectors = new LinkedList<Collector>();
        collectors.offer(collectorTree);
        while (!collectors.isEmpty()) {
            Collector currentCollector = (Collector)collectors.poll();
            if (currentCollector instanceof InternalProfileCollector) {
                collectors.offer(((InternalProfileCollector)currentCollector).getCollector());
                continue;
            }
            if (currentCollector instanceof MinimumScoreCollector) {
                collectors.offer(((MinimumScoreCollector)currentCollector).getCollector());
                continue;
            }
            if (currentCollector instanceof MultiCollector) {
                for (Collector collector : ((MultiCollector)currentCollector).getCollectors()) {
                    collectors.offer(collector);
                }
                continue;
            }
            if (!(currentCollector instanceof BucketCollector)) continue;
            if (currentCollector instanceof Aggregator) {
                ((BucketCollector)currentCollector).postCollection();
                aggregations.add(((Aggregator)currentCollector).buildTopLevelBatch());
                continue;
            }
            if (!(currentCollector instanceof MultiBucketCollector)) continue;
            for (Collector collector : ((MultiBucketCollector)currentCollector).getCollectors()) {
                collectors.offer(collector);
            }
        }
        return aggregations;
    }

    public List<Aggregator> toAggregators(Collection<Collector> collectors) {
        ArrayList<Aggregator> aggregators = new ArrayList<Aggregator>();
        LinkedList<Collector> allCollectors = new LinkedList<Collector>(collectors);
        while (!allCollectors.isEmpty()) {
            Collector currentCollector = (Collector)allCollectors.pop();
            if (currentCollector instanceof Aggregator) {
                aggregators.add((Aggregator)currentCollector);
                continue;
            }
            if (currentCollector instanceof InternalProfileCollector) {
                if (((InternalProfileCollector)currentCollector).getCollector() instanceof Aggregator) {
                    aggregators.add((Aggregator)((InternalProfileCollector)currentCollector).getCollector());
                    continue;
                }
                if (!(((InternalProfileCollector)currentCollector).getCollector() instanceof MultiBucketCollector)) continue;
                allCollectors.addAll(Arrays.asList(((MultiBucketCollector)((InternalProfileCollector)currentCollector).getCollector()).getCollectors()));
                continue;
            }
            if (!(currentCollector instanceof MultiBucketCollector)) continue;
            allCollectors.addAll(Arrays.asList(((MultiBucketCollector)currentCollector).getCollectors()));
        }
        return aggregators;
    }

    public List<InternalAggregation> toInternalAggregations(Collection<Collector> collectors) throws IOException {
        ArrayList<InternalAggregation> internalAggregations = new ArrayList<InternalAggregation>();
        LinkedList<Collector> allCollectors = new LinkedList<Collector>(collectors);
        while (!allCollectors.isEmpty()) {
            Collector currentCollector = (Collector)allCollectors.pop();
            if (currentCollector instanceof InternalProfileCollector) {
                currentCollector = ((InternalProfileCollector)currentCollector).getCollector();
            }
            if (currentCollector instanceof Aggregator) {
                internalAggregations.add(((Aggregator)currentCollector).getPostCollectionAggregation());
                continue;
            }
            if (!(currentCollector instanceof MultiBucketCollector)) continue;
            allCollectors.addAll(Arrays.asList(((MultiBucketCollector)currentCollector).getCollectors()));
        }
        return internalAggregations;
    }
}

