/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import twitter4j.AccessToken;
import twitter4j.Authorization;
import twitter4j.BASE64Encoder;
import twitter4j.Configuration;
import twitter4j.HttpClient;
import twitter4j.HttpParameter;
import twitter4j.HttpRequest;
import twitter4j.HttpResponse;
import twitter4j.Logger;
import twitter4j.OAuthToken;
import twitter4j.RequestToken;
import twitter4j.TwitterException;

public class OAuthAuthorization
implements Authorization,
Serializable {
    private static final long serialVersionUID = -886869424811858868L;
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final HttpParameter OAUTH_SIGNATURE_METHOD = new HttpParameter("oauth_signature_method", "HMAC-SHA1");
    private static final Logger logger = Logger.getLogger();
    private final String consumerKey;
    private final String consumerSecret;
    private final String realm;
    private OAuthToken oauthToken = null;
    private final HttpClient http;
    private final String oAuthRequestTokenURL;
    private final String oAuthAccessTokenURL;
    private final String oAuthInvalidateTokenURL;
    private final String oAuthAuthorizationURL;
    private final String oAuthAuthenticationURL;
    private static final Random RAND = new Random();

    OAuthAuthorization(Configuration conf) {
        this.http = conf.http;
        this.oAuthRequestTokenURL = conf.oAuthRequestTokenURL;
        this.oAuthAccessTokenURL = conf.oAuthAccessTokenURL;
        this.oAuthInvalidateTokenURL = conf.oAuthInvalidateTokenURL;
        this.oAuthAuthorizationURL = conf.oAuthAuthorizationURL;
        this.oAuthAuthenticationURL = conf.oAuthAuthenticationURL;
        this.consumerKey = conf.oAuthConsumerKey != null ? conf.oAuthConsumerKey : "";
        String string = this.consumerSecret = conf.oAuthConsumerSecret != null ? conf.oAuthConsumerSecret : "";
        if (conf.oAuthAccessToken != null && conf.oAuthAccessTokenSecret != null) {
            this.oauthToken = new AccessToken(conf.oAuthAccessToken, conf.oAuthAccessTokenSecret);
        }
        this.realm = conf.oAuthRealm;
    }

    public static OAuthAuthorizationBuilder newBuilder() {
        return new OAuthAuthorizationBuilder();
    }

    public static OAuthAuthorization getInstance(String consumerKey, String consumerSecret) {
        return ((OAuthAuthorizationBuilder)OAuthAuthorization.newBuilder().oAuthConsumer(consumerKey, consumerSecret)).build();
    }

    public static OAuthAuthorization getInstance() {
        return OAuthAuthorization.newBuilder().build();
    }

    @Override
    public String getAuthorizationHeader(HttpRequest req) {
        return this.generateAuthorizationHeader(req.getMethod().name(), req.getURL(), req.getParameters(), this.oauthToken);
    }

    private void ensureTokenIsAvailable() {
        if (null == this.oauthToken) {
            throw new IllegalStateException("No Token available.");
        }
    }

    @Override
    public boolean isEnabled() {
        return this.oauthToken != null && this.oauthToken instanceof AccessToken;
    }

    public RequestToken getOAuthRequestToken() throws TwitterException {
        return this.getOAuthRequestToken(null);
    }

    public RequestToken getOAuthRequestToken(String callbackURL) throws TwitterException {
        if (this.oauthToken instanceof AccessToken) {
            throw new IllegalStateException("Access token already available.");
        }
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (callbackURL != null) {
            params.add(new HttpParameter("oauth_callback", callbackURL));
        }
        this.oauthToken = new RequestToken(this.http.post(this.oAuthRequestTokenURL, params.toArray(new HttpParameter[0]), this, null), this.oAuthAuthorizationURL, this.oAuthAuthenticationURL);
        return (RequestToken)this.oauthToken;
    }

    public AccessToken getOAuthAccessToken() throws TwitterException {
        this.ensureTokenIsAvailable();
        if (this.oauthToken instanceof AccessToken) {
            return (AccessToken)this.oauthToken;
        }
        this.oauthToken = new AccessToken(this.http.post(this.oAuthAccessTokenURL, null, this, null));
        return (AccessToken)this.oauthToken;
    }

    public AccessToken getOAuthAccessToken(String oauthVerifier) throws TwitterException {
        this.ensureTokenIsAvailable();
        this.oauthToken = new AccessToken(this.http.post(this.oAuthAccessTokenURL, new HttpParameter[]{new HttpParameter("oauth_verifier", oauthVerifier)}, this, null));
        return (AccessToken)this.oauthToken;
    }

    public AccessToken getOAuthAccessToken(RequestToken requestToken) throws TwitterException {
        this.oauthToken = requestToken;
        return this.getOAuthAccessToken();
    }

    public AccessToken getOAuthAccessToken(RequestToken requestToken, String oauthVerifier) throws TwitterException {
        this.oauthToken = requestToken;
        return this.getOAuthAccessToken(oauthVerifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateOAuthToken() throws TwitterException {
        if (this.oauthToken == null) {
            throw new IllegalStateException("OAuth Token is not available.");
        }
        HttpParameter[] params = new HttpParameter[]{new HttpParameter("access_token", this.getOAuthAccessToken().getToken())};
        OAuthToken _token = this.oauthToken;
        boolean succeed = false;
        try {
            HttpResponse res = this.http.post(this.oAuthInvalidateTokenURL, params, this, null);
            if (res.getStatusCode() != 200) {
                throw new TwitterException("Invalidating OAuth Token failed.", res);
            }
            succeed = true;
        }
        finally {
            this.oauthToken = null;
            if (!succeed) {
                this.oauthToken = _token;
            }
        }
    }

    String generateAuthorizationHeader(String method, String url, HttpParameter[] params, String nonce, String timestamp, OAuthToken otoken) {
        if (null == params) {
            params = new HttpParameter[]{};
        }
        ArrayList<HttpParameter> oauthHeaderParams = new ArrayList<HttpParameter>(5);
        oauthHeaderParams.add(new HttpParameter("oauth_consumer_key", this.consumerKey));
        oauthHeaderParams.add(OAUTH_SIGNATURE_METHOD);
        oauthHeaderParams.add(new HttpParameter("oauth_timestamp", timestamp));
        oauthHeaderParams.add(new HttpParameter("oauth_nonce", nonce));
        oauthHeaderParams.add(new HttpParameter("oauth_version", "1.0"));
        if (otoken != null) {
            oauthHeaderParams.add(new HttpParameter("oauth_token", otoken.getToken()));
        }
        ArrayList<HttpParameter> signatureBaseParams = new ArrayList<HttpParameter>(oauthHeaderParams.size() + params.length);
        signatureBaseParams.addAll(oauthHeaderParams);
        if (!HttpParameter.containsFile(params)) {
            signatureBaseParams.addAll(OAuthAuthorization.toParamList(params));
        }
        this.parseGetParameters(url, signatureBaseParams);
        StringBuilder base = new StringBuilder(method).append("&").append(HttpParameter.encode(OAuthAuthorization.constructRequestURL(url))).append("&");
        base.append(HttpParameter.encode(OAuthAuthorization.normalizeRequestParameters(signatureBaseParams)));
        String oauthBaseString = base.toString();
        logger.debug("OAuth base string: ", oauthBaseString);
        String signature = this.generateSignature(oauthBaseString, otoken);
        logger.debug("OAuth signature: ", signature);
        oauthHeaderParams.add(new HttpParameter("oauth_signature", signature));
        if (this.realm != null) {
            oauthHeaderParams.add(new HttpParameter("realm", this.realm));
        }
        return "OAuth " + OAuthAuthorization.encodeParameters(oauthHeaderParams, ",", true);
    }

    private void parseGetParameters(String url, List<HttpParameter> signatureBaseParams) {
        int queryStart = url.indexOf("?");
        if (-1 != queryStart) {
            String[] queryStrs = url.substring(queryStart + 1).split("&");
            try {
                for (String query : queryStrs) {
                    String[] split = query.split("=");
                    if (split.length == 2) {
                        signatureBaseParams.add(new HttpParameter(URLDecoder.decode(split[0], "UTF-8"), URLDecoder.decode(split[1], "UTF-8")));
                        continue;
                    }
                    signatureBaseParams.add(new HttpParameter(URLDecoder.decode(split[0], "UTF-8"), ""));
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    String generateAuthorizationHeader(String method, String url, HttpParameter[] params, OAuthToken token) {
        long timestamp = System.currentTimeMillis() / 1000L;
        long nonce = timestamp + (long)RAND.nextInt();
        return this.generateAuthorizationHeader(method, url, params, String.valueOf(nonce), String.valueOf(timestamp), token);
    }

    String generateSignature(String data, OAuthToken token) {
        byte[] byteHMAC;
        try {
            SecretKeySpec spec;
            Mac mac = Mac.getInstance(HMAC_SHA1);
            if (null == token) {
                String oauthSignature = HttpParameter.encode(this.consumerSecret) + "&";
                spec = new SecretKeySpec(oauthSignature.getBytes(), HMAC_SHA1);
            } else {
                spec = token.getSecretKeySpec();
                if (null == spec) {
                    String oauthSignature = HttpParameter.encode(this.consumerSecret) + "&" + HttpParameter.encode(token.getTokenSecret());
                    spec = new SecretKeySpec(oauthSignature.getBytes(), HMAC_SHA1);
                    token.setSecretKeySpec(spec);
                }
            }
            mac.init(spec);
            byteHMAC = mac.doFinal(data.getBytes());
        }
        catch (InvalidKeyException ike) {
            logger.error("Failed initialize \"Message Authentication Code\" (MAC)", ike);
            throw new AssertionError((Object)ike);
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.error("Failed to get HmacSHA1 \"Message Authentication Code\" (MAC)", nsae);
            throw new AssertionError((Object)nsae);
        }
        return BASE64Encoder.encode(byteHMAC);
    }

    static String normalizeRequestParameters(HttpParameter[] params) {
        return OAuthAuthorization.normalizeRequestParameters(OAuthAuthorization.toParamList(params));
    }

    private static String normalizeRequestParameters(List<HttpParameter> params) {
        Collections.sort(params);
        return OAuthAuthorization.encodeParameters(params);
    }

    private static List<HttpParameter> toParamList(HttpParameter[] params) {
        ArrayList<HttpParameter> paramList = new ArrayList<HttpParameter>(params.length);
        paramList.addAll(Arrays.asList(params));
        return paramList;
    }

    public static String encodeParameters(List<HttpParameter> httpParams) {
        return OAuthAuthorization.encodeParameters(httpParams, "&", false);
    }

    static String encodeParameters(List<HttpParameter> httpParams, String splitter, boolean quot) {
        StringBuilder buf = new StringBuilder();
        for (HttpParameter param : httpParams) {
            if (param.isFile() || param.isJson()) continue;
            if (buf.length() != 0) {
                if (quot) {
                    buf.append("\"");
                }
                buf.append(splitter);
            }
            buf.append(HttpParameter.encode(param.getName())).append("=");
            if (quot) {
                buf.append("\"");
            }
            buf.append(HttpParameter.encode(param.getValue()));
        }
        if (buf.length() != 0 && quot) {
            buf.append("\"");
        }
        return buf.toString();
    }

    static String constructRequestURL(String url) {
        int slashIndex;
        String baseURL;
        int colonIndex;
        int index = url.indexOf("?");
        if (-1 != index) {
            url = url.substring(0, index);
        }
        if (-1 != (colonIndex = (baseURL = url.substring(0, slashIndex = url.indexOf("/", 8)).toLowerCase()).indexOf(":", 8))) {
            if (baseURL.startsWith("http://") && baseURL.endsWith(":80")) {
                baseURL = baseURL.substring(0, colonIndex);
            } else if (baseURL.startsWith("https://") && baseURL.endsWith(":443")) {
                baseURL = baseURL.substring(0, colonIndex);
            }
        }
        url = baseURL + url.substring(slashIndex);
        return url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthAuthorization that = (OAuthAuthorization)o;
        return Objects.equals(this.consumerKey, that.consumerKey) && Objects.equals(this.consumerSecret, that.consumerSecret) && Objects.equals(this.realm, that.realm) && Objects.equals(this.oauthToken, that.oauthToken);
    }

    public int hashCode() {
        return Objects.hash(this.consumerKey, this.consumerSecret, this.realm, this.oauthToken);
    }

    public String toString() {
        return "OAuthAuthorization{consumerKey='" + this.consumerKey + '\'' + ", consumerSecret='******************************************', oauthToken=" + this.oauthToken + '}';
    }

    public static class OAuthAuthorizationBuilder
    extends Configuration<OAuthAuthorizationBuilder> {
        private OAuthAuthorizationBuilder() {
        }

        public OAuthAuthorization build() {
            return new OAuthAuthorization((Configuration)this.buildConfiguration());
        }
    }
}

