/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AdjustableJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.postgresql.util.PGInterval;

public class PostgreSQLIntervalSecondJdbcType
implements AdjustableJdbcType {
    private static final long SECONDS_PER_DAY = 86400L;
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long SECONDS_PER_MINUTE = 60L;

    @Override
    public int getJdbcTypeCode() {
        return 1111;
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 3100;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
        return Duration.class;
    }

    @Override
    public JdbcType resolveIndicatedType(JdbcTypeIndicators indicators, JavaType<?> domainJtd) {
        int scale = indicators.getColumnScale() == -1 ? domainJtd.getDefaultSqlScale(indicators.getDialect(), this) : indicators.getColumnScale();
        if (scale > 6) {
            return indicators.getJdbcType(indicators.resolveJdbcTypeCode(2));
        }
        return this;
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return (appender, value, dialect, wrapperOptions) -> dialect.appendIntervalLiteral(appender, javaType.unwrap(value, Duration.class, wrapperOptions));
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                Duration duration = this.getJavaType().unwrap(value, Duration.class, options);
                st.setObject(index, this.constructInterval(duration));
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                Duration duration = this.getJavaType().unwrap(value, Duration.class, options);
                st.setObject(name, this.constructInterval(duration));
            }

            private Object constructInterval(Duration d) {
                long secondsLong = d.getSeconds();
                long minutesLong = secondsLong / 60L;
                long hoursLong = minutesLong / 60L;
                long daysLong = hoursLong / 24L;
                int days = Math.toIntExact(daysLong);
                int hours = (int)(hoursLong - daysLong * 24L);
                int minutes = (int)(minutesLong - hoursLong * 60L);
                double seconds = (double)(secondsLong - minutesLong * 60L) + (double)d.getNano() / 1.0E9;
                return new PGInterval(0, 0, days, hours, minutes, seconds);
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(this.getValue(rs.getObject(paramIndex)), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(this.getValue(statement.getObject(index)), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap(this.getValue(statement.getObject(name)), options);
            }

            private Object getValue(Object value) {
                if (value instanceof PGInterval) {
                    PGInterval interval = (PGInterval)value;
                    long seconds = (long)interval.getSeconds() + 86400L * (long)interval.getDays() + 3600L * (long)interval.getHours() + 60L * (long)interval.getMinutes();
                    long nanos = 1000L * (long)interval.getMicroSeconds();
                    return Duration.ofSeconds(seconds, nanos);
                }
                return value;
            }
        };
    }
}

