/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.internal;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Objects;
import org.infinispan.commons.util.Util;
import org.infinispan.marshall.protostream.impl.MarshallableUserObject;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5306)
public class MultimapObjectWrapper<T>
implements Comparable<MultimapObjectWrapper> {
    final T object;

    public MultimapObjectWrapper(T object) {
        this.object = object;
    }

    @ProtoFactory
    MultimapObjectWrapper(MarshallableUserObject<T> wrapper) {
        this(wrapper.get());
    }

    public T get() {
        return this.object;
    }

    @ProtoField(number=1)
    MarshallableUserObject<T> wrapper() {
        return new MarshallableUserObject(this.object);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MultimapObjectWrapper)) {
            return false;
        }
        MultimapObjectWrapper other = (MultimapObjectWrapper)obj;
        return MultimapObjectWrapper.wrappedEquals(this.object, other.object);
    }

    public boolean wrappedEquals(Object obj) {
        return MultimapObjectWrapper.wrappedEquals(this.object, obj);
    }

    public Double asDouble() {
        if (this.object instanceof byte[]) {
            return Double.valueOf(new String((byte[])this.object, Charset.forName("US-ASCII")));
        }
        if (this.object instanceof Double) {
            return (Double)this.object;
        }
        throw new NumberFormatException("Can't convert to Double from class " + String.valueOf(this.object.getClass()));
    }

    public int hashCode() {
        if (this.object instanceof byte[]) {
            return Arrays.hashCode((byte[])this.object);
        }
        return Objects.hashCode(this.object);
    }

    @Override
    public int compareTo(MultimapObjectWrapper other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (this.equals(other)) {
            return 0;
        }
        if (this.object instanceof Comparable && other.object instanceof Comparable) {
            return ((Comparable)this.object).compareTo(other.object);
        }
        if (this.object instanceof byte[] && other.object instanceof byte[]) {
            return Arrays.compare((byte[])this.object, (byte[])other.object);
        }
        throw new ClassCastException("can't compare");
    }

    public String toString() {
        if (this.object instanceof byte[]) {
            return "MultimapObjectWrapper{object=" + Util.hexDump((byte[])((byte[])this.object)) + "}";
        }
        return "MultimapObjectWrapper{object=" + String.valueOf(this.object) + "}";
    }

    public static boolean wrappedEquals(Object thisWrapped, Object thatWrapped) {
        if (thisWrapped instanceof byte[]) {
            byte[] left = (byte[])thisWrapped;
            if (thatWrapped instanceof byte[]) {
                byte[] right = (byte[])thatWrapped;
                return Arrays.equals(left, right);
            }
        }
        return Objects.equals(thisWrapped, thatWrapped);
    }
}

