/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants;

import jakarta.ws.rs.core.Response;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.JWTAuthorizationGrantProvider;
import org.keycloak.cache.AlternativeLookupProvider;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.JWTAuthorizationGrantValidationContext;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.grants.JWTAuthorizationGrantValidator;
import org.keycloak.protocol.oidc.grants.OAuth2GrantType;
import org.keycloak.protocol.oidc.grants.OAuth2GrantTypeBase;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.Urls;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.JWTAuthorizationGrantContext;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class JWTAuthorizationGrantType
extends OAuth2GrantTypeBase {
    public Response process(OAuth2GrantType.Context context) {
        this.setContext(context);
        String assertion = (String)this.formParams.getFirst((Object)"assertion");
        try {
            JWTAuthorizationGrantValidator authorizationGrantContext = JWTAuthorizationGrantValidator.createValidator(context.getSession(), this.client, assertion, (String)this.formParams.getFirst((Object)"scope"));
            this.event.detail("identity_provider_issuer", authorizationGrantContext.getIssuer());
            this.event.detail("identity_provider_user_id", authorizationGrantContext.getSubject());
            authorizationGrantContext.validateClient();
            authorizationGrantContext.validateIssuer();
            authorizationGrantContext.validateSubject();
            String jwtIssuer = authorizationGrantContext.getIssuer();
            AlternativeLookupProvider lookupProvider = (AlternativeLookupProvider)context.getSession().getProvider(AlternativeLookupProvider.class);
            IdentityProviderModel identityProviderModel = lookupProvider.lookupIdentityProviderFromIssuer(this.session, jwtIssuer);
            if (identityProviderModel == null) {
                throw new RuntimeException("No Identity Provider for provided issuer");
            }
            this.event.detail("identity_provider", identityProviderModel.getAlias());
            if (!OIDCAdvancedConfigWrapper.fromClientModel(context.getClient()).getJWTAuthorizationGrantAllowedIdentityProviders().contains(identityProviderModel.getAlias())) {
                throw new RuntimeException("Identity Provider is not allowed for the client");
            }
            JWTAuthorizationGrantProvider jwtAuthorizationGrantProvider = IdentityBrokerService.getIdentityProvider(this.session, identityProviderModel, JWTAuthorizationGrantProvider.class);
            if (jwtAuthorizationGrantProvider == null) {
                throw new RuntimeException("Identity Provider is not configured for JWT Authorization Grant");
            }
            authorizationGrantContext.validateTokenActive(jwtAuthorizationGrantProvider.getAllowedClockSkew(), jwtAuthorizationGrantProvider.getMaxAllowedExpiration(), jwtAuthorizationGrantProvider.isAssertionReuseAllowed());
            authorizationGrantContext.validateSignatureAlgorithm(jwtAuthorizationGrantProvider.getAssertionSignatureAlg());
            authorizationGrantContext.validateTokenAudience(jwtAuthorizationGrantProvider.getAllowedAudienceForJWTGrant(), false);
            BrokeredIdentityContext brokeredIdentityContext = jwtAuthorizationGrantProvider.validateAuthorizationGrantAssertion((JWTAuthorizationGrantValidationContext)authorizationGrantContext);
            if (brokeredIdentityContext == null) {
                throw new RuntimeException("Error validating JWT with identity provider");
            }
            FederatedIdentityModel federatedIdentityModel = new FederatedIdentityModel(identityProviderModel.getAlias(), brokeredIdentityContext.getId(), brokeredIdentityContext.getUsername(), brokeredIdentityContext.getToken());
            UserModel user = this.session.users().getUserByFederatedIdentity(this.realm, federatedIdentityModel);
            if (user == null) {
                throw new RuntimeException("User not found");
            }
            this.event.user(user);
            this.event.detail("username", user.getUsername());
            String scopeParam = this.getRequestedScopes();
            try {
                this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new JWTAuthorizationGrantContext(authorizationGrantContext, identityProviderModel));
            }
            catch (ClientPolicyException cpe) {
                this.event.detail("reason", "client_policy_error");
                this.event.detail("client_policy_error", cpe.getError());
                this.event.detail("client_policy_error_detail", cpe.getErrorDetail());
                this.event.error(cpe.getError());
                throw new CorsErrorResponseException(this.cors, cpe.getError(), cpe.getErrorDetail(), cpe.getErrorStatus());
            }
            RootAuthenticationSessionModel rootAuthSession = new AuthenticationSessionManager(this.session).createAuthenticationSession(this.realm, false);
            AuthenticationSessionModel authSession = this.createSessionModel(rootAuthSession, user, this.client, scopeParam);
            UserSessionModel userSession = new UserSessionManager(this.session).createUserSession(authSession.getParentSession().getId(), this.realm, user, user.getUsername(), this.clientConnection.getRemoteHost(), "authorization-grant", false, null, null, UserSessionModel.SessionPersistenceState.TRANSIENT);
            this.event.session(userSession);
            ClientSessionContext clientSessionCtx = TokenManager.attachAuthenticationSession(this.session, userSession, authSession, authorizationGrantContext.getRestrictedScopes(), false);
            TokenManager.AccessTokenResponseBuilder responseBuilder = this.createTokenResponseBuilder(user, userSession, clientSessionCtx, scopeParam, null);
            if (jwtAuthorizationGrantProvider.isLimitAccessTokenExpiration() && authorizationGrantContext.getJWT().getExp() < responseBuilder.getAccessToken().getExp()) {
                responseBuilder.getAccessToken().exp(authorizationGrantContext.getJWT().getExp());
            }
            return this.createTokenResponse(responseBuilder, clientSessionCtx, true);
        }
        catch (CorsErrorResponseException e) {
            throw e;
        }
        catch (Exception e) {
            this.event.detail("reason", e.getMessage());
            this.event.error("invalid_request");
            throw new CorsErrorResponseException(this.cors, "invalid_grant", e.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    protected AuthenticationSessionModel createSessionModel(RootAuthenticationSessionModel rootAuthSession, UserModel targetUser, ClientModel client, String scope) {
        AuthenticationSessionModel authSession = rootAuthSession.createAuthenticationSession(client);
        authSession.setAuthenticatedUser(targetUser);
        authSession.setProtocol("openid-connect");
        authSession.setClientNote("iss", Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
        authSession.setClientNote("scope", scope);
        return authSession;
    }

    @Override
    protected boolean useRefreshToken() {
        return false;
    }

    public EventType getEventType() {
        return EventType.LOGIN;
    }
}

