/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Calculates image derivatives using discrete derivative gaussian
kernels. This filter calculates Gaussian derivative by separable
convolution of an image and a discrete Gaussian derivative operator
(kernel).


The Gaussian operators used here were described by Tony Lindeberg
(Discrete Scale-Space Theory and the Scale-Space Primal Sketch.
Dissertation. Royal Institute of Technology, Stockholm, Sweden. May
1991.)

The variance or standard deviation (sigma) will be evaluated as pixel
units if SetUseImageSpacing is off (false) or as physical units if
SetUseImageSpacing is on (true, default). The variance can be set
independently in each dimension.

When the Gaussian kernel is small, this filter tends to run faster
than itk::RecursiveGaussianImageFilter .


Ivan Macia, Vicomtech, Spain, https://www.vicomtech.org/en
 This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/mrg5is


See:
 GaussianDerivativeOperator

 Image

 Neighborhood

 NeighborhoodOperator

 itk::simple::DiscreteGaussianDerivative for the procedural interface

 itk::DiscreteGaussianDerivativeImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkDiscreteGaussianDerivativeImageFilter.h
*/
public class DiscreteGaussianDerivativeImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected DiscreteGaussianDerivativeImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.DiscreteGaussianDerivativeImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(DiscreteGaussianDerivativeImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(DiscreteGaussianDerivativeImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::DiscreteGaussianDerivativeImageFilter::~DiscreteGaussianDerivativeImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_DiscreteGaussianDerivativeImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::DiscreteGaussianDerivativeImageFilter::DiscreteGaussianDerivativeImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  DiscreteGaussianDerivativeImageFilter() {
    this(SimpleITKJNI.new_DiscreteGaussianDerivativeImageFilter(), true);
  }

  /**
Self&amp; itk::simple::DiscreteGaussianDerivativeImageFilter::SetVariance(std::vector&lt; double &gt; Variance)

Convenience Set methods for setting all dimensional parameters to the
same values.

*/
public  void setVariance(VectorDouble Variance) {
    SimpleITKJNI.DiscreteGaussianDerivativeImageFilter_setVariance__SWIG_0(swigCPtr, this, VectorDouble.getCPtr(Variance), Variance);
  }

  /**
Self&amp; itk::simple::DiscreteGaussianDerivativeImageFilter::SetVariance(std::vector&lt; double &gt; Variance)

Convenience Set methods for setting all dimensional parameters to the
same values.

*/
public  void setVariance(double value) {
    SimpleITKJNI.DiscreteGaussianDerivativeImageFilter_setVariance__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;double&gt; itk::simple::DiscreteGaussianDerivativeImageFilter::GetVariance() const

The variance for the discrete Gaussian kernel. Sets the variance
independently for each dimension, but see also SetVariance(const double v) . The default is 0.0 in each dimension. If UseImageSpacing is true,
the units are the physical units of your image. If UseImageSpacing is
false then the units are pixels.

*/
public  VectorDouble getVariance() {
    return new VectorDouble(SimpleITKJNI.DiscreteGaussianDerivativeImageFilter_getVariance(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::DiscreteGaussianDerivativeImageFilter::SetOrder(unsigned int value)

Set the values of the Order vector all to value

*/
public  void setOrder(VectorUInt32 Order) {
    SimpleITKJNI.DiscreteGaussianDerivativeImageFilter_setOrder__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(Order), Order);
  }

  /**
Self&amp; itk::simple::DiscreteGaussianDerivativeImageFilter::SetOrder(unsigned int value)

Set the values of the Order vector all to value

*/
public  void setOrder(long value) {
    SimpleITKJNI.DiscreteGaussianDerivativeImageFilter_setOrder__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::DiscreteGaussianDerivativeImageFilter::GetOrder() const

Order of derivatives in each dimension. Sets the derivative order
independently for each dimension, but see also SetOrder(const unsigned int v) . The default is 1 in each dimension.

*/
public  VectorUInt32 getOrder() {
    return new VectorUInt32(SimpleITKJNI.DiscreteGaussianDerivativeImageFilter_getOrder(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::DiscreteGaussianDerivativeImageFilter::SetMaximumKernelWidth(unsigned int MaximumKernelWidth)

Set the kernel to be no wider than MaximumKernelWidth pixels, even if
MaximumError demands it. The default is 32 pixels.

*/
public  void setMaximumKernelWidth(long MaximumKernelWidth) {
    SimpleITKJNI.DiscreteGaussianDerivativeImageFilter_setMaximumKernelWidth(swigCPtr, this, MaximumKernelWidth);
  }

  /**
unsigned int itk::simple::DiscreteGaussianDerivativeImageFilter::GetMaximumKernelWidth() const

Set the kernel to be no wider than MaximumKernelWidth pixels, even if
MaximumError demands it. The default is 32 pixels.

*/
public  long getMaximumKernelWidth() {
    return SimpleITKJNI.DiscreteGaussianDerivativeImageFilter_getMaximumKernelWidth(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DiscreteGaussianDerivativeImageFilter::SetMaximumError(double MaximumError)

Convenience Set methods for setting all dimensional parameters to the
same values.

*/
public  void setMaximumError(double MaximumError) {
    SimpleITKJNI.DiscreteGaussianDerivativeImageFilter_setMaximumError(swigCPtr, this, MaximumError);
  }

  /**
double itk::simple::DiscreteGaussianDerivativeImageFilter::GetMaximumError() const

The algorithm will size the discrete kernel so that the error
resulting from truncation of the kernel is no greater than
MaximumError. The default is 0.01 in each dimension.

*/
public  double getMaximumError() {
    return SimpleITKJNI.DiscreteGaussianDerivativeImageFilter_getMaximumError(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DiscreteGaussianDerivativeImageFilter::SetUseImageSpacing(bool UseImageSpacing)

Set/Get whether or not the filter will use the spacing of the input
image in its calculations. Default is ImageSpacingOn.

*/
public  void setUseImageSpacing(boolean UseImageSpacing) {
    SimpleITKJNI.DiscreteGaussianDerivativeImageFilter_setUseImageSpacing(swigCPtr, this, UseImageSpacing);
  }

  /**
Self&amp; itk::simple::DiscreteGaussianDerivativeImageFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public  void useImageSpacingOn() {
    SimpleITKJNI.DiscreteGaussianDerivativeImageFilter_useImageSpacingOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DiscreteGaussianDerivativeImageFilter::UseImageSpacingOff()
*/
public  void useImageSpacingOff() {
    SimpleITKJNI.DiscreteGaussianDerivativeImageFilter_useImageSpacingOff(swigCPtr, this);
  }

  /**
bool itk::simple::DiscreteGaussianDerivativeImageFilter::GetUseImageSpacing() const

Set/Get whether or not the filter will use the spacing of the input
image in its calculations. Default is ImageSpacingOn.

*/
public  boolean getUseImageSpacing() {
    return SimpleITKJNI.DiscreteGaussianDerivativeImageFilter_getUseImageSpacing(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DiscreteGaussianDerivativeImageFilter::SetNormalizeAcrossScale(bool NormalizeAcrossScale)

Set/Get the flag for calculating scale-space normalized derivatives.
Normalized derivatives are obtained multiplying by the scale parameter
t.

*/
public  void setNormalizeAcrossScale(boolean NormalizeAcrossScale) {
    SimpleITKJNI.DiscreteGaussianDerivativeImageFilter_setNormalizeAcrossScale(swigCPtr, this, NormalizeAcrossScale);
  }

  /**
Self&amp; itk::simple::DiscreteGaussianDerivativeImageFilter::NormalizeAcrossScaleOn()

Set the value of NormalizeAcrossScale to true or false respectfully.

*/
public  void normalizeAcrossScaleOn() {
    SimpleITKJNI.DiscreteGaussianDerivativeImageFilter_normalizeAcrossScaleOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DiscreteGaussianDerivativeImageFilter::NormalizeAcrossScaleOff()
*/
public  void normalizeAcrossScaleOff() {
    SimpleITKJNI.DiscreteGaussianDerivativeImageFilter_normalizeAcrossScaleOff(swigCPtr, this);
  }

  /**
bool itk::simple::DiscreteGaussianDerivativeImageFilter::GetNormalizeAcrossScale() const

Set/Get the flag for calculating scale-space normalized derivatives.
Normalized derivatives are obtained multiplying by the scale parameter
t.

*/
public  boolean getNormalizeAcrossScale() {
    return SimpleITKJNI.DiscreteGaussianDerivativeImageFilter_getNormalizeAcrossScale(swigCPtr, this);
  }

  /**
std::string itk::simple::DiscreteGaussianDerivativeImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.DiscreteGaussianDerivativeImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::DiscreteGaussianDerivativeImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.DiscreteGaussianDerivativeImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::DiscreteGaussianDerivativeImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.DiscreteGaussianDerivativeImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
