/*
 * Decompiled with CFR 0.152.
 */
package org.jline.reader.impl.completer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.utils.AttributedString;

public class SystemCompleter
implements Completer {
    private Map<String, List<Completer>> completers = new HashMap<String, List<Completer>>();
    private Map<String, String> aliasCommand = new HashMap<String, String>();
    private Map<String, String> descriptions = new HashMap<String, String>();
    private StringsCompleter commands;
    private boolean compiled = false;

    @Override
    public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates) {
        if (!this.compiled) {
            throw new IllegalStateException();
        }
        assert (commandLine != null);
        assert (candidates != null);
        if (commandLine.words().size() > 0) {
            if (commandLine.words().size() == 1) {
                String buffer = commandLine.words().get(0);
                int eq = buffer.indexOf(61);
                if (eq < 0) {
                    this.commands.complete(reader, commandLine, candidates);
                } else if (reader.getParser().validVariableName(buffer.substring(0, eq))) {
                    String curBuf = buffer.substring(0, eq + 1);
                    for (String c : this.completers.keySet()) {
                        candidates.add(new Candidate(AttributedString.stripAnsi((String)(curBuf + c)), c, null, null, null, null, true));
                    }
                }
            } else {
                String cmd = reader.getParser().getCommand(commandLine.words().get(0));
                if (this.command(cmd) != null) {
                    this.completers.get(this.command(cmd)).get(0).complete(reader, commandLine, candidates);
                }
            }
        }
    }

    public boolean isCompiled() {
        return this.compiled;
    }

    private String command(String cmd) {
        String out = null;
        if (cmd != null) {
            out = this.completers.containsKey(cmd) ? cmd : this.aliasCommand.get(cmd);
        }
        return out;
    }

    public void add(String command, List<Completer> completers) {
        for (Completer c : completers) {
            this.add(command, c);
        }
    }

    public void add(List<String> commands, Completer completer) {
        for (String c : commands) {
            this.add(c, completer);
        }
    }

    public void add(String command, Completer completer) {
        Objects.requireNonNull(command);
        if (this.compiled) {
            throw new IllegalStateException();
        }
        if (!this.completers.containsKey(command)) {
            this.completers.put(command, new ArrayList());
        }
        if (completer instanceof ArgumentCompleter) {
            ((ArgumentCompleter)completer).setStrictCommand(false);
        }
        this.completers.get(command).add(completer);
    }

    public void add(SystemCompleter other) {
        if (other.isCompiled()) {
            throw new IllegalStateException();
        }
        for (Map.Entry<String, List<Completer>> entry : other.getCompleters().entrySet()) {
            for (Completer c : entry.getValue()) {
                this.add(entry.getKey(), c);
            }
        }
        this.addAliases(other.getAliases());
    }

    public void addAliases(Map<String, String> aliasCommand) {
        if (this.compiled) {
            throw new IllegalStateException();
        }
        this.aliasCommand.putAll(aliasCommand);
    }

    private Map<String, String> getAliases() {
        return this.aliasCommand;
    }

    public void compile() {
        this.compile(s -> new Candidate(AttributedString.stripAnsi((String)s), (String)s, null, null, null, null, true));
    }

    public void compile(Function<String, Candidate> candidateBuilder) {
        if (this.compiled) {
            return;
        }
        HashMap<String, List<Completer>> compiledCompleters = new HashMap<String, List<Completer>>();
        for (Map.Entry<String, List<Completer>> entry : this.completers.entrySet()) {
            if (entry.getValue().size() == 1) {
                compiledCompleters.put(entry.getKey(), entry.getValue());
                continue;
            }
            compiledCompleters.put(entry.getKey(), new ArrayList());
            ((List)compiledCompleters.get(entry.getKey())).add(new AggregateCompleter((Collection<Completer>)entry.getValue()));
        }
        this.completers = compiledCompleters;
        HashSet<String> cmds = new HashSet<String>(this.completers.keySet());
        cmds.addAll(this.aliasCommand.keySet());
        this.commands = new StringsCompleter(cmds.stream().map(candidateBuilder).collect(Collectors.toList()));
        this.compiled = true;
    }

    public Map<String, List<Completer>> getCompleters() {
        return this.completers;
    }
}

