/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.io.PrintStream;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.plugin.script.ScriptingPermissions;
import org.freeplane.plugin.script.ScriptingSecurityManager;
import org.freeplane.plugin.script.SignedScriptHandler;

public class ScriptSecurity {
    private final Object script;
    private final ScriptingPermissions specificPermissions;
    private final PrintStream outStream;

    public ScriptSecurity(Object script, ScriptingPermissions specificPermissions, PrintStream outStream) {
        this.script = script;
        this.specificPermissions = specificPermissions;
        this.outStream = outStream;
    }

    ScriptingSecurityManager getScriptingSecurityManager() {
        ScriptingPermissions permissions = this.permissions();
        permissions.assertScriptExecutionAllowed();
        boolean executeSignedScripts = permissions.isExecuteSignedScriptsWithoutRestriction();
        ScriptingSecurityManager scriptingSecurityManager = executeSignedScripts && this.isSignedScript() ? permissions.getPermissiveScriptingSecurityManager() : permissions.getScriptingSecurityManager();
        return scriptingSecurityManager;
    }

    private boolean isSignedScript() {
        return this.script instanceof String && new SignedScriptHandler().isScriptSigned((String)this.script, this.outStream);
    }

    private ScriptingPermissions permissions() {
        if (this.specificPermissions != null) {
            return this.specificPermissions;
        }
        return new ScriptingPermissions(ResourceController.getResourceController().getSecuredProperties());
    }
}

