/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.gaussdb.ui.config;

import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.gaussdb.model.GaussDBPackage;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EntityEditPage;

public class GaussDBPackageConfigurator
implements DBEObjectConfigurator<GaussDBPackage> {
    public static final DBSEntityType PACKAGE = new DBSEntityType("package", "Package", (DBPImage)DBIcon.TREE_PACKAGE, true);

    public GaussDBPackage configureObject(DBRProgressMonitor monitor, DBECommandContext commandContext, Object container, final GaussDBPackage gaussdbPackage, Map<String, Object> options) {
        return (GaussDBPackage)new UITask<GaussDBPackage>(){

            protected GaussDBPackage runTask() throws DBException {
                EntityEditPage editPage = new EntityEditPage((DBPDataSource)gaussdbPackage.getDataSource(), PACKAGE);
                if (!editPage.edit()) {
                    return null;
                }
                String packName = editPage.getEntityName();
                gaussdbPackage.setName(packName);
                gaussdbPackage.setObjectDefinitionText("CREATE OR REPLACE PACKAGE " + packName + "\nAS\n-- Package header\nEND " + packName + ";");
                gaussdbPackage.setExtendedDefinitionText("CREATE OR REPLACE PACKAGE BODY " + packName + "\nAS\n-- Package body\nEND " + packName + ";");
                return gaussdbPackage;
            }
        }.execute();
    }
}

