/* $FreeBSD: src/sys/net80211/ieee80211_radiotap.h,v 1.11 2007/12/13 01:23:40 sam Exp $ */

#ifndef _NET80211_IEEE80211_RADIOTAP_H_
#define _NET80211_IEEE80211_RADIOTAP_H_

#if defined(__KERNEL__) || defined(_KERNEL)
#ifndef DLT_IEEE802_11_RADIO
#define	DLT_IEEE802_11_RADIO	127	
#endif
#endif 

#define	IEEE80211_RADIOTAP_HDRLEN	64

struct ieee80211_radiotap_header {
	uint8_t		it_version;	
	uint8_t		it_pad;
	uint16_t	it_len;		
	uint32_t	it_present;	
} __attribute__((packed));

enum ieee80211_radiotap_type {
	IEEE80211_RADIOTAP_TSFT = 0,
	IEEE80211_RADIOTAP_FLAGS = 1,
	IEEE80211_RADIOTAP_RATE = 2,
	IEEE80211_RADIOTAP_CHANNEL = 3,
	IEEE80211_RADIOTAP_FHSS = 4,
	IEEE80211_RADIOTAP_DBM_ANTSIGNAL = 5,
	IEEE80211_RADIOTAP_DBM_ANTNOISE = 6,
	IEEE80211_RADIOTAP_LOCK_QUALITY = 7,
	IEEE80211_RADIOTAP_TX_ATTENUATION = 8,
	IEEE80211_RADIOTAP_DB_TX_ATTENUATION = 9,
	IEEE80211_RADIOTAP_DBM_TX_POWER = 10,
	IEEE80211_RADIOTAP_ANTENNA = 11,
	IEEE80211_RADIOTAP_DB_ANTSIGNAL = 12,
	IEEE80211_RADIOTAP_DB_ANTNOISE = 13,

	IEEE80211_RADIOTAP_TXFLAGS = 15,
	IEEE80211_RADIOTAP_RETRIES = 17,
	IEEE80211_RADIOTAP_XCHANNEL = 18,
	IEEE80211_RADIOTAP_MCS = 19,
	IEEE80211_RADIOTAP_AMPDU = 20,
	IEEE80211_RADIOTAP_VHT = 21,
	IEEE80211_RADIOTAP_RADIOTAP_NAMESPACE = 29,
	IEEE80211_RADIOTAP_VENDOR_NAMESPACE = 30,
	IEEE80211_RADIOTAP_EXT = 31,
	};

#ifndef _KERNEL

#define	IEEE80211_CHAN_TURBO	0x00000010 
#define	IEEE80211_CHAN_CCK	0x00000020 
#define	IEEE80211_CHAN_OFDM	0x00000040 
#define	IEEE80211_CHAN_2GHZ	0x00000080 
#define	IEEE80211_CHAN_5GHZ	0x00000100 
#define	IEEE80211_CHAN_PASSIVE	0x00000200 
#define	IEEE80211_CHAN_DYN	0x00000400 
#define	IEEE80211_CHAN_GFSK	0x00000800 
#define	IEEE80211_CHAN_GSM	0x00001000 
#define	IEEE80211_CHAN_STURBO	0x00002000 
#define	IEEE80211_CHAN_HALF	0x00004000 
#define	IEEE80211_CHAN_QUARTER	0x00008000 
#define	IEEE80211_CHAN_HT20	0x00010000 
#define	IEEE80211_CHAN_HT40U	0x00020000 
#define	IEEE80211_CHAN_HT40D	0x00040000 
#endif 

#define	IEEE80211_RADIOTAP_F_CFP	0x01	
#define	IEEE80211_RADIOTAP_F_SHORTPRE	0x02	
#define	IEEE80211_RADIOTAP_F_WEP	0x04	
#define	IEEE80211_RADIOTAP_F_FRAG	0x08	
#define	IEEE80211_RADIOTAP_F_FCS	0x10	
#define	IEEE80211_RADIOTAP_F_DATAPAD	0x20	
#define	IEEE80211_RADIOTAP_F_BADFCS	0x40	

#define IEEE80211_RADIOTAP_MCS_HAVE_BW          0x01
#define IEEE80211_RADIOTAP_MCS_HAVE_MCS         0x02
#define IEEE80211_RADIOTAP_MCS_HAVE_GI          0x04
#define IEEE80211_RADIOTAP_MCS_HAVE_FMT         0x08
#define IEEE80211_RADIOTAP_MCS_HAVE_FEC         0x10

#define IEEE80211_RADIOTAP_MCS_BW_MASK          0x03
#define IEEE80211_RADIOTAP_MCS_BW_20		0
#define IEEE80211_RADIOTAP_MCS_BW_40		1
#define IEEE80211_RADIOTAP_MCS_BW_20L		2
#define IEEE80211_RADIOTAP_MCS_BW_20U		3
#define IEEE80211_RADIOTAP_MCS_SGI              0x04
#define IEEE80211_RADIOTAP_MCS_FMT_GF           0x08
#define IEEE80211_RADIOTAP_MCS_FEC_LDPC         0x10

#define IEEE80211_RADIOTAP_MCS_BW_80		0x20
#define IEEE80211_RADIOTAP_MCS_BW_20LL		0x40
#define IEEE80211_RADIOTAP_MCS_BW_20LU		0x60
#define IEEE80211_RADIOTAP_MCS_BW_20UL		0x80
#define IEEE80211_RADIOTAP_MCS_BW_20UU		0xa0
#define IEEE80211_RADIOTAP_MCS_BW_40L		0xc0
#define IEEE80211_RADIOTAP_MCS_BW_40U		0xe0

#define IEEE80211_RADIOTAP_VHT_HAVE_STBC	0x0001
#define IEEE80211_RADIOTAP_VHT_HAVE_TXOP_PS	0x0002
#define IEEE80211_RADIOTAP_VHT_HAVE_GI		0x0004
#define IEEE80211_RADIOTAP_VHT_HAVE_SGI_NSYM_DA	0x0008
#define IEEE80211_RADIOTAP_VHT_HAVE_LDPC_EXTRA	0x0010
#define IEEE80211_RADIOTAP_VHT_HAVE_BF		0x0020
#define IEEE80211_RADIOTAP_VHT_HAVE_BW		0x0040
#define IEEE80211_RADIOTAP_VHT_HAVE_GID		0x0080
#define IEEE80211_RADIOTAP_VHT_HAVE_PAID	0x0100

#define IEEE80211_RADIOTAP_VHT_STBC		0x01
#define IEEE80211_RADIOTAP_VHT_TXOP_PS		0x02
#define IEEE80211_RADIOTAP_VHT_SGI		0x04
#define IEEE80211_RADIOTAP_VHT_SGI_NSYM_DA	0x08
#define IEEE80211_RADIOTAP_VHT_LDPC_EXTRA	0x10
#define IEEE80211_RADIOTAP_VHT_BF		0x20

#define IEEE80211_RADIOTAP_VHT_NSS		0x0f
#define IEEE80211_RADIOTAP_VHT_MCS		0xf0

#define IEEE80211_RADIOTAP_VHT_CODING_LDPC	0x01

#define IEEE80211_RADIOTAP_VHT_BW_20    	IEEE80211_RADIOTAP_MCS_BW_20
#define IEEE80211_RADIOTAP_VHT_BW_40    	IEEE80211_RADIOTAP_MCS_BW_40
#define IEEE80211_RADIOTAP_VHT_BW_20L   	IEEE80211_RADIOTAP_MCS_BW_20L
#define IEEE80211_RADIOTAP_VHT_BW_20U   	IEEE80211_RADIOTAP_MCS_BW_20U
#define IEEE80211_RADIOTAP_VHT_BW_80    	4
#define IEEE80211_RADIOTAP_VHT_BW_40L   	5
#define IEEE80211_RADIOTAP_VHT_BW_40U   	6
#define IEEE80211_RADIOTAP_VHT_BW_20LL		7
#define IEEE80211_RADIOTAP_VHT_BW_20LU		8
#define IEEE80211_RADIOTAP_VHT_BW_20UL		9
#define IEEE80211_RADIOTAP_VHT_BW_20UU		10
#define IEEE80211_RADIOTAP_VHT_BW_160		11
#define IEEE80211_RADIOTAP_VHT_BW_80L		12
#define IEEE80211_RADIOTAP_VHT_BW_80U		13
#define IEEE80211_RADIOTAP_VHT_BW_40LL		14
#define IEEE80211_RADIOTAP_VHT_BW_40LU		15
#define IEEE80211_RADIOTAP_VHT_BW_40UL		16
#define IEEE80211_RADIOTAP_VHT_BW_40UU		17
#define IEEE80211_RADIOTAP_VHT_BW_20LLL		18
#define IEEE80211_RADIOTAP_VHT_BW_20LLU		19
#define IEEE80211_RADIOTAP_VHT_BW_20LUL		20
#define IEEE80211_RADIOTAP_VHT_BW_20LUU		21
#define IEEE80211_RADIOTAP_VHT_BW_20ULL		22
#define IEEE80211_RADIOTAP_VHT_BW_20ULU		23
#define IEEE80211_RADIOTAP_VHT_BW_20UUL		24
#define IEEE80211_RADIOTAP_VHT_BW_20UUU		25

#define IEEE80211_RADIOTAP_TXF_FAIL	0x0001	
#define IEEE80211_RADIOTAP_TXF_CTS	0x0002	
#define IEEE80211_RADIOTAP_TXF_RTSCTS	0x0004	
#define IEEE80211_RADIOTAP_TXF_NOACK	0x0008	
#define IEEE80211_RADIOTAP_TXF_SEQOVR	0x0010	

#define IEEE80211_RADIOTAP_AMPDU_REPORT_ZEROLEN         0x0001
#define IEEE80211_RADIOTAP_AMPDU_IS_ZEROLEN             0x0002
#define IEEE80211_RADIOTAP_AMPDU_LAST_KNOWN             0x0004
#define IEEE80211_RADIOTAP_AMPDU_IS_LAST                0x0008
#define IEEE80211_RADIOTAP_AMPDU_DELIM_CRC_ERR          0x0010
#define IEEE80211_RADIOTAP_AMPDU_DELIM_CRC_KNOWN        0x0020
#define IEEE80211_RADIOTAP_AMPDU_MPDU_ONLY		0x8000

#endif 
