/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.ice4j.StackProperties;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.harvest.AwsCandidateHarvester;
import org.ice4j.ice.harvest.HarvestConfig;
import org.ice4j.ice.harvest.HostCandidateHarvester;
import org.ice4j.ice.harvest.MappingCandidateHarvester;
import org.ice4j.ice.harvest.StunMappingCandidateHarvester;
import org.jetbrains.annotations.NotNull;

public class MappingCandidateHarvesters {
    private static final Logger logger = Logger.getLogger(MappingCandidateHarvesters.class.getName());
    public static final String NAT_HARVESTER_LOCAL_ADDRESS_PNAME = "org.ice4j.ice.harvest.NAT_HARVESTER_LOCAL_ADDRESS";
    public static final String NAT_HARVESTER_PUBLIC_ADDRESS_PNAME = "org.ice4j.ice.harvest.NAT_HARVESTER_PUBLIC_ADDRESS";
    private static boolean initialized = false;
    private static MappingCandidateHarvester[] harvesters = new MappingCandidateHarvester[0];
    public static boolean stunDiscoveryFailed = false;

    public static MappingCandidateHarvester[] getHarvesters() {
        MappingCandidateHarvesters.initialize();
        return harvesters;
    }

    public static synchronized void initialize() {
        List<String> stunServers;
        boolean enableAwsHarvester2;
        if (initialized) {
            return;
        }
        initialized = true;
        long start = System.currentTimeMillis();
        List<MappingCandidateHarvester> harvesterList = new LinkedList<MappingCandidateHarvester>();
        String localAddressStr = StackProperties.getString(NAT_HARVESTER_LOCAL_ADDRESS_PNAME);
        String publicAddressStr = StackProperties.getString(NAT_HARVESTER_PUBLIC_ADDRESS_PNAME);
        if (localAddressStr != null && publicAddressStr != null) {
            TransportAddress localAddress = new TransportAddress(localAddressStr, 9, Transport.UDP);
            TransportAddress publicAddress = new TransportAddress(publicAddressStr, 9, Transport.UDP);
            harvesterList.add(new MappingCandidateHarvester(publicAddress, localAddress));
        }
        if ((enableAwsHarvester2 = HarvestConfig.config.enableAwsHarvester()) && (HarvestConfig.config.forceAwsHarvester() || AwsCandidateHarvester.smellsLikeAnEC2())) {
            logger.info("Using AwsCandidateHarvester.");
            harvesterList.add(new AwsCandidateHarvester());
        }
        if (!(stunServers = HarvestConfig.config.stunMappingCandidateHarvesterAddresses()).isEmpty()) {
            List<StunMappingCandidateHarvester> stunHarvesters = MappingCandidateHarvesters.createStunHarvesters(stunServers);
            stunDiscoveryFailed = stunHarvesters.isEmpty();
            harvesterList.addAll(stunHarvesters);
        }
        harvesterList = MappingCandidateHarvesters.prune(harvesterList);
        for (MappingCandidateHarvester harvester : harvesters = harvesterList.toArray(new MappingCandidateHarvester[harvesterList.size()])) {
            logger.info("Using " + harvester);
        }
        logger.info("Initialized mapping harvesters (delay=" + (System.currentTimeMillis() - start) + "ms).  stunDiscoveryFailed=" + stunDiscoveryFailed);
    }

    private static List<MappingCandidateHarvester> prune(List<MappingCandidateHarvester> harvesters) {
        LinkedList<MappingCandidateHarvester> pruned = new LinkedList<MappingCandidateHarvester>();
        for (MappingCandidateHarvester harvester : harvesters) {
            MappingCandidateHarvesters.maybeAdd(harvester, pruned);
        }
        return pruned;
    }

    private static void maybeAdd(MappingCandidateHarvester harvester, List<MappingCandidateHarvester> harvesters) {
        TransportAddress face = harvester.getFace();
        TransportAddress mask = harvester.getMask();
        if (face == null || mask == null || face.equals(mask)) {
            logger.info("Discarding a mapping harvester: " + harvester);
            return;
        }
        for (MappingCandidateHarvester h : harvesters) {
            if (!face.getAddress().equals(h.getFace().getAddress()) || !mask.getAddress().equals(h.getMask().getAddress())) continue;
            logger.info("Discarding a mapping harvester with duplicate addresses: " + harvester + ". Kept: " + h);
            return;
        }
        harvesters.add(harvester);
    }

    private static List<StunMappingCandidateHarvester> createStunHarvesters(@NotNull List<String> stunServers) {
        List futures;
        LinkedList<StunMappingCandidateHarvester> stunHarvesters = new LinkedList<StunMappingCandidateHarvester>();
        LinkedList<1> tasks = new LinkedList<1>();
        List<InetAddress> localAddresses = HostCandidateHarvester.getAllAllowedAddresses();
        for (String stunServer : stunServers) {
            int port;
            String[] addressAndPort = stunServer.split(":");
            if (addressAndPort.length < 2) {
                logger.severe("Failed to parse STUN server address: " + stunServer);
                continue;
            }
            try {
                port = Integer.parseInt(addressAndPort[1]);
            }
            catch (NumberFormatException nfe) {
                logger.severe("Invalid STUN server port: " + addressAndPort[1]);
                continue;
            }
            TransportAddress remoteAddress = new TransportAddress(addressAndPort[0], port, Transport.UDP);
            for (InetAddress localInetAddress : localAddresses) {
                if (localInetAddress instanceof Inet6Address) continue;
                TransportAddress localAddress = new TransportAddress(localInetAddress, 0, Transport.UDP);
                final StunMappingCandidateHarvester stunHarvester = new StunMappingCandidateHarvester(localAddress, remoteAddress);
                Callable<StunMappingCandidateHarvester> task = new Callable<StunMappingCandidateHarvester>(){

                    @Override
                    public StunMappingCandidateHarvester call() throws Exception {
                        stunHarvester.discover();
                        return stunHarvester;
                    }
                };
                tasks.add(task);
            }
        }
        ExecutorService es = Executors.newFixedThreadPool(tasks.size());
        try {
            futures = es.invokeAll(tasks);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return stunHarvesters;
        }
        for (Future future : futures) {
            try {
                StunMappingCandidateHarvester harvester = (StunMappingCandidateHarvester)future.get();
                if (harvester.getMask() == null) continue;
                stunHarvesters.add(harvester);
            }
            catch (ExecutionException harvester) {
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ie);
            }
        }
        return stunHarvesters;
    }

    private MappingCandidateHarvesters() {
    }
}

