/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.lang.ref.WeakReference;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.network.HttpMessage;

public class HttpMessageCachedData {
    private final String method;
    private final URI uri;
    private final String reason;
    private final int statusCode;
    private final int rtt;
    private final long timeSentMillis;
    private final int requestHeaderLength;
    private final int requestBodyLength;
    private final int responseHeaderLength;
    private final int responseBodyLength;
    private boolean note;
    private WeakReference<String> wrRequestBody;

    public HttpMessageCachedData(HttpMessage msg) {
        this.method = msg.getRequestHeader().getMethod();
        this.uri = msg.getRequestHeader().getURI();
        this.statusCode = msg.getResponseHeader().getStatusCode();
        this.reason = msg.getResponseHeader().getReasonPhrase();
        this.rtt = msg.getTimeElapsedMillis();
        this.note = msg.getNote() != null && msg.getNote().length() > 0;
        this.timeSentMillis = msg.getTimeSentMillis();
        this.requestHeaderLength = msg.getRequestHeader().toString().length();
        this.requestBodyLength = msg.getRequestBody().length();
        this.responseHeaderLength = msg.getResponseHeader().toString().length();
        this.responseBodyLength = msg.getResponseBody().length();
        this.wrRequestBody = new WeakReference<String>(msg.getRequestBody().toString());
    }

    public String getMethod() {
        return this.method;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getReason() {
        return this.reason;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getRtt() {
        return this.rtt;
    }

    public boolean hasNote() {
        return this.note;
    }

    public void setNote(boolean note) {
        this.note = note;
    }

    public long getTimeSentMillis() {
        return this.timeSentMillis;
    }

    public long getTimeReceivedMillis() {
        return this.timeSentMillis + (long)this.rtt;
    }

    public int getRequestHeaderLength() {
        return this.requestHeaderLength;
    }

    public int getRequestBodyLength() {
        return this.requestBodyLength;
    }

    public int getResponseHeaderLength() {
        return this.responseHeaderLength;
    }

    public int getResponseBodyLength() {
        return this.responseBodyLength;
    }

    public String getRequestBody() {
        return (String)this.wrRequestBody.get();
    }

    public void setRequestBody(String requestBody) {
        this.wrRequestBody.clear();
        this.wrRequestBody = new WeakReference<String>(requestBody);
    }
}

