/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.parser.HttpParser;

public class Host {
    private Host() {
    }

    public static int parse(MessageBytes messageBytes) {
        return Host.parse(new MessageBytesReader(messageBytes));
    }

    public static int parse(String string) {
        return Host.parse(new StringReader(string));
    }

    private static int parse(Reader reader) {
        try {
            reader.mark(1);
            int n = reader.read();
            reader.reset();
            if (HttpParser.isAlpha(n)) {
                return HttpParser.readHostDomainName(reader);
            }
            if (HttpParser.isNumeric(n)) {
                return HttpParser.readHostIPv4(reader, false);
            }
            if (91 == n) {
                return HttpParser.readHostIPv6(reader);
            }
            throw new IllegalArgumentException();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException);
        }
    }

    private static class MessageBytesReader
    extends Reader {
        private final byte[] bytes;
        private final int end;
        private int pos;
        private int mark;

        MessageBytesReader(MessageBytes messageBytes) {
            ByteChunk byteChunk = messageBytes.getByteChunk();
            this.bytes = byteChunk.getBytes();
            this.pos = byteChunk.getOffset();
            this.end = byteChunk.getEnd();
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            for (int i = n; i < n + n2; ++i) {
                cArray[i] = (char)(this.bytes[this.pos++] & 0xFF);
            }
            return n2;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public int read() throws IOException {
            if (this.pos < this.end) {
                return this.bytes[this.pos++] & 0xFF;
            }
            return -1;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int n) throws IOException {
            this.mark = this.pos;
        }

        @Override
        public void reset() throws IOException {
            this.pos = this.mark;
        }
    }
}

