# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_tokio_console_global_optspecs
	string join \n log= W/warn= A/allow= log-dir= lang= ascii-only= no-colors colorterm= palette= no-duration-colors= no-terminated-colors= retain-for= h/help V/version
end

function __fish_tokio_console_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_tokio_console_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_tokio_console_using_subcommand
	set -l cmd (__fish_tokio_console_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c tokio-console -n "__fish_tokio_console_needs_command" -l log -d 'Log level filter for the console\'s internal diagnostics' -r
complete -c tokio-console -n "__fish_tokio_console_needs_command" -s W -l warn -d 'Enable lint warnings' -r -f -a "{self-wakes\t'',lost-waker\t'',never-yielded\t'',auto-boxed-future\t'',large-future\t''}"
complete -c tokio-console -n "__fish_tokio_console_needs_command" -s A -l allow -d 'Allow lint warnings' -r
complete -c tokio-console -n "__fish_tokio_console_needs_command" -l log-dir -d 'Path to a directory to write the console\'s internal logs to' -r -f -a "(__fish_complete_directories)"
complete -c tokio-console -n "__fish_tokio_console_needs_command" -l lang -d 'Overrides the terminal\'s default language' -r
complete -c tokio-console -n "__fish_tokio_console_needs_command" -l ascii-only -d 'Explicitly use only ASCII characters' -r -f -a "{true\t'',false\t''}"
complete -c tokio-console -n "__fish_tokio_console_needs_command" -l colorterm -d 'Overrides the value of the `COLORTERM` environment variable' -r -f -a "{24bit\t'',truecolor\t''}"
complete -c tokio-console -n "__fish_tokio_console_needs_command" -l palette -d 'Explicitly set which color palette to use' -r -f -a "{8\t'',16\t'',256\t'',all\t'',off\t''}"
complete -c tokio-console -n "__fish_tokio_console_needs_command" -l no-duration-colors -d 'Disable color-coding for duration units' -r -f -a "{true\t'',false\t''}"
complete -c tokio-console -n "__fish_tokio_console_needs_command" -l no-terminated-colors -d 'Disable color-coding for terminated tasks' -r -f -a "{true\t'',false\t''}"
complete -c tokio-console -n "__fish_tokio_console_needs_command" -l retain-for -d 'How long to continue displaying completed tasks and dropped resources after they have been closed' -r
complete -c tokio-console -n "__fish_tokio_console_needs_command" -l no-colors -d 'Disable ANSI colors entirely'
complete -c tokio-console -n "__fish_tokio_console_needs_command" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c tokio-console -n "__fish_tokio_console_needs_command" -s V -l version -d 'Print version'
complete -c tokio-console -n "__fish_tokio_console_needs_command" -a "gen-config" -d 'Generate a `console.toml` config file with the default configuration values, overridden by any provided command-line arguments'
complete -c tokio-console -n "__fish_tokio_console_needs_command" -a "gen-completion" -d 'Generate shell completions'
complete -c tokio-console -n "__fish_tokio_console_needs_command" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c tokio-console -n "__fish_tokio_console_using_subcommand gen-config" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c tokio-console -n "__fish_tokio_console_using_subcommand gen-config" -s V -l version -d 'Print version'
complete -c tokio-console -n "__fish_tokio_console_using_subcommand gen-completion" -l install
complete -c tokio-console -n "__fish_tokio_console_using_subcommand gen-completion" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c tokio-console -n "__fish_tokio_console_using_subcommand gen-completion" -s V -l version -d 'Print version'
complete -c tokio-console -n "__fish_tokio_console_using_subcommand help; and not __fish_seen_subcommand_from gen-config gen-completion help" -f -a "gen-config" -d 'Generate a `console.toml` config file with the default configuration values, overridden by any provided command-line arguments'
complete -c tokio-console -n "__fish_tokio_console_using_subcommand help; and not __fish_seen_subcommand_from gen-config gen-completion help" -f -a "gen-completion" -d 'Generate shell completions'
complete -c tokio-console -n "__fish_tokio_console_using_subcommand help; and not __fish_seen_subcommand_from gen-config gen-completion help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
