/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.EndDeclaration;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import java.io.IOException;

public class End
extends ControlSequence {
    public End() {
        this("end");
    }

    public End(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new End(this.getName());
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        LaTeXParserListener laTeXParserListener = (LaTeXParserListener)teXParser.getListener();
        String string = this.popLabelString(teXParser, teXObjectList);
        if (teXParser.isDebugMode(4)) {
            teXParser.logMessage("END: " + string);
        }
        if (string.equals("document")) {
            laTeXParserListener.endDocument(teXObjectList);
            return;
        }
        this.doEnd(teXParser, teXObjectList, string);
        ControlSequence controlSequence = teXParser.getControlSequence("@currenvir");
        if (controlSequence == null) {
            throw new LaTeXSyntaxException(teXParser, "latex.error.extra_end", string);
        }
        String string2 = teXParser.expandToString(controlSequence, teXObjectList);
        teXParser.endGroup();
        if (!string.equals(string2)) {
            throw new LaTeXSyntaxException(teXParser, "latex.error.extra_end", string);
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    protected void doEnd(TeXParser teXParser, TeXObjectList teXObjectList, String string) throws IOException {
        ControlSequence controlSequence = teXParser.getListener().getControlSequence("end" + string);
        if (controlSequence instanceof EndDeclaration) {
            if (teXObjectList == teXParser || teXObjectList == null) {
                controlSequence.process(teXParser);
            } else {
                controlSequence.process(teXParser, teXObjectList);
            }
        } else {
            controlSequence = teXParser.getListener().getControlSequence(string);
            if (controlSequence instanceof Declaration) {
                ((Declaration)controlSequence).end(teXParser, teXObjectList);
            }
        }
    }
}

