/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.UndefAction;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import com.dickimawbooks.texparserlib.primitives.Undefined;
import java.io.IOException;

public class L2HUndefined
extends Undefined {
    public L2HUndefined() {
        this("undefined");
    }

    public L2HUndefined(String string) {
        this(string, UndefAction.ERROR);
    }

    public L2HUndefined(String string, UndefAction undefAction) {
        super(string, undefAction);
    }

    @Deprecated
    public L2HUndefined(String string, byte by) {
        super(string, by);
    }

    @Override
    public Object clone() {
        return new L2HUndefined(this.getName(), this.getAction());
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        if (teXParser.isMathMode() && l2HConverter.useMathJax()) {
            l2HConverter.write(this.toString(teXParser));
        } else {
            try {
                throw new TeXSyntaxException(teXParser, "tex.error.undefined", this.getName());
            }
            catch (TeXSyntaxException teXSyntaxException) {
                switch (this.getAction()) {
                    case ERROR: {
                        teXParser.error(teXSyntaxException);
                        break;
                    }
                    case WARN: {
                        teXParser.warning(teXSyntaxException);
                        break;
                    }
                    case MESSAGE: {
                        teXParser.message(teXSyntaxException);
                    }
                }
            }
        }
    }
}

