/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.html.EndElement;
import com.dickimawbooks.texparserlib.html.HtmlTag;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import com.dickimawbooks.texparserlib.html.StartElement;
import com.dickimawbooks.texparserlib.latex.Label;
import com.dickimawbooks.texparserlib.latex.Section;
import java.io.IOException;

public class L2HSection
extends Section {
    public static final String[][] TAGS = new String[][]{{"chapter", "h1"}, {"section", "h2"}, {"subsection", "h3"}, {"subsubsection", "h4"}, {"paragraph", "h5"}};

    public L2HSection() {
        this("section");
    }

    public L2HSection(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new L2HSection(this.getName());
    }

    protected String popLabel(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        TeXObject teXObject = teXParser == teXObjectList || teXObjectList == null ? teXParser.popStack() : teXObjectList.popStack(teXParser);
        while (teXObject != null && (teXObject instanceof WhiteSpace || teXObject.isPar())) {
            if (teXParser == teXObjectList || teXObjectList == null) {
                teXObject = teXParser.popStack();
                continue;
            }
            teXObject = teXObjectList.popStack(teXParser);
        }
        if ((teXObject = TeXParserUtils.resolve(teXObject, teXParser)) instanceof Label) {
            return this.popLabelString(teXParser, teXObjectList);
        }
        if (teXObjectList == null) {
            teXParser.push(teXObject);
        } else {
            teXObjectList.push(teXObject);
        }
        return null;
    }

    @Override
    protected void unnumbered(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        Object object;
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        String string = this.getTag();
        TeXObjectList teXObjectList2 = l2HConverter.createStack();
        ControlSequence controlSequence = teXParser.getControlSequence("theH" + this.getName() + "*");
        String string2 = null;
        if (controlSequence == null) {
            controlSequence = teXParser.getControlSequence("the" + this.getName() + "*");
        }
        if (controlSequence != null) {
            object = teXParser.expandToString(controlSequence, teXObjectList);
            String string3 = this.getName() + "*";
            string2 = this.popLabel(teXParser, teXObjectList);
            if (string2 == null) {
                string2 = HtmlTag.getUriFragment(string3 + "." + (String)object);
            }
            l2HConverter.stepcounter(string3);
        }
        l2HConverter.startSection(false, string, this.getName(), string2, teXObjectList);
        object = new StartElement(string == null ? "div" : string, true);
        if (string == null) {
            ((StartElement)object).putAttribute("class", this.getName());
        }
        teXObjectList2.add((TeXObject)object);
        teXObjectList2.add(new HtmlTag(String.format("<!-- start of %s header -->", this.getName())));
        teXObjectList2.add(teXObject);
        if (string2 != null) {
            teXObjectList2.add(l2HConverter.createLinkBox(string2));
        }
        teXObjectList2.add(new EndElement(string == null ? "div" : string));
        teXObjectList2.add(new HtmlTag(String.format("<!-- end of %s header -->%n", this.getName())));
        if (teXParser == teXObjectList || teXObjectList == null) {
            teXObjectList2.process(teXParser);
        } else {
            teXObjectList2.process(teXParser, teXObjectList);
        }
    }

    @Override
    protected void numbered(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject, TeXObject teXObject2) throws IOException {
        AbstractTeXObject abstractTeXObject;
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        TeXObjectList teXObjectList2 = new TeXObjectList();
        String string = this.getTag();
        String string2 = null;
        String string3 = this.popLabel(teXParser, teXObjectList);
        if (string3 != null) {
            string2 = HtmlTag.getUriFragment(string3);
        } else {
            abstractTeXObject = teXParser.getControlSequence("theH" + this.getName());
            if (abstractTeXObject == null) {
                abstractTeXObject = teXParser.getControlSequence("the" + this.getName());
            }
            if (abstractTeXObject != null) {
                String string4 = teXParser.expandToString(abstractTeXObject, teXObjectList);
                string2 = HtmlTag.getUriFragment(String.format("%s.%s", this.getName(), string4));
            }
        }
        l2HConverter.startSection(true, string, this.getName(), string2, teXObjectList);
        abstractTeXObject = new StartElement(string == null ? "div" : string, true);
        if (string == null) {
            ((StartElement)abstractTeXObject).putAttribute("class", this.getName());
        }
        teXObjectList2.add(abstractTeXObject);
        teXObjectList2.add(new HtmlTag(String.format("<!-- start of %s header -->", this.getName())));
        teXObjectList2.add(l2HConverter.getControlSequence("the" + this.getName()));
        teXObjectList2.add(l2HConverter.getOther(46));
        teXObjectList2.add(l2HConverter.getSpace());
        teXObjectList2.add(teXObject2);
        if (string2 != null) {
            teXObjectList2.add(l2HConverter.createLinkBox(string2));
        }
        teXObjectList2.add(new EndElement(string == null ? "div" : string));
        teXObjectList2.add(new HtmlTag(String.format("<!-- end of %s header -->%n", this.getName())));
        if (!TeXParser.isPar(teXObjectList.peekStack(TeXObjectList.POP_IGNORE_LEADING_SPACE))) {
            teXObjectList2.add(l2HConverter.getPar());
        }
        TeXParserUtils.process(teXObjectList2, teXParser, teXObjectList);
    }

    public String getTag() {
        return L2HSection.getTag(this.getName());
    }

    public static String getTag(String string) {
        for (int i = 0; i < TAGS.length; ++i) {
            if (!TAGS[i][0].equals(string)) continue;
            return TAGS[i][1];
        }
        return null;
    }

    public int getLevel() {
        return this.getLevel(this.getName());
    }

    public int getLevel(String string) {
        for (int i = 0; i < TAGS.length; ++i) {
            if (!TAGS[i][0].equals(string)) continue;
            return i;
        }
        return -1;
    }
}

