/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui.shapes;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.curve.opengl.TextRegionUtil;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.geom.plane.AffineTransform;
import com.jogamp.graph.ui.shapes.BaseButton;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.Vec2f;
import com.jogamp.opengl.math.Vec3f;
import com.jogamp.opengl.math.Vec4f;
import com.jogamp.opengl.math.geom.AABBox;
import jogamp.graph.ui.shapes.Label0;

public class Button
extends BaseButton {
    public static final float DEFAULT_SPACING_X = 0.12f;
    public static final float DEFAULT_SPACING_Y = 0.42f;
    private static final float DEFAULT_LABEL_ZOFFSET = 0.005f;
    private float labelZOffset = 0.005f;
    private final Label0 label;
    private float spacingX = 0.12f;
    private float spacingY = 0.42f;
    private final AffineTransform tempT1 = new AffineTransform();
    private final AffineTransform tempT2 = new AffineTransform();
    private final AffineTransform tempT3 = new AffineTransform();

    public Button(int n, Font font, String string, float f, float f2) {
        super(n | 0x200, f, f2);
        this.label = new Label0(font, string, new Vec4f(1.66f, 1.66f, 1.66f, 1.0f));
    }

    public Font getFont() {
        return this.label.getFont();
    }

    public String getLaben() {
        return this.label.getText();
    }

    @Override
    public void draw(GL2ES2 gL2ES2, RegionRenderer regionRenderer, int[] nArray) {
        super.draw(gL2ES2, regionRenderer, nArray);
    }

    @Override
    protected void addShapeToRegion(GLProfile gLProfile, GL2ES2 gL2ES2) {
        OutlineShape outlineShape = this.createBaseShape(FloatUtil.isZero(this.labelZOffset) ? 0.0f : -this.labelZOffset);
        this.box.resize(outlineShape.getBounds());
        this.setRotationPivot(this.box.getCenter());
        int[] nArray = Region.countOutlineShape(outlineShape, new int[2]);
        TextRegionUtil.countStringRegion(this.label.getFont(), this.label.getText(), nArray);
        this.resetGLRegion(gLProfile, gL2ES2, null, nArray[0], nArray[1]);
        this.region.addOutlineShape(outlineShape, null, this.rgbaColor);
        float f = this.box.getWidth() * (1.0f - this.spacingX);
        float f2 = this.box.getHeight() * (1.0f - this.spacingY);
        AABBox aABBox = this.label.getFont().getGlyphBounds(this.label.getText(), this.tempT1, this.tempT2);
        float f3 = f / aABBox.getWidth();
        float f4 = f2 / aABBox.getHeight();
        float f5 = f3 < f4 ? f3 : f4;
        AABBox aABBox2 = new AABBox(aABBox).scale2(f5);
        Vec3f vec3f = aABBox2.getCenter();
        Vec3f vec3f2 = this.box.getCenter();
        Vec2f vec2f = new Vec2f(vec3f2.x() - vec3f.x(), vec3f2.y() - vec3f.y());
        AABBox aABBox3 = this.label.addShapeToRegion(f5, this.region, vec2f, this.tempT1, this.tempT2, this.tempT3);
    }

    public float getLabelZOffset() {
        return this.labelZOffset;
    }

    public Button setLabelZOffset(float f) {
        this.labelZOffset = f;
        this.markShapeDirty();
        return this;
    }

    public final float getSpacingX() {
        return this.spacingX;
    }

    public final float getSpacingY() {
        return this.spacingY;
    }

    public final Button setSpacing(float f, float f2) {
        this.spacingX = f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
        this.spacingY = f2 < 0.0f ? 0.0f : (f2 > 1.0f ? 1.0f : f2);
        this.markShapeDirty();
        return this;
    }

    public final Vec4f getLabelColor() {
        return this.label.getColor();
    }

    public final Button setLabelColor(float f, float f2, float f3) {
        this.label.setColor(f, f2, f3, 1.0f);
        this.markShapeDirty();
        return this;
    }

    public final Button setFont(Font font) {
        if (!this.label.getFont().equals(font)) {
            this.label.setFont(font);
            this.markShapeDirty();
        }
        return this;
    }

    public final Button setLabel(String string) {
        if (!this.label.getText().equals(string)) {
            this.label.setText(string);
            this.markShapeDirty();
        }
        return this;
    }

    public final Button setLabel(Font font, String string) {
        if (!this.label.getText().equals(string) || !this.label.getFont().equals(font)) {
            this.label.setFont(font);
            this.label.setText(string);
            this.markShapeDirty();
        }
        return this;
    }

    @Override
    public String getSubString() {
        return super.getSubString() + ", " + this.label + ", spacing[" + this.spacingX + ", " + this.spacingY + "]";
    }
}

