/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.MagicImmune;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Momentum;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.PinCushion;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.RevealedArea;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.bags.Bag;
import com.shatteredpixel.shatteredpixeldungeon.items.bags.MagicalHolster;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.RingOfSharpshooting;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.SpiritBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.enchantments.Projecting;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.darts.Dart;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;
import java.util.ArrayList;

public abstract class MissileWeapon
extends Weapon {
    public boolean spawnedForEffect;
    protected boolean sticky;
    public static final float MAX_DURABILITY = 100.0f;
    protected float durability;
    protected float baseUses;
    public boolean holster;
    protected MissileWeapon parent;
    public int tier;
    private static final String SPAWNED = "spawned";
    private static final String DURABILITY = "durability";
    private static boolean bundleRestoring = false;

    public MissileWeapon() {
        this.stackable = true;
        this.levelKnown = true;
        this.bones = true;
        this.defaultAction = "THROW";
        this.usesTargeting = true;
        this.spawnedForEffect = false;
        this.sticky = true;
        this.durability = 100.0f;
        this.baseUses = 10.0f;
    }

    @Override
    public int min() {
        if (Dungeon.hero != null) {
            return Math.max(0, this.min(this.buffedLvl() + RingOfSharpshooting.levelDamageBonus(Dungeon.hero)));
        }
        return Math.max(0, this.min(this.buffedLvl()));
    }

    @Override
    public int min(int lvl) {
        return 2 * this.tier + (this.tier == 1 ? lvl : 2 * lvl);
    }

    @Override
    public int max() {
        if (Dungeon.hero != null) {
            return Math.max(0, this.max(this.buffedLvl() + RingOfSharpshooting.levelDamageBonus(Dungeon.hero)));
        }
        return Math.max(0, this.max(this.buffedLvl()));
    }

    @Override
    public int max(int lvl) {
        return 5 * this.tier + (this.tier == 1 ? 2 * lvl : this.tier * lvl);
    }

    @Override
    public int STRReq(int lvl) {
        return MissileWeapon.STRReq(this.tier, lvl) - 1;
    }

    @Override
    public int buffedLvl() {
        if (this.parent != null) {
            return this.parent.buffedLvl();
        }
        return super.buffedLvl();
    }

    @Override
    public Item upgrade() {
        if (!bundleRestoring) {
            this.durability = 100.0f;
            if (this.quantity > 1) {
                MissileWeapon upgraded = (MissileWeapon)this.split(1);
                upgraded.parent = null;
                if ((upgraded = (MissileWeapon)upgraded.upgrade()).quantity() == 1 && !upgraded.collect()) {
                    Dungeon.level.drop(upgraded, Dungeon.hero.pos);
                }
                MissileWeapon.updateQuickslot();
                return upgraded;
            }
            super.upgrade();
            Item similar = Dungeon.hero.belongings.getSimilar(this);
            if (similar != null) {
                this.detach(Dungeon.hero.belongings.backpack);
                Item result = similar.merge(this);
                MissileWeapon.updateQuickslot();
                return result;
            }
            MissileWeapon.updateQuickslot();
            return this;
        }
        return super.upgrade();
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.remove("EQUIP");
        return actions;
    }

    @Override
    public boolean collect(Bag container) {
        if (container instanceof MagicalHolster) {
            this.holster = true;
        }
        return super.collect(container);
    }

    @Override
    public boolean isSimilar(Item item) {
        return this.level() == item.level() && this.getClass() == item.getClass();
    }

    @Override
    public int throwPos(Hero user, int dst) {
        SpiritBow bow;
        boolean projecting = this.hasEnchant(Projecting.class, user);
        if (!(projecting || Random.Int(3) >= user.pointsInTalent(Talent.SHARED_ENCHANTMENT) || this instanceof Dart && ((Dart)this).crossbowHasEnchant(Dungeon.hero) || (bow = Dungeon.hero.belongings.getItem(SpiritBow.class)) == null || !bow.hasEnchant(Projecting.class, user))) {
            projecting = true;
        }
        if (projecting && (Dungeon.level.passable[dst] || Dungeon.level.avoid[dst] || Actor.findChar(dst) != null) && Dungeon.level.distance(user.pos, dst) <= Math.round(4.0f * Weapon.Enchantment.genericProcChanceMultiplier(user))) {
            return dst;
        }
        return super.throwPos(user, dst);
    }

    @Override
    public float accuracyFactor(Char owner, Char target) {
        float accFactor = super.accuracyFactor(owner, target);
        if (owner instanceof Hero && owner.buff(Momentum.class) != null && owner.buff(Momentum.class).freerunning()) {
            accFactor *= 1.0f + 0.2f * (float)((Hero)owner).pointsInTalent(Talent.PROJECTILE_MOMENTUM);
        }
        return accFactor *= this.adjacentAccFactor(owner, target);
    }

    protected float adjacentAccFactor(Char owner, Char target) {
        if (Dungeon.level.adjacent(owner.pos, target.pos)) {
            if (owner instanceof Hero) {
                return 0.5f + 0.2f * (float)((Hero)owner).pointsInTalent(Talent.POINT_BLANK);
            }
            return 0.5f;
        }
        return 1.5f;
    }

    @Override
    public void doThrow(Hero hero) {
        this.parent = null;
        super.doThrow(hero);
    }

    @Override
    protected void onThrow(int cell) {
        Char enemy = Actor.findChar(cell);
        if (enemy == null || enemy == curUser) {
            this.parent = null;
            if (curUser.hasTalent(Talent.SEER_SHOT) && MissileWeapon.curUser.heroClass != HeroClass.HUNTRESS && curUser.buff(Talent.SeerShotCooldown.class) == null && Actor.findChar(cell) == null) {
                RevealedArea a = Buff.affect(curUser, RevealedArea.class, 5 * curUser.pointsInTalent(Talent.SEER_SHOT));
                a.depth = Dungeon.depth;
                a.pos = cell;
                Buff.affect(curUser, Talent.SeerShotCooldown.class, 20.0f);
            }
            if (!this.spawnedForEffect) {
                super.onThrow(cell);
            }
        } else if (!curUser.shoot(enemy, this)) {
            this.rangedMiss(cell);
        } else {
            this.rangedHit(enemy, cell);
        }
    }

    @Override
    public int proc(Char attacker, Char defender, int damage) {
        SpiritBow bow;
        if (!(attacker != Dungeon.hero || Random.Int(3) >= Dungeon.hero.pointsInTalent(Talent.SHARED_ENCHANTMENT) || this instanceof Dart && ((Dart)this).crossbowHasEnchant(Dungeon.hero) || (bow = Dungeon.hero.belongings.getItem(SpiritBow.class)) == null || bow.enchantment == null || Dungeon.hero.buff(MagicImmune.class) != null)) {
            damage = bow.enchantment.proc(this, attacker, defender, damage);
        }
        return super.proc(attacker, defender, damage);
    }

    @Override
    public Item random() {
        if (!this.stackable) {
            return this;
        }
        this.quantity = 2;
        if (Random.Int(3) == 0) {
            ++this.quantity;
            if (Random.Int(5) == 0) {
                ++this.quantity;
            }
        }
        return this;
    }

    @Override
    public String status() {
        return Integer.toString(this.quantity);
    }

    @Override
    public float castDelay(Char user, int dst) {
        return this.delayFactor(user);
    }

    protected void rangedHit(Char enemy, int cell) {
        this.decrementDurability();
        if (this.durability > 0.0f && !this.spawnedForEffect) {
            if (this.sticky && enemy != null && enemy.isActive() && enemy.alignment != Char.Alignment.ALLY) {
                PinCushion p = Buff.affect(enemy, PinCushion.class);
                if (p.target == enemy) {
                    p.stick(this);
                    return;
                }
            }
            Dungeon.level.drop((Item)this, (int)cell).sprite.drop();
        }
    }

    protected void rangedMiss(int cell) {
        this.parent = null;
        if (!this.spawnedForEffect) {
            super.onThrow(cell);
        }
    }

    public float durabilityLeft() {
        return this.durability;
    }

    public void repair(float amount) {
        this.durability += amount;
        this.durability = Math.min(this.durability, 100.0f);
    }

    public float durabilityPerUse() {
        return this.durabilityPerUse(true);
    }

    protected final float durabilityPerUse(boolean rounded) {
        float usages = this.baseUses * (float)Math.pow(3.0, this.level());
        if (Dungeon.hero != null && Dungeon.hero.hasTalent(Talent.DURABLE_PROJECTILES)) {
            usages *= 1.25f + 0.25f * (float)Dungeon.hero.pointsInTalent(Talent.DURABLE_PROJECTILES);
        }
        if (this.holster) {
            usages *= 1.2f;
        }
        if (Dungeon.hero != null) {
            usages *= RingOfSharpshooting.durabilityMultiplier(Dungeon.hero);
        }
        if (usages >= 100.0f) {
            return 0.0f;
        }
        if (rounded) {
            usages = Math.round(usages);
            return 100.0f / usages + 0.001f;
        }
        return 100.0f / usages;
    }

    protected void decrementDurability() {
        if (this.parent != null) {
            if (this.parent.durability <= this.parent.durabilityPerUse()) {
                this.durability = 0.0f;
                this.parent.durability = 100.0f;
                if (this.parent.durabilityPerUse() < 100.0f) {
                    GLog.n(Messages.get(this, "has_broken", new Object[0]), new Object[0]);
                }
            } else {
                this.parent.durability -= this.parent.durabilityPerUse();
                if (this.parent.durability > 0.0f && this.parent.durability <= this.parent.durabilityPerUse()) {
                    GLog.w(Messages.get(this, "about_to_break", new Object[0]), new Object[0]);
                }
            }
            this.parent = null;
        } else {
            this.durability -= this.durabilityPerUse();
            if (this.durability > 0.0f && this.durability <= this.durabilityPerUse()) {
                GLog.w(Messages.get(this, "about_to_break", new Object[0]), new Object[0]);
            } else if (this.durabilityPerUse() < 100.0f && this.durability <= 0.0f) {
                GLog.n(Messages.get(this, "has_broken", new Object[0]), new Object[0]);
            }
        }
    }

    @Override
    public int damageRoll(Char owner) {
        int damage = this.augment.damageFactor(super.damageRoll(owner));
        if (owner instanceof Hero) {
            int exStr = ((Hero)owner).STR() - this.STRReq();
            if (exStr > 0) {
                damage += Hero.heroDamageIntRange(0, exStr);
            }
            if (owner.buff(Momentum.class) != null && owner.buff(Momentum.class).freerunning()) {
                damage = Math.round((float)damage * (1.0f + 0.15f * (float)((Hero)owner).pointsInTalent(Talent.PROJECTILE_MOMENTUM)));
            }
        }
        return damage;
    }

    @Override
    public void reset() {
        super.reset();
        this.durability = 100.0f;
    }

    @Override
    public Item merge(Item other) {
        super.merge(other);
        if (this.isSimilar(other)) {
            this.durability += ((MissileWeapon)other).durability;
            this.durability -= 100.0f;
            while (this.durability <= 0.0f) {
                --this.quantity;
                this.durability += 100.0f;
            }
        }
        return this;
    }

    @Override
    public Item split(int amount) {
        bundleRestoring = true;
        Item split = super.split(amount);
        bundleRestoring = false;
        if (split != null) {
            MissileWeapon m = (MissileWeapon)split;
            m.durability = 100.0f;
            m.parent = this;
        }
        return split;
    }

    @Override
    public boolean doPickUp(Hero hero, int pos) {
        this.parent = null;
        return super.doPickUp(hero, pos);
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    @Override
    public String info() {
        String info = super.info();
        info = info + "\n\n" + Messages.get(MissileWeapon.class, "stats", this.tier, Math.round(this.augment.damageFactor(this.min())), Math.round(this.augment.damageFactor(this.max())), this.STRReq());
        if (Dungeon.hero != null) {
            if (this.STRReq() > Dungeon.hero.STR()) {
                info = info + " " + Messages.get(Weapon.class, "too_heavy", new Object[0]);
            } else if (Dungeon.hero.STR() > this.STRReq()) {
                info = info + " " + Messages.get(Weapon.class, "excess_str", Dungeon.hero.STR() - this.STRReq());
            }
        }
        if (this.enchantment != null && (this.cursedKnown || !this.enchantment.curse())) {
            info = info + "\n\n" + Messages.get(Weapon.class, "enchanted", this.enchantment.name());
            info = info + " " + Messages.get(this.enchantment, "desc", new Object[0]);
        }
        if (this.cursed && this.isEquipped(Dungeon.hero)) {
            info = info + "\n\n" + Messages.get(Weapon.class, "cursed_worn", new Object[0]);
        } else if (this.cursedKnown && this.cursed) {
            info = info + "\n\n" + Messages.get(Weapon.class, "cursed", new Object[0]);
        } else if (!this.isIdentified() && this.cursedKnown) {
            info = info + "\n\n" + Messages.get(Weapon.class, "not_cursed", new Object[0]);
        }
        info = info + "\n\n" + Messages.get(MissileWeapon.class, "distance", new Object[0]);
        info = info + "\n\n" + Messages.get(this, DURABILITY, new Object[0]);
        info = this.durabilityPerUse() > 0.0f ? info + " " + Messages.get(this, "uses_left", (int)Math.ceil(this.durability / this.durabilityPerUse()), (int)Math.ceil(100.0f / this.durabilityPerUse())) : info + " " + Messages.get(this, "unlimited_uses", new Object[0]);
        return info;
    }

    @Override
    public int value() {
        return 6 * this.tier * this.quantity * (this.level() + 1);
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(SPAWNED, this.spawnedForEffect);
        bundle.put(DURABILITY, this.durability);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        bundleRestoring = true;
        super.restoreFromBundle(bundle);
        bundleRestoring = false;
        this.spawnedForEffect = bundle.getBoolean(SPAWNED);
        this.durability = bundle.getFloat(DURABILITY);
    }

    public static class PlaceHolder
    extends MissileWeapon {
        public PlaceHolder() {
            this.image = ItemSpriteSheet.MISSILE_HOLDER;
        }

        @Override
        public boolean isSimilar(Item item) {
            return item instanceof MissileWeapon;
        }

        @Override
        public String info() {
            return "";
        }
    }
}

