import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@smithy/types";
import {
  CloudFormationClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../CloudFormationClient";
import { ListStackSetsInput, ListStackSetsOutput } from "../models/models_0";
export { __MetadataBearer, $Command };
export interface ListStackSetsCommandInput extends ListStackSetsInput {}
export interface ListStackSetsCommandOutput
  extends ListStackSetsOutput,
    __MetadataBearer {}
export declare class ListStackSetsCommand extends $Command<
  ListStackSetsCommandInput,
  ListStackSetsCommandOutput,
  CloudFormationClientResolvedConfig
> {
  readonly input: ListStackSetsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: ListStackSetsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: CloudFormationClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<ListStackSetsCommandInput, ListStackSetsCommandOutput>;
  private serialize;
  private deserialize;
}
