[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit)](https://github.com/pre-commit/pre-commit)
[![Python-CI](https://github.com/pychess/pychess/actions/workflows/run-tests.yml/badge.svg)](https://github.com/pychess/pychess/actions/workflows/run-tests.yml)
[![codecov](https://codecov.io/gh/pychess/pychess/branch/master/graph/badge.svg)](https://codecov.io/gh/pychess/pychess)
[![Documentation Status](https://readthedocs.org/projects/pychess/badge/?version=latest)](http://pychess.readthedocs.org/en/latest/?badge=latest)

# PyChess - A Free Chess Client for Linux/Windows
Welcome to PyChess, a free and feature-rich chess client designed for Linux and Windows platforms. Whether you're a beginner looking for a quick game or an advanced player seeking to enhance your skills, PyChess has you covered.

## About PyChess
PyChess is a GTK chess client developed primarily for GNOME but compatible with various Linux desktop environments. The entire PyChess codebase, from the user interface to the chess engine, is written in Python and released under the GNU Public License.

## Goals of PyChess
Provide an advanced chess client for Linux following the GNOME Human Interface Guidelines.
Offer a user-friendly interface suitable for both beginners and experienced players.
Allow users to play against the computer, find the best moves with Hint Mode, and access a range of chess engines.

## Features
PyChess boasts a wide array of features to enhance your chess experience:

* Support for UCI and CECP chess engines with 8 different difficulty levels.
* Built-in Python chess engine.
* Online play on FICS (Free Internet Chess Server) with Timeseal support.
* Online play on ICC (Internet Chess Club) with timestamp support.
* Resizable chess board, "pre-drag" support, move and capture sounds, and animations.
* Compatibility with PGN, EPD, and FEN chess file formats.
* Undo, pause, and resume games.
* Various chess variants, including Atomic, Crazyhouse, Fischer Random (Chess 960), and more.
* Built-in opening book.
* Hint Mode arrows indicating the best move based on the chosen analysis engine.
* Compliance with the GNOME Human Interface Guidelines.

## Getting Started
### Installation
To install PyChess, follow these steps:

* Visit the PyChess Download Page on GitHub.
* Download the latest release suitable for your platform (Linux or Windows).
* Follow the installation instructions provided for your specific operating system.

### Running PyChess
Once installed, you can run PyChess as follows:

* Linux: Launch PyChess from your application menu or execute pychess in the terminal.
* Windows: Double-click the PyChess executable.

### Playing Chess
* To play a game against the computer, select "New Game" and configure the options as desired.
* For online play, you can log in to FICS or ICC and enjoy games with players from around the world.

## Community and Support
* Visit the [PyChess Project Homepage](https://pychess.github.io/) for project updates and news.
* Contribute to translations on [Transifex](https://www.transifex.com/projects/p/pychess/).
* Join the [PyChess Mailing List](http://groups.google.com/group/pychess-people) to connect with other PyChess enthusiasts.
* Engage in real-time discussions on the [PyChess Discord Chat](https://discord.gg/aPs8RKr). 

## Contributions
PyChess is an open-source project, and contributions are welcome! Whether you want to improve the code, translate the software, or help with documentation, your contributions are valued.

## License
PyChess is released under the GNU Public License. For more details, refer to the project's License Information.
