/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.corba.TypeCodeImpl;
import com.sun.corba.ee.impl.encoding.BufferManagerWrite;
import com.sun.corba.ee.impl.encoding.CDROutputStreamBase;
import com.sun.corba.ee.impl.encoding.CodeSetConversion;
import com.sun.corba.ee.impl.javax.rmi.CORBA.Util;
import com.sun.corba.ee.impl.misc.CacheTable;
import com.sun.corba.ee.impl.misc.ClassInfoCache;
import com.sun.corba.ee.impl.misc.ORBUtility;
import com.sun.corba.ee.impl.misc.RepositoryIdFactory;
import com.sun.corba.ee.impl.misc.RepositoryIdStrings;
import com.sun.corba.ee.impl.misc.RepositoryIdUtility;
import com.sun.corba.ee.impl.util.Utility;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.IORFactories;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ClassCodeBaseHandler;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBVersionFactory;
import com.sun.corba.ee.spi.trace.CdrWrite;
import com.sun.corba.ee.spi.trace.PrimitiveWrite;
import com.sun.corba.ee.spi.transport.ByteBufferPool;
import com.sun.org.omg.CORBA.portable.ValueHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.rmi.CORBA.EnumDesc;
import javax.rmi.CORBA.ProxyDesc;
import javax.rmi.CORBA.ValueHandler;
import javax.rmi.CORBA.ValueHandlerMultiFormat;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;
import org.omg.CORBA.Any;
import org.omg.CORBA.CustomMarshal;
import org.omg.CORBA.DataOutputStream;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;

@CdrWrite
@PrimitiveWrite
public class CDROutputStream_1_0
extends CDROutputStreamBase {
    private static final int INDIRECTION_TAG = -1;
    private static final boolean BIG_ENDIAN = false;
    protected BufferManagerWrite bufferManagerWrite;
    ByteBuffer byteBuffer;
    protected ORB orb;
    protected static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    protected int blockSizeIndex = -1;
    protected int blockSizePosition = 0;
    protected byte streamFormatVersion;
    private static final String kWriteMethod = "write";
    Map<String, Map<String, EnumDesc>> enumCache = null;
    private Map<String, Integer> codebaseCache = null;
    private CacheTable<java.lang.Object> valueCache = null;
    private CacheTable<String> repositoryIdCache = null;
    private int end_flag = 0;
    private int chunkedValueNestingLevel = 0;
    private boolean mustChunk = false;
    protected boolean inBlock = false;
    private int end_flag_position = 0;
    private int end_flag_index = 0;
    private ValueHandler valueHandler = null;
    private RepositoryIdUtility repIdUtil;
    private RepositoryIdStrings repIdStrs;
    private CodeSetConversion.CTBConverter charConverter;
    private CodeSetConversion.CTBConverter wcharConverter;
    private static final String _id = "IDL:omg.org/CORBA/DataOutputStream:1.0";
    private static final String[] _ids = new String[]{"IDL:omg.org/CORBA/DataOutputStream:1.0"};

    @Override
    public void init(org.omg.CORBA.ORB orb, BufferManagerWrite bufferManager, byte streamFormatVersion, boolean usePooledByteBuffers) {
        this.orb = (ORB)orb;
        this.bufferManagerWrite = bufferManager;
        this.byteBuffer = CDROutputStream_1_0.allocateBuffer(orb, bufferManager, usePooledByteBuffers);
        this.byteBuffer.position(0);
        this.streamFormatVersion = streamFormatVersion;
        this.createRepositoryIdHandlers();
    }

    static ByteBuffer allocateBuffer(org.omg.CORBA.ORB orb, BufferManagerWrite bufferManager, boolean usePooledByteBuffers) {
        ByteBuffer buffer;
        int bufferSize = bufferManager.getBufferSize();
        if (usePooledByteBuffers) {
            ByteBufferPool byteBufferPool = ((ORB)orb).getByteBufferPool();
            buffer = byteBufferPool.getByteBuffer(bufferSize);
        } else {
            buffer = ByteBuffer.allocate(bufferSize);
        }
        buffer.limit(bufferSize);
        return buffer;
    }

    private void createRepositoryIdHandlers() {
        this.repIdUtil = RepositoryIdFactory.getRepIdUtility();
        this.repIdStrs = RepositoryIdFactory.getRepIdStringsFactory();
    }

    @Override
    public BufferManagerWrite getBufferManager() {
        return this.bufferManagerWrite;
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(0);
    }

    @Override
    protected byte[] toByteArray(int start) {
        byte[] it = new byte[this.byteBuffer.position() - start];
        this.byteBuffer.position(start);
        this.byteBuffer.get(it);
        return it;
    }

    @Override
    public GIOPVersion getGIOPVersion() {
        return GIOPVersion.V1_0;
    }

    @Override
    void setHeaderPadding(boolean headerPadding) {
        throw wrapper.giopVersionError();
    }

    @CdrWrite
    protected void handleSpecialChunkBegin(int requiredSize) {
    }

    @CdrWrite
    protected void handleSpecialChunkEnd() {
    }

    protected final int computeAlignment(int align) {
        int incr;
        if (align > 1 && (incr = this.byteBuffer.position() & align - 1) != 0) {
            return align - incr;
        }
        return 0;
    }

    protected void alignAndReserve(int align, int n) {
        this.byteBuffer.position(this.byteBuffer.position() + this.computeAlignment(align));
        if (this.byteBuffer.position() + n > this.byteBuffer.limit()) {
            this.grow(align, n);
        }
    }

    protected void grow(int align, int n) {
        this.byteBuffer = this.bufferManagerWrite.overflow(this.byteBuffer, n);
    }

    @Override
    public final void putEndian() throws SystemException {
        this.write_boolean(false);
    }

    @Override
    void freeInternalCaches() {
        if (this.codebaseCache != null) {
            this.codebaseCache.clear();
        }
        this.freeValueCache();
        if (this.repositoryIdCache != null) {
            this.repositoryIdCache.done();
        }
    }

    @Override
    @PrimitiveWrite
    public void write_octet(byte x) {
        this.alignAndReserve(1, 1);
        this.byteBuffer.put(x);
    }

    @Override
    public final void write_boolean(boolean x) {
        this.write_octet(x ? (byte)1 : 0);
    }

    @Override
    public void write_char(char x) {
        CodeSetConversion.CTBConverter converter = this.getCharConverter();
        converter.convert(x);
        if (converter.getNumBytes() > 1) {
            throw wrapper.invalidSingleCharCtb();
        }
        this.write_octet(converter.getBytes()[0]);
    }

    private void writeBigEndianWchar(char x) {
        this.byteBuffer.put((byte)(x >>> 8 & 0xFF));
        this.byteBuffer.put((byte)(x & 0xFF));
    }

    @Override
    @PrimitiveWrite
    public void write_wchar(char x) {
        if (ORBUtility.isForeignORB(this.orb)) {
            throw wrapper.wcharDataInGiop10();
        }
        this.alignAndReserve(2, 2);
        this.writeBigEndianWchar(x);
    }

    @Override
    @PrimitiveWrite
    public void write_short(short x) {
        this.alignAndReserve(2, 2);
        this.byteBuffer.putShort(x);
    }

    @Override
    public final void write_ushort(short x) {
        this.write_short(x);
    }

    @Override
    @PrimitiveWrite
    public void write_long(int x) {
        this.alignAndReserve(4, 4);
        this.byteBuffer.putInt(x);
    }

    @Override
    public final void write_ulong(int x) {
        this.write_long(x);
    }

    @Override
    @PrimitiveWrite
    public void write_longlong(long x) {
        this.alignAndReserve(8, 8);
        this.byteBuffer.putLong(x);
    }

    @Override
    public final void write_ulonglong(long x) {
        this.write_longlong(x);
    }

    @Override
    public final void write_float(float x) {
        this.write_long(Float.floatToIntBits(x));
    }

    @Override
    public final void write_double(double x) {
        this.write_longlong(Double.doubleToLongBits(x));
    }

    @Override
    public void write_string(String value) {
        this.writeString(value);
    }

    @PrimitiveWrite
    protected int writeString(String value) {
        if (value == null) {
            throw wrapper.nullParam();
        }
        CodeSetConversion.CTBConverter converter = this.getCharConverter();
        converter.convert(value);
        int len = converter.getNumBytes() + 1;
        this.handleSpecialChunkBegin(this.computeAlignment(4) + 4 + len);
        this.write_long(len);
        int indirection = this.get_offset() - 4;
        this.internalWriteOctetArray(converter.getBytes(), 0, converter.getNumBytes());
        this.write_octet((byte)0);
        this.handleSpecialChunkEnd();
        return indirection;
    }

    @Override
    public void write_wstring(String value) {
        if (value == null) {
            throw wrapper.nullParam();
        }
        if (ORBUtility.isForeignORB(this.orb)) {
            throw wrapper.wcharDataInGiop10();
        }
        int len = value.length() + 1;
        this.handleSpecialChunkBegin(4 + len * 2 + this.computeAlignment(4));
        this.write_long(len);
        for (int i = 0; i < len - 1; ++i) {
            this.write_wchar(value.charAt(i));
        }
        this.write_short((short)0);
        this.handleSpecialChunkEnd();
    }

    void internalWriteOctetArray(byte[] value, int offset, int length) {
        int count;
        if (length == 0) {
            return;
        }
        this.alignAndReserve(1, 1);
        for (int numWritten = 0; numWritten < length; numWritten += count) {
            if (!this.byteBuffer.hasRemaining()) {
                this.alignAndReserve(1, 1);
            }
            count = Math.min(length - numWritten, this.byteBuffer.remaining());
            this.byteBuffer.put(value, offset + numWritten, count);
        }
    }

    @Override
    public final void write_octet_array(byte[] b, int offset, int length) {
        if (b == null) {
            throw wrapper.nullParam();
        }
        this.handleSpecialChunkBegin(length);
        this.internalWriteOctetArray(b, offset, length);
        this.handleSpecialChunkEnd();
    }

    @Override
    public void write_Principal(Principal p) {
        this.write_long(p.name().length);
        this.write_octet_array(p.name(), 0, p.name().length);
    }

    @Override
    @CdrWrite
    public void write_any(Any any) {
        if (any == null) {
            throw wrapper.nullParam();
        }
        this.write_TypeCode(any.type());
        any.write_value((org.omg.CORBA.portable.OutputStream)this.parent);
    }

    @Override
    @CdrWrite
    public void write_TypeCode(TypeCode tc) {
        if (tc == null) {
            throw wrapper.nullParam();
        }
        TypeCodeImpl tci = tc instanceof TypeCodeImpl ? (TypeCodeImpl)tc : new TypeCodeImpl(this.orb, tc);
        tci.write_value(this.parent);
    }

    @Override
    @CdrWrite
    public void write_Object(Object ref) {
        if (ref == null) {
            IOR nullIOR = IORFactories.makeIOR(this.orb);
            nullIOR.write(this.parent);
            return;
        }
        if (ref instanceof LocalObject) {
            throw wrapper.writeLocalObject();
        }
        IOR ior = this.orb.getIOR(ref, true);
        ior.write(this.parent);
    }

    @Override
    @CdrWrite
    public void write_abstract_interface(java.lang.Object obj) {
        boolean corbaObject = false;
        Object theObject = null;
        if (obj != null && obj instanceof Object) {
            theObject = (Object)obj;
            corbaObject = true;
        }
        this.write_boolean(corbaObject);
        if (corbaObject) {
            this.write_Object(theObject);
        } else {
            try {
                this.write_value((Serializable)obj);
            }
            catch (ClassCastException cce) {
                if (obj instanceof Serializable) {
                    throw cce;
                }
                ORBUtility.throwNotSerializableForCorba(obj.getClass().getName());
            }
        }
    }

    @Override
    @CdrWrite
    public void write_value(Serializable object, Class clz) {
        this.write_value(object);
    }

    @CdrWrite
    private void startValueChunk(boolean useChunking) {
        if (useChunking) {
            this.start_block();
            --this.chunkedValueNestingLevel;
        }
        --this.end_flag;
    }

    @CdrWrite
    private void endValueChunk(boolean useChunking) {
        if (useChunking) {
            this.end_block();
        }
        this.writeEndTag(useChunking);
    }

    private void writeWStringValue(String string) {
        int indirection = this.writeValueTag(this.mustChunk, true, null);
        this.write_repositoryId(this.repIdStrs.getWStringValueRepId());
        this.updateIndirectionTable(indirection, string);
        this.startValueChunk(this.mustChunk);
        this.write_wstring(string);
        this.endValueChunk(this.mustChunk);
    }

    private String getCodebase(Class cls) {
        String result;
        ClassCodeBaseHandler ccbh = this.orb.classCodeBaseHandler();
        if (ccbh != null && (result = ccbh.getCodeBase(cls)) != null) {
            return result;
        }
        return Util.getInstance().getCodebase(cls);
    }

    @CdrWrite
    private void writeArray(Serializable array, Class clazz) {
        if (this.valueHandler == null) {
            this.valueHandler = ORBUtility.createValueHandler();
        }
        int indirection = this.writeValueTag(this.mustChunk, true, this.getCodebase(clazz));
        this.write_repositoryId(this.repIdStrs.createSequenceRepID(clazz));
        this.updateIndirectionTable(indirection, array);
        this.callWriteValue((org.omg.CORBA.portable.OutputStream)this.parent, array, this.streamFormatVersion);
    }

    @CdrWrite
    private void writeValueBase(ValueBase object, Class clazz) {
        this.mustChunk = true;
        int indirection = this.writeValueTag(true, true, this.getCodebase(clazz));
        String repId = object._truncatable_ids()[0];
        this.write_repositoryId(repId);
        this.updateIndirectionTable(indirection, object);
        this.startValueChunk(true);
        this.writeIDLValue((Serializable)object, repId);
        this.endValueChunk(true);
    }

    @CdrWrite
    private void writeRMIIIOPValueType(Serializable object, Class clazz, ClassInfoCache.ClassInfo cinfo) {
        Serializable key;
        if (this.valueHandler == null) {
            this.valueHandler = ORBUtility.createValueHandler();
        }
        if ((object = this.valueHandler.writeReplace(key = object)) != key) {
            if (object == null) {
                this.write_long(0);
                return;
            }
            if (this.writeIndirectionIfPossible(object)) {
                return;
            }
            clazz = object.getClass();
        }
        this.mustChunk |= this.valueHandler.isCustomMarshaled((Class)clazz);
        int indirection = this.writeValueTag(this.mustChunk, true, this.getCodebase(clazz));
        this.write_repositoryId(this.repIdStrs.createForJavaType(clazz, cinfo));
        this.updateIndirectionTable(indirection, key);
        if (object != key) {
            this.updateIndirectionTable(indirection, object);
        }
        this.callWriteValue((org.omg.CORBA.portable.OutputStream)this.parent, object, this.streamFormatVersion);
    }

    @CdrWrite
    private void callWriteValue(org.omg.CORBA.portable.OutputStream parent, Serializable object, byte streamFormatVersion) {
        if (this.valueHandler == null) {
            this.valueHandler = ORBUtility.createValueHandler();
        }
        boolean currentMustChunk = this.mustChunk;
        this.startValueChunk(currentMustChunk);
        if (this.valueHandler instanceof ValueHandlerMultiFormat) {
            ValueHandlerMultiFormat vh = (ValueHandlerMultiFormat)this.valueHandler;
            vh.writeValue(parent, object, streamFormatVersion);
        } else {
            this.valueHandler.writeValue(parent, object);
        }
        this.endValueChunk(currentMustChunk);
    }

    private EnumDesc getEnumDesc(String className, String enumValue) {
        EnumDesc result = null;
        Map<String, EnumDesc> map = null;
        if (this.enumCache == null) {
            this.enumCache = new HashMap<String, Map<String, EnumDesc>>();
        } else {
            map = this.enumCache.get(className);
        }
        if (map == null) {
            map = new HashMap<String, EnumDesc>();
            this.enumCache.put(className, map);
        } else {
            result = map.get(enumValue);
        }
        if (result == null) {
            result = new EnumDesc();
            result.className = className;
            result.value = enumValue;
            map.put(enumValue, result);
        }
        return result;
    }

    @Override
    @CdrWrite
    public void write_value(Serializable object, String repository_id) {
        if (object == null) {
            this.write_long(0);
            return;
        }
        Class<?> clazz = object.getClass();
        ClassInfoCache.ClassInfo cinfo = ClassInfoCache.get(clazz);
        if (cinfo.isEnum()) {
            String enumValue = ((Enum)((java.lang.Object)object)).name();
            if (this.orb.getORBData().useEnumDesc()) {
                EnumDesc desc = this.getEnumDesc(clazz.getName(), enumValue);
                this.write_value((Serializable)desc, (String)null);
            } else {
                this.mustChunk = false;
                int indirection = this.writeValueTag(this.mustChunk, true, this.getCodebase(clazz));
                this.write_repositoryId(this.repIdStrs.createForJavaType(clazz, cinfo));
                this.updateIndirectionTable(indirection, object);
                this.writeString(enumValue);
            }
            return;
        }
        if (cinfo.isProxyClass()) {
            Class<?>[] ifaces = clazz.getInterfaces();
            ProxyDesc pd = new ProxyDesc();
            pd.interfaces = new String[ifaces.length];
            for (int i = 0; i < ifaces.length; ++i) {
                pd.interfaces[i] = ifaces[i].getName();
            }
            pd.handler = Proxy.getInvocationHandler(object);
            pd.codebase = this.getCodebase(object.getClass());
            this.write_value((Serializable)pd, (String)null);
            return;
        }
        if (this.writeIndirectionIfPossible(object)) {
            return;
        }
        boolean oldMustChunk = this.mustChunk;
        if (this.inBlock) {
            this.end_block();
        }
        if (cinfo.isArray()) {
            this.writeArray(object, clazz);
        } else if (cinfo.isAValueBase(clazz)) {
            this.writeValueBase((ValueBase)object, clazz);
        } else if (cinfo.isAIDLEntity(clazz) && !cinfo.isACORBAObject(clazz)) {
            this.writeIDLEntity((IDLEntity)object);
        } else if (cinfo.isAString(clazz)) {
            this.writeWStringValue((String)((java.lang.Object)object));
        } else if (cinfo.isAClass(clazz)) {
            ClassInfoCache.ClassInfo lcinfo = ClassInfoCache.get((Class)object);
            this.writeClass(repository_id, (Class)object, lcinfo);
        } else {
            this.writeRMIIIOPValueType(object, clazz, cinfo);
        }
        this.mustChunk = oldMustChunk;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    @Override
    public void write_value(Serializable object) {
        this.write_value(object, (String)null);
    }

    @Override
    @CdrWrite
    public void write_value(Serializable object, BoxedValueHelper factory) {
        if (object == null) {
            this.write_long(0);
            return;
        }
        if (this.writeIndirectionIfPossible(object)) {
            return;
        }
        boolean oldMustChunk = this.mustChunk;
        boolean isCustom = this.isCustom(object, factory);
        if (this.mustChunk && this.inBlock) {
            this.end_block();
        }
        int indirection = this.writeValueTag(this.mustChunk, this.orb.getORBData().useRepId(), this.getCodebase(object.getClass()));
        if (this.orb.getORBData().useRepId()) {
            this.write_repositoryId(factory.get_id());
        }
        this.updateIndirectionTable(indirection, object);
        boolean currentMustChunk = this.mustChunk;
        this.startValueChunk(currentMustChunk);
        if (this.mustChunk && isCustom) {
            ((CustomMarshal)object).marshal((DataOutputStream)this.parent);
        } else {
            factory.write_value((org.omg.CORBA.portable.OutputStream)this.parent, object);
        }
        this.endValueChunk(currentMustChunk);
        this.mustChunk = oldMustChunk;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    private boolean isCustom(Serializable object, BoxedValueHelper factory) {
        boolean isCustom = false;
        if (factory instanceof ValueHelper) {
            short modifier = this.getTypeModifier((ValueHelper)factory);
            if (object instanceof CustomMarshal && modifier == 1) {
                isCustom = true;
                this.mustChunk = true;
            } else if (modifier == 3) {
                this.mustChunk = true;
            }
        }
        return isCustom;
    }

    private short getTypeModifier(ValueHelper factory) {
        short modifier;
        try {
            modifier = factory.get_type().type_modifier();
        }
        catch (BadKind ex) {
            modifier = 0;
        }
        return modifier;
    }

    public int get_offset() {
        return this.byteBuffer.position();
    }

    @Override
    @CdrWrite
    public void start_block() {
        this.write_long(0);
        this.inBlock = true;
        this.blockSizePosition = this.get_offset();
        this.blockSizeIndex = this.byteBuffer.position();
    }

    protected void writeLongWithoutAlign(int x) {
        this.byteBuffer.putInt(x);
    }

    @InfoMethod
    private void inABlock() {
    }

    @InfoMethod
    private void blockSizePosition(int blockSize) {
    }

    @InfoMethod
    private void removingZeroLengthBlock() {
    }

    @Override
    @CdrWrite
    public void end_block() {
        if (!this.inBlock) {
            return;
        }
        this.inABlock();
        this.inBlock = false;
        this.blockSizePosition(this.blockSizePosition);
        if (this.get_offset() == this.blockSizePosition) {
            this.removingZeroLengthBlock();
            this.byteBuffer.position(this.byteBuffer.position() - 4);
            this.blockSizeIndex = -1;
            this.blockSizePosition = -1;
            return;
        }
        int oldSize = this.byteBuffer.position();
        this.byteBuffer.position(this.blockSizeIndex - 4);
        this.writeLongWithoutAlign(oldSize - this.blockSizeIndex);
        this.byteBuffer.position(oldSize);
        this.blockSizeIndex = -1;
        this.blockSizePosition = -1;
    }

    @Override
    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    @Override
    @CdrWrite
    public final void write_boolean_array(boolean[] value, int offset, int length) {
        if (value == null) {
            throw wrapper.nullParam();
        }
        this.handleSpecialChunkBegin(length);
        for (int i = 0; i < length; ++i) {
            this.write_boolean(value[offset + i]);
        }
        this.handleSpecialChunkEnd();
    }

    @Override
    @CdrWrite
    public final void write_char_array(char[] value, int offset, int length) {
        if (value == null) {
            throw wrapper.nullParam();
        }
        this.handleSpecialChunkBegin(length);
        for (int i = 0; i < length; ++i) {
            this.write_char(value[offset + i]);
        }
        this.handleSpecialChunkEnd();
    }

    @Override
    @CdrWrite
    public void write_wchar_array(char[] value, int offset, int length) {
        if (value == null) {
            throw wrapper.nullParam();
        }
        this.handleSpecialChunkBegin(this.computeAlignment(2) + length * 2);
        for (int i = 0; i < length; ++i) {
            this.write_wchar(value[offset + i]);
        }
        this.handleSpecialChunkEnd();
    }

    @Override
    @CdrWrite
    public final void write_short_array(short[] value, int offset, int length) {
        if (value == null) {
            throw wrapper.nullParam();
        }
        this.handleSpecialChunkBegin(this.computeAlignment(2) + length * 2);
        for (int i = 0; i < length; ++i) {
            this.write_short(value[offset + i]);
        }
        this.handleSpecialChunkEnd();
    }

    @Override
    public final void write_ushort_array(short[] value, int offset, int length) {
        this.write_short_array(value, offset, length);
    }

    @Override
    @CdrWrite
    public final void write_long_array(int[] value, int offset, int length) {
        if (value == null) {
            throw wrapper.nullParam();
        }
        this.handleSpecialChunkBegin(this.computeAlignment(4) + length * 4);
        for (int i = 0; i < length; ++i) {
            this.write_long(value[offset + i]);
        }
        this.handleSpecialChunkEnd();
    }

    @Override
    public final void write_ulong_array(int[] value, int offset, int length) {
        this.write_long_array(value, offset, length);
    }

    @Override
    @CdrWrite
    public final void write_longlong_array(long[] value, int offset, int length) {
        if (value == null) {
            throw wrapper.nullParam();
        }
        this.handleSpecialChunkBegin(this.computeAlignment(8) + length * 8);
        for (int i = 0; i < length; ++i) {
            this.write_longlong(value[offset + i]);
        }
        this.handleSpecialChunkEnd();
    }

    @Override
    public final void write_ulonglong_array(long[] value, int offset, int length) {
        this.write_longlong_array(value, offset, length);
    }

    @Override
    @CdrWrite
    public final void write_float_array(float[] value, int offset, int length) {
        if (value == null) {
            throw wrapper.nullParam();
        }
        this.handleSpecialChunkBegin(this.computeAlignment(4) + length * 4);
        for (int i = 0; i < length; ++i) {
            this.write_float(value[offset + i]);
        }
        this.handleSpecialChunkEnd();
    }

    @Override
    @CdrWrite
    public final void write_double_array(double[] value, int offset, int length) {
        if (value == null) {
            throw wrapper.nullParam();
        }
        this.handleSpecialChunkBegin(this.computeAlignment(8) + length * 8);
        for (int i = 0; i < length; ++i) {
            this.write_double(value[offset + i]);
        }
        this.handleSpecialChunkEnd();
    }

    @Override
    @CdrWrite
    public final void write_any_array(Any[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.write_any(value[offset + i]);
        }
    }

    @Override
    public void writeTo(OutputStream s) throws IOException {
        byte[] tmpBuf = ORBUtility.getByteBufferArray(this.byteBuffer);
        s.write(tmpBuf, 0, this.byteBuffer.position());
    }

    @Override
    public void writeOctetSequenceTo(org.omg.CORBA.portable.OutputStream s) {
        byte[] buf = ORBUtility.getByteBufferArray(this.byteBuffer);
        s.write_long(this.byteBuffer.position());
        s.write_octet_array(buf, 0, this.byteBuffer.position());
    }

    @Override
    public final int getSize() {
        return this.byteBuffer.position();
    }

    @Override
    public int getIndex() {
        return this.byteBuffer.position();
    }

    @Override
    public void setIndex(int value) {
        this.byteBuffer.position(value);
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    private void freeValueCache() {
        if (this.valueCache != null) {
            this.valueCache.done();
        }
    }

    private void updateIndirectionTable(int indirection, java.lang.Object key) {
        if (this.valueCache == null) {
            this.valueCache = new CacheTable("Output valueCache", this.orb, true);
        }
        this.valueCache.put(key, indirection);
    }

    private boolean writeIndirectionIfPossible(Serializable object) {
        int indir;
        if (this.valueCache != null && (indir = this.valueCache.getVal(object)) != -1) {
            this.writeIndirection(-1, indir);
            return true;
        }
        return false;
    }

    @CdrWrite
    private void write_repositoryId(String id) {
        int indir;
        if (this.repositoryIdCache != null && (indir = this.repositoryIdCache.getVal(id)) != -1) {
            this.writeIndirection(-1, indir);
            return;
        }
        int indirection = this.writeString(id);
        if (this.repositoryIdCache == null) {
            this.repositoryIdCache = new CacheTable("Output repositoryIdCache", this.orb, true);
        }
        this.repositoryIdCache.put(id, indirection);
    }

    @CdrWrite
    private void write_codebase(String str, int pos) {
        Integer value = null;
        if (this.codebaseCache != null) {
            value = this.codebaseCache.get(str);
        }
        if (value != null) {
            this.writeIndirection(-1, value);
        } else {
            this.write_string(str);
            if (this.codebaseCache == null) {
                this.codebaseCache = new HashMap<String, Integer>();
            }
            this.codebaseCache.put(str, pos);
        }
    }

    @CdrWrite
    private int writeValueTag(boolean chunkIt, boolean useRepId, String codebase) {
        int indirection;
        if (chunkIt && !useRepId) {
            if (codebase == null) {
                this.write_long(this.repIdUtil.getStandardRMIChunkedNoRepStrId());
                indirection = this.get_offset() - 4;
            } else {
                this.write_long(this.repIdUtil.getCodeBaseRMIChunkedNoRepStrId());
                indirection = this.get_offset() - 4;
                this.write_codebase(codebase, this.get_offset());
            }
        } else if (chunkIt && useRepId) {
            if (codebase == null) {
                this.write_long(this.repIdUtil.getStandardRMIChunkedId());
                indirection = this.get_offset() - 4;
            } else {
                this.write_long(this.repIdUtil.getCodeBaseRMIChunkedId());
                indirection = this.get_offset() - 4;
                this.write_codebase(codebase, this.get_offset());
            }
        } else if (!useRepId) {
            if (codebase == null) {
                this.write_long(this.repIdUtil.getStandardRMIUnchunkedNoRepStrId());
                indirection = this.get_offset() - 4;
            } else {
                this.write_long(this.repIdUtil.getCodeBaseRMIUnchunkedNoRepStrId());
                indirection = this.get_offset() - 4;
                this.write_codebase(codebase, this.get_offset());
            }
        } else if (codebase == null) {
            this.write_long(this.repIdUtil.getStandardRMIUnchunkedId());
            indirection = this.get_offset() - 4;
        } else {
            this.write_long(this.repIdUtil.getCodeBaseRMIUnchunkedId());
            indirection = this.get_offset() - 4;
            this.write_codebase(codebase, this.get_offset());
        }
        return indirection;
    }

    @CdrWrite
    private void writeIDLValue(Serializable object, String repID) {
        if (object instanceof StreamableValue) {
            ((StreamableValue)object)._write((org.omg.CORBA.portable.OutputStream)this.parent);
        } else if (object instanceof CustomValue) {
            ((CustomValue)object).marshal((DataOutputStream)this.parent);
        } else {
            BoxedValueHelper helper = Utility.getHelper(object.getClass(), null, repID);
            boolean isCustom = false;
            if (helper instanceof ValueHelper && object instanceof CustomMarshal) {
                try {
                    if (((ValueHelper)helper).get_type().type_modifier() == 1) {
                        isCustom = true;
                    }
                }
                catch (BadKind ex) {
                    throw wrapper.badTypecodeForCustomValue(ex);
                }
            }
            if (isCustom) {
                ((CustomMarshal)object).marshal((DataOutputStream)this.parent);
            } else {
                helper.write_value((org.omg.CORBA.portable.OutputStream)this.parent, object);
            }
        }
    }

    @CdrWrite
    private void writeEndTag(boolean chunked) {
        if (chunked) {
            if (this.get_offset() == this.end_flag_position && this.byteBuffer.position() == this.end_flag_index) {
                this.byteBuffer.position(this.byteBuffer.position() - 4);
            }
            this.writeNestingLevel();
            this.end_flag_index = this.byteBuffer.position();
            this.end_flag_position = this.get_offset();
            ++this.chunkedValueNestingLevel;
        }
        ++this.end_flag;
    }

    @CdrWrite
    private void writeNestingLevel() {
        if (this.orb == null || ORBVersionFactory.getFOREIGN().equals(this.orb.getORBVersion()) || ORBVersionFactory.getNEWER().compareTo(this.orb.getORBVersion()) <= 0) {
            this.write_long(this.chunkedValueNestingLevel);
        } else {
            this.write_long(this.end_flag);
        }
    }

    @CdrWrite
    private void writeClass(String repository_id, Class clz, ClassInfoCache.ClassInfo cinfo) {
        if (repository_id == null) {
            repository_id = this.repIdStrs.getClassDescValueRepId();
        }
        int indirection = this.writeValueTag(this.mustChunk, true, null);
        this.updateIndirectionTable(indirection, clz);
        this.write_repositoryId(repository_id);
        this.startValueChunk(this.mustChunk);
        this.writeClassBody(clz, cinfo);
        this.endValueChunk(this.mustChunk);
    }

    @CdrWrite
    private void writeClassBody(Class clz, ClassInfoCache.ClassInfo cinfo) {
        if (this.orb == null || ORBVersionFactory.getFOREIGN().equals(this.orb.getORBVersion()) || ORBVersionFactory.getNEWER().compareTo(this.orb.getORBVersion()) <= 0) {
            this.write_value((Serializable)((java.lang.Object)this.getCodebase(clz)));
            this.write_value((Serializable)((java.lang.Object)this.repIdStrs.createForAnyType(clz, cinfo)));
        } else {
            this.write_value((Serializable)((java.lang.Object)this.repIdStrs.createForAnyType(clz, cinfo)));
            this.write_value((Serializable)((java.lang.Object)this.getCodebase(clz)));
        }
    }

    @CdrWrite
    private void writeIDLEntity(IDLEntity object) {
        this.mustChunk = true;
        String repository_id = this.repIdStrs.createForJavaType((Serializable)object);
        final Class<?> clazz = object.getClass();
        String codebase = this.getCodebase(clazz);
        int indirection = this.writeValueTag(true, true, codebase);
        this.updateIndirectionTable(indirection, object);
        this.write_repositoryId(repository_id);
        this.startValueChunk(true);
        try {
            Method writeMethod;
            ClassLoader clazzLoader = clazz == null ? null : clazz.getClassLoader();
            final Class helperClass = Utility.loadClassForClass(clazz.getName() + "Helper", codebase, clazzLoader, clazz, clazzLoader);
            try {
                writeMethod = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                    @Override
                    public Method run() throws NoSuchMethodException {
                        return helperClass.getDeclaredMethod(CDROutputStream_1_0.kWriteMethod, org.omg.CORBA.portable.OutputStream.class, clazz);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (NoSuchMethodException)pae.getException();
            }
            writeMethod.invoke(null, this.parent, object);
        }
        catch (Exception exc) {
            throw wrapper.errorInvokingHelperWrite(exc);
        }
        this.endValueChunk(true);
    }

    @Override
    @CdrWrite
    public void write_Abstract(java.lang.Object value) {
        this.write_abstract_interface(value);
    }

    @Override
    @CdrWrite
    public void write_Value(Serializable value) {
        this.write_value(value);
    }

    @Override
    public void write_fixed(BigDecimal bigDecimal, short digits, short scale) {
        String fractionPart;
        String integerPart;
        int dotIndex;
        String string = bigDecimal.toString();
        if (string.charAt(0) == '-' || string.charAt(0) == '+') {
            string = string.substring(1);
        }
        if ((dotIndex = string.indexOf(46)) == -1) {
            integerPart = string;
            fractionPart = null;
        } else if (dotIndex == 0) {
            integerPart = null;
            fractionPart = string;
        } else {
            integerPart = string.substring(0, dotIndex);
            fractionPart = string.substring(dotIndex + 1);
        }
        StringBuilder stringBuffer = new StringBuilder(digits);
        if (fractionPart != null) {
            stringBuffer.append(fractionPart);
        }
        while (stringBuffer.length() < scale) {
            stringBuffer.append('0');
        }
        if (integerPart != null) {
            stringBuffer.insert(0, integerPart);
        }
        while (stringBuffer.length() < digits) {
            stringBuffer.insert(0, '0');
        }
        this.write_fixed(stringBuffer.toString(), bigDecimal.signum());
    }

    @Override
    public void write_fixed(BigDecimal bigDecimal) {
        this.write_fixed(bigDecimal.toString(), bigDecimal.signum());
    }

    public void write_fixed(String string, int signum) {
        char ch;
        int i;
        int stringLength = string.length();
        byte doubleDigit = 0;
        int numDigits = 0;
        for (i = 0; i < stringLength; ++i) {
            ch = string.charAt(i);
            if (ch == '-' || ch == '+' || ch == '.') continue;
            ++numDigits;
        }
        for (i = 0; i < stringLength; ++i) {
            ch = string.charAt(i);
            if (ch == '-' || ch == '+' || ch == '.') continue;
            byte digit = (byte)Character.digit(ch, 10);
            if (digit == -1) {
                throw wrapper.badDigitInFixed();
            }
            if (numDigits % 2 == 0) {
                doubleDigit = (byte)(doubleDigit | digit);
                this.write_octet(doubleDigit);
                doubleDigit = 0;
            } else {
                doubleDigit = (byte)(doubleDigit | digit << 4);
            }
            --numDigits;
        }
        doubleDigit = signum == -1 ? (byte)((byte)(doubleDigit | 0xD)) : (byte)((byte)(doubleDigit | 0xC));
        this.write_octet(doubleDigit);
    }

    @Override
    public String[] _truncatable_ids() {
        if (_ids == null) {
            return null;
        }
        return (String[])_ids.clone();
    }

    @Override
    public void writeIndirection(int tag, int posIndirectedTo) {
        this.handleSpecialChunkBegin(this.computeAlignment(4) + 8);
        this.write_long(tag);
        this.write_long(posIndirectedTo - this.parent.getRealIndex(this.get_offset()));
        this.handleSpecialChunkEnd();
    }

    protected CodeSetConversion.CTBConverter getCharConverter() {
        if (this.charConverter == null) {
            this.charConverter = this.parent.createCharCTBConverter();
        }
        return this.charConverter;
    }

    protected CodeSetConversion.CTBConverter getWCharConverter() {
        if (this.wcharConverter == null) {
            this.wcharConverter = this.parent.createWCharCTBConverter();
        }
        return this.wcharConverter;
    }

    @Override
    void alignOnBoundary(int octetBoundary) {
        this.alignAndReserve(octetBoundary, 0);
    }

    @InfoMethod
    private void startValueInfo(String repId, int offset, int position) {
    }

    @Override
    @CdrWrite
    public void start_value(String rep_id) {
        this.startValueInfo(rep_id, this.get_offset(), this.byteBuffer.position());
        if (this.inBlock) {
            this.end_block();
        }
        this.writeValueTag(true, true, null);
        this.write_repositoryId(rep_id);
        --this.end_flag;
        --this.chunkedValueNestingLevel;
        this.start_block();
    }

    @InfoMethod
    private void mustChunk(boolean flag) {
    }

    @Override
    @CdrWrite
    public void end_value() {
        this.end_block();
        this.writeEndTag(true);
        this.mustChunk(this.mustChunk);
        if (this.mustChunk) {
            this.start_block();
        }
    }

    @Override
    @CdrWrite
    public void close() throws IOException {
        this.getBufferManager().close();
        if (this.byteBuffer != null) {
            ByteBufferPool byteBufferPool = this.orb.getByteBufferPool();
            byteBufferPool.releaseByteBuffer(this.byteBuffer);
            this.byteBuffer = null;
        }
    }

    @Override
    void dereferenceBuffer() {
        this.byteBuffer = null;
    }
}

