/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class ConvertPropertyAssertionsToAnnotations
extends AbstractCompositeOntologyChange {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final Set<OWLOntology> ontologies;

    public ConvertPropertyAssertionsToAnnotations(@Nonnull OWLDataFactory dataFactory, @Nonnull Set<OWLOntology> ontologies) {
        super(dataFactory);
        this.ontologies = OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null");
        this.generateChanges();
    }

    @Nonnull
    private Collection<OWLNamedIndividual> getPunnedIndividuals(@Nonnull Collection<OWLNamedIndividual> individuals) {
        ArrayList<OWLNamedIndividual> punned = new ArrayList<OWLNamedIndividual>();
        for (OWLNamedIndividual ind : individuals) {
            for (OWLOntology ont : this.ontologies) {
                if (!ont.containsClassInSignature(ind.getIRI(), Imports.EXCLUDED)) continue;
                punned.add(ind);
            }
        }
        return punned;
    }

    private void generateChanges() {
        Collection<OWLNamedIndividual> individuals = this.getPunnedIndividuals(this.collectIndividuals());
        HashSet<OWLDataProperty> convertedDataProperties = new HashSet<OWLDataProperty>();
        for (OWLNamedIndividual ind : individuals) {
            assert (ind != null);
            this.convertDataAssertionsToAnnotations(convertedDataProperties, ind);
            this.removeDeclarationsAndClassAssertions(ind);
        }
        for (OWLDataProperty prop : convertedDataProperties) {
            assert (prop != null);
            this.removeDeclarationsAndAxioms(prop);
        }
    }

    private void removeDeclarationsAndAxioms(@Nonnull OWLDataProperty prop) {
        for (OWLOntology ont : this.ontologies) {
            assert (ont != null);
            for (OWLAxiom oWLAxiom : ont.getDeclarationAxioms(prop)) {
                assert (oWLAxiom != null);
                this.addChange(new RemoveAxiom(ont, oWLAxiom));
            }
            for (OWLAxiom oWLAxiom : ont.getAxioms(prop, Imports.EXCLUDED)) {
                assert (oWLAxiom != null);
                this.addChange(new RemoveAxiom(ont, oWLAxiom));
            }
        }
    }

    private void removeDeclarationsAndClassAssertions(@Nonnull OWLNamedIndividual ind) {
        for (OWLOntology ont : this.ontologies) {
            assert (ont != null);
            for (OWLAxiom oWLAxiom : ont.getDeclarationAxioms(ind)) {
                assert (oWLAxiom != null);
                this.addChange(new RemoveAxiom(ont, oWLAxiom));
            }
            for (OWLClassAssertionAxiom oWLClassAssertionAxiom : ont.getClassAssertionAxioms(ind)) {
                assert (oWLClassAssertionAxiom != null);
                this.addChange(new RemoveAxiom(ont, oWLClassAssertionAxiom));
            }
        }
    }

    private void convertDataAssertionsToAnnotations(@Nonnull Set<OWLDataProperty> convertedDataProperties, @Nonnull OWLNamedIndividual ind) {
        for (OWLOntology ont : this.ontologies) {
            assert (ont != null);
            for (OWLDataPropertyAssertionAxiom ax : ont.getDataPropertyAssertionAxioms(ind)) {
                if (((OWLDataPropertyExpression)ax.getProperty()).isAnonymous()) continue;
                this.addChange(new RemoveAxiom(ont, ax));
                this.addChange(new AddAxiom(ont, this.convertToAnnotation(ind, ax)));
                convertedDataProperties.add((OWLDataProperty)ax.getProperty());
            }
        }
    }

    @Nonnull
    private OWLAnnotationAssertionAxiom convertToAnnotation(@Nonnull OWLNamedIndividual ind, @Nonnull OWLDataPropertyAssertionAxiom ax) {
        OWLDataFactory df = this.getDataFactory();
        OWLAnnotation anno = df.getOWLAnnotation(df.getOWLAnnotationProperty(((OWLDataPropertyExpression)ax.getProperty()).asOWLDataProperty().getIRI()), (OWLAnnotationValue)ax.getObject());
        return df.getOWLAnnotationAssertionAxiom(ind.getIRI(), anno);
    }

    @Nonnull
    private Set<OWLNamedIndividual> collectIndividuals() {
        HashSet<OWLNamedIndividual> individuals = new HashSet<OWLNamedIndividual>();
        for (OWLOntology ont : this.ontologies) {
            individuals.addAll(ont.getIndividualsInSignature());
        }
        return individuals;
    }
}

